/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import org.immutant.core.as.CoreServices;
import org.immutant.messaging.MessageProcessorGroup;
import org.immutant.messaging.as.MessagingServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.core.ServiceSynchronizationManager;
import org.projectodd.polyglot.messaging.destinations.DestinationUtils;

public class MessageProcessorGroupizer
extends AtRuntimeInstaller<MessageProcessorGroupizer> {
    protected Map<String, List<ServiceName>> installedGroups = new HashMap<String, List<ServiceName>>();

    public MessageProcessorGroupizer(DeploymentUnit unit) {
        super(unit);
    }

    public MessageProcessorGroup createGroup(final String destinationName, final boolean singleton, int concurrency, boolean durable, String handlerName, Connection connection, Object setupHandler) {
        final ServiceName pointerDestName = DestinationUtils.destinationPointerName((DeploymentUnit)this.getUnit(), (String)destinationName);
        ServiceController pointerDest = this.getUnit().getServiceRegistry().getService(pointerDestName);
        if (pointerDest == null || !this.inValidState(pointerDest.getState())) {
            throw new IllegalStateException(destinationName + " is not available. Did you call immutant.messaging/start?");
        }
        String name = destinationName + "." + URLEncoder.encode(handlerName);
        final ServiceName serviceName = MessagingServices.messageProcessor(this.getUnit(), name);
        final MessageProcessorGroup group = new MessageProcessorGroup(this.getUnit().getServiceRegistry(), serviceName, destinationName, connection, setupHandler);
        group.setConcurrency(concurrency);
        group.setDurable(durable);
        group.setName(name);
        this.rememberGroup(destinationName, serviceName);
        ServiceSynchronizationManager.INSTANCE.addService(serviceName, (Service)group, true);
        this.replaceService(serviceName, new Runnable(){

            @Override
            public void run() {
                ServiceBuilder builder = MessageProcessorGroupizer.this.build(serviceName, (Service)group, singleton);
                ServiceName javaContext = ContextNames.JAVA_CONTEXT_SERVICE_NAME;
                builder.addDependency(CoreServices.runtime((DeploymentUnit)MessageProcessorGroupizer.this.getUnit()), group.getClojureRuntimeInjector()).addListener((ServiceListener)ServiceSynchronizationManager.INSTANCE).addDependency(pointerDestName).addDependency(javaContext.append(new String[]{"ConnectionFactory"}), group.getConnectionFactoryInjector()).addDependency(javaContext.append(DestinationUtils.getServiceName((String)destinationName)), group.getDestinationInjector()).install();
            }
        });
        this.installMBean(serviceName, "immutant.messaging", group);
        return group;
    }

    public void removeGroupsFor(String destinationName) {
        List<ServiceName> groups = this.installedGroupsFor(destinationName);
        if (groups != null) {
            for (ServiceName each : groups) {
                ServiceController service = this.getUnit().getServiceRegistry().getService(each);
                if (service == null) continue;
                ((MessageProcessorGroup)service.getValue()).remove();
            }
            this.installedGroups.remove(destinationName);
        }
    }

    public List<ServiceName> installedGroupsFor(String destinationName) {
        return this.installedGroups.get(destinationName);
    }

    protected boolean inValidState(ServiceController.State state) {
        return state == ServiceController.State.STARTING || state == ServiceController.State.UP;
    }

    protected void rememberGroup(String destinationName, ServiceName serviceName) {
        List<ServiceName> groups = this.installedGroups.get(destinationName);
        if (groups == null) {
            groups = new ArrayList<ServiceName>();
            this.installedGroups.put(destinationName, groups);
        }
        groups.add(serviceName);
    }
}

