/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import java.util.HashMap;
import java.util.Map;
import org.immutant.core.HasImmutantRuntimeInjector;
import org.immutant.messaging.MessageProcessorGroupizer;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.core.ServiceSynchronizationManager;
import org.projectodd.polyglot.messaging.destinations.DestinationUtils;
import org.projectodd.polyglot.messaging.destinations.Destroyable;
import org.projectodd.polyglot.messaging.destinations.processors.QueueInstaller;
import org.projectodd.polyglot.messaging.destinations.processors.TopicInstaller;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class Destinationizer
extends AtRuntimeInstaller<Destinationizer>
implements HasImmutantRuntimeInjector {
    private final InjectedValue<ClojureRuntimeShim> clojureRuntimeInjector = new InjectedValue();
    private final InjectedValue<MessageProcessorGroupizer> messageProcessorGroupizerInjector = new InjectedValue();
    private Map<String, ServiceName> destinations = new HashMap<String, ServiceName>();
    static final Logger log = Logger.getLogger((String)"org.immutant.messaging");

    public Destinationizer(DeploymentUnit unit, ServiceTarget globalServiceTarget) {
        super(unit, globalServiceTarget);
    }

    public boolean createQueue(String queueName, boolean durable, String selector) {
        if (DestinationUtils.destinationPointerExists((DeploymentUnit)this.getUnit(), (String)queueName)) {
            return false;
        }
        this.destinations.put(queueName, QueueInstaller.deploySync((DeploymentUnit)this.getUnit(), (ServiceTarget)this.getTarget(), (ServiceTarget)this.getGlobalTarget(), (String)queueName, (String)selector, (boolean)durable, (boolean)false));
        return true;
    }

    public boolean createTopic(String topicName) {
        if (DestinationUtils.destinationPointerExists((DeploymentUnit)this.getUnit(), (String)topicName)) {
            return false;
        }
        this.destinations.put(topicName, TopicInstaller.deploySync((DeploymentUnit)this.getUnit(), (ServiceTarget)this.getTarget(), (ServiceTarget)this.getGlobalTarget(), (String)topicName, (boolean)false));
        return true;
    }

    public synchronized boolean destroyDestination(String name) {
        boolean success = false;
        ((MessageProcessorGroupizer)((Object)this.messageProcessorGroupizerInjector.getValue())).removeGroupsFor(name);
        ServiceName serviceName = this.destinations.get(name);
        if (serviceName != null) {
            ServiceRegistry registry = this.getUnit().getServiceRegistry();
            ServiceController dest = registry.getService(serviceName);
            if (dest != null) {
                ServiceName globalName = QueueInstaller.queueServiceName((String)name);
                ServiceController globalDest = registry.getService(globalName);
                if (globalDest == null) {
                    globalName = TopicInstaller.topicServiceName((String)name);
                    globalDest = registry.getService(globalName);
                }
                if (globalDest == null) {
                    throw new IllegalStateException("Failed to find global dest for " + name);
                }
                Service service = globalDest.getService();
                if (service instanceof Destroyable) {
                    ((Destroyable)service).setShouldDestroy(true);
                }
                dest.setMode(ServiceController.Mode.REMOVE);
                ServiceSynchronizationManager mgr = ServiceSynchronizationManager.INSTANCE;
                if (!mgr.waitForServiceRemove(serviceName, DestinationUtils.destinationWaitTimeout())) {
                    log.warn((Object)("Timed out waiting for " + name + " pointer to stop."));
                }
                if (mgr.hasService(globalName) && !mgr.hasDependents(globalName) && !mgr.waitForServiceDown(globalName, DestinationUtils.destinationWaitTimeout())) {
                    log.warn((Object)("Timed out waiting for " + name + " to stop."));
                }
                success = true;
            }
            this.destinations.remove(name);
        }
        return success;
    }

    public Injector<ClojureRuntimeShim> getClojureRuntimeInjector() {
        return this.clojureRuntimeInjector;
    }

    public Injector<MessageProcessorGroupizer> getMessageProcessorGroupizerInjector() {
        return this.messageProcessorGroupizerInjector;
    }

    public Map<String, ServiceName> getDestinations() {
        return this.destinations;
    }
}

