/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.immutant.runtime.ClojureRuntime;
import org.jboss.logging.Logger;
import org.projectodd.polyglot.web.servlet.HttpServletResponseCapture;

public class RingFilter
implements Filter {
    public static final String CLOJURE_RUNTIME = "clojure.runtime";
    private ClojureRuntime runtime;
    private String handlerName;
    private String subcontext;
    private static final Logger log = Logger.getLogger((String)"org.immutant.web.servlet");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.runtime = (ClojureRuntime)filterConfig.getServletContext().getAttribute(CLOJURE_RUNTIME);
        this.handlerName = filterConfig.getFilterName();
        this.subcontext = filterConfig.getInitParameter("sub-context");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ((request.getPathInfo() == null || request.getPathInfo().equals("/")) && !request.getRequestURI().endsWith("/")) {
            String redirectUri = request.getRequestURI() + "/";
            String queryString = request.getQueryString();
            if (queryString != null) {
                redirectUri = redirectUri + "?" + queryString;
            }
            redirectUri = response.encodeRedirectURL(redirectUri);
            response.sendRedirect(redirectUri);
            return;
        }
        HttpServletResponseCapture responseCapture = new HttpServletResponseCapture(response);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)responseCapture);
            if (!responseCapture.isError()) {
                return;
            }
            response.reset();
        }
        catch (ServletException e) {
            log.error((Object)"Error performing request", (Throwable)e);
        }
        this.doRing(request, response);
    }

    protected void doRing(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.runtime.invoke("immutant.web.ring/handle-request", (Object)this.handlerName, (Object)this.subcontext, (Object)request, (Object)response);
        }
        catch (Exception e) {
            log.error((Object)"Error invoking Ring filter", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

