/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.web.ring.processors;

import java.util.Collection;
import java.util.Collections;
import org.apache.catalina.Context;
import org.immutant.core.processors.RegisteringProcessor;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceName;

public class WebContextRegisteringProcessor
extends RegisteringProcessor {
    static String hostNameOfDeployment(WarMetaData metaData, String defaultHost) {
        String hostName;
        Collection<Object> hostNames = null;
        if (metaData.getMergedJBossWebMetaData() != null) {
            hostNames = metaData.getMergedJBossWebMetaData().getVirtualHosts();
        }
        if (hostNames == null || hostNames.isEmpty()) {
            hostNames = Collections.singleton(defaultHost);
        }
        if ((hostName = (String)hostNames.iterator().next()) == null) {
            throw WebMessages.MESSAGES.nullHostName();
        }
        return hostName;
    }

    static String pathNameOfDeployment(DeploymentUnit deploymentUnit, JBossWebMetaData metaData) {
        String pathName;
        if (metaData.getContextRoot() == null) {
            EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            pathName = description != null ? "/" + description.getModuleName() : "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
        } else {
            pathName = metaData.getContextRoot();
            if ("/".equals(pathName)) {
                pathName = "";
            } else if (pathName.length() > 0 && pathName.charAt(0) != '/') {
                pathName = "/" + pathName;
            }
        }
        return pathName;
    }

    public RegisteringProcessor.RegistryEntry registryEntry(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return null;
        }
        String hostName = WebContextRegisteringProcessor.hostNameOfDeployment(warMetaData, "default-host");
        String pathName = WebContextRegisteringProcessor.pathNameOfDeployment(unit, warMetaData.getMergedJBossWebMetaData());
        ServiceName serviceName = WebSubsystemServices.deploymentServiceName((String)hostName, (String)pathName);
        Context webContext = (Context)unit.getServiceRegistry().getService(serviceName).getValue();
        return new RegisteringProcessor.RegistryEntry((RegisteringProcessor)this, "web-context", (Object)webContext);
    }
}

