/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.web.as;

import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.connector.Connector;
import org.immutant.core.as.CoreServices;
import org.immutant.web.as.WebDependenciesProcessor;
import org.immutant.web.ring.processors.RingApplicationRecognizer;
import org.immutant.web.ring.processors.RingWebApplicationInstaller;
import org.immutant.web.ring.processors.WebContextRegisteringProcessor;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.projectodd.polyglot.web.WebConnectorConfigService;
import org.projectodd.polyglot.web.processors.VirtualHostInstaller;
import org.projectodd.polyglot.web.processors.WebApplicationDefaultsProcessor;

class WebSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final WebSubsystemAdd ADD_INSTANCE = new WebSubsystemAdd();
    static final Logger log = Logger.getLogger((String)"org.immutant.web.as");
    static final Pattern maxThreadsPattern = Pattern.compile("org\\.immutant\\.web\\.(.+)\\.maxThreads");

    WebSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                WebSubsystemAdd.this.addDeploymentProcessors(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
        try {
            this.addWebConnectorConfigServices(context, verificationHandler, newControllers);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e, null);
        }
    }

    protected void addDeploymentProcessors(DeploymentProcessorTarget processorTarget) {
        processorTarget.addDeploymentProcessor("immutant-web", Phase.PARSE, 0, (DeploymentUnitProcessor)new RingApplicationRecognizer());
        processorTarget.addDeploymentProcessor("immutant-web", Phase.PARSE, 60, (DeploymentUnitProcessor)new WebApplicationDefaultsProcessor());
        processorTarget.addDeploymentProcessor("immutant-web", Phase.PARSE, 70, (DeploymentUnitProcessor)new RingWebApplicationInstaller());
        processorTarget.addDeploymentProcessor("immutant-web", Phase.DEPENDENCIES, 1, (DeploymentUnitProcessor)new WebDependenciesProcessor());
        processorTarget.addDeploymentProcessor("immutant-web", Phase.INSTALL, 2100, (DeploymentUnitProcessor)new VirtualHostInstaller());
        processorTarget.addDeploymentProcessor("immutant-web", Phase.INSTALL, 7425, (DeploymentUnitProcessor)new WebContextRegisteringProcessor());
    }

    protected void addWebConnectorConfigServices(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws Exception {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Matcher matcher = maxThreadsPattern.matcher(key);
            if (!matcher.matches()) continue;
            String connectorName = matcher.group(1);
            int maxThreads = Integer.parseInt(System.getProperty(key));
            this.addWebConnectorConfigService(context, verificationHandler, newControllers, connectorName, maxThreads);
        }
    }

    protected void addWebConnectorConfigService(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String connectorName, int maxThreads) throws Exception {
        WebConnectorConfigService service = new WebConnectorConfigService();
        service.setMaxThreads(maxThreads);
        newControllers.add(context.getServiceTarget().addService(CoreServices.IMMUTANT.append(new String[]{"web"}).append(new String[]{connectorName}), (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{connectorName}), Connector.class, service.getConnectorInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }

    static ModelNode createOperation(ModelNode address) {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        return subsystem;
    }
}

