// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.regions.views');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('bluegenes.pages.regions.graphs');
goog.require('bluegenes.components.table');
goog.require('bluegenes.components.loader');
goog.require('bluegenes.pages.regions.events');
goog.require('bluegenes.pages.regions.subs');
goog.require('bluegenes.pages.regions.results');
goog.require('bluegenes.components.imcontrols.views');
goog.require('bluegenes.components.bootstrap');
goog.require('clojure.string');
goog.require('oops.core');
bluegenes.pages.regions.views.css_transition_group = reagent.core.adapt_react_class.call(null,React.addons.CSSTransitionGroup);
/**
 * Generate example region search input based on pre-configured per-mine settings
 */
bluegenes.pages.regions.views.ex = (function bluegenes$pages$regions$views$ex(){
var active_mine = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
var example_text = new cljs.core.Keyword(null,"regionsearch-example","regionsearch-example",-1896453489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,active_mine));
return clojure.string.join.call(null,"\n",clojure.string.split.call(null,example_text,/\\n/));
});
bluegenes.pages.regions.views.region_help_content_popover = ["Genome regions in the following formats are accepted:","\n - chromosome:start..end, e.g. 2L:11334..12296","\n - chromosome:start-end, e.g. 2R:5866746-5868284 or chrII:14646344-14667746","\n - tab delimited"].join('');
/**
 * Given an intermine model (or submodel), only keep classes that have data
 */
bluegenes.pages.regions.views.non_empty_classes = (function bluegenes$pages$regions$views$non_empty_classes(model){
return cljs.core.sort_by.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"displayName","displayName",-809144601),cljs.core.second),cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.pos_QMARK_,new cljs.core.Keyword(null,"count","count",2139924085),cljs.core.second),model));
});
/**
 * Recursively building a tree of user-selectable features as checkboxes
 */
bluegenes.pages.regions.views.feature_branch = (function bluegenes$pages$regions$views$feature_branch(){
var settings = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","settings","regions/settings",-1669063958)], null));
return ((function (settings){
return (function (p__24872){
var vec__24873 = p__24872;
var class_kw = cljs.core.nth.call(null,vec__24873,(0),null);
var map__24876 = cljs.core.nth.call(null,vec__24873,(1),null);
var map__24876__$1 = (((((!((map__24876 == null))))?(((((map__24876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24876):map__24876);
var n = map__24876__$1;
var displayName = cljs.core.get.call(null,map__24876__$1,new cljs.core.Keyword(null,"displayName","displayName",-809144601));
var descendants = cljs.core.get.call(null,map__24876__$1,new cljs.core.Keyword(null,"descendants","descendants",1824886031));
var count = cljs.core.get.call(null,map__24876__$1,new cljs.core.Keyword(null,"count","count",2139924085));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(class_kw.call(null,new cljs.core.Keyword(null,"feature-types","feature-types",1735602513).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,settings))))?"selected":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__24873,class_kw,map__24876,map__24876__$1,n,displayName,descendants,count,settings){
return (function (e){
e.stopPropagation();

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","toggle-feature-type","regions/toggle-feature-type",-1025581197),n], null));
});})(vec__24873,class_kw,map__24876,map__24876__$1,n,displayName,descendants,count,settings))
], null),(cljs.core.truth_(class_kw.call(null,new cljs.core.Keyword(null,"feature-types","feature-types",1735602513).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,settings))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkbox-checked","svg.icon.icon-checkbox-checked",889802540),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkbox-checked"], null)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkbox-unchecked","svg.icon.icon-checkbox-unchecked",-865275889),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkbox-unchecked"], null)], null)], null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(displayName),((cljs.core.empty_QMARK_.call(null,descendants))?null:cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.features-tree","ul.features-tree",-814846587)], null),cljs.core.map.call(null,((function (vec__24873,class_kw,map__24876,map__24876__$1,n,displayName,descendants,count,settings){
return (function (d){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.feature_branch,d], null);
});})(vec__24873,class_kw,map__24876,map__24876__$1,n,displayName,descendants,count,settings))
,bluegenes.pages.regions.views.non_empty_classes.call(null,descendants))))], null);
});
;})(settings))
});
bluegenes.pages.regions.views.feature_types_tree = (function bluegenes$pages$regions$views$feature_types_tree(){

var known_feature_types = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","sequence-feature-types","regions/sequence-feature-types",-1847169897)], null));
var settings = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","settings","regions/settings",-1669063958)], null));
return ((function (known_feature_types,settings){
return (function (){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.features-tree","ul.features-tree",-814846587)], null),cljs.core.map.call(null,((function (known_feature_types,settings){
return (function (f){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.feature_branch,f], null);
});})(known_feature_types,settings))
,bluegenes.pages.regions.views.non_empty_classes.call(null,cljs.core.deref.call(null,known_feature_types))));
});
;})(known_feature_types,settings))
});
/**
 * UI component allowing user to choose which organisms to search. Defaults to all.
 */
bluegenes.pages.regions.views.organism_selection = (function bluegenes$pages$regions$views$organism_selection(){
var settings = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","settings","regions/settings",-1669063958)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Organism"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.imcontrols.views.organism_dropdown,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"selected-value","selected-value",-81904500),(function (){var temp__5455__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,settings),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"organism","organism",-896952862),new cljs.core.Keyword(null,"shortName","shortName",-193714575)], null));
if(cljs.core.truth_(temp__5455__auto__)){
var sn = temp__5455__auto__;
return sn;
} else {
return "All Organisms";
}
})(),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (settings){
return (function (organism){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","set-selected-organism","regions/set-selected-organism",1344472043),organism], null));
});})(settings))
], null)], null)], null);
});
/**
 * UI component allowing user to type in the regions they wish to search for
 */
bluegenes.pages.regions.views.region_input_box = (function bluegenes$pages$regions$views$region_input_box(){
return reagent.core.create_class.call(null,(function (){var to_search = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","to-search","regions/to-search",-176499781)], null));
var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","results","regions/results",2099460098)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (to_search,results){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea.form-control","textarea.form-control",-1690362789),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"rows","rows",850049680),(cljs.core.truth_(cljs.core.deref.call(null,results))?(3):(6)),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"Type chromosome coords here, or click [Show me an example] above.",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref.call(null,to_search),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (to_search,results){
return (function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","set-to-search","regions/set-to-search",484922515),(function (){var target_obj_24878 = e;
var _STAR_runtime_state_STAR__orig_val__24881 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__24882 = oops.state.prepare_state.call(null,target_obj_24878,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__24882;

try{var next_obj_24879 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_24878,(0),"target",true))?(target_obj_24878["target"]):null);
var next_obj_24880 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_24879,(0),"value",true))?(next_obj_24879["value"]):null);
return next_obj_24880;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__24881;
}})()], null));
});})(to_search,results))
], null)], null);
});})(to_search,results))
,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (to_search,results){
return (function (this$){
return reagent.core.dom_node.call(null,this$).focus();
});})(to_search,results))
], null);
})());
});
bluegenes.pages.regions.views.clear_textbox = (function bluegenes$pages$regions$views$clear_textbox(){

var to_search = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","to-search","regions/to-search",-176499781)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.css_transition_group,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"transition-name","transition-name",91360299),"fade",new cljs.core.Keyword(null,"transition-enter-timeout","transition-enter-timeout",811383642),(2000),new cljs.core.Keyword(null,"transition-leave-timeout","transition-leave-timeout",165643286),(2000),new cljs.core.Keyword(null,"component","component",1555936782),"div"], null),(cljs.core.truth_(cljs.core.deref.call(null,to_search))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clear-textbox","div.clear-textbox",105926688),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (to_search){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","set-to-search","regions/set-to-search",484922515),null], null));
});})(to_search))
,new cljs.core.Keyword(null,"title","title",636505583),"Clear this textbox"], null),"\u2716"], null):null)], null);
});
bluegenes.pages.regions.views.region_input = (function bluegenes$pages$regions$views$region_input(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.region-input","div.region-input",-1693563918),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Regions to search ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.bootstrap.tooltip,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),bluegenes.pages.regions.views.region_help_content_popover], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-question","svg.icon.icon-question",479981139),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-question"], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.region-text","div.region-text",996783449),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.clear_textbox], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.region_input_box], null)], null)], null);
});
/**
 * UI component ot allow user to select which types of overlapping features to find
 */
bluegenes.pages.regions.views.checkboxes = (function bluegenes$pages$regions$views$checkboxes(to_search,settings){
var all_selected_QMARK_ = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","sequence-feature-type-all-selected?","regions/sequence-feature-type-all-selected?",1522872810)], null));
var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","results","regions/results",2099460098)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.checkboxes","div.checkboxes",-1301968572),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon","svg.icon",521947604),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"title","title",636505583),(cljs.core.truth_(cljs.core.deref.call(null,all_selected_QMARK_))?"Deselect all":"Select all"),new cljs.core.Keyword(null,"on-click","on-click",1632826543),(cljs.core.truth_(cljs.core.deref.call(null,all_selected_QMARK_))?((function (all_selected_QMARK_,results){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","deselect-all-feature-types","regions/deselect-all-feature-types",-891150593)], null));
});})(all_selected_QMARK_,results))
:((function (all_selected_QMARK_,results){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","select-all-feature-types","regions/select-all-feature-types",-282414240)], null));
});})(all_selected_QMARK_,results))
)], null),(cljs.core.truth_(cljs.core.deref.call(null,all_selected_QMARK_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkbox-checked","svg.icon.icon-checkbox-checked",889802540),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkbox-checked"], null)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkbox-unchecked","svg.icon.icon-checkbox-unchecked",-865275889),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkbox-unchecked"], null)], null)], null))], null),"Features to include"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.feature-tree-container","div.feature-tree-container",1600239356),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.deref.call(null,results))?"shrinkified":null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.feature_types_tree], null)], null)], null);
});
/**
 * Entire UI input section / top half of the region search
 */
bluegenes.pages.regions.views.input_section = (function bluegenes$pages$regions$views$input_section(){
var settings = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","settings","regions/settings",-1669063958)], null));
var to_search = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","to-search","regions/to-search",-176499781)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.row.input-section","div.row.input-section",-565410230),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.organism-and-regions","div.organism-and-regions",-15900515),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.region_input], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.organism_selection], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-primary.btn-raised.fattysubmitbutton","button.btn.btn-primary.btn-raised.fattysubmitbutton",1407857831),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),((cljs.core._EQ_.call(null,"",cljs.core.deref.call(null,to_search))) || (cljs.core._EQ_.call(null,null,cljs.core.deref.call(null,to_search))) || (cljs.core.empty_QMARK_.call(null,cljs.core.filter.call(null,((function (settings,to_search){
return (function (p__24887){
var vec__24888 = p__24887;
var name = cljs.core.nth.call(null,vec__24888,(0),null);
var enabled_QMARK_ = cljs.core.nth.call(null,vec__24888,(1),null);
return enabled_QMARK_;
});})(settings,to_search))
,new cljs.core.Keyword(null,"feature-types","feature-types",1735602513).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,settings)))))),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (settings,to_search){
return (function (e){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","run-query","regions/run-query",-757483589)], null));

var target_obj_24891 = (function (){var target_obj_24895 = e;
var _STAR_runtime_state_STAR__orig_val__24897 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__24898 = oops.state.prepare_state.call(null,target_obj_24895,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__24898;

try{var next_obj_24896 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_24895,(0),"target",true))?(target_obj_24895["target"]):null);
return next_obj_24896;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__24897;
}})();
var _STAR_runtime_state_STAR__orig_val__24899 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__24900 = oops.state.prepare_state.call(null,target_obj_24891,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__24900;

try{var call_info_24893 = [target_obj_24891,(function (){var next_obj_24894 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_24891,(0),"blur",true))?(target_obj_24891["blur"]):null);
return next_obj_24894;
})()];
var fn_24892 = (call_info_24893[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_24892,oops.state.get_last_access_modifier.call(null))){
if((!((fn_24892 == null)))){
return fn_24892.call((call_info_24893[(0)]));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__24899;
}});})(settings,to_search))
,new cljs.core.Keyword(null,"title","title",636505583),"Enter something into the 'Regions to search' box or click on [Show me an example], then click here! :)"], null),"Search"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.checkboxes,to_search,settings], null)], null);
});
bluegenes.pages.regions.views.main = (function bluegenes$pages$regions$views$main(){
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","select-all-feature-types","regions/select-all-feature-types",-282414240)], null));
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.container.regionsearch","div.container.regionsearch",-872908500),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.headerwithguidance","div.headerwithguidance",1585690166),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"Region Search"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.guidance","a.guidance",-2070386324),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","set-to-search","regions/set-to-search",484922515),bluegenes.pages.regions.views.ex.call(null)], null));
})], null),"[Show me an example]"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.views.input_section], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.results_section], null)], null);
})], null));
});

//# sourceMappingURL=views.js.map
