// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.events.auth');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('bluegenes.effects');
bluegenes.events.auth.error_messages = new cljs.core.PersistentArrayMap(null, 2, [(401),"Invalid username or password",(404),"Remote server not found"], null);
/**
 * Fire events to log in a user
 */
bluegenes.events.auth.login_fn = (function bluegenes$events$auth$login_fn(p__22757,p__22758){
var map__22759 = p__22757;
var map__22759__$1 = (((((!((map__22759 == null))))?(((((map__22759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22759):map__22759);
var db = cljs.core.get.call(null,map__22759__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22760 = p__22758;
var _ = cljs.core.nth.call(null,vec__22760,(0),null);
var map__22763 = cljs.core.nth.call(null,vec__22760,(1),null);
var map__22763__$1 = (((((!((map__22763 == null))))?(((((map__22763.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22763.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22763):map__22763);
var credentials = map__22763__$1;
var username = cljs.core.get.call(null,map__22763__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.call(null,map__22763__$1,new cljs.core.Keyword(null,"password","password",417022471));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),true,new cljs.core.Keyword(null,"error?","error?",-460689159),null),new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/auth/login",new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","login-success","bluegenes.events.auth/login-success",1069753972)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","login-failure","bluegenes.events.auth/login-failure",1273876314)], null),new cljs.core.Keyword(null,"on-unauthorised","on-unauthorised",-79914606),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","login-failure","bluegenes.events.auth/login-failure",1273876314)], null),new cljs.core.Keyword(null,"transit-params","transit-params",357261095),credentials], null)], null);
});
/**
 * Fire events to log out a user. This clears the Session on the server
 */
bluegenes.events.auth.logout_fn = (function bluegenes$events$auth$logout_fn(p__22766,p__22767){
var map__22768 = p__22766;
var map__22768__$1 = (((((!((map__22768 == null))))?(((((map__22768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22768.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22768):map__22768);
var db = cljs.core.get.call(null,map__22768__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22769 = p__22767;
var _ = cljs.core.nth.call(null,vec__22769,(0),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),true),new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/auth/logout",new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","logout-success","bluegenes.events.auth/logout-success",-2033887782)], null)], null)], null);
});
/**
 * Store a user's identity and assoc their token to the service of the current mine,
 *   then (re)fetch the user's lists and their MyMine labels
 *   ; TODO - factor out the subscribe
 */
bluegenes.events.auth.login_success_fn = (function bluegenes$events$auth$login_success_fn(p__22773,p__22774){
var map__22775 = p__22773;
var map__22775__$1 = (((((!((map__22775 == null))))?(((((map__22775.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22775.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22775):map__22775);
var db = cljs.core.get.call(null,map__22775__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22776 = p__22774;
var _ = cljs.core.nth.call(null,vec__22776,(0),null);
var map__22779 = cljs.core.nth.call(null,vec__22776,(1),null);
var map__22779__$1 = (((((!((map__22779 == null))))?(((((map__22779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22779):map__22779);
var identity = map__22779__$1;
var token = cljs.core.get.call(null,map__22779__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),false,new cljs.core.Keyword(null,"identity","identity",1647396035),identity,new cljs.core.Keyword(null,"message","message",-406056002),null,new cljs.core.Keyword(null,"error?","error?",-460689159),false),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)))),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"token","token",-1211463215)], null),token),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null)], null)], null);
});
/**
 * Clear a user's identity and store an error message
 */
bluegenes.events.auth.login_failure_fn = (function bluegenes$events$auth$login_failure_fn(db,p__22782){
var vec__22783 = p__22782;
var _ = cljs.core.nth.call(null,vec__22783,(0),null);
var map__22786 = cljs.core.nth.call(null,vec__22783,(1),null);
var map__22786__$1 = (((((!((map__22786 == null))))?(((((map__22786.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22786.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22786):map__22786);
var r = map__22786__$1;
var statusCode = cljs.core.get.call(null,map__22786__$1,new cljs.core.Keyword(null,"statusCode","statusCode",-34606052));
var msg = cljs.core.get.call(null,bluegenes.events.auth.error_messages,statusCode,"Error");
return cljs.core.update.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),false,new cljs.core.Keyword(null,"identity","identity",1647396035),null,new cljs.core.Keyword(null,"error?","error?",-460689159),true,new cljs.core.Keyword(null,"message","message",-406056002),msg);
});
/**
 * Clear the user's identity and reboot the application
 */
bluegenes.events.auth.logout_success_fn = (function bluegenes$events$auth$logout_success_fn(p__22788,p__22789){
var map__22790 = p__22788;
var map__22790__$1 = (((((!((map__22790 == null))))?(((((map__22790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22790):map__22790);
var db = cljs.core.get.call(null,map__22790__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22791 = p__22789;
var _ = cljs.core.nth.call(null,vec__22791,(0),null);
var response = cljs.core.nth.call(null,vec__22791,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),false,new cljs.core.Keyword(null,"identity","identity",1647396035),null,new cljs.core.Keyword(null,"error?","error?",-460689159),false,new cljs.core.Keyword(null,"message","message",-406056002),null),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"boot","boot",2007860585)], null)], null);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.events.auth","login","bluegenes.events.auth/login",78941178),bluegenes.events.auth.login_fn);
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.events.auth","login-success","bluegenes.events.auth/login-success",1069753972),bluegenes.events.auth.login_success_fn);
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.events.auth","login-failure","bluegenes.events.auth/login-failure",1273876314),bluegenes.events.auth.login_failure_fn);
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.events.auth","logout","bluegenes.events.auth/logout",1369412924),bluegenes.events.auth.logout_fn);
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.events.auth","logout-success","bluegenes.events.auth/logout-success",-2033887782),bluegenes.events.auth.logout_success_fn);

//# sourceMappingURL=auth.js.map
