// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.components.search.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('oops.core');
goog.require('bluegenes.db');
goog.require('imcljs.fetch');
goog.require('bluegenes.effects');
bluegenes.components.search.events.max_results = (99);
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","set-search-term","search/set-search-term",141679689),(function (db,p__22395){
var vec__22396 = p__22395;
var _ = cljs.core.nth.call(null,vec__22396,(0),null);
var search_term = cljs.core.nth.call(null,vec__22396,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"search-term","search-term",356193544),search_term);
}));
/**
 * Returns the index of a result item, such that going down at the bottom loops to the top and vice versa. Element -1 is 'show all'
 */
bluegenes.components.search.events.circular_index_finder = (function bluegenes$components$search$events$circular_index_finder(direction){
var result_index = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579)], null));
var results_count = cljs.core.count.call(null,cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"suggestion-results","suggestion-results",-2056023907)], null))));
var next_number = ((cljs.core._EQ_.call(null,direction,new cljs.core.Keyword(null,"next","next",-117701485)))?(cljs.core.deref.call(null,result_index) + (1)):(cljs.core.deref.call(null,result_index) - (1)));
var looped_number = (((next_number >= results_count))?(-1):(((next_number < (-1)))?(results_count - (1)):next_number
));
return looped_number;
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","move-selection","search/move-selection",434892888),(function (db,p__22399){
var vec__22400 = p__22399;
var _ = cljs.core.nth.call(null,vec__22400,(0),null);
var direction_to_move = cljs.core.nth.call(null,vec__22400,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579),bluegenes.components.search.events.circular_index_finder.call(null,direction_to_move));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","reset-selection","search/reset-selection",-1394717115),(function (db,p__22403){
var vec__22404 = p__22403;
var _ = cljs.core.nth.call(null,vec__22404,(0),null);
var direction_to_move = cljs.core.nth.call(null,vec__22404,(1),null);
return cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"quicksearch-selected-index","quicksearch-selected-index",532673579),(-1));
}));
bluegenes.components.search.events.sort_by_value = (function bluegenes$components$search$events$sort_by_value(result_map){

return cljs.core.into.call(null,cljs.core.sorted_map_by.call(null,(function (key1,key2){
return cljs.core.compare.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,result_map,key2),key2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,result_map,key1),key1], null));
})),result_map);
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","save-results","search/save-results",55557484),(function (db,p__22407){
var vec__22408 = p__22407;
var _ = cljs.core.nth.call(null,vec__22408,(0),null);
var map__22411 = cljs.core.nth.call(null,vec__22408,(1),null);
var map__22411__$1 = (((((!((map__22411 == null))))?(((((map__22411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22411):map__22411);
var response = map__22411__$1;
var results = cljs.core.get.call(null,map__22411__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
var facets = cljs.core.get.call(null,map__22411__$1,new cljs.core.Keyword(null,"facets","facets",-2061519464));
if((!((new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"search-results","search-results",306464634).cljs$core$IFn$_invoke$arity$1(db)) == null)))){
return cljs.core.update.call(null,db,new cljs.core.Keyword(null,"search-results","search-results",306464634),cljs.core.assoc,new cljs.core.Keyword(null,"results","results",-1134170113),results,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false);
} else {
return cljs.core.update.call(null,db,new cljs.core.Keyword(null,"search-results","search-results",306464634),cljs.core.assoc,new cljs.core.Keyword(null,"results","results",-1134170113),results,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false,new cljs.core.Keyword(null,"highlight-results","highlight-results",1638973719),new cljs.core.Keyword(null,"highlight-results","highlight-results",1638973719).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"search-results","search-results",306464634).cljs$core$IFn$_invoke$arity$1(db)),new cljs.core.Keyword(null,"facets","facets",-2061519464),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"organisms","organisms",-239799703),bluegenes.components.search.events.sort_by_value.call(null,new cljs.core.Keyword(null,"organism.shortName","organism.shortName",2068671074).cljs$core$IFn$_invoke$arity$1(facets)),new cljs.core.Keyword(null,"category","category",-593092832),bluegenes.components.search.events.sort_by_value.call(null,new cljs.core.Keyword(null,"Category","Category",-250769744).cljs$core$IFn$_invoke$arity$1(facets))], null));
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("search","full-search","search/full-search",-1157710074),(function (p__22413,p__22414){
var map__22415 = p__22413;
var map__22415__$1 = (((((!((map__22415 == null))))?(((((map__22415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22415.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22415):map__22415);
var db = cljs.core.get.call(null,map__22415__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22416 = p__22414;
var _ = cljs.core.nth.call(null,vec__22416,(0),null);
var search_term = cljs.core.nth.call(null,vec__22416,(1),null);
var active_filter = new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"search-results","search-results",306464634).cljs$core$IFn$_invoke$arity$1(db));
var connection = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),(function (){var G__22420 = cljs.core.update.call(null,cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"search-term","search-term",356193544),search_term),new cljs.core.Keyword(null,"search-results","search-results",306464634),cljs.core.assoc,new cljs.core.Keyword(null,"loading?","loading?",1905707049),true,new cljs.core.Keyword(null,"keyword","keyword",811389747),search_term);
if((!((active_filter == null)))){
return cljs.core.update.call(null,G__22420,new cljs.core.Keyword(null,"search-results","search-results",306464634),cljs.core.dissoc,new cljs.core.Keyword(null,"results","results",-1134170113));
} else {
return G__22420;
}
})(),new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.quicksearch.call(null,connection,search_term,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"facet_Category","facet_Category",-793302772),active_filter], null)),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","save-results","search/save-results",55557484)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.components.search.events","major-success","bluegenes.components.search.events/major-success",-136253423),(function (db,p__22421){
var vec__22422 = p__22421;
var _ = cljs.core.nth.call(null,vec__22422,(0),null);
var response = cljs.core.nth.call(null,vec__22422,(1),null);
console.log("response",response);

return db;
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","reset-quicksearch","search/reset-quicksearch",2072032411),(function (db){
return cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"suggestion-results","suggestion-results",-2056023907),null);
}));
bluegenes.components.search.events.is_active_result_QMARK_ = (function bluegenes$components$search$events$is_active_result_QMARK_(result,active_filter){

return ((cljs.core._EQ_.call(null,active_filter,(function (){var target_obj_22429 = result;
var _STAR_runtime_state_STAR__orig_val__22431 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__22432 = oops.state.prepare_state.call(null,target_obj_22429,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__22432;

try{var next_obj_22430 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_22429,(0),"type",true))?(target_obj_22429["type"]):null);
return next_obj_22430;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__22431;
}})())) || ((active_filter == null)));
});
bluegenes.components.search.events.count_current_results = (function bluegenes$components$search$events$count_current_results(results,filter){

return cljs.core.count.call(null,cljs.core.remove.call(null,(function (result){
return (!(bluegenes.components.search.events.is_active_result_QMARK_.call(null,result,filter)));
}),results));
});
re_frame.core.reg_fx.call(null,new cljs.core.Keyword(null,"load-more-results-if-needed","load-more-results-if-needed",1208374548),(function (p__22433){
var map__22434 = p__22433;
var map__22434__$1 = (((((!((map__22434 == null))))?(((((map__22434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22434.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22434):map__22434);
var results = cljs.core.get.call(null,map__22434__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
var active_filter = cljs.core.get.call(null,map__22434__$1,new cljs.core.Keyword(null,"active-filter","active-filter",845441376));
var facets = cljs.core.get.call(null,map__22434__$1,new cljs.core.Keyword(null,"facets","facets",-2061519464));
var keyword = cljs.core.get.call(null,map__22434__$1,new cljs.core.Keyword(null,"keyword","keyword",811389747));
var filtered_result_count = cljs.core.get.call(null,new cljs.core.Keyword(null,"category","category",-593092832).cljs$core$IFn$_invoke$arity$1(facets),active_filter);
var more_filtered_results_to_show_QMARK_ = (bluegenes.components.search.events.count_current_results.call(null,results,active_filter) < filtered_result_count);
var more_results_than_max_QMARK_ = (bluegenes.components.search.events.count_current_results.call(null,results,active_filter) <= bluegenes.components.search.events.max_results);
if(((more_filtered_results_to_show_QMARK_) && (more_results_than_max_QMARK_))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","full-search","search/full-search",-1157710074),keyword], null));
} else {
return null;
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("search","set-active-filter","search/set-active-filter",1406712076),(function (p__22436,p__22437){
var map__22438 = p__22436;
var map__22438__$1 = (((((!((map__22438 == null))))?(((((map__22438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22438.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22438):map__22438);
var db = cljs.core.get.call(null,map__22438__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22439 = p__22437;
var _ = cljs.core.nth.call(null,vec__22439,(0),null);
var filter = cljs.core.nth.call(null,vec__22439,(1),null);
var new_db = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-results","search-results",306464634),new cljs.core.Keyword(null,"active-filter","active-filter",845441376)], null),filter),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"selected-results","selected-results",1133098956)], null),cljs.core.PersistentHashSet.EMPTY);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),new_db,new cljs.core.Keyword(null,"load-more-results-if-needed","load-more-results-if-needed",1208374548),new cljs.core.Keyword(null,"search-results","search-results",306464634).cljs$core$IFn$_invoke$arity$1(new_db)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("search","remove-active-filter","search/remove-active-filter",-1215236709),(function (p__22443){
var map__22444 = p__22443;
var map__22444__$1 = (((((!((map__22444 == null))))?(((((map__22444.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22444.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22444):map__22444);
var db = cljs.core.get.call(null,map__22444__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"search-results","search-results",306464634),cljs.core.dissoc,new cljs.core.Keyword(null,"active-filter","active-filter",845441376)),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("search","full-search","search/full-search",-1157710074),new cljs.core.Keyword(null,"keyword","keyword",811389747).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"search-results","search-results",306464634).cljs$core$IFn$_invoke$arity$1(db))], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("search","to-results","search/to-results",822608175),(function (p__22446){
var map__22447 = p__22446;
var map__22447__$1 = (((((!((map__22447 == null))))?(((((map__22447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22447.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22447):map__22447);
var db = cljs.core.get.call(null,map__22447__$1,new cljs.core.Keyword(null,"db","db",993250759));
var object_type = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-results","search-results",306464634),new cljs.core.Keyword(null,"active-filter","active-filter",845441376)], null));
var ids = cljs.core.reduce.call(null,((function (object_type,map__22447,map__22447__$1,db){
return (function (result_ids,result){
return cljs.core.conj.call(null,result_ids,(function (){var target_obj_22449 = result;
var _STAR_runtime_state_STAR__orig_val__22451 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__22452 = oops.state.prepare_state.call(null,target_obj_22449,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__22452;

try{var next_obj_22450 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_22449,(0),"id",true))?(target_obj_22449["id"]):null);
return next_obj_22450;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__22451;
}})());
});})(object_type,map__22447,map__22447__$1,db))
,cljs.core.PersistentVector.EMPTY,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"selected-results","selected-results",1133098956)], null)));
var current_mine = new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db);
var summary_fields = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"summary-fields","summary-fields",-51287384),current_mine,cljs.core.keyword.call(null,object_type)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("results","history+","results/history+",-1489403964),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"source","source",-433931539),current_mine,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"title","title",636505583),"Search Results",new cljs.core.Keyword(null,"from","from",1815293044),object_type,new cljs.core.Keyword(null,"select","select",1147833503),summary_fields,new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(object_type),".id"].join(''),new cljs.core.Keyword(null,"op","op",-1882987955),"ONE OF",new cljs.core.Keyword(null,"values","values",372645556),ids], null)], null)], null)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","highlight-results","search/highlight-results",867062431),(function (db,p__22453){
var vec__22454 = p__22453;
var _ = cljs.core.nth.call(null,vec__22454,(0),null);
var highlight_QMARK_ = cljs.core.nth.call(null,vec__22454,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-results","search-results",306464634),new cljs.core.Keyword(null,"highlight-results","highlight-results",1638973719)], null),highlight_QMARK_);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","select-result","search/select-result",1394600496),(function (db,p__22457){
var vec__22458 = p__22457;
var _ = cljs.core.nth.call(null,vec__22458,(0),null);
var result = cljs.core.nth.call(null,vec__22458,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"selected-results","selected-results",1133098956)], null),cljs.core.conj,result);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("search","deselect-result","search/deselect-result",1920869558),(function (db,p__22461){
var vec__22462 = p__22461;
var _ = cljs.core.nth.call(null,vec__22462,(0),null);
var result = cljs.core.nth.call(null,vec__22462,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"selected-results","selected-results",1133098956)], null),cljs.core.disj,result);
}));

//# sourceMappingURL=events.js.map
