// Compiled by ClojureScript 1.10.520 {}
goog.provide('im_tables.views.dashboard.exporttable');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('oops.core');
goog.require('inflections.core');
goog.require('imcljs.path');
goog.require('im_tables.components.bootstrap');
/**
 * checks if certain formats are suitable for export given the data in the table
 *  Right now this is explicitly for FASTA, which requires a gene or protein.
 *  Returns either the list of acceptable formats as it was, or the same list
 *  with the new possible format appended to the end. 
 */
im_tables.views.dashboard.exporttable.check_if_good = (function im_tables$views$dashboard$exporttable$check_if_good(good_formats,model_parts,suitable_for,format){
var model_bits = cljs.core.set.call(null,cljs.core.keys.call(null,model_parts));
return cljs.core.distinct.call(null,cljs.core.reduce.call(null,((function (model_bits){
return (function (suitable_bit){
if(cljs.core.contains_QMARK_.call(null,model_bits,cljs.core.name.call(null,suitable_bit))){
return cljs.core.conj.call(null,good_formats,format);
} else {
return good_formats;
}
});})(model_bits))
,suitable_for));
});
/**
 * creates the dropdown to allow users to select their preferred format
 */
im_tables.views.dashboard.exporttable.modal_body = (function im_tables$views$dashboard$exporttable$modal_body(loc){
return (function (){
var settings = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("settings","settings","settings/settings",1867392726),loc], null));
var model_parts = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("main","query-parts","main/query-parts",1431310623),loc], null));
var export_formats = cljs.core.get_in.call(null,cljs.core.deref.call(null,settings),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"data-out","data-out",-1376977853),new cljs.core.Keyword(null,"accepted-formats","accepted-formats",-529263611)], null));
var valid_export_formats = cljs.core.reduce.call(null,((function (settings,model_parts,export_formats){
return (function (good_formats,p__16945){
var vec__16946 = p__16945;
var format = cljs.core.nth.call(null,vec__16946,(0),null);
var suitable_for = cljs.core.nth.call(null,vec__16946,(1),null);
if(cljs.core._EQ_.call(null,suitable_for,new cljs.core.Keyword(null,"all","all",892129742))){
return cljs.core.conj.call(null,good_formats,format);
} else {
return im_tables.views.dashboard.exporttable.check_if_good.call(null,good_formats,cljs.core.deref.call(null,model_parts),suitable_for,format);
}
});})(settings,model_parts,export_formats))
,cljs.core.PersistentVector.EMPTY,export_formats);
return cljs.core.reduce.call(null,((function (settings,model_parts,export_formats,valid_export_formats){
return (function (select,format){
return cljs.core.conj.call(null,select,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),cljs.core.name.call(null,format)], null));
});})(settings,model_parts,export_formats,valid_export_formats))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control","select.form-control",696610397),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (settings,model_parts,export_formats,valid_export_formats){
return (function (p1__16944_SHARP_){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","set-format","exporttable/set-format",467113794),loc,(function (){var target_obj_16949 = p1__16944_SHARP_;
var _STAR_runtime_state_STAR__orig_val__16952 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16953 = oops.state.prepare_state.call(null,target_obj_16949,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16953;

try{var next_obj_16950 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16949,(0),"target",true))?(target_obj_16949["target"]):null);
var next_obj_16951 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16950,(0),"value",true))?(next_obj_16950["value"]):null);
return next_obj_16951;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16952;
}})()], null));
});})(settings,model_parts,export_formats,valid_export_formats))
], null)], null),valid_export_formats);
});
});
/**
 * UI element. Presents the modal to allow user to select an export format.
 */
im_tables.views.dashboard.exporttable.export_menu = (function im_tables$views$dashboard$exporttable$export_menu(loc){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",119441134),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Export this table as...",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.close","a.close",-573589906),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("modal","close","modal/close",1402872795),loc], null));
})], null),"x"], null)], null),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.modal-body","div.modal-body",-2141892968),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Select a format",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.dashboard.exporttable.modal_body,loc], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"id","id",-1388402092),"hiddendownloadlink",new cljs.core.Keyword(null,"download","download",-300081668),"download"], null)], null)], null),new cljs.core.Keyword(null,"footer","footer",1606445390),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-primary","button.btn.btn-primary",510358192),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","download","exporttable/download",1768986514),loc], null));
})], null),"Download now!"], null)], null);
});
im_tables.views.dashboard.exporttable.exporttable = (function im_tables$views$dashboard$exporttable$exporttable(loc){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default","button.btn.btn-default",-991846011),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"on-click","on-click",1632826543),(function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"prep-modal","prep-modal",1727708280),loc,im_tables.views.dashboard.exporttable.export_menu.call(null,loc)], null));
})], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-download","i.fa.fa-download",-637194109)], null)," Export"], null);
});

//# sourceMappingURL=exporttable.js.map
