// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5658 = arguments.length;
var i__4731__auto___5659 = (0);
while(true){
if((i__4731__auto___5659 < len__4730__auto___5658)){
args__4736__auto__.push((arguments[i__4731__auto___5659]));

var G__5660 = (i__4731__auto___5659 + (1));
i__4731__auto___5659 = G__5660;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__5654){
var vec__5655 = p__5654;
var options = cljs.core.nth.call(null,vec__5655,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq5651){
var G__5652 = cljs.core.first.call(null,seq5651);
var seq5651__$1 = cljs.core.next.call(null,seq5651);
var G__5653 = cljs.core.first.call(null,seq5651__$1);
var seq5651__$2 = cljs.core.next.call(null,seq5651__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5652,G__5653,seq5651__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5668 = arguments.length;
var i__4731__auto___5669 = (0);
while(true){
if((i__4731__auto___5669 < len__4730__auto___5668)){
args__4736__auto__.push((arguments[i__4731__auto___5669]));

var G__5670 = (i__4731__auto___5669 + (1));
i__4731__auto___5669 = G__5670;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5664){
var vec__5665 = p__5664;
var options = cljs.core.nth.call(null,vec__5665,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq5661){
var G__5662 = cljs.core.first.call(null,seq5661);
var seq5661__$1 = cljs.core.next.call(null,seq5661);
var G__5663 = cljs.core.first.call(null,seq5661__$1);
var seq5661__$2 = cljs.core.next.call(null,seq5661__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5662,G__5663,seq5661__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5678 = arguments.length;
var i__4731__auto___5679 = (0);
while(true){
if((i__4731__auto___5679 < len__4730__auto___5678)){
args__4736__auto__.push((arguments[i__4731__auto___5679]));

var G__5680 = (i__4731__auto___5679 + (1));
i__4731__auto___5679 = G__5680;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5674){
var vec__5675 = p__5674;
var options = cljs.core.nth.call(null,vec__5675,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq5671){
var G__5672 = cljs.core.first.call(null,seq5671);
var seq5671__$1 = cljs.core.next.call(null,seq5671);
var G__5673 = cljs.core.first.call(null,seq5671__$1);
var seq5671__$2 = cljs.core.next.call(null,seq5671__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5672,G__5673,seq5671__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5688 = arguments.length;
var i__4731__auto___5689 = (0);
while(true){
if((i__4731__auto___5689 < len__4730__auto___5688)){
args__4736__auto__.push((arguments[i__4731__auto___5689]));

var G__5690 = (i__4731__auto___5689 + (1));
i__4731__auto___5689 = G__5690;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5684){
var vec__5685 = p__5684;
var options = cljs.core.nth.call(null,vec__5685,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq5681){
var G__5682 = cljs.core.first.call(null,seq5681);
var seq5681__$1 = cljs.core.next.call(null,seq5681);
var G__5683 = cljs.core.first.call(null,seq5681__$1);
var seq5681__$2 = cljs.core.next.call(null,seq5681__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5682,G__5683,seq5681__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5698 = arguments.length;
var i__4731__auto___5699 = (0);
while(true){
if((i__4731__auto___5699 < len__4730__auto___5698)){
args__4736__auto__.push((arguments[i__4731__auto___5699]));

var G__5700 = (i__4731__auto___5699 + (1));
i__4731__auto___5699 = G__5700;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5694){
var vec__5695 = p__5694;
var options = cljs.core.nth.call(null,vec__5695,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.records.cljs$lang$applyTo = (function (seq5691){
var G__5692 = cljs.core.first.call(null,seq5691);
var seq5691__$1 = cljs.core.next.call(null,seq5691);
var G__5693 = cljs.core.first.call(null,seq5691__$1);
var seq5691__$2 = cljs.core.next.call(null,seq5691__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5692,G__5693,seq5691__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5708 = arguments.length;
var i__4731__auto___5709 = (0);
while(true){
if((i__4731__auto___5709 < len__4730__auto___5708)){
args__4736__auto__.push((arguments[i__4731__auto___5709]));

var G__5710 = (i__4731__auto___5709 + (1));
i__4731__auto___5709 = G__5710;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5704){
var vec__5705 = p__5704;
var options = cljs.core.nth.call(null,vec__5705,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.rows.cljs$lang$applyTo = (function (seq5701){
var G__5702 = cljs.core.first.call(null,seq5701);
var seq5701__$1 = cljs.core.next.call(null,seq5701);
var G__5703 = cljs.core.first.call(null,seq5701__$1);
var seq5701__$2 = cljs.core.next.call(null,seq5701__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5702,G__5703,seq5701__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5718 = arguments.length;
var i__4731__auto___5719 = (0);
while(true){
if((i__4731__auto___5719 < len__4730__auto___5718)){
args__4736__auto__.push((arguments[i__4731__auto___5719]));

var G__5720 = (i__4731__auto___5719 + (1));
i__4731__auto___5719 = G__5720;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__5714){
var vec__5715 = p__5714;
var options = cljs.core.nth.call(null,vec__5715,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq5711){
var G__5712 = cljs.core.first.call(null,seq5711);
var seq5711__$1 = cljs.core.next.call(null,seq5711);
var G__5713 = cljs.core.first.call(null,seq5711__$1);
var seq5711__$2 = cljs.core.next.call(null,seq5711__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5712,G__5713,seq5711__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5728 = arguments.length;
var i__4731__auto___5729 = (0);
while(true){
if((i__4731__auto___5729 < len__4730__auto___5728)){
args__4736__auto__.push((arguments[i__4731__auto___5729]));

var G__5730 = (i__4731__auto___5729 + (1));
i__4731__auto___5729 = G__5730;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__5724){
var vec__5725 = p__5724;
var options = cljs.core.nth.call(null,vec__5725,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq5721){
var G__5722 = cljs.core.first.call(null,seq5721);
var seq5721__$1 = cljs.core.next.call(null,seq5721);
var G__5723 = cljs.core.first.call(null,seq5721__$1);
var seq5721__$2 = cljs.core.next.call(null,seq5721__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5722,G__5723,seq5721__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5809 = arguments.length;
var i__4731__auto___5810 = (0);
while(true){
if((i__4731__auto___5810 < len__4730__auto___5809)){
args__4736__auto__.push((arguments[i__4731__auto___5810]));

var G__5811 = (i__4731__auto___5810 + (1));
i__4731__auto___5810 = G__5811;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__5735){
var vec__5736 = p__5735;
var limit = cljs.core.nth.call(null,vec__5736,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var c__2429__auto___5812 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___5812,return_chan,vec__5736,limit){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___5812,return_chan,vec__5736,limit){
return (function (state_5786){
var state_val_5787 = (state_5786[(1)]);
if((state_val_5787 === (7))){
var state_5786__$1 = state_5786;
var statearr_5788_5813 = state_5786__$1;
(statearr_5788_5813[(2)] = false);

(statearr_5788_5813[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (1))){
var inst_5740 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_5741 = [path,(1),"jsonrows"];
var inst_5742 = cljs.core.PersistentHashMap.fromArrays(inst_5740,inst_5741);
var inst_5743 = imcljs.fetch.rows.call(null,service,query,inst_5742);
var state_5786__$1 = state_5786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5786__$1,(2),inst_5743);
} else {
if((state_val_5787 === (4))){
var state_5786__$1 = state_5786;
var statearr_5789_5814 = state_5786__$1;
(statearr_5789_5814[(2)] = false);

(statearr_5789_5814[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (15))){
var inst_5779 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
var statearr_5790_5815 = state_5786__$1;
(statearr_5790_5815[(2)] = inst_5779);

(statearr_5790_5815[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (13))){
var state_5786__$1 = state_5786;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5786__$1,(17),return_chan,false);
} else {
if((state_val_5787 === (6))){
var state_5786__$1 = state_5786;
var statearr_5791_5816 = state_5786__$1;
(statearr_5791_5816[(2)] = true);

(statearr_5791_5816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (17))){
var inst_5782 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
var statearr_5792_5817 = state_5786__$1;
(statearr_5792_5817[(2)] = inst_5782);

(statearr_5792_5817[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (3))){
var inst_5745 = (state_5786[(7)]);
var inst_5750 = inst_5745.cljs$lang$protocol_mask$partition0$;
var inst_5751 = (inst_5750 & (64));
var inst_5752 = inst_5745.cljs$core$ISeq$;
var inst_5753 = (cljs.core.PROTOCOL_SENTINEL === inst_5752);
var inst_5754 = ((inst_5751) || (inst_5753));
var state_5786__$1 = state_5786;
if(cljs.core.truth_(inst_5754)){
var statearr_5793_5818 = state_5786__$1;
(statearr_5793_5818[(1)] = (6));

} else {
var statearr_5794_5819 = state_5786__$1;
(statearr_5794_5819[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (12))){
var inst_5772 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_5773 = [path,limit,"jsonrows"];
var inst_5774 = cljs.core.PersistentHashMap.fromArrays(inst_5772,inst_5773);
var inst_5775 = imcljs.fetch.rows.call(null,service,query,inst_5774);
var state_5786__$1 = state_5786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5786__$1,(16),inst_5775);
} else {
if((state_val_5787 === (2))){
var inst_5745 = (state_5786[(7)]);
var inst_5745__$1 = (state_5786[(2)]);
var inst_5747 = (inst_5745__$1 == null);
var inst_5748 = cljs.core.not.call(null,inst_5747);
var state_5786__$1 = (function (){var statearr_5795 = state_5786;
(statearr_5795[(7)] = inst_5745__$1);

return statearr_5795;
})();
if(inst_5748){
var statearr_5796_5820 = state_5786__$1;
(statearr_5796_5820[(1)] = (3));

} else {
var statearr_5797_5821 = state_5786__$1;
(statearr_5797_5821[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (11))){
var inst_5766 = (state_5786[(2)]);
var inst_5767 = cljs.core.get.call(null,inst_5766,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_5768 = cljs.core.not.call(null,limit);
var inst_5769 = (inst_5767 <= limit);
var inst_5770 = ((inst_5768) || (inst_5769));
var state_5786__$1 = state_5786;
if(cljs.core.truth_(inst_5770)){
var statearr_5798_5822 = state_5786__$1;
(statearr_5798_5822[(1)] = (12));

} else {
var statearr_5799_5823 = state_5786__$1;
(statearr_5799_5823[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (9))){
var inst_5745 = (state_5786[(7)]);
var inst_5763 = cljs.core.apply.call(null,cljs.core.hash_map,inst_5745);
var state_5786__$1 = state_5786;
var statearr_5800_5824 = state_5786__$1;
(statearr_5800_5824[(2)] = inst_5763);

(statearr_5800_5824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (5))){
var inst_5761 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
if(cljs.core.truth_(inst_5761)){
var statearr_5801_5825 = state_5786__$1;
(statearr_5801_5825[(1)] = (9));

} else {
var statearr_5802_5826 = state_5786__$1;
(statearr_5802_5826[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (14))){
var inst_5784 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5786__$1,inst_5784);
} else {
if((state_val_5787 === (16))){
var inst_5777 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5786__$1,(15),return_chan,inst_5777);
} else {
if((state_val_5787 === (10))){
var inst_5745 = (state_5786[(7)]);
var state_5786__$1 = state_5786;
var statearr_5803_5827 = state_5786__$1;
(statearr_5803_5827[(2)] = inst_5745);

(statearr_5803_5827[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5787 === (8))){
var inst_5758 = (state_5786[(2)]);
var state_5786__$1 = state_5786;
var statearr_5804_5828 = state_5786__$1;
(statearr_5804_5828[(2)] = inst_5758);

(statearr_5804_5828[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___5812,return_chan,vec__5736,limit))
;
return ((function (switch__2334__auto__,c__2429__auto___5812,return_chan,vec__5736,limit){
return (function() {
var imcljs$fetch$state_machine__2335__auto__ = null;
var imcljs$fetch$state_machine__2335__auto____0 = (function (){
var statearr_5805 = [null,null,null,null,null,null,null,null];
(statearr_5805[(0)] = imcljs$fetch$state_machine__2335__auto__);

(statearr_5805[(1)] = (1));

return statearr_5805;
});
var imcljs$fetch$state_machine__2335__auto____1 = (function (state_5786){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_5786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e5806){if((e5806 instanceof Object)){
var ex__2338__auto__ = e5806;
var statearr_5807_5829 = state_5786;
(statearr_5807_5829[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5786);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5806;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5830 = state_5786;
state_5786 = G__5830;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
imcljs$fetch$state_machine__2335__auto__ = function(state_5786){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__2335__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__2335__auto____1.call(this,state_5786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__2335__auto____0;
imcljs$fetch$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__2335__auto____1;
return imcljs$fetch$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___5812,return_chan,vec__5736,limit))
})();
var state__2431__auto__ = (function (){var statearr_5808 = f__2430__auto__.call(null);
(statearr_5808[(6)] = c__2429__auto___5812);

return statearr_5808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___5812,return_chan,vec__5736,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq5731){
var G__5732 = cljs.core.first.call(null,seq5731);
var seq5731__$1 = cljs.core.next.call(null,seq5731);
var G__5733 = cljs.core.first.call(null,seq5731__$1);
var seq5731__$2 = cljs.core.next.call(null,seq5731__$1);
var G__5734 = cljs.core.first.call(null,seq5731__$2);
var seq5731__$3 = cljs.core.next.call(null,seq5731__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5732,G__5733,G__5734,seq5731__$3);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5837 = arguments.length;
var i__4731__auto___5838 = (0);
while(true){
if((i__4731__auto___5838 < len__4730__auto___5837)){
args__4736__auto__.push((arguments[i__4731__auto___5838]));

var G__5839 = (i__4731__auto___5838 + (1));
i__4731__auto___5838 = G__5839;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5833){
var vec__5834 = p__5833;
var options = cljs.core.nth.call(null,vec__5834,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists.cljs$lang$applyTo = (function (seq5831){
var G__5832 = cljs.core.first.call(null,seq5831);
var seq5831__$1 = cljs.core.next.call(null,seq5831);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5832,seq5831__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5847 = arguments.length;
var i__4731__auto___5848 = (0);
while(true){
if((i__4731__auto___5848 < len__4730__auto___5847)){
args__4736__auto__.push((arguments[i__4731__auto___5848]));

var G__5849 = (i__4731__auto___5848 + (1));
i__4731__auto___5848 = G__5849;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__5843){
var vec__5844 = p__5843;
var options = cljs.core.nth.call(null,vec__5844,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq5840){
var G__5841 = cljs.core.first.call(null,seq5840);
var seq5840__$1 = cljs.core.next.call(null,seq5840);
var G__5842 = cljs.core.first.call(null,seq5840__$1);
var seq5840__$2 = cljs.core.next.call(null,seq5840__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5841,G__5842,seq5840__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5856 = arguments.length;
var i__4731__auto___5857 = (0);
while(true){
if((i__4731__auto___5857 < len__4730__auto___5856)){
args__4736__auto__.push((arguments[i__4731__auto___5857]));

var G__5858 = (i__4731__auto___5857 + (1));
i__4731__auto___5857 = G__5858;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5852){
var vec__5853 = p__5852;
var options = cljs.core.nth.call(null,vec__5853,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.model.cljs$lang$applyTo = (function (seq5850){
var G__5851 = cljs.core.first.call(null,seq5850);
var seq5850__$1 = cljs.core.next.call(null,seq5850);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5851,seq5850__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5865 = arguments.length;
var i__4731__auto___5866 = (0);
while(true){
if((i__4731__auto___5866 < len__4730__auto___5865)){
args__4736__auto__.push((arguments[i__4731__auto___5866]));

var G__5867 = (i__4731__auto___5866 + (1));
i__4731__auto___5866 = G__5867;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5861){
var vec__5862 = p__5861;
var options = cljs.core.nth.call(null,vec__5862,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq5859){
var G__5860 = cljs.core.first.call(null,seq5859);
var seq5859__$1 = cljs.core.next.call(null,seq5859);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5860,seq5859__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5874 = arguments.length;
var i__4731__auto___5875 = (0);
while(true){
if((i__4731__auto___5875 < len__4730__auto___5874)){
args__4736__auto__.push((arguments[i__4731__auto___5875]));

var G__5876 = (i__4731__auto___5875 + (1));
i__4731__auto___5875 = G__5876;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5870){
var vec__5871 = p__5870;
var options = cljs.core.nth.call(null,vec__5871,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq5868){
var G__5869 = cljs.core.first.call(null,seq5868);
var seq5868__$1 = cljs.core.next.call(null,seq5868);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5869,seq5868__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5883 = arguments.length;
var i__4731__auto___5884 = (0);
while(true){
if((i__4731__auto___5884 < len__4730__auto___5883)){
args__4736__auto__.push((arguments[i__4731__auto___5884]));

var G__5885 = (i__4731__auto___5884 + (1));
i__4731__auto___5884 = G__5885;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5879){
var vec__5880 = p__5879;
var options = cljs.core.nth.call(null,vec__5880,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.templates.cljs$lang$applyTo = (function (seq5877){
var G__5878 = cljs.core.first.call(null,seq5877);
var seq5877__$1 = cljs.core.next.call(null,seq5877);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5878,seq5877__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5892 = arguments.length;
var i__4731__auto___5893 = (0);
while(true){
if((i__4731__auto___5893 < len__4730__auto___5892)){
args__4736__auto__.push((arguments[i__4731__auto___5893]));

var G__5894 = (i__4731__auto___5893 + (1));
i__4731__auto___5893 = G__5894;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5888){
var vec__5889 = p__5888;
var options = cljs.core.nth.call(null,vec__5889,(0),null);
var token_free_service = cljs.core.dissoc.call(null,service,new cljs.core.Keyword(null,"token","token",-1211463215));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",token_free_service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.session.cljs$lang$applyTo = (function (seq5886){
var G__5887 = cljs.core.first.call(null,seq5886);
var seq5886__$1 = cljs.core.next.call(null,seq5886);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5887,seq5886__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5901 = arguments.length;
var i__4731__auto___5902 = (0);
while(true){
if((i__4731__auto___5902 < len__4730__auto___5901)){
args__4736__auto__.push((arguments[i__4731__auto___5902]));

var G__5903 = (i__4731__auto___5902 + (1));
i__4731__auto___5902 = G__5903;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5897){
var vec__5898 = p__5897;
var options = cljs.core.nth.call(null,vec__5898,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq5895){
var G__5896 = cljs.core.first.call(null,seq5895);
var seq5895__$1 = cljs.core.next.call(null,seq5895);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5896,seq5895__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5910 = arguments.length;
var i__4731__auto___5911 = (0);
while(true){
if((i__4731__auto___5911 < len__4730__auto___5910)){
args__4736__auto__.push((arguments[i__4731__auto___5911]));

var G__5912 = (i__4731__auto___5911 + (1));
i__4731__auto___5911 = G__5912;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__5906){
var vec__5907 = p__5906;
var options = cljs.core.nth.call(null,vec__5907,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq5904){
var G__5905 = cljs.core.first.call(null,seq5904);
var seq5904__$1 = cljs.core.next.call(null,seq5904);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5905,seq5904__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/results"].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/status"].join(''),service);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__5913){
var map__5914 = p__5913;
var map__5914__$1 = (((((!((map__5914 == null))))?(((((map__5914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5914):map__5914);
var options = map__5914__$1;
var identifiers = cljs.core.get.call(null,map__5914__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__5914__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__5914__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__5914__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__5914__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__5916 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__5916__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__5916,new cljs.core.Keyword(null,"type","type",1174270348),type):G__5916);
var G__5916__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__5916__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__5916__$1);
var G__5916__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__5916__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__5916__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__5916__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__5916__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__5917){
var map__5918 = p__5917;
var map__5918__$1 = (((((!((map__5918 == null))))?(((((map__5918.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5918.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5918):map__5918);
var options = map__5918__$1;
var identifiers = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var timeout_ms = cljs.core.get.call(null,map__5918__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__2429__auto___6030 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_5988){
var state_val_5989 = (state_5988[(1)]);
if((state_val_5989 === (1))){
var inst_5920 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_5988__$1 = state_5988;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5988__$1,(2),inst_5920);
} else {
if((state_val_5989 === (2))){
var inst_5922 = (state_5988[(2)]);
var inst_5984 = cljs.core.async.chan.call(null,(1));
var inst_5985 = (function (){var job = inst_5922;
var c__2429__auto____$1 = inst_5984;
return ((function (job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_5982){
var state_val_5983 = (state_5982[(1)]);
if((state_val_5983 === (7))){
var inst_5945 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
if(cljs.core.truth_(inst_5945)){
var statearr_5990_6031 = state_5982__$1;
(statearr_5990_6031[(1)] = (11));

} else {
var statearr_5991_6032 = state_5982__$1;
(statearr_5991_6032[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (20))){
var state_5982__$1 = state_5982;
var statearr_5992_6033 = state_5982__$1;
(statearr_5992_6033[(2)] = timeout_ms);

(statearr_5992_6033[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (1))){
var inst_5923 = (100);
var state_5982__$1 = (function (){var statearr_5993 = state_5982;
(statearr_5993[(7)] = inst_5923);

return statearr_5993;
})();
var statearr_5994_6034 = state_5982__$1;
(statearr_5994_6034[(2)] = null);

(statearr_5994_6034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (24))){
var state_5982__$1 = state_5982;
var statearr_5995_6035 = state_5982__$1;
(statearr_5995_6035[(2)] = null);

(statearr_5995_6035[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (4))){
var inst_5929 = (state_5982[(8)]);
var inst_5929__$1 = (state_5982[(2)]);
var inst_5931 = (inst_5929__$1 == null);
var inst_5932 = cljs.core.not.call(null,inst_5931);
var state_5982__$1 = (function (){var statearr_5996 = state_5982;
(statearr_5996[(8)] = inst_5929__$1);

return statearr_5996;
})();
if(inst_5932){
var statearr_5997_6036 = state_5982__$1;
(statearr_5997_6036[(1)] = (5));

} else {
var statearr_5998_6037 = state_5982__$1;
(statearr_5998_6037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (15))){
var inst_5923 = (state_5982[(7)]);
var inst_5962 = cljs.core.async.timeout.call(null,inst_5923);
var state_5982__$1 = state_5982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5982__$1,(19),inst_5962);
} else {
if((state_val_5983 === (21))){
var state_5982__$1 = state_5982;
var statearr_5999_6038 = state_5982__$1;
(statearr_5999_6038[(2)] = (30000));

(statearr_5999_6038[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (13))){
var inst_5950 = (state_5982[(2)]);
var inst_5951 = cljs.core.get.call(null,inst_5950,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_5952 = cljs.core.get.call(null,inst_5950,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_5953 = cljs.core._EQ_.call(null,"SUCCESS",inst_5951);
var state_5982__$1 = (function (){var statearr_6000 = state_5982;
(statearr_6000[(9)] = inst_5952);

return statearr_6000;
})();
if(inst_5953){
var statearr_6001_6039 = state_5982__$1;
(statearr_6001_6039[(1)] = (14));

} else {
var statearr_6002_6040 = state_5982__$1;
(statearr_6002_6040[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (22))){
var inst_5923 = (state_5982[(7)]);
var inst_5968 = (state_5982[(2)]);
var inst_5969 = (inst_5923 < inst_5968);
var state_5982__$1 = state_5982;
if(cljs.core.truth_(inst_5969)){
var statearr_6003_6041 = state_5982__$1;
(statearr_6003_6041[(1)] = (23));

} else {
var statearr_6004_6042 = state_5982__$1;
(statearr_6004_6042[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (6))){
var state_5982__$1 = state_5982;
var statearr_6005_6043 = state_5982__$1;
(statearr_6005_6043[(2)] = false);

(statearr_6005_6043[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (25))){
var inst_5976 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
var statearr_6006_6044 = state_5982__$1;
(statearr_6006_6044[(2)] = inst_5976);

(statearr_6006_6044[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (17))){
var inst_5958 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5982__$1,(18),return_chan,inst_5958);
} else {
if((state_val_5983 === (3))){
var inst_5980 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5982__$1,inst_5980);
} else {
if((state_val_5983 === (12))){
var inst_5929 = (state_5982[(8)]);
var state_5982__$1 = state_5982;
var statearr_6007_6045 = state_5982__$1;
(statearr_6007_6045[(2)] = inst_5929);

(statearr_6007_6045[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (2))){
var inst_5926 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_5927 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_5926);
var state_5982__$1 = state_5982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5982__$1,(4),inst_5927);
} else {
if((state_val_5983 === (23))){
var inst_5923 = (state_5982[(7)]);
var inst_5971 = (inst_5923 * 1.5);
var inst_5972 = (((1000) < inst_5971) ? (1000) : inst_5971);
var inst_5923__$1 = inst_5972;
var state_5982__$1 = (function (){var statearr_6008 = state_5982;
(statearr_6008[(7)] = inst_5923__$1);

return statearr_6008;
})();
var statearr_6009_6046 = state_5982__$1;
(statearr_6009_6046[(2)] = null);

(statearr_6009_6046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (19))){
var inst_5964 = (state_5982[(2)]);
var state_5982__$1 = (function (){var statearr_6010 = state_5982;
(statearr_6010[(10)] = inst_5964);

return statearr_6010;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_6011_6047 = state_5982__$1;
(statearr_6011_6047[(1)] = (20));

} else {
var statearr_6012_6048 = state_5982__$1;
(statearr_6012_6048[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (11))){
var inst_5929 = (state_5982[(8)]);
var inst_5947 = cljs.core.apply.call(null,cljs.core.hash_map,inst_5929);
var state_5982__$1 = state_5982;
var statearr_6013_6049 = state_5982__$1;
(statearr_6013_6049[(2)] = inst_5947);

(statearr_6013_6049[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (9))){
var state_5982__$1 = state_5982;
var statearr_6014_6050 = state_5982__$1;
(statearr_6014_6050[(2)] = false);

(statearr_6014_6050[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (5))){
var inst_5929 = (state_5982[(8)]);
var inst_5934 = inst_5929.cljs$lang$protocol_mask$partition0$;
var inst_5935 = (inst_5934 & (64));
var inst_5936 = inst_5929.cljs$core$ISeq$;
var inst_5937 = (cljs.core.PROTOCOL_SENTINEL === inst_5936);
var inst_5938 = ((inst_5935) || (inst_5937));
var state_5982__$1 = state_5982;
if(cljs.core.truth_(inst_5938)){
var statearr_6015_6051 = state_5982__$1;
(statearr_6015_6051[(1)] = (8));

} else {
var statearr_6016_6052 = state_5982__$1;
(statearr_6016_6052[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (14))){
var inst_5955 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_5956 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_5955);
var state_5982__$1 = state_5982;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5982__$1,(17),inst_5956);
} else {
if((state_val_5983 === (16))){
var inst_5978 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
var statearr_6017_6053 = state_5982__$1;
(statearr_6017_6053[(2)] = inst_5978);

(statearr_6017_6053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (10))){
var inst_5942 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
var statearr_6018_6054 = state_5982__$1;
(statearr_6018_6054[(2)] = inst_5942);

(statearr_6018_6054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (18))){
var inst_5960 = (state_5982[(2)]);
var state_5982__$1 = state_5982;
var statearr_6019_6055 = state_5982__$1;
(statearr_6019_6055[(2)] = inst_5960);

(statearr_6019_6055[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5983 === (8))){
var state_5982__$1 = state_5982;
var statearr_6020_6056 = state_5982__$1;
(statearr_6020_6056[(2)] = true);

(statearr_6020_6056[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__2334__auto__,job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0 = (function (){
var statearr_6021 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_6021[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__);

(statearr_6021[(1)] = (1));

return statearr_6021;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1 = (function (state_5982){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_5982);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e6022){if((e6022 instanceof Object)){
var ex__2338__auto__ = e6022;
var statearr_6023_6057 = state_5982;
(statearr_6023_6057[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5982);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6022;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6058 = state_5982;
state_5982 = G__6058;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__ = function(state_5982){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1.call(this,state_5982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__2431__auto__ = (function (){var statearr_6024 = f__2430__auto__.call(null);
(statearr_6024[(6)] = c__2429__auto____$1);

return statearr_6024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});
;})(job,c__2429__auto____$1,inst_5922,inst_5984,state_val_5989,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var inst_5986 = cljs.core.async.impl.dispatch.run.call(null,inst_5985);
var state_5988__$1 = (function (){var statearr_6025 = state_5988;
(statearr_6025[(7)] = inst_5986);

return statearr_6025;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5988__$1,inst_5984);
} else {
return null;
}
}
});})(c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__2334__auto__,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0 = (function (){
var statearr_6026 = [null,null,null,null,null,null,null,null];
(statearr_6026[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__);

(statearr_6026[(1)] = (1));

return statearr_6026;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1 = (function (state_5988){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_5988);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e6027){if((e6027 instanceof Object)){
var ex__2338__auto__ = e6027;
var statearr_6028_6059 = state_5988;
(statearr_6028_6059[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5988);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6027;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6060 = state_5988;
state_5988 = G__6060;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__ = function(state_5988){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1.call(this,state_5988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__2431__auto__ = (function (){var statearr_6029 = f__2430__auto__.call(null);
(statearr_6029[(6)] = c__2429__auto___6030);

return statearr_6029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___6030,return_chan,map__5918,map__5918__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6070 = arguments.length;
var i__4731__auto___6071 = (0);
while(true){
if((i__4731__auto___6071 < len__4730__auto___6070)){
args__4736__auto__.push((arguments[i__4731__auto___6071]));

var G__6072 = (i__4731__auto___6071 + (1));
i__4731__auto___6071 = G__6072;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__6064){
var vec__6065 = p__6064;
var map__6068 = cljs.core.nth.call(null,vec__6065,(0),null);
var map__6068__$1 = (((((!((map__6068 == null))))?(((((map__6068.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6068.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6068):map__6068);
var options = map__6068__$1;
var lang = cljs.core.get.call(null,map__6068__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__6068__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.code.cljs$lang$applyTo = (function (seq6061){
var G__6062 = cljs.core.first.call(null,seq6061);
var seq6061__$1 = cljs.core.next.call(null,seq6061);
var G__6063 = cljs.core.first.call(null,seq6061__$1);
var seq6061__$2 = cljs.core.next.call(null,seq6061__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6062,G__6063,seq6061__$2);
});

/**
 * Returns list of InterMines from the InterMine registry. dev-mines? needs to
 * be set to true if you want to return non-prod mines, or otherwise set to false
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.get_plain.call(null,"http://registry.intermine.org/service/instances",(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false], null)));
});

//# sourceMappingURL=fetch.js.map
