// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.results.enrichment.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('imcljs.fetch');
goog.require('imcljs.path');
goog.require('imcljs.query');
goog.require('cljs.spec.alpha');
goog.require('clojure.set');
goog.require('bluegenes.effects');
goog.require('day8.re_frame.http_fx');
goog.require('ajax.core');
goog.require('bluegenes.interceptors');
goog.require('dommy.core');
goog.require('bluegenes.specs');
bluegenes.pages.results.enrichment.events.build_matches_query = (function bluegenes$pages$results$enrichment$events$build_matches_query(query,path_constraint,identifier){
return cljs.core.update_in.call(null,cljs.core.js__GT_clj.call(null,JSON.parse(query),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"where","where",-2044795965)], null),cljs.core.conj,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),path_constraint,new cljs.core.Keyword(null,"op","op",-1882987955),"ONE OF",new cljs.core.Keyword(null,"values","values",372645556),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [identifier], null)], null));
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","get-item-details","enrichment/get-item-details",-47707553),(function (p__22848,p__22849){
var map__22850 = p__22848;
var map__22850__$1 = (((((!((map__22850 == null))))?(((((map__22850.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22850.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22850):map__22850);
var db = cljs.core.get.call(null,map__22850__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22851 = p__22849;
var _ = cljs.core.nth.call(null,vec__22851,(0),null);
var identifier = cljs.core.nth.call(null,vec__22851,(1),null);
var path_constraint = cljs.core.nth.call(null,vec__22851,(2),null);
var source = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"package","package",1189062786),new cljs.core.Keyword(null,"source","source",-433931539)], null));
var model = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),source,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"model","model",331153215)], null));
var classname = cljs.core.keyword.call(null,imcljs.path.class$.call(null,model,path_constraint));
var summary_fields = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"summary-fields","summary-fields",-51287384),source,classname], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),source,new cljs.core.Keyword(null,"service","service",-1963054559)], null));
var summary_chan = imcljs.fetch.rows.call(null,service,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),cljs.core.name.call(null,classname),new cljs.core.Keyword(null,"select","select",1147833503),summary_fields,new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.last.call(null,clojure.string.split.call(null,path_constraint,".")),new cljs.core.Keyword(null,"op","op",-1882987955),"=",new cljs.core.Keyword(null,"value","value",305978217),identifier], null)], null)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"summary-chan","summary-chan",1338241537)], null),summary_chan),new cljs.core.Keyword(null,"get-summary-values","get-summary-values",-1376571579),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [identifier,summary_chan], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","set-text-filter","enrichment/set-text-filter",-2040271543),(function (p__22855,p__22856){
var map__22857 = p__22855;
var map__22857__$1 = (((((!((map__22857 == null))))?(((((map__22857.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22857.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22857):map__22857);
var db = cljs.core.get.call(null,map__22857__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22858 = p__22856;
var _ = cljs.core.nth.call(null,vec__22858,(0),null);
var value = cljs.core.nth.call(null,vec__22858,(1),null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"text-filter","text-filter",653270523)], null),value)], null);
}));
/**
 * Returns list of columns in the results view that have widgets available for enrichment.
 */
bluegenes.pages.results.enrichment.events.what_we_can_enrich = (function bluegenes$pages$results$enrichment$events$what_we_can_enrich(widgets,query_parts){
var possible_roots = cljs.core.set.call(null,cljs.core.keys.call(null,query_parts));
var possible_enrichments = cljs.core.reduce.call(null,((function (possible_roots){
return (function (x,y){
return cljs.core.conj.call(null,x,cljs.core.keyword.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"targets","targets",2014963406).cljs$core$IFn$_invoke$arity$1(y))));
});})(possible_roots))
,cljs.core.PersistentHashSet.EMPTY,widgets);
var enrichable_roots = clojure.set.intersection.call(null,possible_enrichments,possible_roots);
return cljs.core.select_keys.call(null,query_parts,enrichable_roots);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","update-active-enrichment-column","enrichment/update-active-enrichment-column",-1217456270),(function (p__22862,p__22863){
var map__22864 = p__22862;
var map__22864__$1 = (((((!((map__22864 == null))))?(((((map__22864.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22864.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22864):map__22864);
var db = cljs.core.get.call(null,map__22864__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22865 = p__22863;
var _ = cljs.core.nth.call(null,vec__22865,(0),null);
var new_enrichment_column = cljs.core.nth.call(null,vec__22865,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-enrichment-column","active-enrichment-column",-29456368)], null),new_enrichment_column),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113)], null),cljs.core.dissoc,new cljs.core.Keyword(null,"enrichment-results","enrichment-results",-1610770142)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-results-loading?","enrichment-results-loading?",-1156951643)], null),true),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("enrichment","enrich","enrichment/enrich",-933338086)], null)], null);
}));
/**
 * Returns whether or not the previously used enrichment column is within the list of existing column types.
 */
bluegenes.pages.results.enrichment.events.can_we_enrich_on_existing_preference_QMARK_ = (function bluegenes$pages$results$enrichment$events$can_we_enrich_on_existing_preference_QMARK_(enrichable,existing_enrichable){
var paths = cljs.core.reduce.call(null,(function (new$,x){
return cljs.core.conj.call(null,new$,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(x));
}),cljs.core.PersistentHashSet.EMPTY,cljs.core.flatten.call(null,cljs.core.vals.call(null,enrichable)));
return cljs.core.contains_QMARK_.call(null,paths,existing_enrichable);
});
/**
 * This is complex - we need to resolve which columns are of a suitable type to be enriched by a widget, and then select one. Where possible we try to always preserve the same column that the user was looking at in the previous enrichment, to ensure general consistency.
 */
bluegenes.pages.results.enrichment.events.resolve_what_to_enrich = (function bluegenes$pages$results$enrichment$events$resolve_what_to_enrich(db){
var query_parts = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"query-parts","query-parts",1443695462)], null));
var widgets = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"widgets","widgets",-159098978),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null));
var existing_enrichable_path = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-enrichment-column","active-enrichment-column",-29456368),new cljs.core.Keyword(null,"path","path",-188191168)], null));
var existing_type = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-enrichment-column","active-enrichment-column",-29456368),new cljs.core.Keyword(null,"type","type",1174270348)], null));
var enrichable = bluegenes.pages.results.enrichment.events.what_we_can_enrich.call(null,widgets,query_parts);
var use_existing_enrichable_QMARK_ = bluegenes.pages.results.enrichment.events.can_we_enrich_on_existing_preference_QMARK_.call(null,enrichable,existing_enrichable_path);
var enrichable_default = cljs.core.last.call(null,cljs.core.last.call(null,cljs.core.vals.call(null,enrichable)));
if(use_existing_enrichable_QMARK_){
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (query_parts,widgets,existing_enrichable_path,existing_type,enrichable,use_existing_enrichable_QMARK_,enrichable_default){
return (function (val){
return cljs.core._EQ_.call(null,existing_enrichable_path,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(val));
});})(query_parts,widgets,existing_enrichable_path,existing_type,enrichable,use_existing_enrichable_QMARK_,enrichable_default))
,existing_type.call(null,enrichable)));
} else {
return enrichable_default;
}
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","enrich","enrichment/enrich",-933338086),(function (p__22869,p__22870){
var map__22871 = p__22869;
var map__22871__$1 = (((((!((map__22871 == null))))?(((((map__22871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22871):map__22871);
var db = cljs.core.get.call(null,map__22871__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22872 = p__22870;
var _ = cljs.core.nth.call(null,vec__22872,(0),null);
var query_parts = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"query-parts","query-parts",1443695462)], null));
var widgets = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"widgets","widgets",-159098978),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null));
var enrichable = bluegenes.pages.results.enrichment.events.what_we_can_enrich.call(null,widgets,query_parts);
var what_to_enrich = bluegenes.pages.results.enrichment.events.resolve_what_to_enrich.call(null,db);
var can_enrich_QMARK_ = (cljs.core.count.call(null,enrichable) > (0));
var source_kw = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"package","package",1189062786),new cljs.core.Keyword(null,"source","source",-433931539)], null));
if(can_enrich_QMARK_){
var enrich_query = new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(what_to_enrich);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-enrichment-column","active-enrichment-column",-29456368)], null),what_to_enrich),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichable-columns","enrichable-columns",-1451534727)], null),enrichable),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fetch-ids-from-query","fetch-ids-from-query",661377367),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),source_kw,new cljs.core.Keyword(null,"service","service",-1963054559)], null)),enrich_query,what_to_enrich], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),db], null);
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","update-enrichment-setting","enrichment/update-enrichment-setting",-818204939),(function (p__22876,p__22877){
var map__22878 = p__22876;
var map__22878__$1 = (((((!((map__22878 == null))))?(((((map__22878.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22878.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22878):map__22878);
var db = cljs.core.get.call(null,map__22878__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22879 = p__22877;
var _ = cljs.core.nth.call(null,vec__22879,(0),null);
var setting = cljs.core.nth.call(null,vec__22879,(1),null);
var value = cljs.core.nth.call(null,vec__22879,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-settings","enrichment-settings",1498562878),setting], null),value),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("enrichment","run-all-enrichment-queries","enrichment/run-all-enrichment-queries",64505)], null)], null);
}));
/**
 * When the web service gives us a vector, we make it into a map for easy lookup
 */
bluegenes.pages.results.enrichment.events.widgets_to_map = (function bluegenes$pages$results$enrichment$events$widgets_to_map(widgets){
return cljs.core.reduce.call(null,(function (new_map,vals){
return cljs.core.assoc.call(null,new_map,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(vals)),vals);
}),cljs.core.PersistentArrayMap.EMPTY,widgets);
});
/**
 * We only want to load widgets that can be used on our datatypes
 */
bluegenes.pages.results.enrichment.events.get_suitable_widgets = (function bluegenes$pages$results$enrichment$events$get_suitable_widgets(array_widgets,classname){
var widgets = bluegenes.pages.results.enrichment.events.widgets_to_map.call(null,array_widgets);
if(cljs.core.truth_(classname)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (widgets){
return (function (p__22883){
var vec__22884 = p__22883;
var _ = cljs.core.nth.call(null,vec__22884,(0),null);
var widget = cljs.core.nth.call(null,vec__22884,(1),null);
return cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,new cljs.core.Keyword(null,"targets","targets",2014963406).cljs$core$IFn$_invoke$arity$1(widget)),cljs.core.name.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(classname)));
});})(widgets))
,widgets));
} else {
return widgets;
}
});
bluegenes.pages.results.enrichment.events.build_enrichment_query = (function bluegenes$pages$results$enrichment$events$build_enrichment_query(selection,widget_name,settings){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("enrichment","run","enrichment/run",-647940120),cljs.core.merge.call(null,selection,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"maxp","maxp",-1041949792),0.05,new cljs.core.Keyword(null,"widget","widget",-853968943),widget_name,new cljs.core.Keyword(null,"correction","correction",-1158421777),"Holm-Bonferroni"], null),settings)], null);
});
bluegenes.pages.results.enrichment.events.build_all_enrichment_queries = (function bluegenes$pages$results$enrichment$events$build_all_enrichment_queries(selection,suitable_widgets,settings){

return cljs.core.reduce.call(null,(function (new_vec,p__22887){
var vec__22888 = p__22887;
var _ = cljs.core.nth.call(null,vec__22888,(0),null);
var vals = cljs.core.nth.call(null,vec__22888,(1),null);
return cljs.core.conj.call(null,new_vec,bluegenes.pages.results.enrichment.events.build_enrichment_query.call(null,selection,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(vals),settings));
}),cljs.core.PersistentVector.EMPTY,suitable_widgets);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","run-all-enrichment-queries","enrichment/run-all-enrichment-queries",64505),(function (p__22891,p__22892){
var map__22893 = p__22891;
var map__22893__$1 = (((((!((map__22893 == null))))?(((((map__22893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22893):map__22893);
var db = cljs.core.get.call(null,map__22893__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22894 = p__22892;
var _ = cljs.core.nth.call(null,vec__22894,(0),null);
var selection = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ids","ids",-998535796),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"ids-to-enrich","ids-to-enrich",-247576102)], null))], null);
var settings = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-settings","enrichment-settings",1498562878)], null));
var widgets = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"widgets","widgets",-159098978),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null));
var enrichment_column = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-enrichment-column","active-enrichment-column",-29456368)], null));
var suitable_widgets = bluegenes.pages.results.enrichment.events.get_suitable_widgets.call(null,widgets,enrichment_column);
var queries = bluegenes.pages.results.enrichment.events.build_all_enrichment_queries.call(null,selection,suitable_widgets,settings);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"active-widgets","active-widgets",-1838640521)], null),suitable_widgets),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),queries], null);
}));
bluegenes.pages.results.enrichment.events.service = (function bluegenes$pages$results$enrichment$events$service(db,mine_kw){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_kw,new cljs.core.Keyword(null,"service","service",-1963054559)], null));
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("enrichment","run","enrichment/run",-647940120),(function (p__22898,p__22899){
var map__22900 = p__22898;
var map__22900__$1 = (((((!((map__22900 == null))))?(((((map__22900.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22900.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22900):map__22900);
var db = cljs.core.get.call(null,map__22900__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22901 = p__22899;
var _ = cljs.core.nth.call(null,vec__22901,(0),null);
var params = cljs.core.nth.call(null,vec__22901,(1),null);
var updated_params = (function (){var G__22905 = params;
if(cljs.core.contains_QMARK_.call(null,params,new cljs.core.Keyword(null,"ids","ids",-998535796))){
return cljs.core.update.call(null,G__22905,new cljs.core.Keyword(null,"ids","ids",-998535796),cljs.core.partial.call(null,clojure.string.join,","));
} else {
return G__22905;
}
})();
var enrichment_chan = imcljs.fetch.enrichment.call(null,bluegenes.pages.results.enrichment.events.service.call(null,db,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"package","package",1189062786),new cljs.core.Keyword(null,"source","source",-433931539)], null))),updated_params);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-results","enrichment-results",-1610770142),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"widget","widget",-853968943).cljs$core$IFn$_invoke$arity$1(updated_params))], null),null),new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),enrichment_chan,new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"enrichment","enrichment",-925265804),new cljs.core.Keyword(null,"widget","widget",-853968943).cljs$core$IFn$_invoke$arity$1(updated_params)], null),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("enrichment","handle-results","enrichment/handle-results",925287568),new cljs.core.Keyword(null,"widget","widget",-853968943).cljs$core$IFn$_invoke$arity$1(updated_params)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("enrichment","handle-results","enrichment/handle-results",925287568),(function (db,p__22906){
var vec__22907 = p__22906;
var _ = cljs.core.nth.call(null,vec__22907,(0),null);
var widget_name = cljs.core.nth.call(null,vec__22907,(1),null);
var results = cljs.core.nth.call(null,vec__22907,(2),null);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-results","enrichment-results",-1610770142),cljs.core.keyword.call(null,widget_name)], null),results),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"enrichment-results-loading","enrichment-results-loading",-6359841)], null),false);
}));

//# sourceMappingURL=events.js.map
