// Compiled by ClojureScript 1.10.520 {}
goog.provide('joshkh.undo');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('re_frame.db');
joshkh.undo.config = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"max-undos","max-undos",-911142923),(50),new cljs.core.Keyword(null,"harvest-fn","harvest-fn",9140059),cljs.core.deref,new cljs.core.Keyword(null,"post-reinstate-fn","post-reinstate-fn",-417777091),null,new cljs.core.Keyword(null,"reinstate-fn","reinstate-fn",1996128442),cljs.core.reset_BANG_], null));
/**
 * Set configuration parameters for library.
 * 
 *   Should be called on app startup.
 */
joshkh.undo.undo_config_BANG_ = (function joshkh$undo$undo_config_BANG_(new_config){
var temp__5455__auto__ = cljs.core.seq.call(null,clojure.set.difference.call(null,cljs.core.set.call(null,cljs.core.keys.call(null,new_config)),cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.deref.call(null,joshkh.undo.config)))));
if(temp__5455__auto__){
var unknown_keys = temp__5455__auto__;
return re_frame.core.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame-undo: undo-config! called within unknown keys: ",unknown_keys);
} else {
return cljs.core.swap_BANG_.call(null,joshkh.undo.config,cljs.core.merge,new_config);
}
});
joshkh.undo.max_undos = (function joshkh$undo$max_undos(){
return new cljs.core.Keyword(null,"max-undos","max-undos",-911142923).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config));
});
/**
 * A list of history states
 */
joshkh.undo.undo_list = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * A list of future states, caused by undoing
 */
joshkh.undo.redo_list = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Mirrors app-db
 */
joshkh.undo.app_explain = reagent.core.atom.call(null,"");
/**
 * Mirrors undo-list
 */
joshkh.undo.undo_explain_list = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Mirrors redo-list
 */
joshkh.undo.redo_explain_list = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
joshkh.undo.clear_undos_BANG_ = (function joshkh$undo$clear_undos_BANG_(){
cljs.core.reset_BANG_.call(null,joshkh.undo.undo_list,cljs.core.PersistentArrayMap.EMPTY);

return cljs.core.reset_BANG_.call(null,joshkh.undo.undo_explain_list,cljs.core.PersistentArrayMap.EMPTY);
});
joshkh.undo.clear_redos_BANG_ = (function joshkh$undo$clear_redos_BANG_(){
cljs.core.reset_BANG_.call(null,joshkh.undo.redo_list,cljs.core.PersistentArrayMap.EMPTY);

return cljs.core.reset_BANG_.call(null,joshkh.undo.redo_explain_list,cljs.core.PersistentArrayMap.EMPTY);
});
joshkh.undo.clear_history_BANG_ = (function joshkh$undo$clear_history_BANG_(){
joshkh.undo.clear_undos_BANG_.call(null);

joshkh.undo.clear_redos_BANG_.call(null);

return cljs.core.reset_BANG_.call(null,joshkh.undo.app_explain,"");
});
/**
 * Stores the value currently in app-db, so the user can later undo
 */
joshkh.undo.store_now_BANG_ = (function joshkh$undo$store_now_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___17894 = arguments.length;
var i__4731__auto___17895 = (0);
while(true){
if((i__4731__auto___17895 < len__4730__auto___17894)){
args__4736__auto__.push((arguments[i__4731__auto___17895]));

var G__17896 = (i__4731__auto___17895 + (1));
i__4731__auto___17895 = G__17896;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return joshkh.undo.store_now_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

joshkh.undo.store_now_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (explanation,p__17890){
var vec__17891 = p__17890;
var location = cljs.core.nth.call(null,vec__17891,(0),null);
joshkh.undo.clear_redos_BANG_.call(null);

cljs.core.swap_BANG_.call(null,joshkh.undo.undo_list,cljs.core.update_in,location,cljs.core.comp.call(null,((function (vec__17891,location){
return (function (p1__17886_SHARP_){
return cljs.core.conj.call(null,p1__17886_SHARP_,new cljs.core.Keyword(null,"harvest-fn","harvest-fn",9140059).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config)).call(null,re_frame.db.app_db,location));
});})(vec__17891,location))
,cljs.core.vec,cljs.core.partial.call(null,cljs.core.take_last,joshkh.undo.max_undos.call(null))));

cljs.core.swap_BANG_.call(null,joshkh.undo.undo_explain_list,cljs.core.update_in,location,cljs.core.comp.call(null,((function (vec__17891,location){
return (function (p1__17887_SHARP_){
return cljs.core.conj.call(null,p1__17887_SHARP_,explanation);
});})(vec__17891,location))
,cljs.core.vec,cljs.core.partial.call(null,cljs.core.take_last,joshkh.undo.max_undos.call(null))));

return cljs.core.reset_BANG_.call(null,joshkh.undo.app_explain,explanation);
});

joshkh.undo.store_now_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
joshkh.undo.store_now_BANG_.cljs$lang$applyTo = (function (seq17888){
var G__17889 = cljs.core.first.call(null,seq17888);
var seq17888__$1 = cljs.core.next.call(null,seq17888);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17889,seq17888__$1);
});

/**
 * Returns true if undos exist, false otherwise
 */
joshkh.undo.undos_QMARK_ = (function joshkh$undo$undos_QMARK_(location){
return cljs.core.seq.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,joshkh.undo.undo_list),location));
});
/**
 * Returns true if redos exist, false otherwise
 */
joshkh.undo.redos_QMARK_ = (function joshkh$undo$redos_QMARK_(location){
return cljs.core.seq.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,joshkh.undo.redo_list),location));
});
/**
 * Returns a vector of undo descriptions, perhaps empty
 */
joshkh.undo.undo_explanations = (function joshkh$undo$undo_explanations(location){
if(joshkh.undo.undos_QMARK_.call(null,location)){
var G__17897 = cljs.core.deref.call(null,joshkh.undo.undo_explain_list);
if((G__17897 == null)){
return null;
} else {
return cljs.core.get_in.call(null,G__17897,location);
}
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
re_frame.core.reg_sub_raw.call(null,new cljs.core.Keyword(null,"undos?","undos?",-1094259081),(function joshkh$undo$handler(_,p__17898){
var vec__17899 = p__17898;
var ___$1 = cljs.core.nth.call(null,vec__17899,(0),null);
var location = cljs.core.nth.call(null,vec__17899,(1),null);
return reagent.ratom.make_reaction.call(null,((function (vec__17899,___$1,location){
return (function (){
return joshkh.undo.undos_QMARK_.call(null,location);
});})(vec__17899,___$1,location))
);
}));
re_frame.core.reg_sub_raw.call(null,new cljs.core.Keyword(null,"redos?","redos?",1340247550),(function joshkh$undo$handler(_,p__17902){
var vec__17903 = p__17902;
var ___$1 = cljs.core.nth.call(null,vec__17903,(0),null);
var location = cljs.core.nth.call(null,vec__17903,(1),null);
return reagent.ratom.make_reaction.call(null,((function (vec__17903,___$1,location){
return (function (){
return joshkh.undo.redos_QMARK_.call(null,location);
});})(vec__17903,___$1,location))
);
}));
re_frame.core.reg_sub_raw.call(null,new cljs.core.Keyword(null,"undo-explanations","undo-explanations",942251259),(function joshkh$undo$handler(_,p__17906){
var vec__17907 = p__17906;
var ___$1 = cljs.core.nth.call(null,vec__17907,(0),null);
var location = cljs.core.nth.call(null,vec__17907,(1),null);
return reagent.ratom.make_reaction.call(null,((function (vec__17907,___$1,location){
return (function (){
return joshkh.undo.undo_explanations.call(null,location);
});})(vec__17907,___$1,location))
);
}));
re_frame.core.reg_sub_raw.call(null,new cljs.core.Keyword(null,"redo-explanations","redo-explanations",-1933832741),(function joshkh$undo$handler(_,p__17910){
var vec__17911 = p__17910;
var ___$1 = cljs.core.nth.call(null,vec__17911,(0),null);
var location = cljs.core.nth.call(null,vec__17911,(1),null);
return reagent.ratom.make_reaction.call(null,((function (vec__17911,___$1,location){
return (function (){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,joshkh.undo.redo_explain_list),location);
});})(vec__17911,___$1,location))
);
}));
joshkh.undo.undo = (function joshkh$undo$undo(harvester,reinstater,undos,cur,redos,location){
var u = cljs.core.get_in.call(null,cljs.core.deref.call(null,undos),location);
var r = cljs.core.cons.call(null,harvester.call(null,cur,location),cljs.core.get_in.call(null,cljs.core.deref.call(null,redos),location));
reinstater.call(null,cur,cljs.core.last.call(null,u),location);

cljs.core.swap_BANG_.call(null,redos,cljs.core.assoc_in,location,r);

return cljs.core.swap_BANG_.call(null,undos,cljs.core.update_in,location,cljs.core.pop);
});
/**
 * undo n steps or until we run out of undos
 */
joshkh.undo.undo_n = (function joshkh$undo$undo_n(location,n){
while(true){
if((!((((n > (0))) && (joshkh.undo.undos_QMARK_.call(null,location)))))){
var temp__5457__auto__ = new cljs.core.Keyword(null,"post-reinstate-fn","post-reinstate-fn",-417777091).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config));
if(cljs.core.truth_(temp__5457__auto__)){
var post_reinstate_fn = temp__5457__auto__;
return post_reinstate_fn.call(null,location);
} else {
return null;
}
} else {
joshkh.undo.undo.call(null,new cljs.core.Keyword(null,"harvest-fn","harvest-fn",9140059).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config)),new cljs.core.Keyword(null,"reinstate-fn","reinstate-fn",1996128442).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config)),joshkh.undo.undo_list,re_frame.db.app_db,joshkh.undo.redo_list,location);

joshkh.undo.undo.call(null,cljs.core.deref,cljs.core.reset_BANG_,joshkh.undo.undo_explain_list,joshkh.undo.app_explain,joshkh.undo.redo_explain_list,location);

var G__17914 = location;
var G__17915 = (n - (1));
location = G__17914;
n = G__17915;
continue;
}
break;
}
});
joshkh.undo.undo_handler = (function joshkh$undo$undo_handler(_,p__17916){
var vec__17917 = p__17916;
var ___$1 = cljs.core.nth.call(null,vec__17917,(0),null);
var location = cljs.core.nth.call(null,vec__17917,(1),null);
var n = cljs.core.nth.call(null,vec__17917,(2),null);
if(cljs.core.not.call(null,joshkh.undo.undos_QMARK_.call(null,location))){
re_frame.core.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"re-frame: you did a (dispatch [:undo]), but there is nothing to undo.");
} else {
joshkh.undo.undo_n.call(null,location,(function (){var or__4131__auto__ = n;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})());
}

return cljs.core.PersistentArrayMap.EMPTY;
});
joshkh.undo.redo = (function joshkh$undo$redo(harvester,reinstater,undos,cur,redos,location){
var u = cljs.core.conj.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,undos),location),harvester.call(null,cur,location));
var r = cljs.core.get_in.call(null,cljs.core.deref.call(null,redos),location);
reinstater.call(null,cur,cljs.core.first.call(null,r),location);

cljs.core.swap_BANG_.call(null,redos,cljs.core.assoc_in,location,cljs.core.rest.call(null,r));

return cljs.core.swap_BANG_.call(null,undos,cljs.core.assoc_in,location,u);
});
/**
 * redo n steps or until we run out of redos
 */
joshkh.undo.redo_n = (function joshkh$undo$redo_n(location,n){
while(true){
if((!((((n > (0))) && (joshkh.undo.redos_QMARK_.call(null,location)))))){
var temp__5457__auto__ = new cljs.core.Keyword(null,"post-reinstate-fn","post-reinstate-fn",-417777091).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config));
if(cljs.core.truth_(temp__5457__auto__)){
var post_reinstate_fn = temp__5457__auto__;
return post_reinstate_fn.call(null,location);
} else {
return null;
}
} else {
joshkh.undo.redo.call(null,new cljs.core.Keyword(null,"harvest-fn","harvest-fn",9140059).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config)),new cljs.core.Keyword(null,"reinstate-fn","reinstate-fn",1996128442).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,joshkh.undo.config)),joshkh.undo.undo_list,re_frame.db.app_db,joshkh.undo.redo_list,location);

joshkh.undo.redo.call(null,cljs.core.deref,cljs.core.reset_BANG_,joshkh.undo.undo_explain_list,joshkh.undo.app_explain,joshkh.undo.redo_explain_list,location);

var G__17920 = location;
var G__17921 = (n - (1));
location = G__17920;
n = G__17921;
continue;
}
break;
}
});
joshkh.undo.redo_handler = (function joshkh$undo$redo_handler(_,p__17922){
var vec__17923 = p__17922;
var ___$1 = cljs.core.nth.call(null,vec__17923,(0),null);
var location = cljs.core.nth.call(null,vec__17923,(1),null);
var n = cljs.core.nth.call(null,vec__17923,(2),null);
if(cljs.core.not.call(null,joshkh.undo.redos_QMARK_.call(null,location))){
re_frame.core.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"re-frame: you did a (dispatch [:redo]), but there is nothing to redo.");
} else {
joshkh.undo.redo_n.call(null,location,(function (){var or__4131__auto__ = n;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})());
}

return cljs.core.PersistentArrayMap.EMPTY;
});
joshkh.undo.purge_redo_handler = (function joshkh$undo$purge_redo_handler(db,p__17926){
var vec__17927 = p__17926;
var _ = cljs.core.nth.call(null,vec__17927,(0),null);
var location = cljs.core.nth.call(null,vec__17927,(1),null);
if(cljs.core.not.call(null,joshkh.undo.redos_QMARK_.call(null,location))){
re_frame.core.console.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"re-frame: you did a (dispatch [:purge-redos]), but there is nothing to redo.");
} else {
joshkh.undo.clear_redos_BANG_.call(null);
}

return db;
});
/**
 * returns a side-effecting Interceptor, which stores an undo checkpoint in
 *   `:after` processing.
 * If the `:effect` cotnains an `:undo` key, then use the explanation provided
 * by it. Otherwise, `explanation` can be:
 *   - a string (of explanation)
 *   - a function expected to return a string of explanation. It will be called
 *     with two arguments: `db` and `event-vec`.
 *   - a nil, in which case "" is recorded as the explanation
 *   
 */
joshkh.undo.undoable = (function joshkh$undo$undoable(var_args){
var G__17931 = arguments.length;
switch (G__17931) {
case 0:
return joshkh.undo.undoable.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return joshkh.undo.undoable.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

joshkh.undo.undoable.cljs$core$IFn$_invoke$arity$0 = (function (){
return joshkh.undo.undoable.call(null,null);
});

joshkh.undo.undoable.cljs$core$IFn$_invoke$arity$1 = (function (explanation){
return re_frame.core.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"undoable","undoable",303475882),new cljs.core.Keyword(null,"after","after",594996914),(function (context){
var event = re_frame.core.get_coeffect.call(null,context,new cljs.core.Keyword(null,"event","event",301435442));
var undo_effect = re_frame.core.get_effect.call(null,context,new cljs.core.Keyword(null,"undo","undo",-1818036302));
var map__17932 = (((!((undo_effect == null))))?undo_effect:((cljs.core.fn_QMARK_.call(null,explanation))?explanation.call(null,re_frame.core.get_coeffect.call(null,context,new cljs.core.Keyword(null,"db","db",993250759)),event):((typeof explanation === 'string')?explanation:(((explanation == null))?"":re_frame.core.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame-undo: \"undoable\" interceptor on event ",event," given a bad parameter. Got: ",explanation)
))));
var map__17932__$1 = (((((!((map__17932 == null))))?(((((map__17932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17932.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17932):map__17932);
var location = cljs.core.get.call(null,map__17932__$1,new cljs.core.Keyword(null,"location","location",1815599388));
var message = cljs.core.get.call(null,map__17932__$1,new cljs.core.Keyword(null,"message","message",-406056002));
joshkh.undo.store_now_BANG_.call(null,message,location);

return cljs.core.update.call(null,context,new cljs.core.Keyword(null,"effects","effects",-282369292),cljs.core.dissoc,new cljs.core.Keyword(null,"undo","undo",-1818036302));
}));
});

joshkh.undo.undoable.cljs$lang$maxFixedArity = 1;

joshkh.undo.register_events_subs_BANG_ = (function joshkh$undo$register_events_subs_BANG_(){
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"undo","undo",-1818036302),joshkh.undo.undo_handler);

re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"redo","redo",501190664),joshkh.undo.redo_handler);

return re_frame.core.reg_event_db.call(null,new cljs.core.Keyword(null,"purge-redos","purge-redos",1815721624),joshkh.undo.purge_redo_handler);
});
joshkh.undo.register_events_subs_BANG_.call(null);

//# sourceMappingURL=undo.js.map
