(ns bluegenes.pages.reportpage.components.tables
  (:require [re-frame.core :refer [subscribe dispatch]]))

#_(defn tbl)

;; Note:
;; Is this really necessary when it's already computed as the comments table?
;; We should maybe instead focus on categorising.


(let [allowed-comment-types ["similarity" "function" "tissue specificity"
                             "subcellular location" "catalytic activity"
                             "disease" "developmental stage" "pathway"
                             "pharmaceutical"]]

  (defn curated-gene-comments [gene-id]
    {:from "Gene"
     :select ["proteins.comments.description"
              "proteins.primaryIdentifier"
              "proteins.id"
              "proteins.comments.type"
              "primaryIdentifier"]
     :where [{:path "Gene.id"
              :op "="
              :value gene-id}
             {:path "proteins.comments.type"
              :op "ONE OF"
              :values allowed-comment-types}]
     :sortOrder [{:path "Gene.proteins.comments.type"
                  :direction "ASC"}]})

  (defn curated-protein-comments [protein-id]
    {:from "Protein"
     :select ["Protein.comments.description"
              "Protein.comments.type"
              "Protein.primaryIdentifier"]
     :where [{:path "Protein.id"
              :op "="
              :value protein-id}
             {:path "Protein.comments.type"
              :op "ONE OF"
              :values allowed-comment-types}]
     :sortOrder [{:path "Protein.comments.type"
                  :direction "ASC"}]}))

(defn main []
  {:Gene    [curated-gene-comments]
   :Protein [curated-protein-comments]})
