// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.querybuilder.logic');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('clojure.string');
goog.require('oops.core');
goog.require('cljs.reader');
bluegenes.pages.querybuilder.logic.index_of = (function bluegenes$pages$querybuilder$logic$index_of(haystack,needle){
return cljs.core.first.call(null,cljs.core.keep_indexed.call(null,(function (idx,e){
if(cljs.core._EQ_.call(null,needle,e)){
return idx;
} else {
return null;
}
}),haystack));
});
/**
 * Recurisvely groups entities in a vector that are connected by the 'and symbol
 */
bluegenes.pages.querybuilder.logic.group_ands = (function bluegenes$pages$querybuilder$logic$group_ands(v){
while(true){
if(cljs.core.vector_QMARK_.call(null,v)){
var first_part = cljs.core.vec.call(null,cljs.core.take.call(null,(bluegenes.pages.querybuilder.logic.index_of.call(null,v,new cljs.core.Symbol(null,"and","and",668631710,null)) - (1)),v));
var grouped = cljs.core.vec.call(null,cljs.core.take_while.call(null,cljs.core.partial.call(null,cljs.core.not_EQ_,new cljs.core.Symbol(null,"or","or",1876275696,null)),cljs.core.drop.call(null,cljs.core.count.call(null,first_part),v)));
var end = cljs.core.take_last.call(null,(cljs.core.count.call(null,v) - (cljs.core.count.call(null,first_part) + cljs.core.count.call(null,grouped))),v);
var grouped__$1 = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,grouped)))?cljs.core.first.call(null,grouped):grouped);
var final$ = cljs.core.reduce.call(null,cljs.core.conj,cljs.core.conj.call(null,first_part,grouped__$1),end);
if(cljs.core.truth_(bluegenes.pages.querybuilder.logic.index_of.call(null,final$,new cljs.core.Symbol(null,"and","and",668631710,null)))){
var G__19996 = final$;
v = G__19996;
continue;
} else {
return final$;
}
} else {
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[v],null));
}
break;
}
});
bluegenes.pages.querybuilder.logic.without_operators = (function bluegenes$pages$querybuilder$logic$without_operators(col){
return cljs.core.vec.call(null,cljs.core.filter.call(null,(function (item){
return (!((!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([item]),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"and","and",668631710,null),null,new cljs.core.Symbol(null,"or","or",1876275696,null),null], null), null)) == null)))));
}),col));
});
bluegenes.pages.querybuilder.logic.single_vec_of_vec_QMARK_ = (function bluegenes$pages$querybuilder$logic$single_vec_of_vec_QMARK_(item){

return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,item),(1))) && (cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,item))));
});
bluegenes.pages.querybuilder.logic.single_vec_of_symbol_QMARK_ = (function bluegenes$pages$querybuilder$logic$single_vec_of_symbol_QMARK_(item){

return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,item),(1))) && ((cljs.core.first.call(null,item) instanceof cljs.core.Symbol)));
});
bluegenes.pages.querybuilder.logic.raise = (function bluegenes$pages$querybuilder$logic$raise(v){
while(true){
if(((cljs.core.vector_QMARK_.call(null,v)) && ((cljs.core.count.call(null,v) < (2))) && (cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,v))))){
var G__19997 = cljs.core.first.call(null,v);
v = G__19997;
continue;
} else {
return v;
}
break;
}
});
/**
 * Recursively convert vectors to lists
 */
bluegenes.pages.querybuilder.logic.vec__GT_list = (function bluegenes$pages$querybuilder$logic$vec__GT_list(v){
return clojure.walk.postwalk.call(null,(function (e){
if(cljs.core.vector_QMARK_.call(null,e)){
return cljs.core.apply.call(null,cljs.core.list,e);
} else {
return e;
}
}),v);
});
/**
 * Recursively convert lists to vectors
 */
bluegenes.pages.querybuilder.logic.list__GT_vec = (function bluegenes$pages$querybuilder$logic$list__GT_vec(v){
return clojure.walk.postwalk.call(null,(function (e){
if(cljs.core.list_QMARK_.call(null,e)){
return cljs.core.vec.call(null,e);
} else {
return e;
}
}),v);
});
bluegenes.pages.querybuilder.logic.add_left_bracket = (function bluegenes$pages$querybuilder$logic$add_left_bracket(s){
return ["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
});
bluegenes.pages.querybuilder.logic.add_right_bracket = (function bluegenes$pages$querybuilder$logic$add_right_bracket(s){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"]"].join('');
});
bluegenes.pages.querybuilder.logic.wrap_string_in_brackets = (function bluegenes$pages$querybuilder$logic$wrap_string_in_brackets(s){
var G__19998 = s;
var G__19998__$1 = (((!(clojure.string.starts_with_QMARK_.call(null,s,"("))))?bluegenes.pages.querybuilder.logic.add_left_bracket.call(null,G__19998):G__19998);
if((!(clojure.string.ends_with_QMARK_.call(null,s,")")))){
return bluegenes.pages.querybuilder.logic.add_right_bracket.call(null,G__19998__$1);
} else {
return G__19998__$1;
}
});
bluegenes.pages.querybuilder.logic.clause_type = (function bluegenes$pages$querybuilder$logic$clause_type(v){
if((!((cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"or","or",1876275696,null),null], null), null),v) == null)))){
return new cljs.core.Keyword(null,"or","or",235744169);
} else {
if((!((cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"and","and",668631710,null),null], null), null),v) == null)))){
return new cljs.core.Keyword(null,"and","and",-971899817);
} else {
return null;

}
}
});
bluegenes.pages.querybuilder.logic.append_code = (function bluegenes$pages$querybuilder$logic$append_code(v,code){
if(cljs.core.empty_QMARK_.call(null,v)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [code], null);
} else {
var type = bluegenes.pages.querybuilder.logic.clause_type.call(null,v);
return bluegenes.pages.querybuilder.logic.raise.call(null,bluegenes.pages.querybuilder.logic.group_ands.call(null,(function (){var G__19999 = type;
var G__19999__$1 = (((G__19999 instanceof cljs.core.Keyword))?G__19999.fqn:null);
switch (G__19999__$1) {
case "or":
return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,new cljs.core.Symbol(null,"and","and",668631710,null),code], null));

break;
default:
return cljs.core.reduce.call(null,cljs.core.conj,v,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"and","and",668631710,null),code], null));

}
})()));
}
});
bluegenes.pages.querybuilder.logic.one_of_QMARK_ = (function bluegenes$pages$querybuilder$logic$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
bluegenes.pages.querybuilder.logic.remove_repeats = (function bluegenes$pages$querybuilder$logic$remove_repeats(v){
var without_repeats = cljs.core.reduce.call(null,(function (total,next){
if(cljs.core.not_EQ_.call(null,next,cljs.core.last.call(null,total))){
return cljs.core.conj.call(null,total,next);
} else {
return total;
}
}),cljs.core.PersistentVector.EMPTY,v);
return cljs.core.vec.call(null,(function (){var G__20001 = without_repeats;
var G__20001__$1 = ((bluegenes.pages.querybuilder.logic.one_of_QMARK_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"and","and",668631710,null)], null),cljs.core.first.call(null,without_repeats)))?cljs.core.drop.call(null,(1),G__20001):G__20001);
if(bluegenes.pages.querybuilder.logic.one_of_QMARK_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"and","and",668631710,null)], null),cljs.core.last.call(null,without_repeats))){
return cljs.core.butlast.call(null,G__20001__$1);
} else {
return G__20001__$1;
}
})());
});
/**
 * Recursively removes a symbol from a tree and raises neighbours with a count of one
 */
bluegenes.pages.querybuilder.logic.remove_code = (function bluegenes$pages$querybuilder$logic$remove_code(v,code){
return bluegenes.pages.querybuilder.logic.raise.call(null,bluegenes.pages.querybuilder.logic.group_ands.call(null,clojure.walk.postwalk.call(null,(function (e){
if(cljs.core.vector_QMARK_.call(null,e)){
var removed = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.partial.call(null,cljs.core._EQ_,code),e));
var without_ops = bluegenes.pages.querybuilder.logic.without_operators.call(null,removed);
if(bluegenes.pages.querybuilder.logic.single_vec_of_vec_QMARK_.call(null,without_ops)){
return cljs.core.vec.call(null,cljs.core.mapcat.call(null,cljs.core.identity,without_ops));
} else {
if(bluegenes.pages.querybuilder.logic.single_vec_of_symbol_QMARK_.call(null,without_ops)){
return cljs.core.first.call(null,without_ops);
} else {
return bluegenes.pages.querybuilder.logic.remove_repeats.call(null,removed);

}
}
} else {
return e;
}
}),v)));
});
bluegenes.pages.querybuilder.logic.read_logic_string = (function bluegenes$pages$querybuilder$logic$read_logic_string(s){
var G__20002 = s;
var G__20002__$1 = (((G__20002 == null))?null:bluegenes.pages.querybuilder.logic.wrap_string_in_brackets.call(null,G__20002));
var G__20002__$2 = (((G__20002__$1 == null))?null:cljs.reader.read_string.call(null,G__20002__$1));
var G__20002__$3 = (((G__20002__$2 == null))?null:bluegenes.pages.querybuilder.logic.list__GT_vec.call(null,G__20002__$2));
var G__20002__$4 = (((G__20002__$3 == null))?null:bluegenes.pages.querybuilder.logic.group_ands.call(null,G__20002__$3));
if((G__20002__$4 == null)){
return null;
} else {
return bluegenes.pages.querybuilder.logic.raise.call(null,G__20002__$4);
}
});

//# sourceMappingURL=logic.js.map
