// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.regions.results');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('bluegenes.pages.regions.graphs');
goog.require('bluegenes.components.table');
goog.require('bluegenes.components.loader');
goog.require('bluegenes.pages.regions.events');
goog.require('bluegenes.pages.regions.subs');
goog.require('bluegenes.components.imcontrols.views');
goog.require('bluegenes.components.bootstrap');
goog.require('clojure.string');
goog.require('oops.core');
goog.require('bluegenes.route');
bluegenes.pages.regions.results.feature_to_uid = (function bluegenes$pages$regions$results$feature_to_uid(p__24858){
var map__24859 = p__24858;
var map__24859__$1 = (((((!((map__24859 == null))))?(((((map__24859.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24859.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24859):map__24859);
var feature = map__24859__$1;
var chromosome = cljs.core.get.call(null,map__24859__$1,new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350));
var from = cljs.core.get.call(null,map__24859__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__24859__$1,new cljs.core.Keyword(null,"to","to",192099007));
var results = cljs.core.get.call(null,map__24859__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
var regions_searched = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","regions-searched","regions/regions-searched",350929708)], null));
if(cljs.core.truth_(from)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(chromosome),cljs.core.str.cljs$core$IFn$_invoke$arity$1(from),cljs.core.str.cljs$core$IFn$_invoke$arity$1(to)].join('');
} else {
var the_feature = cljs.core.first.call(null,cljs.core.filter.call(null,((function (regions_searched,map__24859,map__24859__$1,feature,chromosome,from,to,results){
return (function (x){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350).cljs$core$IFn$_invoke$arity$1(x),feature);
});})(regions_searched,map__24859,map__24859__$1,feature,chromosome,from,to,results))
,cljs.core.deref.call(null,regions_searched)));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350).cljs$core$IFn$_invoke$arity$1(the_feature)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(the_feature)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"to","to",192099007).cljs$core$IFn$_invoke$arity$1(the_feature))].join('');
}
});
/**
 * Header for each region. includes paginator and number of features.
 */
bluegenes.pages.regions.results.region_header = (function bluegenes$pages$regions$results$region_header(p__24861,paginator){
var map__24862 = p__24861;
var map__24862__$1 = (((((!((map__24862 == null))))?(((((map__24862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24862.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24862):map__24862);
var feature = map__24862__$1;
var chromosome = cljs.core.get.call(null,map__24862__$1,new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350));
var from = cljs.core.get.call(null,map__24862__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__24862__$1,new cljs.core.Keyword(null,"to","to",192099007));
var results = cljs.core.get.call(null,map__24862__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),bluegenes.pages.regions.results.feature_to_uid.call(null,feature)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),"Region: "], null),(cljs.core.truth_(chromosome)?new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),chromosome," ",from,"..",to," "], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),feature," "], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"small.features-count","small.features-count",1887686032),cljs.core.count.call(null,results)," overlapping features"], null),(((cljs.core.count.call(null,results) > (0)))?paginator:null)], null);
});
/**
 * UI component to switch between pages of results
 */
bluegenes.pages.regions.results.table_paginator = (function bluegenes$pages$regions$results$table_paginator(pager,results){
var page_count = (Math.ceil((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)))) | (0));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.pull-right.paginator","div.pull-right.paginator",-895193836),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) < (1)),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (page_count){
return (function (){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.update,new cljs.core.Keyword(null,"page","page",849072397),cljs.core.dec);
});})(page_count))
], null),"< Previous"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.currentpage","span.currentpage",782884836),"Page ",(new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) + (1))," of ",page_count], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(cljs.core.count.call(null,results) < (new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * (new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) + (1)))),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (page_count){
return (function (){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.update,new cljs.core.Keyword(null,"page","page",849072397),cljs.core.inc);
});})(page_count))
], null),"Next >"], null)], null);
});
/**
 * Header for results table.
 */
bluegenes.pages.regions.results.table_header = (function bluegenes$pages$regions$results$table_header(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid-3_xs-3","div.grid-3_xs-3",-515707527),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Feature"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Feature Type"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Location"], null)], null)], null);
});
/**
 * A single result row for a single region feature.
 */
bluegenes.pages.regions.results.table_row = (function bluegenes$pages$regions$results$table_row(chromosome,p__24864){
var map__24865 = p__24864;
var map__24865__$1 = (((((!((map__24865 == null))))?(((((map__24865.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24865.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24865):map__24865);
var result = map__24865__$1;
var primaryIdentifier = cljs.core.get.call(null,map__24865__$1,new cljs.core.Keyword(null,"primaryIdentifier","primaryIdentifier",1592261948));
var class$ = cljs.core.get.call(null,map__24865__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var chromosomeLocation = cljs.core.get.call(null,map__24865__$1,new cljs.core.Keyword(null,"chromosomeLocation","chromosomeLocation",-816811374));
var objectId = cljs.core.get.call(null,map__24865__$1,new cljs.core.Keyword(null,"objectId","objectId",1455179945));
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"model","model",331153215)], null));
var current_mine = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
var the_type = cljs.core.get_in.call(null,cljs.core.deref.call(null,model),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,class$),new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","report","bluegenes.route/report",626109223),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"mine","mine",-130428525),cljs.core.name.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine))),new cljs.core.Keyword(null,"type","type",1174270348),class$,new cljs.core.Keyword(null,"id","id",-1388402092),objectId], null))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.grid-3_xs-3.single-feature","div.grid-3_xs-3.single-feature",-1114280466),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"word-wrap","word-wrap",-1700975926),"break-word"], null)], null),primaryIdentifier], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),the_type], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col","div.col",-1800797011),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,chromosomeLocation,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"locatedOn","locatedOn",1737198609),new cljs.core.Keyword(null,"primaryIdentifier","primaryIdentifier",1592261948)], null))),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(chromosomeLocation)),"..",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"end","end",-268185958).cljs$core$IFn$_invoke$arity$1(chromosomeLocation))].join('')], null)], null)], null);
});
/**
 * The result table for a region - all features
 */
bluegenes.pages.regions.results.result_table = (function bluegenes$pages$regions$results$result_table(){
var pager = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"show","show",-576705889),(20),new cljs.core.Keyword(null,"page","page",849072397),(0)], null));
return ((function (pager){
return (function (p__24867){
var map__24868 = p__24867;
var map__24868__$1 = (((((!((map__24868 == null))))?(((((map__24868.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24868.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24868):map__24868);
var feature = map__24868__$1;
var chromosome = cljs.core.get.call(null,map__24868__$1,new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350));
var from = cljs.core.get.call(null,map__24868__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__24868__$1,new cljs.core.Keyword(null,"to","to",192099007));
var results = cljs.core.get.call(null,map__24868__$1,new cljs.core.Keyword(null,"results","results",-1134170113));
if((cljs.core.count.call(null,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(feature)) > (0))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results","div.results",1001372547),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.region_header,feature,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.table_paginator,pager,results], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tabulated","div.tabulated",-2122420462),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.table_header], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results-body","div.results-body",-525587332)], null),cljs.core.map.call(null,((function (map__24868,map__24868__$1,feature,chromosome,from,to,results,pager){
return (function (result){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.table_row,chromosome,result], null);
});})(map__24868,map__24868__$1,feature,chromosome,from,to,results,pager))
,cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),cljs.core.sort_by.call(null,cljs.core.comp.call(null,new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"chromosomeLocation","chromosomeLocation",-816811374)),results)))))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results.noresults","div.results.noresults",-1959813571),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.region_header,chromosome,from,to], null),"No features returned for this region"], null);
}
});
;})(pager))
});
bluegenes.pages.regions.results.error_loading_results = (function bluegenes$pages$regions$results$error_loading_results(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results.error","div.results.error",-159548916),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-wondering","svg.icon.icon-wondering",-1400649319),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-wondering"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.errordetails","div.errordetails",419757759),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),"Houston, we've had a problem. "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Looks like there was a problem fetching results."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),"Please check that your search regions are in the correct format."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),"Please check you're connected to the internet."], null)], null)], null)], null);
});
bluegenes.pages.regions.results.results_count_summary = (function bluegenes$pages$regions$results$results_count_summary(results){
if((cljs.core.count.call(null,results) > (0))){
return cljs.core.reduce.call(null,(function (new_div,result){
var num = cljs.core.count.call(null,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(result));
var feature = bluegenes.pages.regions.results.feature_to_uid.call(null,result);
return cljs.core.conj.call(null,new_div,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.results-count","span.results-count",819772375),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),(((num === (0)))?"noresults":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (num,feature){
return (function (){
document.getElementById(feature).scrollIntoView(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"behavior","behavior",1202392908),"smooth"], null));

return window.scrollBy((0),(-80));
});})(num,feature))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),new cljs.core.Keyword(null,"chromosome","chromosome",-2014316350).cljs$core$IFn$_invoke$arity$1(result)], null),": ",num," results"], null));
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results-counts","div.results-counts",812493239),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.skip-to","span.skip-to",2028936586),"Skip to:"], null)], null),results);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632)], null);
}
});
bluegenes.pages.regions.results.results_section = (function bluegenes$pages$regions$results$results_section(){
var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","results","regions/results",2099460098)], null));
var loading_QMARK_ = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","loading","regions/loading",349624758)], null));
var error = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","error","regions/error",98657847)], null));
if(cljs.core.truth_(cljs.core.deref.call(null,loading_QMARK_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.loader.loader,"Regions"], null);
} else {
if(cljs.core.not.call(null,cljs.core.deref.call(null,error))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results-summary","div.results-summary",749930356),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Results"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.results_count_summary,cljs.core.deref.call(null,results)], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.allresults","div.allresults",-253140881)], null),cljs.core.map.call(null,((function (results,loading_QMARK_,error){
return (function (result){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.result_table,result], null);
});})(results,loading_QMARK_,error))
,cljs.core.deref.call(null,results)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.regions.results.error_loading_results], null);
}
}
});

//# sourceMappingURL=results.js.map
