// Compiled by ClojureScript 1.10.520 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy.core.selector,data));
} else {
if(((typeof data === 'string') || ((data instanceof cljs.core.Keyword)))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__4131__auto__ = elem.textContent;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var G__6669 = arguments.length;
switch (G__6669) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.call(null,elem,k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__5455__auto__ = elem.classList;
if(cljs.core.truth_(temp__5455__auto__)){
var class_list = temp__5455__auto__;
return class_list.contains(c__$1);
} else {
var temp__5457__auto__ = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(temp__5457__auto__)){
var class_name = temp__5457__auto__;
var temp__5457__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);
if(cljs.core.truth_(temp__5457__auto____$1)){
var i = temp__5457__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var G__6672 = arguments.length;
switch (G__6672) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var G__6676 = arguments.length;
switch (G__6676) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__6674_SHARP_){
return (!((p1__6674_SHARP_ === base)));
}),dommy.core.ancestors.call(null,elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.call(null,document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if((!((void 0 === elem.textContent)))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6696 = arguments.length;
var i__4731__auto___6697 = (0);
while(true){
if((i__4731__auto___6697 < len__4730__auto___6696)){
args__4736__auto__.push((arguments[i__4731__auto___6697]));

var G__6698 = (i__4731__auto___6697 + (1));
i__4731__auto___6697 = G__6698;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__6680_6699 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__6681_6700 = null;
var count__6682_6701 = (0);
var i__6683_6702 = (0);
while(true){
if((i__6683_6702 < count__6682_6701)){
var vec__6690_6703 = cljs.core._nth.call(null,chunk__6681_6700,i__6683_6702);
var k_6704 = cljs.core.nth.call(null,vec__6690_6703,(0),null);
var v_6705 = cljs.core.nth.call(null,vec__6690_6703,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_6704),v_6705);


var G__6706 = seq__6680_6699;
var G__6707 = chunk__6681_6700;
var G__6708 = count__6682_6701;
var G__6709 = (i__6683_6702 + (1));
seq__6680_6699 = G__6706;
chunk__6681_6700 = G__6707;
count__6682_6701 = G__6708;
i__6683_6702 = G__6709;
continue;
} else {
var temp__5457__auto___6710 = cljs.core.seq.call(null,seq__6680_6699);
if(temp__5457__auto___6710){
var seq__6680_6711__$1 = temp__5457__auto___6710;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6680_6711__$1)){
var c__4550__auto___6712 = cljs.core.chunk_first.call(null,seq__6680_6711__$1);
var G__6713 = cljs.core.chunk_rest.call(null,seq__6680_6711__$1);
var G__6714 = c__4550__auto___6712;
var G__6715 = cljs.core.count.call(null,c__4550__auto___6712);
var G__6716 = (0);
seq__6680_6699 = G__6713;
chunk__6681_6700 = G__6714;
count__6682_6701 = G__6715;
i__6683_6702 = G__6716;
continue;
} else {
var vec__6693_6717 = cljs.core.first.call(null,seq__6680_6711__$1);
var k_6718 = cljs.core.nth.call(null,vec__6693_6717,(0),null);
var v_6719 = cljs.core.nth.call(null,vec__6693_6717,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_6718),v_6719);


var G__6720 = cljs.core.next.call(null,seq__6680_6711__$1);
var G__6721 = null;
var G__6722 = (0);
var G__6723 = (0);
seq__6680_6699 = G__6720;
chunk__6681_6700 = G__6721;
count__6682_6701 = G__6722;
i__6683_6702 = G__6723;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq6678){
var G__6679 = cljs.core.first.call(null,seq6678);
var seq6678__$1 = cljs.core.next.call(null,seq6678);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6679,seq6678__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6730 = arguments.length;
var i__4731__auto___6731 = (0);
while(true){
if((i__4731__auto___6731 < len__4730__auto___6730)){
args__4736__auto__.push((arguments[i__4731__auto___6731]));

var G__6732 = (i__4731__auto___6731 + (1));
i__4731__auto___6731 = G__6732;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__6726_6733 = cljs.core.seq.call(null,keywords);
var chunk__6727_6734 = null;
var count__6728_6735 = (0);
var i__6729_6736 = (0);
while(true){
if((i__6729_6736 < count__6728_6735)){
var kw_6737 = cljs.core._nth.call(null,chunk__6727_6734,i__6729_6736);
style.removeProperty(dommy.utils.as_str.call(null,kw_6737));


var G__6738 = seq__6726_6733;
var G__6739 = chunk__6727_6734;
var G__6740 = count__6728_6735;
var G__6741 = (i__6729_6736 + (1));
seq__6726_6733 = G__6738;
chunk__6727_6734 = G__6739;
count__6728_6735 = G__6740;
i__6729_6736 = G__6741;
continue;
} else {
var temp__5457__auto___6742 = cljs.core.seq.call(null,seq__6726_6733);
if(temp__5457__auto___6742){
var seq__6726_6743__$1 = temp__5457__auto___6742;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6726_6743__$1)){
var c__4550__auto___6744 = cljs.core.chunk_first.call(null,seq__6726_6743__$1);
var G__6745 = cljs.core.chunk_rest.call(null,seq__6726_6743__$1);
var G__6746 = c__4550__auto___6744;
var G__6747 = cljs.core.count.call(null,c__4550__auto___6744);
var G__6748 = (0);
seq__6726_6733 = G__6745;
chunk__6727_6734 = G__6746;
count__6728_6735 = G__6747;
i__6729_6736 = G__6748;
continue;
} else {
var kw_6749 = cljs.core.first.call(null,seq__6726_6743__$1);
style.removeProperty(dommy.utils.as_str.call(null,kw_6749));


var G__6750 = cljs.core.next.call(null,seq__6726_6743__$1);
var G__6751 = null;
var G__6752 = (0);
var G__6753 = (0);
seq__6726_6733 = G__6750;
chunk__6727_6734 = G__6751;
count__6728_6735 = G__6752;
i__6729_6736 = G__6753;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq6724){
var G__6725 = cljs.core.first.call(null,seq6724);
var seq6724__$1 = cljs.core.next.call(null,seq6724);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6725,seq6724__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___6772 = arguments.length;
var i__4731__auto___6773 = (0);
while(true){
if((i__4731__auto___6773 < len__4730__auto___6772)){
args__4736__auto__.push((arguments[i__4731__auto___6773]));

var G__6774 = (i__4731__auto___6773 + (1));
i__4731__auto___6773 = G__6774;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__6756_6775 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__6757_6776 = null;
var count__6758_6777 = (0);
var i__6759_6778 = (0);
while(true){
if((i__6759_6778 < count__6758_6777)){
var vec__6766_6779 = cljs.core._nth.call(null,chunk__6757_6776,i__6759_6778);
var k_6780 = cljs.core.nth.call(null,vec__6766_6779,(0),null);
var v_6781 = cljs.core.nth.call(null,vec__6766_6779,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_6780,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_6781),"px"].join(''));


var G__6782 = seq__6756_6775;
var G__6783 = chunk__6757_6776;
var G__6784 = count__6758_6777;
var G__6785 = (i__6759_6778 + (1));
seq__6756_6775 = G__6782;
chunk__6757_6776 = G__6783;
count__6758_6777 = G__6784;
i__6759_6778 = G__6785;
continue;
} else {
var temp__5457__auto___6786 = cljs.core.seq.call(null,seq__6756_6775);
if(temp__5457__auto___6786){
var seq__6756_6787__$1 = temp__5457__auto___6786;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6756_6787__$1)){
var c__4550__auto___6788 = cljs.core.chunk_first.call(null,seq__6756_6787__$1);
var G__6789 = cljs.core.chunk_rest.call(null,seq__6756_6787__$1);
var G__6790 = c__4550__auto___6788;
var G__6791 = cljs.core.count.call(null,c__4550__auto___6788);
var G__6792 = (0);
seq__6756_6775 = G__6789;
chunk__6757_6776 = G__6790;
count__6758_6777 = G__6791;
i__6759_6778 = G__6792;
continue;
} else {
var vec__6769_6793 = cljs.core.first.call(null,seq__6756_6787__$1);
var k_6794 = cljs.core.nth.call(null,vec__6769_6793,(0),null);
var v_6795 = cljs.core.nth.call(null,vec__6769_6793,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_6794,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v_6795),"px"].join(''));


var G__6796 = cljs.core.next.call(null,seq__6756_6787__$1);
var G__6797 = null;
var G__6798 = (0);
var G__6799 = (0);
seq__6756_6775 = G__6796;
chunk__6757_6776 = G__6797;
count__6758_6777 = G__6798;
i__6759_6778 = G__6799;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq6754){
var G__6755 = cljs.core.first.call(null,seq6754);
var seq6754__$1 = cljs.core.next.call(null,seq6754);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6755,seq6754__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var G__6805 = arguments.length;
switch (G__6805) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___6825 = arguments.length;
var i__4731__auto___6826 = (0);
while(true){
if((i__4731__auto___6826 < len__4730__auto___6825)){
args_arr__4751__auto__.push((arguments[i__4731__auto___6826]));

var G__6827 = (i__4731__auto___6826 + (1));
i__4731__auto___6826 = G__6827;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4752__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.call(null,elem,k,dommy.utils.as_str.call(null,k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__6806 = elem;
(G__6806[k__$1] = v);

return G__6806;
} else {
var G__6807 = elem;
G__6807.setAttribute(k__$1,v);

return G__6807;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__6808_6828 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__6809_6829 = null;
var count__6810_6830 = (0);
var i__6811_6831 = (0);
while(true){
if((i__6811_6831 < count__6810_6830)){
var vec__6818_6832 = cljs.core._nth.call(null,chunk__6809_6829,i__6811_6831);
var k_6833__$1 = cljs.core.nth.call(null,vec__6818_6832,(0),null);
var v_6834__$1 = cljs.core.nth.call(null,vec__6818_6832,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_6833__$1,v_6834__$1);


var G__6835 = seq__6808_6828;
var G__6836 = chunk__6809_6829;
var G__6837 = count__6810_6830;
var G__6838 = (i__6811_6831 + (1));
seq__6808_6828 = G__6835;
chunk__6809_6829 = G__6836;
count__6810_6830 = G__6837;
i__6811_6831 = G__6838;
continue;
} else {
var temp__5457__auto___6839 = cljs.core.seq.call(null,seq__6808_6828);
if(temp__5457__auto___6839){
var seq__6808_6840__$1 = temp__5457__auto___6839;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6808_6840__$1)){
var c__4550__auto___6841 = cljs.core.chunk_first.call(null,seq__6808_6840__$1);
var G__6842 = cljs.core.chunk_rest.call(null,seq__6808_6840__$1);
var G__6843 = c__4550__auto___6841;
var G__6844 = cljs.core.count.call(null,c__4550__auto___6841);
var G__6845 = (0);
seq__6808_6828 = G__6842;
chunk__6809_6829 = G__6843;
count__6810_6830 = G__6844;
i__6811_6831 = G__6845;
continue;
} else {
var vec__6821_6846 = cljs.core.first.call(null,seq__6808_6840__$1);
var k_6847__$1 = cljs.core.nth.call(null,vec__6821_6846,(0),null);
var v_6848__$1 = cljs.core.nth.call(null,vec__6821_6846,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_6847__$1,v_6848__$1);


var G__6849 = cljs.core.next.call(null,seq__6808_6840__$1);
var G__6850 = null;
var G__6851 = (0);
var G__6852 = (0);
seq__6808_6828 = G__6849;
chunk__6809_6829 = G__6850;
count__6810_6830 = G__6851;
i__6811_6831 = G__6852;
continue;
}
} else {
}
}
break;
}

return elem;
});

/** @this {Function} */
dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq6801){
var G__6802 = cljs.core.first.call(null,seq6801);
var seq6801__$1 = cljs.core.next.call(null,seq6801);
var G__6803 = cljs.core.first.call(null,seq6801__$1);
var seq6801__$2 = cljs.core.next.call(null,seq6801__$1);
var G__6804 = cljs.core.first.call(null,seq6801__$2);
var seq6801__$3 = cljs.core.next.call(null,seq6801__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6802,G__6803,G__6804,seq6801__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var G__6857 = arguments.length;
switch (G__6857) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___6863 = arguments.length;
var i__4731__auto___6864 = (0);
while(true){
if((i__4731__auto___6864 < len__4730__auto___6863)){
args_arr__4751__auto__.push((arguments[i__4731__auto___6864]));

var G__6865 = (i__4731__auto___6864 + (1));
i__4731__auto___6864 = G__6865;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_6866__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_6866__$1))){
dommy.core.set_class_BANG_.call(null,elem,"");
} else {
elem.removeAttribute(k_6866__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__6858_6867 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__6859_6868 = null;
var count__6860_6869 = (0);
var i__6861_6870 = (0);
while(true){
if((i__6861_6870 < count__6860_6869)){
var k_6871__$1 = cljs.core._nth.call(null,chunk__6859_6868,i__6861_6870);
dommy.core.remove_attr_BANG_.call(null,elem,k_6871__$1);


var G__6872 = seq__6858_6867;
var G__6873 = chunk__6859_6868;
var G__6874 = count__6860_6869;
var G__6875 = (i__6861_6870 + (1));
seq__6858_6867 = G__6872;
chunk__6859_6868 = G__6873;
count__6860_6869 = G__6874;
i__6861_6870 = G__6875;
continue;
} else {
var temp__5457__auto___6876 = cljs.core.seq.call(null,seq__6858_6867);
if(temp__5457__auto___6876){
var seq__6858_6877__$1 = temp__5457__auto___6876;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6858_6877__$1)){
var c__4550__auto___6878 = cljs.core.chunk_first.call(null,seq__6858_6877__$1);
var G__6879 = cljs.core.chunk_rest.call(null,seq__6858_6877__$1);
var G__6880 = c__4550__auto___6878;
var G__6881 = cljs.core.count.call(null,c__4550__auto___6878);
var G__6882 = (0);
seq__6858_6867 = G__6879;
chunk__6859_6868 = G__6880;
count__6860_6869 = G__6881;
i__6861_6870 = G__6882;
continue;
} else {
var k_6883__$1 = cljs.core.first.call(null,seq__6858_6877__$1);
dommy.core.remove_attr_BANG_.call(null,elem,k_6883__$1);


var G__6884 = cljs.core.next.call(null,seq__6858_6877__$1);
var G__6885 = null;
var G__6886 = (0);
var G__6887 = (0);
seq__6858_6867 = G__6884;
chunk__6859_6868 = G__6885;
count__6860_6869 = G__6886;
i__6861_6870 = G__6887;
continue;
}
} else {
}
}
break;
}

return elem;
});

/** @this {Function} */
dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq6854){
var G__6855 = cljs.core.first.call(null,seq6854);
var seq6854__$1 = cljs.core.next.call(null,seq6854);
var G__6856 = cljs.core.first.call(null,seq6854__$1);
var seq6854__$2 = cljs.core.next.call(null,seq6854__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6855,G__6856,seq6854__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var G__6889 = arguments.length;
switch (G__6889) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.call(null,elem,k);
} else {
return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var G__6895 = arguments.length;
switch (G__6895) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___6909 = arguments.length;
var i__4731__auto___6910 = (0);
while(true){
if((i__4731__auto___6910 < len__4730__auto___6909)){
args_arr__4751__auto__.push((arguments[i__4731__auto___6910]));

var G__6911 = (i__4731__auto___6910 + (1));
i__4731__auto___6910 = G__6911;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);
if(cljs.core.seq.call(null,classes__$1)){
var temp__5455__auto___6912 = elem.classList;
if(cljs.core.truth_(temp__5455__auto___6912)){
var class_list_6913 = temp__5455__auto___6912;
var seq__6896_6914 = cljs.core.seq.call(null,classes__$1);
var chunk__6897_6915 = null;
var count__6898_6916 = (0);
var i__6899_6917 = (0);
while(true){
if((i__6899_6917 < count__6898_6916)){
var c_6918 = cljs.core._nth.call(null,chunk__6897_6915,i__6899_6917);
class_list_6913.add(c_6918);


var G__6919 = seq__6896_6914;
var G__6920 = chunk__6897_6915;
var G__6921 = count__6898_6916;
var G__6922 = (i__6899_6917 + (1));
seq__6896_6914 = G__6919;
chunk__6897_6915 = G__6920;
count__6898_6916 = G__6921;
i__6899_6917 = G__6922;
continue;
} else {
var temp__5457__auto___6923 = cljs.core.seq.call(null,seq__6896_6914);
if(temp__5457__auto___6923){
var seq__6896_6924__$1 = temp__5457__auto___6923;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6896_6924__$1)){
var c__4550__auto___6925 = cljs.core.chunk_first.call(null,seq__6896_6924__$1);
var G__6926 = cljs.core.chunk_rest.call(null,seq__6896_6924__$1);
var G__6927 = c__4550__auto___6925;
var G__6928 = cljs.core.count.call(null,c__4550__auto___6925);
var G__6929 = (0);
seq__6896_6914 = G__6926;
chunk__6897_6915 = G__6927;
count__6898_6916 = G__6928;
i__6899_6917 = G__6929;
continue;
} else {
var c_6930 = cljs.core.first.call(null,seq__6896_6924__$1);
class_list_6913.add(c_6930);


var G__6931 = cljs.core.next.call(null,seq__6896_6924__$1);
var G__6932 = null;
var G__6933 = (0);
var G__6934 = (0);
seq__6896_6914 = G__6931;
chunk__6897_6915 = G__6932;
count__6898_6916 = G__6933;
i__6899_6917 = G__6934;
continue;
}
} else {
}
}
break;
}
} else {
var seq__6900_6935 = cljs.core.seq.call(null,classes__$1);
var chunk__6901_6936 = null;
var count__6902_6937 = (0);
var i__6903_6938 = (0);
while(true){
if((i__6903_6938 < count__6902_6937)){
var c_6939 = cljs.core._nth.call(null,chunk__6901_6936,i__6903_6938);
var class_name_6940 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_6940,c_6939))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_6940 === ""))?c_6939:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_6940)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_6939)].join('')));
}


var G__6941 = seq__6900_6935;
var G__6942 = chunk__6901_6936;
var G__6943 = count__6902_6937;
var G__6944 = (i__6903_6938 + (1));
seq__6900_6935 = G__6941;
chunk__6901_6936 = G__6942;
count__6902_6937 = G__6943;
i__6903_6938 = G__6944;
continue;
} else {
var temp__5457__auto___6945 = cljs.core.seq.call(null,seq__6900_6935);
if(temp__5457__auto___6945){
var seq__6900_6946__$1 = temp__5457__auto___6945;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6900_6946__$1)){
var c__4550__auto___6947 = cljs.core.chunk_first.call(null,seq__6900_6946__$1);
var G__6948 = cljs.core.chunk_rest.call(null,seq__6900_6946__$1);
var G__6949 = c__4550__auto___6947;
var G__6950 = cljs.core.count.call(null,c__4550__auto___6947);
var G__6951 = (0);
seq__6900_6935 = G__6948;
chunk__6901_6936 = G__6949;
count__6902_6937 = G__6950;
i__6903_6938 = G__6951;
continue;
} else {
var c_6952 = cljs.core.first.call(null,seq__6900_6946__$1);
var class_name_6953 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_6953,c_6952))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_6953 === ""))?c_6952:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name_6953)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c_6952)].join('')));
}


var G__6954 = cljs.core.next.call(null,seq__6900_6946__$1);
var G__6955 = null;
var G__6956 = (0);
var G__6957 = (0);
seq__6900_6935 = G__6954;
chunk__6901_6936 = G__6955;
count__6902_6937 = G__6956;
i__6903_6938 = G__6957;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__6904_6958 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__6905_6959 = null;
var count__6906_6960 = (0);
var i__6907_6961 = (0);
while(true){
if((i__6907_6961 < count__6906_6960)){
var c_6962 = cljs.core._nth.call(null,chunk__6905_6959,i__6907_6961);
dommy.core.add_class_BANG_.call(null,elem,c_6962);


var G__6963 = seq__6904_6958;
var G__6964 = chunk__6905_6959;
var G__6965 = count__6906_6960;
var G__6966 = (i__6907_6961 + (1));
seq__6904_6958 = G__6963;
chunk__6905_6959 = G__6964;
count__6906_6960 = G__6965;
i__6907_6961 = G__6966;
continue;
} else {
var temp__5457__auto___6967 = cljs.core.seq.call(null,seq__6904_6958);
if(temp__5457__auto___6967){
var seq__6904_6968__$1 = temp__5457__auto___6967;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6904_6968__$1)){
var c__4550__auto___6969 = cljs.core.chunk_first.call(null,seq__6904_6968__$1);
var G__6970 = cljs.core.chunk_rest.call(null,seq__6904_6968__$1);
var G__6971 = c__4550__auto___6969;
var G__6972 = cljs.core.count.call(null,c__4550__auto___6969);
var G__6973 = (0);
seq__6904_6958 = G__6970;
chunk__6905_6959 = G__6971;
count__6906_6960 = G__6972;
i__6907_6961 = G__6973;
continue;
} else {
var c_6974 = cljs.core.first.call(null,seq__6904_6968__$1);
dommy.core.add_class_BANG_.call(null,elem,c_6974);


var G__6975 = cljs.core.next.call(null,seq__6904_6968__$1);
var G__6976 = null;
var G__6977 = (0);
var G__6978 = (0);
seq__6904_6958 = G__6975;
chunk__6905_6959 = G__6976;
count__6906_6960 = G__6977;
i__6907_6961 = G__6978;
continue;
}
} else {
}
}
break;
}

return elem;
});

/** @this {Function} */
dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq6892){
var G__6893 = cljs.core.first.call(null,seq6892);
var seq6892__$1 = cljs.core.next.call(null,seq6892);
var G__6894 = cljs.core.first.call(null,seq6892__$1);
var seq6892__$2 = cljs.core.next.call(null,seq6892__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6893,G__6894,seq6892__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var G__6983 = arguments.length;
switch (G__6983) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___6989 = arguments.length;
var i__4731__auto___6990 = (0);
while(true){
if((i__4731__auto___6990 < len__4730__auto___6989)){
args_arr__4751__auto__.push((arguments[i__4731__auto___6990]));

var G__6991 = (i__4731__auto___6990 + (1));
i__4731__auto___6990 = G__6991;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__5455__auto___6992 = elem.classList;
if(cljs.core.truth_(temp__5455__auto___6992)){
var class_list_6993 = temp__5455__auto___6992;
class_list_6993.remove(c__$1);
} else {
var class_name_6994 = dommy.core.class$.call(null,elem);
var new_class_name_6995 = dommy.utils.remove_class_str.call(null,class_name_6994,c__$1);
if((class_name_6994 === new_class_name_6995)){
} else {
dommy.core.set_class_BANG_.call(null,elem,new_class_name_6995);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__6984 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__6985 = null;
var count__6986 = (0);
var i__6987 = (0);
while(true){
if((i__6987 < count__6986)){
var c = cljs.core._nth.call(null,chunk__6985,i__6987);
dommy.core.remove_class_BANG_.call(null,elem,c);


var G__6996 = seq__6984;
var G__6997 = chunk__6985;
var G__6998 = count__6986;
var G__6999 = (i__6987 + (1));
seq__6984 = G__6996;
chunk__6985 = G__6997;
count__6986 = G__6998;
i__6987 = G__6999;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__6984);
if(temp__5457__auto__){
var seq__6984__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6984__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__6984__$1);
var G__7000 = cljs.core.chunk_rest.call(null,seq__6984__$1);
var G__7001 = c__4550__auto__;
var G__7002 = cljs.core.count.call(null,c__4550__auto__);
var G__7003 = (0);
seq__6984 = G__7000;
chunk__6985 = G__7001;
count__6986 = G__7002;
i__6987 = G__7003;
continue;
} else {
var c = cljs.core.first.call(null,seq__6984__$1);
dommy.core.remove_class_BANG_.call(null,elem,c);


var G__7004 = cljs.core.next.call(null,seq__6984__$1);
var G__7005 = null;
var G__7006 = (0);
var G__7007 = (0);
seq__6984 = G__7004;
chunk__6985 = G__7005;
count__6986 = G__7006;
i__6987 = G__7007;
continue;
}
} else {
return null;
}
}
break;
}
});

/** @this {Function} */
dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq6980){
var G__6981 = cljs.core.first.call(null,seq6980);
var seq6980__$1 = cljs.core.next.call(null,seq6980);
var G__6982 = cljs.core.first.call(null,seq6980__$1);
var seq6980__$2 = cljs.core.next.call(null,seq6980__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__6981,G__6982,seq6980__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var G__7009 = arguments.length;
switch (G__7009) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__5455__auto___7011 = elem.classList;
if(cljs.core.truth_(temp__5455__auto___7011)){
var class_list_7012 = temp__5455__auto___7011;
class_list_7012.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.call(null,elem,c__$1,(!(dommy.core.has_class_QMARK_.call(null,elem,c__$1))));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.call(null,elem,class$);
} else {
dommy.core.remove_class_BANG_.call(null,elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var G__7014 = arguments.length;
switch (G__7014) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var G__7017 = arguments.length;
switch (G__7017) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var G__7023 = arguments.length;
switch (G__7023) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___7030 = arguments.length;
var i__4731__auto___7031 = (0);
while(true){
if((i__4731__auto___7031 < len__4730__auto___7030)){
args_arr__4751__auto__.push((arguments[i__4731__auto___7031]));

var G__7032 = (i__4731__auto___7031 + (1));
i__4731__auto___7031 = G__7032;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__7024 = parent;
G__7024.appendChild(child);

return G__7024;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__7025_7033 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__7026_7034 = null;
var count__7027_7035 = (0);
var i__7028_7036 = (0);
while(true){
if((i__7028_7036 < count__7027_7035)){
var c_7037 = cljs.core._nth.call(null,chunk__7026_7034,i__7028_7036);
dommy.core.append_BANG_.call(null,parent,c_7037);


var G__7038 = seq__7025_7033;
var G__7039 = chunk__7026_7034;
var G__7040 = count__7027_7035;
var G__7041 = (i__7028_7036 + (1));
seq__7025_7033 = G__7038;
chunk__7026_7034 = G__7039;
count__7027_7035 = G__7040;
i__7028_7036 = G__7041;
continue;
} else {
var temp__5457__auto___7042 = cljs.core.seq.call(null,seq__7025_7033);
if(temp__5457__auto___7042){
var seq__7025_7043__$1 = temp__5457__auto___7042;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7025_7043__$1)){
var c__4550__auto___7044 = cljs.core.chunk_first.call(null,seq__7025_7043__$1);
var G__7045 = cljs.core.chunk_rest.call(null,seq__7025_7043__$1);
var G__7046 = c__4550__auto___7044;
var G__7047 = cljs.core.count.call(null,c__4550__auto___7044);
var G__7048 = (0);
seq__7025_7033 = G__7045;
chunk__7026_7034 = G__7046;
count__7027_7035 = G__7047;
i__7028_7036 = G__7048;
continue;
} else {
var c_7049 = cljs.core.first.call(null,seq__7025_7043__$1);
dommy.core.append_BANG_.call(null,parent,c_7049);


var G__7050 = cljs.core.next.call(null,seq__7025_7043__$1);
var G__7051 = null;
var G__7052 = (0);
var G__7053 = (0);
seq__7025_7033 = G__7050;
chunk__7026_7034 = G__7051;
count__7027_7035 = G__7052;
i__7028_7036 = G__7053;
continue;
}
} else {
}
}
break;
}

return parent;
});

/** @this {Function} */
dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq7020){
var G__7021 = cljs.core.first.call(null,seq7020);
var seq7020__$1 = cljs.core.next.call(null,seq7020);
var G__7022 = cljs.core.first.call(null,seq7020__$1);
var seq7020__$2 = cljs.core.next.call(null,seq7020__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7021,G__7022,seq7020__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var G__7058 = arguments.length;
switch (G__7058) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___7065 = arguments.length;
var i__4731__auto___7066 = (0);
while(true){
if((i__4731__auto___7066 < len__4730__auto___7065)){
args_arr__4751__auto__.push((arguments[i__4731__auto___7066]));

var G__7067 = (i__4731__auto___7066 + (1));
i__4731__auto___7066 = G__7067;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__7059 = parent;
G__7059.insertBefore(child,parent.firstChild);

return G__7059;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__7060_7068 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__7061_7069 = null;
var count__7062_7070 = (0);
var i__7063_7071 = (0);
while(true){
if((i__7063_7071 < count__7062_7070)){
var c_7072 = cljs.core._nth.call(null,chunk__7061_7069,i__7063_7071);
dommy.core.prepend_BANG_.call(null,parent,c_7072);


var G__7073 = seq__7060_7068;
var G__7074 = chunk__7061_7069;
var G__7075 = count__7062_7070;
var G__7076 = (i__7063_7071 + (1));
seq__7060_7068 = G__7073;
chunk__7061_7069 = G__7074;
count__7062_7070 = G__7075;
i__7063_7071 = G__7076;
continue;
} else {
var temp__5457__auto___7077 = cljs.core.seq.call(null,seq__7060_7068);
if(temp__5457__auto___7077){
var seq__7060_7078__$1 = temp__5457__auto___7077;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7060_7078__$1)){
var c__4550__auto___7079 = cljs.core.chunk_first.call(null,seq__7060_7078__$1);
var G__7080 = cljs.core.chunk_rest.call(null,seq__7060_7078__$1);
var G__7081 = c__4550__auto___7079;
var G__7082 = cljs.core.count.call(null,c__4550__auto___7079);
var G__7083 = (0);
seq__7060_7068 = G__7080;
chunk__7061_7069 = G__7081;
count__7062_7070 = G__7082;
i__7063_7071 = G__7083;
continue;
} else {
var c_7084 = cljs.core.first.call(null,seq__7060_7078__$1);
dommy.core.prepend_BANG_.call(null,parent,c_7084);


var G__7085 = cljs.core.next.call(null,seq__7060_7078__$1);
var G__7086 = null;
var G__7087 = (0);
var G__7088 = (0);
seq__7060_7068 = G__7085;
chunk__7061_7069 = G__7086;
count__7062_7070 = G__7087;
i__7063_7071 = G__7088;
continue;
}
} else {
}
}
break;
}

return parent;
});

/** @this {Function} */
dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq7055){
var G__7056 = cljs.core.first.call(null,seq7055);
var seq7055__$1 = cljs.core.next.call(null,seq7055);
var G__7057 = cljs.core.first.call(null,seq7055__$1);
var seq7055__$2 = cljs.core.next.call(null,seq7055__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7056,G__7057,seq7055__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent.call(null,other);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__5455__auto___7089 = other.nextSibling;
if(cljs.core.truth_(temp__5455__auto___7089)){
var next_7090 = temp__5455__auto___7089;
dommy.core.insert_before_BANG_.call(null,elem,next_7090);
} else {
dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var G__7092 = arguments.length;
switch (G__7092) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error(["Assert failed: ","Target element must have a parent","\n","p"].join('')));
}

return dommy.core.remove_BANG_.call(null,p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__7093 = p;
G__7093.removeChild(elem);

return G__7093;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__7095){
var vec__7096 = p__7095;
var special_mouse_event = cljs.core.nth.call(null,vec__7096,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__7096,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.createAsIfByAssoc([real_mouse_event,((function (vec__7096,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__7096,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__4131__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__4120__auto__ = related_target;
if(cljs.core.truth_(and__4120__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__4120__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__7096,special_mouse_event,real_mouse_event))
});})(vec__7096,special_mouse_event,real_mouse_event))
])], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,elem,event.target,selector);
if(cljs.core.truth_((function (){var and__4120__auto__ = selected_target;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__4120__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__4131__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7102 = arguments.length;
var i__4731__auto___7103 = (0);
while(true){
if((i__4731__auto___7103 < len__4730__auto___7102)){
args__4736__auto__.push((arguments[i__4731__auto___7103]));

var G__7104 = (i__4731__auto___7103 + (1));
i__4731__auto___7103 = G__7104;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq7099){
var G__7100 = cljs.core.first.call(null,seq7099);
var seq7099__$1 = cljs.core.next.call(null,seq7099);
var G__7101 = cljs.core.first.call(null,seq7099__$1);
var seq7099__$2 = cljs.core.next.call(null,seq7099__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7100,G__7101,seq7099__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7186 = arguments.length;
var i__4731__auto___7187 = (0);
while(true){
if((i__4731__auto___7187 < len__4730__auto___7186)){
args__4736__auto__.push((arguments[i__4731__auto___7187]));

var G__7188 = (i__4731__auto___7187 + (1));
i__4731__auto___7187 = G__7188;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__7107_7189 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_7190 = cljs.core.nth.call(null,vec__7107_7189,(0),null);
var selector_7191 = cljs.core.nth.call(null,vec__7107_7189,(1),null);
var seq__7110_7192 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__7117_7193 = null;
var count__7118_7194 = (0);
var i__7119_7195 = (0);
while(true){
if((i__7119_7195 < count__7118_7194)){
var vec__7156_7196 = cljs.core._nth.call(null,chunk__7117_7193,i__7119_7195);
var orig_type_7197 = cljs.core.nth.call(null,vec__7156_7196,(0),null);
var f_7198 = cljs.core.nth.call(null,vec__7156_7196,(1),null);
var seq__7120_7199 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_7197,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_7197,cljs.core.identity])));
var chunk__7122_7200 = null;
var count__7123_7201 = (0);
var i__7124_7202 = (0);
while(true){
if((i__7124_7202 < count__7123_7201)){
var vec__7165_7203 = cljs.core._nth.call(null,chunk__7122_7200,i__7124_7202);
var actual_type_7204 = cljs.core.nth.call(null,vec__7165_7203,(0),null);
var factory_7205 = cljs.core.nth.call(null,vec__7165_7203,(1),null);
var canonical_f_7206 = (cljs.core.truth_(selector_7191)?cljs.core.partial.call(null,dommy.core.live_listener,elem_7190,selector_7191):cljs.core.identity).call(null,factory_7205.call(null,f_7198));
dommy.core.update_event_listeners_BANG_.call(null,elem_7190,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7191,actual_type_7204,f_7198], null),canonical_f_7206);

if(cljs.core.truth_(elem_7190.addEventListener)){
elem_7190.addEventListener(cljs.core.name.call(null,actual_type_7204),canonical_f_7206);
} else {
elem_7190.attachEvent(cljs.core.name.call(null,actual_type_7204),canonical_f_7206);
}


var G__7207 = seq__7120_7199;
var G__7208 = chunk__7122_7200;
var G__7209 = count__7123_7201;
var G__7210 = (i__7124_7202 + (1));
seq__7120_7199 = G__7207;
chunk__7122_7200 = G__7208;
count__7123_7201 = G__7209;
i__7124_7202 = G__7210;
continue;
} else {
var temp__5457__auto___7211 = cljs.core.seq.call(null,seq__7120_7199);
if(temp__5457__auto___7211){
var seq__7120_7212__$1 = temp__5457__auto___7211;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7120_7212__$1)){
var c__4550__auto___7213 = cljs.core.chunk_first.call(null,seq__7120_7212__$1);
var G__7214 = cljs.core.chunk_rest.call(null,seq__7120_7212__$1);
var G__7215 = c__4550__auto___7213;
var G__7216 = cljs.core.count.call(null,c__4550__auto___7213);
var G__7217 = (0);
seq__7120_7199 = G__7214;
chunk__7122_7200 = G__7215;
count__7123_7201 = G__7216;
i__7124_7202 = G__7217;
continue;
} else {
var vec__7168_7218 = cljs.core.first.call(null,seq__7120_7212__$1);
var actual_type_7219 = cljs.core.nth.call(null,vec__7168_7218,(0),null);
var factory_7220 = cljs.core.nth.call(null,vec__7168_7218,(1),null);
var canonical_f_7221 = (cljs.core.truth_(selector_7191)?cljs.core.partial.call(null,dommy.core.live_listener,elem_7190,selector_7191):cljs.core.identity).call(null,factory_7220.call(null,f_7198));
dommy.core.update_event_listeners_BANG_.call(null,elem_7190,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7191,actual_type_7219,f_7198], null),canonical_f_7221);

if(cljs.core.truth_(elem_7190.addEventListener)){
elem_7190.addEventListener(cljs.core.name.call(null,actual_type_7219),canonical_f_7221);
} else {
elem_7190.attachEvent(cljs.core.name.call(null,actual_type_7219),canonical_f_7221);
}


var G__7222 = cljs.core.next.call(null,seq__7120_7212__$1);
var G__7223 = null;
var G__7224 = (0);
var G__7225 = (0);
seq__7120_7199 = G__7222;
chunk__7122_7200 = G__7223;
count__7123_7201 = G__7224;
i__7124_7202 = G__7225;
continue;
}
} else {
}
}
break;
}

var G__7226 = seq__7110_7192;
var G__7227 = chunk__7117_7193;
var G__7228 = count__7118_7194;
var G__7229 = (i__7119_7195 + (1));
seq__7110_7192 = G__7226;
chunk__7117_7193 = G__7227;
count__7118_7194 = G__7228;
i__7119_7195 = G__7229;
continue;
} else {
var temp__5457__auto___7230 = cljs.core.seq.call(null,seq__7110_7192);
if(temp__5457__auto___7230){
var seq__7110_7231__$1 = temp__5457__auto___7230;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7110_7231__$1)){
var c__4550__auto___7232 = cljs.core.chunk_first.call(null,seq__7110_7231__$1);
var G__7233 = cljs.core.chunk_rest.call(null,seq__7110_7231__$1);
var G__7234 = c__4550__auto___7232;
var G__7235 = cljs.core.count.call(null,c__4550__auto___7232);
var G__7236 = (0);
seq__7110_7192 = G__7233;
chunk__7117_7193 = G__7234;
count__7118_7194 = G__7235;
i__7119_7195 = G__7236;
continue;
} else {
var vec__7171_7237 = cljs.core.first.call(null,seq__7110_7231__$1);
var orig_type_7238 = cljs.core.nth.call(null,vec__7171_7237,(0),null);
var f_7239 = cljs.core.nth.call(null,vec__7171_7237,(1),null);
var seq__7111_7240 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_7238,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_7238,cljs.core.identity])));
var chunk__7113_7241 = null;
var count__7114_7242 = (0);
var i__7115_7243 = (0);
while(true){
if((i__7115_7243 < count__7114_7242)){
var vec__7180_7244 = cljs.core._nth.call(null,chunk__7113_7241,i__7115_7243);
var actual_type_7245 = cljs.core.nth.call(null,vec__7180_7244,(0),null);
var factory_7246 = cljs.core.nth.call(null,vec__7180_7244,(1),null);
var canonical_f_7247 = (cljs.core.truth_(selector_7191)?cljs.core.partial.call(null,dommy.core.live_listener,elem_7190,selector_7191):cljs.core.identity).call(null,factory_7246.call(null,f_7239));
dommy.core.update_event_listeners_BANG_.call(null,elem_7190,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7191,actual_type_7245,f_7239], null),canonical_f_7247);

if(cljs.core.truth_(elem_7190.addEventListener)){
elem_7190.addEventListener(cljs.core.name.call(null,actual_type_7245),canonical_f_7247);
} else {
elem_7190.attachEvent(cljs.core.name.call(null,actual_type_7245),canonical_f_7247);
}


var G__7248 = seq__7111_7240;
var G__7249 = chunk__7113_7241;
var G__7250 = count__7114_7242;
var G__7251 = (i__7115_7243 + (1));
seq__7111_7240 = G__7248;
chunk__7113_7241 = G__7249;
count__7114_7242 = G__7250;
i__7115_7243 = G__7251;
continue;
} else {
var temp__5457__auto___7252__$1 = cljs.core.seq.call(null,seq__7111_7240);
if(temp__5457__auto___7252__$1){
var seq__7111_7253__$1 = temp__5457__auto___7252__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7111_7253__$1)){
var c__4550__auto___7254 = cljs.core.chunk_first.call(null,seq__7111_7253__$1);
var G__7255 = cljs.core.chunk_rest.call(null,seq__7111_7253__$1);
var G__7256 = c__4550__auto___7254;
var G__7257 = cljs.core.count.call(null,c__4550__auto___7254);
var G__7258 = (0);
seq__7111_7240 = G__7255;
chunk__7113_7241 = G__7256;
count__7114_7242 = G__7257;
i__7115_7243 = G__7258;
continue;
} else {
var vec__7183_7259 = cljs.core.first.call(null,seq__7111_7253__$1);
var actual_type_7260 = cljs.core.nth.call(null,vec__7183_7259,(0),null);
var factory_7261 = cljs.core.nth.call(null,vec__7183_7259,(1),null);
var canonical_f_7262 = (cljs.core.truth_(selector_7191)?cljs.core.partial.call(null,dommy.core.live_listener,elem_7190,selector_7191):cljs.core.identity).call(null,factory_7261.call(null,f_7239));
dommy.core.update_event_listeners_BANG_.call(null,elem_7190,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7191,actual_type_7260,f_7239], null),canonical_f_7262);

if(cljs.core.truth_(elem_7190.addEventListener)){
elem_7190.addEventListener(cljs.core.name.call(null,actual_type_7260),canonical_f_7262);
} else {
elem_7190.attachEvent(cljs.core.name.call(null,actual_type_7260),canonical_f_7262);
}


var G__7263 = cljs.core.next.call(null,seq__7111_7253__$1);
var G__7264 = null;
var G__7265 = (0);
var G__7266 = (0);
seq__7111_7240 = G__7263;
chunk__7113_7241 = G__7264;
count__7114_7242 = G__7265;
i__7115_7243 = G__7266;
continue;
}
} else {
}
}
break;
}

var G__7267 = cljs.core.next.call(null,seq__7110_7231__$1);
var G__7268 = null;
var G__7269 = (0);
var G__7270 = (0);
seq__7110_7192 = G__7267;
chunk__7117_7193 = G__7268;
count__7118_7194 = G__7269;
i__7119_7195 = G__7270;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq7105){
var G__7106 = cljs.core.first.call(null,seq7105);
var seq7105__$1 = cljs.core.next.call(null,seq7105);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7106,seq7105__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7352 = arguments.length;
var i__4731__auto___7353 = (0);
while(true){
if((i__4731__auto___7353 < len__4730__auto___7352)){
args__4736__auto__.push((arguments[i__4731__auto___7353]));

var G__7354 = (i__4731__auto___7353 + (1));
i__4731__auto___7353 = G__7354;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__7273_7355 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_7356 = cljs.core.nth.call(null,vec__7273_7355,(0),null);
var selector_7357 = cljs.core.nth.call(null,vec__7273_7355,(1),null);
var seq__7276_7358 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__7283_7359 = null;
var count__7284_7360 = (0);
var i__7285_7361 = (0);
while(true){
if((i__7285_7361 < count__7284_7360)){
var vec__7322_7362 = cljs.core._nth.call(null,chunk__7283_7359,i__7285_7361);
var orig_type_7363 = cljs.core.nth.call(null,vec__7322_7362,(0),null);
var f_7364 = cljs.core.nth.call(null,vec__7322_7362,(1),null);
var seq__7286_7365 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_7363,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_7363,cljs.core.identity])));
var chunk__7288_7366 = null;
var count__7289_7367 = (0);
var i__7290_7368 = (0);
while(true){
if((i__7290_7368 < count__7289_7367)){
var vec__7331_7369 = cljs.core._nth.call(null,chunk__7288_7366,i__7290_7368);
var actual_type_7370 = cljs.core.nth.call(null,vec__7331_7369,(0),null);
var __7371 = cljs.core.nth.call(null,vec__7331_7369,(1),null);
var keys_7372 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7357,actual_type_7370,f_7364], null);
var canonical_f_7373 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_7356),keys_7372);
dommy.core.update_event_listeners_BANG_.call(null,elem_7356,dommy.utils.dissoc_in,keys_7372);

if(cljs.core.truth_(elem_7356.removeEventListener)){
elem_7356.removeEventListener(cljs.core.name.call(null,actual_type_7370),canonical_f_7373);
} else {
elem_7356.detachEvent(cljs.core.name.call(null,actual_type_7370),canonical_f_7373);
}


var G__7374 = seq__7286_7365;
var G__7375 = chunk__7288_7366;
var G__7376 = count__7289_7367;
var G__7377 = (i__7290_7368 + (1));
seq__7286_7365 = G__7374;
chunk__7288_7366 = G__7375;
count__7289_7367 = G__7376;
i__7290_7368 = G__7377;
continue;
} else {
var temp__5457__auto___7378 = cljs.core.seq.call(null,seq__7286_7365);
if(temp__5457__auto___7378){
var seq__7286_7379__$1 = temp__5457__auto___7378;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7286_7379__$1)){
var c__4550__auto___7380 = cljs.core.chunk_first.call(null,seq__7286_7379__$1);
var G__7381 = cljs.core.chunk_rest.call(null,seq__7286_7379__$1);
var G__7382 = c__4550__auto___7380;
var G__7383 = cljs.core.count.call(null,c__4550__auto___7380);
var G__7384 = (0);
seq__7286_7365 = G__7381;
chunk__7288_7366 = G__7382;
count__7289_7367 = G__7383;
i__7290_7368 = G__7384;
continue;
} else {
var vec__7334_7385 = cljs.core.first.call(null,seq__7286_7379__$1);
var actual_type_7386 = cljs.core.nth.call(null,vec__7334_7385,(0),null);
var __7387 = cljs.core.nth.call(null,vec__7334_7385,(1),null);
var keys_7388 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7357,actual_type_7386,f_7364], null);
var canonical_f_7389 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_7356),keys_7388);
dommy.core.update_event_listeners_BANG_.call(null,elem_7356,dommy.utils.dissoc_in,keys_7388);

if(cljs.core.truth_(elem_7356.removeEventListener)){
elem_7356.removeEventListener(cljs.core.name.call(null,actual_type_7386),canonical_f_7389);
} else {
elem_7356.detachEvent(cljs.core.name.call(null,actual_type_7386),canonical_f_7389);
}


var G__7390 = cljs.core.next.call(null,seq__7286_7379__$1);
var G__7391 = null;
var G__7392 = (0);
var G__7393 = (0);
seq__7286_7365 = G__7390;
chunk__7288_7366 = G__7391;
count__7289_7367 = G__7392;
i__7290_7368 = G__7393;
continue;
}
} else {
}
}
break;
}

var G__7394 = seq__7276_7358;
var G__7395 = chunk__7283_7359;
var G__7396 = count__7284_7360;
var G__7397 = (i__7285_7361 + (1));
seq__7276_7358 = G__7394;
chunk__7283_7359 = G__7395;
count__7284_7360 = G__7396;
i__7285_7361 = G__7397;
continue;
} else {
var temp__5457__auto___7398 = cljs.core.seq.call(null,seq__7276_7358);
if(temp__5457__auto___7398){
var seq__7276_7399__$1 = temp__5457__auto___7398;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7276_7399__$1)){
var c__4550__auto___7400 = cljs.core.chunk_first.call(null,seq__7276_7399__$1);
var G__7401 = cljs.core.chunk_rest.call(null,seq__7276_7399__$1);
var G__7402 = c__4550__auto___7400;
var G__7403 = cljs.core.count.call(null,c__4550__auto___7400);
var G__7404 = (0);
seq__7276_7358 = G__7401;
chunk__7283_7359 = G__7402;
count__7284_7360 = G__7403;
i__7285_7361 = G__7404;
continue;
} else {
var vec__7337_7405 = cljs.core.first.call(null,seq__7276_7399__$1);
var orig_type_7406 = cljs.core.nth.call(null,vec__7337_7405,(0),null);
var f_7407 = cljs.core.nth.call(null,vec__7337_7405,(1),null);
var seq__7277_7408 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_7406,cljs.core.PersistentArrayMap.createAsIfByAssoc([orig_type_7406,cljs.core.identity])));
var chunk__7279_7409 = null;
var count__7280_7410 = (0);
var i__7281_7411 = (0);
while(true){
if((i__7281_7411 < count__7280_7410)){
var vec__7346_7412 = cljs.core._nth.call(null,chunk__7279_7409,i__7281_7411);
var actual_type_7413 = cljs.core.nth.call(null,vec__7346_7412,(0),null);
var __7414 = cljs.core.nth.call(null,vec__7346_7412,(1),null);
var keys_7415 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7357,actual_type_7413,f_7407], null);
var canonical_f_7416 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_7356),keys_7415);
dommy.core.update_event_listeners_BANG_.call(null,elem_7356,dommy.utils.dissoc_in,keys_7415);

if(cljs.core.truth_(elem_7356.removeEventListener)){
elem_7356.removeEventListener(cljs.core.name.call(null,actual_type_7413),canonical_f_7416);
} else {
elem_7356.detachEvent(cljs.core.name.call(null,actual_type_7413),canonical_f_7416);
}


var G__7417 = seq__7277_7408;
var G__7418 = chunk__7279_7409;
var G__7419 = count__7280_7410;
var G__7420 = (i__7281_7411 + (1));
seq__7277_7408 = G__7417;
chunk__7279_7409 = G__7418;
count__7280_7410 = G__7419;
i__7281_7411 = G__7420;
continue;
} else {
var temp__5457__auto___7421__$1 = cljs.core.seq.call(null,seq__7277_7408);
if(temp__5457__auto___7421__$1){
var seq__7277_7422__$1 = temp__5457__auto___7421__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7277_7422__$1)){
var c__4550__auto___7423 = cljs.core.chunk_first.call(null,seq__7277_7422__$1);
var G__7424 = cljs.core.chunk_rest.call(null,seq__7277_7422__$1);
var G__7425 = c__4550__auto___7423;
var G__7426 = cljs.core.count.call(null,c__4550__auto___7423);
var G__7427 = (0);
seq__7277_7408 = G__7424;
chunk__7279_7409 = G__7425;
count__7280_7410 = G__7426;
i__7281_7411 = G__7427;
continue;
} else {
var vec__7349_7428 = cljs.core.first.call(null,seq__7277_7422__$1);
var actual_type_7429 = cljs.core.nth.call(null,vec__7349_7428,(0),null);
var __7430 = cljs.core.nth.call(null,vec__7349_7428,(1),null);
var keys_7431 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_7357,actual_type_7429,f_7407], null);
var canonical_f_7432 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_7356),keys_7431);
dommy.core.update_event_listeners_BANG_.call(null,elem_7356,dommy.utils.dissoc_in,keys_7431);

if(cljs.core.truth_(elem_7356.removeEventListener)){
elem_7356.removeEventListener(cljs.core.name.call(null,actual_type_7429),canonical_f_7432);
} else {
elem_7356.detachEvent(cljs.core.name.call(null,actual_type_7429),canonical_f_7432);
}


var G__7433 = cljs.core.next.call(null,seq__7277_7422__$1);
var G__7434 = null;
var G__7435 = (0);
var G__7436 = (0);
seq__7277_7408 = G__7433;
chunk__7279_7409 = G__7434;
count__7280_7410 = G__7435;
i__7281_7411 = G__7436;
continue;
}
} else {
}
}
break;
}

var G__7437 = cljs.core.next.call(null,seq__7276_7399__$1);
var G__7438 = null;
var G__7439 = (0);
var G__7440 = (0);
seq__7276_7358 = G__7437;
chunk__7283_7359 = G__7438;
count__7284_7360 = G__7439;
i__7285_7361 = G__7440;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq7271){
var G__7272 = cljs.core.first.call(null,seq7271);
var seq7271__$1 = cljs.core.next.call(null,seq7271);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7272,seq7271__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7462 = arguments.length;
var i__4731__auto___7463 = (0);
while(true){
if((i__4731__auto___7463 < len__4730__auto___7462)){
args__4736__auto__.push((arguments[i__4731__auto___7463]));

var G__7464 = (i__4731__auto___7463 + (1));
i__4731__auto___7463 = G__7464;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__7443_7465 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_7466 = cljs.core.nth.call(null,vec__7443_7465,(0),null);
var selector_7467 = cljs.core.nth.call(null,vec__7443_7465,(1),null);
var seq__7446_7468 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__7447_7469 = null;
var count__7448_7470 = (0);
var i__7449_7471 = (0);
while(true){
if((i__7449_7471 < count__7448_7470)){
var vec__7456_7472 = cljs.core._nth.call(null,chunk__7447_7469,i__7449_7471);
var type_7473 = cljs.core.nth.call(null,vec__7456_7472,(0),null);
var f_7474 = cljs.core.nth.call(null,vec__7456_7472,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_7473,((function (seq__7446_7468,chunk__7447_7469,count__7448_7470,i__7449_7471,vec__7456_7472,type_7473,f_7474,vec__7443_7465,elem_7466,selector_7467){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_7473,dommy$core$this_fn);

return f_7474.call(null,e);
});})(seq__7446_7468,chunk__7447_7469,count__7448_7470,i__7449_7471,vec__7456_7472,type_7473,f_7474,vec__7443_7465,elem_7466,selector_7467))
);


var G__7475 = seq__7446_7468;
var G__7476 = chunk__7447_7469;
var G__7477 = count__7448_7470;
var G__7478 = (i__7449_7471 + (1));
seq__7446_7468 = G__7475;
chunk__7447_7469 = G__7476;
count__7448_7470 = G__7477;
i__7449_7471 = G__7478;
continue;
} else {
var temp__5457__auto___7479 = cljs.core.seq.call(null,seq__7446_7468);
if(temp__5457__auto___7479){
var seq__7446_7480__$1 = temp__5457__auto___7479;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7446_7480__$1)){
var c__4550__auto___7481 = cljs.core.chunk_first.call(null,seq__7446_7480__$1);
var G__7482 = cljs.core.chunk_rest.call(null,seq__7446_7480__$1);
var G__7483 = c__4550__auto___7481;
var G__7484 = cljs.core.count.call(null,c__4550__auto___7481);
var G__7485 = (0);
seq__7446_7468 = G__7482;
chunk__7447_7469 = G__7483;
count__7448_7470 = G__7484;
i__7449_7471 = G__7485;
continue;
} else {
var vec__7459_7486 = cljs.core.first.call(null,seq__7446_7480__$1);
var type_7487 = cljs.core.nth.call(null,vec__7459_7486,(0),null);
var f_7488 = cljs.core.nth.call(null,vec__7459_7486,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_7487,((function (seq__7446_7468,chunk__7447_7469,count__7448_7470,i__7449_7471,vec__7459_7486,type_7487,f_7488,seq__7446_7480__$1,temp__5457__auto___7479,vec__7443_7465,elem_7466,selector_7467){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_7487,dommy$core$this_fn);

return f_7488.call(null,e);
});})(seq__7446_7468,chunk__7447_7469,count__7448_7470,i__7449_7471,vec__7459_7486,type_7487,f_7488,seq__7446_7480__$1,temp__5457__auto___7479,vec__7443_7465,elem_7466,selector_7467))
);


var G__7489 = cljs.core.next.call(null,seq__7446_7480__$1);
var G__7490 = null;
var G__7491 = (0);
var G__7492 = (0);
seq__7446_7468 = G__7489;
chunk__7447_7469 = G__7490;
count__7448_7470 = G__7491;
i__7449_7471 = G__7492;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq7441){
var G__7442 = cljs.core.first.call(null,seq7441);
var seq7441__$1 = cljs.core.next.call(null,seq7441);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7442,seq7441__$1);
});


//# sourceMappingURL=core.js.map
