// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__4402 = url;
var G__4402__$1 = ((imcljs.internal.utils.missing_http_QMARK__.call(null,url))?["http://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__4402)].join(''):G__4402);
if(imcljs.internal.utils.missing_service_QMARK__.call(null,url)){
return imcljs.internal.utils.append_.call(null,"/service",G__4402__$1);
} else {
return G__4402__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__4403){
var map__4404 = p__4403;
var map__4404__$1 = (((((!((map__4404 == null))))?(((((map__4404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4404):map__4404);
var old_list_details = map__4404__$1;
var old_list_name = cljs.core.get.call(null,map__4404__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__4404__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),".id"].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__){
return (function (state_4424){
var state_val_4425 = (state_4424[(1)]);
if((state_val_4425 === (1))){
var inst_4406 = cljs.core.List.EMPTY;
var inst_4407 = inst_4406;
var inst_4408 = chans;
var state_4424__$1 = (function (){var statearr_4426 = state_4424;
(statearr_4426[(7)] = inst_4408);

(statearr_4426[(8)] = inst_4407);

return statearr_4426;
})();
var statearr_4427_4438 = state_4424__$1;
(statearr_4427_4438[(2)] = null);

(statearr_4427_4438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4425 === (2))){
var inst_4408 = (state_4424[(7)]);
var inst_4410 = cljs.core.seq.call(null,inst_4408);
var state_4424__$1 = state_4424;
if(inst_4410){
var statearr_4428_4439 = state_4424__$1;
(statearr_4428_4439[(1)] = (4));

} else {
var statearr_4429_4440 = state_4424__$1;
(statearr_4429_4440[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4425 === (3))){
var inst_4422 = (state_4424[(2)]);
var state_4424__$1 = state_4424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4424__$1,inst_4422);
} else {
if((state_val_4425 === (4))){
var inst_4408 = (state_4424[(7)]);
var inst_4412 = cljs.core.first.call(null,inst_4408);
var state_4424__$1 = state_4424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4424__$1,(7),inst_4412);
} else {
if((state_val_4425 === (5))){
var inst_4407 = (state_4424[(8)]);
var state_4424__$1 = state_4424;
var statearr_4430_4441 = state_4424__$1;
(statearr_4430_4441[(2)] = inst_4407);

(statearr_4430_4441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4425 === (6))){
var inst_4420 = (state_4424[(2)]);
var state_4424__$1 = state_4424;
var statearr_4431_4442 = state_4424__$1;
(statearr_4431_4442[(2)] = inst_4420);

(statearr_4431_4442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4425 === (7))){
var inst_4408 = (state_4424[(7)]);
var inst_4407 = (state_4424[(8)]);
var inst_4414 = (state_4424[(2)]);
var inst_4415 = cljs.core.conj.call(null,inst_4407,inst_4414);
var inst_4416 = cljs.core.rest.call(null,inst_4408);
var inst_4407__$1 = inst_4415;
var inst_4408__$1 = inst_4416;
var state_4424__$1 = (function (){var statearr_4432 = state_4424;
(statearr_4432[(7)] = inst_4408__$1);

(statearr_4432[(8)] = inst_4407__$1);

return statearr_4432;
})();
var statearr_4433_4443 = state_4424__$1;
(statearr_4433_4443[(2)] = null);

(statearr_4433_4443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2429__auto__))
;
return ((function (switch__2334__auto__,c__2429__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____0 = (function (){
var statearr_4434 = [null,null,null,null,null,null,null,null,null];
(statearr_4434[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__);

(statearr_4434[(1)] = (1));

return statearr_4434;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____1 = (function (state_4424){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_4424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e4435){if((e4435 instanceof Object)){
var ex__2338__auto__ = e4435;
var statearr_4436_4444 = state_4424;
(statearr_4436_4444[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4445 = state_4424;
state_4424 = G__4445;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__ = function(state_4424){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____1.call(this,state_4424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__))
})();
var state__2431__auto__ = (function (){var statearr_4437 = f__2430__auto__.call(null);
(statearr_4437[(6)] = c__2429__auto__);

return statearr_4437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__))
);

return c__2429__auto__;
});

//# sourceMappingURL=utils.js.map
