// Compiled by ClojureScript 1.10.520 {}
goog.provide('inflections.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('no.en.core');
/**
 * Coerce the string `s` to the type of `obj`.
 */
inflections.core.coerce = (function inflections$core$coerce(obj,s){
if((obj instanceof cljs.core.Keyword)){
return cljs.core.keyword.call(null,s);
} else {
if((obj instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,s);
} else {
return s;

}
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
inflections.core.Rule = (function (pattern,replacement,__meta,__extmap,__hash){
this.pattern = pattern;
this.replacement = replacement;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

inflections.core.Rule.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k16824,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__16828 = k16824;
var G__16828__$1 = (((G__16828 instanceof cljs.core.Keyword))?G__16828.fqn:null);
switch (G__16828__$1) {
case "pattern":
return self__.pattern;

break;
case "replacement":
return self__.replacement;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k16824,else__4388__auto__);

}
});

inflections.core.Rule.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.call(null,((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__16829){
var vec__16830 = p__16829;
var k__4408__auto__ = cljs.core.nth.call(null,vec__16830,(0),null);
var v__4409__auto__ = cljs.core.nth.call(null,vec__16830,(1),null);
return f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__);
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

inflections.core.Rule.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4400__auto__,pr_pair__4402__auto__,"#inflections.core.Rule{",", ","}",opts__4401__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pattern","pattern",242135423),self__.pattern],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"replacement","replacement",-1836238839),self__.replacement],null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__16823){
var self__ = this;
var G__16823__$1 = this;
return (new cljs.core.RecordIter((0),G__16823__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"replacement","replacement",-1836238839)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

inflections.core.Rule.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

inflections.core.Rule.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1327743444 ^ cljs.core.hash_unordered_coll.call(null,coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
.call(null,this__4381__auto____$1);
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

inflections.core.Rule.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this16825,other16826){
var self__ = this;
var this16825__$1 = this;
return (((!((other16826 == null)))) && ((this16825__$1.constructor === other16826.constructor)) && (cljs.core._EQ_.call(null,this16825__$1.pattern,other16826.pattern)) && (cljs.core._EQ_.call(null,this16825__$1.replacement,other16826.replacement)) && (cljs.core._EQ_.call(null,this16825__$1.__extmap,other16826.__extmap)));
});

inflections.core.Rule.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"replacement","replacement",-1836238839),null,new cljs.core.Keyword(null,"pattern","pattern",242135423),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4395__auto__)),null));
}
});

inflections.core.Rule.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__16823){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__16833 = cljs.core.keyword_identical_QMARK_;
var expr__16834 = k__4393__auto__;
if(cljs.core.truth_(pred__16833.call(null,new cljs.core.Keyword(null,"pattern","pattern",242135423),expr__16834))){
return (new inflections.core.Rule(G__16823,self__.replacement,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__16833.call(null,new cljs.core.Keyword(null,"replacement","replacement",-1836238839),expr__16834))){
return (new inflections.core.Rule(self__.pattern,G__16823,self__.__meta,self__.__extmap,null));
} else {
return (new inflections.core.Rule(self__.pattern,self__.replacement,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4393__auto__,G__16823),null));
}
}
});

inflections.core.Rule.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pattern","pattern",242135423),self__.pattern,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"replacement","replacement",-1836238839),self__.replacement,null))], null),self__.__extmap));
});

inflections.core.Rule.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__16823){
var self__ = this;
var this__4384__auto____$1 = this;
return (new inflections.core.Rule(self__.pattern,self__.replacement,G__16823,self__.__extmap,self__.__hash));
});

inflections.core.Rule.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4391__auto__,(0)),cljs.core._nth.call(null,entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

inflections.core.Rule.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"replacement","replacement",-195707312,null)], null);
});

inflections.core.Rule.cljs$lang$type = true;

inflections.core.Rule.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"inflections.core/Rule",null,(1),null));
});

inflections.core.Rule.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write.call(null,writer__4429__auto__,"inflections.core/Rule");
});

/**
 * Positional factory function for inflections.core/Rule.
 */
inflections.core.__GT_Rule = (function inflections$core$__GT_Rule(pattern,replacement){
return (new inflections.core.Rule(pattern,replacement,null,null,null));
});

/**
 * Factory function for inflections.core/Rule, taking a map of keywords to field values.
 */
inflections.core.map__GT_Rule = (function inflections$core$map__GT_Rule(G__16827){
var extmap__4424__auto__ = (function (){var G__16836 = cljs.core.dissoc.call(null,G__16827,new cljs.core.Keyword(null,"pattern","pattern",242135423),new cljs.core.Keyword(null,"replacement","replacement",-1836238839));
if(cljs.core.record_QMARK_.call(null,G__16827)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__16836);
} else {
return G__16836;
}
})();
return (new inflections.core.Rule(new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(G__16827),new cljs.core.Keyword(null,"replacement","replacement",-1836238839).cljs$core$IFn$_invoke$arity$1(G__16827),null,cljs.core.not_empty.call(null,extmap__4424__auto__),null));
});

inflections.core.add_rule_BANG_ = (function inflections$core$add_rule_BANG_(rules,rule){
if((!(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.deref.call(null,rules)),rule)))){
return cljs.core.swap_BANG_.call(null,rules,cljs.core.conj,rule);
} else {
return null;
}
});
/**
 * Returns a seq of rules, where the pattern and replacement must be
 *   given in pairs of two elements.
 */
inflections.core.slurp_rules = (function inflections$core$slurp_rules(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16840 = arguments.length;
var i__4731__auto___16841 = (0);
while(true){
if((i__4731__auto___16841 < len__4730__auto___16840)){
args__4736__auto__.push((arguments[i__4731__auto___16841]));

var G__16842 = (i__4731__auto___16841 + (1));
i__4731__auto___16841 = G__16842;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

inflections.core.slurp_rules.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
return cljs.core.map.call(null,(function (p1__16838_SHARP_){
return cljs.core.apply.call(null,inflections.core.__GT_Rule,p1__16838_SHARP_);
}),cljs.core.partition.call(null,(2),patterns_and_replacements));
});

inflections.core.slurp_rules.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
inflections.core.slurp_rules.cljs$lang$applyTo = (function (seq16839){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16839));
});

inflections.core.resolve_rule = (function inflections$core$resolve_rule(rule,word){
if(cljs.core.truth_((function (){var and__4120__auto__ = rule;
if(cljs.core.truth_(and__4120__auto__)){
return word;
} else {
return and__4120__auto__;
}
})())){
var pattern = new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(rule);
var replacement = new cljs.core.Keyword(null,"replacement","replacement",-1836238839).cljs$core$IFn$_invoke$arity$1(rule);
if(cljs.core.truth_(cljs.core.re_find.call(null,pattern,word))){
return clojure.string.replace.call(null,word,pattern,replacement);
} else {
return null;
}
} else {
return null;
}
});
inflections.core.resolve_rules = (function inflections$core$resolve_rules(rules,word){
return cljs.core.first.call(null,cljs.core.keep.call(null,(function (p1__16843_SHARP_){
return inflections.core.resolve_rule.call(null,p1__16843_SHARP_,word);
}),rules));
});
/**
 * Resets the list of plural rules.
 */
inflections.core.reset_rules_BANG_ = (function inflections$core$reset_rules_BANG_(rules){
return cljs.core.reset_BANG_.call(null,rules,cljs.core.PersistentVector.EMPTY);
});
/**
 * Same as `clojure.core/name`, but keeps the namespace for keywords
 *   and symbols.
 */
inflections.core.str_name = (function inflections$core$str_name(x){
if((x == null)){
return x;
} else {
if(typeof x === 'string'){
return x;
} else {
if((((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)))){
var temp__5455__auto__ = cljs.core.namespace.call(null,x);
if(cljs.core.truth_(temp__5455__auto__)){
var ns = temp__5455__auto__;
return [ns,"/",cljs.core.name.call(null,x)].join('');
} else {
return cljs.core.name.call(null,x);
}
} else {
return null;
}
}
}
});
inflections.core._STAR_uncountable_words_STAR_ = cljs.core.atom.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 81, ["gossip",null,"sadness",null,"space",null,"happiness",null,"blood",null,"silver",null,"cotton",null,"species",null,"mist",null,"paper",null,"education",null,"wine",null,"up",null,"food",null,"sugar",null,"gold",null,"literature",null,"pork",null,"lightning",null,"sheep",null,"shopping",null,"fresh",null,"news",null,"pepper",null,"experience",null,"milk",null,"honey",null,"oxygen",null,"fiction",null,"luck",null,"vinegar",null,"coffee",null,"ground",null,"peanut",null,"confusion",null,"tennis",null,"power",null,"meat",null,"butter",null,"music",null,"luggage",null,"love",null,"grass",null,"knowledge",null,"time",null,"cheese",null,"jam",null,"thunder",null,"electricity",null,"gum",null,"sunshine",null,"history",null,"snow",null,"money",null,"wool",null,"rice",null,"series",null,"liquid",null,"equipment",null,"pressure",null,"oil",null,"information",null,"steam",null,"chewing",null,"petrol",null,"research",null,"patience",null,"toothpaste",null,"speed",null,"entertainment",null,"wood",null,"tea",null,"art",null,"washing",null,"forgiveness",null,"traffic",null,"alcohol",null,"ice",null,"homework",null,"fish",null,"air",null], null), null));
inflections.core._STAR_acronyms_STAR_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, ["hst","HST","nasa","NASA"], null));
/**
 * Returns the the acronym for `s` if it is one, otherwise nil.
 */
inflections.core.acronym = (function inflections$core$acronym(s){
if(cljs.core.truth_(s)){
var G__16844 = inflections.core.str_name.call(null,s);
var G__16844__$1 = (((G__16844 == null))?null:clojure.string.lower_case.call(null,G__16844));
var G__16844__$2 = (((G__16844__$1 == null))?null:cljs.core.get.call(null,cljs.core.deref.call(null,inflections.core._STAR_acronyms_STAR_),G__16844__$1));
if((G__16844__$2 == null)){
return null;
} else {
return inflections.core.coerce.call(null,s,G__16844__$2);
}
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*acronyms*`.
 */
inflections.core.add_acronym_BANG_ = (function inflections$core$add_acronym_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_acronyms_STAR_,cljs.core.assoc,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)),inflections.core.str_name.call(null,word));
});
/**
 * Delete `word` from the set of `*acronyms*`.
 */
inflections.core.delete_acronym_BANG_ = (function inflections$core$delete_acronym_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_acronyms_STAR_,cljs.core.dissoc,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
/**
 * Returns true if `s` is countable, otherwise false.
 */
inflections.core.countable_QMARK_ = (function inflections$core$countable_QMARK_(s){
if(cljs.core.truth_(s)){
return (!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,inflections.core._STAR_uncountable_words_STAR_),clojure.string.lower_case.call(null,inflections.core.str_name.call(null,s)))));
} else {
return null;
}
});
/**
 * Returns true if `x` is uncountable, otherwise false.
 */
inflections.core.uncountable_QMARK_ = (function inflections$core$uncountable_QMARK_(x){
if(cljs.core.truth_(x)){
return cljs.core.not.call(null,inflections.core.countable_QMARK_.call(null,x));
} else {
return null;
}
});
/**
 * Adds `word` to the set of `*uncountable-words*`.
 */
inflections.core.add_uncountable_BANG_ = (function inflections$core$add_uncountable_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_uncountable_words_STAR_,cljs.core.conj,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
/**
 * Delete `word` from the set of `*uncountable-words*`.
 */
inflections.core.delete_uncountable_BANG_ = (function inflections$core$delete_uncountable_BANG_(word){
return cljs.core.swap_BANG_.call(null,inflections.core._STAR_uncountable_words_STAR_,cljs.core.disj,clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
});
inflections.core._STAR_plural_rules_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
/**
 * Returns the plural of s.
 */
inflections.core.plural = (function inflections$core$plural(s){
var s__$1 = inflections.core.str_name.call(null,s);
if(cljs.core.truth_((function (){var or__4131__auto__ = clojure.string.blank_QMARK_.call(null,s__$1);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return inflections.core.uncountable_QMARK_.call(null,s__$1);
}
})())){
return s__$1;
} else {
return inflections.core.resolve_rules.call(null,cljs.core.rseq.call(null,cljs.core.deref.call(null,inflections.core._STAR_plural_rules_STAR_)),s__$1);
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (plural! #"$(?i)" "s")
 *          (plural! #"(ax|test)is$(?i)" "$1es"
 *                   #"(octop|vir)us$(?i)" "$1i")
 */
inflections.core.plural_BANG_ = (function inflections$core$plural_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16850 = arguments.length;
var i__4731__auto___16851 = (0);
while(true){
if((i__4731__auto___16851 < len__4730__auto___16850)){
args__4736__auto__.push((arguments[i__4731__auto___16851]));

var G__16852 = (i__4731__auto___16851 + (1));
i__4731__auto___16851 = G__16852;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

inflections.core.plural_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__16846 = cljs.core.seq.call(null,cljs.core.apply.call(null,inflections.core.slurp_rules,patterns_and_replacements));
var chunk__16847 = null;
var count__16848 = (0);
var i__16849 = (0);
while(true){
if((i__16849 < count__16848)){
var rule = cljs.core._nth.call(null,chunk__16847,i__16849);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_plural_rules_STAR_,rule);


var G__16853 = seq__16846;
var G__16854 = chunk__16847;
var G__16855 = count__16848;
var G__16856 = (i__16849 + (1));
seq__16846 = G__16853;
chunk__16847 = G__16854;
count__16848 = G__16855;
i__16849 = G__16856;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16846);
if(temp__5457__auto__){
var seq__16846__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16846__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__16846__$1);
var G__16857 = cljs.core.chunk_rest.call(null,seq__16846__$1);
var G__16858 = c__4550__auto__;
var G__16859 = cljs.core.count.call(null,c__4550__auto__);
var G__16860 = (0);
seq__16846 = G__16857;
chunk__16847 = G__16858;
count__16848 = G__16859;
i__16849 = G__16860;
continue;
} else {
var rule = cljs.core.first.call(null,seq__16846__$1);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_plural_rules_STAR_,rule);


var G__16861 = cljs.core.next.call(null,seq__16846__$1);
var G__16862 = null;
var G__16863 = (0);
var G__16864 = (0);
seq__16846 = G__16861;
chunk__16847 = G__16862;
count__16848 = G__16863;
i__16849 = G__16864;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.plural_BANG_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
inflections.core.plural_BANG_.cljs$lang$applyTo = (function (seq16845){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16845));
});

inflections.core.init_plural_rules_BANG_ = (function inflections$core$init_plural_rules_BANG_(){
return inflections.core.plural_BANG_.call(null,/$/i,"s",/s$/i,"s",/(ax|test)is$/i,"$1es",/(octop|vir)us$/i,"$1i",/(alias|status)$/i,"$1es",/(bu)s$/i,"$1ses",/(buffal|tomat)o$/i,"$1oes",/([ti])um$/i,"$1a",/sis$/i,"ses",/(?:([^f])fe|([lr])f)$/i,"$1$2ves",/(hive)$/i,"$1s",/([^aeiouy]|qu)y$/i,"$1ies",/(x|ch|ss|sh)$/i,"$1es",/(matr|vert|ind)(?:ix|ex)$/i,"$1ices",/([m|l])ouse$/i,"$1ice",/^(ox)$/i,"$1en",/(quiz)$/i,"$1zes");
});
inflections.core._STAR_singular_rules_STAR_ = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
/**
 * Returns the singular of s.
 */
inflections.core.singular = (function inflections$core$singular(s){
var s_SINGLEQUOTE_ = inflections.core.str_name.call(null,s);
if(cljs.core.not.call(null,inflections.core.uncountable_QMARK_.call(null,s_SINGLEQUOTE_))){
return inflections.core.coerce.call(null,s,(function (){var or__4131__auto__ = inflections.core.resolve_rules.call(null,cljs.core.rseq.call(null,cljs.core.deref.call(null,inflections.core._STAR_singular_rules_STAR_)),s_SINGLEQUOTE_);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return s_SINGLEQUOTE_;
}
})());
} else {
return s;
}
});
/**
 * Define rule(s) to map words from singular to plural.
 * 
 *   Examples: (singular! #"(n)ews$(?i)" "$1ews")
 *          (singular! #"(m)ovies$(?i)" "$1ovie"
 *                     #"([m|l])ice$(?i)" "$1ouse")
 */
inflections.core.singular_BANG_ = (function inflections$core$singular_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16870 = arguments.length;
var i__4731__auto___16871 = (0);
while(true){
if((i__4731__auto___16871 < len__4730__auto___16870)){
args__4736__auto__.push((arguments[i__4731__auto___16871]));

var G__16872 = (i__4731__auto___16871 + (1));
i__4731__auto___16871 = G__16872;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

inflections.core.singular_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (patterns_and_replacements){
var seq__16866 = cljs.core.seq.call(null,cljs.core.apply.call(null,inflections.core.slurp_rules,patterns_and_replacements));
var chunk__16867 = null;
var count__16868 = (0);
var i__16869 = (0);
while(true){
if((i__16869 < count__16868)){
var rule = cljs.core._nth.call(null,chunk__16867,i__16869);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_singular_rules_STAR_,rule);


var G__16873 = seq__16866;
var G__16874 = chunk__16867;
var G__16875 = count__16868;
var G__16876 = (i__16869 + (1));
seq__16866 = G__16873;
chunk__16867 = G__16874;
count__16868 = G__16875;
i__16869 = G__16876;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__16866);
if(temp__5457__auto__){
var seq__16866__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__16866__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__16866__$1);
var G__16877 = cljs.core.chunk_rest.call(null,seq__16866__$1);
var G__16878 = c__4550__auto__;
var G__16879 = cljs.core.count.call(null,c__4550__auto__);
var G__16880 = (0);
seq__16866 = G__16877;
chunk__16867 = G__16878;
count__16868 = G__16879;
i__16869 = G__16880;
continue;
} else {
var rule = cljs.core.first.call(null,seq__16866__$1);
inflections.core.add_rule_BANG_.call(null,inflections.core._STAR_singular_rules_STAR_,rule);


var G__16881 = cljs.core.next.call(null,seq__16866__$1);
var G__16882 = null;
var G__16883 = (0);
var G__16884 = (0);
seq__16866 = G__16881;
chunk__16867 = G__16882;
count__16868 = G__16883;
i__16869 = G__16884;
continue;
}
} else {
return null;
}
}
break;
}
});

inflections.core.singular_BANG_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
inflections.core.singular_BANG_.cljs$lang$applyTo = (function (seq16865){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq16865));
});

inflections.core.init_singular_rules_BANG_ = (function inflections$core$init_singular_rules_BANG_(){
return inflections.core.singular_BANG_.call(null,/s$/i,"",/(ss)$/i,"$1",/(n)ews$/i,"$1ews",/([ti])a$/i,"$1um",/((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)(sis|ses)$/i,"$1$2sis",/(^analy)(sis|ses)$/i,"$1sis",/([^f])ves$/i,"$1fe",/(hive)s$/i,"$1",/(tive)s$/i,"$1",/([lr])ves$/i,"$1f",/([^aeiouy]|qu)ies$/i,"$1y",/(s)eries$/i,"$1eries",/(m)ovies$/i,"$1ovie",/(x|ch|ss|sh)es$/i,"$1",/([m|l])ice$/i,"$1ouse",/(bus)(es)?$/i,"$1",/(o)es$/i,"$1",/(shoe)s$/i,"$1",/(cris|ax|test)(is|es)$/i,"$1is",/(octop|vir)(us|i)$/i,"$1us",/(alias|status)(es)?$/i,"$1",/^(ox)en/i,"$1",/(vert|ind)ices$/i,"$1ex",/(matr)ices$/i,"$1ix",/(quiz)zes$/i,"$1",/(database)s$/i,"$1");
});
inflections.core._STAR_irregular_words_STAR_ = cljs.core.atom.call(null,cljs.core.sorted_set.call(null));
/**
 * Returns true if `word` is an irregular word, otherwise false.
 */
inflections.core.irregular_QMARK_ = (function inflections$core$irregular_QMARK_(word){
if(cljs.core.truth_(word)){
return cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,inflections.core._STAR_irregular_words_STAR_),clojure.string.lower_case.call(null,inflections.core.str_name.call(null,word)));
} else {
return null;
}
});
/**
 * Add `singular` and `plural` to the set of `*irregular-words*`.
 */
inflections.core.add_irregular_BANG_ = (function inflections$core$add_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,singular));
var plural__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,plural));
inflections.core.delete_uncountable_BANG_.call(null,singular__$1);

inflections.core.delete_uncountable_BANG_.call(null,plural__$1);

inflections.core.singular_BANG_.call(null,cljs.core.re_pattern.call(null,["^",cljs.core.str.cljs$core$IFn$_invoke$arity$1(plural__$1),"$"].join('')),singular__$1);

inflections.core.plural_BANG_.call(null,cljs.core.re_pattern.call(null,["^",cljs.core.str.cljs$core$IFn$_invoke$arity$1(singular__$1),"$"].join('')),plural__$1);

cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,singular__$1);

return cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.conj,plural__$1);
});
/**
 * Delete `singular` and `plural` from the set of *irregular-words*.
 */
inflections.core.delete_irregular_BANG_ = (function inflections$core$delete_irregular_BANG_(singular,plural){
var singular__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,singular));
var plural__$1 = clojure.string.lower_case.call(null,inflections.core.str_name.call(null,plural));
cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,singular__$1);

return cljs.core.swap_BANG_.call(null,inflections.core._STAR_irregular_words_STAR_,cljs.core.disj,plural__$1);
});
inflections.core.init_irregular_words_BANG_ = (function inflections$core$init_irregular_words_BANG_(){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (p1__16885_SHARP_){
return inflections.core.add_irregular_BANG_.call(null,cljs.core.first.call(null,p1__16885_SHARP_),cljs.core.second.call(null,p1__16885_SHARP_));
}),new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["amenity","amenities"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["child","children"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["cow","kine"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["foot","feet"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["louse","lice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mailman","mailmen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["man","men"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["mouse","mice"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["move","moves"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ox","oxen"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["person","people"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["sex","sexes"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["tooth","teeth"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["woman","women"], null)], null)));
});
/**
 * Convert `word` to camel case. By default, camel-case converts to
 *   UpperCamelCase. If the argument to camel-case is set to :lower then
 *   camel-case produces lowerCamelCase.
 * 
 *   Examples:
 * 
 *  (camel-case "active_record")
 *  ;=> "ActiveRecord"
 * 
 *  (camel-case "active_record" :lower)
 *  ;=> "activeRecord"
 * 
 *  (camel-case "active_record/errors")
 *  ;=> "ActiveRecord/Errors"
 * 
 *  (camel-case "active_record/errors" :lower)
 *  ;=> "activeRecord/Errors"
 */
inflections.core.camel_case = (function inflections$core$camel_case(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16898 = arguments.length;
var i__4731__auto___16899 = (0);
while(true){
if((i__4731__auto___16899 < len__4730__auto___16898)){
args__4736__auto__.push((arguments[i__4731__auto___16899]));

var G__16900 = (i__4731__auto___16899 + (1));
i__4731__auto___16899 = G__16900;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

inflections.core.camel_case.cljs$core$IFn$_invoke$arity$variadic = (function (word,p__16891){
var vec__16892 = p__16891;
var mode = cljs.core.nth.call(null,vec__16892,(0),null);
if(cljs.core.truth_(word)){
return inflections.core.coerce.call(null,word,(function (){var word__$1 = inflections.core.str_name.call(null,word);
if(cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"lower","lower",1120320821))){
return inflections.core.camel_case.call(null,word__$1,clojure.string.lower_case);
} else {
if(cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"upper","upper",246243906))){
return inflections.core.camel_case.call(null,word__$1,clojure.string.upper_case);
} else {
if(cljs.core.fn_QMARK_.call(null,mode)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mode.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,word__$1)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.rest.call(null,inflections.core.camel_case.call(null,word__$1,null))))].join('');
} else {
return clojure.string.replace.call(null,clojure.string.replace.call(null,word__$1,/\/(.?)/,((function (word__$1,vec__16892,mode){
return (function (p1__16886_SHARP_){
return ["/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__16886_SHARP_,(1))))].join('');
});})(word__$1,vec__16892,mode))
),/(^|_|-)(.)/,((function (word__$1,vec__16892,mode){
return (function (p1__16888_SHARP_){
var vec__16895 = p1__16888_SHARP_;
var _ = cljs.core.nth.call(null,vec__16895,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__16895,(1),null);
var letter_to_uppercase = cljs.core.nth.call(null,vec__16895,(2),null);
return clojure.string.upper_case.call(null,letter_to_uppercase);
});})(word__$1,vec__16892,mode))
);

}
}
}
})());
} else {
return null;
}
});

inflections.core.camel_case.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
inflections.core.camel_case.cljs$lang$applyTo = (function (seq16889){
var G__16890 = cljs.core.first.call(null,seq16889);
var seq16889__$1 = cljs.core.next.call(null,seq16889);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16890,seq16889__$1);
});

/**
 * Convert the first letter in `word` to upper case.
 * 
 *   Examples:
 * 
 *  (capitalize "hello")
 *  ;=> "Hello"
 * 
 *  (capitalize "HELLO")
 *  ;=> "Hello"
 * 
 *  (capitalize "abc123")
 *  ;=> "Abc123"
 */
inflections.core.capitalize = (function inflections$core$capitalize(word){
if(cljs.core.truth_(word)){
var temp__5455__auto__ = inflections.core.acronym.call(null,word);
if(cljs.core.truth_(temp__5455__auto__)){
var acronym = temp__5455__auto__;
return acronym;
} else {
var word_SINGLEQUOTE_ = inflections.core.str_name.call(null,word);
return inflections.core.coerce.call(null,word,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.upper_case.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,word_SINGLEQUOTE_)))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.next.call(null,word_SINGLEQUOTE_))?clojure.string.lower_case.call(null,cljs.core.subs.call(null,word_SINGLEQUOTE_,(1))):null))].join(''));
}
} else {
return null;
}
});
/**
 * Convert `s` into a title.
 */
inflections.core.titleize = (function inflections$core$titleize(s){
if(cljs.core.truth_(s)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,inflections.core.capitalize,clojure.string.split.call(null,inflections.core.str_name.call(null,s),/[-_.\/ ]/)));
} else {
return null;
}
});
/**
 * Replaces all underscores in `s` with dashes.
 * 
 *   Examples:
 * 
 *  (dasherize "puni_puni")
 *  ;=> "puni-puni"
 */
inflections.core.dasherize = (function inflections$core$dasherize(s){
if(cljs.core.truth_(s)){
return inflections.core.coerce.call(null,s,clojure.string.replace.call(null,inflections.core.str_name.call(null,s),/_/,"-"));
} else {
return null;
}
});
/**
 * Removes the module part from `x`.
 * 
 *   Examples:
 * 
 *  (demodulize "inflections.MyRecord")
 *  ;=> "MyRecord"
 * 
 *  (demodulize "ActiveRecord::CoreExtensions::String::Inflections")
 *  ;=> "Inflections"
 * 
 *  (demodulize "Inflections")
 *  ;=> "Inflections"
 */
inflections.core.demodulize = (function inflections$core$demodulize(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/^.*(::|\.)/,""));
} else {
return null;
}
});
/**
 * Hyphenate x, which is the same as threading `x` through the str,
 *   underscore and dasherize fns.
 * 
 *   Examples:
 * 
 *  (hyphenate 'Continent)
 *  ; => "continent"
 * 
 *  (hyphenate "CountryFlag")
 *  ; => "country-flag"
 */
inflections.core.hyphenate = (function inflections$core$hyphenate(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/([A-Z]+)([A-Z][a-z])/,"$1-$2"),/([a-z\d])([A-Z])/,"$1-$2"),/\s+/,"-"),/_/,"-")));
} else {
return null;
}
});
/**
 * Turns `x` into an ordinal string used to denote the position in an
 *   ordered sequence such as 1st, 2nd, 3rd, 4th, etc.
 * 
 *   Examples:
 * 
 *  (ordinalize "1")
 *  ;=> "1st"
 * 
 *  (ordinalize "23")
 *  ;=> "23rd"
 */
inflections.core.ordinalize = (function inflections$core$ordinalize(x){
var temp__5455__auto__ = no.en.core.parse_integer.call(null,x);
if(cljs.core.truth_(temp__5455__auto__)){
var number = temp__5455__auto__;
if(cljs.core.contains_QMARK_.call(null,cljs.core.set.call(null,cljs.core.range.call(null,(11),(14))),cljs.core.mod.call(null,number,(100)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(number),"th"].join('');
} else {
var modulus = cljs.core.mod.call(null,number,(10));
if(cljs.core._EQ_.call(null,modulus,(1))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(number),"st"].join('');
} else {
if(cljs.core._EQ_.call(null,modulus,(2))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(number),"nd"].join('');
} else {
if(cljs.core._EQ_.call(null,modulus,(3))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(number),"rd"].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(number),"th"].join('');

}
}
}
}
} else {
return null;
}
});
/**
 * Replaces special characters in `x` with the default separator
 *   "-". so that it may be used as part of a pretty URL.
 * 
 *   Examples:
 * 
 *  (parameterize "Donald E. Knuth")
 *  ; => "donald-e-knuth"
 * 
 *  (parameterize "Donald E. Knuth" "_")
 *  ; => "donald_e_knuth"
 */
inflections.core.parameterize = (function inflections$core$parameterize(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16907 = arguments.length;
var i__4731__auto___16908 = (0);
while(true){
if((i__4731__auto___16908 < len__4730__auto___16907)){
args__4736__auto__.push((arguments[i__4731__auto___16908]));

var G__16909 = (i__4731__auto___16908 + (1));
i__4731__auto___16908 = G__16909;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

inflections.core.parameterize.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__16903){
var vec__16904 = p__16903;
var sep = cljs.core.nth.call(null,vec__16904,(0),null);
if(cljs.core.truth_(x)){
var sep__$1 = (function (){var or__4131__auto__ = sep;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "-";
}
})();
return clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/[^A-Za-z0-9]+/,sep__$1),/\++/,sep__$1),cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep__$1),"{2,}"].join('')),sep__$1),cljs.core.re_pattern.call(null,["(?i)(^",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep__$1),")|(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sep__$1),"$)"].join('')),""));
} else {
return null;
}
});

inflections.core.parameterize.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
inflections.core.parameterize.cljs$lang$applyTo = (function (seq16901){
var G__16902 = cljs.core.first.call(null,seq16901);
var seq16901__$1 = cljs.core.next.call(null,seq16901);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16902,seq16901__$1);
});

/**
 * Attempts to pluralize the word unless count is 1. If plural is
 *   supplied, it will use that when count is > 1, otherwise it will use
 *   the inflector to determine the plural form.
 */
inflections.core.pluralize = (function inflections$core$pluralize(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16917 = arguments.length;
var i__4731__auto___16918 = (0);
while(true){
if((i__4731__auto___16918 < len__4730__auto___16917)){
args__4736__auto__.push((arguments[i__4731__auto___16918]));

var G__16919 = (i__4731__auto___16918 + (1));
i__4731__auto___16918 = G__16919;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

inflections.core.pluralize.cljs$core$IFn$_invoke$arity$variadic = (function (count,singular,p__16913){
var vec__16914 = p__16913;
var plural = cljs.core.nth.call(null,vec__16914,(0),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.call(null,(1),count))?singular:(function (){var or__4131__auto__ = plural;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return inflections.core.plural.call(null,singular);
}
})()))].join('');
});

inflections.core.pluralize.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
inflections.core.pluralize.cljs$lang$applyTo = (function (seq16910){
var G__16911 = cljs.core.first.call(null,seq16910);
var seq16910__$1 = cljs.core.next.call(null,seq16910);
var G__16912 = cljs.core.first.call(null,seq16910__$1);
var seq16910__$2 = cljs.core.next.call(null,seq16910__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16911,G__16912,seq16910__$2);
});

/**
 * The reverse of camel-case. Makes an underscored, lowercase form from
 *   the expression in the string.
 * 
 *   Examples:
 * 
 *  (underscore "ActiveRecord")
 *  ;=> "active_record"
 * 
 *  (underscore "ActiveRecord::Errors")
 *  ;=> "active_record::errors"
 */
inflections.core.underscore = (function inflections$core$underscore(x){
if(cljs.core.truth_(x)){
return inflections.core.coerce.call(null,x,clojure.string.lower_case.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,inflections.core.str_name.call(null,x),/([A-Z\d]+)([A-Z][a-z])/,"$1_$2"),/([a-z\d])([A-Z])/,"$1_$2"),/-/,"_")));
} else {
return null;
}
});
/**
 * Converts `x` into a foreign key. The default separator "_" is
 *   placed between the name and "id".
 * 
 * 
 *   Examples:
 * 
 *  (foreign-key "Message")
 *  ;=> "message_id"
 * 
 *  (foreign-key "Message" false)
 *  ;=> "messageid"
 * 
 *  (foreign-key "Admin::Post")
 *  ;=> "post_id"
 */
inflections.core.foreign_key = (function inflections$core$foreign_key(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16926 = arguments.length;
var i__4731__auto___16927 = (0);
while(true){
if((i__4731__auto___16927 < len__4730__auto___16926)){
args__4736__auto__.push((arguments[i__4731__auto___16927]));

var G__16928 = (i__4731__auto___16927 + (1));
i__4731__auto___16927 = G__16928;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

inflections.core.foreign_key.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__16922){
var vec__16923 = p__16922;
var sep = cljs.core.nth.call(null,vec__16923,(0),null);
var x_SINGLEQUOTE_ = inflections.core.str_name.call(null,x);
if(clojure.string.blank_QMARK_.call(null,x_SINGLEQUOTE_)){
return null;
} else {
return inflections.core.coerce.call(null,x,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(inflections.core.underscore.call(null,inflections.core.hyphenate.call(null,inflections.core.singular.call(null,inflections.core.demodulize.call(null,x_SINGLEQUOTE_))))),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = sep;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "_";
}
})()),"id"].join(''));
}
});

inflections.core.foreign_key.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
inflections.core.foreign_key.cljs$lang$applyTo = (function (seq16920){
var G__16921 = cljs.core.first.call(null,seq16920);
var seq16920__$1 = cljs.core.next.call(null,seq16920);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16921,seq16920__$1);
});

/**
 * Recursively transform all keys in the map `m` by applying `f` on them.
 */
inflections.core.transform_keys = (function inflections$core$transform_keys(m,f){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (memo,key){
var value = cljs.core.get.call(null,m,key);
return cljs.core.assoc.call(null,cljs.core.dissoc.call(null,memo,key),f.call(null,key),((cljs.core.map_QMARK_.call(null,value))?inflections.core.transform_keys.call(null,value,f):((cljs.core.sequential_QMARK_.call(null,value))?cljs.core.map.call(null,((function (value){
return (function (p1__16929_SHARP_){
return inflections.core.transform_keys.call(null,p1__16929_SHARP_,f);
});})(value))
,value):value
)));
}),m,cljs.core.keys.call(null,m));
} else {
return m;
}
});
/**
 * Recursively transform all map values of m by applying f on them.
 */
inflections.core.transform_values = (function inflections$core$transform_values(m,f){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (memo,key){
var value = cljs.core.get.call(null,m,key);
return cljs.core.assoc.call(null,memo,key,((cljs.core.map_QMARK_.call(null,value))?inflections.core.transform_values.call(null,value,f):f.call(null,value)));
}),m,cljs.core.keys.call(null,m));
} else {
return m;
}
});
/**
 * Recursively apply camel-case on all keys of m.
 */
inflections.core.camel_case_keys = (function inflections$core$camel_case_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___16937 = arguments.length;
var i__4731__auto___16938 = (0);
while(true){
if((i__4731__auto___16938 < len__4730__auto___16937)){
args__4736__auto__.push((arguments[i__4731__auto___16938]));

var G__16939 = (i__4731__auto___16938 + (1));
i__4731__auto___16938 = G__16939;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

inflections.core.camel_case_keys.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__16933){
var vec__16934 = p__16933;
var mode = cljs.core.nth.call(null,vec__16934,(0),null);
return clojure.walk.keywordize_keys.call(null,inflections.core.transform_keys.call(null,m,((function (vec__16934,mode){
return (function (p1__16930_SHARP_){
return inflections.core.camel_case.call(null,p1__16930_SHARP_,mode);
});})(vec__16934,mode))
));
});

inflections.core.camel_case_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
inflections.core.camel_case_keys.cljs$lang$applyTo = (function (seq16931){
var G__16932 = cljs.core.first.call(null,seq16931);
var seq16931__$1 = cljs.core.next.call(null,seq16931);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__16932,seq16931__$1);
});

/**
 * Recursively apply hyphenate on all keys of m.
 */
inflections.core.hyphenate_keys = (function inflections$core$hyphenate_keys(m){
return inflections.core.transform_keys.call(null,m,inflections.core.hyphenate);
});
/**
 * Recursively apply hyphenate on all values of m.
 */
inflections.core.hyphenate_values = (function inflections$core$hyphenate_values(m){
return inflections.core.transform_values.call(null,m,inflections.core.hyphenate);
});
/**
 * Recursively transform all keys of m into strings.
 */
inflections.core.stringify_keys = (function inflections$core$stringify_keys(m){
return inflections.core.transform_keys.call(null,m,(function (p1__16940_SHARP_){
if((p1__16940_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name.call(null,p1__16940_SHARP_);
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16940_SHARP_);
}
}));
});
/**
 * Recursively transform all values of m into strings.
 */
inflections.core.stringify_values = (function inflections$core$stringify_values(m){
return inflections.core.transform_values.call(null,m,(function (p1__16941_SHARP_){
if((p1__16941_SHARP_ instanceof cljs.core.Keyword)){
return inflections.core.str_name.call(null,p1__16941_SHARP_);
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16941_SHARP_);
}
}));
});
/**
 * Recursively apply underscore on all keys of m.
 */
inflections.core.underscore_keys = (function inflections$core$underscore_keys(m){
return inflections.core.transform_keys.call(null,m,inflections.core.underscore);
});
/**
 * Initialize the Inflections library with defaults.
 */
inflections.core.init_inflections_BANG_ = (function inflections$core$init_inflections_BANG_(){
inflections.core.init_plural_rules_BANG_.call(null);

inflections.core.init_singular_rules_BANG_.call(null);

return inflections.core.init_irregular_words_BANG_.call(null);
});
inflections.core.init_inflections_BANG_.call(null);

//# sourceMappingURL=core.js.map
