// Compiled by ClojureScript 1.10.520 {}
goog.provide('json_html.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hiccups.runtime');
json_html.core.render_keyword = (function json_html$core$render_keyword(k){
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null,"/",cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.juxt.call(null,cljs.core.namespace,cljs.core.name).call(null,k))))].join('');
});
json_html.core.str_compare = (function json_html$core$str_compare(k1,k2){
return cljs.core.compare.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(k1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k2));
});
json_html.core.sort_map = (function json_html$core$sort_map(m){
var m__$1 = cljs.core.mapv.call(null,(function (p__16403){
var vec__16404 = p__16403;
var k = cljs.core.nth.call(null,vec__16404,(0),null);
var v = cljs.core.nth.call(null,vec__16404,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,cljs.core.type.call(null,k),Object))?cljs.core.js__GT_clj.call(null,k):k),v], null);
}),m);
try{return cljs.core.into.call(null,cljs.core.sorted_map.call(null),m__$1);
}catch (e16407){if((e16407 instanceof Error)){
var _ = e16407;
return cljs.core.into.call(null,cljs.core.sorted_map_by.call(null,json_html.core.str_compare),m__$1);
} else {
throw e16407;

}
}});
json_html.core.sort_set = (function json_html$core$sort_set(s){
try{return cljs.core.into.call(null,cljs.core.sorted_set.call(null),s);
}catch (e16408){if((e16408 instanceof Error)){
var _ = e16408;
return cljs.core.into.call(null,cljs.core.sorted_set_by.call(null,json_html.core.str_compare),s);
} else {
throw e16408;

}
}});
json_html.core.url_regex = cljs.core.re_pattern.call(null,"(\\b(https?|ftp|file|ldap)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]*[-A-Za-z0-9+&@#/%=~_|])");
/**
 * Make links clickable.
 */
json_html.core.linkify_links = (function json_html$core$linkify_links(string){
return clojure.string.replace.call(null,string,json_html.core.url_regex,"<a class='jh-type-string-link' href=$1>$1</a>");
});

/**
 * @interface
 */
json_html.core.Render = function(){};

/**
 * Renders the element a Hiccup structure
 */
json_html.core.render = (function json_html$core$render(this$){
if((((!((this$ == null)))) && ((!((this$.json_html$core$Render$render$arity$1 == null)))))){
return this$.json_html$core$Render$render$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (json_html.core.render[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,this$);
} else {
var m__4431__auto__ = (json_html.core.render["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Render.render",this$);
}
}
}
});

json_html.core.escape_html = (function json_html$core$escape_html(s){
return clojure.string.escape.call(null,s,new cljs.core.PersistentArrayMap(null, 4, ["&","&amp;",">","&gt;","<","&lt;","\"","&quot;"], null));
});

json_html.core.obj__GT_clj = (function json_html$core$obj__GT_clj(obj){
return cljs.core.reduce.call(null,(function (props,k){
return cljs.core.assoc.call(null,props,cljs.core.keyword.call(null,k),(obj[k]));
}),cljs.core.PersistentArrayMap.EMPTY,Object.keys(obj));
});


json_html.core.render_collection = (function json_html$core$render_collection(col){
if(cljs.core.empty_QMARK_.call(null,col)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.jh-type-object","div.jh-type-object",1704701538),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-empty-collection","span.jh-empty-collection",-107581393)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.jh-type-object","table.jh-type-object",-163995322),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__4523__auto__ = (function json_html$core$render_collection_$_iter__16409(s__16410){
return (new cljs.core.LazySeq(null,(function (){
var s__16410__$1 = s__16410;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__16410__$1);
if(temp__5457__auto__){
var s__16410__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16410__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__16410__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__16412 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__16411 = (0);
while(true){
if((i__16411 < size__4522__auto__)){
var vec__16413 = cljs.core._nth.call(null,c__4521__auto__,i__16411);
var i = cljs.core.nth.call(null,vec__16413,(0),null);
var v = cljs.core.nth.call(null,vec__16413,(1),null);
cljs.core.chunk_append.call(null,b__16412,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.jh-key.jh-array-key","th.jh-key.jh-array-key",-1623829832),i], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.jh-value.jh-array-value","td.jh-value.jh-array-value",1645079212),json_html.core.render_html.call(null,v)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__16437 = (i__16411 + (1));
i__16411 = G__16437;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16412),json_html$core$render_collection_$_iter__16409.call(null,cljs.core.chunk_rest.call(null,s__16410__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16412),null);
}
} else {
var vec__16416 = cljs.core.first.call(null,s__16410__$2);
var i = cljs.core.nth.call(null,vec__16416,(0),null);
var v = cljs.core.nth.call(null,vec__16416,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.jh-key.jh-array-key","th.jh-key.jh-array-key",-1623829832),i], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.jh-value.jh-array-value","td.jh-value.jh-array-value",1645079212),json_html.core.render_html.call(null,v)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),json_html$core$render_collection_$_iter__16409.call(null,cljs.core.rest.call(null,s__16410__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,col));
})()], null)], null);
}
});

json_html.core.render_set = (function json_html$core$render_set(s){
if(cljs.core.empty_QMARK_.call(null,s)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.jh-type-set","div.jh-type-set",-367189823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-empty-set","span.jh-empty-set",-1364654969)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4523__auto__ = (function json_html$core$render_set_$_iter__16419(s__16420){
return (new cljs.core.LazySeq(null,(function (){
var s__16420__$1 = s__16420;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__16420__$1);
if(temp__5457__auto__){
var s__16420__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16420__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__16420__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__16422 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__16421 = (0);
while(true){
if((i__16421 < size__4522__auto__)){
var item = cljs.core._nth.call(null,c__4521__auto__,i__16421);
cljs.core.chunk_append.call(null,b__16422,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.jh-value","li.jh-value",-344939266),json_html.core.render_html.call(null,item)], null));

var G__16438 = (i__16421 + (1));
i__16421 = G__16438;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16422),json_html$core$render_set_$_iter__16419.call(null,cljs.core.chunk_rest.call(null,s__16420__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16422),null);
}
} else {
var item = cljs.core.first.call(null,s__16420__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.jh-value","li.jh-value",-344939266),json_html.core.render_html.call(null,item)], null),json_html$core$render_set_$_iter__16419.call(null,cljs.core.rest.call(null,s__16420__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,json_html.core.sort_set.call(null,s));
})()], null);
}
});

json_html.core.render_map = (function json_html$core$render_map(m){
if(cljs.core.empty_QMARK_.call(null,m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.jh-type-object","div.jh-type-object",1704701538),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-empty-map","span.jh-empty-map",-2061532971)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.jh-type-object","table.jh-type-object",-163995322),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300),(function (){var iter__4523__auto__ = (function json_html$core$render_map_$_iter__16423(s__16424){
return (new cljs.core.LazySeq(null,(function (){
var s__16424__$1 = s__16424;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__16424__$1);
if(temp__5457__auto__){
var s__16424__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__16424__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__16424__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__16426 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__16425 = (0);
while(true){
if((i__16425 < size__4522__auto__)){
var vec__16427 = cljs.core._nth.call(null,c__4521__auto__,i__16425);
var k = cljs.core.nth.call(null,vec__16427,(0),null);
var v = cljs.core.nth.call(null,vec__16427,(1),null);
cljs.core.chunk_append.call(null,b__16426,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.jh-key.jh-object-key","th.jh-key.jh-object-key",1382268279),json_html.core.render_html.call(null,k)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.jh-value.jh-object-value","td.jh-value.jh-object-value",-2080818691),json_html.core.render_html.call(null,v)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)));

var G__16439 = (i__16425 + (1));
i__16425 = G__16439;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16426),json_html$core$render_map_$_iter__16423.call(null,cljs.core.chunk_rest.call(null,s__16424__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__16426),null);
}
} else {
var vec__16430 = cljs.core.first.call(null,s__16424__$2);
var k = cljs.core.nth.call(null,vec__16430,(0),null);
var v = cljs.core.nth.call(null,vec__16430,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th.jh-key.jh-object-key","th.jh-key.jh-object-key",1382268279),json_html.core.render_html.call(null,k)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.jh-value.jh-object-value","td.jh-value.jh-object-value",-2080818691),json_html.core.render_html.call(null,v)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),k], null)),json_html$core$render_map_$_iter__16423.call(null,cljs.core.rest.call(null,s__16424__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__.call(null,json_html.core.sort_map.call(null,m));
})()], null)], null);
}
});

json_html.core.render_string = (function json_html$core$render_string(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-string","span.jh-type-string",-94106783),((clojure.string.blank_QMARK_.call(null,s))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-empty-string","span.jh-empty-string",1227187446)], null):json_html.core.escape_html.call(null,s))], null);
});

json_html.core.render_html = (function json_html$core$render_html(v){
var t = cljs.core.type.call(null,v);
if((((!((v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === v.json_html$core$Render$))))?true:(((!v.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,json_html.core.Render,v):false)):cljs.core.native_satisfies_QMARK_.call(null,json_html.core.Render,v))){
return json_html.core.render.call(null,v);
} else {
if(cljs.core._EQ_.call(null,t,cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-string","span.jh-type-string",-94106783),json_html.core.render_keyword.call(null,v)], null);
} else {
if(cljs.core._EQ_.call(null,t,cljs.core.Symbol)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-string","span.jh-type-string",-94106783),cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)], null);
} else {
if(cljs.core._EQ_.call(null,t,String)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-string","span.jh-type-string",-94106783),json_html.core.render_string.call(null,v)], null);
} else {
if(cljs.core._EQ_.call(null,t,Date)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-date","span.jh-type-date",-1243309956),v.toString()], null);
} else {
if(cljs.core._EQ_.call(null,t,Boolean)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-bool","span.jh-type-bool",53751640),cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)], null);
} else {
if(cljs.core._EQ_.call(null,t,Number)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.jh-type-number","span.jh-type-number",1495617844),v], null);
} else {
if(cljs.core._EQ_.call(null,t,Array)){
return json_html.core.render_html.call(null,cljs.core.js__GT_clj.call(null,v));
} else {
if((((!((v == null))))?(((((v.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$IMap$))))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMap,v):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IMap,v))){
return json_html.core.render_map.call(null,v);
} else {
if((((!((v == null))))?(((((v.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$ISet$))))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISet,v):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ISet,v))){
return json_html.core.render_set.call(null,v);
} else {
if((((!((v == null))))?(((((v.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$ICollection$))))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICollection,v):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.ICollection,v))){
return json_html.core.render_collection.call(null,v);
} else {
if(cljs.core._EQ_.call(null,t,Object)){
return json_html.core.render_html.call(null,json_html.core.obj__GT_clj.call(null,v));
} else {
return null;

}
}
}
}
}
}
}
}
}
}
}
}
});

json_html.core.edn__GT_hiccup = (function json_html$core$edn__GT_hiccup(edn){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.jh-root","div.jh-root",-111047998),json_html.core.render_html.call(null,edn)], null);
});

json_html.core.edn__GT_html = (function json_html$core$edn__GT_html(edn){
return json_html.core.linkify_links.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(hiccups.runtime.render_html.call(null,json_html.core.edn__GT_hiccup.call(null,edn))));
});

json_html.core.json__GT_hiccup = (function json_html$core$json__GT_hiccup(json){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.jh-root","div.jh-root",-111047998),json_html.core.render_html.call(null,cljs.core.js__GT_clj.call(null,json))], null);
});

json_html.core.json__GT_html = (function json_html$core$json__GT_html(json){
return json_html.core.linkify_links.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(hiccups.runtime.render_html.call(null,json_html.core.json__GT_hiccup.call(null,json))));
});

//# sourceMappingURL=core.js.map
