// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__29401 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29401) : cljs.core.atom.call(null,G__29401));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__6753__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__6753__auto__)){
var req = temp__6753__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__29406){
var vec__29407 = p__29406;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29407,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29407,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__29411 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__29411)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__29411)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__29411)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__29411)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__29411)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__29411)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__29412){
var map__29416 = p__29412;
var map__29416__$1 = ((((!((map__29416 == null)))?((((map__29416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29416):map__29416);
var request = map__29416__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29416__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29416__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29416__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__7219__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__29418 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__29418,default_headers);

cljs_http.core.apply_response_type_BANG_(G__29418,response_type);

G__29418.setTimeoutInterval(timeout);

G__29418.setWithCredentials(send_credentials);

return G__29418;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__29419){
var map__29448 = p__29419;
var map__29448__$1 = ((((!((map__29448 == null)))?((((map__29448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29448.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29448):map__29448);
var request = map__29448__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29448__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__7219__auto__ = request_method;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__29450 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__29450) : cljs_http.core.error_kw.call(null,G__29450));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_29476 = ((function (channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__29451_29477 = xhr;
G__29451_29477.setProgressEventsEnabled(true);

G__29451_29477.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_29476,cljs.core.cst$kw$upload));

G__29451_29477.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_29476,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__17905__auto___29478 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_29462){
var state_val_29463 = (state_29462[(1)]);
if((state_val_29463 === (1))){
var state_29462__$1 = state_29462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29462__$1,(2),cancel);
} else {
if((state_val_29463 === (2))){
var inst_29453 = (state_29462[(2)]);
var inst_29454 = xhr.isComplete();
var inst_29455 = cljs.core.not(inst_29454);
var state_29462__$1 = (function (){var statearr_29464 = state_29462;
(statearr_29464[(7)] = inst_29453);

return statearr_29464;
})();
if(inst_29455){
var statearr_29465_29479 = state_29462__$1;
(statearr_29465_29479[(1)] = (3));

} else {
var statearr_29466_29480 = state_29462__$1;
(statearr_29466_29480[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29463 === (3))){
var inst_29457 = xhr.abort();
var state_29462__$1 = state_29462;
var statearr_29467_29481 = state_29462__$1;
(statearr_29467_29481[(2)] = inst_29457);

(statearr_29467_29481[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29463 === (4))){
var state_29462__$1 = state_29462;
var statearr_29468_29482 = state_29462__$1;
(statearr_29468_29482[(2)] = null);

(statearr_29468_29482[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29463 === (5))){
var inst_29460 = (state_29462[(2)]);
var state_29462__$1 = state_29462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29462__$1,inst_29460);
} else {
return null;
}
}
}
}
}
});})(c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__17779__auto__,c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__17780__auto__ = null;
var cljs_http$core$xhr_$_state_machine__17780__auto____0 = (function (){
var statearr_29472 = [null,null,null,null,null,null,null,null];
(statearr_29472[(0)] = cljs_http$core$xhr_$_state_machine__17780__auto__);

(statearr_29472[(1)] = (1));

return statearr_29472;
});
var cljs_http$core$xhr_$_state_machine__17780__auto____1 = (function (state_29462){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_29462);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e29473){if((e29473 instanceof Object)){
var ex__17783__auto__ = e29473;
var statearr_29474_29483 = state_29462;
(statearr_29474_29483[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29462);

return cljs.core.cst$kw$recur;
} else {
throw e29473;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__29484 = state_29462;
state_29462 = G__29484;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__17780__auto__ = function(state_29462){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__17780__auto____1.call(this,state_29462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__17780__auto____0;
cljs_http$core$xhr_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__17780__auto____1;
return cljs_http$core$xhr_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__17907__auto__ = (function (){var statearr_29475 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_29475[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___29478);

return statearr_29475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___29478,channel,request_url,method,headers__$1,xhr,map__29448,map__29448__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__29485){
var map__29502 = p__29485;
var map__29502__$1 = ((((!((map__29502 == null)))?((((map__29502.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29502.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29502):map__29502);
var request = map__29502__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29502__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29502__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29502__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29502__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_29518 = jsonp.send(null,((function (channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_29518], null));

if(cljs.core.truth_(cancel)){
var c__17905__auto___29519 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_29508){
var state_val_29509 = (state_29508[(1)]);
if((state_val_29509 === (1))){
var state_29508__$1 = state_29508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29508__$1,(2),cancel);
} else {
if((state_val_29509 === (2))){
var inst_29505 = (state_29508[(2)]);
var inst_29506 = jsonp.cancel(req_29518);
var state_29508__$1 = (function (){var statearr_29510 = state_29508;
(statearr_29510[(7)] = inst_29505);

return statearr_29510;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_29508__$1,inst_29506);
} else {
return null;
}
}
});})(c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__17779__auto__,c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__17780__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__17780__auto____0 = (function (){
var statearr_29514 = [null,null,null,null,null,null,null,null];
(statearr_29514[(0)] = cljs_http$core$jsonp_$_state_machine__17780__auto__);

(statearr_29514[(1)] = (1));

return statearr_29514;
});
var cljs_http$core$jsonp_$_state_machine__17780__auto____1 = (function (state_29508){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_29508);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e29515){if((e29515 instanceof Object)){
var ex__17783__auto__ = e29515;
var statearr_29516_29520 = state_29508;
(statearr_29516_29520[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29508);

return cljs.core.cst$kw$recur;
} else {
throw e29515;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__29521 = state_29508;
state_29508 = G__29521;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__17780__auto__ = function(state_29508){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__17780__auto____1.call(this,state_29508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__17780__auto____0;
cljs_http$core$jsonp_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__17780__auto____1;
return cljs_http$core$jsonp_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__17907__auto__ = (function (){var statearr_29517 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_29517[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___29519);

return statearr_29517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___29519,req_29518,channel,jsonp,map__29502,map__29502__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__29522){
var map__29525 = p__29522;
var map__29525__$1 = ((((!((map__29525 == null)))?((((map__29525.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29525.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29525):map__29525);
var request = map__29525__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29525__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
