// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.router');
goog.require('cljs.core');
goog.require('re_frame.events');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
re_frame.router.later_fns = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$flush_DASH_dom,(function (f){
var G__22570 = (function (){
return (re_frame.interop.next_tick.cljs$core$IFn$_invoke$arity$1 ? re_frame.interop.next_tick.cljs$core$IFn$_invoke$arity$1(f) : re_frame.interop.next_tick.call(null,f));
});
return (re_frame.interop.after_render.cljs$core$IFn$_invoke$arity$1 ? re_frame.interop.after_render.cljs$core$IFn$_invoke$arity$1(G__22570) : re_frame.interop.after_render.call(null,G__22570));
}),cljs.core.cst$kw$yield,re_frame.interop.next_tick], null);

/**
 * @interface
 */
re_frame.router.IEventQueue = function(){};

re_frame.router.push = (function re_frame$router$push(this$,event){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$push$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$push$arity$2(this$,event);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router.push[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto__.call(null,this$,event));
} else {
var m__7933__auto____$1 = (re_frame.router.push["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto____$1.call(null,this$,event));
} else {
throw cljs.core.missing_protocol("IEventQueue.push",this$);
}
}
}
});

re_frame.router.add_post_event_callback = (function re_frame$router$add_post_event_callback(this$,id,callack){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$add_post_event_callback$arity$3 == null)))){
return this$.re_frame$router$IEventQueue$add_post_event_callback$arity$3(this$,id,callack);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router.add_post_event_callback[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$3(this$,id,callack) : m__7933__auto__.call(null,this$,id,callack));
} else {
var m__7933__auto____$1 = (re_frame.router.add_post_event_callback["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,id,callack) : m__7933__auto____$1.call(null,this$,id,callack));
} else {
throw cljs.core.missing_protocol("IEventQueue.add-post-event-callback",this$);
}
}
}
});

re_frame.router.remove_post_event_callback = (function re_frame$router$remove_post_event_callback(this$,f){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$remove_post_event_callback$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$remove_post_event_callback$arity$2(this$,f);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router.remove_post_event_callback[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,f) : m__7933__auto__.call(null,this$,f));
} else {
var m__7933__auto____$1 = (re_frame.router.remove_post_event_callback["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,f) : m__7933__auto____$1.call(null,this$,f));
} else {
throw cljs.core.missing_protocol("IEventQueue.remove-post-event-callback",this$);
}
}
}
});

re_frame.router._fsm_trigger = (function re_frame$router$_fsm_trigger(this$,trigger,arg){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_fsm_trigger$arity$3 == null)))){
return this$.re_frame$router$IEventQueue$_fsm_trigger$arity$3(this$,trigger,arg);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._fsm_trigger[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$3(this$,trigger,arg) : m__7933__auto__.call(null,this$,trigger,arg));
} else {
var m__7933__auto____$1 = (re_frame.router._fsm_trigger["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,trigger,arg) : m__7933__auto____$1.call(null,this$,trigger,arg));
} else {
throw cljs.core.missing_protocol("IEventQueue.-fsm-trigger",this$);
}
}
}
});

re_frame.router._add_event = (function re_frame$router$_add_event(this$,event){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_add_event$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$_add_event$arity$2(this$,event);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._add_event[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto__.call(null,this$,event));
} else {
var m__7933__auto____$1 = (re_frame.router._add_event["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto____$1.call(null,this$,event));
} else {
throw cljs.core.missing_protocol("IEventQueue.-add-event",this$);
}
}
}
});

re_frame.router._process_1st_event_in_queue = (function re_frame$router$_process_1st_event_in_queue(this$){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_process_1st_event_in_queue$arity$1 == null)))){
return this$.re_frame$router$IEventQueue$_process_1st_event_in_queue$arity$1(this$);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._process_1st_event_in_queue[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto__.call(null,this$));
} else {
var m__7933__auto____$1 = (re_frame.router._process_1st_event_in_queue["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEventQueue.-process-1st-event-in-queue",this$);
}
}
}
});

re_frame.router._run_next_tick = (function re_frame$router$_run_next_tick(this$){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_run_next_tick$arity$1 == null)))){
return this$.re_frame$router$IEventQueue$_run_next_tick$arity$1(this$);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._run_next_tick[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto__.call(null,this$));
} else {
var m__7933__auto____$1 = (re_frame.router._run_next_tick["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEventQueue.-run-next-tick",this$);
}
}
}
});

re_frame.router._run_queue = (function re_frame$router$_run_queue(this$){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_run_queue$arity$1 == null)))){
return this$.re_frame$router$IEventQueue$_run_queue$arity$1(this$);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._run_queue[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto__.call(null,this$));
} else {
var m__7933__auto____$1 = (re_frame.router._run_queue["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEventQueue.-run-queue",this$);
}
}
}
});

re_frame.router._exception = (function re_frame$router$_exception(this$,ex){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_exception$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$_exception$arity$2(this$,ex);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._exception[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,ex) : m__7933__auto__.call(null,this$,ex));
} else {
var m__7933__auto____$1 = (re_frame.router._exception["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,ex) : m__7933__auto____$1.call(null,this$,ex));
} else {
throw cljs.core.missing_protocol("IEventQueue.-exception",this$);
}
}
}
});

re_frame.router._pause = (function re_frame$router$_pause(this$,later_fn){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_pause$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$_pause$arity$2(this$,later_fn);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._pause[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,later_fn) : m__7933__auto__.call(null,this$,later_fn));
} else {
var m__7933__auto____$1 = (re_frame.router._pause["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,later_fn) : m__7933__auto____$1.call(null,this$,later_fn));
} else {
throw cljs.core.missing_protocol("IEventQueue.-pause",this$);
}
}
}
});

re_frame.router._resume = (function re_frame$router$_resume(this$){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_resume$arity$1 == null)))){
return this$.re_frame$router$IEventQueue$_resume$arity$1(this$);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._resume[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto__.call(null,this$));
} else {
var m__7933__auto____$1 = (re_frame.router._resume["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7933__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IEventQueue.-resume",this$);
}
}
}
});

re_frame.router._call_post_event_callbacks = (function re_frame$router$_call_post_event_callbacks(this$,event){
if((!((this$ == null))) && (!((this$.re_frame$router$IEventQueue$_call_post_event_callbacks$arity$2 == null)))){
return this$.re_frame$router$IEventQueue$_call_post_event_callbacks$arity$2(this$,event);
} else {
var x__7932__auto__ = (((this$ == null))?null:this$);
var m__7933__auto__ = (re_frame.router._call_post_event_callbacks[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto__.call(null,this$,event));
} else {
var m__7933__auto____$1 = (re_frame.router._call_post_event_callbacks["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,event) : m__7933__auto____$1.call(null,this$,event));
} else {
throw cljs.core.missing_protocol("IEventQueue.-call-post-event-callbacks",this$);
}
}
}
});


/**
* @constructor
 * @implements {re_frame.router.IEventQueue}
*/
re_frame.router.EventQueue = (function (fsm_state,queue,post_event_callback_fns){
this.fsm_state = fsm_state;
this.queue = queue;
this.post_event_callback_fns = post_event_callback_fns;
})
re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$ = cljs.core.PROTOCOL_SENTINEL;

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_run_queue$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var n = cljs.core.count(self__.queue);
while(true){
if((n === (0))){
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$finish_DASH_run,null);
} else {
var temp__6751__auto__ = cljs.core.some(re_frame.router.later_fns,cljs.core.keys(cljs.core.meta(cljs.core.peek(self__.queue))));
if(cljs.core.truth_(temp__6751__auto__)){
var later_fn = temp__6751__auto__;
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$pause,later_fn);
} else {
re_frame.router._process_1st_event_in_queue(this$__$1);

var G__22582 = (n - (1));
n = G__22582;
continue;
}
}
break;
}
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$remove_post_event_callback$arity$2 = (function (_,id){
var self__ = this;
var ___$1 = this;
if(!(cljs.core.contains_QMARK_(self__.post_event_callback_fns,id))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.array_seq(["re-frame: could not remove post event call back with id: ",id], 0));
} else {
return self__.post_event_callback_fns = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.post_event_callback_fns,id);
}
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_add_event$arity$2 = (function (_,event){
var self__ = this;
var ___$1 = this;
return self__.queue = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.queue,event);
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_resume$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
re_frame.router._process_1st_event_in_queue(this$__$1);

return re_frame.router._run_queue(this$__$1);
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$push$arity$2 = (function (this$,event){
var self__ = this;
var this$__$1 = this;
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$add_DASH_event,event);
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_run_next_tick$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__22571 = ((function (this$__$1){
return (function (){
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$run_DASH_queue,null);
});})(this$__$1))
;
return (re_frame.interop.next_tick.cljs$core$IFn$_invoke$arity$1 ? re_frame.interop.next_tick.cljs$core$IFn$_invoke$arity$1(G__22571) : re_frame.interop.next_tick.call(null,G__22571));
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_fsm_trigger$arity$3 = (function (this$,trigger,arg){
var self__ = this;
var this$__$1 = this;
var vec__22572 = (function (){var G__22575 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.fsm_state,trigger], null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idle,cljs.core.cst$kw$add_DASH_event], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$scheduled,((function (G__22575,this$__$1){
return (function (){
re_frame.router._add_event(this$__$1,arg);

return re_frame.router._run_next_tick(this$__$1);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$scheduled,cljs.core.cst$kw$add_DASH_event], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$scheduled,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._add_event(this$__$1,arg);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$scheduled,cljs.core.cst$kw$run_DASH_queue], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._run_queue(this$__$1);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,cljs.core.cst$kw$add_DASH_event], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._add_event(this$__$1,arg);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,cljs.core.cst$kw$pause], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$paused,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._pause(this$__$1,arg);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,cljs.core.cst$kw$exception], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idle,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._exception(this$__$1,arg);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,cljs.core.cst$kw$finish_DASH_run], null),G__22575)){
if(cljs.core.empty_QMARK_(self__.queue)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idle], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$scheduled,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._run_next_tick(this$__$1);
});})(G__22575,this$__$1))
], null);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$paused,cljs.core.cst$kw$add_DASH_event], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$paused,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._add_event(this$__$1,arg);
});})(G__22575,this$__$1))
], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$paused,cljs.core.cst$kw$resume], null),G__22575)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$running,((function (G__22575,this$__$1){
return (function (){
return re_frame.router._resume(this$__$1);
});})(G__22575,this$__$1))
], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str("re-frame: router state transition not found. "),cljs.core.str(self__.fsm_state),cljs.core.str(" "),cljs.core.str(trigger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$fsm_DASH_state,self__.fsm_state,cljs.core.cst$kw$trigger,trigger], null));

}
}
}
}
}
}
}
}
}
})();
var new_fsm_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22572,(0),null);
var action_fn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22572,(1),null);
self__.fsm_state = new_fsm_state;

if(cljs.core.truth_(action_fn)){
return (action_fn.cljs$core$IFn$_invoke$arity$0 ? action_fn.cljs$core$IFn$_invoke$arity$0() : action_fn.call(null));
} else {
return null;
}
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_pause$arity$2 = (function (this$,later_fn){
var self__ = this;
var this$__$1 = this;
var G__22576 = ((function (this$__$1){
return (function (){
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$resume,null);
});})(this$__$1))
;
return (later_fn.cljs$core$IFn$_invoke$arity$1 ? later_fn.cljs$core$IFn$_invoke$arity$1(G__22576) : later_fn.call(null,G__22576));
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$add_post_event_callback$arity$3 = (function (_,id,callback_fn){
var self__ = this;
var ___$1 = this;
if(cljs.core.contains_QMARK_(self__.post_event_callback_fns,id)){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$warn,cljs.core.array_seq(["re-frame: overwriting existing post event call back with id: ",id], 0));
} else {
}

return self__.post_event_callback_fns = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.post_event_callback_fns,id,callback_fn);
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_process_1st_event_in_queue$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var event_v = cljs.core.peek(self__.queue);
try{re_frame.events.handle(event_v);

self__.queue = cljs.core.pop(self__.queue);

return re_frame.router._call_post_event_callbacks(this$__$1,event_v);
}catch (e22577){var ex = e22577;
return re_frame.router._fsm_trigger(this$__$1,cljs.core.cst$kw$exception,ex);
}});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_call_post_event_callbacks$arity$2 = (function (_,event_v){
var self__ = this;
var ___$1 = this;
var seq__22578 = cljs.core.seq(cljs.core.vals(self__.post_event_callback_fns));
var chunk__22579 = null;
var count__22580 = (0);
var i__22581 = (0);
while(true){
if((i__22581 < count__22580)){
var callback = chunk__22579.cljs$core$IIndexed$_nth$arity$2(null,i__22581);
(callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(event_v,self__.queue) : callback.call(null,event_v,self__.queue));

var G__22583 = seq__22578;
var G__22584 = chunk__22579;
var G__22585 = count__22580;
var G__22586 = (i__22581 + (1));
seq__22578 = G__22583;
chunk__22579 = G__22584;
count__22580 = G__22585;
i__22581 = G__22586;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__22578);
if(temp__6753__auto__){
var seq__22578__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22578__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__22578__$1);
var G__22587 = cljs.core.chunk_rest(seq__22578__$1);
var G__22588 = c__8125__auto__;
var G__22589 = cljs.core.count(c__8125__auto__);
var G__22590 = (0);
seq__22578 = G__22587;
chunk__22579 = G__22588;
count__22580 = G__22589;
i__22581 = G__22590;
continue;
} else {
var callback = cljs.core.first(seq__22578__$1);
(callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(event_v,self__.queue) : callback.call(null,event_v,self__.queue));

var G__22591 = cljs.core.next(seq__22578__$1);
var G__22592 = null;
var G__22593 = (0);
var G__22594 = (0);
seq__22578 = G__22591;
chunk__22579 = G__22592;
count__22580 = G__22593;
i__22581 = G__22594;
continue;
}
} else {
return null;
}
}
break;
}
});

re_frame.router.EventQueue.prototype.re_frame$router$IEventQueue$_exception$arity$2 = (function (_,ex){
var self__ = this;
var ___$1 = this;
self__.queue = re_frame.interop.empty_queue;

throw ex;
});

re_frame.router.EventQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fsm_DASH_state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$queue,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$post_DASH_event_DASH_callback_DASH_fns,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

re_frame.router.EventQueue.cljs$lang$type = true;

re_frame.router.EventQueue.cljs$lang$ctorStr = "re-frame.router/EventQueue";

re_frame.router.EventQueue.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"re-frame.router/EventQueue");
});

re_frame.router.__GT_EventQueue = (function re_frame$router$__GT_EventQueue(fsm_state,queue,post_event_callback_fns){
return (new re_frame.router.EventQueue(fsm_state,queue,post_event_callback_fns));
});

re_frame.router.event_queue = re_frame.router.__GT_EventQueue(cljs.core.cst$kw$idle,re_frame.interop.empty_queue,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Queue the given event for processing by the registered event handler.
 * 
 *   Just to be clear: the event handler is not run immediately - it is not run
 *   synchronously. It will likely be run 'very soon', although it may be
 *   added to the end of a FIFO queue which already contain events.
 * 
 *   Usage:
 *   (dispatch [:delete-item 42])
 */
re_frame.router.dispatch = (function re_frame$router$dispatch(event){
if((event == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("re-frame: you called \"dispatch\" without an event vector.",cljs.core.PersistentArrayMap.EMPTY);
} else {
re_frame.router.push(re_frame.router.event_queue,event);
}

return null;
});
/**
 * Sychronously (immediaetly!) process the given event using the registered handler.
 * 
 *   Generally, you shouldn't use this - you should use `dispatch` instead.  It
 *   is an error to use `dispatch-sync` within an event handler.
 * 
 *   Usage:
 *   (dispatch-sync [:delete-item 42])
 */
re_frame.router.dispatch_sync = (function re_frame$router$dispatch_sync(event_v){
re_frame.events.handle(event_v);

re_frame.router._call_post_event_callbacks(re_frame.router.event_queue,event_v);

return null;
});
