// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.enrichment.events');
goog.require('cljs.core');
goog.require('ajax.core');
goog.require('imcljs.fetch');
goog.require('imcljs.path');
goog.require('imcljsold.search');
goog.require('cljs.spec');
goog.require('cljs.core.async');
goog.require('imcljsold.filters');
goog.require('redgenes.interceptors');
goog.require('clojure.set');
goog.require('redgenes.sections.saveddata.events');
goog.require('accountant.core');
goog.require('dommy.core');
goog.require('re_frame.core');
goog.require('day8.re_frame.http_fx');
redgenes.components.enrichment.events.build_matches_query = (function redgenes$components$enrichment$events$build_matches_query(query,path_constraint,identifier){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(query),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$where], null),cljs.core.conj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,path_constraint,cljs.core.cst$kw$op,"ONE OF",cljs.core.cst$kw$values,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [identifier], null)], null));
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_get_DASH_item_DASH_details,(function (p__35188,p__35189){
var map__35190 = p__35188;
var map__35190__$1 = ((((!((map__35190 == null)))?((((map__35190.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35190.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35190):map__35190);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35190__$1,cljs.core.cst$kw$db);
var vec__35191 = p__35189;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35191,(0),null);
var identifier = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35191,(1),null);
var path_constraint = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35191,(2),null);
var source = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$package,cljs.core.cst$kw$source], null));
var model = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,source,cljs.core.cst$kw$service,cljs.core.cst$kw$model], null));
var classname = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(imcljs.path.class$(model,path_constraint));
var summary_fields = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$summary_DASH_fields,source,classname], null));
var service = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,source,cljs.core.cst$kw$service], null));
var summary_chan = imcljsold.search.raw_query_rows(service,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$from,classname,cljs.core.cst$kw$select,summary_fields,cljs.core.cst$kw$where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(path_constraint,".")),cljs.core.cst$kw$op,"=",cljs.core.cst$kw$value,identifier], null)], null)], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$summary_DASH_chan], null),summary_chan),cljs.core.cst$kw$get_DASH_summary_DASH_values,summary_chan], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_set_DASH_text_DASH_filter,(function (p__35195,p__35196){
var map__35197 = p__35195;
var map__35197__$1 = ((((!((map__35197 == null)))?((((map__35197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35197.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35197):map__35197);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35197__$1,cljs.core.cst$kw$db);
var vec__35198 = p__35196;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35198,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35198,(1),null);
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$text_DASH_filter], null),value)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$enrichment_SLASH_set_DASH_query,redgenes.interceptors.abort_spec(redgenes.specs.im_package),(function (p__35202,p__35203){
var map__35204 = p__35202;
var map__35204__$1 = ((((!((map__35204 == null)))?((((map__35204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35204.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35204):map__35204);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35204__$1,cljs.core.cst$kw$db);
var vec__35205 = p__35203;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35205,(0),null);
var map__35208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35205,(1),null);
var map__35208__$1 = ((((!((map__35208 == null)))?((((map__35208.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35208.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35208):map__35208);
var package$ = map__35208__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35208__$1,cljs.core.cst$kw$source);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35208__$1,cljs.core.cst$kw$value);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35208__$1,cljs.core.cst$kw$type);
var model = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,source,cljs.core.cst$kw$service,cljs.core.cst$kw$model,cljs.core.cst$kw$classes], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results], null),cljs.core.assoc,cljs.core.cst$kw$query,value,cljs.core.cst$kw$package,cljs.core.array_seq([package$,cljs.core.cst$kw$history,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [package$], null),cljs.core.cst$kw$history_DASH_index,(0),cljs.core.cst$kw$query_DASH_parts,imcljsold.filters.get_parts(model,value),cljs.core.cst$kw$enrichment_DASH_results,null], 0)),cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$enrichment_SLASH_enrich], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_replace_DASH_all_DASH_state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$fortable], null),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$settings,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$links,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$vocab,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mine,cljs.core.name(source)], null),cljs.core.cst$kw$on_DASH_click,((function (model,map__35204,map__35204__$1,db,vec__35205,_,map__35208,map__35208__$1,package$,source,value,type){
return (function (val){
return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1(val);
});})(model,map__35204,map__35204__$1,db,vec__35205,_,map__35208,map__35208__$1,package$,source,value,type))
], null)], null),cljs.core.cst$kw$query,value,cljs.core.cst$kw$service,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,source,cljs.core.cst$kw$service], null))], null)], null)], null)], null);
}));
/**
 * Returns list of columns in the results view that have widgets available for enrichment.
 */
redgenes.components.enrichment.events.what_we_can_enrich = (function redgenes$components$enrichment$events$what_we_can_enrich(widgets,query_parts){
var possible_roots = cljs.core.set(cljs.core.keys(query_parts));
var possible_enrichments = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (possible_roots){
return (function (x,y){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(x,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$targets.cljs$core$IFn$_invoke$arity$1(y))));
});})(possible_roots))
,cljs.core.PersistentHashSet.EMPTY,widgets);
var enrichable_roots = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(possible_enrichments,possible_roots);
return cljs.core.select_keys(query_parts,enrichable_roots);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_update_DASH_active_DASH_enrichment_DASH_column,(function (p__35211,p__35212){
var map__35213 = p__35211;
var map__35213__$1 = ((((!((map__35213 == null)))?((((map__35213.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35213.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35213):map__35213);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35213__$1,cljs.core.cst$kw$db);
var vec__35214 = p__35212;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35214,(0),null);
var new_enrichment_column = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35214,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_enrichment_DASH_column], null),new_enrichment_column),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results], null),cljs.core.dissoc,cljs.core.cst$kw$enrichment_DASH_results),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_results_DASH_loading_QMARK_], null),true),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$enrichment_SLASH_enrich], null)], null);
}));
/**
 * Returns whether or not the previously used enrichment column is within the list of existing column types.
 */
redgenes.components.enrichment.events.can_we_enrich_on_existing_preference_QMARK_ = (function redgenes$components$enrichment$events$can_we_enrich_on_existing_preference_QMARK_(enrichable,existing_enrichable){
var paths = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (new$,x){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new$,cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(x));
}),cljs.core.PersistentHashSet.EMPTY,cljs.core.flatten(cljs.core.vals(enrichable)));
return cljs.core.contains_QMARK_(paths,existing_enrichable);
});
/**
 * This is complex - we need to resolve which columns are of a suitable type to be enriched by a widget, and then select one. Where possible we try to always preserve the same column that the user was looking at in the previous enrichment, to ensure general consistency.
 */
redgenes.components.enrichment.events.resolve_what_to_enrich = (function redgenes$components$enrichment$events$resolve_what_to_enrich(db){
var query_parts = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$query_DASH_parts], null));
var widgets = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$widgets,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null));
var existing_enrichable_path = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_enrichment_DASH_column,cljs.core.cst$kw$path], null));
var existing_type = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_enrichment_DASH_column,cljs.core.cst$kw$type], null));
var enrichable = redgenes.components.enrichment.events.what_we_can_enrich(widgets,query_parts);
var use_existing_enrichable_QMARK_ = redgenes.components.enrichment.events.can_we_enrich_on_existing_preference_QMARK_(enrichable,existing_enrichable_path);
var enrichable_default = cljs.core.last(cljs.core.last(cljs.core.vals(enrichable)));
if(cljs.core.truth_(use_existing_enrichable_QMARK_)){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (query_parts,widgets,existing_enrichable_path,existing_type,enrichable,use_existing_enrichable_QMARK_,enrichable_default){
return (function (val){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(existing_enrichable_path,cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(val));
});})(query_parts,widgets,existing_enrichable_path,existing_type,enrichable,use_existing_enrichable_QMARK_,enrichable_default))
,(existing_type.cljs$core$IFn$_invoke$arity$1 ? existing_type.cljs$core$IFn$_invoke$arity$1(enrichable) : existing_type.call(null,enrichable))));
} else {
return enrichable_default;
}
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_enrich,(function (p__35218,p__35219){
var map__35220 = p__35218;
var map__35220__$1 = ((((!((map__35220 == null)))?((((map__35220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35220.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35220):map__35220);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35220__$1,cljs.core.cst$kw$db);
var vec__35221 = p__35219;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35221,(0),null);
var query_parts = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$query_DASH_parts], null));
var widgets = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$widgets,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null));
var enrichable = redgenes.components.enrichment.events.what_we_can_enrich(widgets,query_parts);
var what_to_enrich = redgenes.components.enrichment.events.resolve_what_to_enrich(db);
var can_enrich_QMARK_ = (cljs.core.count(enrichable) > (0));
var source_kw = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$package,cljs.core.cst$kw$source], null));
if(can_enrich_QMARK_){
var enrich_query = cljs.core.cst$kw$query.cljs$core$IFn$_invoke$arity$1(what_to_enrich);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_enrichment_DASH_column], null),what_to_enrich),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichable_DASH_columns], null),enrichable),cljs.core.cst$kw$fetch_DASH_ids_DASH_from_DASH_query,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,source_kw,cljs.core.cst$kw$service], null)),enrich_query,what_to_enrich], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,db], null);
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_update_DASH_enrichment_DASH_setting,(function (p__35225,p__35226){
var map__35227 = p__35225;
var map__35227__$1 = ((((!((map__35227 == null)))?((((map__35227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35227.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35227):map__35227);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35227__$1,cljs.core.cst$kw$db);
var vec__35228 = p__35226;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35228,(0),null);
var setting = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35228,(1),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35228,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_settings,setting], null),value),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$enrichment_SLASH_run_DASH_all_DASH_enrichment_DASH_queries], null)], null);
}));
/**
 * When the web service gives us a vector, we make it into a map for easy lookup
 */
redgenes.components.enrichment.events.widgets_to_map = (function redgenes$components$enrichment$events$widgets_to_map(widgets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (new_map,vals){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_map,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(vals)),vals);
}),cljs.core.PersistentArrayMap.EMPTY,widgets);
});
/**
 * We only want to load widgets that can be used on our datatypes
 */
redgenes.components.enrichment.events.get_suitable_widgets = (function redgenes$components$enrichment$events$get_suitable_widgets(array_widgets,classname){
var widgets = redgenes.components.enrichment.events.widgets_to_map(array_widgets);
if(cljs.core.truth_(classname)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (widgets){
return (function (p__35236){
var vec__35237 = p__35236;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35237,(0),null);
var widget = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35237,(1),null);
return cljs.core.contains_QMARK_(cljs.core.set(cljs.core.cst$kw$targets.cljs$core$IFn$_invoke$arity$1(widget)),cljs.core.name(cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(classname)));
});})(widgets))
,widgets));
} else {
return widgets;
}
});
redgenes.components.enrichment.events.build_enrichment_query = (function redgenes$components$enrichment$events$build_enrichment_query(selection,widget_name,settings){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$enrichment_SLASH_run,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([selection,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$maxp,0.05,cljs.core.cst$kw$widget,widget_name,cljs.core.cst$kw$correction,"Holm-Bonferroni"], null),settings], 0))], null);
});
redgenes.components.enrichment.events.build_all_enrichment_queries = (function redgenes$components$enrichment$events$build_all_enrichment_queries(selection,suitable_widgets,settings){

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (new_vec,p__35244){
var vec__35245 = p__35244;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35245,(0),null);
var vals = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35245,(1),null);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new_vec,redgenes.components.enrichment.events.build_enrichment_query(selection,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(vals),settings));
}),cljs.core.PersistentVector.EMPTY,suitable_widgets);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_run_DASH_all_DASH_enrichment_DASH_queries,(function (p__35248,p__35249){
var map__35250 = p__35248;
var map__35250__$1 = ((((!((map__35250 == null)))?((((map__35250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35250):map__35250);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35250__$1,cljs.core.cst$kw$db);
var vec__35251 = p__35249;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35251,(0),null);
var selection = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$ids,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$ids_DASH_to_DASH_enrich], null))], null);
var settings = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_settings], null));
var widgets = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$widgets,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null));
var enrichment_column = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_enrichment_DASH_column], null));
var suitable_widgets = redgenes.components.enrichment.events.get_suitable_widgets(widgets,enrichment_column);
var queries = redgenes.components.enrichment.events.build_all_enrichment_queries(selection,suitable_widgets,settings);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$active_DASH_widgets], null),suitable_widgets),cljs.core.cst$kw$dispatch_DASH_n,queries], null);
}));
redgenes.components.enrichment.events.service = (function redgenes$components$enrichment$events$service(db,mine_kw){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,mine_kw,cljs.core.cst$kw$service], null));
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_run,(function (p__35255,p__35256){
var map__35257 = p__35255;
var map__35257__$1 = ((((!((map__35257 == null)))?((((map__35257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35257.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35257):map__35257);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35257__$1,cljs.core.cst$kw$db);
var vec__35258 = p__35256;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35258,(0),null);
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35258,(1),null);
var enrichment_chan = imcljsold.search.enrichment(redgenes.components.enrichment.events.service(db,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$package,cljs.core.cst$kw$source], null))),params);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_results,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$widget.cljs$core$IFn$_invoke$arity$1(params))], null),null),cljs.core.cst$kw$enrichment_SLASH_get_DASH_enrichment,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$widget.cljs$core$IFn$_invoke$arity$1(params),enrichment_chan], null)], null);
}));
var G__35262_35285 = cljs.core.cst$kw$enrichment_SLASH_get_DASH_enrichment;
var G__35263_35286 = ((function (G__35262_35285){
return (function (p__35264){
var vec__35265 = p__35264;
var widget_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35265,(0),null);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35265,(1),null);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,vec__35265,widget_name,results,G__35262_35285){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,vec__35265,widget_name,results,G__35262_35285){
return (function (state_35275){
var state_val_35276 = (state_35275[(1)]);
if((state_val_35276 === (1))){
var inst_35268 = cljs.core.PersistentVector.EMPTY_NODE;
var state_35275__$1 = (function (){var statearr_35277 = state_35275;
(statearr_35277[(7)] = inst_35268);

return statearr_35277;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35275__$1,(2),results);
} else {
if((state_val_35276 === (2))){
var inst_35268 = (state_35275[(7)]);
var inst_35270 = (state_35275[(2)]);
var inst_35271 = [cljs.core.cst$kw$enrichment_SLASH_handle_DASH_results,widget_name,inst_35270];
var inst_35272 = (new cljs.core.PersistentVector(null,3,(5),inst_35268,inst_35271,null));
var inst_35273 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_35272) : re_frame.core.dispatch.call(null,inst_35272));
var state_35275__$1 = state_35275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35275__$1,inst_35273);
} else {
return null;
}
}
});})(c__14702__auto__,vec__35265,widget_name,results,G__35262_35285))
;
return ((function (switch__14623__auto__,c__14702__auto__,vec__35265,widget_name,results,G__35262_35285){
return (function() {
var redgenes$components$enrichment$events$state_machine__14624__auto__ = null;
var redgenes$components$enrichment$events$state_machine__14624__auto____0 = (function (){
var statearr_35281 = [null,null,null,null,null,null,null,null];
(statearr_35281[(0)] = redgenes$components$enrichment$events$state_machine__14624__auto__);

(statearr_35281[(1)] = (1));

return statearr_35281;
});
var redgenes$components$enrichment$events$state_machine__14624__auto____1 = (function (state_35275){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_35275);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e35282){if((e35282 instanceof Object)){
var ex__14627__auto__ = e35282;
var statearr_35283_35287 = state_35275;
(statearr_35283_35287[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35275);

return cljs.core.cst$kw$recur;
} else {
throw e35282;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__35288 = state_35275;
state_35275 = G__35288;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$enrichment$events$state_machine__14624__auto__ = function(state_35275){
switch(arguments.length){
case 0:
return redgenes$components$enrichment$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$enrichment$events$state_machine__14624__auto____1.call(this,state_35275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$enrichment$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$enrichment$events$state_machine__14624__auto____0;
redgenes$components$enrichment$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$enrichment$events$state_machine__14624__auto____1;
return redgenes$components$enrichment$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,vec__35265,widget_name,results,G__35262_35285))
})();
var state__14704__auto__ = (function (){var statearr_35284 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_35284[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_35284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,vec__35265,widget_name,results,G__35262_35285))
);

return c__14702__auto__;
});})(G__35262_35285))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__35262_35285,G__35263_35286) : re_frame.core.reg_fx.call(null,G__35262_35285,G__35263_35286));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$enrichment_SLASH_handle_DASH_results,(function (db,p__35289){
var vec__35290 = p__35289;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35290,(0),null);
var widget_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35290,(1),null);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35290,(2),null);
return cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_results,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(widget_name)], null),results),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results,cljs.core.cst$kw$enrichment_DASH_results_DASH_loading], null),false);
}));
