// Compiled by ClojureScript 1.9.89 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('reagent.impl.util');
goog.require('reagent.interop');
goog.require('reagent.ratom');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('cljsjs.react.dom');
goog.require('reagent.debug');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(cljs.core.some_QMARK_.call(null,reagent.dom.imported)){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__12249__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_14078 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_14078){
return (function (){
var _STAR_always_update_STAR_14079 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(cljs.core.some_QMARK_.call(null,callback)){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_14079;
}});})(_STAR_always_update_STAR_14078))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_14078;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args14080 = [];
var len__13324__auto___14083 = arguments.length;
var i__13325__auto___14084 = (0);
while(true){
if((i__13325__auto___14084 < len__13324__auto___14083)){
args14080.push((arguments[i__13325__auto___14084]));

var G__14085 = (i__13325__auto___14084 + (1));
i__13325__auto___14084 = G__14085;
continue;
} else {
}
break;
}

var G__14082 = args14080.length;
switch (G__14082) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14080.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
reagent.impl.template.find_dom_node = reagent.dom.dom_node;
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__14091_14095 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__14092_14096 = null;
var count__14093_14097 = (0);
var i__14094_14098 = (0);
while(true){
if((i__14094_14098 < count__14093_14097)){
var v_14099 = cljs.core._nth.call(null,chunk__14092_14096,i__14094_14098);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_14099);

var G__14100 = seq__14091_14095;
var G__14101 = chunk__14092_14096;
var G__14102 = count__14093_14097;
var G__14103 = (i__14094_14098 + (1));
seq__14091_14095 = G__14100;
chunk__14092_14096 = G__14101;
count__14093_14097 = G__14102;
i__14094_14098 = G__14103;
continue;
} else {
var temp__4657__auto___14104 = cljs.core.seq.call(null,seq__14091_14095);
if(temp__4657__auto___14104){
var seq__14091_14105__$1 = temp__4657__auto___14104;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14091_14105__$1)){
var c__13060__auto___14106 = cljs.core.chunk_first.call(null,seq__14091_14105__$1);
var G__14107 = cljs.core.chunk_rest.call(null,seq__14091_14105__$1);
var G__14108 = c__13060__auto___14106;
var G__14109 = cljs.core.count.call(null,c__13060__auto___14106);
var G__14110 = (0);
seq__14091_14095 = G__14107;
chunk__14092_14096 = G__14108;
count__14093_14097 = G__14109;
i__14094_14098 = G__14110;
continue;
} else {
var v_14111 = cljs.core.first.call(null,seq__14091_14105__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_14111);

var G__14112 = cljs.core.next.call(null,seq__14091_14105__$1);
var G__14113 = null;
var G__14114 = (0);
var G__14115 = (0);
seq__14091_14095 = G__14112;
chunk__14092_14096 = G__14113;
count__14093_14097 = G__14114;
i__14094_14098 = G__14115;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1473935445807