// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('im_tables.views.table.head.controls');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('im_tables.views.graphs.histogram');
goog.require('im_tables.views.common');
goog.require('oops.core');
im_tables.views.table.head.controls.filter_input = (function im_tables$views$table$head$controls$filter_input(){
return (function (loc,view,val){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$inline_DASH_filter,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_filter], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$value,val,cljs.core.cst$kw$placeholder,"Search for a value...",cljs.core.cst$kw$on_DASH_change,(function (e){
var G__33275 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_SLASH_set_DASH_text_DASH_filter,loc,view,(function (){var target_obj_33276 = e;
var next_obj_33277 = (target_obj_33276["target"]);
var next_obj_33278 = (next_obj_33277["value"]);
return next_obj_33278;
})()], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33275) : re_frame.core.dispatch.call(null,G__33275));
})], null)], null)], null);
});
});
/**
 * Force a dropdown to close 
 */
im_tables.views.table.head.controls.force_close = (function im_tables$views$table$head$controls$force_close(component){
var target_obj_33292 = (function (){var target_obj_33296 = (function (){var target_obj_33300 = (function (){var G__33304 = reagent.core.dom_node(component);
return $(G__33304);
})();
var call_info_33302 = [target_obj_33300,(function (){var next_obj_33303 = (target_obj_33300["closest"]);
return next_obj_33303;
})()];
var fn_33301 = (call_info_33302[(1)]);
if(!((fn_33301 == null))){
return fn_33301.call((call_info_33302[(0)]),".dropdown-menu");
} else {
return null;
}
})();
var call_info_33298 = [target_obj_33296,(function (){var next_obj_33299 = (target_obj_33296["parent"]);
return next_obj_33299;
})()];
var fn_33297 = (call_info_33298[(1)]);
if(!((fn_33297 == null))){
return fn_33297.call((call_info_33298[(0)]));
} else {
return null;
}
})();
var call_info_33294 = [target_obj_33292,(function (){var next_obj_33295 = (target_obj_33292["removeClass"]);
return next_obj_33295;
})()];
var fn_33293 = (call_info_33294[(1)]);
if(!((fn_33293 == null))){
return fn_33293.call((call_info_33294[(0)]),"open");
} else {
return null;
}
});
/**
 * Return true if a label contains a string
 */
im_tables.views.table.head.controls.has_text_QMARK_ = (function im_tables$views$table$head$controls$has_text_QMARK_(needle,haystack){
if(cljs.core.truth_(needle)){
var temp__6751__auto__ = cljs.core.cst$kw$item.cljs$core$IFn$_invoke$arity$1(haystack);
if(cljs.core.truth_(temp__6751__auto__)){
var text_to_search = temp__6751__auto__;
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(needle)].join('')),cljs.core.cst$kw$item.cljs$core$IFn$_invoke$arity$1(haystack));
} else {
return false;
}
} else {
return true;
}
});
im_tables.views.table.head.controls.constraint_has_path_QMARK_ = (function im_tables$views$table$head$controls$constraint_has_path_QMARK_(view,constraint){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view,cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(constraint));
});
im_tables.views.table.head.controls.constraint_dropdown = (function im_tables$views$table$head$controls$constraint_dropdown(){
return (function (p__33309){
var map__33310 = p__33309;
var map__33310__$1 = ((((!((map__33310 == null)))?((((map__33310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33310.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33310):map__33310);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33310__$1,cljs.core.cst$kw$value);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33310__$1,cljs.core.cst$kw$on_DASH_change);
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select$form_DASH_control,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,(cljs.core.truth_(value)?value:"="),cljs.core.cst$kw$on_DASH_change,((function (map__33310,map__33310__$1,value,on_change){
return (function (e){
var G__33312 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,e.target.value], null);
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__33312) : on_change.call(null,G__33312));
});})(map__33310,map__33310__$1,value,on_change))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,">"], null),"greater than"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"<"], null),"less than"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"="], null),"equal to"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"CONTAINS"], null),"contains"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"ONE OF"], null),"one of"], null)], null);
});
});
im_tables.views.table.head.controls.constraint_text = (function im_tables$views$table$head$controls$constraint_text(){
return (function (p__33317){
var map__33318 = p__33317;
var map__33318__$1 = ((((!((map__33318 == null)))?((((map__33318.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33318.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33318):map__33318);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33318__$1,cljs.core.cst$kw$value);
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33318__$1,cljs.core.cst$kw$on_DASH_change);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$on_DASH_change,((function (map__33318,map__33318__$1,value,on_change){
return (function (e){
var G__33320 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,e.target.value], null);
return (on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(G__33320) : on_change.call(null,G__33320));
});})(map__33318,map__33318__$1,value,on_change))
,cljs.core.cst$kw$value,value], null)], null);
});
});
im_tables.views.table.head.controls.blank_constraint = (function im_tables$views$table$head$controls$blank_constraint(loc,path){
var state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,path,cljs.core.cst$kw$op,"=",cljs.core.cst$kw$value,null], null));
return ((function (state){
return (function (loc__$1,path__$1){
var submit_constraint = ((function (state){
return (function (){
var G__33329 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_add_DASH_constraint,loc__$1,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))], null);
var G__33330 = (function (){var G__33331 = state;
var G__33332 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,path__$1,cljs.core.cst$kw$op,"=",cljs.core.cst$kw$value,null], null);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33331,G__33332) : cljs.core.reset_BANG_.call(null,G__33331,G__33332));
})();
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$2(G__33329,G__33330) : re_frame.core.dispatch.call(null,G__33329,G__33330));
});})(state))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$imtable_DASH_constraint,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$constraint_DASH_operator,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.constraint_dropdown,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))),cljs.core.cst$kw$on_DASH_change,((function (submit_constraint,state){
return (function (v){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$op,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(v));
});})(submit_constraint,state))
], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$constraint_DASH_input,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))),cljs.core.cst$kw$on_DASH_change,((function (submit_constraint,state){
return (function (e){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$value,e.target.value);
});})(submit_constraint,state))
,cljs.core.cst$kw$on_DASH_blur,((function (submit_constraint,state){
return (function (e){
if(!(clojure.string.blank_QMARK_(e.target.value))){
return submit_constraint();
} else {
return null;
}
});})(submit_constraint,state))
,cljs.core.cst$kw$on_DASH_key_DASH_press,((function (submit_constraint,state){
return (function (e){
var keycode = e.charCode;
var input = e.target.value;
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(13))) && (!(clojure.string.blank_QMARK_(input)))){
return submit_constraint();
} else {
return null;
}
});})(submit_constraint,state))
], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_success,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,((function (submit_constraint,state){
return (function (){
var G__33333 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_add_DASH_constraint,loc__$1,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))], null);
var G__33334 = (function (){var G__33335 = state;
var G__33336 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,path__$1,cljs.core.cst$kw$op,"=",cljs.core.cst$kw$value,null], null);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33335,G__33336) : cljs.core.reset_BANG_.call(null,G__33335,G__33336));
})();
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$2(G__33333,G__33334) : re_frame.core.dispatch.call(null,G__33333,G__33334));
});})(submit_constraint,state))
,cljs.core.cst$kw$type,"button"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_plus], null)], null)], null);
});
;})(state))
});
im_tables.views.table.head.controls.constraint = (function im_tables$views$table$head$controls$constraint(){
return (function (loc,p__33345){
var map__33346 = p__33345;
var map__33346__$1 = ((((!((map__33346 == null)))?((((map__33346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33346):map__33346);
var const$ = map__33346__$1;
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$path);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$op);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$value);
var values = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$values);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33346__$1,cljs.core.cst$kw$code);
var on_change = ((function (map__33346,map__33346__$1,const$,path,op,value,values,code){
return (function im_tables$views$table$head$controls$constraint_$_on_change(new_value){
var G__33351 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_update_DASH_constraint,loc,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([const$,new_value], 0))], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33351) : re_frame.core.dispatch.call(null,G__33351));
});})(map__33346,map__33346__$1,const$,path,op,value,values,code))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$imtable_DASH_constraint,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$constraint_DASH_operator,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.constraint_dropdown,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,op,cljs.core.cst$kw$on_DASH_change,on_change], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$constraint_DASH_input,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.constraint_text,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,(function (){var or__7219__auto__ = value;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return values;
}
})(),cljs.core.cst$kw$on_DASH_change,on_change], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_danger,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,((function (map__33346,map__33346__$1,const$,path,op,value,values,code){
return (function (){
var G__33352 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_remove_DASH_constraint,loc,const$], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33352) : re_frame.core.dispatch.call(null,G__33352));
});})(map__33346,map__33346__$1,const$,path,op,value,values,code))
,cljs.core.cst$kw$type,"button"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_times], null)], null)], null);
});
});
im_tables.views.table.head.controls.filter_view = (function im_tables$views$table$head$controls$filter_view(loc,view){
var response = (function (){var G__33361 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selection_SLASH_response,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33361) : re_frame.core.subscribe.call(null,G__33361));
})();
var selections = (function (){var G__33362 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selection_SLASH_selections,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33362) : re_frame.core.subscribe.call(null,G__33362));
})();
var query = (function (){var G__33363 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_temp_DASH_query,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33363) : re_frame.core.subscribe.call(null,G__33363));
})();
return ((function (response,selections,query){
return (function (loc__$1,view__$1){
var active_filters = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (response,selections,query){
return (function (c){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.constraint,loc__$1,c], null);
});})(response,selections,query))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(im_tables.views.table.head.controls.constraint_has_path_QMARK_,view__$1),cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(query) : cljs.core.deref.call(null,query)))));
var dropdown = reagent.core.current_component();
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form$form$filter_DASH_view,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_submit,((function (active_filters,dropdown,response,selections,query){
return (function (e){
var target_obj_33364_33369 = e;
var call_info_33366_33370 = [target_obj_33364_33369,(function (){var next_obj_33367 = (target_obj_33364_33369["preventDefault"]);
return next_obj_33367;
})()];
var fn_33365_33371 = (call_info_33366_33370[(1)]);
if(!((fn_33365_33371 == null))){
fn_33365_33371.call((call_info_33366_33370[(0)]));
} else {
}

im_tables.views.table.head.controls.force_close(dropdown);

var G__33368 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_save_DASH_changes,loc__$1], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33368) : re_frame.core.dispatch.call(null,G__33368));
});})(active_filters,dropdown,response,selections,query))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$alert$alert_DASH_success,((cljs.core.seq(active_filters))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Active filters:"], null)], null),active_filters):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"No active filters"], null))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$alert$alert_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Add a new filter:"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.blank_constraint,loc__$1,view__$1], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$toolbar,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"button",cljs.core.cst$kw$data_DASH_toggle,"dropdown"], null),"Cancel"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$btn$btn_DASH_primary$pull_DASH_right,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"submit",cljs.core.cst$kw$value,"Apply"], null)], null)], null)], null);
});
;})(response,selections,query))
});
im_tables.views.table.head.controls.column_summary = (function im_tables$views$table$head$controls$column_summary(loc,view){
var response = (function (){var G__33382 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selection_SLASH_response,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33382) : re_frame.core.subscribe.call(null,G__33382));
})();
var selections = (function (){var G__33383 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selection_SLASH_selections,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33383) : re_frame.core.subscribe.call(null,G__33383));
})();
var text_filter = (function (){var G__33384 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selection_SLASH_text_DASH_filter,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33384) : re_frame.core.subscribe.call(null,G__33384));
})();
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_will_DASH_mount,((function (response,selections,text_filter){
return (function (){
return null;
});})(response,selections,text_filter))
,cljs.core.cst$kw$component_DASH_will_DASH_update,((function (response,selections,text_filter){
return (function (){
return null;
});})(response,selections,text_filter))
,cljs.core.cst$kw$reagent_DASH_render,((function (response,selections,text_filter){
return (function (loc__$1,view__$1){
var close_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(im_tables.views.table.head.controls.force_close,reagent.core.current_component());
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form$form$column_DASH_summary,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$main_DASH_view,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.graphs.histogram.main,cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(response) : cljs.core.deref.call(null,response)))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.filter_input,loc__$1,view__$1,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(text_filter) : cljs.core.deref.call(null,text_filter))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$table$table_DASH_striped$table_DASH_condensed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,((cljs.core.empty_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selections) : cljs.core.deref.call(null,selections))))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$title,"Select all",cljs.core.cst$kw$on_DASH_click,((function (close_fn,response,selections,text_filter){
return (function (){
var G__33385 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_SLASH_select_DASH_all,loc__$1,view__$1], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33385) : re_frame.core.dispatch.call(null,G__33385));
});})(close_fn,response,selections,text_filter))
], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_check_DASH_square_DASH_o], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$title,"Deselect all",cljs.core.cst$kw$on_DASH_click,((function (close_fn,response,selections,text_filter){
return (function (){
var G__33386 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_SLASH_clear_DASH_selection,loc__$1,view__$1], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33386) : re_frame.core.dispatch.call(null,G__33386));
});})(close_fn,response,selections,text_filter))
], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_square_DASH_o], null)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Item"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,"Count"], null)], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (close_fn,response,selections,text_filter){
return (function (p__33387){
var map__33388 = p__33387;
var map__33388__$1 = ((((!((map__33388 == null)))?((((map__33388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33388.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33388):map__33388);
var count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33388__$1,cljs.core.cst$kw$count);
var item = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33388__$1,cljs.core.cst$kw$item);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr$hoverable,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__33388,map__33388__$1,count,item,close_fn,response,selections,text_filter){
return (function (e){
var G__33390 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_SLASH_toggle_DASH_selection,loc__$1,view__$1,item], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33390) : re_frame.core.dispatch.call(null,G__33390));
});})(map__33388,map__33388__$1,count,item,close_fn,response,selections,text_filter))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_change,((function (map__33388,map__33388__$1,count,item,close_fn,response,selections,text_filter){
return (function (){
return null;
});})(map__33388,map__33388__$1,count,item,close_fn,response,selections,text_filter))
,cljs.core.cst$kw$checked,cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selections) : cljs.core.deref.call(null,selections)),item),cljs.core.cst$kw$type,"checkbox"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,(cljs.core.truth_(item)?item:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.common.no_value], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,count], null)], null)], null);
});})(close_fn,response,selections,text_filter))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(im_tables.views.table.head.controls.has_text_QMARK_,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(text_filter) : cljs.core.deref.call(null,text_filter))),cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(response) : cljs.core.deref.call(null,response))))))], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$btn_DASH_toolbar$column_DASH_summary_DASH_toolbar,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"button",cljs.core.cst$kw$on_DASH_click,((function (close_fn,response,selections,text_filter){
return (function (){
var G__33391_33392 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_apply_DASH_summary_DASH_filter,loc__$1,view__$1], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33391_33392) : re_frame.core.dispatch.call(null,G__33391_33392));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
});})(close_fn,response,selections,text_filter))
], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_filter], null),[cljs.core.str(" Filter")].join('')], null)], null)], null);
});})(response,selections,text_filter))
], null));
});
im_tables.views.table.head.controls.toolbar = (function im_tables$views$table$head$controls$toolbar(){
return (function (loc,view,idx,col_count){
var query = (function (){var G__33397 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_temp_DASH_query,loc,view], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__33397) : re_frame.core.subscribe.call(null,G__33397));
})();
var active_filters_QMARK_ = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (query){
return (function (c){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.constraint,loc,c], null);
});})(query))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(im_tables.views.table.head.controls.constraint_has_path_QMARK_,view),cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(query) : cljs.core.deref.call(null,query))))));
var direction = (((idx > (col_count / (2))))?"dropdown-right":"dropdown-left");
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$summary_DASH_toolbar,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_sort$sort_DASH_icon,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,((function (query,active_filters_QMARK_,direction){
return (function (){
var G__33398 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_sort_DASH_by,loc,view], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33398) : re_frame.core.dispatch.call(null,G__33398));
});})(query,active_filters_QMARK_,direction))
,cljs.core.cst$kw$title,[cljs.core.str("Sort "),cljs.core.str(view),cljs.core.str(" column")].join('')], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_times$remove_DASH_icon,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,((function (query,active_filters_QMARK_,direction){
return (function (){
var G__33399 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_remove_DASH_view,loc,view], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33399) : re_frame.core.dispatch.call(null,G__33399));
});})(query,active_filters_QMARK_,direction))
,cljs.core.cst$kw$title,[cljs.core.str("Remove "),cljs.core.str(view),cljs.core.str(" column")].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$dropdown,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_filter$dropdown_DASH_toggle$filter_DASH_icon,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$on_DASH_click,((function (query,active_filters_QMARK_,direction){
return (function (){
var G__33400 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_set_DASH_temp_DASH_query,loc], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__33400) : re_frame.core.dispatch.call(null,G__33400));
});})(query,active_filters_QMARK_,direction))
,cljs.core.cst$kw$data_DASH_toggle,"dropdown",cljs.core.cst$kw$class,((active_filters_QMARK_)?"active-filter":null),cljs.core.cst$kw$title,[cljs.core.str("Filter "),cljs.core.str(view),cljs.core.str(" column")].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$dropdown_DASH_menu,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,direction], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.filter_view,loc,view], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$dropdown,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_bar_DASH_chart$dropdown_DASH_toggle,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data_DASH_toggle,"dropdown"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$dropdown_DASH_menu,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$title,[cljs.core.str("Summarise "),cljs.core.str(view),cljs.core.str(" column")].join(''),cljs.core.cst$kw$class,direction], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.table.head.controls.column_summary,loc,view], null)], null)], null)], null);
});
});
