// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('imcljsold.filters');
goog.require('cljs.core');
goog.require('ajax.core');
goog.require('cljs_http.client');
goog.require('imcljsold.utils');
goog.require('cljs.core.async');
/**
 * Returns the deepest class from a query path.
 *   Example:
 *   (end-class Gene.proteins flymine-model) ;; Protein
 *   (end-class Gene.goAnnotation.ontologyTerm.name ;; OntologyTerm
 */
imcljsold.filters.end_class = (function imcljsold$filters$end_class(model,path){
var parts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,"."));
var class$ = cljs.core.first(parts);
var parts_remaining = cljs.core.rest(parts);
while(true){
var temp__6751__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class$], null));
if(cljs.core.truth_(temp__6751__auto__)){
var found = temp__6751__auto__;
if(cljs.core.empty_QMARK_(parts_remaining)){
return cljs.core.name(class$);
} else {
var related = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$references.cljs$core$IFn$_invoke$arity$1(found),cljs.core.cst$kw$collections.cljs$core$IFn$_invoke$arity$1(found)], 0));
var map__29581 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(related,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parts_remaining)], null));
var map__29581__$1 = ((((!((map__29581 == null)))?((((map__29581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29581.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29581):map__29581);
var refType = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29581__$1,cljs.core.cst$kw$referencedType);
if((refType == null)){
return cljs.core.name(class$);
} else {
var G__29583 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(refType);
var G__29584 = cljs.core.rest(parts_remaining);
class$ = G__29583;
parts_remaining = G__29584;
continue;
}
}
} else {
return null;
}
break;
}
});
imcljsold.filters.path_types = new cljs.core.PersistentArrayMap(null, 6, ["class",cljs.core.cst$kw$class,"java.lang.String",cljs.core.cst$kw$string,"java.lang.Boolean",cljs.core.cst$kw$boolean,"java.lang.Integer",cljs.core.cst$kw$integer,"java.lang.Double",cljs.core.cst$kw$double,"java.lang.Float",cljs.core.cst$kw$float], null);
/**
 * Returns a keyword representing the type of the path
 *   (see path-types for possible types
 *   TODO: This is atrocious and needs to be reassessed. But it works.
 */
imcljsold.filters.path_type = (function imcljsold$filters$path_type(var_args){
var args__8442__auto__ = [];
var len__8435__auto___29593 = arguments.length;
var i__8436__auto___29594 = (0);
while(true){
if((i__8436__auto___29594 < len__8435__auto___29593)){
args__8442__auto__.push((arguments[i__8436__auto___29594]));

var G__29595 = (i__8436__auto___29594 + (1));
i__8436__auto___29594 = G__29595;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return imcljsold.filters.path_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

imcljsold.filters.path_type.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,subclasses){
while(true){
if(typeof path === 'string'){
var G__29596 = model;
var G__29597 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,"."));
var G__29598 = subclasses;
model = G__29596;
path = G__29597;
subclasses = G__29598;
continue;
} else {
if(cljs.core.truth_(cljs.core.some(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.string_QMARK_,cljs.core.cst$kw$path),subclasses))){
var G__29599 = model;
var G__29600 = path;
var G__29601 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (model,path,subclasses){
return (function (subclass){
if(typeof cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(subclass) === 'string'){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(subclass,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path], null),((function (model,path,subclasses){
return (function (p){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(p,"."));
});})(model,path,subclasses))
);
} else {
return subclass;
}
});})(model,path,subclasses))
,subclasses);
model = G__29599;
path = G__29600;
subclasses = G__29601;
continue;
} else {
var vec__29588 = path;
var seq__29589 = cljs.core.seq(vec__29588);
var first__29590 = cljs.core.first(seq__29589);
var seq__29589__$1 = cljs.core.next(seq__29589);
var class$ = first__29590;
var first__29590__$1 = cljs.core.first(seq__29589__$1);
var seq__29589__$2 = cljs.core.next(seq__29589__$1);
var child = first__29590__$1;
var remaining = seq__29589__$2;
if((child == null)){
return cljs.core.cst$kw$class;
} else {
var temp__6751__auto__ = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1((function (){var G__29591 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2((class$.cljs$core$IFn$_invoke$arity$1 ? class$.cljs$core$IFn$_invoke$arity$1(model) : class$.call(null,model)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$references,cljs.core.cst$kw$collections], null)));
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__29591) : child.call(null,G__29591));
})()));
if(cljs.core.truth_(temp__6751__auto__)){
var child_class = temp__6751__auto__;
if(remaining){
var sc = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,cljs.core.second(cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(cljs.core.first(subclasses)))))?cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (model,path,subclasses,child_class,temp__6751__auto__,vec__29588,seq__29589,first__29590,seq__29589__$1,class$,first__29590__$1,seq__29589__$2,child,remaining){
return (function (x){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(x,cljs.core.cst$kw$path,cljs.core.rest);
});})(model,path,subclasses,child_class,temp__6751__auto__,vec__29588,seq__29589,first__29590,seq__29589__$1,class$,first__29590__$1,seq__29589__$2,child,remaining))
,subclasses):subclasses);
var subclass_path = cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(cljs.core.first(sc));
var child_class__$1 = (((cljs.core.empty_QMARK_(cljs.core.rest(subclass_path))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,cljs.core.first(subclass_path))))?cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.first(sc))):child_class);
var G__29602 = model;
var G__29603 = cljs.core.cons(child_class__$1,remaining);
var G__29604 = sc;
model = G__29602;
path = G__29603;
subclasses = G__29604;
continue;
} else {
return cljs.core.cst$kw$class;
}
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(imcljsold.filters.path_types,cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1((function (){var G__29592 = cljs.core.cst$kw$attributes.cljs$core$IFn$_invoke$arity$1((class$.cljs$core$IFn$_invoke$arity$1 ? class$.cljs$core$IFn$_invoke$arity$1(model) : class$.call(null,model)));
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__29592) : child.call(null,G__29592));
})()));
}
}

}
}
break;
}
});

imcljsold.filters.path_type.cljs$lang$maxFixedArity = (2);

imcljsold.filters.path_type.cljs$lang$applyTo = (function (seq29585){
var G__29586 = cljs.core.first(seq29585);
var seq29585__$1 = cljs.core.next(seq29585);
var G__29587 = cljs.core.first(seq29585__$1);
var seq29585__$2 = cljs.core.next(seq29585__$1);
return imcljsold.filters.path_type.cljs$core$IFn$_invoke$arity$variadic(G__29586,G__29587,seq29585__$2);
});

imcljsold.filters.display_name = (function imcljsold$filters$display_name(model,class$){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((class$ instanceof cljs.core.Keyword))?class$:cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(class$)),cljs.core.cst$kw$displayName], null));
});
/**
 * Trims a path string to its parent class.
 *   Example:
 *   (trim-path-to-class flymine-model Gene.homologues.homologue.name )
 *   => Gene.homologues.homologue
 */
imcljsold.filters.trim_path_to_class = (function imcljsold$filters$trim_path_to_class(model,path){
var parts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,"."));
var parts_remaining = parts;
var collected = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parts_remaining)], null);
while(true){
var vec__29608 = parts_remaining;
var parent = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29608,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29608,(1),null);
var temp__6751__auto__ = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$references.cljs$core$IFn$_invoke$arity$1(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(parent).call(null,model)),cljs.core.cst$kw$collections.cljs$core$IFn$_invoke$arity$1(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(parent).call(null,model))], 0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [child,cljs.core.cst$kw$referencedType], null)));
if(cljs.core.truth_(temp__6751__auto__)){
var child_reference_type = temp__6751__auto__;
var G__29611 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(cljs.core.rest(parts_remaining)),child_reference_type);
var G__29612 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(collected,child);
parts_remaining = G__29611;
collected = G__29612;
continue;
} else {
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,collected));
}
break;
}
});
imcljsold.filters.sterilize_query = (function imcljsold$filters$sterilize_query(query){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$select,(function (paths){
if(cljs.core.contains_QMARK_(query,cljs.core.cst$kw$from)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query),cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,".")))){
return path;
} else {
return [cljs.core.str(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(path)].join('');
}
}),paths);
} else {
return paths;
}
}));
});
imcljsold.filters.referenced_type = (function imcljsold$filters$referenced_type(model,class_kw,field_kw){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1((function (){var G__29614 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2((class_kw.cljs$core$IFn$_invoke$arity$1 ? class_kw.cljs$core$IFn$_invoke$arity$1(model) : class_kw.call(null,model)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$references,cljs.core.cst$kw$collections], null)));
return (field_kw.cljs$core$IFn$_invoke$arity$1 ? field_kw.cljs$core$IFn$_invoke$arity$1(G__29614) : field_kw.call(null,G__29614));
})()));
});
/**
 * Returns the class that represents a path
 *   (class Gene.homologues.homologue.symbol) => Gene
 */
imcljsold.filters.im_type = (function imcljsold$filters$im_type(model,path){
var parts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,"."));
var class$ = cljs.core.first(parts);
var parts__$1 = cljs.core.rest(parts);
while(true){
var c = imcljsold.filters.referenced_type(model,class$,cljs.core.first(parts__$1));
var remaining = cljs.core.rest(parts__$1);
if((c == null)){
return class$;
} else {
if(cljs.core.empty_QMARK_(remaining)){
return c;
} else {
var G__29615 = c;
var G__29616 = remaining;
class$ = G__29615;
parts__$1 = G__29616;
continue;
}
}
break;
}
});
/**
 * Get all of the different parts of an intermine query and group them by type
 */
imcljsold.filters.get_parts = (function imcljsold$filters$get_parts(model,query){
return cljs.core.group_by(cljs.core.cst$kw$type,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (path){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$type,imcljsold.filters.im_type(model,path),cljs.core.array_seq([cljs.core.cst$kw$path,[cljs.core.str(imcljsold.filters.trim_path_to_class(model,path)),cljs.core.str(".id")].join(''),cljs.core.cst$kw$query,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$select,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(imcljsold.filters.trim_path_to_class(model,path)),cljs.core.str(".id")].join('')], null),cljs.core.cst$kw$where,cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(query)], null)], 0));
}),cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(query))));
});
/**
 * Deconstructs a query into a map. Keys are the unique paths
 *   and values include the query to return the values in the path,
 *   the display name, and the end class.
 *   {:Gene.pathways {:end-class Pathway :display-name Pathway :query ...}}
 */
imcljsold.filters.deconstruct_query = (function imcljsold$filters$deconstruct_query(model,query){
var sterile_query = imcljsold.filters.sterilize_query(query);
var classes = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljsold.filters.trim_path_to_class,model)),cljs.core.distinct.cljs$core$IFn$_invoke$arity$0()),cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(sterile_query));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sterile_query,classes){
return (function (total,next){
var end_class = imcljsold.filters.end_class(model,next);
var display_name = imcljsold.filters.display_name(model,end_class);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(total,next,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$count,"N",cljs.core.cst$kw$end_DASH_class,end_class,cljs.core.cst$kw$display_DASH_name,display_name,cljs.core.cst$kw$query,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$select,[cljs.core.str(next),cljs.core.str(".id")].join(''))], null));
});})(sterile_query,classes))
,cljs.core.PersistentArrayMap.EMPTY,classes);
});
