// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('imcljsold.search');
goog.require('cljs.core');
goog.require('ajax.core');
goog.require('cljs_http.client');
goog.require('imcljsold.utils');
goog.require('re_frame.core');
goog.require('cljs.core.async');
/**
 * Returns the results of a quicksearch
 */
imcljsold.search.quicksearch = (function imcljsold$search$quicksearch(p__27290,term,size){
var map__27315 = p__27290;
var map__27315__$1 = ((((!((map__27315 == null)))?((((map__27315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27315.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27315):map__27315);
var root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27315__$1,cljs.core.cst$kw$root);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27315__$1,cljs.core.cst$kw$token);
var root__$1 = imcljsold.utils.cleanse_url(root);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token){
return (function (state_27330){
var state_val_27331 = (state_27330[(1)]);
if((state_val_27331 === (1))){
var inst_27317 = [cljs.core.str(root__$1),cljs.core.str("/search")].join('');
var inst_27318 = [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$with_DASH_credentials_QMARK_];
var inst_27319 = [cljs.core.cst$kw$q,cljs.core.cst$kw$size];
var inst_27320 = [term,size];
var inst_27321 = cljs.core.PersistentHashMap.fromArrays(inst_27319,inst_27320);
var inst_27322 = [inst_27321,false];
var inst_27323 = cljs.core.PersistentHashMap.fromArrays(inst_27318,inst_27322);
var inst_27324 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(inst_27317,cljs.core.array_seq([inst_27323], 0));
var state_27330__$1 = state_27330;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27330__$1,(2),inst_27324);
} else {
if((state_val_27331 === (2))){
var inst_27326 = (state_27330[(2)]);
var inst_27327 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_27326);
var inst_27328 = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(inst_27327);
var state_27330__$1 = state_27330;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27330__$1,inst_27328);
} else {
return null;
}
}
});})(c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token))
;
return ((function (switch__14623__auto__,c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token){
return (function() {
var imcljsold$search$quicksearch_$_state_machine__14624__auto__ = null;
var imcljsold$search$quicksearch_$_state_machine__14624__auto____0 = (function (){
var statearr_27335 = [null,null,null,null,null,null,null];
(statearr_27335[(0)] = imcljsold$search$quicksearch_$_state_machine__14624__auto__);

(statearr_27335[(1)] = (1));

return statearr_27335;
});
var imcljsold$search$quicksearch_$_state_machine__14624__auto____1 = (function (state_27330){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_27330);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e27336){if((e27336 instanceof Object)){
var ex__14627__auto__ = e27336;
var statearr_27337_27339 = state_27330;
(statearr_27337_27339[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27330);

return cljs.core.cst$kw$recur;
} else {
throw e27336;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__27340 = state_27330;
state_27330 = G__27340;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
imcljsold$search$quicksearch_$_state_machine__14624__auto__ = function(state_27330){
switch(arguments.length){
case 0:
return imcljsold$search$quicksearch_$_state_machine__14624__auto____0.call(this);
case 1:
return imcljsold$search$quicksearch_$_state_machine__14624__auto____1.call(this,state_27330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljsold$search$quicksearch_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = imcljsold$search$quicksearch_$_state_machine__14624__auto____0;
imcljsold$search$quicksearch_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = imcljsold$search$quicksearch_$_state_machine__14624__auto____1;
return imcljsold$search$quicksearch_$_state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token))
})();
var state__14704__auto__ = (function (){var statearr_27338 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_27338[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_27338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,root__$1,map__27315,map__27315__$1,root,token))
);

return c__14702__auto__;
});
/**
 * search for the given term via IMJS promise. Filter is optional
 */
imcljsold.search.full_search = (function imcljsold$search$full_search(var_args){
var args__8442__auto__ = [];
var len__8435__auto___27348 = arguments.length;
var i__8436__auto___27349 = (0);
while(true){
if((i__8436__auto___27349 < len__8435__auto___27348)){
args__8442__auto__.push((arguments[i__8436__auto___27349]));

var G__27350 = (i__8436__auto___27349 + (1));
i__8436__auto___27349 = G__27350;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return imcljsold.search.full_search.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

imcljsold.search.full_search.cljs$core$IFn$_invoke$arity$variadic = (function (p__27344,searchterm,filter){
var map__27345 = p__27344;
var map__27345__$1 = ((((!((map__27345 == null)))?((((map__27345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27345.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27345):map__27345);
var root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27345__$1,cljs.core.cst$kw$root);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27345__$1,cljs.core.cst$kw$token);
var mine = (new imjs.Service(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$root,imcljsold.utils.cleanse_url(root)], null))));
var search = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$q,searchterm,cljs.core.cst$kw$Category,filter], null);
var id_promise = mine.search(cljs.core.clj__GT_js(search));
return id_promise.then(((function (mine,search,id_promise,map__27345,map__27345__$1,root,token){
return (function (results){
var G__27347 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_save_DASH_results,results], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__27347) : re_frame.core.dispatch.call(null,G__27347));
});})(mine,search,id_promise,map__27345,map__27345__$1,root,token))
);
});

imcljsold.search.full_search.cljs$lang$maxFixedArity = (2);

imcljsold.search.full_search.cljs$lang$applyTo = (function (seq27341){
var G__27342 = cljs.core.first(seq27341);
var seq27341__$1 = cljs.core.next(seq27341);
var G__27343 = cljs.core.first(seq27341__$1);
var seq27341__$2 = cljs.core.next(seq27341__$1);
return imcljsold.search.full_search.cljs$core$IFn$_invoke$arity$variadic(G__27342,G__27343,seq27341__$2);
});

/**
 * Returns IMJS row-style result
 */
imcljsold.search.raw_query_rows = (function imcljsold$search$raw_query_rows(var_args){
var args__8442__auto__ = [];
var len__8435__auto___27390 = arguments.length;
var i__8436__auto___27391 = (0);
while(true){
if((i__8436__auto___27391 < len__8435__auto___27390)){
args__8442__auto__.push((arguments[i__8436__auto___27391]));

var G__27392 = (i__8436__auto___27391 + (1));
i__8436__auto___27391 = G__27392;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return imcljsold.search.raw_query_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

imcljsold.search.raw_query_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__27354){
var vec__27355 = p__27354;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27355,(0),null);
var c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
(new imjs.Service(cljs.core.clj__GT_js(service))).query(cljs.core.clj__GT_js(query)).then(((function (c,vec__27355,options){
return (function (q){
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,c,vec__27355,options){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,c,vec__27355,options){
return (function (state_27380){
var state_val_27381 = (state_27380[(1)]);
if((state_val_27381 === (1))){
var inst_27358 = cljs.core.cst$kw$root.cljs$core$IFn$_invoke$arity$1(service);
var inst_27359 = imcljsold.utils.cleanse_url(inst_27358);
var inst_27360 = [cljs.core.str(inst_27359),cljs.core.str("/query/results")].join('');
var inst_27361 = [cljs.core.cst$kw$with_DASH_credentials_QMARK_,cljs.core.cst$kw$form_DASH_params];
var inst_27362 = [cljs.core.cst$kw$format];
var inst_27363 = ["json"];
var inst_27364 = cljs.core.PersistentHashMap.fromArrays(inst_27362,inst_27363);
var inst_27365 = [cljs.core.cst$kw$query];
var inst_27366 = q.toXML();
var inst_27367 = [inst_27366];
var inst_27368 = cljs.core.PersistentHashMap.fromArrays(inst_27365,inst_27367);
var inst_27369 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_27364,options,inst_27368], 0));
var inst_27370 = [false,inst_27369];
var inst_27371 = cljs.core.PersistentHashMap.fromArrays(inst_27361,inst_27370);
var inst_27372 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(inst_27360,cljs.core.array_seq([inst_27371], 0));
var state_27380__$1 = state_27380;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27380__$1,(2),inst_27372);
} else {
if((state_val_27381 === (2))){
var inst_27374 = (state_27380[(2)]);
var inst_27375 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_27374);
var state_27380__$1 = state_27380;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27380__$1,(3),c,inst_27375);
} else {
if((state_val_27381 === (3))){
var inst_27377 = (state_27380[(2)]);
var inst_27378 = cljs.core.async.close_BANG_(c);
var state_27380__$1 = (function (){var statearr_27382 = state_27380;
(statearr_27382[(7)] = inst_27377);

return statearr_27382;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27380__$1,inst_27378);
} else {
return null;
}
}
}
});})(c__14702__auto__,c,vec__27355,options))
;
return ((function (switch__14623__auto__,c__14702__auto__,c,vec__27355,options){
return (function() {
var imcljsold$search$state_machine__14624__auto__ = null;
var imcljsold$search$state_machine__14624__auto____0 = (function (){
var statearr_27386 = [null,null,null,null,null,null,null,null];
(statearr_27386[(0)] = imcljsold$search$state_machine__14624__auto__);

(statearr_27386[(1)] = (1));

return statearr_27386;
});
var imcljsold$search$state_machine__14624__auto____1 = (function (state_27380){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_27380);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e27387){if((e27387 instanceof Object)){
var ex__14627__auto__ = e27387;
var statearr_27388_27393 = state_27380;
(statearr_27388_27393[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27380);

return cljs.core.cst$kw$recur;
} else {
throw e27387;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__27394 = state_27380;
state_27380 = G__27394;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
imcljsold$search$state_machine__14624__auto__ = function(state_27380){
switch(arguments.length){
case 0:
return imcljsold$search$state_machine__14624__auto____0.call(this);
case 1:
return imcljsold$search$state_machine__14624__auto____1.call(this,state_27380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljsold$search$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = imcljsold$search$state_machine__14624__auto____0;
imcljsold$search$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = imcljsold$search$state_machine__14624__auto____1;
return imcljsold$search$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,c,vec__27355,options))
})();
var state__14704__auto__ = (function (){var statearr_27389 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_27389[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_27389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,c,vec__27355,options))
);

return c__14702__auto__;
});})(c,vec__27355,options))
,((function (c,vec__27355,options){
return (function (error){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["ERROR",error], 0));
});})(c,vec__27355,options))
);

return c;
});

imcljsold.search.raw_query_rows.cljs$lang$maxFixedArity = (2);

imcljsold.search.raw_query_rows.cljs$lang$applyTo = (function (seq27351){
var G__27352 = cljs.core.first(seq27351);
var seq27351__$1 = cljs.core.next(seq27351);
var G__27353 = cljs.core.first(seq27351__$1);
var seq27351__$2 = cljs.core.next(seq27351__$1);
return imcljsold.search.raw_query_rows.cljs$core$IFn$_invoke$arity$variadic(G__27352,G__27353,seq27351__$2);
});

/**
 * Get the results of using a list enrichment widget to calculate statistics for a set of objects.
 */
imcljsold.search.enrichment = (function imcljsold$search$enrichment(p__27395,p__27396){
var map__27462 = p__27395;
var map__27462__$1 = ((((!((map__27462 == null)))?((((map__27462.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27462.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27462):map__27462);
var root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27462__$1,cljs.core.cst$kw$root);
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27462__$1,cljs.core.cst$kw$token);
var map__27463 = p__27396;
var map__27463__$1 = ((((!((map__27463 == null)))?((((map__27463.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27463.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27463):map__27463);
var e = map__27463__$1;
var ids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$ids);
var list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$list);
var widget = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$widget);
var maxp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$maxp);
var correction = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$correction);
var population = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27463__$1,cljs.core.cst$kw$population);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population){
return (function (state_27504){
var state_val_27505 = (state_27504[(1)]);
if((state_val_27505 === (7))){
var state_27504__$1 = state_27504;
var statearr_27506_27527 = state_27504__$1;
(statearr_27506_27527[(2)] = null);

(statearr_27506_27527[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (1))){
var inst_27466 = imcljsold.utils.cleanse_url(root);
var inst_27467 = [cljs.core.str(inst_27466),cljs.core.str("/list/enrichment")].join('');
var inst_27468 = [cljs.core.cst$kw$with_DASH_credentials_QMARK_,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,cljs.core.cst$kw$form_DASH_params];
var inst_27469 = [cljs.core.cst$kw$widget,cljs.core.cst$kw$maxp,cljs.core.cst$kw$format,cljs.core.cst$kw$correction];
var inst_27470 = [widget,maxp,"json",correction];
var inst_27471 = cljs.core.PersistentHashMap.fromArrays(inst_27469,inst_27470);
var state_27504__$1 = (function (){var statearr_27507 = state_27504;
(statearr_27507[(7)] = inst_27468);

(statearr_27507[(8)] = inst_27467);

(statearr_27507[(9)] = inst_27471);

return statearr_27507;
})();
if(cljs.core.truth_(ids)){
var statearr_27508_27528 = state_27504__$1;
(statearr_27508_27528[(1)] = (3));

} else {
var statearr_27509_27529 = state_27504__$1;
(statearr_27509_27529[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (4))){
var state_27504__$1 = state_27504;
if(cljs.core.truth_(list)){
var statearr_27510_27530 = state_27504__$1;
(statearr_27510_27530[(1)] = (6));

} else {
var statearr_27511_27531 = state_27504__$1;
(statearr_27511_27531[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (6))){
var inst_27479 = [cljs.core.cst$kw$list];
var inst_27480 = [list];
var inst_27481 = cljs.core.PersistentHashMap.fromArrays(inst_27479,inst_27480);
var state_27504__$1 = state_27504;
var statearr_27512_27532 = state_27504__$1;
(statearr_27512_27532[(2)] = inst_27481);

(statearr_27512_27532[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (3))){
var inst_27473 = [cljs.core.cst$kw$ids];
var inst_27474 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",ids);
var inst_27475 = [inst_27474];
var inst_27476 = cljs.core.PersistentHashMap.fromArrays(inst_27473,inst_27475);
var state_27504__$1 = state_27504;
var statearr_27513_27533 = state_27504__$1;
(statearr_27513_27533[(2)] = inst_27476);

(statearr_27513_27533[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (2))){
var inst_27501 = (state_27504[(2)]);
var inst_27502 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_27501);
var state_27504__$1 = state_27504;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27504__$1,inst_27502);
} else {
if((state_val_27505 === (11))){
var inst_27468 = (state_27504[(7)]);
var inst_27467 = (state_27504[(8)]);
var inst_27471 = (state_27504[(9)]);
var inst_27486 = (state_27504[(10)]);
var inst_27495 = (state_27504[(2)]);
var inst_27496 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_27471,inst_27486,inst_27495], 0));
var inst_27497 = [false,true,inst_27496];
var inst_27498 = cljs.core.PersistentHashMap.fromArrays(inst_27468,inst_27497);
var inst_27499 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(inst_27467,cljs.core.array_seq([inst_27498], 0));
var state_27504__$1 = state_27504;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27504__$1,(2),inst_27499);
} else {
if((state_val_27505 === (9))){
var inst_27490 = [cljs.core.cst$kw$population];
var inst_27491 = [population];
var inst_27492 = cljs.core.PersistentHashMap.fromArrays(inst_27490,inst_27491);
var state_27504__$1 = state_27504;
var statearr_27514_27534 = state_27504__$1;
(statearr_27514_27534[(2)] = inst_27492);

(statearr_27514_27534[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (5))){
var inst_27486 = (state_27504[(2)]);
var inst_27487 = (population == null);
var inst_27488 = cljs.core.not(inst_27487);
var state_27504__$1 = (function (){var statearr_27515 = state_27504;
(statearr_27515[(10)] = inst_27486);

return statearr_27515;
})();
if(inst_27488){
var statearr_27516_27535 = state_27504__$1;
(statearr_27516_27535[(1)] = (9));

} else {
var statearr_27517_27536 = state_27504__$1;
(statearr_27517_27536[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (10))){
var state_27504__$1 = state_27504;
var statearr_27518_27537 = state_27504__$1;
(statearr_27518_27537[(2)] = null);

(statearr_27518_27537[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27505 === (8))){
var inst_27484 = (state_27504[(2)]);
var state_27504__$1 = state_27504;
var statearr_27519_27538 = state_27504__$1;
(statearr_27519_27538[(2)] = inst_27484);

(statearr_27519_27538[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population))
;
return ((function (switch__14623__auto__,c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population){
return (function() {
var imcljsold$search$enrichment_$_state_machine__14624__auto__ = null;
var imcljsold$search$enrichment_$_state_machine__14624__auto____0 = (function (){
var statearr_27523 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27523[(0)] = imcljsold$search$enrichment_$_state_machine__14624__auto__);

(statearr_27523[(1)] = (1));

return statearr_27523;
});
var imcljsold$search$enrichment_$_state_machine__14624__auto____1 = (function (state_27504){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_27504);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e27524){if((e27524 instanceof Object)){
var ex__14627__auto__ = e27524;
var statearr_27525_27539 = state_27504;
(statearr_27525_27539[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27504);

return cljs.core.cst$kw$recur;
} else {
throw e27524;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__27540 = state_27504;
state_27504 = G__27540;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
imcljsold$search$enrichment_$_state_machine__14624__auto__ = function(state_27504){
switch(arguments.length){
case 0:
return imcljsold$search$enrichment_$_state_machine__14624__auto____0.call(this);
case 1:
return imcljsold$search$enrichment_$_state_machine__14624__auto____1.call(this,state_27504);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljsold$search$enrichment_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = imcljsold$search$enrichment_$_state_machine__14624__auto____0;
imcljsold$search$enrichment_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = imcljsold$search$enrichment_$_state_machine__14624__auto____1;
return imcljsold$search$enrichment_$_state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population))
})();
var state__14704__auto__ = (function (){var statearr_27526 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_27526[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_27526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,map__27462,map__27462__$1,root,token,map__27463,map__27463__$1,e,ids,list,widget,maxp,correction,population))
);

return c__14702__auto__;
});
