// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('json_html.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('hiccups.runtime');
json_html.core.escape_html = (function json_html$core$escape_html(s){
return clojure.string.escape(s,new cljs.core.PersistentArrayMap(null, 4, ["&","&amp;",">","&gt;","<","&lt;","\"","&quot;"], null));
});
json_html.core.render_keyword = (function json_html$core$render_keyword(k){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("/",cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace,cljs.core.name).call(null,k)));
});
json_html.core.str_compare = (function json_html$core$str_compare(k1,k2){
return cljs.core.compare([cljs.core.str(k1)].join(''),[cljs.core.str(k2)].join(''));
});
json_html.core.sort_map = (function json_html$core$sort_map(m){
try{return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map(),m);
}catch (e24032){if((e24032 instanceof Error)){
var _ = e24032;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(json_html.core.str_compare),m);
} else {
throw e24032;

}
}});
json_html.core.sort_set = (function json_html$core$sort_set(s){
try{return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_set(),s);
}catch (e24034){if((e24034 instanceof Error)){
var _ = e24034;
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_set_by(json_html.core.str_compare),s);
} else {
throw e24034;

}
}});
json_html.core.render_collection = (function json_html$core$render_collection(col){
if(cljs.core.empty_QMARK_(col)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$jh_DASH_type_DASH_object,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_empty_DASH_collection], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$jh_DASH_type_DASH_object,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__8076__auto__ = (function json_html$core$render_collection_$_iter__24053(s__24054){
return (new cljs.core.LazySeq(null,(function (){
var s__24054__$1 = s__24054;
while(true){
var temp__6753__auto__ = cljs.core.seq(s__24054__$1);
if(temp__6753__auto__){
var s__24054__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24054__$2)){
var c__8074__auto__ = cljs.core.chunk_first(s__24054__$2);
var size__8075__auto__ = cljs.core.count(c__8074__auto__);
var b__24056 = cljs.core.chunk_buffer(size__8075__auto__);
if((function (){var i__24055 = (0);
while(true){
if((i__24055 < size__8075__auto__)){
var vec__24065 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8074__auto__,i__24055);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24065,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24065,(1),null);
cljs.core.chunk_append(b__24056,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$jh_DASH_key$jh_DASH_array_DASH_key,i], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$jh_DASH_value$jh_DASH_array_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(v) : json_html.core.render.call(null,v))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,i], null)));

var G__24071 = (i__24055 + (1));
i__24055 = G__24071;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24056),json_html$core$render_collection_$_iter__24053(cljs.core.chunk_rest(s__24054__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24056),null);
}
} else {
var vec__24068 = cljs.core.first(s__24054__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24068,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24068,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$jh_DASH_key$jh_DASH_array_DASH_key,i], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$jh_DASH_value$jh_DASH_array_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(v) : json_html.core.render.call(null,v))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,i], null)),json_html$core$render_collection_$_iter__24053(cljs.core.rest(s__24054__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8076__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,col));
})()], null)], null);
}
});
json_html.core.render_set = (function json_html$core$render_set(s){
if(cljs.core.empty_QMARK_(s)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$jh_DASH_type_DASH_set,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_empty_DASH_set], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,(function (){var iter__8076__auto__ = (function json_html$core$render_set_$_iter__24078(s__24079){
return (new cljs.core.LazySeq(null,(function (){
var s__24079__$1 = s__24079;
while(true){
var temp__6753__auto__ = cljs.core.seq(s__24079__$1);
if(temp__6753__auto__){
var s__24079__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24079__$2)){
var c__8074__auto__ = cljs.core.chunk_first(s__24079__$2);
var size__8075__auto__ = cljs.core.count(c__8074__auto__);
var b__24081 = cljs.core.chunk_buffer(size__8075__auto__);
if((function (){var i__24080 = (0);
while(true){
if((i__24080 < size__8075__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8074__auto__,i__24080);
cljs.core.chunk_append(b__24081,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$jh_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(item) : json_html.core.render.call(null,item))], null));

var G__24084 = (i__24080 + (1));
i__24080 = G__24084;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24081),json_html$core$render_set_$_iter__24078(cljs.core.chunk_rest(s__24079__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24081),null);
}
} else {
var item = cljs.core.first(s__24079__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$jh_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(item) : json_html.core.render.call(null,item))], null),json_html$core$render_set_$_iter__24078(cljs.core.rest(s__24079__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8076__auto__(json_html.core.sort_set(s));
})()], null);
}
});
json_html.core.render_map = (function json_html$core$render_map(m){
if(cljs.core.empty_QMARK_(m)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$jh_DASH_type_DASH_object,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_empty_DASH_map], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$jh_DASH_type_DASH_object,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,(function (){var iter__8076__auto__ = (function json_html$core$render_map_$_iter__24103(s__24104){
return (new cljs.core.LazySeq(null,(function (){
var s__24104__$1 = s__24104;
while(true){
var temp__6753__auto__ = cljs.core.seq(s__24104__$1);
if(temp__6753__auto__){
var s__24104__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24104__$2)){
var c__8074__auto__ = cljs.core.chunk_first(s__24104__$2);
var size__8075__auto__ = cljs.core.count(c__8074__auto__);
var b__24106 = cljs.core.chunk_buffer(size__8075__auto__);
if((function (){var i__24105 = (0);
while(true){
if((i__24105 < size__8075__auto__)){
var vec__24115 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8074__auto__,i__24105);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24115,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24115,(1),null);
cljs.core.chunk_append(b__24106,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$jh_DASH_key$jh_DASH_object_DASH_key,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(k) : json_html.core.render.call(null,k))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$jh_DASH_value$jh_DASH_object_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(v) : json_html.core.render.call(null,v))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)));

var G__24121 = (i__24105 + (1));
i__24105 = G__24121;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24106),json_html$core$render_map_$_iter__24103(cljs.core.chunk_rest(s__24104__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24106),null);
}
} else {
var vec__24118 = cljs.core.first(s__24104__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24118,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24118,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$jh_DASH_key$jh_DASH_object_DASH_key,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(k) : json_html.core.render.call(null,k))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$jh_DASH_value$jh_DASH_object_DASH_value,(json_html.core.render.cljs$core$IFn$_invoke$arity$1 ? json_html.core.render.cljs$core$IFn$_invoke$arity$1(v) : json_html.core.render.call(null,v))], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,k], null)),json_html$core$render_map_$_iter__24103(cljs.core.rest(s__24104__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8076__auto__(json_html.core.sort_map(m));
})()], null)], null);
}
});
json_html.core.render_string = (function json_html$core$render_string(s){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_string,((clojure.string.blank_QMARK_(s))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_empty_DASH_string], null):json_html.core.escape_html(s))], null);
});
json_html.core.render = (function json_html$core$render(v){
var t = cljs.core.type(v);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_string,json_html.core.render_keyword(v)], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.Symbol)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_string,[cljs.core.str(v)].join('')], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,String)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_string,json_html.core.escape_html(v)], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,Date)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_date,v.toString()], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,Boolean)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_bool,[cljs.core.str(v)].join('')], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,Number)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$jh_DASH_type_DASH_number,v], null);
} else {
if(((!((v == null)))?((((v.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$IMap$)))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,v):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,v))){
return json_html.core.render_map(v);
} else {
if(((!((v == null)))?((((v.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$ISet$)))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,v):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,v))){
return json_html.core.render_set(v);
} else {
if(((!((v == null)))?((((v.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === v.cljs$core$ICollection$)))?true:(((!v.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,v):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,v))){
return json_html.core.render_collection(v);
} else {
return null;

}
}
}
}
}
}
}
}
}
});
json_html.core.edn__GT_hiccup = (function json_html$core$edn__GT_hiccup(edn){
return json_html.core.render(edn);
});
json_html.core.edn__GT_html = (function json_html$core$edn__GT_html(edn){
return [cljs.core.str(hiccups.runtime.render_html(json_html.core.edn__GT_hiccup(edn)))].join('');
});
json_html.core.json__GT_hiccup = (function json_html$core$json__GT_hiccup(json){
return json_html.core.render(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(json));
});
json_html.core.json__GT_html = (function json_html$core$json__GT_html(json){
return [cljs.core.str(hiccups.runtime.render_html(json_html.core.json__GT_hiccup(json)))].join('');
});
