// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = cljs.core.cst$kw$fx;
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.register = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.register_handler,re_frame.fx.kind);
/**
 * An interceptor which actions a `context's` (side) `:effects`.
 * 
 *   For each key in the `:effects` map, call the `effects handler` previously
 *   registered using `reg-fx`.
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 *   call the registered effects handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$id,cljs.core.cst$kw$do_DASH_fx,cljs.core.cst$kw$after,(function re_frame$fx$do_fx_after(context){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22601){
var vec__22602 = p__22601;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22602,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22602,(1),null);
var temp__6751__auto__ = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,k,true);
if(cljs.core.truth_(temp__6751__auto__)){
var effect_fn = temp__6751__auto__;
return (effect_fn.cljs$core$IFn$_invoke$arity$1 ? effect_fn.cljs$core$IFn$_invoke$arity$1(value) : effect_fn.call(null,value));
} else {
return null;
}
}),cljs.core.cst$kw$effects.cljs$core$IFn$_invoke$arity$1(context)));
})], 0));
var G__22605_22615 = cljs.core.cst$kw$dispatch_DASH_later;
var G__22606_22616 = ((function (G__22605_22615){
return (function (value){
var seq__22607 = cljs.core.seq(value);
var chunk__22608 = null;
var count__22609 = (0);
var i__22610 = (0);
while(true){
if((i__22610 < count__22609)){
var map__22611 = chunk__22608.cljs$core$IIndexed$_nth$arity$2(null,i__22610);
var map__22611__$1 = ((((!((map__22611 == null)))?((((map__22611.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22611.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22611):map__22611);
var effect = map__22611__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22611__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22611__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.array_seq(["re-frame: ignoring bad :dispatch-later value: ",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__22607,chunk__22608,count__22609,i__22610,map__22611,map__22611__$1,effect,ms,dispatch,G__22605_22615){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__22607,chunk__22608,count__22609,i__22610,map__22611,map__22611__$1,effect,ms,dispatch,G__22605_22615))
,ms);
}

var G__22617 = seq__22607;
var G__22618 = chunk__22608;
var G__22619 = count__22609;
var G__22620 = (i__22610 + (1));
seq__22607 = G__22617;
chunk__22608 = G__22618;
count__22609 = G__22619;
i__22610 = G__22620;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__22607);
if(temp__6753__auto__){
var seq__22607__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22607__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__22607__$1);
var G__22621 = cljs.core.chunk_rest(seq__22607__$1);
var G__22622 = c__8125__auto__;
var G__22623 = cljs.core.count(c__8125__auto__);
var G__22624 = (0);
seq__22607 = G__22621;
chunk__22608 = G__22622;
count__22609 = G__22623;
i__22610 = G__22624;
continue;
} else {
var map__22613 = cljs.core.first(seq__22607__$1);
var map__22613__$1 = ((((!((map__22613 == null)))?((((map__22613.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22613.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__22613):map__22613);
var effect = map__22613__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22613__$1,cljs.core.cst$kw$ms);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22613__$1,cljs.core.cst$kw$dispatch);
if((cljs.core.empty_QMARK_(dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.array_seq(["re-frame: ignoring bad :dispatch-later value: ",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__22607,chunk__22608,count__22609,i__22610,map__22613,map__22613__$1,effect,ms,dispatch,seq__22607__$1,temp__6753__auto__,G__22605_22615){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__22607,chunk__22608,count__22609,i__22610,map__22613,map__22613__$1,effect,ms,dispatch,seq__22607__$1,temp__6753__auto__,G__22605_22615))
,ms);
}

var G__22625 = cljs.core.next(seq__22607__$1);
var G__22626 = null;
var G__22627 = (0);
var G__22628 = (0);
seq__22607 = G__22625;
chunk__22608 = G__22626;
count__22609 = G__22627;
i__22610 = G__22628;
continue;
}
} else {
return null;
}
}
break;
}
});})(G__22605_22615))
;
(re_frame.fx.register.cljs$core$IFn$_invoke$arity$2 ? re_frame.fx.register.cljs$core$IFn$_invoke$arity$2(G__22605_22615,G__22606_22616) : re_frame.fx.register.call(null,G__22605_22615,G__22606_22616));
var G__22629_22631 = cljs.core.cst$kw$dispatch;
var G__22630_22632 = ((function (G__22629_22631){
return (function (value){
if(!(cljs.core.vector_QMARK_(value))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.array_seq(["re-frame: ignoring bad :dispatch value. Expected a vector, but got: ",value], 0));
} else {
return re_frame.router.dispatch(value);
}
});})(G__22629_22631))
;
(re_frame.fx.register.cljs$core$IFn$_invoke$arity$2 ? re_frame.fx.register.cljs$core$IFn$_invoke$arity$2(G__22629_22631,G__22630_22632) : re_frame.fx.register.call(null,G__22629_22631,G__22630_22632));
var G__22633_22639 = cljs.core.cst$kw$dispatch_DASH_n;
var G__22634_22640 = ((function (G__22633_22639){
return (function (value){
if(!(cljs.core.sequential_QMARK_(value))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$error,cljs.core.array_seq(["re-frame: ignoring bad :dispatch-n value. Expected a collection, got got: ",value], 0));
} else {
}

var seq__22635 = cljs.core.seq(value);
var chunk__22636 = null;
var count__22637 = (0);
var i__22638 = (0);
while(true){
if((i__22638 < count__22637)){
var event = chunk__22636.cljs$core$IIndexed$_nth$arity$2(null,i__22638);
re_frame.router.dispatch(event);

var G__22641 = seq__22635;
var G__22642 = chunk__22636;
var G__22643 = count__22637;
var G__22644 = (i__22638 + (1));
seq__22635 = G__22641;
chunk__22636 = G__22642;
count__22637 = G__22643;
i__22638 = G__22644;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__22635);
if(temp__6753__auto__){
var seq__22635__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22635__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__22635__$1);
var G__22645 = cljs.core.chunk_rest(seq__22635__$1);
var G__22646 = c__8125__auto__;
var G__22647 = cljs.core.count(c__8125__auto__);
var G__22648 = (0);
seq__22635 = G__22645;
chunk__22636 = G__22646;
count__22637 = G__22647;
i__22638 = G__22648;
continue;
} else {
var event = cljs.core.first(seq__22635__$1);
re_frame.router.dispatch(event);

var G__22649 = cljs.core.next(seq__22635__$1);
var G__22650 = null;
var G__22651 = (0);
var G__22652 = (0);
seq__22635 = G__22649;
chunk__22636 = G__22650;
count__22637 = G__22651;
i__22638 = G__22652;
continue;
}
} else {
return null;
}
}
break;
}
});})(G__22633_22639))
;
(re_frame.fx.register.cljs$core$IFn$_invoke$arity$2 ? re_frame.fx.register.cljs$core$IFn$_invoke$arity$2(G__22633_22639,G__22634_22640) : re_frame.fx.register.call(null,G__22633_22639,G__22634_22640));
var G__22653_22655 = cljs.core.cst$kw$deregister_DASH_event_DASH_handler;
var G__22654_22656 = ((function (G__22653_22655){
return (function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clear_event,value));
} else {
return (clear_event.cljs$core$IFn$_invoke$arity$1 ? clear_event.cljs$core$IFn$_invoke$arity$1(value) : clear_event.call(null,value));
}
});})(G__22653_22655))
;
(re_frame.fx.register.cljs$core$IFn$_invoke$arity$2 ? re_frame.fx.register.cljs$core$IFn$_invoke$arity$2(G__22653_22655,G__22654_22656) : re_frame.fx.register.call(null,G__22653_22655,G__22654_22656));
var G__22657_22659 = cljs.core.cst$kw$db;
var G__22658_22660 = ((function (G__22657_22659){
return (function (value){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.db.app_db,value) : cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value));
});})(G__22657_22659))
;
(re_frame.fx.register.cljs$core$IFn$_invoke$arity$2 ? re_frame.fx.register.cljs$core$IFn$_invoke$arity$2(G__22657_22659,G__22658_22660) : re_frame.fx.register.call(null,G__22657_22659,G__22658_22660));
