// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.databrowser.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('redgenes.db');
goog.require('cljs.core.async');
goog.require('imcljsold.counts');
goog.require('accountant.core');
redgenes.components.databrowser.events.pi = Math.PI;
redgenes.components.databrowser.events.viewport = (function (){var G__34941 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$databrowser_SLASH_viewport], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__34941) : re_frame.core.subscribe.call(null,G__34941));
})();
redgenes.components.databrowser.events.margin = (30);
redgenes.components.databrowser.events.padding = (10);
redgenes.components.databrowser.events.center = (function redgenes$components$databrowser$events$center(){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x,(cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.viewport) : cljs.core.deref.call(null,redgenes.components.databrowser.events.viewport))) / (2)),cljs.core.cst$kw$y,(cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.viewport) : cljs.core.deref.call(null,redgenes.components.databrowser.events.viewport))) / (2))], null);
});
/**
 * like it sounds. strategy is to correlate the area to the log of the count, then whack it up in size a bit because we want to see these silly little dots.
 */
redgenes.components.databrowser.events.radius_from_count = (function redgenes$components$databrowser$events$radius_from_count(count){
var area = (Math.log2(count) * (100));
var r = (function (){var G__34943 = (area / redgenes.components.databrowser.events.pi);
return Math.sqrt(G__34943);
})();
return (r + redgenes.components.databrowser.events.padding);
});
redgenes.components.databrowser.events.random_coord = (function redgenes$components$databrowser$events$random_coord(max_coord,radius){
var r = (radius + redgenes.components.databrowser.events.margin);
var x = (max_coord * Math.random());
if((max_coord < (r + x))){
return (max_coord - r);
} else {
if((r > x)){
return r;
} else {
return x;

}
}
});
/**
 * Euclidean distance between 2 points
 */
redgenes.components.databrowser.events.distance = (function redgenes$components$databrowser$events$distance(p__34944,p__34945){
var vec__34957 = p__34944;
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34957,(0),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34957,(1),null);
var vec__34960 = p__34945;
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34960,(0),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34960,(1),null);
var G__34963 = ((function (){var G__34964 = (x1 - x2);
var G__34965 = (2);
return Math.pow(G__34964,G__34965);
})() + (function (){var G__34966 = (y1 - y2);
var G__34967 = (2);
return Math.pow(G__34966,G__34967);
})());
return Math.sqrt(G__34963);
});
/**
 * given two sets of circle coords, check if they collide at all.
 *   Essentially, the distance between their centres needs to be greater than
 *   the sum of their radiuses for this to be true. Also, a circle can't collide with itself.
 */
redgenes.components.databrowser.events.collides_QMARK_ = (function redgenes$components$databrowser$events$collides_QMARK_(c1,c2){
var distance_between_centers = redgenes.components.databrowser.events.distance(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(c1),cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(c1)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(c2),cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(c2)], null));
var radius_sum = (cljs.core.cst$kw$r.cljs$core$IFn$_invoke$arity$1(c1) + cljs.core.cst$kw$r.cljs$core$IFn$_invoke$arity$1(c2));
return ((radius_sum >= distance_between_centers)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c1,c2));
});
redgenes.components.databrowser.events.check_for_collision = (function redgenes$components$databrowser$events$check_for_collision(mymap){

var themap = cljs.core.vec(mymap);
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (themap){
return (function (new_map,p__34976){
var vec__34977 = p__34976;
var id2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34977,(0),null);
var circle2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34977,(1),null);
var inner_layer = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__34977,id2,circle2,themap){
return (function (new_map2,p__34980){
var vec__34981 = p__34980;
var id3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34981,(0),null);
var circle3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34981,(1),null);
if(cljs.core.truth_(redgenes.components.databrowser.events.collides_QMARK_(circle2,circle3))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_map2,id3,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(circle3,cljs.core.cst$kw$collides_DASH_with,circle2));
} else {
return new_map2;
}
});})(vec__34977,id2,circle2,themap))
,new_map,themap));
return inner_layer;
});})(themap))
,cljs.core.PersistentArrayMap.EMPTY,themap));
});
/**
 * The biggest node always goes smack in the centre
 */
redgenes.components.databrowser.events.build_central_node = (function redgenes$components$databrowser$events$build_central_node(sorted_counts){
return cljs.core.PersistentArrayMap.fromArray([cljs.core.first(cljs.core.first(sorted_counts)),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.center()),cljs.core.cst$kw$y,cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.center()),cljs.core.cst$kw$r,redgenes.components.databrowser.events.radius_from_count(cljs.core.second(cljs.core.first(sorted_counts))),cljs.core.cst$kw$name,cljs.core.first(cljs.core.first(sorted_counts))], null)], true, false);
});
/**
 * chooses a random location on the playing board and creats a coord & radius set for the circle
 */
redgenes.components.databrowser.events.assign_random_location = (function redgenes$components$databrowser$events$assign_random_location(k,v){
var radius = redgenes.components.databrowser.events.radius_from_count(v);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,redgenes.components.databrowser.events.random_coord(cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.viewport) : cljs.core.deref.call(null,redgenes.components.databrowser.events.viewport))),radius),cljs.core.cst$kw$y,redgenes.components.databrowser.events.random_coord(cljs.core.cst$kw$y.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redgenes.components.databrowser.events.viewport) : cljs.core.deref.call(null,redgenes.components.databrowser.events.viewport))),radius),cljs.core.cst$kw$r,radius,cljs.core.cst$kw$name,k], null);
});
/**
 * Generates a location for the bubble, checks if it's overlapping, and tries again if it is
 */
redgenes.components.databrowser.events.new_bubble = (function redgenes$components$databrowser$events$new_bubble(k,v,locs){
var possible_location = redgenes.components.databrowser.events.assign_random_location(k,v);
var collisions = redgenes.components.databrowser.events.check_for_collision(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(locs,k,possible_location));
if(cljs.core.empty_QMARK_(collisions)){
return possible_location;
} else {
return (redgenes.components.databrowser.events.new_bubble.cljs$core$IFn$_invoke$arity$3 ? redgenes.components.databrowser.events.new_bubble.cljs$core$IFn$_invoke$arity$3(k,v,locs) : redgenes.components.databrowser.events.new_bubble.call(null,k,v,locs));
}
});
/**
 * Given counts, generate a coord set and sizes for the bubbles, and ensure that they don't overlap.
 */
redgenes.components.databrowser.events.calculate_node_locations = (function redgenes$components$databrowser$events$calculate_node_locations(counts){
var numeric_counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34992){
var vec__34993 = p__34992;
var a = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993,(0),null);
var b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34993,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,(b | (0))], null);
}),counts);
var sorted_counts = cljs.core.reverse(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.second,numeric_counts));
var central_node = redgenes.components.databrowser.events.build_central_node(sorted_counts);
var locs = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (numeric_counts,sorted_counts,central_node){
return (function (new_map,p__34996){
var vec__34997 = p__34996;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34997,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_map,k,redgenes.components.databrowser.events.new_bubble(k,v,new_map));
});})(numeric_counts,sorted_counts,central_node))
,central_node,cljs.core.rest(sorted_counts));
return locs;
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$databrowser_SLASH_fetch_DASH_all_DASH_counts,(function (args,p__35000){
var vec__35001 = p__35000;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35001,(0),null);
var xy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35001,(1),null);
var db = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(args);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$fetching_DASH_counts_QMARK_,true),cljs.core.cst$kw$databrowser_SLASH_viewport,xy),cljs.core.cst$kw$databrowser_SLASH_fetch_DASH_counts,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$connection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$root,(function (){var G__35004 = (function (){var G__35005 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mine_DASH_url], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__35005) : re_frame.core.subscribe.call(null,G__35005));
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35004) : cljs.core.deref.call(null,G__35004));
})()], null),cljs.core.cst$kw$path,"top"], null)], null);
}));
var G__35006_35028 = cljs.core.cst$kw$databrowser_SLASH_fetch_DASH_counts;
var G__35007_35029 = ((function (G__35006_35028){
return (function (p__35008){
var map__35009 = p__35008;
var map__35009__$1 = ((((!((map__35009 == null)))?((((map__35009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35009):map__35009);
var connection = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35009__$1,cljs.core.cst$kw$connection);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35009__$1,cljs.core.cst$kw$path);
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028){
return (function (state_35019){
var state_val_35020 = (state_35019[(1)]);
if((state_val_35020 === (1))){
var inst_35011 = imcljsold.counts.count_rows(connection,path);
var state_35019__$1 = state_35019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35019__$1,(2),inst_35011);
} else {
if((state_val_35020 === (2))){
var inst_35013 = (state_35019[(2)]);
var inst_35014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35015 = [cljs.core.cst$kw$databrowser_SLASH_save_DASH_counts,cljs.core.cst$kw$human,inst_35013];
var inst_35016 = (new cljs.core.PersistentVector(null,3,(5),inst_35014,inst_35015,null));
var inst_35017 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_35016) : re_frame.core.dispatch.call(null,inst_35016));
var state_35019__$1 = state_35019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35019__$1,inst_35017);
} else {
return null;
}
}
});})(c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028))
;
return ((function (switch__14623__auto__,c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028){
return (function() {
var redgenes$components$databrowser$events$state_machine__14624__auto__ = null;
var redgenes$components$databrowser$events$state_machine__14624__auto____0 = (function (){
var statearr_35024 = [null,null,null,null,null,null,null];
(statearr_35024[(0)] = redgenes$components$databrowser$events$state_machine__14624__auto__);

(statearr_35024[(1)] = (1));

return statearr_35024;
});
var redgenes$components$databrowser$events$state_machine__14624__auto____1 = (function (state_35019){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_35019);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e35025){if((e35025 instanceof Object)){
var ex__14627__auto__ = e35025;
var statearr_35026_35030 = state_35019;
(statearr_35026_35030[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35019);

return cljs.core.cst$kw$recur;
} else {
throw e35025;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__35031 = state_35019;
state_35019 = G__35031;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$databrowser$events$state_machine__14624__auto__ = function(state_35019){
switch(arguments.length){
case 0:
return redgenes$components$databrowser$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$databrowser$events$state_machine__14624__auto____1.call(this,state_35019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$databrowser$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$databrowser$events$state_machine__14624__auto____0;
redgenes$components$databrowser$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$databrowser$events$state_machine__14624__auto____1;
return redgenes$components$databrowser$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028))
})();
var state__14704__auto__ = (function (){var statearr_35027 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_35027[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_35027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,map__35009,map__35009__$1,connection,path,G__35006_35028))
);

return c__14702__auto__;
});})(G__35006_35028))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__35006_35028,G__35007_35029) : re_frame.core.reg_fx.call(null,G__35006_35028,G__35007_35029));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$databrowser_SLASH_save_DASH_counts,(function (db,p__35032){
var vec__35033 = p__35032;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35033,(0),null);
var mine_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35033,(1),null);
var counts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35033,(2),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$databrowser_SLASH_model_DASH_counts,mine_name], null),counts),cljs.core.cst$kw$fetching_DASH_counts_QMARK_,false),cljs.core.cst$kw$databrowser_SLASH_node_DASH_locations,redgenes.components.databrowser.events.calculate_node_locations(counts));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$databrowser_SLASH_viewport,(function (db,p__35036){
var vec__35037 = p__35036;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35037,(0),null);
var xy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35037,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$databrowser_SLASH_viewport,xy);
}));
