// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.search.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('oops.core');
goog.require('redgenes.db');
goog.require('imcljsold.search');
redgenes.components.search.events.max_results = (99);
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_set_DASH_search_DASH_term,(function (db,p__35055){
var vec__35056 = p__35055;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35056,(0),null);
var search_term = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35056,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$search_DASH_term,search_term);
}));
/**
 * Returns the index of a result item, such that going down at the bottom loops to the top and vice versa. Element -1 is 'show all'
 */
redgenes.components.search.events.circular_index_finder = (function redgenes$components$search$events$circular_index_finder(direction){
var result_index = (function (){var G__35062 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__35062) : re_frame.core.subscribe.call(null,G__35062));
})();
var results_count = cljs.core.count((function (){var G__35063 = (function (){var G__35064 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$suggestion_DASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__35064) : re_frame.core.subscribe.call(null,G__35064));
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__35063) : cljs.core.deref.call(null,G__35063));
})());
var next_number = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(direction,cljs.core.cst$kw$next))?((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(result_index) : cljs.core.deref.call(null,result_index)) + (1)):((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(result_index) : cljs.core.deref.call(null,result_index)) - (1)));
var looped_number = (((next_number >= results_count))?(-1):(((next_number < (-1)))?(results_count - (1)):next_number
));
return looped_number;
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_move_DASH_selection,(function (db,p__35065){
var vec__35066 = p__35065;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35066,(0),null);
var direction_to_move = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35066,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index,redgenes.components.search.events.circular_index_finder(direction_to_move));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_reset_DASH_selection,(function (db,p__35069){
var vec__35070 = p__35069;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35070,(0),null);
var direction_to_move = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35070,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$quicksearch_DASH_selected_DASH_index,(-1));
}));
redgenes.components.search.events.sort_by_value = (function redgenes$components$search$events$sort_by_value(result_map){

return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by((function (key1,key2){
return cljs.core.compare(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(result_map,key2),key2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(result_map,key1),key1], null));
})),result_map);
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_save_DASH_results,(function (db,p__35073){
var vec__35074 = p__35073;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35074,(0),null);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35074,(1),null);
if(cljs.core.some_QMARK_(cljs.core.cst$kw$active_DASH_filter.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(db)))){
return cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$results], null),(results["results"])),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$loading_QMARK_], null),false);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$search_DASH_results,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$results,(results["results"]),cljs.core.cst$kw$loading_QMARK_,false,cljs.core.cst$kw$highlight_DASH_results,cljs.core.cst$kw$highlight_DASH_results.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(db)),cljs.core.cst$kw$facets,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$organisms,redgenes.components.search.events.sort_by_value(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1((results["facets"]["organism.shortName"]))),cljs.core.cst$kw$category,redgenes.components.search.events.sort_by_value(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1((results["facets"]["Category"])))], null)], null));
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_full_DASH_search,(function (p__35077){
var map__35078 = p__35077;
var map__35078__$1 = ((((!((map__35078 == null)))?((((map__35078.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35078.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35078):map__35078);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35078__$1,cljs.core.cst$kw$db);
var active_filter = cljs.core.cst$kw$active_DASH_filter.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(db));
var connection = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$current_DASH_mine),cljs.core.cst$kw$service], null));
imcljsold.search.full_search.cljs$core$IFn$_invoke$arity$variadic(connection,cljs.core.cst$kw$search_DASH_term.cljs$core$IFn$_invoke$arity$1(db),cljs.core.array_seq([active_filter], 0));

if(cljs.core.some_QMARK_(active_filter)){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$loading_QMARK_], null),true)], null);
} else {
var resultless_db = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$search_DASH_results,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$results));
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,cljs.core.assoc_in(resultless_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$loading_QMARK_], null),true)], null);
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_reset_DASH_quicksearch,(function (db){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$suggestion_DASH_results,null);
}));
redgenes.components.search.events.is_active_result_QMARK_ = (function redgenes$components$search$events$is_active_result_QMARK_(result,active_filter){

return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(active_filter,(function (){var target_obj_35086 = result;
var next_obj_35087 = (target_obj_35086["type"]);
return next_obj_35087;
})())) || ((active_filter == null));
});
redgenes.components.search.events.count_current_results = (function redgenes$components$search$events$count_current_results(results,filter){

return cljs.core.count(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.not(redgenes.components.search.events.is_active_result_QMARK_(result,filter));
}),results));
});
var G__35088_35091 = cljs.core.cst$kw$load_DASH_more_DASH_results_DASH_if_DASH_needed;
var G__35089_35092 = ((function (G__35088_35091){
return (function (search_results){
var results = cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(search_results);
var filter = cljs.core.cst$kw$active_DASH_filter.cljs$core$IFn$_invoke$arity$1(search_results);
var filtered_result_count = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$category.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$facets.cljs$core$IFn$_invoke$arity$1(search_results)),filter);
var more_filtered_results_to_show_QMARK_ = (redgenes.components.search.events.count_current_results(results,filter) < filtered_result_count);
var more_results_than_max_QMARK_ = (redgenes.components.search.events.count_current_results(results,filter) <= redgenes.components.search.events.max_results);
if((more_filtered_results_to_show_QMARK_) && (more_results_than_max_QMARK_)){
var G__35090 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_full_DASH_search], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__35090) : re_frame.core.dispatch.call(null,G__35090));
} else {
return null;
}
});})(G__35088_35091))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__35088_35091,G__35089_35092) : re_frame.core.reg_fx.call(null,G__35088_35091,G__35089_35092));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_set_DASH_active_DASH_filter,(function (p__35093,p__35094){
var map__35095 = p__35093;
var map__35095__$1 = ((((!((map__35095 == null)))?((((map__35095.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35095.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35095):map__35095);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35095__$1,cljs.core.cst$kw$db);
var vec__35096 = p__35094;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35096,(0),null);
var filter = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35096,(1),null);
var new_db = cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$active_DASH_filter], null),filter);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,new_db,cljs.core.cst$kw$load_DASH_more_DASH_results_DASH_if_DASH_needed,cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(new_db)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_remove_DASH_active_DASH_filter,(function (p__35100){
var map__35101 = p__35100;
var map__35101__$1 = ((((!((map__35101 == null)))?((((map__35101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35101.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35101):map__35101);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35101__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$search_DASH_results,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_DASH_results.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$active_DASH_filter)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_SLASH_full_DASH_search], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$search_SLASH_highlight_DASH_results,(function (db,p__35103){
var vec__35104 = p__35103;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35104,(0),null);
var highlight_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35104,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$search_DASH_results,cljs.core.cst$kw$highlight_DASH_results], null),highlight_QMARK_);
}));
