// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.events.boot');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('redgenes.db');
goog.require('redgenes.mines');
goog.require('imcljs.fetch');
goog.require('redgenes.persistence');
redgenes.events.boot.boot_flow = (function redgenes$events$boot$boot_flow(db){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$first_DASH_dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$authentication_SLASH_fetch_DASH_anonymous_DASH_token,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$current_DASH_mine)], null),cljs.core.cst$kw$rules,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$when,cljs.core.cst$kw$seen_QMARK_,cljs.core.cst$kw$events,cljs.core.cst$kw$authentication_SLASH_store_DASH_token,cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_model], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_lists], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_templates], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_widgets], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_summary_DASH_fields], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_intermine_DASH_version], null)], null)], null),new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$when,cljs.core.cst$kw$seen_DASH_all_DASH_of_QMARK_,cljs.core.cst$kw$events,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_model,cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_lists,cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_templates,cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_summary_DASH_fields,cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_widgets,cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_intermine_DASH_version], null),cljs.core.cst$kw$dispatch_DASH_n,(function (){var x__8148__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$finished_DASH_loading_DASH_assets], null);
return cljs.core._conj((function (){var x__8148__auto____$1 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$save_DASH_state], null);
return cljs.core._conj(cljs.core.List.EMPTY,x__8148__auto____$1);
})(),x__8148__auto__);
})(),cljs.core.cst$kw$halt_QMARK_,true], null)], null)], null);
});
redgenes.events.boot.im_tables_events_forwarder = (function redgenes$events$boot$im_tables_events_forwarder(){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$register,cljs.core.cst$kw$im_DASH_tables_DASH_events,cljs.core.cst$kw$events,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$imt$io_SLASH_save_DASH_list_DASH_success,null], null), null),cljs.core.cst$kw$dispatch_DASH_to,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_fetch_DASH_lists], null)], null);
});
/**
 * This method is implemented for robust updates. It ensures that local-storage client-cached mine entries are deleted if the mine entry is removed from mines.cljc. Goes hand in hand with get-active mine to ensure that we still have an active mine to select
 */
redgenes.events.boot.get_current_mines = (function redgenes$events$boot$get_current_mines(state_mines,config_mines){
var good_mines = cljs.core.set(cljs.core.keys(config_mines));
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (good_mines){
return (function (new_mine_list,p__35299){
var vec__35300 = p__35299;
var mine_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35300,(0),null);
var details = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35300,(1),null);
if(cljs.core.contains_QMARK_(good_mines,mine_name)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_mine_list,mine_name,details);
} else {
return null;
}
});})(good_mines))
,cljs.core.PersistentArrayMap.EMPTY,state_mines));
});
/**
 * Return the current mine if it still exists after a config update, or else just return the first one if the ID doesn't exist for some reason
 */
redgenes.events.boot.get_active_mine = (function redgenes$events$boot$get_active_mine(all_mines,mine_name){
var mine_names = cljs.core.set(cljs.core.keys(all_mines));
if(cljs.core.contains_QMARK_(mine_names,mine_name)){
return mine_name;
} else {
console.debug(cljs.core.clj__GT_js(mine_name),"doesn't exist so we've auto-selected the first available mine");

return cljs.core.first(mine_names);
}
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boot,(function (){
var db = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(redgenes.db.default_db,cljs.core.cst$kw$mines,redgenes.mines.mines);
var state = redgenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$0();
var has_state_QMARK_ = cljs.core.seq(state);
var good_state_mines = redgenes.events.boot.get_current_mines(cljs.core.cst$kw$mines.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$mines.cljs$core$IFn$_invoke$arity$1(db));
var all_mines = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([redgenes.mines.mines,good_state_mines], 0));
var current_mine = redgenes.events.boot.get_active_mine(all_mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(state));
if(has_state_QMARK_){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(redgenes.db.default_db,cljs.core.cst$kw$current_DASH_mine,current_mine,cljs.core.array_seq([cljs.core.cst$kw$mines,all_mines,cljs.core.cst$kw$assets,cljs.core.cst$kw$assets.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$fetching_DASH_assets_QMARK_,false], 0)),cljs.core.cst$kw$async_DASH_flow,redgenes.events.boot.boot_flow(db),cljs.core.cst$kw$forward_DASH_events,redgenes.events.boot.im_tables_events_forwarder()], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(redgenes.db.default_db,cljs.core.cst$kw$mines,redgenes.mines.mines,cljs.core.array_seq([cljs.core.cst$kw$fetching_DASH_assets_QMARK_,true], 0)),cljs.core.cst$kw$async_DASH_flow,redgenes.events.boot.boot_flow(db),cljs.core.cst$kw$forward_DASH_events,redgenes.events.boot.im_tables_events_forwarder()], null);
}
}));
/**
 * Any tools / components that have mine-specific state should lose that state if we switch mines. For example, in list upload (ID Resolver), drosophila IDs are no longer valid when using humanmine.
 */
redgenes.events.boot.remove_stateful_keys_from_db = (function redgenes$events$boot$remove_stateful_keys_from_db(db){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$regions,cljs.core.array_seq([cljs.core.cst$kw$idresolver,cljs.core.cst$kw$results], 0));
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$reboot,(function (p__35303){
var map__35304 = p__35303;
var map__35304__$1 = ((((!((map__35304 == null)))?((((map__35304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35304.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35304):map__35304);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35304__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,redgenes.events.boot.remove_stateful_keys_from_db(db),cljs.core.cst$kw$async_DASH_flow,redgenes.events.boot.boot_flow(db)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$finished_DASH_loading_DASH_assets,(function (p__35306){
var map__35307 = p__35306;
var map__35307__$1 = ((((!((map__35307 == null)))?((((map__35307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35307.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35307):map__35307);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35307__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$fetching_DASH_assets_QMARK_,false),cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache_SLASH_fetch_DASH_organisms], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_load_DASH_lists], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_select_DASH_all_DASH_feature_DASH_types], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$authentication_SLASH_store_DASH_token,(function (db,p__35309){
var vec__35310 = p__35309;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35310,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35310,(1),null);
var token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35310,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,mine_kw,cljs.core.cst$kw$service,cljs.core.cst$kw$token], null),token);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$authentication_SLASH_fetch_DASH_anonymous_DASH_token,(function (p__35313,p__35314){
var map__35315 = p__35313;
var map__35315__$1 = ((((!((map__35315 == null)))?((((map__35315.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35315.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35315):map__35315);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35315__$1,cljs.core.cst$kw$db);
var vec__35316 = p__35314;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35316,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35316,(1),null);
var mine = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,mine_kw,cljs.core.cst$kw$service], null)),cljs.core.cst$kw$token);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$authentication_SLASH_store_DASH_token,mine_kw], null),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.session,mine)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_model,(function (db,p__35320){
var vec__35321 = p__35320;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35321,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35321,(1),null);
var model = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35321,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,mine_kw,cljs.core.cst$kw$service,cljs.core.cst$kw$model], null),model);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_model,(function (p__35324){
var map__35325 = p__35324;
var map__35325__$1 = ((((!((map__35325 == null)))?((((map__35325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35325):map__35325);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35325__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.model,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_model,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_lists,(function (db,p__35327){
var vec__35328 = p__35327;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35328,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35328,(1),null);
var lists = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35328,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$lists,mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_lists,(function (p__35331){
var map__35332 = p__35331;
var map__35332__$1 = ((((!((map__35332 == null)))?((((map__35332.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35332.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35332):map__35332);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35332__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.lists,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_lists,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_templates,(function (db,p__35334){
var vec__35335 = p__35334;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35335,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35335,(1),null);
var lists = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35335,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$templates,mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_templates,(function (p__35338){
var map__35339 = p__35338;
var map__35339__$1 = ((((!((map__35339 == null)))?((((map__35339.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35339.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35339):map__35339);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35339__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.templates,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_templates,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_summary_DASH_fields,(function (db,p__35341){
var vec__35342 = p__35341;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35342,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35342,(1),null);
var lists = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35342,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$summary_DASH_fields,mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_summary_DASH_fields,(function (p__35345){
var map__35346 = p__35345;
var map__35346__$1 = ((((!((map__35346 == null)))?((((map__35346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35346):map__35346);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35346__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.summary_fields,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_summary_DASH_fields,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_widgets,(function (p__35348){
var map__35349 = p__35348;
var map__35349__$1 = ((((!((map__35349 == null)))?((((map__35349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35349.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35349):map__35349);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35349__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.widgets,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_widgets,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_widgets,(function (db,p__35351){
var vec__35352 = p__35351;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35352,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35352,(1),null);
var widgets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35352,(2),null);
var widget_type = "enrichment";
var filtered_widgets = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (widget_type,vec__35352,_,mine_kw,widgets){
return (function (widget){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(widget_type,cljs.core.cst$kw$widgetType.cljs$core$IFn$_invoke$arity$1(widget));
});})(widget_type,vec__35352,_,mine_kw,widgets))
,cljs.core.cst$kw$widgets.cljs$core$IFn$_invoke$arity$1(widgets)));
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$widgets,mine_kw], null),filtered_widgets);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_fetch_DASH_intermine_DASH_version,(function (p__35355){
var map__35356 = p__35355;
var map__35356__$1 = ((((!((map__35356 == null)))?((((map__35356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35356.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35356):map__35356);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35356__$1,cljs.core.cst$kw$db);
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.fetch.version_intermine,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null))),cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_intermine_DASH_version,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$assets_SLASH_success_DASH_fetch_DASH_intermine_DASH_version,(function (db,p__35358){
var vec__35359 = p__35358;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35359,(0),null);
var mine_kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35359,(1),null);
var version = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35359,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$intermine_DASH_version,mine_kw], null),version);
}));
