// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.utils');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('day8.re_frame.undo');
goog.require('clojure.string');
/**
 * 
 *   Helper for registering re-frame events
 *   using metadata of their vars
 * 
 *   Note: because CLJS only allows statically compiled metadata
 *   for vars, we can't pass-in fns in metadata maps for those
 *   vars because they're not evaluated and just end-up as lists.
 *   That's why if the :undo-exp is a keyword, it
 *   signals that the event fn includes a 3-arity implementation
 *   for returning a re-frame string explanation dynamically
 *   
 */
redgenes.utils.register_BANG_ = (function redgenes$utils$register_BANG_(var_args){
var args29392 = [];
var len__8435__auto___29399 = arguments.length;
var i__8436__auto___29400 = (0);
while(true){
if((i__8436__auto___29400 < len__8435__auto___29399)){
args29392.push((arguments[i__8436__auto___29400]));

var G__29401 = (i__8436__auto___29400 + (1));
i__8436__auto___29400 = G__29401;
continue;
} else {
}
break;
}

var G__29394 = args29392.length;
switch (G__29394) {
case 1:
return redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29392.length)].join('')));

}
});
goog.exportSymbol('redgenes.utils.register_BANG_', redgenes.utils.register_BANG_);

redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (v){
return redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(v) : cljs.core.deref.call(null,v)),cljs.core.meta(v));
});

redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (f,p__29395){
var map__29396 = p__29395;
var map__29396__$1 = ((((!((map__29396 == null)))?((((map__29396.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29396.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29396):map__29396);
var reframe_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29396__$1,cljs.core.cst$kw$reframe_DASH_key);
var reframe_kind = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29396__$1,cljs.core.cst$kw$reframe_DASH_kind);
var naym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29396__$1,cljs.core.cst$kw$name);
var undoable_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29396__$1,cljs.core.cst$kw$undoable_QMARK_,false);
var undo_exp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29396__$1,cljs.core.cst$kw$undo_DASH_exp);
var G__29398 = (((reframe_kind instanceof cljs.core.Keyword))?reframe_kind.fqn:null);
switch (G__29398) {
case "event":
if(cljs.core.truth_(undoable_QMARK_)){
return re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(reframe_key,day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$1((((undo_exp instanceof cljs.core.Keyword))?((function (G__29398,map__29396,map__29396__$1,reframe_key,reframe_kind,naym,undoable_QMARK_,undo_exp){
return (function (db,ev){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3((1),db,ev) : f.call(null,(1),db,ev));
});})(G__29398,map__29396,map__29396__$1,reframe_key,reframe_kind,naym,undoable_QMARK_,undo_exp))
:undo_exp)),f);
} else {
return re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(reframe_key,f);
}

break;
case "cofx":
if(cljs.core.truth_(undoable_QMARK_)){
return re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(reframe_key,day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$1((((undo_exp instanceof cljs.core.Keyword))?((function (G__29398,map__29396,map__29396__$1,reframe_key,reframe_kind,naym,undoable_QMARK_,undo_exp){
return (function (db,ev){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3((1),db,ev) : f.call(null,(1),db,ev));
});})(G__29398,map__29396,map__29396__$1,reframe_key,reframe_kind,naym,undoable_QMARK_,undo_exp))
:undo_exp)),f);
} else {
return re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(reframe_key,f);
}

break;
case "fx":
return (re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(reframe_key,f) : re_frame.core.reg_fx.call(null,reframe_key,f));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(reframe_kind)].join('')));

}
});

redgenes.utils.register_BANG_.cljs$lang$maxFixedArity = 2;

/**
 * Registers all the given vars
 */
redgenes.utils.register_all_BANG_ = (function redgenes$utils$register_all_BANG_(vars){
var seq__29408 = cljs.core.seq(vars);
var chunk__29409 = null;
var count__29410 = (0);
var i__29411 = (0);
while(true){
if((i__29411 < count__29410)){
var v = chunk__29409.cljs$core$IIndexed$_nth$arity$2(null,i__29411);
redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$1(v);

var G__29412 = seq__29408;
var G__29413 = chunk__29409;
var G__29414 = count__29410;
var G__29415 = (i__29411 + (1));
seq__29408 = G__29412;
chunk__29409 = G__29413;
count__29410 = G__29414;
i__29411 = G__29415;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__29408);
if(temp__6753__auto__){
var seq__29408__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29408__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__29408__$1);
var G__29416 = cljs.core.chunk_rest(seq__29408__$1);
var G__29417 = c__8125__auto__;
var G__29418 = cljs.core.count(c__8125__auto__);
var G__29419 = (0);
seq__29408 = G__29416;
chunk__29409 = G__29417;
count__29410 = G__29418;
i__29411 = G__29419;
continue;
} else {
var v = cljs.core.first(seq__29408__$1);
redgenes.utils.register_BANG_.cljs$core$IFn$_invoke$arity$1(v);

var G__29420 = cljs.core.next(seq__29408__$1);
var G__29421 = null;
var G__29422 = (0);
var G__29423 = (0);
seq__29408 = G__29420;
chunk__29409 = G__29421;
count__29410 = G__29422;
i__29411 = G__29423;
continue;
}
} else {
return null;
}
}
break;
}
});
goog.exportSymbol('redgenes.utils.register_all_BANG_', redgenes.utils.register_all_BANG_);
/**
 * Registers all the given subscriptions
 *   e.g. [[:constraint :query-builder/current-constraint]]
 */
redgenes.utils.reg_all_subs_BANG_ = (function redgenes$utils$reg_all_subs_BANG_(queries){
var seq__29438 = cljs.core.seq(queries);
var chunk__29439 = null;
var count__29440 = (0);
var i__29441 = (0);
while(true){
if((i__29441 < count__29440)){
var vec__29442 = chunk__29439.cljs$core$IIndexed$_nth$arity$2(null,i__29441);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(0),null);
var kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29442,(1),null);
var G__29445_29452 = (function (){var or__7219__auto__ = kw;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(cljs.core.cst$kw$query_DASH_builder),cljs.core.name(path));
}
})();
var G__29446_29453 = ((function (seq__29438,chunk__29439,count__29440,i__29441,G__29445_29452,vec__29442,path,kw){
return (function (db,_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,path], null));
});})(seq__29438,chunk__29439,count__29440,i__29441,G__29445_29452,vec__29442,path,kw))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__29445_29452,G__29446_29453) : re_frame.core.reg_sub.call(null,G__29445_29452,G__29446_29453));

var G__29454 = seq__29438;
var G__29455 = chunk__29439;
var G__29456 = count__29440;
var G__29457 = (i__29441 + (1));
seq__29438 = G__29454;
chunk__29439 = G__29455;
count__29440 = G__29456;
i__29441 = G__29457;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__29438);
if(temp__6753__auto__){
var seq__29438__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29438__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__29438__$1);
var G__29458 = cljs.core.chunk_rest(seq__29438__$1);
var G__29459 = c__8125__auto__;
var G__29460 = cljs.core.count(c__8125__auto__);
var G__29461 = (0);
seq__29438 = G__29458;
chunk__29439 = G__29459;
count__29440 = G__29460;
i__29441 = G__29461;
continue;
} else {
var vec__29447 = cljs.core.first(seq__29438__$1);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(0),null);
var kw = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29447,(1),null);
var G__29450_29462 = (function (){var or__7219__auto__ = kw;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(cljs.core.name(cljs.core.cst$kw$query_DASH_builder),cljs.core.name(path));
}
})();
var G__29451_29463 = ((function (seq__29438,chunk__29439,count__29440,i__29441,G__29450_29462,vec__29447,path,kw,seq__29438__$1,temp__6753__auto__){
return (function (db,_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,path], null));
});})(seq__29438,chunk__29439,count__29440,i__29441,G__29450_29462,vec__29447,path,kw,seq__29438__$1,temp__6753__auto__))
;
(re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub.cljs$core$IFn$_invoke$arity$2(G__29450_29462,G__29451_29463) : re_frame.core.reg_sub.call(null,G__29450_29462,G__29451_29463));

var G__29464 = cljs.core.next(seq__29438__$1);
var G__29465 = null;
var G__29466 = (0);
var G__29467 = (0);
seq__29438 = G__29464;
chunk__29439 = G__29465;
count__29440 = G__29466;
i__29441 = G__29467;
continue;
}
} else {
return null;
}
}
break;
}
});
goog.exportSymbol('redgenes.utils.reg_all_subs_BANG_', redgenes.utils.reg_all_subs_BANG_);
