// Compiled by ClojureScript 1.9.89 {}
goog.provide('redgenes.components.search.views');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('redgenes.components.search.filters');
goog.require('redgenes.components.search.resultrow');
goog.require('clojure.string');
goog.require('re_frame.core');
redgenes.components.search.views.search_results = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"results","results",-1134170113),null], null));
redgenes.components.search.views.max_results = (99);
redgenes.components.search.views.sort_by_value = (function redgenes$components$search$views$sort_by_value(result_map){

return cljs.core.into.call(null,cljs.core.sorted_map_by.call(null,(function (key1,key2){
return cljs.core.compare.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,result_map,key2),key2], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,result_map,key1),key1], null));
})),result_map);
});
redgenes.components.search.views.results_handler = (function redgenes$components$search$views$results_handler(results,searchterm){

if(cljs.core.truth_(new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)))){
return cljs.core.swap_BANG_.call(null,redgenes.components.search.views.search_results,cljs.core.assoc,new cljs.core.Keyword(null,"results","results",-1134170113),results.results,new cljs.core.Keyword(null,"term","term",-1817390416),searchterm);
} else {
return cljs.core.reset_BANG_.call(null,redgenes.components.search.views.search_results,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"results","results",-1134170113),results.results,new cljs.core.Keyword(null,"term","term",-1817390416),searchterm,new cljs.core.Keyword(null,"highlight-results","highlight-results",1638973719),new cljs.core.Keyword(null,"highlight-results","highlight-results",1638973719).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)),new cljs.core.Keyword(null,"facets","facets",-2061519464),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"organisms","organisms",-239799703),redgenes.components.search.views.sort_by_value.call(null,cljs.core.js__GT_clj.call(null,(results["facets"]["organism.shortName"]))),new cljs.core.Keyword(null,"category","category",-593092832),redgenes.components.search.views.sort_by_value.call(null,cljs.core.js__GT_clj.call(null,(results["facets"]["Category"])))], null)], null));
}
});
/**
 * search for the given term via IMJS promise. Filter is optional
 */
redgenes.components.search.views.search = (function redgenes$components$search$views$search(var_args){
var args__13331__auto__ = [];
var len__13324__auto___27444 = arguments.length;
var i__13325__auto___27445 = (0);
while(true){
if((i__13325__auto___27445 < len__13324__auto___27444)){
args__13331__auto__.push((arguments[i__13325__auto___27445]));

var G__27446 = (i__13325__auto___27445 + (1));
i__13325__auto___27445 = G__27446;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((0) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((0)),(0),null)):null);
return redgenes.components.search.views.search.cljs$core$IFn$_invoke$arity$variadic(argseq__13332__auto__);
});

redgenes.components.search.views.search.cljs$core$IFn$_invoke$arity$variadic = (function (filter){
var searchterm = cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-term","search-term",356193544)], null)));
var mine = (new imjs.Service(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mine-url","mine-url",1768733452)], null)))], null))));
var search = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"q","q",689001697),searchterm,new cljs.core.Keyword(null,"Category","Category",-250769744),filter], null);
var id_promise = mine.search(cljs.core.clj__GT_js.call(null,search));
return id_promise.then(((function (searchterm,mine,search,id_promise){
return (function (results){
return redgenes.components.search.views.results_handler.call(null,results,searchterm);
});})(searchterm,mine,search,id_promise))
);
});

redgenes.components.search.views.search.cljs$lang$maxFixedArity = (0);

redgenes.components.search.views.search.cljs$lang$applyTo = (function (seq27443){
return redgenes.components.search.views.search.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27443));
});

redgenes.components.search.views.is_active_result_QMARK_ = (function redgenes$components$search$views$is_active_result_QMARK_(result){

return (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)),result.type)) || ((new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)) == null));
});
redgenes.components.search.views.count_total_results = (function redgenes$components$search$views$count_total_results(state){

return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.vals.call(null,new cljs.core.Keyword(null,"category","category",-593092832).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"facets","facets",-2061519464).cljs$core$IFn$_invoke$arity$1(state))));
});
redgenes.components.search.views.count_current_results = (function redgenes$components$search$views$count_current_results(){

return cljs.core.count.call(null,cljs.core.remove.call(null,(function (result){
return cljs.core.not.call(null,redgenes.components.search.views.is_active_result_QMARK_.call(null,result));
}),new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results))));
});
redgenes.components.search.views.results_count = (function redgenes$components$search$views$results_count(){

return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"small","small",2133478704)," Displaying ",redgenes.components.search.views.count_current_results.call(null)," of ",redgenes.components.search.views.count_total_results.call(null,cljs.core.deref.call(null,redgenes.components.search.views.search_results))," results"], null);
});
redgenes.components.search.views.load_more_results = (function redgenes$components$search$views$load_more_results(api,search_term){
return redgenes.components.search.views.search.call(null,new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)));
});
redgenes.components.search.views.results_display = (function redgenes$components$search$views$results_display(api,search_term){

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results","div.results",1001372547),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),"Results for '",new cljs.core.Keyword(null,"term","term",-1817390416).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,redgenes.components.search.views.search_results)),"'",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.views.results_count], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),cljs.core.doall.call(null,(function (){var state = redgenes.components.search.views.search_results;
var active_results = cljs.core.filter.call(null,((function (state){
return (function (result){
return redgenes.components.search.views.is_active_result_QMARK_.call(null,result);
});})(state))
,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)));
var filtered_result_count = cljs.core.get.call(null,new cljs.core.Keyword(null,"category","category",-593092832).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"facets","facets",-2061519464).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state))),new cljs.core.Keyword(null,"active-filter","active-filter",845441376).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)));
if(((redgenes.components.search.views.count_current_results.call(null) < filtered_result_count)) && ((redgenes.components.search.views.count_current_results.call(null) <= redgenes.components.search.views.max_results))){
redgenes.components.search.views.load_more_results.call(null,api,search_term);
} else {
}

var iter__13029__auto__ = ((function (state,active_results,filtered_result_count){
return (function redgenes$components$search$views$results_display_$_iter__27451(s__27452){
return (new cljs.core.LazySeq(null,((function (state,active_results,filtered_result_count){
return (function (){
var s__27452__$1 = s__27452;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__27452__$1);
if(temp__4657__auto__){
var s__27452__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27452__$2)){
var c__13027__auto__ = cljs.core.chunk_first.call(null,s__27452__$2);
var size__13028__auto__ = cljs.core.count.call(null,c__13027__auto__);
var b__27454 = cljs.core.chunk_buffer.call(null,size__13028__auto__);
if((function (){var i__27453 = (0);
while(true){
if((i__27453 < size__13028__auto__)){
var result = cljs.core._nth.call(null,c__13027__auto__,i__27453);
cljs.core.chunk_append.call(null,b__27454,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.resultrow.result_row,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"result","result",1415092211),result,new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"api","api",-899839580),api,new cljs.core.Keyword(null,"search-term","search-term",356193544),cljs.core.deref.call(null,search_term)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),result.id], null)));

var G__27455 = (i__27453 + (1));
i__27453 = G__27455;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27454),redgenes$components$search$views$results_display_$_iter__27451.call(null,cljs.core.chunk_rest.call(null,s__27452__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27454),null);
}
} else {
var result = cljs.core.first.call(null,s__27452__$2);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.resultrow.result_row,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"result","result",1415092211),result,new cljs.core.Keyword(null,"state","state",-1988618099),state,new cljs.core.Keyword(null,"api","api",-899839580),api,new cljs.core.Keyword(null,"search-term","search-term",356193544),cljs.core.deref.call(null,search_term)], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),result.id], null)),redgenes$components$search$views$results_display_$_iter__27451.call(null,cljs.core.rest.call(null,s__27452__$2)));
}
} else {
return null;
}
break;
}
});})(state,active_results,filtered_result_count))
,null,null));
});})(state,active_results,filtered_result_count))
;
return iter__13029__auto__.call(null,active_results);
})())], null)], null);
});
redgenes.components.search.views.search_form = (function redgenes$components$search$views$search_form(search_term,api){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.search-fullscreen","div.search-fullscreen",-1793638630),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.response","div.response",1075872876),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.filters.facet_display,redgenes.components.search.views.search_results,api,redgenes.components.search.views.search,cljs.core.deref.call(null,search_term)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.views.results_display,api,search_term], null)], null)], null);
});
redgenes.components.search.views.main = (function redgenes$components$search$views$main(){
var global_search_term = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search-term","search-term",356193544)], null));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (global_search_term){
return (function redgenes$components$search$views$main_$_render(p__27461){
var map__27464 = p__27461;
var map__27464__$1 = ((((!((map__27464 == null)))?((((map__27464.cljs$lang$protocol_mask$partition0$ & (64))) || (map__27464.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27464):map__27464);
var state = cljs.core.get.call(null,map__27464__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var upstream_data = cljs.core.get.call(null,map__27464__$1,new cljs.core.Keyword(null,"upstream-data","upstream-data",1200770060));
var api = cljs.core.get.call(null,map__27464__$1,new cljs.core.Keyword(null,"api","api",-899839580));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.search.views.search_form,global_search_term,api], null);
});})(global_search_term))
,new cljs.core.Keyword(null,"component-will-mount","component-will-mount",209708855),((function (global_search_term){
return (function (this$){
var api = new cljs.core.Keyword(null,"api","api",-899839580).cljs$core$IFn$_invoke$arity$1(reagent.core.props.call(null,this$));
if(cljs.core.some_QMARK_.call(null,global_search_term)){
return redgenes.components.search.views.search.call(null);
} else {
return null;
}
});})(global_search_term))
,new cljs.core.Keyword(null,"component-will-update","component-will-update",335247566),((function (global_search_term){
return (function (this$){
var api = new cljs.core.Keyword(null,"api","api",-899839580).cljs$core$IFn$_invoke$arity$1(reagent.core.props.call(null,this$));
return redgenes.components.search.views.search.call(null);
});})(global_search_term))
], null));
});
goog.exportSymbol('redgenes.components.search.views.main', redgenes.components.search.views.main);

//# sourceMappingURL=views.js.map?rel=1473935461355