// Compiled by ClojureScript 1.9.89 {}
goog.provide('cognitect.transit');
goog.require('cljs.core');
goog.require('com.cognitect.transit');
goog.require('com.cognitect.transit.types');
goog.require('com.cognitect.transit.eq');
goog.require('goog.math.Long');
cljs.core.UUID.prototype.cljs$core$IEquiv$ = true;

cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return (this$__$1.uuid === other.uuid);
} else {
if((other instanceof com.cognitect.transit.types.UUID)){
return (this$__$1.uuid === other.toString());
} else {
return false;

}
}
});
cljs.core.UUID.prototype.cljs$core$IComparable$ = true;

cljs.core.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if(((other instanceof cljs.core.UUID)) || ((other instanceof com.cognitect.transit.types.UUID))){
return cljs.core.compare.call(null,this$__$1.toString(),other.toString());
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
goog.math.Long.prototype.cljs$core$IEquiv$ = true;

goog.math.Long.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof cljs.core.UUID)){
return cljs.core._equiv.call(null,other,this$__$1);
} else {
return this$__$1.equiv(other);
}
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var this$__$1 = this;
return this$__$1.equiv(other);
});
goog.math.Long.prototype.cljs$core$IHash$ = true;

goog.math.Long.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.hash.call(null,this$__$1.toString());
});

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$ = true;

com.cognitect.transit.types.TaggedValue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this$__$1 = this;
return com.cognitect.transit.eq.hashCode.call(null,this$__$1);
});
com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$ = true;

com.cognitect.transit.types.UUID.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (uuid,writer,_){
var uuid__$1 = this;
return cljs.core._write.call(null,writer,[cljs.core.str("#uuid \""),cljs.core.str(uuid__$1.toString()),cljs.core.str("\"")].join(''));
});
cognitect.transit.opts_merge = (function cognitect$transit$opts_merge(a,b){
var seq__14583_14587 = cljs.core.seq.call(null,cljs.core.js_keys.call(null,b));
var chunk__14584_14588 = null;
var count__14585_14589 = (0);
var i__14586_14590 = (0);
while(true){
if((i__14586_14590 < count__14585_14589)){
var k_14591 = cljs.core._nth.call(null,chunk__14584_14588,i__14586_14590);
var v_14592 = (b[k_14591]);
(a[k_14591] = v_14592);

var G__14593 = seq__14583_14587;
var G__14594 = chunk__14584_14588;
var G__14595 = count__14585_14589;
var G__14596 = (i__14586_14590 + (1));
seq__14583_14587 = G__14593;
chunk__14584_14588 = G__14594;
count__14585_14589 = G__14595;
i__14586_14590 = G__14596;
continue;
} else {
var temp__4657__auto___14597 = cljs.core.seq.call(null,seq__14583_14587);
if(temp__4657__auto___14597){
var seq__14583_14598__$1 = temp__4657__auto___14597;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14583_14598__$1)){
var c__13060__auto___14599 = cljs.core.chunk_first.call(null,seq__14583_14598__$1);
var G__14600 = cljs.core.chunk_rest.call(null,seq__14583_14598__$1);
var G__14601 = c__13060__auto___14599;
var G__14602 = cljs.core.count.call(null,c__13060__auto___14599);
var G__14603 = (0);
seq__14583_14587 = G__14600;
chunk__14584_14588 = G__14601;
count__14585_14589 = G__14602;
i__14586_14590 = G__14603;
continue;
} else {
var k_14604 = cljs.core.first.call(null,seq__14583_14598__$1);
var v_14605 = (b[k_14604]);
(a[k_14604] = v_14605);

var G__14606 = cljs.core.next.call(null,seq__14583_14598__$1);
var G__14607 = null;
var G__14608 = (0);
var G__14609 = (0);
seq__14583_14587 = G__14606;
chunk__14584_14588 = G__14607;
count__14585_14589 = G__14608;
i__14586_14590 = G__14609;
continue;
}
} else {
}
}
break;
}

return a;
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapBuilder = (function (){
})
cognitect.transit.MapBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cognitect.transit.MapBuilder.prototype.add = (function (m,k,v,node){
var self__ = this;
var _ = this;
return cljs.core.assoc_BANG_.call(null,m,k,v);
});

cognitect.transit.MapBuilder.prototype.finalize = (function (m,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,m);
});

cognitect.transit.MapBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentArrayMap.fromArray.call(null,arr,true,true);
});

cognitect.transit.MapBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapBuilder.cljs$lang$type = true;

cognitect.transit.MapBuilder.cljs$lang$ctorStr = "cognitect.transit/MapBuilder";

cognitect.transit.MapBuilder.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/MapBuilder");
});

cognitect.transit.__GT_MapBuilder = (function cognitect$transit$__GT_MapBuilder(){
return (new cognitect.transit.MapBuilder());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorBuilder = (function (){
})
cognitect.transit.VectorBuilder.prototype.init = (function (node){
var self__ = this;
var _ = this;
return cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
});

cognitect.transit.VectorBuilder.prototype.add = (function (v,x,node){
var self__ = this;
var _ = this;
return cljs.core.conj_BANG_.call(null,v,x);
});

cognitect.transit.VectorBuilder.prototype.finalize = (function (v,node){
var self__ = this;
var _ = this;
return cljs.core.persistent_BANG_.call(null,v);
});

cognitect.transit.VectorBuilder.prototype.fromArray = (function (arr,node){
var self__ = this;
var _ = this;
return cljs.core.PersistentVector.fromArray.call(null,arr,true);
});

cognitect.transit.VectorBuilder.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorBuilder.cljs$lang$type = true;

cognitect.transit.VectorBuilder.cljs$lang$ctorStr = "cognitect.transit/VectorBuilder";

cognitect.transit.VectorBuilder.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/VectorBuilder");
});

cognitect.transit.__GT_VectorBuilder = (function cognitect$transit$__GT_VectorBuilder(){
return (new cognitect.transit.VectorBuilder());
});

/**
 * Return a transit reader. type may be either :json or :json-verbose.
 * opts may be a map optionally containing a :handlers entry. The value
 * of :handlers should be map from tag to a decoder function which returns
 * then in-memory representation of the semantic transit value.
 */
cognitect.transit.reader = (function cognitect$transit$reader(var_args){
var args14610 = [];
var len__13324__auto___14613 = arguments.length;
var i__13325__auto___14614 = (0);
while(true){
if((i__13325__auto___14614 < len__13324__auto___14613)){
args14610.push((arguments[i__13325__auto___14614]));

var G__14615 = (i__13325__auto___14614 + (1));
i__13325__auto___14614 = G__14615;
continue;
} else {
}
break;
}

var G__14612 = args14610.length;
switch (G__14612) {
case 1:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14610.length)].join('')));

}
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.reader.call(null,type,null);
});

cognitect.transit.reader.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
return com.cognitect.transit.reader.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"handlers": cljs.core.clj__GT_js.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 5, ["$",(function (v){
return cljs.core.symbol.call(null,v);
}),":",(function (v){
return cljs.core.keyword.call(null,v);
}),"set",(function (v){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,v);
}),"list",(function (v){
return cljs.core.into.call(null,cljs.core.List.EMPTY,v.reverse());
}),"cmap",(function (v){
var i = (0);
var ret = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < v.length)){
var G__14617 = (i + (2));
var G__14618 = cljs.core.assoc_BANG_.call(null,ret,(v[i]),(v[(i + (1))]));
i = G__14617;
ret = G__14618;
continue;
} else {
return cljs.core.persistent_BANG_.call(null,ret);
}
break;
}
})], null),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts))), "mapBuilder": (new cognitect.transit.MapBuilder()), "arrayBuilder": (new cognitect.transit.VectorBuilder()), "prefersStrings": false},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.reader.cljs$lang$maxFixedArity = 2;

/**
 * Read a transit encoded string into ClojureScript values given a 
 * transit reader.
 */
cognitect.transit.read = (function cognitect$transit$read(r,str){
return r.read(str);
});

/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.KeywordHandler = (function (){
})
cognitect.transit.KeywordHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return ":";
});

cognitect.transit.KeywordHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.fqn;
});

cognitect.transit.KeywordHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.KeywordHandler.cljs$lang$type = true;

cognitect.transit.KeywordHandler.cljs$lang$ctorStr = "cognitect.transit/KeywordHandler";

cognitect.transit.KeywordHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/KeywordHandler");
});

cognitect.transit.__GT_KeywordHandler = (function cognitect$transit$__GT_KeywordHandler(){
return (new cognitect.transit.KeywordHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SymbolHandler = (function (){
})
cognitect.transit.SymbolHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "$";
});

cognitect.transit.SymbolHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return v.str;
});

cognitect.transit.SymbolHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SymbolHandler.cljs$lang$type = true;

cognitect.transit.SymbolHandler.cljs$lang$ctorStr = "cognitect.transit/SymbolHandler";

cognitect.transit.SymbolHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/SymbolHandler");
});

cognitect.transit.__GT_SymbolHandler = (function cognitect$transit$__GT_SymbolHandler(){
return (new cognitect.transit.SymbolHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.ListHandler = (function (){
})
cognitect.transit.ListHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "list";
});

cognitect.transit.ListHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__14619_14623 = cljs.core.seq.call(null,v);
var chunk__14620_14624 = null;
var count__14621_14625 = (0);
var i__14622_14626 = (0);
while(true){
if((i__14622_14626 < count__14621_14625)){
var x_14627 = cljs.core._nth.call(null,chunk__14620_14624,i__14622_14626);
ret.push(x_14627);

var G__14628 = seq__14619_14623;
var G__14629 = chunk__14620_14624;
var G__14630 = count__14621_14625;
var G__14631 = (i__14622_14626 + (1));
seq__14619_14623 = G__14628;
chunk__14620_14624 = G__14629;
count__14621_14625 = G__14630;
i__14622_14626 = G__14631;
continue;
} else {
var temp__4657__auto___14632 = cljs.core.seq.call(null,seq__14619_14623);
if(temp__4657__auto___14632){
var seq__14619_14633__$1 = temp__4657__auto___14632;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14619_14633__$1)){
var c__13060__auto___14634 = cljs.core.chunk_first.call(null,seq__14619_14633__$1);
var G__14635 = cljs.core.chunk_rest.call(null,seq__14619_14633__$1);
var G__14636 = c__13060__auto___14634;
var G__14637 = cljs.core.count.call(null,c__13060__auto___14634);
var G__14638 = (0);
seq__14619_14623 = G__14635;
chunk__14620_14624 = G__14636;
count__14621_14625 = G__14637;
i__14622_14626 = G__14638;
continue;
} else {
var x_14639 = cljs.core.first.call(null,seq__14619_14633__$1);
ret.push(x_14639);

var G__14640 = cljs.core.next.call(null,seq__14619_14633__$1);
var G__14641 = null;
var G__14642 = (0);
var G__14643 = (0);
seq__14619_14623 = G__14640;
chunk__14620_14624 = G__14641;
count__14621_14625 = G__14642;
i__14622_14626 = G__14643;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.ListHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.ListHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.ListHandler.cljs$lang$type = true;

cognitect.transit.ListHandler.cljs$lang$ctorStr = "cognitect.transit/ListHandler";

cognitect.transit.ListHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/ListHandler");
});

cognitect.transit.__GT_ListHandler = (function cognitect$transit$__GT_ListHandler(){
return (new cognitect.transit.ListHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.MapHandler = (function (){
})
cognitect.transit.MapHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "map";
});

cognitect.transit.MapHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v;
});

cognitect.transit.MapHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.MapHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.MapHandler.cljs$lang$type = true;

cognitect.transit.MapHandler.cljs$lang$ctorStr = "cognitect.transit/MapHandler";

cognitect.transit.MapHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/MapHandler");
});

cognitect.transit.__GT_MapHandler = (function cognitect$transit$__GT_MapHandler(){
return (new cognitect.transit.MapHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.SetHandler = (function (){
})
cognitect.transit.SetHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "set";
});

cognitect.transit.SetHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__14644_14648 = cljs.core.seq.call(null,v);
var chunk__14645_14649 = null;
var count__14646_14650 = (0);
var i__14647_14651 = (0);
while(true){
if((i__14647_14651 < count__14646_14650)){
var x_14652 = cljs.core._nth.call(null,chunk__14645_14649,i__14647_14651);
ret.push(x_14652);

var G__14653 = seq__14644_14648;
var G__14654 = chunk__14645_14649;
var G__14655 = count__14646_14650;
var G__14656 = (i__14647_14651 + (1));
seq__14644_14648 = G__14653;
chunk__14645_14649 = G__14654;
count__14646_14650 = G__14655;
i__14647_14651 = G__14656;
continue;
} else {
var temp__4657__auto___14657 = cljs.core.seq.call(null,seq__14644_14648);
if(temp__4657__auto___14657){
var seq__14644_14658__$1 = temp__4657__auto___14657;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14644_14658__$1)){
var c__13060__auto___14659 = cljs.core.chunk_first.call(null,seq__14644_14658__$1);
var G__14660 = cljs.core.chunk_rest.call(null,seq__14644_14658__$1);
var G__14661 = c__13060__auto___14659;
var G__14662 = cljs.core.count.call(null,c__13060__auto___14659);
var G__14663 = (0);
seq__14644_14648 = G__14660;
chunk__14645_14649 = G__14661;
count__14646_14650 = G__14662;
i__14647_14651 = G__14663;
continue;
} else {
var x_14664 = cljs.core.first.call(null,seq__14644_14658__$1);
ret.push(x_14664);

var G__14665 = cljs.core.next.call(null,seq__14644_14658__$1);
var G__14666 = null;
var G__14667 = (0);
var G__14668 = (0);
seq__14644_14648 = G__14665;
chunk__14645_14649 = G__14666;
count__14646_14650 = G__14667;
i__14647_14651 = G__14668;
continue;
}
} else {
}
}
break;
}

return com.cognitect.transit.tagged.call(null,"array",ret);
});

cognitect.transit.SetHandler.prototype.stringRep = (function (){
var self__ = this;
var v = this;
return null;
});

cognitect.transit.SetHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.SetHandler.cljs$lang$type = true;

cognitect.transit.SetHandler.cljs$lang$ctorStr = "cognitect.transit/SetHandler";

cognitect.transit.SetHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/SetHandler");
});

cognitect.transit.__GT_SetHandler = (function cognitect$transit$__GT_SetHandler(){
return (new cognitect.transit.SetHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.VectorHandler = (function (){
})
cognitect.transit.VectorHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "array";
});

cognitect.transit.VectorHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
var ret = [];
var seq__14669_14673 = cljs.core.seq.call(null,v);
var chunk__14670_14674 = null;
var count__14671_14675 = (0);
var i__14672_14676 = (0);
while(true){
if((i__14672_14676 < count__14671_14675)){
var x_14677 = cljs.core._nth.call(null,chunk__14670_14674,i__14672_14676);
ret.push(x_14677);

var G__14678 = seq__14669_14673;
var G__14679 = chunk__14670_14674;
var G__14680 = count__14671_14675;
var G__14681 = (i__14672_14676 + (1));
seq__14669_14673 = G__14678;
chunk__14670_14674 = G__14679;
count__14671_14675 = G__14680;
i__14672_14676 = G__14681;
continue;
} else {
var temp__4657__auto___14682 = cljs.core.seq.call(null,seq__14669_14673);
if(temp__4657__auto___14682){
var seq__14669_14683__$1 = temp__4657__auto___14682;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14669_14683__$1)){
var c__13060__auto___14684 = cljs.core.chunk_first.call(null,seq__14669_14683__$1);
var G__14685 = cljs.core.chunk_rest.call(null,seq__14669_14683__$1);
var G__14686 = c__13060__auto___14684;
var G__14687 = cljs.core.count.call(null,c__13060__auto___14684);
var G__14688 = (0);
seq__14669_14673 = G__14685;
chunk__14670_14674 = G__14686;
count__14671_14675 = G__14687;
i__14672_14676 = G__14688;
continue;
} else {
var x_14689 = cljs.core.first.call(null,seq__14669_14683__$1);
ret.push(x_14689);

var G__14690 = cljs.core.next.call(null,seq__14669_14683__$1);
var G__14691 = null;
var G__14692 = (0);
var G__14693 = (0);
seq__14669_14673 = G__14690;
chunk__14670_14674 = G__14691;
count__14671_14675 = G__14692;
i__14672_14676 = G__14693;
continue;
}
} else {
}
}
break;
}

return ret;
});

cognitect.transit.VectorHandler.prototype.stringRep = (function (v){
var self__ = this;
var _ = this;
return null;
});

cognitect.transit.VectorHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.VectorHandler.cljs$lang$type = true;

cognitect.transit.VectorHandler.cljs$lang$ctorStr = "cognitect.transit/VectorHandler";

cognitect.transit.VectorHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/VectorHandler");
});

cognitect.transit.__GT_VectorHandler = (function cognitect$transit$__GT_VectorHandler(){
return (new cognitect.transit.VectorHandler());
});


/**
* @constructor
 * @implements {cognitect.transit.Object}
*/
cognitect.transit.UUIDHandler = (function (){
})
cognitect.transit.UUIDHandler.prototype.tag = (function (v){
var self__ = this;
var _ = this;
return "u";
});

cognitect.transit.UUIDHandler.prototype.rep = (function (v){
var self__ = this;
var _ = this;
return v.uuid;
});

cognitect.transit.UUIDHandler.prototype.stringRep = (function (v){
var self__ = this;
var this$ = this;
return this$.rep(v);
});

cognitect.transit.UUIDHandler.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cognitect.transit.UUIDHandler.cljs$lang$type = true;

cognitect.transit.UUIDHandler.cljs$lang$ctorStr = "cognitect.transit/UUIDHandler";

cognitect.transit.UUIDHandler.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/UUIDHandler");
});

cognitect.transit.__GT_UUIDHandler = (function cognitect$transit$__GT_UUIDHandler(){
return (new cognitect.transit.UUIDHandler());
});

/**
 * Return a transit writer. type maybe either :json or :json-verbose.
 *   opts is a map containing a :handlers entry. :handlers is a map of
 *   type constructors to handler instances.
 */
cognitect.transit.writer = (function cognitect$transit$writer(var_args){
var args14694 = [];
var len__13324__auto___14709 = arguments.length;
var i__13325__auto___14710 = (0);
while(true){
if((i__13325__auto___14710 < len__13324__auto___14709)){
args14694.push((arguments[i__13325__auto___14710]));

var G__14711 = (i__13325__auto___14710 + (1));
i__13325__auto___14710 = G__14711;
continue;
} else {
}
break;
}

var G__14696 = args14694.length;
switch (G__14696) {
case 1:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14694.length)].join('')));

}
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$1 = (function (type){
return cognitect.transit.writer.call(null,type,null);
});

cognitect.transit.writer.cljs$core$IFn$_invoke$arity$2 = (function (type,opts){
var keyword_handler = (new cognitect.transit.KeywordHandler());
var symbol_handler = (new cognitect.transit.SymbolHandler());
var list_handler = (new cognitect.transit.ListHandler());
var map_handler = (new cognitect.transit.MapHandler());
var set_handler = (new cognitect.transit.SetHandler());
var vector_handler = (new cognitect.transit.VectorHandler());
var uuid_handler = (new cognitect.transit.UUIDHandler());
var handlers = cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([cljs.core.PersistentHashMap,cljs.core.Cons,cljs.core.PersistentArrayMap,cljs.core.NodeSeq,cljs.core.PersistentQueue,cljs.core.IndexedSeq,cljs.core.Keyword,cljs.core.EmptyList,cljs.core.LazySeq,cljs.core.Subvec,cljs.core.PersistentQueueSeq,cljs.core.ArrayNodeSeq,cljs.core.ValSeq,cljs.core.PersistentArrayMapSeq,cljs.core.PersistentVector,cljs.core.List,cljs.core.RSeq,cljs.core.PersistentHashSet,cljs.core.PersistentTreeMap,cljs.core.KeySeq,cljs.core.ChunkedSeq,cljs.core.PersistentTreeSet,cljs.core.ChunkedCons,cljs.core.Symbol,cljs.core.UUID,cljs.core.Range,cljs.core.PersistentTreeMapSeq],[map_handler,list_handler,map_handler,list_handler,list_handler,list_handler,keyword_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,list_handler,list_handler,vector_handler,list_handler,list_handler,set_handler,map_handler,list_handler,list_handler,set_handler,list_handler,symbol_handler,uuid_handler,list_handler,list_handler]),new cljs.core.Keyword(null,"handlers","handlers",79528781).cljs$core$IFn$_invoke$arity$1(opts));
return com.cognitect.transit.writer.call(null,cljs.core.name.call(null,type),cognitect.transit.opts_merge.call(null,{"objectBuilder": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (m,kfn,vfn){
return cljs.core.reduce_kv.call(null,((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (obj,k,v){
var G__14697 = obj;
G__14697.push(kfn.call(null,k),vfn.call(null,v));

return G__14697;
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
,["^ "],m);
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
, "handlers": (function (){var x14698 = cljs.core.clone.call(null,handlers);
x14698.forEach = ((function (x14698,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (f){
var coll = this;
var seq__14699 = cljs.core.seq.call(null,coll);
var chunk__14700 = null;
var count__14701 = (0);
var i__14702 = (0);
while(true){
if((i__14702 < count__14701)){
var vec__14703 = cljs.core._nth.call(null,chunk__14700,i__14702);
var k = cljs.core.nth.call(null,vec__14703,(0),null);
var v = cljs.core.nth.call(null,vec__14703,(1),null);
f.call(null,v,k);

var G__14713 = seq__14699;
var G__14714 = chunk__14700;
var G__14715 = count__14701;
var G__14716 = (i__14702 + (1));
seq__14699 = G__14713;
chunk__14700 = G__14714;
count__14701 = G__14715;
i__14702 = G__14716;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__14699);
if(temp__4657__auto__){
var seq__14699__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14699__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__14699__$1);
var G__14717 = cljs.core.chunk_rest.call(null,seq__14699__$1);
var G__14718 = c__13060__auto__;
var G__14719 = cljs.core.count.call(null,c__13060__auto__);
var G__14720 = (0);
seq__14699 = G__14717;
chunk__14700 = G__14718;
count__14701 = G__14719;
i__14702 = G__14720;
continue;
} else {
var vec__14706 = cljs.core.first.call(null,seq__14699__$1);
var k = cljs.core.nth.call(null,vec__14706,(0),null);
var v = cljs.core.nth.call(null,vec__14706,(1),null);
f.call(null,v,k);

var G__14721 = cljs.core.next.call(null,seq__14699__$1);
var G__14722 = null;
var G__14723 = (0);
var G__14724 = (0);
seq__14699 = G__14721;
chunk__14700 = G__14722;
count__14701 = G__14723;
i__14702 = G__14724;
continue;
}
} else {
return null;
}
}
break;
}
});})(x14698,keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
;

return x14698;
})(), "unpack": ((function (keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers){
return (function (x){
if((x instanceof cljs.core.PersistentArrayMap)){
return x.arr;
} else {
return false;
}
});})(keyword_handler,symbol_handler,list_handler,map_handler,set_handler,vector_handler,uuid_handler,handlers))
},cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"handlers","handlers",79528781)))));
});

cognitect.transit.writer.cljs$lang$maxFixedArity = 2;

/**
 * Encode an object into a transit string given a transit writer.
 */
cognitect.transit.write = (function cognitect$transit$write(w,o){
return w.write(o);
});
/**
 * Construct a read handler. Implemented as identity, exists primarily
 * for API compatiblity with transit-clj
 */
cognitect.transit.read_handler = (function cognitect$transit$read_handler(from_rep){
return from_rep;
});
/**
 * Creates a transit write handler whose tag, rep,
 * stringRep, and verboseWriteHandler methods
 * invoke the provided fns.
 */
cognitect.transit.write_handler = (function cognitect$transit$write_handler(var_args){
var args14725 = [];
var len__13324__auto___14731 = arguments.length;
var i__13325__auto___14732 = (0);
while(true){
if((i__13325__auto___14732 < len__13324__auto___14731)){
args14725.push((arguments[i__13325__auto___14732]));

var G__14733 = (i__13325__auto___14732 + (1));
i__13325__auto___14732 = G__14733;
continue;
} else {
}
break;
}

var G__14727 = args14725.length;
switch (G__14727) {
case 2:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14725.length)].join('')));

}
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$2 = (function (tag_fn,rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,null,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$3 = (function (tag_fn,rep_fn,str_rep_fn){
return cognitect.transit.write_handler.call(null,tag_fn,rep_fn,str_rep_fn,null);
});

cognitect.transit.write_handler.cljs$core$IFn$_invoke$arity$4 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn){
if(typeof cognitect.transit.t_cognitect$transit14728 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cognitect.transit.Object}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cognitect.transit.t_cognitect$transit14728 = (function (tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,meta14729){
this.tag_fn = tag_fn;
this.rep_fn = rep_fn;
this.str_rep_fn = str_rep_fn;
this.verbose_handler_fn = verbose_handler_fn;
this.meta14729 = meta14729;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cognitect.transit.t_cognitect$transit14728.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14730,meta14729__$1){
var self__ = this;
var _14730__$1 = this;
return (new cognitect.transit.t_cognitect$transit14728(self__.tag_fn,self__.rep_fn,self__.str_rep_fn,self__.verbose_handler_fn,meta14729__$1));
});

cognitect.transit.t_cognitect$transit14728.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14730){
var self__ = this;
var _14730__$1 = this;
return self__.meta14729;
});

cognitect.transit.t_cognitect$transit14728.prototype.tag = (function (o){
var self__ = this;
var _ = this;
return self__.tag_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit14728.prototype.rep = (function (o){
var self__ = this;
var _ = this;
return self__.rep_fn.call(null,o);
});

cognitect.transit.t_cognitect$transit14728.prototype.stringRep = (function (o){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.str_rep_fn)){
return self__.str_rep_fn.call(null,o);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit14728.prototype.getVerboseHandler = (function (){
var self__ = this;
var _ = this;
if(cljs.core.truth_(self__.verbose_handler_fn)){
return self__.verbose_handler_fn.call(null);
} else {
return null;
}
});

cognitect.transit.t_cognitect$transit14728.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"tag-fn","tag-fn",242055482,null),new cljs.core.Symbol(null,"rep-fn","rep-fn",-1724891035,null),new cljs.core.Symbol(null,"str-rep-fn","str-rep-fn",-1179615016,null),new cljs.core.Symbol(null,"verbose-handler-fn","verbose-handler-fn",547340594,null),new cljs.core.Symbol(null,"meta14729","meta14729",-220901388,null)], null);
});

cognitect.transit.t_cognitect$transit14728.cljs$lang$type = true;

cognitect.transit.t_cognitect$transit14728.cljs$lang$ctorStr = "cognitect.transit/t_cognitect$transit14728";

cognitect.transit.t_cognitect$transit14728.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cognitect.transit/t_cognitect$transit14728");
});

cognitect.transit.__GT_t_cognitect$transit14728 = (function cognitect$transit$__GT_t_cognitect$transit14728(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta14729){
return (new cognitect.transit.t_cognitect$transit14728(tag_fn__$1,rep_fn__$1,str_rep_fn__$1,verbose_handler_fn__$1,meta14729));
});

}

return (new cognitect.transit.t_cognitect$transit14728(tag_fn,rep_fn,str_rep_fn,verbose_handler_fn,cljs.core.PersistentArrayMap.EMPTY));
});

cognitect.transit.write_handler.cljs$lang$maxFixedArity = 4;

/**
 * Construct a tagged value. tag must be a string and rep can
 * be any transit encodeable value.
 */
cognitect.transit.tagged_value = (function cognitect$transit$tagged_value(tag,rep){
return com.cognitect.transit.types.taggedValue.call(null,tag,rep);
});
/**
 * Returns true if x is a transit tagged value, false otherwise.
 */
cognitect.transit.tagged_value_QMARK_ = (function cognitect$transit$tagged_value_QMARK_(x){
return com.cognitect.transit.types.isTaggedValue.call(null,x);
});
/**
 * Construct a transit integer value. Returns JavaScript number if
 *   in the 53bit integer range, a goog.math.Long instance if above. s
 *   may be a string or a JavaScript number.
 */
cognitect.transit.integer = (function cognitect$transit$integer(s){
return com.cognitect.transit.types.intValue.call(null,s);
});
/**
 * Returns true if x is an integer value between the 53bit and 64bit
 *   range, false otherwise.
 */
cognitect.transit.integer_QMARK_ = (function cognitect$transit$integer_QMARK_(x){
return com.cognitect.transit.types.isInteger.call(null,x);
});
/**
 * Construct a big integer from a string.
 */
cognitect.transit.bigint = (function cognitect$transit$bigint(s){
return com.cognitect.transit.types.bigInteger.call(null,s);
});
/**
 * Returns true if x is a transit big integer value, false otherwise.
 */
cognitect.transit.bigint_QMARK_ = (function cognitect$transit$bigint_QMARK_(x){
return com.cognitect.transit.types.isBigInteger.call(null,x);
});
/**
 * Construct a big decimal from a string.
 */
cognitect.transit.bigdec = (function cognitect$transit$bigdec(s){
return com.cognitect.transit.types.bigDecimalValue.call(null,s);
});
/**
 * Returns true if x is a transit big decimal value, false otherwise.
 */
cognitect.transit.bigdec_QMARK_ = (function cognitect$transit$bigdec_QMARK_(x){
return com.cognitect.transit.types.isBigDecimal.call(null,x);
});
/**
 * Construct a URI from a string.
 */
cognitect.transit.uri = (function cognitect$transit$uri(s){
return com.cognitect.transit.types.uri.call(null,s);
});
/**
 * Returns true if x is a transit URI value, false otherwise.
 */
cognitect.transit.uri_QMARK_ = (function cognitect$transit$uri_QMARK_(x){
return com.cognitect.transit.types.isURI.call(null,x);
});
/**
 * Construct a UUID from a string.
 */
cognitect.transit.uuid = (function cognitect$transit$uuid(s){
return com.cognitect.transit.types.uuid.call(null,s);
});
/**
 * Returns true if x is a transit UUID value, false otherwise.
 */
cognitect.transit.uuid_QMARK_ = (function cognitect$transit$uuid_QMARK_(x){
var or__12249__auto__ = com.cognitect.transit.types.isUUID.call(null,x);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return (x instanceof cljs.core.UUID);
}
});
/**
 * Construct a transit binary value. s should be base64 encoded
 * string.
 */
cognitect.transit.binary = (function cognitect$transit$binary(s){
return com.cognitect.transit.types.binary.call(null,s);
});
/**
 * Returns true if x is a transit binary value, false otherwise.
 */
cognitect.transit.binary_QMARK_ = (function cognitect$transit$binary_QMARK_(x){
return com.cognitect.transit.types.isBinary.call(null,x);
});
/**
 * Construct a quoted transit value. x should be a transit
 * encodeable value.
 */
cognitect.transit.quoted = (function cognitect$transit$quoted(x){
return com.cognitect.transit.types.quoted.call(null,x);
});
/**
 * Returns true if x is a transit quoted value, false otherwise.
 */
cognitect.transit.quoted_QMARK_ = (function cognitect$transit$quoted_QMARK_(x){
return com.cognitect.transit.types.isQuoted.call(null,x);
});
/**
 * Construct a transit link value. x should be an IMap instance
 * containing at a minimum the following keys: :href, :rel. It
 * may optionall include :name, :render, and :prompt. :href must
 * be a transit URI, all other values are strings, and :render must
 * be either :image or :link.
 */
cognitect.transit.link = (function cognitect$transit$link(x){
return com.cognitect.transit.types.link.call(null,x);
});
/**
 * Returns true if x a transit link value, false if otherwise.
 */
cognitect.transit.link_QMARK_ = (function cognitect$transit$link_QMARK_(x){
return com.cognitect.transit.types.isLink.call(null,x);
});

//# sourceMappingURL=transit.js.map?rel=1473935447703