(ns bluegenes.components.icons)

;;TO ADD AN SVG: i'd recommend icomoon. get the svg symbol
;; definition of an icon from https://icomoon.io/app/
;; then plug it into http://htmltohiccup.herokuapp.com/ to make
;; it hiccup, THEN paste it in here. Top tip: if your icon
;; doesn't work, check if it's viewBox or view-box (but not viewBox)
;; lowercase b makes react grumpy.

;;TO USE AN SVG INLINE, do it like so:
;;[:svg.icon.icon-search [:use {:xlinkHref "#icon-search"}]]
;;The definitions of icons are below ) use the part after # in the symbol
;;tag as identifiers.
;;OR just go the the developer section in the cog menu (top right)
;; of bluegenes and copy/paste the code for your icon from there

(defn icons []
  [:svg
   {:version "1.1"
    :height "0"
    :width "0"
    :style {:position "absolute" :width 0 :height 0}}
   [:defs

    [:symbol#icon-intermine
     {:viewBox "0 0 16 16"}
     [:title "InterMine Logo"]
     [:rect.intermine-logo.lowlight {:x 0 :y 1 :width 7 :height 4 :fill "#bbb"}]
     [:rect.intermine-logo.highlight {:x 0 :y 6 :width 7 :height 4}]
     [:rect.intermine-logo.highlight {:x 0 :y 11 :width 7 :height 4}]
     [:rect.intermine-logo.highlight {:x 8 :y 1 :width 7 :height 4}]
     [:rect.intermine-logo.lowlight {:x 8 :y 6 :width 7 :height 4 :fill "#bbb"}]
     [:rect.intermine-logo.lowlight {:x 8 :y 11 :width 7 :height 4 :fill "#bbb"}]]

    [:symbol#icon-chevron-right {:view-box "0 0 14 32"}
     [:title "chevron-right"]
     [:path {:d "M4 6l-4 4 6 6-6 6 4 4 10-10-10-10z"}]]

    [:symbol#icon-chevron-left {:view-box "0 0 14 32"}
     [:title "chevron-left"]
     [:path {:d "M14 10l-4-4-10 10 10 10 4-4-6-6 6-6z"}]]

    [:symbol#icon-document-list {:view-box "0 0 32 32"}
     [:title "document-list"]
     [:path {:d "M19 3v6.002c0 1.111 0.898 1.998 2.006 1.998h4.994v17.003c0 1.107-0.894 1.997-1.997 1.997h-15.005c-1.107 0-1.997-0.899-1.997-2.007v-22.985c0-1.109 0.899-2.007 2.009-2.007h9.991zM20 3v5.997c0 0.554 0.451 1.003 0.991 1.003h5.009l-6-7zM15 14v1h8v-1h-8zM10 13v3h3v-3h-3zM11 14v1h1v-1h-1zM10 18v3h3v-3h-3zM11 19v1h1v-1h-1zM15 19v1h8v-1h-8zM10 23v3h3v-3h-3zM11 24v1h1v-1h-1zM15 24v1h8v-1h-8z"}]]

    [:symbol#icon-list {:view-box "0 0 32 32"}
     [:title "list"]
     [:path {:d "M12 2h20v4h-20v-4zM12 14h20v4h-20v-4zM12 26h20v4h-20v-4zM0 4c0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.209-1.791 4-4 4s-4-1.791-4-4zM0 16c0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.209-1.791 4-4 4s-4-1.791-4-4zM0 28c0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.209-1.791 4-4 4s-4-1.791-4-4z"}]]

    [:symbol#icon-arrow-left {:view-box "0 0 32 32"}
     [:title "arrow-left"]
     [:path {:d "M1 16l15 15v-9h16v-12h-16v-9z"}]]

    [:symbol#icon-lock {:view-box "0 0 32 32"}
     [:title "lock"]
     [:path {:d "M18.5 14h-0.5v-6c0-3.308-2.692-6-6-6h-4c-3.308 0-6 2.692-6 6v6h-0.5c-0.825 0-1.5 0.675-1.5 1.5v15c0 0.825 0.675 1.5 1.5 1.5h17c0.825 0 1.5-0.675 1.5-1.5v-15c0-0.825-0.675-1.5-1.5-1.5zM6 8c0-1.103 0.897-2 2-2h4c1.103 0 2 0.897 2 2v6h-8v-6z"}]]

    [:symbol#icon-swap-vertical {:view-box "0 0 24 24"}
     [:title "swap-vertical"]
     [:path {:d "M9 3l3.984 3.984h-3v7.031h-1.969v-7.031h-3zM15.984 17.016h3l-3.984 3.984-3.984-3.984h3v-7.031h1.969v7.031z"}]]

    [:symbol#icon-price-tag {:view-box "0 0 32 32"}
     [:title "price-tag"]
     [:path {:d "M30.5 0h-12c-0.825 0-1.977 0.477-2.561 1.061l-14.879 14.879c-0.583 0.583-0.583 1.538 0 2.121l12.879 12.879c0.583 0.583 1.538 0.583 2.121 0l14.879-14.879c0.583-0.583 1.061-1.736 1.061-2.561v-12c0-0.825-0.675-1.5-1.5-1.5zM23 12c-1.657 0-3-1.343-3-3s1.343-3 3-3 3 1.343 3 3-1.343 3-3 3z"}]]

    [:symbol#icon-caret-right {:view-box "0 0 9 28"}
     [:title "caret-right"]
     [:path {:d "M9 14c0 0.266-0.109 0.516-0.297 0.703l-7 7c-0.187 0.187-0.438 0.297-0.703 0.297-0.547 0-1-0.453-1-1v-14c0-0.547 0.453-1 1-1 0.266 0 0.516 0.109 0.703 0.297l7 7c0.187 0.187 0.297 0.438 0.297 0.703z"}]]

    [:symbol#icon-bar-chart
     {:viewBox "0 0 32 28"}
     [:title "bar-chart"]
     [:path.path1
      {:d
       "M10 14v8h-4v-8h4zM16 6v16h-4v-16h4zM32 24v2h-32v-24h2v22h30zM22 10v12h-4v-12h4zM28 4v18h-4v-18h4z"}]]
    [:symbol#icon-venn-disjunction
     {:viewBox "0 -4 26 26"}
     {:fill-rule "evenodd",
      :fill "none",
      :stroke-width "1",
      :stroke "none"}
     [:g#icon-list-disjunction
      {:transform "translate(1.000000, 1.000000)"}
      [:path.path1
       {:fill-rule "nonzero",
        :fill "#AAAAAA",
        :d
        "M12,14.9297396 C10.8233059,15.6104216 9.4571477,16 8,16 C3.581728,16 0,12.418272 0,8 C0,3.581728 3.581728,0 8,0 C9.4571477,0 10.8233059,0.389578385 12,1.07026042 C13.1766941,0.389578385 14.5428523,0 16,0 C20.41824,0 24,3.581728 24,8 C24,12.418272 20.41824,16 16,16 C14.5428523,16 13.1766941,15.6104216 12,14.9297396 Z M12,14.9297396 C14.391204,13.5465002 16,10.9611243 16,8 C16,5.0388757 14.391204,2.45349982 12,1.07026042 C9.60879602,2.45349982 8,5.0388757 8,8 C8,10.9611243 9.60879602,13.5465002 12,14.9297396 Z"}]
      [:path.path2
       {:stroke-width "0.8",
        :stroke "#000000",
        :d
        "M16,8 C16,12.418272 12.418272,16 8,16 C3.581728,16 0,12.418272 0,8 C0,3.581728 3.581728,0 8,0 C12.418272,0 16,3.581728 16,8"}]
      [:path.path3
       {:stroke-width "0.8",
        :stroke "#000000",
        :d
        "M24,8 C24,12.418272 20.41824,16 16,16 C11.581728,16 8,12.418272 8,8 C8,3.581728 11.581728,0 16,0 C20.41824,0 24,3.581728 24,8"}]]]

    [:symbol#icon-user-times {:view-box "0 0 32 28"}
     [:title "user-times"]
     [:path {:d "M11 14c-3.313 0-6-2.688-6-6s2.688-6 6-6 6 2.688 6 6-2.688 6-6 6zM27.828 19l3.891 3.891c0.094 0.094 0.141 0.219 0.141 0.359 0 0.125-0.047 0.25-0.141 0.344l-2.125 2.125c-0.094 0.094-0.219 0.141-0.344 0.141-0.141 0-0.266-0.047-0.359-0.141l-3.891-3.891-3.891 3.891c-0.094 0.094-0.219 0.141-0.359 0.141-0.125 0-0.25-0.047-0.344-0.141l-2.125-2.125c-0.094-0.094-0.141-0.219-0.141-0.344 0-0.141 0.047-0.266 0.141-0.359l3.891-3.891-3.891-3.891c-0.094-0.094-0.141-0.219-0.141-0.359 0-0.125 0.047-0.25 0.141-0.344l2.125-2.125c0.094-0.094 0.219-0.141 0.344-0.141 0.141 0 0.266 0.047 0.359 0.141l3.891 3.891 3.891-3.891c0.094-0.094 0.219-0.141 0.359-0.141 0.125 0 0.25 0.047 0.344 0.141l2.125 2.125c0.094 0.094 0.141 0.219 0.141 0.344 0 0.141-0.047 0.266-0.141 0.359zM20.047 19l-2.828 2.828c-0.375 0.375-0.578 0.891-0.578 1.422 0 0.516 0.203 1.031 0.578 1.406l1.297 1.297c-0.219 0.031-0.453 0.047-0.688 0.047h-13.656c-2.5 0-4.172-1.5-4.172-4.047 0-3.531 0.828-8.953 5.406-8.953 0.25 0 0.422 0.109 0.609 0.266 1.5 1.188 3.031 1.906 4.984 1.906s3.484-0.719 4.984-1.906c0.187-0.156 0.359-0.266 0.609-0.266 0.297 0 0.594 0.031 0.891 0.094-0.516 0.5-0.844 0.906-0.844 1.656 0 0.531 0.203 1.047 0.578 1.422z"}]]

    [:symbol#icon-globe
     {:viewBox "0 0 24 24"}
     [:title "public"]
     [:path {:d
             "M17.906 17.391c1.313-1.406 2.109-3.328 2.109-5.391 0-3.328-2.063-6.234-5.016-7.406v0.422c0 1.078-0.938 1.969-2.016 1.969h-1.969v2.016c0 0.563-0.469 0.984-1.031 0.984h-1.969v2.016h6c0.563 0 0.984 0.422 0.984 0.984v3h0.984c0.891 0 1.641 0.609 1.922 1.406zM11.016 19.922v-1.922c-1.078 0-2.016-0.938-2.016-2.016v-0.984l-4.781-4.781c-0.141 0.563-0.234 1.172-0.234 1.781 0 4.078 3.094 7.453 7.031 7.922zM12 2.016c5.531 0 9.984 4.453 9.984 9.984s-4.453 9.984-9.984 9.984-9.984-4.453-9.984-9.984 4.453-9.984 9.984-9.984z"}]]

    [:symbol#icon-venn-combine
     {:viewBox "0 -4 26 26"}
     {:fill-rule "evenodd",
      :fill "none",
      :stroke-width "1",
      :stroke "none"}
     [:g#icon-venn-combine-g
      {:transform "translate(1.000000, 1.000000)"}
      [:path.path1
       {:fill-rule "nonzero",
        :fill "#AAAAAA",
        :d
        "M12,14.9297396 C10.8233059,15.6104216 9.4571477,16 8,16 C3.581728,16 0,12.418272 0,8 C0,3.581728 3.581728,0 8,0 C9.4571477,0 10.8233059,0.389578385 12,1.07026042 C13.1766941,0.389578385 14.5428523,0 16,0 C20.41824,0 24,3.581728 24,8 C24,12.418272 20.41824,16 16,16 C14.5428523,16 13.1766941,15.6104216 12,14.9297396 Z"}]
      [:path.path2
       {:stroke-width "0.8",
        :stroke "#000000",
        :d
        "M12,14.9297396 C10.8233059,15.6104216 9.4571477,16 8,16 C3.581728,16 0,12.418272 0,8 C0,3.581728 3.581728,0 8,0 C9.4571477,0 10.8233059,0.389578385 12,1.07026042 C13.1766941,0.389578385 14.5428523,0 16,0 C20.41824,0 24,3.581728 24,8 C24,12.418272 20.41824,16 16,16 C14.5428523,16 13.1766941,15.6104216 12,14.9297396 Z"}]]]

    [:symbol#icon-venn-difference
     {:viewBox "-5 0 160 100"}
     [:title "Subtract one list from another"]

     [:circle.venn-full
      {:r 50 :cx 50 :cy 50 :stroke-width 5 :fill "rgba(0,0,0,0.3)" :stroke "black"}]
     [:circle.venn-hollow
      {:r 50 :cx 100 :cy 50 :stroke-width 5 :fill "rgb(247,247,247)" :stroke "black"}]]

    [:symbol#icon-venn-intersection
     {:viewBox "-5 0 160 100"}
     [:title "Intersect these lists"]

     [:circle
      {:r 50 :cx 50 :cy 50 :stroke-width 5 :fill "transparent" :stroke "black"}]
     [:circle
      {:r 50 :cx 100 :cy 50 :stroke-width 5 :fill "transparent" :stroke "black"}]

     [:path {:d "M 75.015625 6.7617188 A 50 50 0 0 0 50 50 A 50 50 0 0 0 74.984375 93.238281 A 50 50 0 0 0 100 50 A 50 50 0 0 0 75.015625 6.7617188 z " :fill "rgb(170,170,170)" :stroke "black"}]]

    [:symbol#icon-floppy-disk
     {:viewBox "0 0 16 16"}
     [:title "floppy-disk"]
     [:path.path1
      {:d
       "M14 0h-14v16h16v-14l-2-2zM8 2h2v4h-2v-4zM14 14h-12v-12h1v5h9v-5h1.172l0.828 0.828v11.172z"}]]
    [:symbol#icon-user
     {:viewBox "0 0 16 16"}
     [:title "user"]
     [:path.path1
      {:d
       "M9 11.041v-0.825c1.102-0.621 2-2.168 2-3.716 0-2.485 0-4.5-3-4.5s-3 2.015-3 4.5c0 1.548 0.898 3.095 2 3.716v0.825c-3.392 0.277-6 1.944-6 3.959h14c0-2.015-2.608-3.682-6-3.959z"}]]
    [:symbol#icon-cog
     {:viewBox "0 0 16 16"}
     [:title "Settings"]
     [:path.path1
      {:d
       "M14.59 9.535c-0.839-1.454-0.335-3.317 1.127-4.164l-1.572-2.723c-0.449 0.263-0.972 0.414-1.529 0.414-1.68 0-3.042-1.371-3.042-3.062h-3.145c0.004 0.522-0.126 1.051-0.406 1.535-0.839 1.454-2.706 1.948-4.17 1.106l-1.572 2.723c0.453 0.257 0.845 0.634 1.123 1.117 0.838 1.452 0.336 3.311-1.12 4.16l1.572 2.723c0.448-0.261 0.967-0.41 1.522-0.41 1.675 0 3.033 1.362 3.042 3.046h3.145c-0.001-0.517 0.129-1.040 0.406-1.519 0.838-1.452 2.7-1.947 4.163-1.11l1.572-2.723c-0.45-0.257-0.839-0.633-1.116-1.113zM8 11.24c-1.789 0-3.24-1.45-3.24-3.24s1.45-3.24 3.24-3.24c1.789 0 3.24 1.45 3.24 3.24s-1.45 3.24-3.24 3.24z"}]]
    [:symbol#icon-arrow-right
     {:viewBox "0 0 32 32"}
     [:title "arrow-right"]
     [:path.path1
      {:d
       "M31 16l-15-15v9h-16v12h16v9z"}]]
    [:symbol#icon-download
     {:viewBox "0 0 16 16"}
     [:title "download"]
     [:path.path1
      {:d
       "M11.5 7l-4 4-4-4h2.5v-6h3v6zM7.5 11h-7.5v4h15v-4h-7.5zM14 13h-2v-1h2v1z"}]]

    [:symbol#icon-user-circle {:view-box "0 0 28 28"}
     [:title "user-circle"]
     [:path {:d "M23.797 20.922c-0.406-2.922-1.594-5.516-4.25-5.875-1.375 1.5-3.359 2.453-5.547 2.453s-4.172-0.953-5.547-2.453c-2.656 0.359-3.844 2.953-4.25 5.875 2.172 3.063 5.75 5.078 9.797 5.078s7.625-2.016 9.797-5.078zM20 10c0-3.313-2.688-6-6-6s-6 2.688-6 6 2.688 6 6 6 6-2.688 6-6zM28 14c0 7.703-6.25 14-14 14-7.734 0-14-6.281-14-14 0-7.734 6.266-14 14-14s14 6.266 14 14z"}]]

    [:symbol#icon-duplicate
     {:viewBox "0 0 16 16"}
     [:title "duplicate"]
     [:path
      {:d "M10 4v-4h-7l-3 3v9h6v4h10v-12h-6zM3 1.414v1.586h-1.586l1.586-1.586zM1 11v-7h3v-3h5v3l-3 3v4h-5zM9 5.414v1.586h-1.586l1.586-1.586zM15 15h-8v-7h3v-3h5v10z"}]]

    [:symbol#icon-upload
     {:viewBox "0 0 16 16"}
     [:title "upload"]
     [:path
      {:d
       "M7.5 11h-7.5v4h15v-4h-7.5zM14 13h-2v-1h2v1zM3.5 5l4-4 4 4h-2.5v5h-3v-5z"}]] [:symbol#icon-star-empty
                                                                                     {:viewBox "0 0 16 16"}
                                                                                     [:title "star-empty"]
                                                                                     [:path.path1
                                                                                      {:d
                                                                                       "M16 6.204l-5.528-0.803-2.472-5.009-2.472 5.009-5.528 0.803 4 3.899-0.944 5.505 4.944-2.599 4.944 2.599-0.944-5.505 4-3.899zM8 11.773l-3.492 1.836 0.667-3.888-2.825-2.753 3.904-0.567 1.746-3.537 1.746 3.537 3.904 0.567-2.825 2.753 0.667 3.888-3.492-1.836z"}]]
    [:symbol#icon-star-full
     {:viewBox "0 0 16 16"}
     [:title "star-full"]
     [:path.path1
      {:d
       "M16 6.204l-5.528-0.803-2.472-5.009-2.472 5.009-5.528 0.803 4 3.899-0.944 5.505 4.944-2.599 4.944 2.599-0.944-5.505 4-3.899z"}]]
    [:symbol#icon-question
     {:viewBox "0 0 16 16"}
     [:title "question"]
     [:path.path1
      {:d
       "M7 11h2v2h-2zM11 4c0.552 0 1 0.448 1 1v3l-3 2h-2v-1l3-2v-1h-5v-2h6zM8 1.5c-1.736 0-3.369 0.676-4.596 1.904s-1.904 2.86-1.904 4.596c0 1.736 0.676 3.369 1.904 4.596s2.86 1.904 4.596 1.904c1.736 0 3.369-0.676 4.596-1.904s1.904-2.86 1.904-4.596c0-1.736-0.676-3.369-1.904-4.596s-2.86-1.904-4.596-1.904zM8 0v0c4.418 0 8 3.582 8 8s-3.582 8-8 8c-4.418 0-8-3.582-8-8s3.582-8 8-8z"}]]
    [:symbol#icon-plus
     {:viewBox "0 0 16 16"}
     [:title "plus"]
     [:path.path1
      {:d
       "M15.5 6h-5.5v-5.5c0-0.276-0.224-0.5-0.5-0.5h-3c-0.276 0-0.5 0.224-0.5 0.5v5.5h-5.5c-0.276 0-0.5 0.224-0.5 0.5v3c0 0.276 0.224 0.5 0.5 0.5h5.5v5.5c0 0.276 0.224 0.5 0.5 0.5h3c0.276 0 0.5-0.224 0.5-0.5v-5.5h5.5c0.276 0 0.5-0.224 0.5-0.5v-3c0-0.276-0.224-0.5-0.5-0.5z"}]]
    [:symbol#icon-minus
     {:viewBox "0 0 16 16"}
     [:title "minus"]
     [:path.path1
      {:d
       "M0 6.5v3c0 0.276 0.224 0.5 0.5 0.5h15c0.276 0 0.5-0.224 0.5-0.5v-3c0-0.276-0.224-0.5-0.5-0.5h-15c-0.276 0-0.5 0.224-0.5 0.5z"}]]
    [:symbol#icon-external
     {:viewBox "0 0 16 16"}
     [:title "external link"]
     [:path.path1
      {:d
       "M4 10c0 0 0.919-3 6-3v3l6-4-6-4v3c-4 0-6 2.495-6 5zM11 12h-9v-6h1.967c0.158-0.186 0.327-0.365 0.508-0.534 0.687-0.644 1.509-1.135 2.439-1.466h-6.914v10h13v-4.197l-2 1.333v0.864z"}]]
    [:symbol#icon-waiting
     {:viewBox "0 0 16 16"}
     [:title "waiting"]
     [:path.path1
      {:d
       "M6 2c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2s-2-0.895-2-2zM10.243 3.757c0-1.105 0.895-2 2-2s2 0.895 2 2c0 1.105-0.895 2-2 2s-2-0.895-2-2zM13 8c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1zM11.243 12.243c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1zM7 14c0 0 0 0 0 0 0-0.552 0.448-1 1-1s1 0.448 1 1c0 0 0 0 0 0 0 0.552-0.448 1-1 1s-1-0.448-1-1zM2.757 12.243c0 0 0 0 0 0 0-0.552 0.448-1 1-1s1 0.448 1 1c0 0 0 0 0 0 0 0.552-0.448 1-1 1s-1-0.448-1-1zM2.257 3.757c0 0 0 0 0 0 0-0.828 0.672-1.5 1.5-1.5s1.5 0.672 1.5 1.5c0 0 0 0 0 0 0 0.828-0.672 1.5-1.5 1.5s-1.5-0.672-1.5-1.5zM0.875 8c0-0.621 0.504-1.125 1.125-1.125s1.125 0.504 1.125 1.125c0 0.621-0.504 1.125-1.125 1.125s-1.125-0.504-1.125-1.125z"}]]

    [:symbol#icon-table
     {:viewBox "0 0 16 16"}
     [:title "table"]
     [:path.path1
      {:d
       "M0 1v14h16v-14h-16zM6 10v-3h4v3h-4zM10 11v3h-4v-3h4zM10 3v3h-4v-3h4zM5 3v3h-4v-3h4zM1 7h4v3h-4v-3zM11 7h4v3h-4v-3zM11 6v-3h4v3h-4zM1 11h4v3h-4v-3zM11 14v-3h4v3h-4z"}]]

    [:symbol#icon-tree
     {:viewBox "0 0 16 16"}
     [:title "tree"]
     [:path.path1
      {:d
       "M15.25 12h-0.25v-3.25c0-0.965-0.785-1.75-1.75-1.75h-4.25v-2h0.25c0.412 0 0.75-0.338 0.75-0.75v-2.5c0-0.413-0.338-0.75-0.75-0.75h-2.5c-0.412 0-0.75 0.337-0.75 0.75v2.5c0 0.412 0.338 0.75 0.75 0.75h0.25v2h-4.25c-0.965 0-1.75 0.785-1.75 1.75v3.25h-0.25c-0.412 0-0.75 0.338-0.75 0.75v2.5c0 0.412 0.338 0.75 0.75 0.75h2.5c0.413 0 0.75-0.338 0.75-0.75v-2.5c0-0.412-0.337-0.75-0.75-0.75h-0.25v-3h4v3h-0.25c-0.412 0-0.75 0.338-0.75 0.75v2.5c0 0.412 0.338 0.75 0.75 0.75h2.5c0.412 0 0.75-0.338 0.75-0.75v-2.5c0-0.412-0.338-0.75-0.75-0.75h-0.25v-3h4v3h-0.25c-0.412 0-0.75 0.338-0.75 0.75v2.5c0 0.412 0.338 0.75 0.75 0.75h2.5c0.412 0 0.75-0.338 0.75-0.75v-2.5c0-0.412-0.338-0.75-0.75-0.75zM3 15h-2v-2h2v2zM9 15h-2v-2h2v2zM7 4v-2h2v2h-2zM15 15h-2v-2h2v2z"}]]

    [:symbol#icon-biological-process
     {:viewBox "0 0 16 16"}
     [:title "biological process"]
     [:path.path1
      {:d
       "M12.775 5.44c-3.024-2.248-4.067-4.047-4.774-5.44v0c-0 0-0-0-0-0v0c-0.708 1.393-1.75 3.192-4.774 5.44-5.157 3.833-0.303 9.182 3.965 6.238-0.278 1.827-1.227 3.159-2.191 3.733v0.59h6v-0.59c-0.964-0.574-1.913-1.906-2.191-3.733 4.268 2.944 9.122-2.405 3.965-6.238z"}]]

    [:symbol#icon-cellular-component
     {:viewBox "0 0 16 16"}
     [:title "cellular component"]
     [:path.path1 {:d "M8 0l-5 8 5 8 5-8z"}]]

    [:symbol#icon-molecular-function
     {:viewBox "0 0 16 16"}
     [:title "molecular function"]
     [:path.path1
      {:d
       "M12.294 6.137c-0.922 0-1.751 0.384-2.341 1.011-0.25 0.265-0.684 0.58-1.153 0.856 0.22-0.842 0.917-1.902 1.4-2.367 0.619-0.596 1-1.435 1-2.367 0-1.795-1.429-3.252-3.2-3.271-1.771 0.019-3.2 1.475-3.2 3.271 0 0.932 0.38 1.771 1 2.367 0.484 0.465 1.18 1.525 1.4 2.367-0.469-0.277-0.903-0.591-1.153-0.856-0.59-0.627-1.419-1.011-2.341-1.011-1.787 0-3.236 1.463-3.236 3.271s1.448 3.271 3.236 3.271c0.923 0 1.751-0.396 2.341-1.023 0.263-0.279 0.726-0.627 1.223-0.916-0.047 2.308-1.149 4.003-2.271 4.67v0.59h6v-0.59c-1.122-0.668-2.224-2.363-2.271-4.67 0.498 0.289 0.961 0.637 1.223 0.916 0.59 0.626 1.419 1.023 2.341 1.023 1.787 0 3.236-1.464 3.236-3.271s-1.448-3.271-3.236-3.271z"}]]

    [:symbol#icon-summary
     {:viewBox "0 0 16 16"}
     [:title "summary"]
     [:path.path1
      {:d
       "M13.5 0h-12c-0.825 0-1.5 0.675-1.5 1.5v13c0 0.825 0.675 1.5 1.5 1.5h12c0.825 0 1.5-0.675 1.5-1.5v-13c0-0.825-0.675-1.5-1.5-1.5zM13 14h-11v-12h11v12zM4 7h7v1h-7zM4 9h7v1h-7zM4 11h7v1h-7zM4 5h7v1h-7z"}]]

    [:symbol#icon-enrichment
     {:viewBox "0 0 16 16"}
     [:title "enrichment"]
     [:path.path1
      {:d
       "M5 2h-2c-0.55 0-1 0.45-1 1v2c0 0.55 0.45 1 1 1h2c0.55 0 1-0.45 1-1v-2c0-0.55-0.45-1-1-1z"}]
     [:path.path2
      {:d
       "M11 6h2c0.55 0 1-0.45 1-1v-2c0-0.55-0.45-1-1-1h-2c-0.55 0-1 0.45-1 1v2c0 0.55 0.45 1 1 1zM11 3h2v2h-2v-2z"}]
     [:path.path3
      {:d
       "M5 10h-2c-0.55 0-1 0.45-1 1v2c0 0.55 0.45 1 1 1h2c0.55 0 1-0.45 1-1v-2c0-0.55-0.45-1-1-1zM5 13h-2v-2h2v2z"}]
     [:path.path4
      {:d
       "M13 10h-2c-0.55 0-1 0.45-1 1v2c0 0.55 0.45 1 1 1h2c0.55 0 1-0.45 1-1v-2c0-0.55-0.45-1-1-1z"}]
     [:path.path5
      {:d
       "M14 8h-1c-1.336 0-2.591-0.52-3.536-1.464s-1.464-2.2-1.464-3.536v-1c0-1.1-0.9-2-2-2h-4c-1.1 0-2 0.9-2 2v4c0 1.1 0.9 2 2 2h1c1.336 0 2.591 0.52 3.536 1.464s1.464 2.2 1.464 3.536v1c0 1.1 0.9 2 2 2h4c1.1 0 2-0.9 2-2v-4c0-1.1-0.9-2-2-2zM15 14c0 0.265-0.105 0.515-0.295 0.705s-0.44 0.295-0.705 0.295h-4c-0.265 0-0.515-0.105-0.705-0.295s-0.295-0.44-0.295-0.705v-1c0-3.314-2.686-6-6-6h-1c-0.265 0-0.515-0.105-0.705-0.295s-0.295-0.441-0.295-0.705v-4c0-0.265 0.105-0.515 0.295-0.705s0.44-0.295 0.705-0.295h4c0.265 0 0.515 0.105 0.705 0.295s0.295 0.44 0.295 0.705v1c0 3.314 2.686 6 6 6h1c0.265 0 0.515 0.105 0.705 0.295s0.295 0.44 0.295 0.705v4z"}]]

    [:symbol#icon-code
     {:viewBox "0 0 20 16"}
     [:title "code"]
     [:path.path1 {:d "M13 11.5l1.5 1.5 5-5-5-5-1.5 1.5 3.5 3.5z"}]
     [:path.path2 {:d "M7 4.5l-1.5-1.5-5 5 5 5 1.5-1.5-3.5-3.5z"}]
     [:path.path3
      {:d "M10.958 2.352l1.085 0.296-3 11-1.085-0.296 3-11z"}]]

    [:symbol#icon-wondering
     {:view-box "0 0 16 16"}
     [:title "wondering"]
     [:path.path1
      {:d
       "M8 16c4.418 0 8-3.582 8-8s-3.582-8-8-8-8 3.582-8 8 3.582 8 8 8zM8 1.5c3.59 0 6.5 2.91 6.5 6.5s-2.91 6.5-6.5 6.5-6.5-2.91-6.5-6.5 2.91-6.5 6.5-6.5zM11.652 9.4l0.351 1.2-6.828 2-0.351-1.2zM4 5c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1zM10 5c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1z"}]]

    [:symbol#icon-close
     {:viewBox "0 0 16 16"}
     [:title "close, clear"]
     [:path
      {:d
       "M15.854 12.854c-0-0-0-0-0-0l-4.854-4.854 4.854-4.854c0-0 0-0 0-0 0.052-0.052 0.090-0.113 0.114-0.178 0.066-0.178 0.028-0.386-0.114-0.529l-2.293-2.293c-0.143-0.143-0.351-0.181-0.529-0.114-0.065 0.024-0.126 0.062-0.178 0.114 0 0-0 0-0 0l-4.854 4.854-4.854-4.854c-0-0-0-0-0-0-0.052-0.052-0.113-0.090-0.178-0.114-0.178-0.066-0.386-0.029-0.529 0.114l-2.293 2.293c-0.143 0.143-0.181 0.351-0.114 0.529 0.024 0.065 0.062 0.126 0.114 0.178 0 0 0 0 0 0l4.854 4.854-4.854 4.854c-0 0-0 0-0 0-0.052 0.052-0.090 0.113-0.114 0.178-0.066 0.178-0.029 0.386 0.114 0.529l2.293 2.293c0.143 0.143 0.351 0.181 0.529 0.114 0.065-0.024 0.126-0.062 0.178-0.114 0-0 0-0 0-0l4.854-4.854 4.854 4.854c0 0 0 0 0 0 0.052 0.052 0.113 0.090 0.178 0.114 0.178 0.066 0.386 0.029 0.529-0.114l2.293-2.293c0.143-0.143 0.181-0.351 0.114-0.529-0.024-0.065-0.062-0.126-0.114-0.178z"}]]

    [:symbol#icon-sad
     {:viewBox "0 0 16 16"}
     [:title "Sad face: error"]
     [:path.path1
      {:d
       "M8 16c4.418 0 8-3.582 8-8s-3.582-8-8-8-8 3.582-8 8 3.582 8 8 8zM8 1.5c3.59 0 6.5 2.91 6.5 6.5s-2.91 6.5-6.5 6.5-6.5-2.91-6.5-6.5 2.91-6.5 6.5-6.5zM4 5c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1zM10 5c0-0.552 0.448-1 1-1s1 0.448 1 1c0 0.552-0.448 1-1 1s-1-0.448-1-1zM4.998 12.199l-1.286-0.772c0.874-1.454 2.467-2.427 4.288-2.427s3.413 0.973 4.288 2.427l-1.286 0.772c-0.612-1.018-1.727-1.699-3.002-1.699s-2.389 0.681-3.002 1.699z"}]]

    [:symbol#icon-info
     {:view-box "0 0 16 16"}
     [:title "info"]
     [:path.path1
      {:d
       "M7 4.75c0-0.412 0.338-0.75 0.75-0.75h0.5c0.412 0 0.75 0.338 0.75 0.75v0.5c0 0.412-0.338 0.75-0.75 0.75h-0.5c-0.412 0-0.75-0.338-0.75-0.75v-0.5z"}]
     [:path.path2 {:d "M10 12h-4v-1h1v-3h-1v-1h3v4h1z"}]
     [:path.path3
      {:d
       "M8 0c-4.418 0-8 3.582-8 8s3.582 8 8 8 8-3.582 8-8-3.582-8-8-8zM8 14.5c-3.59 0-6.5-2.91-6.5-6.5s2.91-6.5 6.5-6.5 6.5 2.91 6.5 6.5-2.91 6.5-6.5 6.5z"}]]

    [:symbol#icon-circle-left
     {:viewBox "0 0 16 16"}
     [:title "circle-left"]
     [:path
      {:d
       "M8 16c4.418 0 8-3.582 8-8s-3.582-8-8-8-8 3.582-8 8 3.582 8 8 8zM8 1.5c3.59 0 6.5 2.91 6.5 6.5s-2.91 6.5-6.5 6.5-6.5-2.91-6.5-6.5 2.91-6.5 6.5-6.5z"}]
     [:path
      {:d
       "M10.457 4.957l-1.414-1.414-4.457 4.457 4.457 4.457 1.414-1.414-3.043-3.043z"}]]
    [:symbol#icon-circle-up
     {:viewBox "0 0 16 16"}
     [:title "circle-up"]
     [:path
      {:d
       "M0 8c0 4.418 3.582 8 8 8s8-3.582 8-8-3.582-8-8-8-8 3.582-8 8zM14.5 8c0 3.59-2.91 6.5-6.5 6.5s-6.5-2.91-6.5-6.5 2.91-6.5 6.5-6.5 6.5 2.91 6.5 6.5z"}]
     [:path
      {:d
       "M11.043 10.457l1.414-1.414-4.457-4.457-4.457 4.457 1.414 1.414 3.043-3.043z"}]] [:symbol#icon-circle-right
                                                                                         {:view-box "0 0 16 16"}
                                                                                         [:title "circle-right"]
                                                                                         [:path.path1
                                                                                          {:d
                                                                                           "M8 0c-4.418 0-8 3.582-8 8s3.582 8 8 8 8-3.582 8-8-3.582-8-8-8zM8 14.5c-3.59 0-6.5-2.91-6.5-6.5s2.91-6.5 6.5-6.5 6.5 2.91 6.5 6.5-2.91 6.5-6.5 6.5z"}]
                                                                                         [:path.path2
                                                                                          {:d
                                                                                           "M5.543 11.043l1.414 1.414 4.457-4.457-4.457-4.457-1.414 1.414 3.043 3.043z"}]]

    [:symbol#icon-circle-down
     {:view-box "0 0 16 16"}
     [:title "circle-down"]
     [:path.path1
      {:d
       "M16 8c0-4.418-3.582-8-8-8s-8 3.582-8 8 3.582 8 8 8 8-3.582 8-8zM1.5 8c0-3.59 2.91-6.5 6.5-6.5s6.5 2.91 6.5 6.5-2.91 6.5-6.5 6.5-6.5-2.91-6.5-6.5z"}]
     [:path.path2
      {:d
       "M4.957 5.543l-1.414 1.414 4.457 4.457 4.457-4.457-1.414-1.414-3.043 3.043z"}]]

    [:symbol#icon-search
     {:view-box "0 0 16 16"}
     [:title "search"]
     [:path.path1
      {:d
       "M15.504 13.616l-3.79-3.223c-0.392-0.353-0.811-0.514-1.149-0.499 0.895-1.048 1.435-2.407 1.435-3.893 0-3.314-2.686-6-6-6s-6 2.686-6 6 2.686 6 6 6c1.486 0 2.845-0.54 3.893-1.435-0.016 0.338 0.146 0.757 0.499 1.149l3.223 3.79c0.552 0.613 1.453 0.665 2.003 0.115s0.498-1.452-0.115-2.003zM6 10c-2.209 0-4-1.791-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4z"}]]

    [:symbol#expanded-row
     {:view-box "0 0 16 16"}
     [:title "Expanded row"]
     [:path
      {:stroke-width "2"
       :d "M0 0 L 0 9, L 26 09 L 26 07 L 2 07 L 2 0"}]
     [:path.path2
      {:d
       "M11 11l1.414 1.414 4.457-4.457-4.457-4.457-1.414 1.414 3.043 3.043z"}]]

    [:symbol#icon-eh
     {:view-box "0.125 0 16 16"}
     [:title "Eh?"]

     [:path.path
      {:d "m6.670358,14.791868l0,-1.067631l1.067631,0l1.067631,0l0,1.067631l0,1.067631l-1.067631,0l-1.067631,0l0,-1.067631zm0.25882,-3.294258c0,-1.177521 0.287357,-2.0784 0.936737,-2.936718c0.169581,-0.224144 0.789982,-0.834689 1.378667,-1.356767c1.554303,-1.378438 1.879947,-1.894157 1.810339,-2.867015c-0.100778,-1.408503 -1.464612,-2.586058 -2.990826,-2.582323c-1.564342,0.003829 -2.635751,0.931092 -3.045506,2.635769c-0.062018,0.258011 -0.130662,0.468442 -0.152541,0.467624c-0.021879,-0.000818 -0.418304,-0.058383 -0.880944,-0.127923c-0.46264,-0.06954 -0.866242,-0.127105 -0.896893,-0.127923c-0.030651,-0.000818 -0.03634,-0.110676 -0.012642,-0.24413c0.320767,-1.806361 1.076684,-2.965255 2.374614,-3.640512c1.245252,-0.647851 3.023586,-0.760521 4.518594,-0.286285c2.125134,0.67412 3.379532,2.837413 2.848732,4.912824c-0.24902,0.973657 -0.82578,1.75068 -2.254815,3.037728c-0.942123,0.848516 -1.295198,1.26618 -1.49065,1.763342c-0.133746,0.340201 -0.266424,1.179141 -0.266424,1.684622l0,0.276693l-0.938221,0l-0.938221,0l0,-0.609005z"}]]

    [:symbol#icon-filter
     {:view-box "0 0 16 16"}
     [:title "filter"]
     [:path.path1
      {:d
       "M8 0c-4.418 0-8 1.119-8 2.5v1.5l6 6v5c0 0.552 0.895 1 2 1s2-0.448 2-1v-5l6-6v-1.5c0-1.381-3.582-2.5-8-2.5zM1.475 2.169c0.374-0.213 0.9-0.416 1.52-0.586 1.374-0.376 3.152-0.583 5.005-0.583s3.631 0.207 5.005 0.583c0.62 0.17 1.146 0.372 1.52 0.586 0.247 0.141 0.38 0.26 0.442 0.331-0.062 0.071-0.195 0.19-0.442 0.331-0.374 0.213-0.9 0.416-1.52 0.586-1.374 0.376-3.152 0.583-5.005 0.583s-3.631-0.207-5.005-0.583c-0.62-0.17-1.146-0.372-1.52-0.586-0.247-0.141-0.38-0.26-0.442-0.331 0.062-0.071 0.195-0.19 0.442-0.331z"}]]

    [:symbol#icon-file
     {:view-box "0 0 16 16"}
     [:title "file upload"]
     [:path.path1
      {:d
       "M14.341 3.579c-0.347-0.473-0.831-1.027-1.362-1.558s-1.085-1.015-1.558-1.362c-0.806-0.591-1.197-0.659-1.421-0.659h-7.75c-0.689 0-1.25 0.561-1.25 1.25v13.5c0 0.689 0.561 1.25 1.25 1.25h11.5c0.689 0 1.25-0.561 1.25-1.25v-9.75c0-0.224-0.068-0.615-0.659-1.421zM12.271 2.729c0.48 0.48 0.856 0.912 1.134 1.271h-2.406v-2.405c0.359 0.278 0.792 0.654 1.271 1.134zM14 14.75c0 0.136-0.114 0.25-0.25 0.25h-11.5c-0.135 0-0.25-0.114-0.25-0.25v-13.5c0-0.135 0.115-0.25 0.25-0.25 0 0 7.749-0 7.75 0v3.5c0 0.276 0.224 0.5 0.5 0.5h3.5v9.75z"}]
     [:path.path2
      {:d
       "M11.5 13h-7c-0.276 0-0.5-0.224-0.5-0.5s0.224-0.5 0.5-0.5h7c0.276 0 0.5 0.224 0.5 0.5s-0.224 0.5-0.5 0.5z"}]
     [:path.path3
      {:d
       "M11.5 11h-7c-0.276 0-0.5-0.224-0.5-0.5s0.224-0.5 0.5-0.5h7c0.276 0 0.5 0.224 0.5 0.5s-0.224 0.5-0.5 0.5z"}]
     [:path.path4
      {:d
       "M11.5 9h-7c-0.276 0-0.5-0.224-0.5-0.5s0.224-0.5 0.5-0.5h7c0.276 0 0.5 0.224 0.5 0.5s-0.224 0.5-0.5 0.5z"}]] [:svg#icon-rat
                                                                                                                     {:style {:enable-background "new 0 0 493.008 493.008"}
                                                                                                                      :view-box "0 0 493.008 493.008"
                                                                                                                      :version "1.1"}
                                                                                                                     [:title "rat"]
                                                                                                                     [:path
                                                                                                                      {:d
                                                                                                                       "M486.374,214.288l-50.79-41.124c-1.273-1.038-2.726-1.733-4.148-2.509c1.027-2.711,1.667-5.624,1.667-8.696  c0-13.604-11.024-24.636-24.628-24.636c-13.623,0-24.648,11.032-24.648,24.636c0,3.642,0.837,7.073,2.255,10.182h-65.078  c-19.338-13.31-43.72-21.317-70.292-21.317c-56.701,0-103.575,36.245-112.082,83.567c-25.589,3.797-49.221,27.364-49.221,58.953  c0,12.701-9.775,27.392-19.831,32.551c-6.77,3.473-8.685,3.496-62.939,6.101c-3.542,0.176-6.465,3.02-6.632,6.629  c-0.177,3.844,2.777,7.122,6.632,7.298c48.545,2.331,57.816,3.137,67.695,0.173c18.196-5.459,36.707-22.862,40.502-51.957  c0.184-1.411,1.253-8.733,4.465-14.331c6.882-11.993,18.188-13.303,19.508-13.646c6.173,32.181,30.118,59.027,62.795,72.723  c0,0.026-0.015,0.048-0.015,0.074c0,9.237,7.479,16.723,16.723,16.723h127.517c9.24,0,16.723-7.486,16.723-16.723  c0-9.237-7.482-16.723-16.723-16.723h-16.382l82.88-67.073l65.245-9.163c7.074-0.997,12.886-6.092,14.78-12.975  C494.264,226.144,491.911,218.787,486.374,214.288z"}]]
    [:svg#icon-yeast
     {:view-box "179 225 50 50"}
     [:path
      {:d
       "m 213.39416,232.62355 a 13.131984,8.8388348 0 0 0 -13.13281,8.83984 13.131984,8.8388348 0 0 0 0.33203,1.92188 23.233509,11.616755 0 0 0 -19.52344,11.46289 23.233509,11.616755 0 0 0 23.23243,11.61523 23.233509,11.616755 0 0 0 23.23437,-11.61523 23.233509,11.616755 0 0 0 -4.88867,-7.1211 13.131984,8.8388348 0 0 0 3.87891,-6.26367 13.131984,8.8388348 0 0 0 -13.13282,-8.83984 z"}]]

    [:svg#icon-mouse
     {:view-box "0 0 612.001 612.001"
      :version "1.1"}
     [:path
      {:d
       "M49.893,443.325c-0.948,1.185-1.71,2.069-2.076,2.343c-15.98,12.01-22.065,1.155-37.096,13.068    c-2.432,1.927-5.852,12.863-8.728,23.611c-3.051,11.403-4.03,22.597,7.774,22.597h0.954h26.326h350.228h21.397h65.34    c6.314,0,12.544-1.516,18.125-4.469c209.43-110.773,89.53-238.558,47.381-299.686c-32.105-46.56-13.294-93.732-13.294-93.732    s-73.648,25.148,16.166,141.399c58.492,75.709,25.561,129.222-4.522,157.342c3.039-11.386,4.623-23.367,4.517-35.737    c-0.632-73.954-61.864-132.955-135.819-132.55c-46.553,0.254-89.093,8.936-127.575,23.024c4.361,13.554,4.926,28.264,1.469,43.15    c-4.661,20.072-16.239,38.161-32.599,50.935c-16.18,12.633-36.417,19.591-56.986,19.591h-64.054h-18.434    C84.562,398.441,65.044,422.541,49.893,443.325z M120.612,407.733c11.543,0.604,20.411,10.452,19.807,21.995    c-0.604,11.543-10.452,20.411-21.995,19.807s-20.411-10.452-19.807-21.995C99.221,415.997,109.069,407.129,120.612,407.733z"}]
     [:path
      {:d
       "M133.414,350.262h57.461c31.426,0,59.147-21.383,66.257-51.995c2.436-10.488,2.048-20.151-0.436-28.786    c-7.871-27.356-36.847-44.365-64.227-44.365c-13.197,0-26.016,3.947-35.929,12.589c-46.699,40.712-29.72,112.557-29.72,112.557    H133.414z"}]] [:svg#icon-zebrafish
                                                                                                                                                                                                                                                            {:view-box "0 0 231.236 231.236"
                                                                                                                                                                                                                                                             :version "1.1"}
                                                                                                                                                                                                                                                            [:path
                                                                                                                                                                                                                                                             {:d
                                                                                                                                                                                                                                                              "M196.231,115.618c6.723-2.425,13.358-6.088,18.866-11.596c18.817-18.817,16.054-51.067,15.927-52.431l-0.385-4.131  l-4.13-0.385c-0.089-0.008-2.206-0.202-5.576-0.202c-11.477,0-32.824,2.096-46.857,16.128c-8.031,8.031-12.123,18.506-14.175,27.985  c-11.702-9.376-27.239-19.427-45.08-25.028c0.753-7.972,0.255-13.805,0.202-14.367l-0.385-4.131l-4.13-0.385  c-0.089-0.008-2.206-0.202-5.576-0.202c-11.477,0-32.824,2.096-46.856,16.128c-1.757,1.757-3.325,3.631-4.725,5.586  C21.102,82.404,2.612,111.841,1.615,113.461L0,116.083l1.615,2.622c1.306,2.12,32.592,51.927,85.488,51.927  c29.504,0,55.533-15.582,72.972-29.591c2.107,9.267,6.192,19.385,14,27.194c14.032,14.032,35.38,16.127,46.857,16.128  c3.37,0,5.487-0.194,5.576-0.202l4.13-0.385l0.385-4.131c0.127-1.363,2.891-33.613-15.927-52.431  C209.589,121.706,202.954,118.043,196.231,115.618z M48.06,114.482c-4.933,0-8.932-3.999-8.932-8.932s3.999-8.932,8.932-8.932  s8.932,3.999,8.932,8.932S52.993,114.482,48.06,114.482z"}]] [:svg#icon-worm
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             {:view-box "0 0 588.81 588.81"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              :version "1.1"}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             [:title "worm"]
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             [:path
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              {:d
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "M585.831,10.021c-1.281-0.314-2.566-0.359-3.77-0.359l-1.51,0.008l-0.723-0.008c-0.392,0-0.791,0.065-1.555,0.208    c-1.027-0.078-2.052-0.18-3.08-0.281c-1.652-0.167-3.309-0.335-4.961-0.408c-3.081-0.123-6.182-0.225-9.245,0.028    c-1.551,0.127-2.995,0.551-4.395,0.963c-0.648,0.192-1.298,0.384-1.954,0.539c-1.021,0.241-2.044,0.465-3.068,0.69    c-1.444,0.318-2.889,0.636-4.32,0.995c-1.429,0.355-2.84,0.759-4.256,1.159l-5.365,1.453c-2.411,0.628-4.826,1.261-7.201,2.016    c-1.232,0.396-2.317,0.975-3.37,1.542c-0.579,0.31-1.154,0.62-1.75,0.89c-1.028,0.461-2.069,0.894-3.113,1.326    c-1.652,0.685-3.305,1.371-4.904,2.162c-1.832,0.902-3.603,1.926-5.373,2.946l-3.072,1.754c-0.584,0.334-1.163,0.673-1.775,0.935    c-5.92,2.489-10.616,6.552-14.047,9.812c-1.478,1.408-3.358,2.489-5.354,3.635l-1.207,0.702c-3.48,2.044-6.459,4.892-9.38,8.956    c-1.388,1.934-3.102,3.884-5.239,5.977c-0.33,0.326-0.673,0.637-1.008,0.951c-1.611,1.485-3.431,3.166-4.23,5.892    c-0.062,0.175-0.466,0.6-0.73,0.881c-0.384,0.404-0.763,0.816-1.065,1.256c-0.815,1.183-1.235,2.224-1.33,3.28    c-0.061,0.69-0.004,1.371,0.058,1.979c0.012,0.139,0.032,0.269,0.045,0.396c-0.306,0.282-0.559,0.49-0.579,0.51    c-0.249,0.11-0.49,0.237-0.719,0.371c-2.934,1.734-4.94,4.235-5.916,7.312c-0.085,0.126-0.216,0.241-0.338,0.359    c-0.421,0.424-0.996,1-1.273,1.856c-0.106,0.334-0.18,0.665-0.18,0.767c-0.094,0.273-0.693,1.489-1.946,3.717    c-1.13,2.003-2.179,4.06-3.153,6.153c-1.167,2.513-2.117,4.255-2.452,4.676c-1.004,1.273-1.334,2.354-1.004,3.317l0.062,0.147    c-0.033,0.126-0.082,0.281-0.147,0.465c-0.171,0.465-0.44,1.004-0.689,1.506c-0.285,0.579-0.546,1.118-0.693,1.518    c-0.24,0.653-0.367,1.367-0.375,2.252c-0.302,4.472-1.775,10.2-3.199,15.741c-1.077,4.194-2.194,8.536-2.835,12.444    c-7.643,46.247-31.869,103.241-76.941,124.501c-17.295,8.16-37.226,11.815-56.691,10.392c-3.651-0.261-7.173-0.624-10.624-0.979    c-6.292-0.649-12.236-1.265-18.425-1.265c-4.929,0-9.478,0.404-13.905,1.224c-11.073,2.057-22.138,4.162-33.203,6.263    l-16.887,3.227c-39.049,13.33-72.616,43.685-89.584,80.861c-2.016,2.783-2.562,6.521-1.591,9.788    c-1.693,0.841-3.06,2.48-3.696,4.599c-0.571,1.885-0.449,3.741,0.27,5.259c-1.392,1.016-2.501,2.488-3.154,4.255    c-0.897,2.437-0.775,5.015,0.294,7.096l-0.922,2.934c-9.735,30.979-20.768,66.088-21.636,98.646    c-0.069,0.057-0.327,0.179-0.51,0.269l-0.518,0.258c-1.077,0.562-1.607,1.619-2.154,2.717c-0.098,0.196-0.428,0.51-0.722,0.787    c-0.273,0.258-0.547,0.522-0.934,0.951c-0.367,0.388-0.979,1.032-1.094,1.995c-0.359,2.979-0.657,5.969-0.942,8.955    c-0.021,0.225-0.033,0.441-0.037,0.661c-0.18,0.307-0.637,0.935-1.293,1.596c-0.653,0.652-1.403,1.444-2.011,2.391    c-0.743,1.146-1.367,2.37-1.991,3.595c-0.575,1.126-1.143,2.26-1.832,3.312c-0.718,1.098-1.763,2.216-3.289,3.525    c-0.836,0.714-1.656,1.456-2.48,2.203c-2.366,2.142-4.602,4.166-7.144,5.517c-2.248,1.187-4.006,2.762-5.708,4.283    c-1.334,1.191-2.595,2.317-4.011,3.195c-0.6,0.371-1.211,0.726-1.828,1.077c-0.681,0.396-1.363,0.783-2.032,1.203    c-0.951,0.596-1.893,1.204-2.836,1.812c-1.424,0.922-2.844,1.841-4.3,2.701c-2.248,1.33-4.529,2.615-6.805,3.896l-3.558,2.012    c-0.412,0.232-0.816,0.485-1.216,0.738c-0.534,0.339-1.073,0.682-1.636,0.946c-1.11,0.526-2.236,1.021-3.362,1.514    c-1.616,0.71-3.228,1.42-4.798,2.212l-2.448,1.235c-4.284,2.154-8.715,4.383-12.93,6.888c-3.158,1.872-5.471,4.736-6.687,8.282    c-0.502,1.448-0.445,2.86,0.159,3.97c0.51,0.938,1.399,1.611,2.497,1.885c1.281,0.314,2.566,0.359,3.77,0.359l1.51-0.008    l0.722,0.008c0.392,0,0.792-0.065,1.554-0.208c1.028,0.077,2.052,0.18,3.081,0.281c1.652,0.168,3.309,0.335,4.961,0.408    c1.681,0.069,3.366,0.131,5.047,0.131c1.403,0,2.807-0.045,4.198-0.159c1.55-0.127,2.995-0.551,4.394-0.963    c0.649-0.192,1.297-0.384,1.955-0.539c1.02-0.24,2.044-0.465,3.068-0.689c1.444-0.318,2.889-0.637,4.321-0.995    c1.428-0.355,2.844-0.759,4.26-1.159l5.361-1.452c2.412-0.629,4.827-1.261,7.201-2.016c1.228-0.396,2.317-0.975,3.366-1.538    c0.579-0.311,1.159-0.624,1.758-0.894c1.028-0.461,2.073-0.897,3.117-1.326c1.648-0.686,3.301-1.375,4.896-2.162    c1.832-0.901,3.603-1.926,5.374-2.946l3.072-1.754c0.583-0.335,1.163-0.673,1.775-0.935c5.92-2.488,10.616-6.553,14.047-9.812    c1.477-1.407,3.358-2.488,5.353-3.635l1.208-0.702c3.48-2.044,6.458-4.892,9.38-8.955c1.387-1.935,3.101-3.885,5.239-5.978    c0.331-0.326,0.673-0.637,1.008-0.951c1.611-1.484,3.431-3.166,4.231-5.891c0.061-0.176,0.465-0.604,0.734-0.89    c0.379-0.4,0.759-0.808,1.061-1.249c0.286-0.412,0.535-0.819,0.739-1.24c0.175-0.354,1.289-2.061,2.713-3.917    c17.769-23.227,24.664-51.889,31.331-79.608c8.666-36.022,16.851-70.05,46.72-93.963c13.219-10.587,29.155-18.254,46.087-22.175    c11.853-2.745,21.44-4.08,29.303-4.08c6.287,0,11.354,0.874,15.063,2.591c0.204,0.095,0.424,0.188,0.652,0.266    c0.123,0.049,0.339,0.184,0.543,0.318c0.367,0.236,0.738,0.461,1.134,0.628c0.404,0.172,0.833,0.29,1.294,0.392l0.686,0.082    c0.767,0,1.473-0.294,1.99-0.828c0.217-0.229,0.388-0.481,0.515-0.763c0.155-0.024,0.351-0.041,0.583-0.041    c0.996,0.004,3.211,0.403,4.831,0.697l2.113,0.363c0.718,0.114,1.428,0.232,2.134,0.375l0.714,0.074    c1.135-0.005,2.167-0.515,2.853-0.906c2.925-1.685,8.115-1.714,13.133-1.746c4.134-0.021,8.405-0.049,11.824-0.987    c18.173-1.453,36.141-6.977,51.682-15.835c19.918-7.27,37.042-19.902,55.68-41.146c0.607-0.677,1.525-1.701,1.432-3.043    c-0.057-0.869,0.099-1.33,1.191-1.787c1.146-0.478,4.194-1.75,3.872-5.553c0.065-0.245,0.47-0.747,0.693-0.869    c2.444-1.241,3.538-3.097,3.346-5.684c-0.069-0.934,0.221-1.102,0.698-1.265c1.211-0.417,3.904-1.795,2.77-5.749    c-0.134-0.469-0.171-0.702-0.229-0.722c0.07-0.045,0.209-0.122,0.453-0.22c4.133-1.591,4.276-3.57,3.052-7.156    c-0.065-0.188-0.126-0.379-0.188-0.58c1.354-0.118,2.615-0.812,3.428-1.901c0.894-1.191,1.162-2.705,0.734-4.158    c-0.208-0.706-0.506-1.383-0.824-2.056c0.942-0.196,1.868-0.775,2.623-1.665c0.608-0.722,1.273-1.603,1.596-2.701    c0.313-1.085,0.22-2.175,0.085-3.101c-0.139-0.963-0.673-1.672-1.179-2.223c0.869-0.249,1.701-0.902,2.395-1.897    c0.616-0.885,1.106-1.648,1.481-2.513c0.583-1.322,0.285-3.35-0.657-4.525c-0.416-0.514-0.705-1.024-0.894-1.575    c1.869-0.033,3.578-1.591,4.174-3.811c0.481-1.791,0.155-3.476-0.995-5.149c-0.037-0.053-0.106-0.224-0.147-0.775    c1.314,0.118,2.514-0.559,3.02-1.689c0.123-0.265,0.249-0.542,0.408-0.799c1.146-1.889,1.118-3.709-0.086-5.557    c-0.384-0.592-0.514-0.926-0.579-0.991c0.131-0.094,0.388-0.216,0.534-0.286c0.421-0.204,1.314-0.628,1.624-1.632    c0.71-0.546,1.175-1.199,1.379-1.954c0.412-1.51-0.354-2.791-1.044-3.945l-0.343-0.551c-0.192-0.306-0.485-0.747-0.58-0.632    c0,0,0.074-0.098,0.339-0.278c0.833-0.563,1.028-1.432,1.069-2.06c0.616-0.322,1.102-0.861,1.354-1.514    c0.322-0.829,0.257-1.783-0.18-2.615c-0.253-0.478-0.514-0.926-0.836-1.33c-0.262-0.331-0.311-0.604-0.27-0.759    c0.073-0.269,0.787-0.791,1.126-1.044c0.498-0.363,0.967-0.709,1.306-1.199c0.31-0.441,0.6-0.885,0.865-1.354    c0.437-0.788,0.615-1.759,0.481-2.595c-0.176-1.098-0.376-2.191-0.584-3.313c-0.036-0.188-0.062-0.355-0.081-0.506    c1.379-0.653,2.346-2.219,2.758-2.986c0.865-1.636,0.771-3.309-0.281-4.965c-0.327-0.514-0.551-1.163-0.764-1.963    c1.273-0.424,2.403-1.652,3.085-3.415c0.734-1.877,0.489-3.607-0.751-5.275c-0.665-0.898-0.44-1.612,1.257-3.888    c1.411-1.897,1.591-3.95,0.53-6.104c-0.318-0.641-0.367-1.273,0.375-2.448c1.897-3.003,3.75-6.557,1.918-10.874    c0.053-0.134,0.151-0.351,0.322-0.665c0.314-0.575,0.661-1.13,1.008-1.689c1.542-2.477,3.468-5.565,2.003-9.812    c-0.248-0.722-0.261-1.628-0.269-2.754c0.069-0.061,0.326-0.184,0.51-0.269l0.522-0.261c1.077-0.563,1.607-1.62,2.154-2.717    c0.098-0.196,0.428-0.51,0.722-0.788c0.273-0.257,0.547-0.522,0.935-0.951c0.367-0.388,0.979-1.032,1.093-1.995    c0.359-2.978,0.657-5.969,0.943-8.956c0.02-0.224,0.032-0.44,0.036-0.661c0.18-0.306,0.637-0.934,1.294-1.595    c0.652-0.653,1.403-1.444,2.011-2.391c0.743-1.146,1.367-2.371,1.991-3.595c0.575-1.126,1.143-2.26,1.832-3.313    c0.718-1.097,1.767-2.219,3.293-3.525c0.824-0.71,1.64-1.444,2.456-2.183c2.374-2.15,4.618-4.182,7.168-5.528    c2.248-1.191,4.011-2.766,5.712-4.292c1.335-1.191,2.591-2.313,4.007-3.19c0.6-0.372,1.212-0.727,1.828-1.077    c0.682-0.396,1.362-0.783,2.031-1.204c0.951-0.596,1.894-1.204,2.836-1.812c1.424-0.922,2.844-1.84,4.301-2.701    c2.248-1.33,4.528-2.615,6.805-3.896l3.559-2.012c0.411-0.232,0.815-0.485,1.216-0.738c0.534-0.339,1.072-0.682,1.636-0.947    c1.109-0.526,2.235-1.02,3.362-1.514c1.615-0.71,3.227-1.42,4.798-2.211l2.448-1.236c4.283-2.154,8.715-4.382,12.929-6.887    c3.158-1.873,5.472-4.737,6.688-8.283c0.502-1.448,0.444-2.86-0.159-3.97C587.818,10.964,586.933,10.294,585.831,10.021z"}]]

    [:svg#icon-fly
     {:style {:enable-background "new 0 0 563.881 563.881"}
      :view-box "-50 -40 650 650"
      :version "1.1"}
     [:title "fly"]
     [:path
      {:d
       "M7.164,124.165c-0.334-0.836-0.816-1.538-1.33-2.285c-0.241-0.351-0.502-0.73-0.779-1.171    c-0.416-0.657-1.15-1.008-1.95-0.938c-0.775,0.086-1.436,0.608-1.697,1.347c-1.616,4.557-1.518,8.56-1.257,12.599    c0.49,7.564,4.386,13.538,11.269,17.287c5.451,2.966,11.31,3.529,16.826,3.696l1.419,0.041c2.599,0.078,5.194,0.147,7.646,0.359    c0.062,0.021,0.163,0.078,0.257,0.139c0.184,2.958,2.064,4.745,5.598,5.316c3.101,0.506,6.226,0.885,9.355,1.22    c11.457,1.216,20.734,5.757,28.368,13.884c5.476,5.839,9.702,12.807,13.791,19.543c0.889,1.469,1.783,2.938,2.685,4.398    c6.899,11.139,13.815,22.273,20.771,33.379c3.219,5.141,7.94,8.49,13.652,9.69c4.223,0.889,8.531,1.595,12.697,2.276    c1.542,0.253,3.084,0.506,4.631,0.767c-2.925,4.108-5.859,8.209-8.788,12.31c-7.185,10.049-14.37,20.098-21.416,30.241    c-17.173,24.729-32.95,49.727-46.896,74.309c-16.406,28.919-28.075,53.607-36.728,77.695c-4.59,12.787-7.254,23.525-8.389,33.799    c-1.566,14.194,0.017,29.013,4.712,44.044c2.399,7.683,5.957,13.505,10.881,17.788c9.347,8.14,20.673,10.563,33.676,7.161    c11.918-3.105,22.604-8.561,33.407-14.35c27.748-14.863,51.388-29.25,72.265-43.986c6.21-4.382,12.354-9.05,18.299-13.554    l0.906-0.693c1.371-0.959,2.738-1.931,4.101-2.905c1.542-1.105,3.101-2.231,4.664-3.374l0.473,0.759    c0.416,0.656,1.15,1.032,1.938,0.942c2.938-0.298,5.227-1.693,7.421-3.089c-1.424,1.518-2.929,3.26-3.888,5.672    c-0.281,0.718-0.143,1.529,0.372,2.108c0.514,0.58,1.305,0.805,2.048,0.616c1.126-0.298,2.089-0.738,2.938-1.256    c-0.465,0.828-0.856,1.729-1.122,2.733c-0.192,0.726,0.028,1.493,0.575,2.007c0.546,0.515,1.334,0.678,2.04,0.449    c1.081-0.359,2.011-0.865,2.839-1.448c-0.139,0.188-0.273,0.375-0.408,0.562l-0.967,1.334c-0.661,0.898-0.477,2.163,0.417,2.836    l0.706,0.539c0.592,0.457,1.383,0.559,2.073,0.257c1.077-0.474,2.003-1.085,2.832-1.771c-0.416,0.832-0.75,1.737-0.959,2.737    c-0.146,0.702,0.086,1.432,0.612,1.918c0.53,0.493,1.273,0.66,1.962,0.457c0.771-0.229,1.812-0.596,2.722-1.294    c-0.294,0.877-0.51,1.8-0.612,2.803c-0.077,0.768,0.281,1.51,0.935,1.922c0.648,0.42,1.473,0.429,2.134,0.041    c0.722-0.425,1.358-0.914,1.926-1.44c-0.008,0.028-0.017,0.062-0.021,0.086l-0.302,1.15c-0.257,0.926,0.163,1.905,1.012,2.354    l0.669,0.351c0.816,0.425,1.82,0.253,2.448-0.429c0.053-0.057,0.106-0.105,0.159-0.163c-0.008,0.073-0.013,0.147-0.021,0.225    c-0.065,0.796,0.347,1.562,1.053,1.95c0.702,0.388,1.57,0.322,2.211-0.163c1.575-1.191,2.656-2.652,3.497-4.174    c-0.404,1.493-0.624,3.072-0.425,4.806c0.086,0.768,0.601,1.42,1.33,1.682c0.727,0.265,1.538,0.094,2.102-0.433    c2.542-2.403,3.546-5.378,4.517-8.25c0.245-0.722,0.485-1.444,0.759-2.154l0.053,0.013l-0.028,0.143    c-0.31,1.493-0.604,2.921-0.828,4.354c-0.216,1.403-0.359,2.815-0.502,4.227l-0.184,1.787c-0.118,1.073,0.62,2.053,1.686,2.236    l0.93,0.159c0.792,0.134,1.583-0.204,2.032-0.865c0.42-0.616,0.767-1.253,1.064-1.894c0.053,0.571,0.184,1.094,0.302,1.567    l0.151,0.645c0.188,0.959,1.697,1.632,2.685,1.632c0.013,0,0.024,0,0.037,0c0.57-0.013,1.105-0.257,1.48-0.678    c0.024,0.135,0.049,0.266,0.078,0.404c0.15,0.73,0.681,1.317,1.395,1.538c0.71,0.232,1.489,0.041,2.024-0.481    c0.343-0.334,0.648-0.677,0.909-1.028l0.021,0.204c0.098,1.077,1.983,1.954,2.901,1.832c0.673-0.021,1.285-0.371,1.648-0.926    c0.347,0.547,0.946,0.922,1.64,0.95l1.105,0.049c0.849,0.024,1.562-0.416,1.922-1.143c1.416-2.896,1.42-5.862,1.428-8.727    c0-0.955,0-1.877,0.058-2.774h0.33v0.135c-0.012,1.591-0.021,3.129,0.024,4.671c0.119,3.905,0.339,6.186,3.387,7.581    c0.628,0.29,1.362,0.24,1.95-0.139c0.416-0.266,0.718-0.673,0.853-1.134c0.073,0.13,0.146,0.261,0.225,0.396    c0.384,0.637,1.105,1.02,1.823,0.991c0.743-0.028,1.412-0.453,1.751-1.118c0.163-0.322,0.302-0.645,0.424-0.975    c0.106,0.204,0.217,0.403,0.307,0.604c0.416,0.918,2.17,1.191,3.141,0.931c0.833-0.229,1.429-0.955,1.494-1.812l0.008-0.074    c0.404,0.486,0.995,0.768,1.652,0.747c0.706-0.028,1.351-0.42,1.701-1.036c0.579-1.021,0.897-1.987,0.972-2.941    c0.334,0.701,0.738,1.391,1.231,2.052c0.474,0.637,1.273,0.931,2.061,0.775l0.991-0.212c1.057-0.229,1.759-1.245,1.592-2.31    l-1.616-10.347c0.277,0.701,0.522,1.444,0.775,2.207c0.894,2.697,1.905,5.757,4.766,7.936c0.673,0.514,1.587,0.562,2.301,0.118    c0.719-0.44,1.094-1.277,0.938-2.109c-0.379-2.081-0.946-4.076-1.559-6.018c0.931,2.325,2.212,4.696,4.863,6.349    c0.706,0.432,1.607,0.407,2.281-0.086c0.358-0.262,0.616-0.629,0.746-1.036c0.184,0.109,0.384,0.195,0.6,0.248    c0.616,0.144,1.266-0.004,1.759-0.403l1.135-0.914c0.665-0.53,0.93-1.42,0.665-2.231l-0.213-0.674    c0.547,0.47,1.171,0.897,1.894,1.265c0.637,0.331,1.396,0.294,2.003-0.085c0.608-0.38,0.972-1.045,0.959-1.763    c-0.017-1.077-0.2-2.053-0.494-2.954c0.543,0.444,1.146,0.853,1.82,1.188c0.673,0.334,1.477,0.273,2.093-0.163l0.723-0.515    c0.905-0.641,1.13-1.893,0.506-2.807l-1.33-1.954c0.959,0.836,2.04,1.566,3.333,2.109c0.714,0.289,1.534,0.163,2.122-0.343    l0.665-0.58c0.832-0.718,0.942-1.966,0.253-2.823l-1.094-1.351c0.645,0.49,1.351,0.931,2.134,1.294    c0.742,0.343,1.624,0.208,2.235-0.343l0.837-0.759c0.796-0.719,0.901-1.926,0.24-2.771l-0.987-1.269    c0.625,0.343,1.314,0.624,2.077,0.815c0.686,0.18,1.407-0.021,1.913-0.506l0.625-0.604c0.767-0.747,0.828-1.959,0.139-2.778    l-3.722-4.398c0.005,0,0.009,0.004,0.017,0.008c2.143,1.399,4.569,2.979,7.654,3.162c0.82,0.062,1.51-0.351,1.893-1.024    l0.466-0.823c0.045,0.036,0.09,0.073,0.135,0.102c5.883,4.558,11.971,9.266,18.099,13.729    c25.744,18.764,53.762,36.018,85.651,52.742c9.245,4.847,20.09,10.249,31.864,12.945c2.926,0.669,5.863,1.012,8.731,1.012    c13.428,0,25.015-7.49,30.996-20.028c5.487-11.497,7.001-23.795,7.707-33.224c1.525-20.399-4.284-39.27-10.163-55.035    c-7.634-20.474-17.083-40.8-28.091-60.416c-8.246-14.696-18.083-31.976-28.486-48.757c-15.068-24.296-32.559-49.881-53.477-78.208    c-0.771-1.044-1.522-2.102-2.302-3.211c1.469-0.249,2.941-0.481,4.415-0.718c4.1-0.657,8.339-1.334,12.488-2.248    c3.403-0.755,7.679-2.093,10.502-5.818c2.407-3.174,5.21-6.948,7.731-10.841c2.518-3.88,4.966-7.805,7.418-11.73    c2.126-3.407,4.255-6.818,6.426-10.196c1.399-2.179,2.782-4.37,4.166-6.557c4.015-6.361,8.164-12.934,12.664-19.045    c6.847-9.286,16.536-14.839,28.809-16.508l3.334-0.424c2.831-0.355,5.765-0.718,8.637-1.289c1.579-0.31,4.558-2.073,4.619-4.337    c0.016-0.661,0.15-0.853,0.15-0.853c0.208-0.167,1.229-0.22,1.714-0.245c1.416-0.069,2.832-0.11,4.251-0.159    c3.15-0.102,6.41-0.212,9.625-0.555c8.499-0.901,14.574-4.28,18.58-10.326c4.496-6.793,3.909-14.211,2.611-21.22    c-0.15-0.808-0.648-1.269-0.979-1.571l-0.318-0.31c-0.449-0.485-1.118-0.755-1.763-0.628c-0.657,0.086-1.229,0.486-1.534,1.073    l-0.714,1.326c-0.502,0.914-0.959,1.763-1.358,2.64c-4.525,10.094-11.461,16.161-21.2,18.547    c-5.545,1.359-11.118,2.603-16.691,3.848c-4.459,0.996-8.923,1.991-13.37,3.048c-7.531,1.783-13.79,5.108-18.613,9.882    l-3.194,3.146c-4.137,4.047-8.413,8.242-12.231,12.746c-10.273,12.142-21.253,25.275-31.951,39.103    c-5.104,6.597-11.203,9.882-19.191,10.322c-1.188,0.065-2.379,0.09-3.574,0.118c-4.692,0.102-9.527,0.208-14.113,2.583    l-10.51-14.007c-2.077-2.966-4.162-5.924-6.259-8.878c-1.347-1.889-2.644-3.439-3.766-4.484l-2.302-3.068h3.497    c1.028,0,1.897-0.767,2.023-1.787l0.09-0.714c0.135-1.057-0.571-2.036-1.611-2.252l-2.587-0.543    c-1.853-0.392-3.704-0.779-5.565-1.134c-0.767-0.146-1.436-0.661-1.787-1.224h10.507c1.04,0,1.979-1.379,2.093-2.412    c0.11-0.995-0.522-1.926-1.489-2.191l-0.571-0.171c-0.567-0.175-1.139-0.342-1.726-0.424c-2.729-0.387-5.459-0.742-8.25-1.069    c-0.706-0.085-1.437-0.167-1.722-0.151c-0.041-0.212-0.082-0.424-0.118-0.641c1.109-0.118,2.228-0.196,3.35-0.273    c3.374-0.245,6.866-0.489,10.27-1.775c0.853-0.322,1.387-1.167,1.313-2.077l-0.053-0.604c-0.094-1.053-0.976-1.856-2.032-1.856    h-14.019l-0.221-1.134l12.212-2.868c1.053-0.249,1.729-1.273,1.542-2.338l-0.212-1.191c-0.188-1.081-1.208-1.832-2.273-1.669    l-12.02,1.563l11.469-3.46c1.045-0.314,1.563-1.771,1.294-2.828l-0.18-0.702c-0.266-1.032-1.285-1.656-2.342-1.497l-13.085,2.395    l-0.154-0.428c0.832-0.232,1.664-0.441,2.492-0.653c3.546-0.906,7.218-1.836,10.519-4.06c0.682-0.457,1.02-1.281,0.86-2.089    c-0.158-0.804-0.787-1.44-1.591-1.604c-0.918-0.196-1.832-0.241-2.722-0.151c0.764-0.836,1.444-1.787,2.04-2.844l3.46-6.087    c1.963-3.443,3.925-6.887,5.847-10.355c4.048-7.307,8.083-14.623,12.122-21.938c7.617-13.811,15.234-27.622,22.945-41.379    c3.595-6.405,8.214-13.713,15.235-19.323c2.044-1.636,3.668-2.04,5.793-1.489c5.9,1.546,12.208,1.579,18.797,0.078    c11.012-2.501,21.583-6.667,31.363-10.792c4.944-2.089,8.453-5.594,10.433-10.429c0.648-1.587,1.171-3.219,1.688-4.851l0.69-2.125    c0.31-0.926-0.078-1.942-0.927-2.423l-0.942-0.539c-0.771-0.437-1.742-0.326-2.395,0.278c-0.393,0.359-0.792,0.71-1.191,1.065    c-0.979,0.861-1.991,1.75-2.894,2.799c-1.032,1.199-1.876,2.505-2.692,3.77l-0.641,0.979c-1.244,1.881-2.742,2.819-4.863,3.06    c-4.549,0.518-9.095,1.065-13.644,1.611c-8.013,0.963-16.026,1.934-24.056,2.722c-6.675,0.665-12.905,2.46-18.52,5.34    c-6.218,3.187-9.976,8.915-13.007,14.027c-3.79,6.389-7.434,12.999-10.959,19.384c-1.746,3.167-3.492,6.336-5.263,9.486    l-1.146,2.081c-2.55,4.664-4.962,9.066-9.335,11.906c-1.399,0.91-2.008,2.672-2.208,3.39c-0.645,2.33-2.113,4.031-4.275,6.022    l-1.171,1.073c-2.48,2.26-5.047,4.594-6.944,7.458c-4.614,6.981-8.947,14.292-13.134,21.354l-1.624,2.738    c-0.24,0.408-0.387,0.596-0.416,0.657c-1.844-0.535-4.108-0.465-6.34-0.245c-0.563,0.057-1.126,0.11-1.689,0.147l2.815-3.187    c0.689-0.779,0.682-1.955-0.021-2.726l-0.624-0.677c-0.714-0.767-1.89-0.869-2.729-0.241l-4.113,3.121l3.497-4.337    c0.682-0.84,0.583-2.064-0.216-2.791l-0.71-0.645c-0.768-0.698-1.926-0.706-2.705-0.033l-2.354,2.032l1.342-2.24    c0.543-0.906,0.307-2.077-0.546-2.697l-0.796-0.567c-0.849-0.608-2.031-0.485-2.726,0.302l-0.987,1.118    c0.232-0.571,0.188-1.208-0.094-1.73c2.628-2.044,4.329-4.961,4.773-8.278c0.429-3.211-0.403-6.405-2.264-8.874    c1.701-0.257,3.354-0.53,4.981-0.918c8.943-2.117,13.99-9.661,12.55-18.784c-1.044-6.626-4.831-12.203-11.575-17.054    c-10.024-7.202-21.787-10.029-34.867-8.38c-0.2,0.024-0.376,0.045-0.343,0.245c-0.004-0.004-0.086-0.126-0.2-0.539    c-2.02-7.197-8.601-10.975-15.725-8.943c-1.909,0.547-3.573,1.571-5.189,2.566l-0.375,0.232c-0.172,0.012-0.343,0.033-0.515,0.049    c-9.645-9.253-20.774-9.106-30.306,0.306c-4.256-2.713-7.353-3.888-10.159-3.888c-5.427,0-8.756,4.655-11.469,9.979    c-0.241-0.016-0.481-0.037-0.718-0.057c-17.651-1.787-30.878,2.962-40.841,14.513c-4.529,5.251-6.3,11.396-5.125,17.764    c1.114,6.022,5.369,10.078,12.652,12.065c1.624,0.44,3.244,0.685,4.827,0.889c-0.792,1.191-1.542,2.452-1.995,3.896    c-1.546,4.974,0.204,9.865,4.354,13.162c-0.302,0.526-0.363,1.171-0.135,1.758l-0.983-1.114c-0.702-0.804-1.901-0.926-2.75-0.286    l-0.734,0.551c-0.84,0.625-1.064,1.787-0.53,2.681l1.387,2.322l-2.378-2.061c-0.816-0.702-2.04-0.649-2.795,0.118l-0.71,0.727    c-0.738,0.747-0.583,2.187,0.085,2.99l3.272,3.958l-4.153-3.134c-0.861-0.641-2.069-0.518-2.771,0.294l-0.571,0.657    c-0.677,0.775-0.673,1.934,0.012,2.697l2.64,2.975c-1.208-0.086-2.464-0.167-3.819-0.237c-0.767,0-1.566,0.155-2.305,0.453    c-0.979,0.383-1.734,0.118-2.264-0.874l-1.085-2.04c-1.53-2.893-3.117-5.879-4.847-8.752c-4.59-7.621-9.796-16.259-17.948-22.595    c-0.338-0.261-0.971-0.755-1.081-0.975c-1.681-4.619-4.925-7.838-8.058-10.951l-1.032-1.028c-0.404-0.408-0.747-0.971-0.967-1.367    l-2.109-3.676c-1.979-3.443-3.958-6.883-5.822-10.383l-1.709-3.236c-4.37-8.27-8.895-16.826-14.664-24.549    c-3.929-5.263-7.805-8.507-12.566-10.518c-6.793-2.864-13.856-3.607-20.686-4.325c-7.071-0.747-14.125-1.624-21.184-2.505    c-3.876-0.485-7.756-0.971-11.636-1.432c-2.015-0.245-3.48-1.232-4.745-3.215c-1.085-1.697-2.403-3.672-3.954-5.447    c-0.808-0.935-1.754-1.6-2.668-2.244c-0.343-0.245-0.686-0.485-1.016-0.743c-0.844-0.661-2.223-0.343-2.941,0.433l-0.392,0.42    c-0.469,0.506-0.657,1.208-0.494,1.876c1.701,6.981,4.353,13.889,12.211,17.124c7.389,3.048,14.892,5.806,20.6,7.87    c12.289,4.431,21.792,5.349,32.098,2.938c0.783,0,2.097,0.543,3.129,1.29c5.251,3.819,9.73,9.127,14.092,16.704    c6.765,11.758,13.309,23.493,19.372,34.419c3.048,5.5,6.047,11.016,9.049,16.54c2.546,4.68,5.092,9.364,7.663,14.027    c3.366,6.104,6.834,12.146,10.302,18.188c0.506,0.877,1.077,1.673,1.718,2.391c-0.539-0.077-1.098-0.057-1.665-0.028l-0.587,0.021    c-0.996,0-1.853,0.747-2.016,1.73l-0.143,0.832c-0.179,1.02,0.429,2.012,1.42,2.31l12.571,3.786l-0.139,0.367l-13.027-2.456    c-1.061-0.204-2.105,0.465-2.358,1.521l-0.192,0.804c-0.208,0.873,0.18,1.783,0.955,2.235c2.828,1.653,5.9,2.403,8.874,3.125    c1.188,0.29,2.33,0.571,3.448,0.897l-12.55-1.603c-1.097-0.143-2.089,0.6-2.272,1.681l-0.196,1.146    c-0.184,1.061,0.49,2.081,1.534,2.33l12.256,2.925c-0.053,0.318-0.102,0.637-0.131,0.955c-0.041,0.424-0.11,0.555-0.212,0.424    c-0.131,0-0.273-0.012-0.433-0.029c-2.917-0.314-5.871-0.4-8.727-0.478l-1.354-0.032c-0.836,0-1.673,0.077-2.509,0.151    l-1.155,0.098c-1.04,0.074-1.881,1.522-1.921,2.562c-0.037,0.889,0.51,1.697,1.346,1.999c3.403,1.228,6.895,1.498,10.273,1.763    c1.204,0.09,2.403,0.184,3.599,0.322c0,0.237,0.016,0.388,0.053,0.408c-0.266,0.127-1.347,0.253-2.293,0.355l-1.277,0.114    c-0.706,0.061-1.412,0.114-2.105,0.22c-1.612,0.241-3.219,0.501-4.823,0.767l-1.893,0.314c-1.041,0.167-1.783,1.105-1.706,2.154    l0.057,0.767c0.086,1.061,0.971,1.876,2.036,1.876h10.498c-0.424,0.69-1.13,1.13-2.109,1.322c-1.86,0.363-3.717,0.763-5.573,1.159    l-2.256,0.481c-1.069,0.229-1.771,1.256-1.591,2.33l0.122,0.734c0.171,0.975,1.02,1.689,2.012,1.689h3.439l-22.693,30.212    c-0.621-0.159-1.224-0.322-1.816-0.481c-2.24-0.6-4.357-1.171-6.54-1.518c-2.334-0.379-4.684-0.42-6.96-0.457l-1.297-0.024    c-8.797-0.196-15.276-3.5-20.392-10.408c-7.511-10.13-15.969-20.718-25.859-32.367c-3.476-4.088-7.295-7.948-10.992-11.685    c-2.656-2.685-5.316-5.373-7.866-8.16c-6.079-6.643-13.709-11.008-22.668-12.983c-2.097-0.461-4.194-0.938-6.292-1.416    c-5.263-1.2-10.71-2.436-16.124-3.436C20.93,142.798,11.803,135.85,7.164,124.165z"}]]

    [:svg#icon-human
     {:style {:enable-background "new 0 0 206 206.326"}
      :view-box "0 0 206.326 206.326"
      :version "1.1"}
     [:title "human"]
     [:path
      {:d
       "M104.265,117.959c-0.304,3.58,2.126,22.529,3.38,29.959c0.597,3.52,2.234,9.255,1.645,12.3    c-0.841,4.244-1.084,9.736-0.621,12.934c0.292,1.942,1.211,10.899-0.104,14.175c-0.688,1.718-1.949,10.522-1.949,10.522    c-3.285,8.294-1.431,7.886-1.431,7.886c1.017,1.248,2.759,0.098,2.759,0.098c1.327,0.846,2.246-0.201,2.246-0.201    c1.139,0.943,2.467-0.116,2.467-0.116c1.431,0.743,2.758-0.627,2.758-0.627c0.822,0.414,1.023-0.109,1.023-0.109    c2.466-0.158-1.376-8.05-1.376-8.05c-0.92-7.088,0.913-11.033,0.913-11.033c6.004-17.805,6.309-22.53,3.909-29.24    c-0.676-1.937-0.847-2.704-0.536-3.545c0.719-1.941,0.195-9.748,1.072-12.848c1.692-5.979,3.361-21.142,4.231-28.217    c1.169-9.53-4.141-22.308-4.141-22.308c-1.163-5.2,0.542-23.727,0.542-23.727c2.381,3.705,2.29,10.245,2.29,10.245    c-0.378,6.859,5.541,17.342,5.541,17.342c2.844,4.332,3.921,8.442,3.921,8.747c0,1.248-0.273,4.269-0.273,4.269l0.109,2.631    c0.049,0.67,0.426,2.977,0.365,4.092c-0.444,6.862,0.646,5.571,0.646,5.571c0.92,0,1.931-5.522,1.931-5.522    c0,1.424-0.348,5.687,0.42,7.295c0.919,1.918,1.595-0.329,1.607-0.78c0.243-8.737,0.768-6.448,0.768-6.448    c0.511,7.088,1.139,8.689,2.265,8.135c0.853-0.407,0.073-8.506,0.073-8.506c1.461,4.811,2.569,5.577,2.569,5.577    c2.411,1.693,0.92-2.983,0.585-3.909c-1.784-4.92-1.839-6.625-1.839-6.625c2.229,4.421,3.909,4.257,3.909,4.257    c2.174-0.694-1.9-6.954-4.287-9.953c-1.218-1.528-2.789-3.574-3.245-4.789c-0.743-2.058-1.304-8.674-1.304-8.674    c-0.225-7.807-2.155-11.198-2.155-11.198c-3.3-5.282-3.921-15.135-3.921-15.135l-0.146-16.635    c-1.157-11.347-9.518-11.429-9.518-11.429c-8.451-1.258-9.627-3.988-9.627-3.988c-1.79-2.576-0.767-7.514-0.767-7.514    c1.485-1.208,2.058-4.415,2.058-4.415c2.466-1.891,2.345-4.658,1.206-4.628c-0.914,0.024-0.707-0.733-0.707-0.733    C115.068,0.636,104.01,0,104.01,0h-1.688c0,0-11.063,0.636-9.523,13.089c0,0,0.207,0.758-0.715,0.733    c-1.136-0.03-1.242,2.737,1.215,4.628c0,0,0.572,3.206,2.058,4.415c0,0,1.023,4.938-0.767,7.514c0,0-1.172,2.73-9.627,3.988    c0,0-8.375,0.082-9.514,11.429l-0.158,16.635c0,0-0.609,9.853-3.922,15.135c0,0-1.921,3.392-2.143,11.198    c0,0-0.563,6.616-1.303,8.674c-0.451,1.209-2.021,3.255-3.249,4.789c-2.408,2.993-6.455,9.24-4.29,9.953    c0,0,1.689,0.164,3.909-4.257c0,0-0.046,1.693-1.827,6.625c-0.35,0.914-1.839,5.59,0.573,3.909c0,0,1.117-0.767,2.569-5.577    c0,0-0.779,8.099,0.088,8.506c1.133,0.555,1.751-1.047,2.262-8.135c0,0,0.524-2.289,0.767,6.448    c0.012,0.451,0.673,2.698,1.596,0.78c0.779-1.608,0.429-5.864,0.429-7.295c0,0,0.999,5.522,1.933,5.522    c0,0,1.099,1.291,0.648-5.571c-0.073-1.121,0.32-3.422,0.369-4.092l0.106-2.631c0,0-0.274-3.014-0.274-4.269    c0-0.311,1.078-4.415,3.921-8.747c0,0,5.913-10.488,5.532-17.342c0,0-0.082-6.54,2.299-10.245c0,0,1.69,18.526,0.545,23.727    c0,0-5.319,12.778-4.146,22.308c0.864,7.094,2.53,22.237,4.226,28.217c0.886,3.094,0.362,10.899,1.072,12.848    c0.32,0.847,0.152,1.627-0.536,3.545c-2.387,6.71-2.083,11.436,3.921,29.24c0,0,1.848,3.945,0.914,11.033    c0,0-3.836,7.892-1.379,8.05c0,0,0.192,0.523,1.023,0.109c0,0,1.327,1.37,2.761,0.627c0,0,1.328,1.06,2.463,0.116    c0,0,0.91,1.047,2.237,0.201c0,0,1.742,1.175,2.777-0.098c0,0,1.839,0.408-1.435-7.886c0,0-1.254-8.793-1.945-10.522    c-1.318-3.275-0.387-12.251-0.106-14.175c0.453-3.216,0.21-8.695-0.618-12.934c-0.606-3.038,1.035-8.774,1.641-12.3    c1.245-7.423,3.685-26.373,3.38-29.959l1.008,0.354C103.809,118.312,104.265,117.959,104.265,117.959z"}]]

    [:symbol#icon-checkmark
     {:viewBox "0 0 16 16"}
     [:title "Checkmark"]
     [:path {:d "M13.5 2l-7.5 7.5-3.5-3.5-2.5 2.5 6 6 10-10z"}]

     [:symbol#icon-converted
      {:viewBox "0 0 16 16"}
      [:title "Converted"]
      [:path
       {:d
        "M12 11h-1.586l-2.5-2.5 2.5-2.5h1.586v2.5l3.5-3.5-3.5-3.5v2.5h-2c-0.265 0-0.52 0.105-0.707 0.293l-2.793 2.793-2.793-2.793c-0.188-0.188-0.442-0.293-0.707-0.293h-3v2h2.586l2.5 2.5-2.5 2.5h-2.586v2h3c0.265 0 0.52-0.105 0.707-0.293l2.793-2.793 2.793 2.793c0.188 0.188 0.442 0.293 0.707 0.293h2v2.5l3.5-3.5-3.5-3.5v2.5z"}]]
     [:symbol#icon-duplicate
      {:viewBox "0 0 16 16"}
      [:title "duplicate"]
      [:path
       {:d
        "M10 4v-4h-7l-3 3v9h6v4h10v-12h-6zM3 1.414v1.586h-1.586l1.586-1.586zM1 11v-7h3v-3h5v3l-3 3v4h-5zM9 5.414v1.586h-1.586l1.586-1.586zM15 15h-8v-7h3v-3h5v10z"}]]]

    [:symbol#icon-history
     {:viewBox "0 0 16 16"}
     [:title "history"]
     [:path
      {:d
       "M10.293 11.707l-3.293-3.293v-4.414h2v3.586l2.707 2.707zM8 0c-4.418 0-8 3.582-8 8s3.582 8 8 8 8-3.582 8-8-3.582-8-8-8zM8 14c-3.314 0-6-2.686-6-6s2.686-6 6-6c3.314 0 6 2.686 6 6s-2.686 6-6 6z"}]]

    [:symbol#icon-sort-alpha-asc
     {:viewBox "0 0 16 16"}
     [:title "Sort alphabetically ascending"]
     [:path {:d "M5 12v-12h-2v12h-2.5l3.5 3.5 3.5-3.5h-2.5z"}]
     [:path
      {:d
       "M14.5 16h-4c-0.184 0-0.354-0.101-0.441-0.264s-0.077-0.36 0.025-0.513l3.482-5.223h-3.066c-0.276 0-0.5-0.224-0.5-0.5s0.224-0.5 0.5-0.5h4c0.184 0 0.354 0.101 0.441 0.264s0.077 0.36-0.025 0.513l-3.482 5.223h3.066c0.276 0 0.5 0.224 0.5 0.5s-0.224 0.5-0.5 0.5z"}]
     [:path
      {:d
       "M15.947 6.276l-3-6c-0.085-0.169-0.258-0.276-0.447-0.276s-0.363 0.107-0.447 0.276l-3 6c-0.123 0.247-0.023 0.547 0.224 0.671 0.072 0.036 0.148 0.053 0.223 0.053 0.183 0 0.36-0.101 0.448-0.277l0.862-1.724h3.382l0.862 1.724c0.123 0.247 0.424 0.347 0.671 0.224s0.347-0.424 0.224-0.671zM11.309 4l1.191-2.382 1.191 2.382h-2.382z"}]]

    [:symbol#icon-sort-alpha-desc
     {:viewBox "0 0 16 16"}
     [:title "Sort alphabetically descending"]
     [:path {:d "M5 12v-12h-2v12h-2.5l3.5 3.5 3.5-3.5h-2.5z"}]
     [:path
      {:d
       "M14.5 7h-4c-0.184 0-0.354-0.101-0.441-0.264s-0.077-0.36 0.025-0.513l3.482-5.223h-3.066c-0.276 0-0.5-0.224-0.5-0.5s0.224-0.5 0.5-0.5h4c0.184 0 0.354 0.102 0.441 0.264s0.077 0.36-0.025 0.513l-3.482 5.223h3.066c0.276 0 0.5 0.224 0.5 0.5s-0.224 0.5-0.5 0.5z"}]
     [:path
      {:d
       "M15.947 15.276l-3-6c-0.085-0.169-0.258-0.276-0.447-0.276s-0.363 0.107-0.447 0.276l-3 6c-0.123 0.247-0.023 0.547 0.224 0.671 0.072 0.036 0.148 0.053 0.223 0.053 0.183 0 0.36-0.101 0.448-0.277l0.862-1.724h3.382l0.862 1.724c0.123 0.247 0.424 0.347 0.671 0.224s0.347-0.424 0.224-0.671zM11.309 13l1.191-2.382 1.191 2.382h-2.382z"}]]

    [:symbol#icon-bin
     {:viewBox "0 0 16 16"}
     [:title "bin"]
     [:path
      {:d
       "M2 5v10c0 0.55 0.45 1 1 1h9c0.55 0 1-0.45 1-1v-10h-11zM5 14h-1v-7h1v7zM7 14h-1v-7h1v7zM9 14h-1v-7h1v7zM11 14h-1v-7h1v7z"}]
     [:path
      {:d
       "M13.25 2h-3.25v-1.25c0-0.412-0.338-0.75-0.75-0.75h-3.5c-0.412 0-0.75 0.338-0.75 0.75v1.25h-3.25c-0.413 0-0.75 0.337-0.75 0.75v1.25h13v-1.25c0-0.413-0.338-0.75-0.75-0.75zM9 2h-3v-0.987h3v0.987z"}]]

    [:symbol#icon-checkbox-checked
     {:viewBox "0 0 16 16"}
     [:title "checkbox-checked"]
     [:path
      {:d
       "M14 0h-12c-1.1 0-2 0.9-2 2v12c0 1.1 0.9 2 2 2h12c1.1 0 2-0.9 2-2v-12c0-1.1-0.9-2-2-2zM7 12.414l-3.707-3.707 1.414-1.414 2.293 2.293 4.793-4.793 1.414 1.414-6.207 6.207z"}]]
    [:symbol#icon-checkbox-unchecked
     {:viewBox "0 0 16 16"}
     [:title "checkbox-unchecked"]
     [:path
      {:d
       "M14 0h-12c-1.1 0-2 0.9-2 2v12c0 1.1 0.9 2 2 2h12c1.1 0 2-0.9 2-2v-12c0-1.1-0.9-2-2-2zM14 14h-12v-12h12v12z"}]]

    [:symbol#icon-edit
     {:viewBox "0 0 16 16"}
     [:title "Edit"]
     [:path
      {:d
       "M13.5 0c1.381 0 2.5 1.119 2.5 2.5 0 0.563-0.186 1.082-0.5 1.5l-1 1-3.5-3.5 1-1c0.418-0.314 0.937-0.5 1.5-0.5zM1 11.5l-1 4.5 4.5-1 9.25-9.25-3.5-3.5-9.25 9.25zM11.181 5.681l-7 7-0.862-0.862 7-7 0.862 0.862z"}]]

    [:symbol#icon-my-data
     {:viewBox "0 0 32 32"}
     [:title "my-data"]
     [:path
      {:d
       "M16 0c-8.837 0-16 2.239-16 5v4c0 2.761 7.163 5 16 5s16-2.239 16-5v-4c0-2.761-7.163-5-16-5z"}]
     [:path
      {:d
       "M16 17c-8.837 0-16-2.239-16-5v6c0 2.761 7.163 5 16 5s16-2.239 16-5v-6c0 2.761-7.163 5-16 5z"}]
     [:path
      {:d

       "M16 26c-8.837 0-16-2.239-16-5v6c0 2.761 7.163 5 16 5s16-2.239 16-5v-6c0 2.761-7.163 5-16 5z"}]]]])