// Compiled by ClojureScript 1.9.89 {}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_.call(null,data)){
return clojure.string.join.call(null," ",cljs.core.map.call(null,dommy$core$selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name.call(null,data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__12249__auto__ = elem.textContent;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str.call(null,k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var args25732 = [];
var len__13324__auto___25735 = arguments.length;
var i__13325__auto___25736 = (0);
while(true){
if((i__13325__auto___25736 < len__13324__auto___25735)){
args25732.push((arguments[i__13325__auto___25736]));

var G__25737 = (i__13325__auto___25736 + (1));
i__13325__auto___25736 = G__25737;
continue;
} else {
}
break;
}

var G__25734 = args25732.length;
switch (G__25734) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25732.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.call(null,window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str.call(null,k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.call(null,elem,k);
if(cljs.core.seq.call(null,pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__4655__auto__ = elem.classList;
if(cljs.core.truth_(temp__4655__auto__)){
var class_list = temp__4655__auto__;
return class_list.contains(c__$1);
} else {
var temp__4657__auto__ = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(temp__4657__auto__)){
var class_name = temp__4657__auto__;
var temp__4657__auto____$1 = dommy.utils.class_index.call(null,class_name,c__$1);
if(cljs.core.truth_(temp__4657__auto____$1)){
var i = temp__4657__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432)) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"top","top",-1856271961),r.top,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),r.bottom,new cljs.core.Keyword(null,"left","left",-399115937),r.left,new cljs.core.Keyword(null,"right","right",-452581833),r.right,new cljs.core.Keyword(null,"width","width",-384071477),r.width,new cljs.core.Keyword(null,"height","height",1025178622),r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.call(null,cljs.core.identity,cljs.core.iterate.call(null,dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var args25739 = [];
var len__13324__auto___25742 = arguments.length;
var i__13325__auto___25743 = (0);
while(true){
if((i__13325__auto___25743 < len__13324__auto___25742)){
args25739.push((arguments[i__13325__auto___25743]));

var G__25744 = (i__13325__auto___25743 + (1));
i__13325__auto___25743 = G__25744;
continue;
} else {
}
break;
}

var G__25741 = args25739.length;
switch (G__25741) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25739.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array.call(null,base.querySelectorAll(dommy.core.selector.call(null,selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.call(null,document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var args25747 = [];
var len__13324__auto___25750 = arguments.length;
var i__13325__auto___25751 = (0);
while(true){
if((i__13325__auto___25751 < len__13324__auto___25750)){
args25747.push((arguments[i__13325__auto___25751]));

var G__25752 = (i__13325__auto___25751 + (1));
i__13325__auto___25751 = G__25752;
continue;
} else {
}
break;
}

var G__25749 = args25747.length;
switch (G__25749) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25747.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first.call(null,cljs.core.filter.call(null,dommy.core.matches_pred.call(null,base,selector),cljs.core.take_while.call(null,(function (p1__25746_SHARP_){
return !((p1__25746_SHARP_ === base));
}),dommy.core.ancestors.call(null,elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.call(null,document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if(!((void 0 === elem.textContent))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___25766 = arguments.length;
var i__13325__auto___25767 = (0);
while(true){
if((i__13325__auto___25767 < len__13324__auto___25766)){
args__13331__auto__.push((arguments[i__13325__auto___25767]));

var G__25768 = (i__13325__auto___25767 + (1));
i__13325__auto___25767 = G__25768;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__25756_25769 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__25757_25770 = null;
var count__25758_25771 = (0);
var i__25759_25772 = (0);
while(true){
if((i__25759_25772 < count__25758_25771)){
var vec__25760_25773 = cljs.core._nth.call(null,chunk__25757_25770,i__25759_25772);
var k_25774 = cljs.core.nth.call(null,vec__25760_25773,(0),null);
var v_25775 = cljs.core.nth.call(null,vec__25760_25773,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_25774),v_25775);

var G__25776 = seq__25756_25769;
var G__25777 = chunk__25757_25770;
var G__25778 = count__25758_25771;
var G__25779 = (i__25759_25772 + (1));
seq__25756_25769 = G__25776;
chunk__25757_25770 = G__25777;
count__25758_25771 = G__25778;
i__25759_25772 = G__25779;
continue;
} else {
var temp__4657__auto___25780 = cljs.core.seq.call(null,seq__25756_25769);
if(temp__4657__auto___25780){
var seq__25756_25781__$1 = temp__4657__auto___25780;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25756_25781__$1)){
var c__13060__auto___25782 = cljs.core.chunk_first.call(null,seq__25756_25781__$1);
var G__25783 = cljs.core.chunk_rest.call(null,seq__25756_25781__$1);
var G__25784 = c__13060__auto___25782;
var G__25785 = cljs.core.count.call(null,c__13060__auto___25782);
var G__25786 = (0);
seq__25756_25769 = G__25783;
chunk__25757_25770 = G__25784;
count__25758_25771 = G__25785;
i__25759_25772 = G__25786;
continue;
} else {
var vec__25763_25787 = cljs.core.first.call(null,seq__25756_25781__$1);
var k_25788 = cljs.core.nth.call(null,vec__25763_25787,(0),null);
var v_25789 = cljs.core.nth.call(null,vec__25763_25787,(1),null);
style.setProperty(dommy.utils.as_str.call(null,k_25788),v_25789);

var G__25790 = cljs.core.next.call(null,seq__25756_25781__$1);
var G__25791 = null;
var G__25792 = (0);
var G__25793 = (0);
seq__25756_25769 = G__25790;
chunk__25757_25770 = G__25791;
count__25758_25771 = G__25792;
i__25759_25772 = G__25793;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq25754){
var G__25755 = cljs.core.first.call(null,seq25754);
var seq25754__$1 = cljs.core.next.call(null,seq25754);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25755,seq25754__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___25800 = arguments.length;
var i__13325__auto___25801 = (0);
while(true){
if((i__13325__auto___25801 < len__13324__auto___25800)){
args__13331__auto__.push((arguments[i__13325__auto___25801]));

var G__25802 = (i__13325__auto___25801 + (1));
i__13325__auto___25801 = G__25802;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__25796_25803 = cljs.core.seq.call(null,keywords);
var chunk__25797_25804 = null;
var count__25798_25805 = (0);
var i__25799_25806 = (0);
while(true){
if((i__25799_25806 < count__25798_25805)){
var kw_25807 = cljs.core._nth.call(null,chunk__25797_25804,i__25799_25806);
style.removeProperty(dommy.utils.as_str.call(null,kw_25807));

var G__25808 = seq__25796_25803;
var G__25809 = chunk__25797_25804;
var G__25810 = count__25798_25805;
var G__25811 = (i__25799_25806 + (1));
seq__25796_25803 = G__25808;
chunk__25797_25804 = G__25809;
count__25798_25805 = G__25810;
i__25799_25806 = G__25811;
continue;
} else {
var temp__4657__auto___25812 = cljs.core.seq.call(null,seq__25796_25803);
if(temp__4657__auto___25812){
var seq__25796_25813__$1 = temp__4657__auto___25812;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25796_25813__$1)){
var c__13060__auto___25814 = cljs.core.chunk_first.call(null,seq__25796_25813__$1);
var G__25815 = cljs.core.chunk_rest.call(null,seq__25796_25813__$1);
var G__25816 = c__13060__auto___25814;
var G__25817 = cljs.core.count.call(null,c__13060__auto___25814);
var G__25818 = (0);
seq__25796_25803 = G__25815;
chunk__25797_25804 = G__25816;
count__25798_25805 = G__25817;
i__25799_25806 = G__25818;
continue;
} else {
var kw_25819 = cljs.core.first.call(null,seq__25796_25813__$1);
style.removeProperty(dommy.utils.as_str.call(null,kw_25819));

var G__25820 = cljs.core.next.call(null,seq__25796_25813__$1);
var G__25821 = null;
var G__25822 = (0);
var G__25823 = (0);
seq__25796_25803 = G__25820;
chunk__25797_25804 = G__25821;
count__25798_25805 = G__25822;
i__25799_25806 = G__25823;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq25794){
var G__25795 = cljs.core.first.call(null,seq25794);
var seq25794__$1 = cljs.core.next.call(null,seq25794);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25795,seq25794__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___25836 = arguments.length;
var i__13325__auto___25837 = (0);
while(true){
if((i__13325__auto___25837 < len__13324__auto___25836)){
args__13331__auto__.push((arguments[i__13325__auto___25837]));

var G__25838 = (i__13325__auto___25837 + (1));
i__13325__auto___25837 = G__25838;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__25826_25839 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),kvs));
var chunk__25827_25840 = null;
var count__25828_25841 = (0);
var i__25829_25842 = (0);
while(true){
if((i__25829_25842 < count__25828_25841)){
var vec__25830_25843 = cljs.core._nth.call(null,chunk__25827_25840,i__25829_25842);
var k_25844 = cljs.core.nth.call(null,vec__25830_25843,(0),null);
var v_25845 = cljs.core.nth.call(null,vec__25830_25843,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_25844,[cljs.core.str(v_25845),cljs.core.str("px")].join(''));

var G__25846 = seq__25826_25839;
var G__25847 = chunk__25827_25840;
var G__25848 = count__25828_25841;
var G__25849 = (i__25829_25842 + (1));
seq__25826_25839 = G__25846;
chunk__25827_25840 = G__25847;
count__25828_25841 = G__25848;
i__25829_25842 = G__25849;
continue;
} else {
var temp__4657__auto___25850 = cljs.core.seq.call(null,seq__25826_25839);
if(temp__4657__auto___25850){
var seq__25826_25851__$1 = temp__4657__auto___25850;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25826_25851__$1)){
var c__13060__auto___25852 = cljs.core.chunk_first.call(null,seq__25826_25851__$1);
var G__25853 = cljs.core.chunk_rest.call(null,seq__25826_25851__$1);
var G__25854 = c__13060__auto___25852;
var G__25855 = cljs.core.count.call(null,c__13060__auto___25852);
var G__25856 = (0);
seq__25826_25839 = G__25853;
chunk__25827_25840 = G__25854;
count__25828_25841 = G__25855;
i__25829_25842 = G__25856;
continue;
} else {
var vec__25833_25857 = cljs.core.first.call(null,seq__25826_25851__$1);
var k_25858 = cljs.core.nth.call(null,vec__25833_25857,(0),null);
var v_25859 = cljs.core.nth.call(null,vec__25833_25857,(1),null);
dommy.core.set_style_BANG_.call(null,elem,k_25858,[cljs.core.str(v_25859),cljs.core.str("px")].join(''));

var G__25860 = cljs.core.next.call(null,seq__25826_25851__$1);
var G__25861 = null;
var G__25862 = (0);
var G__25863 = (0);
seq__25826_25839 = G__25860;
chunk__25827_25840 = G__25861;
count__25828_25841 = G__25862;
i__25829_25842 = G__25863;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq25824){
var G__25825 = cljs.core.first.call(null,seq25824);
var seq25824__$1 = cljs.core.next.call(null,seq25824);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25825,seq25824__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var args25864 = [];
var len__13324__auto___25883 = arguments.length;
var i__13325__auto___25884 = (0);
while(true){
if((i__13325__auto___25884 < len__13324__auto___25883)){
args25864.push((arguments[i__13325__auto___25884]));

var G__25885 = (i__13325__auto___25884 + (1));
i__13325__auto___25884 = G__25885;
continue;
} else {
}
break;
}

var G__25870 = args25864.length;
switch (G__25870) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args25864.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__13343__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.call(null,elem,k,dommy.utils.as_str.call(null,k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_.call(null,v)){
var G__25871 = elem;
(G__25871[k__$1] = v);

return G__25871;
} else {
var G__25872 = elem;
G__25872.setAttribute(k__$1,v);

return G__25872;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__25873_25887 = cljs.core.seq.call(null,cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.call(null,(2),kvs)));
var chunk__25874_25888 = null;
var count__25875_25889 = (0);
var i__25876_25890 = (0);
while(true){
if((i__25876_25890 < count__25875_25889)){
var vec__25877_25891 = cljs.core._nth.call(null,chunk__25874_25888,i__25876_25890);
var k_25892__$1 = cljs.core.nth.call(null,vec__25877_25891,(0),null);
var v_25893__$1 = cljs.core.nth.call(null,vec__25877_25891,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_25892__$1,v_25893__$1);

var G__25894 = seq__25873_25887;
var G__25895 = chunk__25874_25888;
var G__25896 = count__25875_25889;
var G__25897 = (i__25876_25890 + (1));
seq__25873_25887 = G__25894;
chunk__25874_25888 = G__25895;
count__25875_25889 = G__25896;
i__25876_25890 = G__25897;
continue;
} else {
var temp__4657__auto___25898 = cljs.core.seq.call(null,seq__25873_25887);
if(temp__4657__auto___25898){
var seq__25873_25899__$1 = temp__4657__auto___25898;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25873_25899__$1)){
var c__13060__auto___25900 = cljs.core.chunk_first.call(null,seq__25873_25899__$1);
var G__25901 = cljs.core.chunk_rest.call(null,seq__25873_25899__$1);
var G__25902 = c__13060__auto___25900;
var G__25903 = cljs.core.count.call(null,c__13060__auto___25900);
var G__25904 = (0);
seq__25873_25887 = G__25901;
chunk__25874_25888 = G__25902;
count__25875_25889 = G__25903;
i__25876_25890 = G__25904;
continue;
} else {
var vec__25880_25905 = cljs.core.first.call(null,seq__25873_25899__$1);
var k_25906__$1 = cljs.core.nth.call(null,vec__25880_25905,(0),null);
var v_25907__$1 = cljs.core.nth.call(null,vec__25880_25905,(1),null);
dommy.core.set_attr_BANG_.call(null,elem,k_25906__$1,v_25907__$1);

var G__25908 = cljs.core.next.call(null,seq__25873_25899__$1);
var G__25909 = null;
var G__25910 = (0);
var G__25911 = (0);
seq__25873_25887 = G__25908;
chunk__25874_25888 = G__25909;
count__25875_25889 = G__25910;
i__25876_25890 = G__25911;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq25865){
var G__25866 = cljs.core.first.call(null,seq25865);
var seq25865__$1 = cljs.core.next.call(null,seq25865);
var G__25867 = cljs.core.first.call(null,seq25865__$1);
var seq25865__$2 = cljs.core.next.call(null,seq25865__$1);
var G__25868 = cljs.core.first.call(null,seq25865__$2);
var seq25865__$3 = cljs.core.next.call(null,seq25865__$2);
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25866,G__25867,G__25868,seq25865__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var args25912 = [];
var len__13324__auto___25922 = arguments.length;
var i__13325__auto___25923 = (0);
while(true){
if((i__13325__auto___25923 < len__13324__auto___25922)){
args25912.push((arguments[i__13325__auto___25923]));

var G__25924 = (i__13325__auto___25923 + (1));
i__13325__auto___25923 = G__25924;
continue;
} else {
}
break;
}

var G__25917 = args25912.length;
switch (G__25917) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args25912.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13343__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_25926__$1 = dommy.utils.as_str.call(null,k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_25926__$1))){
dommy.core.set_class_BANG_.call(null,elem,"");
} else {
elem.removeAttribute(k_25926__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__25918_25927 = cljs.core.seq.call(null,cljs.core.cons.call(null,k,ks));
var chunk__25919_25928 = null;
var count__25920_25929 = (0);
var i__25921_25930 = (0);
while(true){
if((i__25921_25930 < count__25920_25929)){
var k_25931__$1 = cljs.core._nth.call(null,chunk__25919_25928,i__25921_25930);
dommy.core.remove_attr_BANG_.call(null,elem,k_25931__$1);

var G__25932 = seq__25918_25927;
var G__25933 = chunk__25919_25928;
var G__25934 = count__25920_25929;
var G__25935 = (i__25921_25930 + (1));
seq__25918_25927 = G__25932;
chunk__25919_25928 = G__25933;
count__25920_25929 = G__25934;
i__25921_25930 = G__25935;
continue;
} else {
var temp__4657__auto___25936 = cljs.core.seq.call(null,seq__25918_25927);
if(temp__4657__auto___25936){
var seq__25918_25937__$1 = temp__4657__auto___25936;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25918_25937__$1)){
var c__13060__auto___25938 = cljs.core.chunk_first.call(null,seq__25918_25937__$1);
var G__25939 = cljs.core.chunk_rest.call(null,seq__25918_25937__$1);
var G__25940 = c__13060__auto___25938;
var G__25941 = cljs.core.count.call(null,c__13060__auto___25938);
var G__25942 = (0);
seq__25918_25927 = G__25939;
chunk__25919_25928 = G__25940;
count__25920_25929 = G__25941;
i__25921_25930 = G__25942;
continue;
} else {
var k_25943__$1 = cljs.core.first.call(null,seq__25918_25937__$1);
dommy.core.remove_attr_BANG_.call(null,elem,k_25943__$1);

var G__25944 = cljs.core.next.call(null,seq__25918_25937__$1);
var G__25945 = null;
var G__25946 = (0);
var G__25947 = (0);
seq__25918_25927 = G__25944;
chunk__25919_25928 = G__25945;
count__25920_25929 = G__25946;
i__25921_25930 = G__25947;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq25913){
var G__25914 = cljs.core.first.call(null,seq25913);
var seq25913__$1 = cljs.core.next.call(null,seq25913);
var G__25915 = cljs.core.first.call(null,seq25913__$1);
var seq25913__$2 = cljs.core.next.call(null,seq25913__$1);
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25914,G__25915,seq25913__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var args25948 = [];
var len__13324__auto___25951 = arguments.length;
var i__13325__auto___25952 = (0);
while(true){
if((i__13325__auto___25952 < len__13324__auto___25951)){
args25948.push((arguments[i__13325__auto___25952]));

var G__25953 = (i__13325__auto___25952 + (1));
i__13325__auto___25952 = G__25953;
continue;
} else {
}
break;
}

var G__25950 = args25948.length;
switch (G__25950) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args25948.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.call(null,elem,k,cljs.core.boolean$.call(null,dommy.core.attr.call(null,elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.call(null,elem,k);
} else {
return dommy.core.remove_attr_BANG_.call(null,elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var args25955 = [];
var len__13324__auto___25973 = arguments.length;
var i__13325__auto___25974 = (0);
while(true){
if((i__13325__auto___25974 < len__13324__auto___25973)){
args25955.push((arguments[i__13325__auto___25974]));

var G__25975 = (i__13325__auto___25974 + (1));
i__13325__auto___25974 = G__25975;
continue;
} else {
}
break;
}

var G__25960 = args25955.length;
switch (G__25960) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args25955.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13343__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim.call(null,dommy.utils.as_str.call(null,classes)).split(/\s+/);
if(cljs.core.seq.call(null,classes__$1)){
var temp__4655__auto___25977 = elem.classList;
if(cljs.core.truth_(temp__4655__auto___25977)){
var class_list_25978 = temp__4655__auto___25977;
var seq__25961_25979 = cljs.core.seq.call(null,classes__$1);
var chunk__25962_25980 = null;
var count__25963_25981 = (0);
var i__25964_25982 = (0);
while(true){
if((i__25964_25982 < count__25963_25981)){
var c_25983 = cljs.core._nth.call(null,chunk__25962_25980,i__25964_25982);
class_list_25978.add(c_25983);

var G__25984 = seq__25961_25979;
var G__25985 = chunk__25962_25980;
var G__25986 = count__25963_25981;
var G__25987 = (i__25964_25982 + (1));
seq__25961_25979 = G__25984;
chunk__25962_25980 = G__25985;
count__25963_25981 = G__25986;
i__25964_25982 = G__25987;
continue;
} else {
var temp__4657__auto___25988 = cljs.core.seq.call(null,seq__25961_25979);
if(temp__4657__auto___25988){
var seq__25961_25989__$1 = temp__4657__auto___25988;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25961_25989__$1)){
var c__13060__auto___25990 = cljs.core.chunk_first.call(null,seq__25961_25989__$1);
var G__25991 = cljs.core.chunk_rest.call(null,seq__25961_25989__$1);
var G__25992 = c__13060__auto___25990;
var G__25993 = cljs.core.count.call(null,c__13060__auto___25990);
var G__25994 = (0);
seq__25961_25979 = G__25991;
chunk__25962_25980 = G__25992;
count__25963_25981 = G__25993;
i__25964_25982 = G__25994;
continue;
} else {
var c_25995 = cljs.core.first.call(null,seq__25961_25989__$1);
class_list_25978.add(c_25995);

var G__25996 = cljs.core.next.call(null,seq__25961_25989__$1);
var G__25997 = null;
var G__25998 = (0);
var G__25999 = (0);
seq__25961_25979 = G__25996;
chunk__25962_25980 = G__25997;
count__25963_25981 = G__25998;
i__25964_25982 = G__25999;
continue;
}
} else {
}
}
break;
}
} else {
var seq__25965_26000 = cljs.core.seq.call(null,classes__$1);
var chunk__25966_26001 = null;
var count__25967_26002 = (0);
var i__25968_26003 = (0);
while(true){
if((i__25968_26003 < count__25967_26002)){
var c_26004 = cljs.core._nth.call(null,chunk__25966_26001,i__25968_26003);
var class_name_26005 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_26005,c_26004))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_26005 === ""))?c_26004:[cljs.core.str(class_name_26005),cljs.core.str(" "),cljs.core.str(c_26004)].join('')));
}

var G__26006 = seq__25965_26000;
var G__26007 = chunk__25966_26001;
var G__26008 = count__25967_26002;
var G__26009 = (i__25968_26003 + (1));
seq__25965_26000 = G__26006;
chunk__25966_26001 = G__26007;
count__25967_26002 = G__26008;
i__25968_26003 = G__26009;
continue;
} else {
var temp__4657__auto___26010 = cljs.core.seq.call(null,seq__25965_26000);
if(temp__4657__auto___26010){
var seq__25965_26011__$1 = temp__4657__auto___26010;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25965_26011__$1)){
var c__13060__auto___26012 = cljs.core.chunk_first.call(null,seq__25965_26011__$1);
var G__26013 = cljs.core.chunk_rest.call(null,seq__25965_26011__$1);
var G__26014 = c__13060__auto___26012;
var G__26015 = cljs.core.count.call(null,c__13060__auto___26012);
var G__26016 = (0);
seq__25965_26000 = G__26013;
chunk__25966_26001 = G__26014;
count__25967_26002 = G__26015;
i__25968_26003 = G__26016;
continue;
} else {
var c_26017 = cljs.core.first.call(null,seq__25965_26011__$1);
var class_name_26018 = dommy.core.class$.call(null,elem);
if(cljs.core.truth_(dommy.utils.class_index.call(null,class_name_26018,c_26017))){
} else {
dommy.core.set_class_BANG_.call(null,elem,(((class_name_26018 === ""))?c_26017:[cljs.core.str(class_name_26018),cljs.core.str(" "),cljs.core.str(c_26017)].join('')));
}

var G__26019 = cljs.core.next.call(null,seq__25965_26011__$1);
var G__26020 = null;
var G__26021 = (0);
var G__26022 = (0);
seq__25965_26000 = G__26019;
chunk__25966_26001 = G__26020;
count__25967_26002 = G__26021;
i__25968_26003 = G__26022;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__25969_26023 = cljs.core.seq.call(null,cljs.core.conj.call(null,more_classes,classes));
var chunk__25970_26024 = null;
var count__25971_26025 = (0);
var i__25972_26026 = (0);
while(true){
if((i__25972_26026 < count__25971_26025)){
var c_26027 = cljs.core._nth.call(null,chunk__25970_26024,i__25972_26026);
dommy.core.add_class_BANG_.call(null,elem,c_26027);

var G__26028 = seq__25969_26023;
var G__26029 = chunk__25970_26024;
var G__26030 = count__25971_26025;
var G__26031 = (i__25972_26026 + (1));
seq__25969_26023 = G__26028;
chunk__25970_26024 = G__26029;
count__25971_26025 = G__26030;
i__25972_26026 = G__26031;
continue;
} else {
var temp__4657__auto___26032 = cljs.core.seq.call(null,seq__25969_26023);
if(temp__4657__auto___26032){
var seq__25969_26033__$1 = temp__4657__auto___26032;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25969_26033__$1)){
var c__13060__auto___26034 = cljs.core.chunk_first.call(null,seq__25969_26033__$1);
var G__26035 = cljs.core.chunk_rest.call(null,seq__25969_26033__$1);
var G__26036 = c__13060__auto___26034;
var G__26037 = cljs.core.count.call(null,c__13060__auto___26034);
var G__26038 = (0);
seq__25969_26023 = G__26035;
chunk__25970_26024 = G__26036;
count__25971_26025 = G__26037;
i__25972_26026 = G__26038;
continue;
} else {
var c_26039 = cljs.core.first.call(null,seq__25969_26033__$1);
dommy.core.add_class_BANG_.call(null,elem,c_26039);

var G__26040 = cljs.core.next.call(null,seq__25969_26033__$1);
var G__26041 = null;
var G__26042 = (0);
var G__26043 = (0);
seq__25969_26023 = G__26040;
chunk__25970_26024 = G__26041;
count__25971_26025 = G__26042;
i__25972_26026 = G__26043;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq25956){
var G__25957 = cljs.core.first.call(null,seq25956);
var seq25956__$1 = cljs.core.next.call(null,seq25956);
var G__25958 = cljs.core.first.call(null,seq25956__$1);
var seq25956__$2 = cljs.core.next.call(null,seq25956__$1);
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25957,G__25958,seq25956__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var args26044 = [];
var len__13324__auto___26054 = arguments.length;
var i__13325__auto___26055 = (0);
while(true){
if((i__13325__auto___26055 < len__13324__auto___26054)){
args26044.push((arguments[i__13325__auto___26055]));

var G__26056 = (i__13325__auto___26055 + (1));
i__13325__auto___26055 = G__26056;
continue;
} else {
}
break;
}

var G__26049 = args26044.length;
switch (G__26049) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args26044.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13343__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__4655__auto___26058 = elem.classList;
if(cljs.core.truth_(temp__4655__auto___26058)){
var class_list_26059 = temp__4655__auto___26058;
class_list_26059.remove(c__$1);
} else {
var class_name_26060 = dommy.core.class$.call(null,elem);
var new_class_name_26061 = dommy.utils.remove_class_str.call(null,class_name_26060,c__$1);
if((class_name_26060 === new_class_name_26061)){
} else {
dommy.core.set_class_BANG_.call(null,elem,new_class_name_26061);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__26050 = cljs.core.seq.call(null,cljs.core.conj.call(null,classes,class$));
var chunk__26051 = null;
var count__26052 = (0);
var i__26053 = (0);
while(true){
if((i__26053 < count__26052)){
var c = cljs.core._nth.call(null,chunk__26051,i__26053);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__26062 = seq__26050;
var G__26063 = chunk__26051;
var G__26064 = count__26052;
var G__26065 = (i__26053 + (1));
seq__26050 = G__26062;
chunk__26051 = G__26063;
count__26052 = G__26064;
i__26053 = G__26065;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__26050);
if(temp__4657__auto__){
var seq__26050__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26050__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__26050__$1);
var G__26066 = cljs.core.chunk_rest.call(null,seq__26050__$1);
var G__26067 = c__13060__auto__;
var G__26068 = cljs.core.count.call(null,c__13060__auto__);
var G__26069 = (0);
seq__26050 = G__26066;
chunk__26051 = G__26067;
count__26052 = G__26068;
i__26053 = G__26069;
continue;
} else {
var c = cljs.core.first.call(null,seq__26050__$1);
dommy.core.remove_class_BANG_.call(null,elem,c);

var G__26070 = cljs.core.next.call(null,seq__26050__$1);
var G__26071 = null;
var G__26072 = (0);
var G__26073 = (0);
seq__26050 = G__26070;
chunk__26051 = G__26071;
count__26052 = G__26072;
i__26053 = G__26073;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq26045){
var G__26046 = cljs.core.first.call(null,seq26045);
var seq26045__$1 = cljs.core.next.call(null,seq26045);
var G__26047 = cljs.core.first.call(null,seq26045__$1);
var seq26045__$2 = cljs.core.next.call(null,seq26045__$1);
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26046,G__26047,seq26045__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var args26074 = [];
var len__13324__auto___26077 = arguments.length;
var i__13325__auto___26078 = (0);
while(true){
if((i__13325__auto___26078 < len__13324__auto___26077)){
args26074.push((arguments[i__13325__auto___26078]));

var G__26079 = (i__13325__auto___26078 + (1));
i__13325__auto___26078 = G__26079;
continue;
} else {
}
break;
}

var G__26076 = args26074.length;
switch (G__26076) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26074.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str.call(null,c);
var temp__4655__auto___26081 = elem.classList;
if(cljs.core.truth_(temp__4655__auto___26081)){
var class_list_26082 = temp__4655__auto___26081;
class_list_26082.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.call(null,elem,c__$1,!(dommy.core.has_class_QMARK_.call(null,elem,c__$1)));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.call(null,elem,class$);
} else {
dommy.core.remove_class_BANG_.call(null,elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var args26083 = [];
var len__13324__auto___26086 = arguments.length;
var i__13325__auto___26087 = (0);
while(true){
if((i__13325__auto___26087 < len__13324__auto___26086)){
args26083.push((arguments[i__13325__auto___26087]));

var G__26088 = (i__13325__auto___26087 + (1));
i__13325__auto___26087 = G__26088;
continue;
} else {
}
break;
}

var G__26085 = args26083.length;
switch (G__26085) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26083.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.call(null,elem,new cljs.core.Keyword(null,"display","display",242065432),((show_QMARK_)?"":"none"));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.call(null,elem,dommy.core.hidden_QMARK_.call(null,elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.call(null,elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect.call(null,elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var args26090 = [];
var len__13324__auto___26093 = arguments.length;
var i__13325__auto___26094 = (0);
while(true){
if((i__13325__auto___26094 < len__13324__auto___26093)){
args26090.push((arguments[i__13325__auto___26094]));

var G__26095 = (i__13325__auto___26094 + (1));
i__13325__auto___26094 = G__26095;
continue;
} else {
}
break;
}

var G__26092 = args26090.length;
switch (G__26092) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26090.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str.call(null,tag_ns),dommy.utils.as_str.call(null,tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_.call(null,elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var args26097 = [];
var len__13324__auto___26108 = arguments.length;
var i__13325__auto___26109 = (0);
while(true){
if((i__13325__auto___26109 < len__13324__auto___26108)){
args26097.push((arguments[i__13325__auto___26109]));

var G__26110 = (i__13325__auto___26109 + (1));
i__13325__auto___26109 = G__26110;
continue;
} else {
}
break;
}

var G__26102 = args26097.length;
switch (G__26102) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args26097.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13343__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__26103 = parent;
G__26103.appendChild(child);

return G__26103;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__26104_26112 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__26105_26113 = null;
var count__26106_26114 = (0);
var i__26107_26115 = (0);
while(true){
if((i__26107_26115 < count__26106_26114)){
var c_26116 = cljs.core._nth.call(null,chunk__26105_26113,i__26107_26115);
dommy.core.append_BANG_.call(null,parent,c_26116);

var G__26117 = seq__26104_26112;
var G__26118 = chunk__26105_26113;
var G__26119 = count__26106_26114;
var G__26120 = (i__26107_26115 + (1));
seq__26104_26112 = G__26117;
chunk__26105_26113 = G__26118;
count__26106_26114 = G__26119;
i__26107_26115 = G__26120;
continue;
} else {
var temp__4657__auto___26121 = cljs.core.seq.call(null,seq__26104_26112);
if(temp__4657__auto___26121){
var seq__26104_26122__$1 = temp__4657__auto___26121;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26104_26122__$1)){
var c__13060__auto___26123 = cljs.core.chunk_first.call(null,seq__26104_26122__$1);
var G__26124 = cljs.core.chunk_rest.call(null,seq__26104_26122__$1);
var G__26125 = c__13060__auto___26123;
var G__26126 = cljs.core.count.call(null,c__13060__auto___26123);
var G__26127 = (0);
seq__26104_26112 = G__26124;
chunk__26105_26113 = G__26125;
count__26106_26114 = G__26126;
i__26107_26115 = G__26127;
continue;
} else {
var c_26128 = cljs.core.first.call(null,seq__26104_26122__$1);
dommy.core.append_BANG_.call(null,parent,c_26128);

var G__26129 = cljs.core.next.call(null,seq__26104_26122__$1);
var G__26130 = null;
var G__26131 = (0);
var G__26132 = (0);
seq__26104_26112 = G__26129;
chunk__26105_26113 = G__26130;
count__26106_26114 = G__26131;
i__26107_26115 = G__26132;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq26098){
var G__26099 = cljs.core.first.call(null,seq26098);
var seq26098__$1 = cljs.core.next.call(null,seq26098);
var G__26100 = cljs.core.first.call(null,seq26098__$1);
var seq26098__$2 = cljs.core.next.call(null,seq26098__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26099,G__26100,seq26098__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var args26133 = [];
var len__13324__auto___26144 = arguments.length;
var i__13325__auto___26145 = (0);
while(true){
if((i__13325__auto___26145 < len__13324__auto___26144)){
args26133.push((arguments[i__13325__auto___26145]));

var G__26146 = (i__13325__auto___26145 + (1));
i__13325__auto___26145 = G__26146;
continue;
} else {
}
break;
}

var G__26138 = args26133.length;
switch (G__26138) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__13343__auto__ = (new cljs.core.IndexedSeq(args26133.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13343__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__26139 = parent;
G__26139.insertBefore(child,parent.firstChild);

return G__26139;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__26140_26148 = cljs.core.seq.call(null,cljs.core.cons.call(null,child,more_children));
var chunk__26141_26149 = null;
var count__26142_26150 = (0);
var i__26143_26151 = (0);
while(true){
if((i__26143_26151 < count__26142_26150)){
var c_26152 = cljs.core._nth.call(null,chunk__26141_26149,i__26143_26151);
dommy.core.prepend_BANG_.call(null,parent,c_26152);

var G__26153 = seq__26140_26148;
var G__26154 = chunk__26141_26149;
var G__26155 = count__26142_26150;
var G__26156 = (i__26143_26151 + (1));
seq__26140_26148 = G__26153;
chunk__26141_26149 = G__26154;
count__26142_26150 = G__26155;
i__26143_26151 = G__26156;
continue;
} else {
var temp__4657__auto___26157 = cljs.core.seq.call(null,seq__26140_26148);
if(temp__4657__auto___26157){
var seq__26140_26158__$1 = temp__4657__auto___26157;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26140_26158__$1)){
var c__13060__auto___26159 = cljs.core.chunk_first.call(null,seq__26140_26158__$1);
var G__26160 = cljs.core.chunk_rest.call(null,seq__26140_26158__$1);
var G__26161 = c__13060__auto___26159;
var G__26162 = cljs.core.count.call(null,c__13060__auto___26159);
var G__26163 = (0);
seq__26140_26148 = G__26160;
chunk__26141_26149 = G__26161;
count__26142_26150 = G__26162;
i__26143_26151 = G__26163;
continue;
} else {
var c_26164 = cljs.core.first.call(null,seq__26140_26158__$1);
dommy.core.prepend_BANG_.call(null,parent,c_26164);

var G__26165 = cljs.core.next.call(null,seq__26140_26158__$1);
var G__26166 = null;
var G__26167 = (0);
var G__26168 = (0);
seq__26140_26148 = G__26165;
chunk__26141_26149 = G__26166;
count__26142_26150 = G__26167;
i__26143_26151 = G__26168;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq26134){
var G__26135 = cljs.core.first.call(null,seq26134);
var seq26134__$1 = cljs.core.next.call(null,seq26134);
var G__26136 = cljs.core.first.call(null,seq26134__$1);
var seq26134__$2 = cljs.core.next.call(null,seq26134__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26135,G__26136,seq26134__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent.call(null,other);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__4655__auto___26169 = other.nextSibling;
if(cljs.core.truth_(temp__4655__auto___26169)){
var next_26170 = temp__4655__auto___26169;
dommy.core.insert_before_BANG_.call(null,elem,next_26170);
} else {
dommy.core.append_BANG_.call(null,dommy.core.parent.call(null,other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.call(null,dommy.core.clear_BANG_.call(null,p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var args26171 = [];
var len__13324__auto___26175 = arguments.length;
var i__13325__auto___26176 = (0);
while(true){
if((i__13325__auto___26176 < len__13324__auto___26175)){
args26171.push((arguments[i__13325__auto___26176]));

var G__26177 = (i__13325__auto___26176 + (1));
i__13325__auto___26176 = G__26177;
continue;
} else {
}
break;
}

var G__26173 = args26171.length;
switch (G__26173) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args26171.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent.call(null,elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

return dommy.core.remove_BANG_.call(null,p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__26174 = p;
G__26174.removeChild(elem);

return G__26174;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__26179){
var vec__26180 = p__26179;
var special_mouse_event = cljs.core.nth.call(null,vec__26180,(0),null);
var real_mouse_event = cljs.core.nth.call(null,vec__26180,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__26180,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__26180,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__12249__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__12237__auto__ = related_target;
if(cljs.core.truth_(and__12237__auto__)){
return dommy.core.descendant_QMARK_.call(null,related_target,listener_target);
} else {
return and__12237__auto__;
}
})())){
return null;
} else {
return f.call(null,event);
}
});
;})(vec__26180,special_mouse_event,real_mouse_event))
});})(vec__26180,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"mouseenter","mouseenter",-1792413560),new cljs.core.Keyword(null,"mouseover","mouseover",-484272303),new cljs.core.Keyword(null,"mouseleave","mouseleave",531566580),new cljs.core.Keyword(null,"mouseout","mouseout",2049446890)], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.call(null,elem,event.target,selector);
if(cljs.core.truth_((function (){var and__12237__auto__ = selected_target;
if(cljs.core.truth_(and__12237__auto__)){
return cljs.core.not.call(null,dommy.core.attr.call(null,selected_target,new cljs.core.Keyword(null,"disabled","disabled",-1529784218)));
} else {
return and__12237__auto__;
}
})())){
event.selectedTarget = selected_target;

return f.call(null,event);
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__12249__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___26186 = arguments.length;
var i__13325__auto___26187 = (0);
while(true){
if((i__13325__auto___26187 < len__13324__auto___26186)){
args__13331__auto__.push((arguments[i__13325__auto___26187]));

var G__26188 = (i__13325__auto___26187 + (1));
i__13325__auto___26187 = G__26188;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((2) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13332__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.call(null,f,dommy.core.event_listeners.call(null,elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq26183){
var G__26184 = cljs.core.first.call(null,seq26183);
var seq26183__$1 = cljs.core.next.call(null,seq26183);
var G__26185 = cljs.core.first.call(null,seq26183__$1);
var seq26183__$2 = cljs.core.next.call(null,seq26183__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26184,G__26185,seq26183__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_.call(null,elem_sel)){
return cljs.core.juxt.call(null,cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___26228 = arguments.length;
var i__13325__auto___26229 = (0);
while(true){
if((i__13325__auto___26229 < len__13324__auto___26228)){
args__13331__auto__.push((arguments[i__13325__auto___26229]));

var G__26230 = (i__13325__auto___26229 + (1));
i__13325__auto___26229 = G__26230;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__26191_26231 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_26232 = cljs.core.nth.call(null,vec__26191_26231,(0),null);
var selector_26233 = cljs.core.nth.call(null,vec__26191_26231,(1),null);
var seq__26194_26234 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__26201_26235 = null;
var count__26202_26236 = (0);
var i__26203_26237 = (0);
while(true){
if((i__26203_26237 < count__26202_26236)){
var vec__26210_26238 = cljs.core._nth.call(null,chunk__26201_26235,i__26203_26237);
var orig_type_26239 = cljs.core.nth.call(null,vec__26210_26238,(0),null);
var f_26240 = cljs.core.nth.call(null,vec__26210_26238,(1),null);
var seq__26204_26241 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_26239,cljs.core.PersistentArrayMap.fromArray([orig_type_26239,cljs.core.identity], true, false)));
var chunk__26206_26242 = null;
var count__26207_26243 = (0);
var i__26208_26244 = (0);
while(true){
if((i__26208_26244 < count__26207_26243)){
var vec__26213_26245 = cljs.core._nth.call(null,chunk__26206_26242,i__26208_26244);
var actual_type_26246 = cljs.core.nth.call(null,vec__26213_26245,(0),null);
var factory_26247 = cljs.core.nth.call(null,vec__26213_26245,(1),null);
var canonical_f_26248 = (cljs.core.truth_(selector_26233)?cljs.core.partial.call(null,dommy.core.live_listener,elem_26232,selector_26233):cljs.core.identity).call(null,factory_26247.call(null,f_26240));
dommy.core.update_event_listeners_BANG_.call(null,elem_26232,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26233,actual_type_26246,f_26240], null),canonical_f_26248);

if(cljs.core.truth_(elem_26232.addEventListener)){
elem_26232.addEventListener(cljs.core.name.call(null,actual_type_26246),canonical_f_26248);
} else {
elem_26232.attachEvent(cljs.core.name.call(null,actual_type_26246),canonical_f_26248);
}

var G__26249 = seq__26204_26241;
var G__26250 = chunk__26206_26242;
var G__26251 = count__26207_26243;
var G__26252 = (i__26208_26244 + (1));
seq__26204_26241 = G__26249;
chunk__26206_26242 = G__26250;
count__26207_26243 = G__26251;
i__26208_26244 = G__26252;
continue;
} else {
var temp__4657__auto___26253 = cljs.core.seq.call(null,seq__26204_26241);
if(temp__4657__auto___26253){
var seq__26204_26254__$1 = temp__4657__auto___26253;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26204_26254__$1)){
var c__13060__auto___26255 = cljs.core.chunk_first.call(null,seq__26204_26254__$1);
var G__26256 = cljs.core.chunk_rest.call(null,seq__26204_26254__$1);
var G__26257 = c__13060__auto___26255;
var G__26258 = cljs.core.count.call(null,c__13060__auto___26255);
var G__26259 = (0);
seq__26204_26241 = G__26256;
chunk__26206_26242 = G__26257;
count__26207_26243 = G__26258;
i__26208_26244 = G__26259;
continue;
} else {
var vec__26216_26260 = cljs.core.first.call(null,seq__26204_26254__$1);
var actual_type_26261 = cljs.core.nth.call(null,vec__26216_26260,(0),null);
var factory_26262 = cljs.core.nth.call(null,vec__26216_26260,(1),null);
var canonical_f_26263 = (cljs.core.truth_(selector_26233)?cljs.core.partial.call(null,dommy.core.live_listener,elem_26232,selector_26233):cljs.core.identity).call(null,factory_26262.call(null,f_26240));
dommy.core.update_event_listeners_BANG_.call(null,elem_26232,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26233,actual_type_26261,f_26240], null),canonical_f_26263);

if(cljs.core.truth_(elem_26232.addEventListener)){
elem_26232.addEventListener(cljs.core.name.call(null,actual_type_26261),canonical_f_26263);
} else {
elem_26232.attachEvent(cljs.core.name.call(null,actual_type_26261),canonical_f_26263);
}

var G__26264 = cljs.core.next.call(null,seq__26204_26254__$1);
var G__26265 = null;
var G__26266 = (0);
var G__26267 = (0);
seq__26204_26241 = G__26264;
chunk__26206_26242 = G__26265;
count__26207_26243 = G__26266;
i__26208_26244 = G__26267;
continue;
}
} else {
}
}
break;
}

var G__26268 = seq__26194_26234;
var G__26269 = chunk__26201_26235;
var G__26270 = count__26202_26236;
var G__26271 = (i__26203_26237 + (1));
seq__26194_26234 = G__26268;
chunk__26201_26235 = G__26269;
count__26202_26236 = G__26270;
i__26203_26237 = G__26271;
continue;
} else {
var temp__4657__auto___26272 = cljs.core.seq.call(null,seq__26194_26234);
if(temp__4657__auto___26272){
var seq__26194_26273__$1 = temp__4657__auto___26272;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26194_26273__$1)){
var c__13060__auto___26274 = cljs.core.chunk_first.call(null,seq__26194_26273__$1);
var G__26275 = cljs.core.chunk_rest.call(null,seq__26194_26273__$1);
var G__26276 = c__13060__auto___26274;
var G__26277 = cljs.core.count.call(null,c__13060__auto___26274);
var G__26278 = (0);
seq__26194_26234 = G__26275;
chunk__26201_26235 = G__26276;
count__26202_26236 = G__26277;
i__26203_26237 = G__26278;
continue;
} else {
var vec__26219_26279 = cljs.core.first.call(null,seq__26194_26273__$1);
var orig_type_26280 = cljs.core.nth.call(null,vec__26219_26279,(0),null);
var f_26281 = cljs.core.nth.call(null,vec__26219_26279,(1),null);
var seq__26195_26282 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_26280,cljs.core.PersistentArrayMap.fromArray([orig_type_26280,cljs.core.identity], true, false)));
var chunk__26197_26283 = null;
var count__26198_26284 = (0);
var i__26199_26285 = (0);
while(true){
if((i__26199_26285 < count__26198_26284)){
var vec__26222_26286 = cljs.core._nth.call(null,chunk__26197_26283,i__26199_26285);
var actual_type_26287 = cljs.core.nth.call(null,vec__26222_26286,(0),null);
var factory_26288 = cljs.core.nth.call(null,vec__26222_26286,(1),null);
var canonical_f_26289 = (cljs.core.truth_(selector_26233)?cljs.core.partial.call(null,dommy.core.live_listener,elem_26232,selector_26233):cljs.core.identity).call(null,factory_26288.call(null,f_26281));
dommy.core.update_event_listeners_BANG_.call(null,elem_26232,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26233,actual_type_26287,f_26281], null),canonical_f_26289);

if(cljs.core.truth_(elem_26232.addEventListener)){
elem_26232.addEventListener(cljs.core.name.call(null,actual_type_26287),canonical_f_26289);
} else {
elem_26232.attachEvent(cljs.core.name.call(null,actual_type_26287),canonical_f_26289);
}

var G__26290 = seq__26195_26282;
var G__26291 = chunk__26197_26283;
var G__26292 = count__26198_26284;
var G__26293 = (i__26199_26285 + (1));
seq__26195_26282 = G__26290;
chunk__26197_26283 = G__26291;
count__26198_26284 = G__26292;
i__26199_26285 = G__26293;
continue;
} else {
var temp__4657__auto___26294__$1 = cljs.core.seq.call(null,seq__26195_26282);
if(temp__4657__auto___26294__$1){
var seq__26195_26295__$1 = temp__4657__auto___26294__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26195_26295__$1)){
var c__13060__auto___26296 = cljs.core.chunk_first.call(null,seq__26195_26295__$1);
var G__26297 = cljs.core.chunk_rest.call(null,seq__26195_26295__$1);
var G__26298 = c__13060__auto___26296;
var G__26299 = cljs.core.count.call(null,c__13060__auto___26296);
var G__26300 = (0);
seq__26195_26282 = G__26297;
chunk__26197_26283 = G__26298;
count__26198_26284 = G__26299;
i__26199_26285 = G__26300;
continue;
} else {
var vec__26225_26301 = cljs.core.first.call(null,seq__26195_26295__$1);
var actual_type_26302 = cljs.core.nth.call(null,vec__26225_26301,(0),null);
var factory_26303 = cljs.core.nth.call(null,vec__26225_26301,(1),null);
var canonical_f_26304 = (cljs.core.truth_(selector_26233)?cljs.core.partial.call(null,dommy.core.live_listener,elem_26232,selector_26233):cljs.core.identity).call(null,factory_26303.call(null,f_26281));
dommy.core.update_event_listeners_BANG_.call(null,elem_26232,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26233,actual_type_26302,f_26281], null),canonical_f_26304);

if(cljs.core.truth_(elem_26232.addEventListener)){
elem_26232.addEventListener(cljs.core.name.call(null,actual_type_26302),canonical_f_26304);
} else {
elem_26232.attachEvent(cljs.core.name.call(null,actual_type_26302),canonical_f_26304);
}

var G__26305 = cljs.core.next.call(null,seq__26195_26295__$1);
var G__26306 = null;
var G__26307 = (0);
var G__26308 = (0);
seq__26195_26282 = G__26305;
chunk__26197_26283 = G__26306;
count__26198_26284 = G__26307;
i__26199_26285 = G__26308;
continue;
}
} else {
}
}
break;
}

var G__26309 = cljs.core.next.call(null,seq__26194_26273__$1);
var G__26310 = null;
var G__26311 = (0);
var G__26312 = (0);
seq__26194_26234 = G__26309;
chunk__26201_26235 = G__26310;
count__26202_26236 = G__26311;
i__26203_26237 = G__26312;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq26189){
var G__26190 = cljs.core.first.call(null,seq26189);
var seq26189__$1 = cljs.core.next.call(null,seq26189);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26190,seq26189__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___26352 = arguments.length;
var i__13325__auto___26353 = (0);
while(true){
if((i__13325__auto___26353 < len__13324__auto___26352)){
args__13331__auto__.push((arguments[i__13325__auto___26353]));

var G__26354 = (i__13325__auto___26353 + (1));
i__13325__auto___26353 = G__26354;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__26315_26355 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_26356 = cljs.core.nth.call(null,vec__26315_26355,(0),null);
var selector_26357 = cljs.core.nth.call(null,vec__26315_26355,(1),null);
var seq__26318_26358 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__26325_26359 = null;
var count__26326_26360 = (0);
var i__26327_26361 = (0);
while(true){
if((i__26327_26361 < count__26326_26360)){
var vec__26334_26362 = cljs.core._nth.call(null,chunk__26325_26359,i__26327_26361);
var orig_type_26363 = cljs.core.nth.call(null,vec__26334_26362,(0),null);
var f_26364 = cljs.core.nth.call(null,vec__26334_26362,(1),null);
var seq__26328_26365 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_26363,cljs.core.PersistentArrayMap.fromArray([orig_type_26363,cljs.core.identity], true, false)));
var chunk__26330_26366 = null;
var count__26331_26367 = (0);
var i__26332_26368 = (0);
while(true){
if((i__26332_26368 < count__26331_26367)){
var vec__26337_26369 = cljs.core._nth.call(null,chunk__26330_26366,i__26332_26368);
var actual_type_26370 = cljs.core.nth.call(null,vec__26337_26369,(0),null);
var __26371 = cljs.core.nth.call(null,vec__26337_26369,(1),null);
var keys_26372 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26357,actual_type_26370,f_26364], null);
var canonical_f_26373 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_26356),keys_26372);
dommy.core.update_event_listeners_BANG_.call(null,elem_26356,dommy.utils.dissoc_in,keys_26372);

if(cljs.core.truth_(elem_26356.removeEventListener)){
elem_26356.removeEventListener(cljs.core.name.call(null,actual_type_26370),canonical_f_26373);
} else {
elem_26356.detachEvent(cljs.core.name.call(null,actual_type_26370),canonical_f_26373);
}

var G__26374 = seq__26328_26365;
var G__26375 = chunk__26330_26366;
var G__26376 = count__26331_26367;
var G__26377 = (i__26332_26368 + (1));
seq__26328_26365 = G__26374;
chunk__26330_26366 = G__26375;
count__26331_26367 = G__26376;
i__26332_26368 = G__26377;
continue;
} else {
var temp__4657__auto___26378 = cljs.core.seq.call(null,seq__26328_26365);
if(temp__4657__auto___26378){
var seq__26328_26379__$1 = temp__4657__auto___26378;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26328_26379__$1)){
var c__13060__auto___26380 = cljs.core.chunk_first.call(null,seq__26328_26379__$1);
var G__26381 = cljs.core.chunk_rest.call(null,seq__26328_26379__$1);
var G__26382 = c__13060__auto___26380;
var G__26383 = cljs.core.count.call(null,c__13060__auto___26380);
var G__26384 = (0);
seq__26328_26365 = G__26381;
chunk__26330_26366 = G__26382;
count__26331_26367 = G__26383;
i__26332_26368 = G__26384;
continue;
} else {
var vec__26340_26385 = cljs.core.first.call(null,seq__26328_26379__$1);
var actual_type_26386 = cljs.core.nth.call(null,vec__26340_26385,(0),null);
var __26387 = cljs.core.nth.call(null,vec__26340_26385,(1),null);
var keys_26388 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26357,actual_type_26386,f_26364], null);
var canonical_f_26389 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_26356),keys_26388);
dommy.core.update_event_listeners_BANG_.call(null,elem_26356,dommy.utils.dissoc_in,keys_26388);

if(cljs.core.truth_(elem_26356.removeEventListener)){
elem_26356.removeEventListener(cljs.core.name.call(null,actual_type_26386),canonical_f_26389);
} else {
elem_26356.detachEvent(cljs.core.name.call(null,actual_type_26386),canonical_f_26389);
}

var G__26390 = cljs.core.next.call(null,seq__26328_26379__$1);
var G__26391 = null;
var G__26392 = (0);
var G__26393 = (0);
seq__26328_26365 = G__26390;
chunk__26330_26366 = G__26391;
count__26331_26367 = G__26392;
i__26332_26368 = G__26393;
continue;
}
} else {
}
}
break;
}

var G__26394 = seq__26318_26358;
var G__26395 = chunk__26325_26359;
var G__26396 = count__26326_26360;
var G__26397 = (i__26327_26361 + (1));
seq__26318_26358 = G__26394;
chunk__26325_26359 = G__26395;
count__26326_26360 = G__26396;
i__26327_26361 = G__26397;
continue;
} else {
var temp__4657__auto___26398 = cljs.core.seq.call(null,seq__26318_26358);
if(temp__4657__auto___26398){
var seq__26318_26399__$1 = temp__4657__auto___26398;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26318_26399__$1)){
var c__13060__auto___26400 = cljs.core.chunk_first.call(null,seq__26318_26399__$1);
var G__26401 = cljs.core.chunk_rest.call(null,seq__26318_26399__$1);
var G__26402 = c__13060__auto___26400;
var G__26403 = cljs.core.count.call(null,c__13060__auto___26400);
var G__26404 = (0);
seq__26318_26358 = G__26401;
chunk__26325_26359 = G__26402;
count__26326_26360 = G__26403;
i__26327_26361 = G__26404;
continue;
} else {
var vec__26343_26405 = cljs.core.first.call(null,seq__26318_26399__$1);
var orig_type_26406 = cljs.core.nth.call(null,vec__26343_26405,(0),null);
var f_26407 = cljs.core.nth.call(null,vec__26343_26405,(1),null);
var seq__26319_26408 = cljs.core.seq.call(null,cljs.core.get.call(null,dommy.core.special_listener_makers,orig_type_26406,cljs.core.PersistentArrayMap.fromArray([orig_type_26406,cljs.core.identity], true, false)));
var chunk__26321_26409 = null;
var count__26322_26410 = (0);
var i__26323_26411 = (0);
while(true){
if((i__26323_26411 < count__26322_26410)){
var vec__26346_26412 = cljs.core._nth.call(null,chunk__26321_26409,i__26323_26411);
var actual_type_26413 = cljs.core.nth.call(null,vec__26346_26412,(0),null);
var __26414 = cljs.core.nth.call(null,vec__26346_26412,(1),null);
var keys_26415 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26357,actual_type_26413,f_26407], null);
var canonical_f_26416 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_26356),keys_26415);
dommy.core.update_event_listeners_BANG_.call(null,elem_26356,dommy.utils.dissoc_in,keys_26415);

if(cljs.core.truth_(elem_26356.removeEventListener)){
elem_26356.removeEventListener(cljs.core.name.call(null,actual_type_26413),canonical_f_26416);
} else {
elem_26356.detachEvent(cljs.core.name.call(null,actual_type_26413),canonical_f_26416);
}

var G__26417 = seq__26319_26408;
var G__26418 = chunk__26321_26409;
var G__26419 = count__26322_26410;
var G__26420 = (i__26323_26411 + (1));
seq__26319_26408 = G__26417;
chunk__26321_26409 = G__26418;
count__26322_26410 = G__26419;
i__26323_26411 = G__26420;
continue;
} else {
var temp__4657__auto___26421__$1 = cljs.core.seq.call(null,seq__26319_26408);
if(temp__4657__auto___26421__$1){
var seq__26319_26422__$1 = temp__4657__auto___26421__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26319_26422__$1)){
var c__13060__auto___26423 = cljs.core.chunk_first.call(null,seq__26319_26422__$1);
var G__26424 = cljs.core.chunk_rest.call(null,seq__26319_26422__$1);
var G__26425 = c__13060__auto___26423;
var G__26426 = cljs.core.count.call(null,c__13060__auto___26423);
var G__26427 = (0);
seq__26319_26408 = G__26424;
chunk__26321_26409 = G__26425;
count__26322_26410 = G__26426;
i__26323_26411 = G__26427;
continue;
} else {
var vec__26349_26428 = cljs.core.first.call(null,seq__26319_26422__$1);
var actual_type_26429 = cljs.core.nth.call(null,vec__26349_26428,(0),null);
var __26430 = cljs.core.nth.call(null,vec__26349_26428,(1),null);
var keys_26431 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_26357,actual_type_26429,f_26407], null);
var canonical_f_26432 = cljs.core.get_in.call(null,dommy.core.event_listeners.call(null,elem_26356),keys_26431);
dommy.core.update_event_listeners_BANG_.call(null,elem_26356,dommy.utils.dissoc_in,keys_26431);

if(cljs.core.truth_(elem_26356.removeEventListener)){
elem_26356.removeEventListener(cljs.core.name.call(null,actual_type_26429),canonical_f_26432);
} else {
elem_26356.detachEvent(cljs.core.name.call(null,actual_type_26429),canonical_f_26432);
}

var G__26433 = cljs.core.next.call(null,seq__26319_26422__$1);
var G__26434 = null;
var G__26435 = (0);
var G__26436 = (0);
seq__26319_26408 = G__26433;
chunk__26321_26409 = G__26434;
count__26322_26410 = G__26435;
i__26323_26411 = G__26436;
continue;
}
} else {
}
}
break;
}

var G__26437 = cljs.core.next.call(null,seq__26318_26399__$1);
var G__26438 = null;
var G__26439 = (0);
var G__26440 = (0);
seq__26318_26358 = G__26437;
chunk__26325_26359 = G__26438;
count__26326_26360 = G__26439;
i__26327_26361 = G__26440;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq26313){
var G__26314 = cljs.core.first.call(null,seq26313);
var seq26313__$1 = cljs.core.next.call(null,seq26313);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26314,seq26313__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___26456 = arguments.length;
var i__13325__auto___26457 = (0);
while(true){
if((i__13325__auto___26457 < len__13324__auto___26456)){
args__13331__auto__.push((arguments[i__13325__auto___26457]));

var G__26458 = (i__13325__auto___26457 + (1));
i__13325__auto___26457 = G__26458;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__26443_26459 = dommy.core.elem_and_selector.call(null,elem_sel);
var elem_26460 = cljs.core.nth.call(null,vec__26443_26459,(0),null);
var selector_26461 = cljs.core.nth.call(null,vec__26443_26459,(1),null);
var seq__26446_26462 = cljs.core.seq.call(null,cljs.core.partition.call(null,(2),type_fs));
var chunk__26447_26463 = null;
var count__26448_26464 = (0);
var i__26449_26465 = (0);
while(true){
if((i__26449_26465 < count__26448_26464)){
var vec__26450_26466 = cljs.core._nth.call(null,chunk__26447_26463,i__26449_26465);
var type_26467 = cljs.core.nth.call(null,vec__26450_26466,(0),null);
var f_26468 = cljs.core.nth.call(null,vec__26450_26466,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_26467,((function (seq__26446_26462,chunk__26447_26463,count__26448_26464,i__26449_26465,vec__26450_26466,type_26467,f_26468,vec__26443_26459,elem_26460,selector_26461){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_26467,dommy$core$this_fn);

return f_26468.call(null,e);
});})(seq__26446_26462,chunk__26447_26463,count__26448_26464,i__26449_26465,vec__26450_26466,type_26467,f_26468,vec__26443_26459,elem_26460,selector_26461))
);

var G__26469 = seq__26446_26462;
var G__26470 = chunk__26447_26463;
var G__26471 = count__26448_26464;
var G__26472 = (i__26449_26465 + (1));
seq__26446_26462 = G__26469;
chunk__26447_26463 = G__26470;
count__26448_26464 = G__26471;
i__26449_26465 = G__26472;
continue;
} else {
var temp__4657__auto___26473 = cljs.core.seq.call(null,seq__26446_26462);
if(temp__4657__auto___26473){
var seq__26446_26474__$1 = temp__4657__auto___26473;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__26446_26474__$1)){
var c__13060__auto___26475 = cljs.core.chunk_first.call(null,seq__26446_26474__$1);
var G__26476 = cljs.core.chunk_rest.call(null,seq__26446_26474__$1);
var G__26477 = c__13060__auto___26475;
var G__26478 = cljs.core.count.call(null,c__13060__auto___26475);
var G__26479 = (0);
seq__26446_26462 = G__26476;
chunk__26447_26463 = G__26477;
count__26448_26464 = G__26478;
i__26449_26465 = G__26479;
continue;
} else {
var vec__26453_26480 = cljs.core.first.call(null,seq__26446_26474__$1);
var type_26481 = cljs.core.nth.call(null,vec__26453_26480,(0),null);
var f_26482 = cljs.core.nth.call(null,vec__26453_26480,(1),null);
dommy.core.listen_BANG_.call(null,elem_sel,type_26481,((function (seq__26446_26462,chunk__26447_26463,count__26448_26464,i__26449_26465,vec__26453_26480,type_26481,f_26482,seq__26446_26474__$1,temp__4657__auto___26473,vec__26443_26459,elem_26460,selector_26461){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.call(null,elem_sel,type_26481,dommy$core$this_fn);

return f_26482.call(null,e);
});})(seq__26446_26462,chunk__26447_26463,count__26448_26464,i__26449_26465,vec__26453_26480,type_26481,f_26482,seq__26446_26474__$1,temp__4657__auto___26473,vec__26443_26459,elem_26460,selector_26461))
);

var G__26483 = cljs.core.next.call(null,seq__26446_26474__$1);
var G__26484 = null;
var G__26485 = (0);
var G__26486 = (0);
seq__26446_26462 = G__26483;
chunk__26447_26463 = G__26484;
count__26448_26464 = G__26485;
i__26449_26465 = G__26486;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq26441){
var G__26442 = cljs.core.first.call(null,seq26441);
var seq26441__$1 = cljs.core.next.call(null,seq26441);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26442,seq26441__$1);
});


//# sourceMappingURL=core.js.map?rel=1473935458220