// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.components.navbar.nav');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('reagent.core');
goog.require('bluegenes.components.search.typeahead');
goog.require('oops.core');
goog.require('bluegenes.components.progress_bar');
goog.require('bluegenes.route');
/**
 * returns the icon set for a specific mine, or a default.
 * Pass it the entire set of mine details, e.g.
 * (subscribe [:current-mine]).
 */
bluegenes.components.navbar.nav.mine_icon = (function bluegenes$components$navbar$nav$mine_icon(mine){
var icon = new cljs.core.Keyword(null,"icon","icon",1679606541).cljs$core$IFn$_invoke$arity$1(mine);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.logo","svg.icon.logo",954113542),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),icon], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(icon)].join('')], null)], null)], null);
});
bluegenes.components.navbar.nav.update_form = (function bluegenes$components$navbar$nav$update_form(atom,key,evt){
return cljs.core.swap_BANG_.call(null,atom,cljs.core.assoc,key,(function (){var target_obj_23674 = evt;
var _STAR_runtime_state_STAR__orig_val__23677 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23678 = oops.state.prepare_state.call(null,target_obj_23674,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23678;

try{var next_obj_23675 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23674,(0),"target",true))?(target_obj_23674["target"]):null);
var next_obj_23676 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23675,(0),"value",true))?(next_obj_23675["value"]):null);
return next_obj_23676;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23677;
}})());
});
/**
 * Note the iframe hack we've included below to ensure the user actually
 *   reaches the registration page, rather than the homepage :(
 *   I'm sure in the future we'll remove this when we have auth set up fully.
 *   The dangerouslysetInnerHTML comment is intentional as a hidden iframe looks
 *   mega spooky to anyone inspecting source. Please don't remove the comment unless it's because we've got better auth working!!
 */
bluegenes.components.navbar.nav.register_for_mine = (function bluegenes$components$navbar$nav$register_for_mine(current_mine){
var link = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cljs.core.deref.call(null,current_mine),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"root","root",-448657453)], null))),"/createAccount.do"].join('');
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.register","div.register",-301785170),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.sneaky-iframe-fix-see-comment","div.sneaky-iframe-fix-see-comment",-254772667),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dangerouslySetInnerHTML","dangerouslySetInnerHTML",-554971138),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"__html","__html",674048345),"<!-- InterMine automatically redirects to the homepage unless you have a session (sigh) - but we want the user to go to the registration page. So we're loading the page in an iframe the user can't see, to bootstrap the session :/ -->"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"iframe.forceregistrationscreen","iframe.forceregistrationscreen",-45032777),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",-1651076051),link,new cljs.core.Keyword(null,"height","height",1025178622),"0px",new cljs.core.Keyword(null,"width","width",-384071477),"0px"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),link], null),"Register"], null)], null);
});
bluegenes.components.navbar.nav.login_form = (function bluegenes$components$navbar$nav$login_form(){
var credentials = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),null,new cljs.core.Keyword(null,"password","password",417022471),null], null));
var current_mine = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
var auth_values = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.subs.auth","auth","bluegenes.subs.auth/auth",75054891)], null));
return ((function (credentials,current_mine,auth_values){
return (function (){
var map__23679 = cljs.core.deref.call(null,auth_values);
var map__23679__$1 = (((((!((map__23679 == null))))?(((((map__23679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23679.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23679):map__23679);
var error_QMARK_ = cljs.core.get.call(null,map__23679__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var thinking_QMARK_ = cljs.core.get.call(null,map__23679__$1,new cljs.core.Keyword(null,"thinking?","thinking?",731614708));
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form.login-form","form.login-form",864488891),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Log in to ",new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group","div.form-group",-1721134770),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Email Address"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.form-control","input.form-control",-1123419636),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"text",new cljs.core.Keyword(null,"id","id",-1388402092),"email",new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"username","username",1605666410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,credentials)),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,bluegenes.components.navbar.nav.update_form,credentials,new cljs.core.Keyword(null,"username","username",1605666410))], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group","div.form-group",-1721134770),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Password"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.form-control","input.form-control",-1123419636),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"password",new cljs.core.Keyword(null,"id","id",-1388402092),"password",new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"password","password",417022471).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,credentials)),new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,bluegenes.components.navbar.nav.update_form,credentials,new cljs.core.Keyword(null,"password","password",417022471)),new cljs.core.Keyword(null,"on-key-up","on-key-up",884441808),((function (map__23679,map__23679__$1,error_QMARK_,thinking_QMARK_,credentials,current_mine,auth_values){
return (function (k){
if(cljs.core._EQ_.call(null,(13),(function (){var target_obj_23681 = k;
var _STAR_runtime_state_STAR__orig_val__23683 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23684 = oops.state.prepare_state.call(null,target_obj_23681,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23684;

try{var next_obj_23682 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23681,(0),"keyCode",true))?(target_obj_23681["keyCode"]):null);
return next_obj_23682;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23683;
}})())){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","login","bluegenes.events.auth/login",78941178),cljs.core.assoc.call(null,cljs.core.deref.call(null,credentials),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"service","service",-1963054559).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine)),new cljs.core.Keyword(null,"mine-id","mine-id",-1735167747),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine)))], null));
} else {
return null;
}
});})(map__23679,map__23679__$1,error_QMARK_,thinking_QMARK_,credentials,current_mine,auth_values))
], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.register-or-login","div.register-or-login",-1871826019),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.register_for_mine,current_mine], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-primary.btn-raised","button.btn.btn-primary.btn-raised",1169755725),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__23679,map__23679__$1,error_QMARK_,thinking_QMARK_,credentials,current_mine,auth_values){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","login","bluegenes.events.auth/login",78941178),cljs.core.assoc.call(null,cljs.core.deref.call(null,credentials),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"service","service",-1963054559).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine)),new cljs.core.Keyword(null,"mine-id","mine-id",-1735167747),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine)))], null));
});})(map__23679,map__23679__$1,error_QMARK_,thinking_QMARK_,credentials,current_mine,auth_values))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_icon,cljs.core.deref.call(null,current_mine)], null),"Sign In"], null)], null),(cljs.core.truth_(error_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-danger.error-box","div.alert.alert-danger.error-box",1457902888),"Invalid username or password"], null):null)], null);
});
;})(credentials,current_mine,auth_values))
});
bluegenes.components.navbar.nav.mine_entry = (function bluegenes$components$navbar$nav$mine_entry(details,current_mine_QMARK_){

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(current_mine_QMARK_)?"active":null),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(details)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","home","bluegenes.route/home",165174212),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mine","mine",-130428525),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(details))], null))], null),(cljs.core.truth_(current_mine_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_icon,details], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"logo","logo",1237980263).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"images","images",1757475080).cljs$core$IFn$_invoke$arity$1(details))], null)], null)),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(details),(cljs.core.truth_(current_mine_QMARK_)?" (current)":null)], null)], null);
});
bluegenes.components.navbar.nav.mine_entry_current = (function bluegenes$components$navbar$nav$mine_entry_current(details){

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_icon,details], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"logo","logo",1237980263).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"images","images",1757475080).cljs$core$IFn$_invoke$arity$1(details))], null)], null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(details)," (current)"], null)], null);
});
bluegenes.components.navbar.nav.settings = (function bluegenes$components$navbar$nav$settings(){

var current_mine = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
return ((function (current_mine){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.dropdown.mine-settings.secondary-nav","li.dropdown.mine-settings.secondary-nav",1283860007),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.dropdown-toggle","a.dropdown-toggle",-264466802),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data-toggle","data-toggle",436966687),"dropdown",new cljs.core.Keyword(null,"role","role",-736691072),"button"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-cog","svg.icon.icon-cog",1723559883),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-cog"], null)], null)], null)], null),cljs.core.conj.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.dropdown-menu","ul.dropdown-menu",-867384656),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_entry_current,cljs.core.deref.call(null,current_mine)], null)], null),cljs.core.map.call(null,((function (current_mine){
return (function (p__23685){
var vec__23686 = p__23685;
var id = cljs.core.nth.call(null,vec__23686,(0),null);
var details = cljs.core.nth.call(null,vec__23686,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_entry,details], null);
});})(current_mine))
,cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"registry","registry",1021159018)], null))))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.special","li.special",-1068145760),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","debug","bluegenes.route/debug",-1829787509),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"panel","panel",-558637456),"main"], null))], null),">_ Developer"], null)], null))], null);
});
;})(current_mine))
});
bluegenes.components.navbar.nav.logged_in = (function bluegenes$components$navbar$nav$logged_in(){
var identity = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.subs.auth","identity","bluegenes.subs.auth/identity",-1888716358)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.logon.dropdown.success.secondary-nav","li.logon.dropdown.success.secondary-nav",-478866372),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.dropdown-toggle","a.dropdown-toggle",-264466802),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data-toggle","data-toggle",436966687),"dropdown",new cljs.core.Keyword(null,"role","role",-736691072),"button"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-cog","svg.icon.icon-cog",1723559883),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-user-circle"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.long-name","span.long-name",-1463483895),[" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"username","username",1605666410).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,identity)))].join('')], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.dropdown-menu","ul.dropdown-menu",-867384656),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (identity){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.auth","logout","bluegenes.events.auth/logout",1369412924)], null));
});})(identity))
], null),"Log Out"], null)], null)], null)], null);
});
bluegenes.components.navbar.nav.anonymous = (function bluegenes$components$navbar$nav$anonymous(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.logon.secondary-nav.dropdown.warning","li.logon.secondary-nav.dropdown.warning",1067746082),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.dropdown-toggle","a.dropdown-toggle",-264466802),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"data-toggle","data-toggle",436966687),"dropdown",new cljs.core.Keyword(null,"role","role",-736691072),"button"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-cog","svg.icon.icon-cog",1723559883),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-user-times"], null)], null)], null)," Log In"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.dropdown-menu.login-form-dropdown","div.dropdown-menu.login-form-dropdown",346979745),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.login_form], null)], null)], null);
});
bluegenes.components.navbar.nav.user = (function bluegenes$components$navbar$nav$user(){
var authed_QMARK_ = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.subs.auth","authenticated?","bluegenes.subs.auth/authenticated?",1470943614)], null));
return ((function (authed_QMARK_){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,authed_QMARK_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.logged_in,cljs.core.deref.call(null,authed_QMARK_)], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.anonymous], null);
}
});
;})(authed_QMARK_))
});
bluegenes.components.navbar.nav.active_mine_logo = (function bluegenes$components$navbar$nav$active_mine_logo(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.mine_icon,cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)))], null);
});
bluegenes.components.navbar.nav.main = (function bluegenes$components$navbar$nav$main(){
var active_panel = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"active-panel","active-panel",-1802545994)], null));
var current_mine = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
var panel_is = ((function (active_panel,current_mine){
return (function (panel_key){
return cljs.core._EQ_.call(null,cljs.core.deref.call(null,active_panel),panel_key);
});})(active_panel,current_mine))
;
return ((function (active_panel,current_mine,panel_is){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nav#bluegenes-main-nav.main-nav","nav#bluegenes-main-nav.main-nav",1373581348),new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.minename.primary-nav","li.minename.primary-nav",-1905129058),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","home","bluegenes.route/home",165174212))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.active_mine_logo], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.long-name","span.long-name",-1463483895),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine))], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.homelink.primary-nav.larger-screen-only","li.homelink.primary-nav.larger-screen-only",1354242181),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"home-panel","home-panel",1226198754)))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","home","bluegenes.route/home",165174212))], null),"Home"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.primary-nav","li.primary-nav",-465513707),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"upload-panel","upload-panel",-1690644333)))?"active":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","upload-step","bluegenes.route/upload-step",-286508008),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"step","step",1288888124),"input"], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-upload.extra-tiny-screen","svg.icon.icon-upload.extra-tiny-screen",-1799491943),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-upload"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span..long-name.larger-screen-only","span..long-name.larger-screen-only",508195396),"Upload"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.primary-nav","li.primary-nav",-465513707),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"mymine-panel","mymine-panel",1415101903)))?"active":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","mymine","bluegenes.route/mymine",-1092818401))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-cog","svg.icon.icon-cog",1723559883),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-my-data"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"My\u00A0Data"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.primary-nav","li.primary-nav",-465513707),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"templates-panel","templates-panel",-3302002)))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","templates","bluegenes.route/templates",-920380740))], null),"Templates"], null)], null),(cljs.core.truth_(new cljs.core.Keyword(null,"regionsearch-example","regionsearch-example",-1896453489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,current_mine)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"regions-panel","regions-panel",502559209)))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","regions","bluegenes.route/regions",-2010387797))], null),"Regions"], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.primary-nav","li.primary-nav",-465513707),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((panel_is.call(null,new cljs.core.Keyword(null,"querybuilder-panel","querybuilder-panel",-537796168)))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","querybuilder","bluegenes.route/querybuilder",1149547765))], null),"Query\u00A0Builder"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.secondary-nav.search","li.secondary-nav.search",-1133705209),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.search.typeahead.main], null)], null),((panel_is.call(null,new cljs.core.Keyword(null,"search-panel","search-panel",-1795519670)))?null:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.secondary-nav.search-mini","li.secondary-nav.search-mini",-1925635252),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","search","bluegenes.route/search",245199469))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-search","svg.icon.icon-search",897369953),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-search"], null)], null)], null)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.secondary-nav.larger-screen-only","li.secondary-nav.larger-screen-only",-639129679),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","help","bluegenes.route/help",412612763))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-question","svg.icon.icon-question",479981139),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-question"], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.settings], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.navbar.nav.user], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.progress_bar.main], null)], null);
});
;})(active_panel,current_mine,panel_is))
});

//# sourceMappingURL=nav.js.map
