// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.querybuilder.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('cljs.core.async');
goog.require('imcljs.query');
goog.require('imcljs.path');
goog.require('imcljs.fetch');
goog.require('clojure.set');
goog.require('cljs.reader');
goog.require('bluegenes.pages.querybuilder.logic');
goog.require('clojure.string');
bluegenes.pages.querybuilder.events.loc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"qm","qm",1837529525)], null);
bluegenes.pages.querybuilder.events.not_blank_QMARK_ = cljs.core.complement.call(null,clojure.string.blank_QMARK_);
/**
 * remove elem in coll
 */
bluegenes.pages.querybuilder.events.drop_nth = (function bluegenes$pages$querybuilder$events$drop_nth(coll,pos){
return cljs.core.vec.call(null,cljs.core.concat.call(null,cljs.core.subvec.call(null,coll,(0),pos),cljs.core.subvec.call(null,coll,(pos + (1)))));
});
bluegenes.pages.querybuilder.events.alphabet = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
/**
 * Walks down the query map and pulls all codes from constraints
 */
bluegenes.pages.querybuilder.events.used_const_code = (function bluegenes$pages$querybuilder$events$used_const_code(query){
return cljs.core.map.call(null,new cljs.core.Keyword(null,"code","code",1586293142),cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"constraints","constraints",422775616),cljs.core.tree_seq.call(null,cljs.core.map_QMARK_,cljs.core.vals,query)));
});
/**
 * Gets the next available unused constraint letter from the query map
 */
bluegenes.pages.querybuilder.events.next_available_const_code = (function bluegenes$pages$querybuilder$events$next_available_const_code(query){
var used_codes = bluegenes.pages.querybuilder.events.used_const_code.call(null,query);
return cljs.core.first.call(null,cljs.core.filter.call(null,((function (used_codes){
return (function (p1__22467_SHARP_){
return cljs.core.not.call(null,cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([p1__22467_SHARP_]),used_codes));
});})(used_codes))
,bluegenes.pages.querybuilder.events.alphabet));
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","set-query","qb/set-query",-898596101),(function (p__22468,p__22469){
var map__22470 = p__22468;
var map__22470__$1 = (((((!((map__22470 == null))))?(((((map__22470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22470):map__22470);
var db = cljs.core.get.call(null,map__22470__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22471 = p__22469;
var _ = cljs.core.nth.call(null,vec__22471,(0),null);
var query = cljs.core.nth.call(null,vec__22471,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"query-map","query-map",-808576972)], null),query),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","build-im-query","qb/build-im-query",1127023276)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","load-example","qb/load-example",-2000478110),(function (p__22475){
var map__22476 = p__22475;
var map__22476__$1 = (((((!((map__22476 == null))))?(((((map__22476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22476.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22476):map__22476);
var db = cljs.core.get.call(null,map__22476__$1,new cljs.core.Keyword(null,"db","db",993250759));
var default_query = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"default-query-example","default-query-example",1840089940)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","load-query","qb/load-query",433152121),default_query], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","store-possible-values","qb/store-possible-values",512388662),(function (db,p__22478){
var vec__22479 = p__22478;
var _ = cljs.core.nth.call(null,vec__22479,(0),null);
var view_vec = cljs.core.nth.call(null,vec__22479,(1),null);
var results = cljs.core.nth.call(null,vec__22479,(2),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,view_vec,cljs.core.assoc,new cljs.core.Keyword(null,"possible-values","possible-values",-819180652),new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(results));
}));
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("qb","pv","qb/pv",55036581),(function (p__22482){
var map__22483 = p__22482;
var map__22483__$1 = (((((!((map__22483 == null))))?(((((map__22483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22483.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22483):map__22483);
var service = cljs.core.get.call(null,map__22483__$1,new cljs.core.Keyword(null,"service","service",-1963054559));
var store_in = cljs.core.get.call(null,map__22483__$1,new cljs.core.Keyword(null,"store-in","store-in",-1979320243));
var summary_path = cljs.core.get.call(null,map__22483__$1,new cljs.core.Keyword(null,"summary-path","summary-path",-427364048));
var query = cljs.core.get.call(null,map__22483__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var sum_chan = imcljs.fetch.unique_values.call(null,service,query,summary_path,(100));
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query){
return (function (state_22492){
var state_val_22493 = (state_22492[(1)]);
if((state_val_22493 === (1))){
var inst_22485 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22492__$1 = (function (){var statearr_22494 = state_22492;
(statearr_22494[(7)] = inst_22485);

return statearr_22494;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22492__$1,(2),sum_chan);
} else {
if((state_val_22493 === (2))){
var inst_22485 = (state_22492[(7)]);
var inst_22487 = (state_22492[(2)]);
var inst_22488 = [new cljs.core.Keyword("qb","store-possible-values","qb/store-possible-values",512388662),store_in,inst_22487];
var inst_22489 = (new cljs.core.PersistentVector(null,3,(5),inst_22485,inst_22488,null));
var inst_22490 = re_frame.core.dispatch.call(null,inst_22489);
var state_22492__$1 = state_22492;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22492__$1,inst_22490);
} else {
return null;
}
}
});})(c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query))
;
return ((function (switch__2334__auto__,c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query){
return (function() {
var bluegenes$pages$querybuilder$events$state_machine__2335__auto__ = null;
var bluegenes$pages$querybuilder$events$state_machine__2335__auto____0 = (function (){
var statearr_22495 = [null,null,null,null,null,null,null,null];
(statearr_22495[(0)] = bluegenes$pages$querybuilder$events$state_machine__2335__auto__);

(statearr_22495[(1)] = (1));

return statearr_22495;
});
var bluegenes$pages$querybuilder$events$state_machine__2335__auto____1 = (function (state_22492){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_22492);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e22496){if((e22496 instanceof Object)){
var ex__2338__auto__ = e22496;
var statearr_22497_22499 = state_22492;
(statearr_22497_22499[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22492);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22496;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22500 = state_22492;
state_22492 = G__22500;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
bluegenes$pages$querybuilder$events$state_machine__2335__auto__ = function(state_22492){
switch(arguments.length){
case 0:
return bluegenes$pages$querybuilder$events$state_machine__2335__auto____0.call(this);
case 1:
return bluegenes$pages$querybuilder$events$state_machine__2335__auto____1.call(this,state_22492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bluegenes$pages$querybuilder$events$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = bluegenes$pages$querybuilder$events$state_machine__2335__auto____0;
bluegenes$pages$querybuilder$events$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = bluegenes$pages$querybuilder$events$state_machine__2335__auto____1;
return bluegenes$pages$querybuilder$events$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query))
})();
var state__2431__auto__ = (function (){var statearr_22498 = f__2430__auto__.call(null);
(statearr_22498[(6)] = c__2429__auto__);

return statearr_22498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__,sum_chan,map__22483,map__22483__$1,service,store_in,summary_path,query))
);

return c__2429__auto__;
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","fetch-possible-values","qb/fetch-possible-values",143079467),(function (p__22501,p__22502){
var map__22503 = p__22501;
var map__22503__$1 = (((((!((map__22503 == null))))?(((((map__22503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22503.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22503):map__22503);
var db = cljs.core.get.call(null,map__22503__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22504 = p__22502;
var _ = cljs.core.nth.call(null,vec__22504,(0),null);
var view_vec = cljs.core.nth.call(null,vec__22504,(1),null);
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
var summary_path = imcljs.path.adjust_path_to_last_class.call(null,new cljs.core.Keyword(null,"model","model",331153215).cljs$core$IFn$_invoke$arity$1(service),clojure.string.join.call(null,".",view_vec));
var split_summary_path = clojure.string.split.call(null,summary_path,".");
if((!(imcljs.path.class_QMARK_.call(null,new cljs.core.Keyword(null,"model","model",331153215).cljs$core$IFn$_invoke$arity$1(service),summary_path)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("qb","pv","qb/pv",55036581),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"service","service",-1963054559),service,new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),cljs.core.first.call(null,split_summary_path),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.last.call(null,split_summary_path)], null)], null),new cljs.core.Keyword(null,"summary-path","summary-path",-427364048),summary_path,new cljs.core.Keyword(null,"store-in","store-in",-1979320243),view_vec], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","store-possible-values","qb/store-possible-values",512388662),view_vec,false], null)], null);
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","add-constraint","qb/add-constraint",83040055),(function (p__22508,p__22509){
var map__22510 = p__22508;
var map__22510__$1 = (((((!((map__22510 == null))))?(((((map__22510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22510.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22510):map__22510);
var db = cljs.core.get.call(null,map__22510__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22511 = p__22509;
var _ = cljs.core.nth.call(null,vec__22511,(0),null);
var view_vec = cljs.core.nth.call(null,vec__22511,(1),null);
var code = bluegenes.pages.querybuilder.events.next_available_const_code.call(null,cljs.core.get_in.call(null,db,bluegenes.pages.querybuilder.events.loc));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,bluegenes.pages.querybuilder.events.loc,cljs.core.update_in,cljs.core.conj.call(null,view_vec,new cljs.core.Keyword(null,"constraints","constraints",422775616)),cljs.core.comp.call(null,cljs.core.vec,cljs.core.conj),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"code","code",1586293142),null,new cljs.core.Keyword(null,"op","op",-1882987955),null,new cljs.core.Keyword(null,"value","value",305978217),null], null)),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","build-im-query","qb/build-im-query",1127023276)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","remove-constraint","qb/remove-constraint",-621150670),(function (p__22515,p__22516){
var map__22517 = p__22515;
var map__22517__$1 = (((((!((map__22517 == null))))?(((((map__22517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22517):map__22517);
var db = cljs.core.get.call(null,map__22517__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22518 = p__22516;
var _ = cljs.core.nth.call(null,vec__22518,(0),null);
var path = cljs.core.nth.call(null,vec__22518,(1),null);
var idx = cljs.core.nth.call(null,vec__22518,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,bluegenes.pages.querybuilder.events.loc,cljs.core.update_in,cljs.core.conj.call(null,path,new cljs.core.Keyword(null,"constraints","constraints",422775616)),bluegenes.pages.querybuilder.events.drop_nth,idx),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","build-im-query","qb/build-im-query",1127023276)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","update-constraint","qb/update-constraint",1023897692),(function (db,p__22522){
var vec__22523 = p__22522;
var _ = cljs.core.nth.call(null,vec__22523,(0),null);
var path = cljs.core.nth.call(null,vec__22523,(1),null);
var idx = cljs.core.nth.call(null,vec__22523,(2),null);
var constraint = cljs.core.nth.call(null,vec__22523,(3),null);
var updated_constraint = (function (){var G__22526 = constraint;
var G__22526__$1 = (cljs.core.truth_((function (){var and__4120__auto__ = clojure.string.blank_QMARK_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(constraint));
if(and__4120__auto__){
return bluegenes.pages.querybuilder.events.not_blank_QMARK_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(constraint));
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__22526,new cljs.core.Keyword(null,"code","code",1586293142),bluegenes.pages.querybuilder.events.next_available_const_code.call(null,cljs.core.get_in.call(null,db,bluegenes.pages.querybuilder.events.loc))):G__22526);
if(clojure.string.blank_QMARK_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(constraint))){
return cljs.core.dissoc.call(null,G__22526__$1,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return G__22526__$1;
}
})();
return cljs.core.update_in.call(null,db,bluegenes.pages.querybuilder.events.loc,cljs.core.assoc_in,cljs.core.reduce.call(null,cljs.core.conj,path,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"constraints","constraints",422775616),idx], null)),updated_constraint);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","update-constraint-logic","qb/update-constraint-logic",295848268),(function (db,p__22527){
var vec__22528 = p__22527;
var _ = cljs.core.nth.call(null,vec__22528,(0),null);
var logic = cljs.core.nth.call(null,vec__22528,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null),["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(logic),")"].join(''));
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","format-constraint-logic","qb/format-constraint-logic",966448086),(function (p__22531,p__22532){
var map__22533 = p__22531;
var map__22533__$1 = (((((!((map__22533 == null))))?(((((map__22533.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22533.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22533):map__22533);
var db = cljs.core.get.call(null,map__22533__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22534 = p__22532;
var _ = cljs.core.nth.call(null,vec__22534,(0),null);
var enhance_query = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null));
var logic_vec = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null));
var used_codes = cljs.core.set.call(null,bluegenes.pages.querybuilder.events.used_const_code.call(null,enhance_query));
var codes_in_logic_vec = cljs.core.set.call(null,cljs.core.map.call(null,cljs.core.name,cljs.core.remove.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"and","and",668631710,null),null,new cljs.core.Symbol(null,"or","or",1876275696,null),null], null), null),cljs.core.flatten.call(null,bluegenes.pages.querybuilder.logic.read_logic_string.call(null,logic_vec)))));
var codes_to_append = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,used_codes,codes_in_logic_vec));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null),cljs.core.reduce.call(null,bluegenes.pages.querybuilder.logic.append_code,bluegenes.pages.querybuilder.logic.read_logic_string.call(null,logic_vec),cljs.core.map.call(null,cljs.core.symbol,codes_to_append))),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
bluegenes.pages.querybuilder.events.serialize_views = (function bluegenes$pages$querybuilder$events$serialize_views(p__22538,total,views){
var vec__22539 = p__22538;
var k = cljs.core.nth.call(null,vec__22539,(0),null);
var value = cljs.core.nth.call(null,vec__22539,(1),null);
var new_total = cljs.core.vec.call(null,cljs.core.conj.call(null,total,k));
var temp__5455__auto__ = cljs.core.not_empty.call(null,cljs.core.select_keys.call(null,value,cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),cljs.core.keys.call(null,value))));
if(cljs.core.truth_(temp__5455__auto__)){
var children = temp__5455__auto__;
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.mapcat.call(null,((function (children,temp__5455__auto__,new_total,vec__22539,k,value){
return (function (c){
return bluegenes.pages.querybuilder.events.serialize_views.call(null,c,new_total,views);
});})(children,temp__5455__auto__,new_total,vec__22539,k,value))
,children));
} else {
return cljs.core.conj.call(null,views,clojure.string.join.call(null,".",new_total));
}
});
bluegenes.pages.querybuilder.events.serialize_constraints = (function bluegenes$pages$querybuilder$events$serialize_constraints(p__22542,total,trail){
var vec__22543 = p__22542;
var k = cljs.core.nth.call(null,vec__22543,(0),null);
var map__22546 = cljs.core.nth.call(null,vec__22543,(1),null);
var map__22546__$1 = (((((!((map__22546 == null))))?(((((map__22546.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22546.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22546):map__22546);
var children = cljs.core.get.call(null,map__22546__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var constraints = cljs.core.get.call(null,map__22546__$1,new cljs.core.Keyword(null,"constraints","constraints",422775616));
if(cljs.core.truth_(children)){
return cljs.core.flatten.call(null,cljs.core.reduce.call(null,((function (vec__22543,k,map__22546,map__22546__$1,children,constraints){
return (function (t,n){
return cljs.core.conj.call(null,t,bluegenes.pages.querybuilder.events.serialize_constraints.call(null,n,total,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(trail),(cljs.core.truth_(trail)?".":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join('')));
});})(vec__22543,k,map__22546,map__22546__$1,children,constraints))
,total,children));
} else {
return cljs.core.conj.call(null,total,cljs.core.map.call(null,((function (vec__22543,k,map__22546,map__22546__$1,children,constraints){
return (function (n){
return cljs.core.assoc.call(null,n,new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(trail),(cljs.core.truth_(trail)?".":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''));
});})(vec__22543,k,map__22546,map__22546__$1,children,constraints))
,constraints));
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","success-count","qb/success-count",1857454491),(function (db,p__22548){
var vec__22549 = p__22548;
var _ = cljs.core.nth.call(null,vec__22549,(0),null);
var count = cljs.core.nth.call(null,vec__22549,(1),null);
return db;
}));
bluegenes.pages.querybuilder.events.extract_constraints = (function bluegenes$pages$querybuilder$events$extract_constraints(p__22552,total,views){
var vec__22553 = p__22552;
var k = cljs.core.nth.call(null,vec__22553,(0),null);
var value = cljs.core.nth.call(null,vec__22553,(1),null);
var new_total = cljs.core.conj.call(null,total,k);
var temp__5455__auto__ = cljs.core.not_empty.call(null,cljs.core.select_keys.call(null,value,cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),cljs.core.keys.call(null,value))));
if(cljs.core.truth_(temp__5455__auto__)){
var children = temp__5455__auto__;
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.mapcat.call(null,((function (children,temp__5455__auto__,new_total,vec__22553,k,value){
return (function (c){
return bluegenes.pages.querybuilder.events.extract_constraints.call(null,c,new_total,cljs.core.conj.call(null,views,cljs.core.assoc.call(null,value,new cljs.core.Keyword(null,"path","path",-188191168),new_total)));
});})(children,temp__5455__auto__,new_total,vec__22553,k,value))
,children));
} else {
return cljs.core.conj.call(null,views,cljs.core.assoc.call(null,value,new cljs.core.Keyword(null,"path","path",-188191168),new_total));
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","success-summary","qb/success-summary",-1483474159),(function (db,p__22556){
var vec__22557 = p__22556;
var _ = cljs.core.nth.call(null,vec__22557,(0),null);
var dot_path = cljs.core.nth.call(null,vec__22557,(1),null);
var summary = cljs.core.nth.call(null,vec__22557,(2),null);
var v = cljs.core.vec.call(null,cljs.core.butlast.call(null,clojure.string.split.call(null,dot_path,".")));
return cljs.core.update_in.call(null,db,bluegenes.pages.querybuilder.events.loc,cljs.core.assoc_in,cljs.core.conj.call(null,v,new cljs.core.Keyword(null,"id-count","id-count",-476311183)),summary);
}));
/**
 * Removes all keys from a map that are keywords.
 *   In our query map, keywords are reserved for special attributes such as :constraints and :visible
 */
bluegenes.pages.querybuilder.events.remove_keyword_keys = (function bluegenes$pages$querybuilder$events$remove_keyword_keys(m){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),cljs.core.first),m));
});
/**
 * Walks the query map and retrieves all im-paths that resolve to a class
 */
bluegenes.pages.querybuilder.events.class_paths = (function bluegenes$pages$querybuilder$events$class_paths(var_args){
var G__22562 = arguments.length;
switch (G__22562) {
case 2:
return bluegenes.pages.querybuilder.events.class_paths.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return bluegenes.pages.querybuilder.events.class_paths.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.pages.querybuilder.events.class_paths.cljs$core$IFn$_invoke$arity$2 = (function (model,query){
var vec__22563 = cljs.core.first.call(null,query);
var root = cljs.core.nth.call(null,vec__22563,(0),null);
var children = cljs.core.nth.call(null,vec__22563,(1),null);
return cljs.core.filter.call(null,cljs.core.partial.call(null,imcljs.path.class_QMARK_,model),cljs.core.map.call(null,((function (vec__22563,root,children){
return (function (p1__22560_SHARP_){
return clojure.string.join.call(null,".",p1__22560_SHARP_);
});})(vec__22563,root,children))
,cljs.core.distinct.call(null,bluegenes.pages.querybuilder.events.class_paths.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [root,children], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root], null),cljs.core.PersistentVector.EMPTY))));
});

bluegenes.pages.querybuilder.events.class_paths.cljs$core$IFn$_invoke$arity$4 = (function (model,p__22566,running,total){
var vec__22567 = p__22566;
var parent = cljs.core.nth.call(null,vec__22567,(0),null);
var children = cljs.core.nth.call(null,vec__22567,(1),null);
var total__$1 = cljs.core.conj.call(null,total,running);
var temp__5455__auto__ = cljs.core.not_empty.call(null,bluegenes.pages.querybuilder.events.remove_keyword_keys.call(null,children));
if(cljs.core.truth_(temp__5455__auto__)){
var children__$1 = temp__5455__auto__;
return cljs.core.mapcat.call(null,((function (children__$1,temp__5455__auto__,total__$1,vec__22567,parent,children){
return (function (p__22570){
var vec__22571 = p__22570;
var k = cljs.core.nth.call(null,vec__22571,(0),null);
var v = cljs.core.nth.call(null,vec__22571,(1),null);
return bluegenes.pages.querybuilder.events.class_paths.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.conj.call(null,running,k),total__$1);
});})(children__$1,temp__5455__auto__,total__$1,vec__22567,parent,children))
,children__$1);
} else {
return total__$1;
}
});

bluegenes.pages.querybuilder.events.class_paths.cljs$lang$maxFixedArity = 4;

bluegenes.pages.querybuilder.events.view_map = (function bluegenes$pages$querybuilder$events$view_map(model,q){
return cljs.core.reduce.call(null,(function (total,next){
return cljs.core.assoc_in.call(null,total,next,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"visible","visible",-1024216805),true], null));
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (v){
return clojure.string.split.call(null,v,".");
}),new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(q)));
});
bluegenes.pages.querybuilder.events.with_constraints = (function bluegenes$pages$querybuilder$events$with_constraints(model,q,query_map){
return cljs.core.reduce.call(null,(function (total,next){
var path = cljs.core.conj.call(null,cljs.core.vec.call(null,clojure.string.split.call(null,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(next),".")),new cljs.core.Keyword(null,"constraints","constraints",422775616));
return cljs.core.update_in.call(null,total,path,cljs.core.comp.call(null,cljs.core.vec,cljs.core.conj),cljs.core.dissoc.call(null,next,new cljs.core.Keyword(null,"path","path",-188191168)));
}),query_map,new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q));
});
bluegenes.pages.querybuilder.events.treeify = (function bluegenes$pages$querybuilder$events$treeify(model,q){
return bluegenes.pages.querybuilder.events.with_constraints.call(null,model,q,bluegenes.pages.querybuilder.events.view_map.call(null,model,q));
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","load-query","qb/load-query",433152121),(function (p__22575,p__22576){
var map__22577 = p__22575;
var map__22577__$1 = (((((!((map__22577 == null))))?(((((map__22577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22577):map__22577);
var db = cljs.core.get.call(null,map__22577__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22578 = p__22576;
var _ = cljs.core.nth.call(null,vec__22578,(0),null);
var query = cljs.core.nth.call(null,vec__22578,(1),null);
var model = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"model","model",331153215)], null));
var query__$1 = imcljs.query.sterilize_query.call(null,query);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"qb","qb",-1714166232),cljs.core.assoc,new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575),bluegenes.pages.querybuilder.events.treeify.call(null,model,query__$1),new cljs.core.Keyword(null,"menu","menu",352255198),bluegenes.pages.querybuilder.events.treeify.call(null,model,query__$1),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query__$1),new cljs.core.Keyword(null,"root-class","root-class",-267672298),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query__$1)),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816),bluegenes.pages.querybuilder.logic.read_logic_string.call(null,new cljs.core.Keyword(null,"constraintLogic","constraintLogic",1960517918).cljs$core$IFn$_invoke$arity$1(query__$1))),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","set-root-class","qb/set-root-class",-162948355),(function (p__22582,p__22583){
var map__22584 = p__22582;
var map__22584__$1 = (((((!((map__22584 == null))))?(((((map__22584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22584.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22584):map__22584);
var db = cljs.core.get.call(null,map__22584__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22585 = p__22583;
var _ = cljs.core.nth.call(null,vec__22585,(0),null);
var root_class_kw = cljs.core.nth.call(null,vec__22585,(1),null);
var model = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"model","model",331153215)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"qb","qb",-1714166232),cljs.core.assoc,new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816),null,new cljs.core.Keyword(null,"query-is-valid?","query-is-valid?",-1059700147),false,new cljs.core.Keyword(null,"order","order",-1254677256),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"preview","preview",451279890),null,new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"root-class","root-class",-267672298),cljs.core.keyword.call(null,root_class_kw),new cljs.core.Keyword(null,"qm","qm",1837529525),cljs.core.PersistentArrayMap.createAsIfByAssoc([root_class_kw,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"visible","visible",-1024216805),true], null)]))], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","expand-path","qb/expand-path",-436459403),(function (db,p__22589){
var vec__22590 = p__22589;
var _ = cljs.core.nth.call(null,vec__22590,(0),null);
var path = cljs.core.nth.call(null,vec__22590,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.assoc_in,path,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","expand-all","qb/expand-all",-1489421844),(function (db,p__22593){
var vec__22594 = p__22593;
var _ = cljs.core.nth.call(null,vec__22594,(0),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null)));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","enhance-query-choose-subclass","qb/enhance-query-choose-subclass",1545379523),(function (db,p__22597){
var vec__22598 = p__22597;
var _ = cljs.core.nth.call(null,vec__22598,(0),null);
var path_vec = cljs.core.nth.call(null,vec__22598,(1),null);
var subclass = cljs.core.nth.call(null,vec__22598,(2),null);
var enhance_query = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null));
var map__22601 = cljs.core.get_in.call(null,db,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),path_vec));
var map__22601__$1 = (((((!((map__22601 == null))))?(((((map__22601.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22601.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22601):map__22601);
var current_subclass = cljs.core.get.call(null,map__22601__$1,new cljs.core.Keyword(null,"subclass","subclass",1661186879));
if(cljs.core._EQ_.call(null,current_subclass,subclass)){
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.assoc_in,cljs.core.conj.call(null,path_vec,new cljs.core.Keyword(null,"subclass","subclass",1661186879)),null);
} else {
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.assoc_in,cljs.core.conj.call(null,path_vec,new cljs.core.Keyword(null,"subclass","subclass",1661186879)),subclass);
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","collapse-all","qb/collapse-all",957706026),(function (db,p__22603){
var vec__22604 = p__22603;
var _ = cljs.core.nth.call(null,vec__22604,(0),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.PersistentArrayMap.EMPTY);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","collapse-path","qb/collapse-path",404247408),(function (db,p__22607){
var vec__22608 = p__22607;
var _ = cljs.core.nth.call(null,vec__22608,(0),null);
var path = cljs.core.nth.call(null,vec__22608,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"menu","menu",352255198)], null),cljs.core.update_in,cljs.core.butlast.call(null,path),cljs.core.dissoc,cljs.core.last.call(null,path));
}));
bluegenes.pages.querybuilder.events.dissoc_keywords = (function bluegenes$pages$querybuilder$events$dissoc_keywords(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.apply.call(null,cljs.core.dissoc,m,cljs.core.filter.call(null,cljs.core.some_fn.call(null,cljs.core.keyword_QMARK_,cljs.core.nil_QMARK_),cljs.core.keys.call(null,m)));
} else {
return null;
}
});
/**
 * Builds path-query subclass constraints from the query structure
 */
bluegenes.pages.querybuilder.events.all_views = (function bluegenes$pages$querybuilder$events$all_views(var_args){
var G__22613 = arguments.length;
switch (G__22613) {
case 1:
return bluegenes.pages.querybuilder.events.all_views.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return bluegenes.pages.querybuilder.events.all_views.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.pages.querybuilder.events.all_views.cljs$core$IFn$_invoke$arity$1 = (function (m){
return cljs.core.mapcat.call(null,(function (n){
return bluegenes.pages.querybuilder.events.all_views.call(null,n,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY);
}),bluegenes.pages.querybuilder.events.dissoc_keywords.call(null,m));
});

bluegenes.pages.querybuilder.events.all_views.cljs$core$IFn$_invoke$arity$3 = (function (p__22614,trail,views){
var vec__22615 = p__22614;
var k = cljs.core.nth.call(null,vec__22615,(0),null);
var properties = cljs.core.nth.call(null,vec__22615,(1),null);
var next_trail = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.conj.call(null,trail,k));
if(((cljs.core.map_QMARK_.call(null,properties)) && ((!((cljs.core.not_empty.call(null,bluegenes.pages.querybuilder.events.dissoc_keywords.call(null,properties)) == null)))))){
return cljs.core.mapcat.call(null,((function (next_trail,vec__22615,k,properties){
return (function (p1__22611_SHARP_){
return bluegenes.pages.querybuilder.events.all_views.call(null,p1__22611_SHARP_,next_trail,views);
});})(next_trail,vec__22615,k,properties))
,bluegenes.pages.querybuilder.events.dissoc_keywords.call(null,properties));
} else {
return cljs.core.conj.call(null,views,next_trail);
}
});

bluegenes.pages.querybuilder.events.all_views.cljs$lang$maxFixedArity = 3;

/**
 * Builds path-query subclass constraints from the query structure
 */
bluegenes.pages.querybuilder.events.subclass_constraints = (function bluegenes$pages$querybuilder$events$subclass_constraints(var_args){
var G__22621 = arguments.length;
switch (G__22621) {
case 1:
return bluegenes.pages.querybuilder.events.subclass_constraints.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return bluegenes.pages.querybuilder.events.subclass_constraints.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.pages.querybuilder.events.subclass_constraints.cljs$core$IFn$_invoke$arity$1 = (function (m){
return cljs.core.mapcat.call(null,(function (n){
return bluegenes.pages.querybuilder.events.subclass_constraints.call(null,n,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY);
}),m);
});

bluegenes.pages.querybuilder.events.subclass_constraints.cljs$core$IFn$_invoke$arity$3 = (function (p__22622,trail,subclasses){
var vec__22623 = p__22622;
var k = cljs.core.nth.call(null,vec__22623,(0),null);
var map__22626 = cljs.core.nth.call(null,vec__22623,(1),null);
var map__22626__$1 = (((((!((map__22626 == null))))?(((((map__22626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22626.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22626):map__22626);
var properties = map__22626__$1;
var subclass = cljs.core.get.call(null,map__22626__$1,new cljs.core.Keyword(null,"subclass","subclass",1661186879));
var next_trail = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.conj.call(null,trail,k));
var next_subclasses = (cljs.core.truth_(subclass)?cljs.core.conj.call(null,subclasses,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),clojure.string.join.call(null,".",next_trail),new cljs.core.Keyword(null,"type","type",1174270348),subclass], null)):subclasses);
if(cljs.core.map_QMARK_.call(null,properties)){
return cljs.core.mapcat.call(null,((function (next_trail,next_subclasses,vec__22623,k,map__22626,map__22626__$1,properties,subclass){
return (function (p1__22619_SHARP_){
return bluegenes.pages.querybuilder.events.subclass_constraints.call(null,p1__22619_SHARP_,next_trail,next_subclasses);
});})(next_trail,next_subclasses,vec__22623,k,map__22626,map__22626__$1,properties,subclass))
,properties);
} else {
return subclasses;
}
});

bluegenes.pages.querybuilder.events.subclass_constraints.cljs$lang$maxFixedArity = 3;

/**
 * Builds path-query subclass constraints from the query structure
 */
bluegenes.pages.querybuilder.events.regular_constraints = (function bluegenes$pages$querybuilder$events$regular_constraints(var_args){
var G__22631 = arguments.length;
switch (G__22631) {
case 1:
return bluegenes.pages.querybuilder.events.regular_constraints.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return bluegenes.pages.querybuilder.events.regular_constraints.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.pages.querybuilder.events.regular_constraints.cljs$core$IFn$_invoke$arity$1 = (function (m){
return cljs.core.mapcat.call(null,(function (n){
return bluegenes.pages.querybuilder.events.regular_constraints.call(null,n,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY);
}),m);
});

bluegenes.pages.querybuilder.events.regular_constraints.cljs$core$IFn$_invoke$arity$3 = (function (p__22632,trail,total_constraints){
var vec__22633 = p__22632;
var k = cljs.core.nth.call(null,vec__22633,(0),null);
var map__22636 = cljs.core.nth.call(null,vec__22633,(1),null);
var map__22636__$1 = (((((!((map__22636 == null))))?(((((map__22636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22636):map__22636);
var properties = map__22636__$1;
var constraints = cljs.core.get.call(null,map__22636__$1,new cljs.core.Keyword(null,"constraints","constraints",422775616));
var next_trail = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.conj.call(null,trail,k));
var next_constraints = cljs.core.reduce.call(null,((function (next_trail,vec__22633,k,map__22636,map__22636__$1,properties,constraints){
return (function (total,next){
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(next))){
return cljs.core.conj.call(null,total,cljs.core.assoc.call(null,next,new cljs.core.Keyword(null,"path","path",-188191168),clojure.string.join.call(null,".",next_trail)));
} else {
return total;
}
});})(next_trail,vec__22633,k,map__22636,map__22636__$1,properties,constraints))
,total_constraints,constraints);
if(cljs.core.truth_(cljs.core.not_empty.call(null,bluegenes.pages.querybuilder.events.dissoc_keywords.call(null,properties)))){
return cljs.core.distinct.call(null,cljs.core.mapcat.call(null,((function (next_trail,next_constraints,vec__22633,k,map__22636,map__22636__$1,properties,constraints){
return (function (p1__22629_SHARP_){
return bluegenes.pages.querybuilder.events.regular_constraints.call(null,p1__22629_SHARP_,next_trail,next_constraints);
});})(next_trail,next_constraints,vec__22633,k,map__22636,map__22636__$1,properties,constraints))
,properties));
} else {
return cljs.core.distinct.call(null,cljs.core.concat.call(null,total_constraints,next_constraints));
}
});

bluegenes.pages.querybuilder.events.regular_constraints.cljs$lang$maxFixedArity = 3;

re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","export-query","qb/export-query",-450395774),(function (p__22639,p__22640){
var map__22641 = p__22639;
var map__22641__$1 = (((((!((map__22641 == null))))?(((((map__22641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22641):map__22641);
var db = cljs.core.get.call(null,map__22641__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22642 = p__22640;
var _ = cljs.core.nth.call(null,vec__22642,(0),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("results","history+","results/history+",-1489403964),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"source","source",-433931539),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.assoc.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"im-query","im-query",-1607747997)], null)),new cljs.core.Keyword(null,"title","title",636505583),"Custom Built Query")], null)], null)], null);
}));
bluegenes.pages.querybuilder.events.within_QMARK_ = (function bluegenes$pages$querybuilder$events$within_QMARK_(col,item){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([item]),col) == null)));
});
bluegenes.pages.querybuilder.events.add_if_missing = (function bluegenes$pages$querybuilder$events$add_if_missing(col,item){
if((!(bluegenes.pages.querybuilder.events.within_QMARK_.call(null,col,item)))){
return cljs.core.conj.call(null,col,item);
} else {
return col;
}
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-add-view","qb/enhance-query-add-view",-1050404084),(function (p__22646,p__22647){
var map__22648 = p__22646;
var map__22648__$1 = (((((!((map__22648 == null))))?(((((map__22648.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22648.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22648):map__22648);
var db = cljs.core.get.call(null,map__22648__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22649 = p__22647;
var _ = cljs.core.nth.call(null,vec__22649,(0),null);
var path_vec = cljs.core.nth.call(null,vec__22649,(1),null);
var subclass = cljs.core.nth.call(null,vec__22649,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),(function (){var G__22653 = db;
var G__22653__$1 = (cljs.core.truth_(path_vec)?cljs.core.update_in.call(null,G__22653,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.assoc_in,path_vec,cljs.core.PersistentArrayMap.EMPTY):G__22653);
var G__22653__$2 = (cljs.core.truth_(subclass)?cljs.core.update_in.call(null,G__22653__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,cljs.core.butlast.call(null,path_vec),cljs.core.assoc,new cljs.core.Keyword(null,"subclass","subclass",1661186879),subclass):G__22653__$1);
if(cljs.core.truth_(path_vec)){
return cljs.core.update_in.call(null,G__22653__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"order","order",-1254677256)], null),bluegenes.pages.querybuilder.events.add_if_missing,clojure.string.join.call(null,".",path_vec));
} else {
return G__22653__$2;
}
})(),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","fetch-possible-values","qb/fetch-possible-values",143079467),path_vec], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null)], null);
}));
bluegenes.pages.querybuilder.events.split_and_drop_first = (function bluegenes$pages$querybuilder$events$split_and_drop_first(parent_path,summary_field){
return cljs.core.concat.call(null,parent_path,cljs.core.comp.call(null,cljs.core.vec,cljs.core.partial.call(null,cljs.core.drop,(1)),(function (p1__22654_SHARP_){
return clojure.string.split.call(null,p1__22654_SHARP_,".");
})).call(null,summary_field));
});
bluegenes.pages.querybuilder.events.deep_merge = (function bluegenes$pages$querybuilder$events$deep_merge(a,b){
return cljs.core.merge_with.call(null,(function (x,y){
if(cljs.core.map_QMARK_.call(null,y)){
return bluegenes.pages.querybuilder.events.deep_merge.call(null,x,y);
} else {
if(cljs.core.vector_QMARK_.call(null,y)){
return cljs.core.concat.call(null,x,y);
} else {
return y;

}
}
}),a,b);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-add-summary-views","qb/enhance-query-add-summary-views",66929150),(function (p__22655,p__22656){
var map__22657 = p__22655;
var map__22657__$1 = (((((!((map__22657 == null))))?(((((map__22657.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22657.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22657):map__22657);
var db = cljs.core.get.call(null,map__22657__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22658 = p__22656;
var _ = cljs.core.nth.call(null,vec__22658,(0),null);
var original_path_vec = cljs.core.nth.call(null,vec__22658,(1),null);
var subclass = cljs.core.nth.call(null,vec__22658,(2),null);
var current_mine_name = cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086));
var model = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),current_mine_name,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"model","model",331153215)], null));
var all_summary_fields = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"summary-fields","summary-fields",-51287384),current_mine_name], null));
var summary_fields = cljs.core.get.call(null,all_summary_fields,(function (){var or__4131__auto__ = cljs.core.keyword.call(null,subclass);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return imcljs.path.class$.call(null,model,clojure.string.join.call(null,".",original_path_vec));
}
})());
var adjusted_views = cljs.core.map.call(null,cljs.core.partial.call(null,bluegenes.pages.querybuilder.events.split_and_drop_first,original_path_vec),summary_fields);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.reduce.call(null,((function (current_mine_name,model,all_summary_fields,summary_fields,adjusted_views,map__22657,map__22657__$1,db,vec__22658,_,original_path_vec,subclass){
return (function (db__$1,path_vec){
var G__22662 = db__$1;
var G__22662__$1 = (cljs.core.truth_(path_vec)?cljs.core.update_in.call(null,G__22662,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,path_vec,bluegenes.pages.querybuilder.events.deep_merge,cljs.core.PersistentArrayMap.EMPTY):G__22662);
var G__22662__$2 = (cljs.core.truth_(subclass)?cljs.core.update_in.call(null,G__22662__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,cljs.core.butlast.call(null,path_vec),cljs.core.assoc,new cljs.core.Keyword(null,"subclass","subclass",1661186879),subclass):G__22662__$1);
if(cljs.core.truth_(path_vec)){
return cljs.core.update_in.call(null,G__22662__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"order","order",-1254677256)], null),bluegenes.pages.querybuilder.events.add_if_missing,clojure.string.join.call(null,".",path_vec));
} else {
return G__22662__$2;
}
});})(current_mine_name,model,all_summary_fields,summary_fields,adjusted_views,map__22657,map__22657__$1,db,vec__22658,_,original_path_vec,subclass))
,db,adjusted_views),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
/**
 * Dissociates an entry from a nested associative structure returning a new
 *   nested structure. keys is a sequence of keys. Any empty maps that result
 *   will not be present in the new structure.
 */
bluegenes.pages.querybuilder.events.dissoc_in = (function bluegenes$pages$querybuilder$events$dissoc_in(m,p__22663){
var vec__22664 = p__22663;
var seq__22665 = cljs.core.seq.call(null,vec__22664);
var first__22666 = cljs.core.first.call(null,seq__22665);
var seq__22665__$1 = cljs.core.next.call(null,seq__22665);
var k = first__22666;
var ks = seq__22665__$1;
var keys = vec__22664;
if(ks){
var temp__5455__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(temp__5455__auto__)){
var nextmap = temp__5455__auto__;
var newmap = bluegenes.pages.querybuilder.events.dissoc_in.call(null,nextmap,ks);
if(cljs.core.seq.call(null,newmap)){
return cljs.core.assoc.call(null,m,k,newmap);
} else {
return cljs.core.dissoc.call(null,m,k);
}
} else {
return m;
}
} else {
return cljs.core.dissoc.call(null,m,k);
}
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-remove-view","qb/enhance-query-remove-view",-550621260),(function (p__22667,p__22668){
var map__22669 = p__22667;
var map__22669__$1 = (((((!((map__22669 == null))))?(((((map__22669.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22669.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22669):map__22669);
var db = cljs.core.get.call(null,map__22669__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22670 = p__22668;
var _ = cljs.core.nth.call(null,vec__22670,(0),null);
var path_vec = cljs.core.nth.call(null,vec__22670,(1),null);
var trimmed = bluegenes.pages.querybuilder.events.dissoc_in.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null)),path_vec);
var remaining_views = cljs.core.map.call(null,cljs.core.partial.call(null,clojure.string.join,"."),bluegenes.pages.querybuilder.events.all_views.call(null,trimmed));
var new_order = cljs.core.vec.call(null,cljs.core.remove.call(null,cljs.core.partial.call(null,cljs.core.complement.call(null,bluegenes.pages.querybuilder.events.within_QMARK_),remaining_views),cljs.core.reduce.call(null,bluegenes.pages.querybuilder.events.add_if_missing,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"order","order",-1254677256)], null)),remaining_views)));
var current_codes = cljs.core.set.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,bluegenes.pages.querybuilder.events.used_const_code.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null)))));
var remaining_codes = cljs.core.set.call(null,bluegenes.pages.querybuilder.events.used_const_code.call(null,trimmed));
var codes_to_remove = cljs.core.map.call(null,cljs.core.symbol,clojure.set.difference.call(null,current_codes,remaining_codes));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232)], null),cljs.core.assoc,new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575),trimmed,new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816),cljs.core.reduce.call(null,bluegenes.pages.querybuilder.logic.remove_code,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null)),codes_to_remove),new cljs.core.Keyword(null,"order","order",-1254677256),new_order),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-add-constraint","qb/enhance-query-add-constraint",1832428211),(function (p__22674,p__22675){
var map__22676 = p__22674;
var map__22676__$1 = (((((!((map__22676 == null))))?(((((map__22676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22676):map__22676);
var db = cljs.core.get.call(null,map__22676__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22677 = p__22675;
var _ = cljs.core.nth.call(null,vec__22677,(0),null);
var view_vec = cljs.core.nth.call(null,vec__22677,(1),null);
var code = bluegenes.pages.querybuilder.events.next_available_const_code.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null)));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,cljs.core.conj.call(null,view_vec,new cljs.core.Keyword(null,"constraints","constraints",422775616)),cljs.core.comp.call(null,cljs.core.vec,cljs.core.conj),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"code","code",1586293142),null,new cljs.core.Keyword(null,"op","op",-1882987955),null,new cljs.core.Keyword(null,"value","value",305978217),null], null)),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cache","fetch-possible-values","cache/fetch-possible-values",237476028),clojure.string.join.call(null,".",view_vec)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","fetch-possible-values","qb/fetch-possible-values",143079467),view_vec], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-remove-constraint","qb/enhance-query-remove-constraint",-1355874383),(function (p__22681,p__22682){
var map__22683 = p__22681;
var map__22683__$1 = (((((!((map__22683 == null))))?(((((map__22683.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22683.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22683):map__22683);
var db = cljs.core.get.call(null,map__22683__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22684 = p__22682;
var _ = cljs.core.nth.call(null,vec__22684,(0),null);
var path = cljs.core.nth.call(null,vec__22684,(1),null);
var idx = cljs.core.nth.call(null,vec__22684,(2),null);
var dropped_code = cljs.core.get_in.call(null,db,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.conj.call(null,path,new cljs.core.Keyword(null,"constraints","constraints",422775616)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"code","code",1586293142)], null)));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.update_in,cljs.core.conj.call(null,path,new cljs.core.Keyword(null,"constraints","constraints",422775616)),bluegenes.pages.querybuilder.events.drop_nth,idx),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null),bluegenes.pages.querybuilder.logic.remove_code,(cljs.core.truth_(dropped_code)?cljs.core.symbol.call(null,dropped_code):null)),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","enhance-query-update-constraint","qb/enhance-query-update-constraint",486320165),(function (db,p__22688){
var vec__22689 = p__22688;
var _ = cljs.core.nth.call(null,vec__22689,(0),null);
var path = cljs.core.nth.call(null,vec__22689,(1),null);
var idx = cljs.core.nth.call(null,vec__22689,(2),null);
var constraint = cljs.core.nth.call(null,vec__22689,(3),null);
var add_code_QMARK_ = (function (){var and__4120__auto__ = clojure.string.blank_QMARK_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(constraint));
if(and__4120__auto__){
var or__4131__auto__ = bluegenes.pages.querybuilder.events.not_blank_QMARK_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(constraint));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return bluegenes.pages.querybuilder.events.not_blank_QMARK_.call(null,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(constraint));
}
} else {
return and__4120__auto__;
}
})();
var remove_code_QMARK_ = (function (){var and__4120__auto__ = clojure.string.blank_QMARK_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(constraint));
if(and__4120__auto__){
var and__4120__auto____$1 = clojure.string.blank_QMARK_.call(null,new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(constraint));
if(and__4120__auto____$1){
return new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(constraint);
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})();
var updated_constraint = (function (){var G__22692 = constraint;
var G__22692__$1 = (cljs.core.truth_(add_code_QMARK_)?cljs.core.assoc.call(null,G__22692,new cljs.core.Keyword(null,"code","code",1586293142),bluegenes.pages.querybuilder.events.next_available_const_code.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null)))):G__22692);
if(cljs.core.truth_(remove_code_QMARK_)){
return cljs.core.dissoc.call(null,G__22692__$1,new cljs.core.Keyword(null,"code","code",1586293142));
} else {
return G__22692__$1;
}
})();
var G__22693 = db;
var G__22693__$1 = (cljs.core.truth_(updated_constraint)?cljs.core.update_in.call(null,G__22693,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.assoc_in,cljs.core.reduce.call(null,cljs.core.conj,path,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"constraints","constraints",422775616),idx], null)),updated_constraint):G__22693);
var G__22693__$2 = (cljs.core.truth_(add_code_QMARK_)?cljs.core.update_in.call(null,G__22693__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null),bluegenes.pages.querybuilder.logic.append_code,cljs.core.symbol.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(updated_constraint))):G__22693__$1);
if(cljs.core.truth_(remove_code_QMARK_)){
return cljs.core.update_in.call(null,G__22693__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null),bluegenes.pages.querybuilder.logic.remove_code,cljs.core.symbol.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(constraint)));
} else {
return G__22693__$2;
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","enhance-query-clear-query","qb/enhance-query-clear-query",-351674547),(function (db){
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232)], null),cljs.core.assoc,new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"order","order",-1254677256),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"preview","preview",451279890),null,new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816),cljs.core.List.EMPTY,new cljs.core.Keyword(null,"im-query","im-query",-1607747997),null,new cljs.core.Keyword(null,"menu","menu",352255198),cljs.core.PersistentArrayMap.EMPTY);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),(function (p__22694,p__22695){
var map__22696 = p__22694;
var map__22696__$1 = (((((!((map__22696 == null))))?(((((map__22696.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22696.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22696):map__22696);
var db = cljs.core.get.call(null,map__22696__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22697 = p__22695;
var _ = cljs.core.nth.call(null,vec__22697,(0),null);
var fetch_preview_QMARK_ = cljs.core.nth.call(null,vec__22697,(1),null);
var enhance_query = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
var im_query = imcljs.query.sterilize_query.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"from","from",1815293044),cljs.core.name.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"root-class","root-class",-267672298)], null))),new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"order","order",-1254677256)], null)),new cljs.core.Keyword(null,"constraintLogic","constraintLogic",1960517918),cljs.core.not_empty.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.not_empty.call(null,bluegenes.pages.querybuilder.logic.vec__GT_list.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"constraint-logic","constraint-logic",-1588287816)], null)))))),new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.concat.call(null,bluegenes.pages.querybuilder.events.regular_constraints.call(null,enhance_query),bluegenes.pages.querybuilder.events.subclass_constraints.call(null,enhance_query))], null));
var query_changed_QMARK_ = cljs.core.not_EQ_.call(null,im_query,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"im-query","im-query",-1607747997)], null)));
var G__22701 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232)], null),cljs.core.assoc,new cljs.core.Keyword(null,"im-query","im-query",-1607747997),im_query)], null);
if(cljs.core.truth_(fetch_preview_QMARK_)){
return cljs.core.assoc.call(null,G__22701,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","fetch-preview","qb/fetch-preview",-1456060383),service,im_query], null));
} else {
return G__22701;
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","set-order","qb/set-order",1777438430),(function (p__22702,p__22703){
var map__22704 = p__22702;
var map__22704__$1 = (((((!((map__22704 == null))))?(((((map__22704.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22704.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22704):map__22704);
var db = cljs.core.get.call(null,map__22704__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22705 = p__22703;
var _ = cljs.core.nth.call(null,vec__22705,(0),null);
var ordered_vec = cljs.core.nth.call(null,vec__22705,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"order","order",-1254677256)], null),ordered_vec),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","enhance-query-build-im-query","qb/enhance-query-build-im-query",-170894404),true], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","save-preview","qb/save-preview",-710686040),(function (db,p__22709){
var vec__22710 = p__22709;
var _ = cljs.core.nth.call(null,vec__22710,(0),null);
var results = cljs.core.nth.call(null,vec__22710,(1),null);
return cljs.core.update.call(null,db,new cljs.core.Keyword(null,"qb","qb",-1714166232),cljs.core.assoc,new cljs.core.Keyword(null,"preview","preview",451279890),results,new cljs.core.Keyword(null,"fetching-preview?","fetching-preview?",-1384261753),false);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","make-tree","qb/make-tree",1815455057),(function (db){
var model = new cljs.core.Keyword(null,"model","model",331153215).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"assets","assets",210278279).cljs$core$IFn$_invoke$arity$1(db));
return db;
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("qb","fetch-preview","qb/fetch-preview",-1456060383),(function (p__22713,p__22714){
var map__22715 = p__22713;
var map__22715__$1 = (((((!((map__22715 == null))))?(((((map__22715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22715):map__22715);
var db = cljs.core.get.call(null,map__22715__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22716 = p__22714;
var _ = cljs.core.nth.call(null,vec__22716,(0),null);
var service = cljs.core.nth.call(null,vec__22716,(1),null);
var query = cljs.core.nth.call(null,vec__22716,(2),null);
var new_request = imcljs.fetch.table_rows.call(null,service,query,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(5)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"fetching-preview?","fetching-preview?",-1384261753)], null),true),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"preview-chan","preview-chan",-1076938557)], null),cljs.core.fnil.call(null,cljs.core.async.close_BANG_,cljs.core.async.chan.call(null))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"preview-chan","preview-chan",-1076938557)], null),new_request),new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("qb","save-preview","qb/save-preview",-710686040)], null),new cljs.core.Keyword(null,"chan","chan",-2103021695),new_request], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("qb","enhance-query-success-summary","qb/enhance-query-success-summary",-1311309160),(function (db,p__22720){
var vec__22721 = p__22720;
var _ = cljs.core.nth.call(null,vec__22721,(0),null);
var dot_path = cljs.core.nth.call(null,vec__22721,(1),null);
var summary = cljs.core.nth.call(null,vec__22721,(2),null);
var v = cljs.core.vec.call(null,cljs.core.butlast.call(null,clojure.string.split.call(null,dot_path,".")));
if(cljs.core.truth_(summary)){
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.assoc_in,cljs.core.conj.call(null,v,new cljs.core.Keyword(null,"id-count","id-count",-476311183)),parseInt(summary));
} else {
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"qb","qb",-1714166232),new cljs.core.Keyword(null,"enhance-query","enhance-query",260497575)], null),cljs.core.assoc_in,cljs.core.conj.call(null,v,new cljs.core.Keyword(null,"id-count","id-count",-476311183)),null);
}
}));

//# sourceMappingURL=events.js.map
