// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.reportpage.components.tools');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('oops.core');
goog.require('bluegenes.pages.reportpage.subs');
HTMLCollection.prototype.cljs$core$ISeqable$ = cljs.core.PROTOCOL_SENTINEL;

HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
/**
 * Format the arguments for a tool api compliant tool, such that a tool knows what to display
 */
bluegenes.pages.reportpage.components.tools.create_package = (function bluegenes$pages$reportpage$components$tools$create_package(){
var package_details = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"panel-params","panel-params",1099672237)], null));
var package$ = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,package_details)),new cljs.core.Keyword(null,"format","format",-1306924766),"id",new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,package_details))], null);
return cljs.core.clj__GT_js.call(null,package$);
});
/**
 * Executes a tool-api compliant main method to initialise a tool
 */
bluegenes.pages.reportpage.components.tools.run_script = (function bluegenes$pages$reportpage$components$tools$run_script(tool,tool_id){
var el = document.getElementById(tool_id);
var service = cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"service","service",-1963054559).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)))));
var package$ = bluegenes.pages.reportpage.components.tools.create_package.call(null);
var config = cljs.core.clj__GT_js.call(null,new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(tool));
var target_obj_16717 = window;
var _STAR_runtime_state_STAR__orig_val__16720 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16721 = oops.state.prepare_state.call(null,target_obj_16717,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16721;

try{var call_info_16719 = oops.core.get_selector_call_info_dynamically.call(null,target_obj_16717,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"cljs","cljs",1492417629)], null))),".main"].join(''));
var fn_16718 = (call_info_16719[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_16718,oops.state.get_last_access_modifier.call(null))){
if((!((fn_16718 == null)))){
return fn_16718.call((call_info_16719[(0)]),el,service,package$,null,config);
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16720;
}});
/**
 * Dynamically inserts the tool api script into the head of the document
 */
bluegenes.pages.reportpage.components.tools.fetch_script = (function bluegenes$pages$reportpage$components$tools$fetch_script(tool,tool_id){
var script_tag = document.createElement("script");
var head = cljs.core.first.call(null,document.getElementsByTagName("head"));
var tool_path = cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"files","files",-472457450),new cljs.core.Keyword(null,"js","js",1768080579)], null));
if(cljs.core.truth_(tool_path)){
var target_obj_16722_16730 = script_tag;
var _STAR_runtime_state_STAR__orig_val__16724_16731 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16725_16732 = oops.state.prepare_state.call(null,target_obj_16722_16730,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16725_16732;

try{var parent_obj_16723_16733 = target_obj_16722_16730;
if(oops.core.validate_object_access_dynamically.call(null,parent_obj_16723_16733,(0),"src",true)){
(parent_obj_16723_16733["src"] = ["/tools/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"npm","npm",785664792)], null))),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tool_path)].join(''));
} else {
}

}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16724_16731;
}
var target_obj_16726_16734 = script_tag;
var _STAR_runtime_state_STAR__orig_val__16728_16735 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16729_16736 = oops.state.prepare_state.call(null,target_obj_16726_16734,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16729_16736;

try{var parent_obj_16727_16737 = target_obj_16726_16734;
if(oops.core.validate_object_access_dynamically.call(null,parent_obj_16727_16737,(0),"onload",true)){
(parent_obj_16727_16737["onload"] = ((function (parent_obj_16727_16737,_STAR_runtime_state_STAR__orig_val__16728_16735,_STAR_runtime_state_STAR__temp_val__16729_16736,target_obj_16726_16734,script_tag,head,tool_path){
return (function (){
return bluegenes.pages.reportpage.components.tools.run_script.call(null,tool,tool_id);
});})(parent_obj_16727_16737,_STAR_runtime_state_STAR__orig_val__16728_16735,_STAR_runtime_state_STAR__temp_val__16729_16736,target_obj_16726_16734,script_tag,head,tool_path))
);
} else {
}

}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16728_16735;
}
return head.appendChild(script_tag);
} else {
return console.error("%cNo script path provided for %s","background:#ccc;border-bottom:solid 3px indianred; border-radius:2px;",cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"human","human",-772334390)], null)));
}
});
/**
 * If the tool api script has a stylesheet as well, load it and insert into the doc
 */
bluegenes.pages.reportpage.components.tools.fetch_styles = (function bluegenes$pages$reportpage$components$tools$fetch_styles(tool){
var style_tag = document.createElement("link");
var head = cljs.core.first.call(null,document.getElementsByTagName("head"));
var style_path = cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"files","files",-472457450),new cljs.core.Keyword(null,"css","css",1135045163)], null));
if(cljs.core.truth_(style_path)){
var target_obj_16738_16750 = style_tag;
var _STAR_runtime_state_STAR__orig_val__16740_16751 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16741_16752 = oops.state.prepare_state.call(null,target_obj_16738_16750,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16741_16752;

try{var parent_obj_16739_16753 = target_obj_16738_16750;
if(oops.core.validate_object_access_dynamically.call(null,parent_obj_16739_16753,(0),"href",true)){
(parent_obj_16739_16753["href"] = ["/tools/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"npm","npm",785664792)], null))),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(style_path)].join(''));
} else {
}

}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16740_16751;
}
var target_obj_16742_16754 = style_tag;
var _STAR_runtime_state_STAR__orig_val__16744_16755 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16745_16756 = oops.state.prepare_state.call(null,target_obj_16742_16754,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16745_16756;

try{var parent_obj_16743_16757 = target_obj_16742_16754;
if(oops.core.validate_object_access_dynamically.call(null,parent_obj_16743_16757,(0),"type",true)){
(parent_obj_16743_16757["type"] = "text/css");
} else {
}

}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16744_16755;
}
var target_obj_16746_16758 = style_tag;
var _STAR_runtime_state_STAR__orig_val__16748_16759 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16749_16760 = oops.state.prepare_state.call(null,target_obj_16746_16758,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16749_16760;

try{var parent_obj_16747_16761 = target_obj_16746_16758;
if(oops.core.validate_object_access_dynamically.call(null,parent_obj_16747_16761,(0),"rel",true)){
(parent_obj_16747_16761["rel"] = "stylesheet");
} else {
}

}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16748_16759;
}
return head.appendChild(style_tag);
} else {
return null;
}
});
/**
 * Initialise all the tools on the page
 */
bluegenes.pages.reportpage.components.tools.main = (function bluegenes$pages$reportpage$components$tools$main(){
var toolses = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.reportpage.subs","tools-by-current-type","bluegenes.pages.reportpage.subs/tools-by-current-type",591823073)], null));
console.log("%c@toolses","color:mediumorchid;font-weight:bold;",cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,toolses)));

return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tools","div.tools",383588368)], null),cljs.core.map.call(null,((function (toolses){
return (function (tool){
var tool_id = cljs.core.gensym.call(null,cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"toolName","toolName",869440778),new cljs.core.Keyword(null,"cljs","cljs",1492417629)], null)));
bluegenes.pages.reportpage.components.tools.fetch_script.call(null,tool,tool_id);

bluegenes.pages.reportpage.components.tools.fetch_styles.call(null,tool);

return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool","div.tool",-666931346),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"cljs","cljs",1492417629)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"human","human",-772334390)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"id","id",-1388402092),tool_id], null)], null)], null);
});})(toolses))
,cljs.core.deref.call(null,toolses)));
});

//# sourceMappingURL=tools.js.map
