// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.persistence');
goog.require('cljs.core');
goog.require('dommy.core');
goog.require('cognitect.transit');
bluegenes.persistence.merge_state = (function bluegenes$persistence$merge_state(state,other_state,except_paths){
return cljs.core.merge.call(null,state,cljs.core.reduce.call(null,(function (r,p){
return cljs.core.assoc_in.call(null,r,p,cljs.core.get_in.call(null,state,p));
}),other_state,except_paths));
});
bluegenes.persistence.to_transit = (function bluegenes$persistence$to_transit(state){
return cognitect.transit.write.call(null,cognitect.transit.writer.call(null,new cljs.core.Keyword(null,"json-verbose","json-verbose",-542533531)),state);
});
bluegenes.persistence.persist_BANG_ = (function bluegenes$persistence$persist_BANG_(state){
localStorage.setItem("bluegenes/state",bluegenes.persistence.to_transit.call(null,state));

return state;
});
bluegenes.persistence.destroy_BANG_ = (function bluegenes$persistence$destroy_BANG_(){
localStorage.removeItem("bluegenes/state");

return true;
});
/**
 * Returns the merging of the given state
 *   with the one in localstorage, except the given paths
 */
bluegenes.persistence.get_state_BANG_ = (function bluegenes$persistence$get_state_BANG_(var_args){
var G__16576 = arguments.length;
switch (G__16576) {
case 0:
return bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return bluegenes.persistence.get_state_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentVector.EMPTY);
});

bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (state){
return bluegenes.persistence.get_state_BANG_.call(null,state,cljs.core.PersistentVector.EMPTY);
});

bluegenes.persistence.get_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (state,paths){
return bluegenes.persistence.merge_state.call(null,state,cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),localStorage.getItem("bluegenes/state")),paths);
});

bluegenes.persistence.get_state_BANG_.cljs$lang$maxFixedArity = 2;

bluegenes.persistence.merge_state_from_file = (function bluegenes$persistence$merge_state_from_file(state,file){
return cljs.core.merge.call(null,state,cognitect.transit.read.call(null,cognitect.transit.reader.call(null,new cljs.core.Keyword(null,"json","json",1279968570)),file));
});
/**
 * Contrive to 'download' the given contents
 *   as a file locally to be saved on the user's
 *   magnetic disk-drive storage medium
 */
bluegenes.persistence.download_BANG_ = (function bluegenes$persistence$download_BANG_(tipe,naym,contents){
var a = document.createElement("a");
var f = (new Blob(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [contents], null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.name.call(null,tipe)], null)));
a.href = URL.createObjectURL(f);

a.download = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(naym),".",cljs.core.name.call(null,tipe)].join('');

cljs.core.println.call(null,"<a>",a);

return a.dispatchEvent((new MouseEvent("click")));
});
bluegenes.persistence.make_filename = (function bluegenes$persistence$make_filename(s){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,s,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"msas","msas",1169818602),new cljs.core.Keyword(null,"selected-msa","selected-msa",1656052427).cljs$core$IFn$_invoke$arity$1(s),new cljs.core.Keyword(null,"name","name",1843675177)], null))),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"selected-msa","selected-msa",1656052427).cljs$core$IFn$_invoke$arity$1(s)),".dg"].join('');
});
bluegenes.persistence.load_BANG_ = (function bluegenes$persistence$load_BANG_(s){
document.getElementById("file_button").click();

return s;
});
bluegenes.persistence.save_BANG_ = (function bluegenes$persistence$save_BANG_(s){
bluegenes.persistence.download_BANG_.call(null,"JSON",bluegenes.persistence.make_filename.call(null,s),bluegenes.persistence.to_transit.call(null,s));

return s;
});

//# sourceMappingURL=persistence.js.map
