// Compiled by ClojureScript 1.10.520 {}
goog.provide('im_tables.events.exporttable');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('oops.core');
goog.require('clojure.string');
goog.require('imcljs.fetch');
goog.require('im_tables.interceptors');
/**
 * Encode a stringified text file such that it can be downloaded by the browser.
 *   Results must be stringified - don't pass objects / vectors / arrays / whatever.
 */
im_tables.events.exporttable.encode_file = (function im_tables$events$exporttable$encode_file(data,filetype){
var target_obj_17773 = URL;
var _STAR_runtime_state_STAR__orig_val__17777 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__17778 = oops.state.prepare_state.call(null,target_obj_17773,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__17778;

try{var call_info_17775 = [target_obj_17773,(function (){var next_obj_17776 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_17773,(0),"createObjectURL",true))?(target_obj_17773["createObjectURL"]):null);
return next_obj_17776;
})()];
var fn_17774 = (call_info_17775[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_17774,oops.state.get_last_access_modifier.call(null))){
if((!((fn_17774 == null)))){
return fn_17774.call((call_info_17775[(0)]),(new Blob(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [data], null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),["text/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filetype)].join('')], null))));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__17777;
}});
/**
 * converts results into a csv/tsv-style string.
 */
im_tables.events.exporttable.stringify_query_results = (function im_tables$events$exporttable$stringify_query_results(file_type,query_results){
var separator = new cljs.core.Keyword(null,"separator","separator",-1628749125).cljs$core$IFn$_invoke$arity$1(file_type);
var vec_file = cljs.core.reduce.call(null,((function (separator){
return (function (new_str,p__17779){
var vec__17780 = p__17779;
var i = cljs.core.nth.call(null,vec__17780,(0),null);
var rowvals = cljs.core.nth.call(null,vec__17780,(1),null);
return cljs.core.conj.call(null,new_str,clojure.string.join.call(null,separator,cljs.core.reduce.call(null,((function (vec__17780,i,rowvals,separator){
return (function (new_sub_str,rowval){
return cljs.core.conj.call(null,new_sub_str,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(rowval));
});})(vec__17780,i,rowvals,separator))
,cljs.core.PersistentVector.EMPTY,rowvals)));
});})(separator))
,cljs.core.PersistentVector.EMPTY,query_results);
return clojure.string.join.call(null,"\n",vec_file);
});
im_tables.events.exporttable.xsv = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"csv","csv",-1164440893),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file-type","file-type",1274948820),"csv",new cljs.core.Keyword(null,"separator","separator",-1628749125),","], null),new cljs.core.Keyword(null,"tsv","tsv",-1254214356),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"file-type","file-type",1274948820),"tsv",new cljs.core.Keyword(null,"separator","separator",-1628749125),"\t"], null),new cljs.core.Keyword(null,"fasta","fasta",673427391),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"file-type","file-type",1274948820),"fasta"], null)], null);
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("exporttable","set-format","exporttable/set-format",467113794),im_tables.interceptors.sandbox.call(null),(function (db,p__17783){
var vec__17784 = p__17783;
var _ = cljs.core.nth.call(null,vec__17784,(0),null);
var loc = cljs.core.nth.call(null,vec__17784,(1),null);
var format = cljs.core.nth.call(null,vec__17784,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"data-out","data-out",-1376977853),new cljs.core.Keyword(null,"selected-format","selected-format",1611861540)], null),cljs.core.keyword.call(null,format));
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("exporttable","download","exporttable/download",1768986514),im_tables.interceptors.sandbox.call(null),(function (p__17787,p__17788){
var map__17789 = p__17787;
var map__17789__$1 = (((((!((map__17789 == null))))?(((((map__17789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17789):map__17789);
var db = cljs.core.get.call(null,map__17789__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__17790 = p__17788;
var _ = cljs.core.nth.call(null,vec__17790,(0),null);
var loc = cljs.core.nth.call(null,vec__17790,(1),null);
var query_results = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"response","response",-1068424192),new cljs.core.Keyword(null,"results","results",-1134170113)], null));
var file_type = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"data-out","data-out",-1376977853),new cljs.core.Keyword(null,"selected-format","selected-format",1611861540)], null)).call(null,im_tables.events.exporttable.xsv);
var query = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510)], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(file_type),"fasta")){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","run-fasta-query","exporttable/run-fasta-query",-507758794),loc,file_type], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","run-export-query","exporttable/run-export-query",-1469823772),loc,file_type], null)], null);
}
}));
/**
 * We're setting the attributes of a link with the download property enabled,
 * then clicking it programatically.
 * This spawns a nice download without having to create a new window
 * which might be pop-up blocked. It also allows us to set the filename.
 * We live in the future!
 */
im_tables.events.exporttable.set_download_link_properties = (function im_tables$events$exporttable$set_download_link_properties(results,file_type){
var downloadlink = (function (){var target_obj_17794 = document;
var _STAR_runtime_state_STAR__orig_val__17798 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__17799 = oops.state.prepare_state.call(null,target_obj_17794,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__17799;

try{var call_info_17796 = [target_obj_17794,(function (){var next_obj_17797 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_17794,(0),"getElementById",true))?(target_obj_17794["getElementById"]):null);
return next_obj_17797;
})()];
var fn_17795 = (call_info_17796[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_17795,oops.state.get_last_access_modifier.call(null))){
if((!((fn_17795 == null)))){
return fn_17795.call((call_info_17796[(0)]),"hiddendownloadlink");
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__17798;
}})();
var target_obj_17800_17818 = downloadlink;
var _STAR_runtime_state_STAR__orig_val__17804_17819 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__17805_17820 = oops.state.prepare_state.call(null,target_obj_17800_17818,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__17805_17820;

try{var call_info_17802_17821 = [target_obj_17800_17818,(function (){var next_obj_17803 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_17800_17818,(0),"setAttribute",true))?(target_obj_17800_17818["setAttribute"]):null);
return next_obj_17803;
})()];
var fn_17801_17822 = (call_info_17802_17821[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_17801_17822,oops.state.get_last_access_modifier.call(null))){
if((!((fn_17801_17822 == null)))){
fn_17801_17822.call((call_info_17802_17821[(0)]),"href",im_tables.events.exporttable.encode_file.call(null,results,file_type));
} else {
}
} else {
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__17804_17819;
}
var target_obj_17806_17823 = downloadlink;
var _STAR_runtime_state_STAR__orig_val__17810_17824 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__17811_17825 = oops.state.prepare_state.call(null,target_obj_17806_17823,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__17811_17825;

try{var call_info_17808_17826 = [target_obj_17806_17823,(function (){var next_obj_17809 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_17806_17823,(0),"setAttribute",true))?(target_obj_17806_17823["setAttribute"]):null);
return next_obj_17809;
})()];
var fn_17807_17827 = (call_info_17808_17826[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_17807_17827,oops.state.get_last_access_modifier.call(null))){
if((!((fn_17807_17827 == null)))){
fn_17807_17827.call((call_info_17808_17826[(0)]),"download",["results.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file_type)].join(''));
} else {
}
} else {
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__17810_17824;
}
var target_obj_17812 = downloadlink;
var _STAR_runtime_state_STAR__orig_val__17816 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__17817 = oops.state.prepare_state.call(null,target_obj_17812,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__17817;

try{var call_info_17814 = [target_obj_17812,(function (){var next_obj_17815 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_17812,(0),"click",true))?(target_obj_17812["click"]):null);
return next_obj_17815;
})()];
var fn_17813 = (call_info_17814[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_17813,oops.state.get_last_access_modifier.call(null))){
if((!((fn_17813 == null)))){
return fn_17813.call((call_info_17814[(0)]));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__17816;
}});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("exporttable","download-export-response","exporttable/download-export-response",-1345525899),im_tables.interceptors.sandbox.call(null),(function (p__17828,p__17829){
var map__17830 = p__17828;
var map__17830__$1 = (((((!((map__17830 == null))))?(((((map__17830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17830):map__17830);
var db = cljs.core.get.call(null,map__17830__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__17831 = p__17829;
var _ = cljs.core.nth.call(null,vec__17831,(0),null);
var loc = cljs.core.nth.call(null,vec__17831,(1),null);
var file_type = cljs.core.nth.call(null,vec__17831,(2),null);
var results = cljs.core.nth.call(null,vec__17831,(3),null);
im_tables.events.exporttable.set_download_link_properties.call(null,results,new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(file_type));

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),db], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("exporttable","run-export-query","exporttable/run-export-query",-1469823772),im_tables.interceptors.sandbox.call(null),(function (p__17835,p__17836){
var map__17837 = p__17835;
var map__17837__$1 = (((((!((map__17837 == null))))?(((((map__17837.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17837.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17837):map__17837);
var db = cljs.core.get.call(null,map__17837__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__17838 = p__17836;
var _ = cljs.core.nth.call(null,vec__17838,(0),null);
var loc = cljs.core.nth.call(null,vec__17838,(1),null);
var file_type = cljs.core.nth.call(null,vec__17838,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("im-tables","im-operation","im-tables/im-operation",848539974),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","download-export-response","exporttable/download-export-response",-1345525899),loc,file_type], null),new cljs.core.Keyword(null,"op","op",-1882987955),cljs.core.partial.call(null,imcljs.fetch.fetch_custom_format,cljs.core.get.call(null,db,new cljs.core.Keyword(null,"service","service",-1963054559)),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"query","query",-1288509510)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(file_type)], null))], null),new cljs.core.Keyword(null,"db","db",993250759),db], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("exporttable","run-fasta-query","exporttable/run-fasta-query",-507758794),im_tables.interceptors.sandbox.call(null),(function (p__17842,p__17843){
var map__17844 = p__17842;
var map__17844__$1 = (((((!((map__17844 == null))))?(((((map__17844.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17844.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17844):map__17844);
var db = cljs.core.get.call(null,map__17844__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__17845 = p__17843;
var _ = cljs.core.nth.call(null,vec__17845,(0),null);
var loc = cljs.core.nth.call(null,vec__17845,(1),null);
var file_type = cljs.core.nth.call(null,vec__17845,(2),null);
var query = cljs.core.get.call(null,db,new cljs.core.Keyword(null,"query","query",-1288509510));
var fasta_query = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["id"], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("im-tables","im-operation","im-tables/im-operation",848539974),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("exporttable","download-export-response","exporttable/download-export-response",-1345525899),loc,file_type], null),new cljs.core.Keyword(null,"op","op",-1882987955),cljs.core.partial.call(null,imcljs.fetch.fasta,cljs.core.get.call(null,db,new cljs.core.Keyword(null,"service","service",-1963054559)),fasta_query)], null),new cljs.core.Keyword(null,"db","db",993250759),db], null);
}));

//# sourceMappingURL=exporttable.js.map
