// Compiled by ClojureScript 1.10.520 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR__orig_val__7853 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__7854 = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__7854;

try{try{var seq__7855 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__7856 = null;
var count__7857 = (0);
var i__7858 = (0);
while(true){
if((i__7858 < count__7857)){
var vec__7865 = cljs.core._nth.call(null,chunk__7856,i__7858);
var effect_key = cljs.core.nth.call(null,vec__7865,(0),null);
var effect_value = cljs.core.nth.call(null,vec__7865,(1),null);
var temp__5455__auto___7887 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7887)){
var effect_fn_7888 = temp__5455__auto___7887;
effect_fn_7888.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__7889 = seq__7855;
var G__7890 = chunk__7856;
var G__7891 = count__7857;
var G__7892 = (i__7858 + (1));
seq__7855 = G__7889;
chunk__7856 = G__7890;
count__7857 = G__7891;
i__7858 = G__7892;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__7855);
if(temp__5457__auto__){
var seq__7855__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7855__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__7855__$1);
var G__7893 = cljs.core.chunk_rest.call(null,seq__7855__$1);
var G__7894 = c__4550__auto__;
var G__7895 = cljs.core.count.call(null,c__4550__auto__);
var G__7896 = (0);
seq__7855 = G__7893;
chunk__7856 = G__7894;
count__7857 = G__7895;
i__7858 = G__7896;
continue;
} else {
var vec__7868 = cljs.core.first.call(null,seq__7855__$1);
var effect_key = cljs.core.nth.call(null,vec__7868,(0),null);
var effect_value = cljs.core.nth.call(null,vec__7868,(1),null);
var temp__5455__auto___7897 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7897)){
var effect_fn_7898 = temp__5455__auto___7897;
effect_fn_7898.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__7899 = cljs.core.next.call(null,seq__7855__$1);
var G__7900 = null;
var G__7901 = (0);
var G__7902 = (0);
seq__7855 = G__7899;
chunk__7856 = G__7900;
count__7857 = G__7901;
i__7858 = G__7902;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__7682__auto___7903 = re_frame.interop.now.call(null);
var duration__7683__auto___7904 = (end__7682__auto___7903 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__7683__auto___7904,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__7682__auto___7903);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__7853;
}} else {
var seq__7871 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__7872 = null;
var count__7873 = (0);
var i__7874 = (0);
while(true){
if((i__7874 < count__7873)){
var vec__7881 = cljs.core._nth.call(null,chunk__7872,i__7874);
var effect_key = cljs.core.nth.call(null,vec__7881,(0),null);
var effect_value = cljs.core.nth.call(null,vec__7881,(1),null);
var temp__5455__auto___7905 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7905)){
var effect_fn_7906 = temp__5455__auto___7905;
effect_fn_7906.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__7907 = seq__7871;
var G__7908 = chunk__7872;
var G__7909 = count__7873;
var G__7910 = (i__7874 + (1));
seq__7871 = G__7907;
chunk__7872 = G__7908;
count__7873 = G__7909;
i__7874 = G__7910;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__7871);
if(temp__5457__auto__){
var seq__7871__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7871__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__7871__$1);
var G__7911 = cljs.core.chunk_rest.call(null,seq__7871__$1);
var G__7912 = c__4550__auto__;
var G__7913 = cljs.core.count.call(null,c__4550__auto__);
var G__7914 = (0);
seq__7871 = G__7911;
chunk__7872 = G__7912;
count__7873 = G__7913;
i__7874 = G__7914;
continue;
} else {
var vec__7884 = cljs.core.first.call(null,seq__7871__$1);
var effect_key = cljs.core.nth.call(null,vec__7884,(0),null);
var effect_value = cljs.core.nth.call(null,vec__7884,(1),null);
var temp__5455__auto___7915 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___7915)){
var effect_fn_7916 = temp__5455__auto___7915;
effect_fn_7916.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__7917 = cljs.core.next.call(null,seq__7871__$1);
var G__7918 = null;
var G__7919 = (0);
var G__7920 = (0);
seq__7871 = G__7917;
chunk__7872 = G__7918;
count__7873 = G__7919;
i__7874 = G__7920;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__7921 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__7922 = null;
var count__7923 = (0);
var i__7924 = (0);
while(true){
if((i__7924 < count__7923)){
var map__7929 = cljs.core._nth.call(null,chunk__7922,i__7924);
var map__7929__$1 = (((((!((map__7929 == null))))?(((((map__7929.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7929.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7929):map__7929);
var effect = map__7929__$1;
var ms = cljs.core.get.call(null,map__7929__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__7929__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__7921,chunk__7922,count__7923,i__7924,map__7929,map__7929__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__7921,chunk__7922,count__7923,i__7924,map__7929,map__7929__$1,effect,ms,dispatch))
,ms);
}


var G__7933 = seq__7921;
var G__7934 = chunk__7922;
var G__7935 = count__7923;
var G__7936 = (i__7924 + (1));
seq__7921 = G__7933;
chunk__7922 = G__7934;
count__7923 = G__7935;
i__7924 = G__7936;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__7921);
if(temp__5457__auto__){
var seq__7921__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7921__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__7921__$1);
var G__7937 = cljs.core.chunk_rest.call(null,seq__7921__$1);
var G__7938 = c__4550__auto__;
var G__7939 = cljs.core.count.call(null,c__4550__auto__);
var G__7940 = (0);
seq__7921 = G__7937;
chunk__7922 = G__7938;
count__7923 = G__7939;
i__7924 = G__7940;
continue;
} else {
var map__7931 = cljs.core.first.call(null,seq__7921__$1);
var map__7931__$1 = (((((!((map__7931 == null))))?(((((map__7931.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7931.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7931):map__7931);
var effect = map__7931__$1;
var ms = cljs.core.get.call(null,map__7931__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__7931__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__7921,chunk__7922,count__7923,i__7924,map__7931,map__7931__$1,effect,ms,dispatch,seq__7921__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__7921,chunk__7922,count__7923,i__7924,map__7931,map__7931__$1,effect,ms,dispatch,seq__7921__$1,temp__5457__auto__))
,ms);
}


var G__7941 = cljs.core.next.call(null,seq__7921__$1);
var G__7942 = null;
var G__7943 = (0);
var G__7944 = (0);
seq__7921 = G__7941;
chunk__7922 = G__7942;
count__7923 = G__7943;
i__7924 = G__7944;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_.call(null,value)))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__7945 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__7946 = null;
var count__7947 = (0);
var i__7948 = (0);
while(true){
if((i__7948 < count__7947)){
var event = cljs.core._nth.call(null,chunk__7946,i__7948);
re_frame.router.dispatch.call(null,event);


var G__7949 = seq__7945;
var G__7950 = chunk__7946;
var G__7951 = count__7947;
var G__7952 = (i__7948 + (1));
seq__7945 = G__7949;
chunk__7946 = G__7950;
count__7947 = G__7951;
i__7948 = G__7952;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__7945);
if(temp__5457__auto__){
var seq__7945__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7945__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__7945__$1);
var G__7953 = cljs.core.chunk_rest.call(null,seq__7945__$1);
var G__7954 = c__4550__auto__;
var G__7955 = cljs.core.count.call(null,c__4550__auto__);
var G__7956 = (0);
seq__7945 = G__7953;
chunk__7946 = G__7954;
count__7947 = G__7955;
i__7948 = G__7956;
continue;
} else {
var event = cljs.core.first.call(null,seq__7945__$1);
re_frame.router.dispatch.call(null,event);


var G__7957 = cljs.core.next.call(null,seq__7945__$1);
var G__7958 = null;
var G__7959 = (0);
var G__7960 = (0);
seq__7945 = G__7957;
chunk__7946 = G__7958;
count__7947 = G__7959;
i__7948 = G__7960;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__7961 = cljs.core.seq.call(null,value);
var chunk__7962 = null;
var count__7963 = (0);
var i__7964 = (0);
while(true){
if((i__7964 < count__7963)){
var event = cljs.core._nth.call(null,chunk__7962,i__7964);
clear_event.call(null,event);


var G__7965 = seq__7961;
var G__7966 = chunk__7962;
var G__7967 = count__7963;
var G__7968 = (i__7964 + (1));
seq__7961 = G__7965;
chunk__7962 = G__7966;
count__7963 = G__7967;
i__7964 = G__7968;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__7961);
if(temp__5457__auto__){
var seq__7961__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7961__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__7961__$1);
var G__7969 = cljs.core.chunk_rest.call(null,seq__7961__$1);
var G__7970 = c__4550__auto__;
var G__7971 = cljs.core.count.call(null,c__4550__auto__);
var G__7972 = (0);
seq__7961 = G__7969;
chunk__7962 = G__7970;
count__7963 = G__7971;
i__7964 = G__7972;
continue;
} else {
var event = cljs.core.first.call(null,seq__7961__$1);
clear_event.call(null,event);


var G__7973 = cljs.core.next.call(null,seq__7961__$1);
var G__7974 = null;
var G__7975 = (0);
var G__7976 = (0);
seq__7961 = G__7973;
chunk__7962 = G__7974;
count__7963 = G__7975;
i__7964 = G__7976;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref.call(null,re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map
