// Compiled by ClojureScript 1.10.520 {}
goog.provide('reitit.frontend.controllers');
goog.require('cljs.core');
reitit.frontend.controllers.pad_same_length = (function reitit$frontend$controllers$pad_same_length(a,b){
return cljs.core.concat.call(null,a,cljs.core.take.call(null,(cljs.core.count.call(null,b) - cljs.core.count.call(null,a)),cljs.core.repeat.call(null,null)));
});
reitit.frontend.controllers.params_warning = (new cljs.core.Delay((function (){
return console.warn("Reitit-frontend controller :params is deprecated. Replace with :identity or :parameters option.");
}),null));
/**
 * Get controller identity given controller and match.
 * 
 *   To select interesting properties from Match :parameters option can be set.
 *   Value should be param-type => [param-key]
 *   Resulting value is map of param-type => param-key => value.
 * 
 *   For other uses, :identity option can be used to provide function from
 *   Match to identity.
 * 
 *   Default value is nil, i.e. controller identity doesn't depend on Match.
 */
reitit.frontend.controllers.get_identity = (function reitit$frontend$controllers$get_identity(p__14757,match){
var map__14758 = p__14757;
var map__14758__$1 = (((((!((map__14758 == null))))?(((((map__14758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14758):map__14758);
var identity = cljs.core.get.call(null,map__14758__$1,new cljs.core.Keyword(null,"identity","identity",1647396035));
var parameters = cljs.core.get.call(null,map__14758__$1,new cljs.core.Keyword(null,"parameters","parameters",-1229919748));
var params = cljs.core.get.call(null,map__14758__$1,new cljs.core.Keyword(null,"params","params",710516235));
if(cljs.core.not.call(null,(function (){var and__4120__auto__ = identity;
if(cljs.core.truth_(and__4120__auto__)){
return parameters;
} else {
return and__4120__auto__;
}
})())){
} else {
throw (new Error(["Assert failed: ","Use either :identity or :parameters for controller, not both.","\n","(not (and identity parameters))"].join('')));
}

if(cljs.core.truth_(params)){
cljs.core.deref.call(null,reitit.frontend.controllers.params_warning);
} else {
}

if(cljs.core.truth_(parameters)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4523__auto__ = ((function (map__14758,map__14758__$1,identity,parameters,params){
return (function reitit$frontend$controllers$get_identity_$_iter__14760(s__14761){
return (new cljs.core.LazySeq(null,((function (map__14758,map__14758__$1,identity,parameters,params){
return (function (){
var s__14761__$1 = s__14761;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__14761__$1);
if(temp__5457__auto__){
var s__14761__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__14761__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__14761__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__14763 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__14762 = (0);
while(true){
if((i__14762 < size__4522__auto__)){
var vec__14764 = cljs.core._nth.call(null,c__4521__auto__,i__14762);
var param_type = cljs.core.nth.call(null,vec__14764,(0),null);
var ks = cljs.core.nth.call(null,vec__14764,(1),null);
cljs.core.chunk_append.call(null,b__14763,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys.call(null,cljs.core.get.call(null,new cljs.core.Keyword(null,"parameters","parameters",-1229919748).cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null));

var G__14770 = (i__14762 + (1));
i__14762 = G__14770;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14763),reitit$frontend$controllers$get_identity_$_iter__14760.call(null,cljs.core.chunk_rest.call(null,s__14761__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__14763),null);
}
} else {
var vec__14767 = cljs.core.first.call(null,s__14761__$2);
var param_type = cljs.core.nth.call(null,vec__14767,(0),null);
var ks = cljs.core.nth.call(null,vec__14767,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_type,cljs.core.select_keys.call(null,cljs.core.get.call(null,new cljs.core.Keyword(null,"parameters","parameters",-1229919748).cljs$core$IFn$_invoke$arity$1(match),param_type),ks)], null),reitit$frontend$controllers$get_identity_$_iter__14760.call(null,cljs.core.rest.call(null,s__14761__$2)));
}
} else {
return null;
}
break;
}
});})(map__14758,map__14758__$1,identity,parameters,params))
,null,null));
});})(map__14758,map__14758__$1,identity,parameters,params))
;
return iter__4523__auto__.call(null,parameters);
})());
} else {
if(cljs.core.truth_(identity)){
return identity.call(null,match);
} else {
if(cljs.core.truth_(params)){
return params.call(null,match);
} else {
return null;

}
}
}
});
/**
 * Run side-effects (:start or :stop) for controller.
 *   The side-effect function is called with controller identity value.
 */
reitit.frontend.controllers.apply_controller = (function reitit$frontend$controllers$apply_controller(controller,method){
var temp__5457__auto__ = cljs.core.get.call(null,controller,method);
if(cljs.core.truth_(temp__5457__auto__)){
var f = temp__5457__auto__;
return f.call(null,new cljs.core.Keyword("reitit.frontend.controllers","identity","reitit.frontend.controllers/identity",-806277693).cljs$core$IFn$_invoke$arity$1(controller));
} else {
return null;
}
});
/**
 * Applies changes between current controllers and
 *   those previously enabled. Reinitializes controllers whose
 *   identity has changed.
 */
reitit.frontend.controllers.apply_controllers = (function reitit$frontend$controllers$apply_controllers(old_controllers,new_match){
var new_controllers = cljs.core.mapv.call(null,(function (controller){
return cljs.core.assoc.call(null,controller,new cljs.core.Keyword("reitit.frontend.controllers","identity","reitit.frontend.controllers/identity",-806277693),reitit.frontend.controllers.get_identity.call(null,controller,new_match));
}),new cljs.core.Keyword(null,"controllers","controllers",-1120410624).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(new_match)));
var changed_controllers = cljs.core.vec.call(null,cljs.core.keep.call(null,cljs.core.identity,cljs.core.map.call(null,((function (new_controllers){
return (function (old,new$){
if(cljs.core.not_EQ_.call(null,old,new$)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"old","old",-1825222690),old,new cljs.core.Keyword(null,"new","new",-2085437848),new$], null);
} else {
return null;
}
});})(new_controllers))
,reitit.frontend.controllers.pad_same_length.call(null,old_controllers,new_controllers),reitit.frontend.controllers.pad_same_length.call(null,new_controllers,old_controllers))));
var seq__14771_14779 = cljs.core.seq.call(null,cljs.core.reverse.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"old","old",-1825222690),changed_controllers)));
var chunk__14772_14780 = null;
var count__14773_14781 = (0);
var i__14774_14782 = (0);
while(true){
if((i__14774_14782 < count__14773_14781)){
var controller_14783 = cljs.core._nth.call(null,chunk__14772_14780,i__14774_14782);
reitit.frontend.controllers.apply_controller.call(null,controller_14783,new cljs.core.Keyword(null,"stop","stop",-2140911342));


var G__14784 = seq__14771_14779;
var G__14785 = chunk__14772_14780;
var G__14786 = count__14773_14781;
var G__14787 = (i__14774_14782 + (1));
seq__14771_14779 = G__14784;
chunk__14772_14780 = G__14785;
count__14773_14781 = G__14786;
i__14774_14782 = G__14787;
continue;
} else {
var temp__5457__auto___14788 = cljs.core.seq.call(null,seq__14771_14779);
if(temp__5457__auto___14788){
var seq__14771_14789__$1 = temp__5457__auto___14788;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14771_14789__$1)){
var c__4550__auto___14790 = cljs.core.chunk_first.call(null,seq__14771_14789__$1);
var G__14791 = cljs.core.chunk_rest.call(null,seq__14771_14789__$1);
var G__14792 = c__4550__auto___14790;
var G__14793 = cljs.core.count.call(null,c__4550__auto___14790);
var G__14794 = (0);
seq__14771_14779 = G__14791;
chunk__14772_14780 = G__14792;
count__14773_14781 = G__14793;
i__14774_14782 = G__14794;
continue;
} else {
var controller_14795 = cljs.core.first.call(null,seq__14771_14789__$1);
reitit.frontend.controllers.apply_controller.call(null,controller_14795,new cljs.core.Keyword(null,"stop","stop",-2140911342));


var G__14796 = cljs.core.next.call(null,seq__14771_14789__$1);
var G__14797 = null;
var G__14798 = (0);
var G__14799 = (0);
seq__14771_14779 = G__14796;
chunk__14772_14780 = G__14797;
count__14773_14781 = G__14798;
i__14774_14782 = G__14799;
continue;
}
} else {
}
}
break;
}

var seq__14775_14800 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"new","new",-2085437848),changed_controllers));
var chunk__14776_14801 = null;
var count__14777_14802 = (0);
var i__14778_14803 = (0);
while(true){
if((i__14778_14803 < count__14777_14802)){
var controller_14804 = cljs.core._nth.call(null,chunk__14776_14801,i__14778_14803);
reitit.frontend.controllers.apply_controller.call(null,controller_14804,new cljs.core.Keyword(null,"start","start",-355208981));


var G__14805 = seq__14775_14800;
var G__14806 = chunk__14776_14801;
var G__14807 = count__14777_14802;
var G__14808 = (i__14778_14803 + (1));
seq__14775_14800 = G__14805;
chunk__14776_14801 = G__14806;
count__14777_14802 = G__14807;
i__14778_14803 = G__14808;
continue;
} else {
var temp__5457__auto___14809 = cljs.core.seq.call(null,seq__14775_14800);
if(temp__5457__auto___14809){
var seq__14775_14810__$1 = temp__5457__auto___14809;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14775_14810__$1)){
var c__4550__auto___14811 = cljs.core.chunk_first.call(null,seq__14775_14810__$1);
var G__14812 = cljs.core.chunk_rest.call(null,seq__14775_14810__$1);
var G__14813 = c__4550__auto___14811;
var G__14814 = cljs.core.count.call(null,c__4550__auto___14811);
var G__14815 = (0);
seq__14775_14800 = G__14812;
chunk__14776_14801 = G__14813;
count__14777_14802 = G__14814;
i__14778_14803 = G__14815;
continue;
} else {
var controller_14816 = cljs.core.first.call(null,seq__14775_14810__$1);
reitit.frontend.controllers.apply_controller.call(null,controller_14816,new cljs.core.Keyword(null,"start","start",-355208981));


var G__14817 = cljs.core.next.call(null,seq__14775_14810__$1);
var G__14818 = null;
var G__14819 = (0);
var G__14820 = (0);
seq__14775_14800 = G__14817;
chunk__14776_14801 = G__14818;
count__14777_14802 = G__14819;
i__14778_14803 = G__14820;
continue;
}
} else {
}
}
break;
}

return new_controllers;
});

//# sourceMappingURL=controllers.js.map
