// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('accountant.core');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.history.Html5History');
goog.require('goog.history.EventType');
goog.require('cljs.core.async');
goog.require('goog.events');
goog.require('goog.history.Event');
goog.require('clojure.string');
if(typeof accountant.core.history !== 'undefined'){
} else {
accountant.core.history = (new goog.history.Html5History());
}
accountant.core.listen = (function accountant$core$listen(el,type){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var G__20834_20837 = el;
var G__20835_20838 = type;
var G__20836_20839 = ((function (G__20834_20837,G__20835_20838,out){
return (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,e);
});})(G__20834_20837,G__20835_20838,out))
;
goog.events.listen(G__20834_20837,G__20835_20838,G__20836_20839);

return out;
});
accountant.core.dispatch_on_navigate = (function accountant$core$dispatch_on_navigate(history,nav_handler){
var navigation = accountant.core.listen(history,goog.history.EventType.NAVIGATE);
var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__,navigation){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__,navigation){
return (function (state_20882){
var state_val_20883 = (state_20882[(1)]);
if((state_val_20883 === (1))){
var state_20882__$1 = state_20882;
var statearr_20884_20898 = state_20882__$1;
(statearr_20884_20898[(2)] = null);

(statearr_20884_20898[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (2))){
var state_20882__$1 = state_20882;
var statearr_20885_20899 = state_20882__$1;
(statearr_20885_20899[(1)] = (4));



return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (3))){
var inst_20880 = (state_20882[(2)]);
var state_20882__$1 = state_20882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20882__$1,inst_20880);
} else {
if((state_val_20883 === (4))){
var state_20882__$1 = state_20882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20882__$1,(7),navigation);
} else {
if((state_val_20883 === (5))){
var state_20882__$1 = state_20882;
var statearr_20887_20900 = state_20882__$1;
(statearr_20887_20900[(2)] = null);

(statearr_20887_20900[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (6))){
var inst_20878 = (state_20882[(2)]);
var state_20882__$1 = state_20882;
var statearr_20888_20901 = state_20882__$1;
(statearr_20888_20901[(2)] = inst_20878);

(statearr_20888_20901[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20883 === (7))){
var inst_20872 = (state_20882[(2)]);
var inst_20873 = inst_20872.token;
var inst_20874 = (nav_handler.cljs$core$IFn$_invoke$arity$1 ? nav_handler.cljs$core$IFn$_invoke$arity$1(inst_20873) : nav_handler.call(null,inst_20873));
var state_20882__$1 = (function (){var statearr_20889 = state_20882;
(statearr_20889[(7)] = inst_20874);

return statearr_20889;
})();
var statearr_20890_20902 = state_20882__$1;
(statearr_20890_20902[(2)] = null);

(statearr_20890_20902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__17905__auto__,navigation))
;
return ((function (switch__17779__auto__,c__17905__auto__,navigation){
return (function() {
var accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__ = null;
var accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____0 = (function (){
var statearr_20894 = [null,null,null,null,null,null,null,null];
(statearr_20894[(0)] = accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__);

(statearr_20894[(1)] = (1));

return statearr_20894;
});
var accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____1 = (function (state_20882){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20882);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20895){if((e20895 instanceof Object)){
var ex__17783__auto__ = e20895;
var statearr_20896_20903 = state_20882;
(statearr_20896_20903[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20882);

return cljs.core.cst$kw$recur;
} else {
throw e20895;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20904 = state_20882;
state_20882 = G__20904;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__ = function(state_20882){
switch(arguments.length){
case 0:
return accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____0.call(this);
case 1:
return accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____1.call(this,state_20882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____0;
accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = accountant$core$dispatch_on_navigate_$_state_machine__17780__auto____1;
return accountant$core$dispatch_on_navigate_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__,navigation))
})();
var state__17907__auto__ = (function (){var statearr_20897 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20897[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_20897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__,navigation))
);

return c__17905__auto__;
});
/**
 * Given a DOM element that may or may not be a link, traverse up the DOM tree
 *   to see if any of its parents are links. If so, return the href content.
 */
accountant.core.find_href = (function accountant$core$find_href(e){
while(true){
var temp__6751__auto__ = e.href;
if(cljs.core.truth_(temp__6751__auto__)){
var href = temp__6751__auto__;
return href;
} else {
var temp__6753__auto__ = e.parentNode;
if(cljs.core.truth_(temp__6753__auto__)){
var parent = temp__6753__auto__;
var G__20905 = parent;
e = G__20905;
continue;
} else {
return null;
}
}
break;
}
});
/**
 * Gets the URL for a history token, but without preserving the query string
 *   as Google's version incorrectly does. (See https://goo.gl/xwgUos)
 */
accountant.core.get_url = (function accountant$core$get_url(history,token){
return [cljs.core.str(history.pathPrefix_),cljs.core.str(token)].join('');
});
/**
 * Sets a history token, but without preserving the query string as Google's
 *   version incorrectly does. (See https://goo.gl/xwgUos)
 */
accountant.core.set_token_BANG_ = (function accountant$core$set_token_BANG_(history,token,title){
var js_history = history.window_.history;
var url = accountant.core.get_url(history,token);
js_history.pushState(null,(function (){var or__7219__auto__ = title;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
var or__7219__auto____$1 = document.title;
if(cljs.core.truth_(or__7219__auto____$1)){
return or__7219__auto____$1;
} else {
return "";
}
}
})(),url);

return history.dispatchEvent((new goog.history.Event(token)));
});
accountant.core.uri__GT_query = (function accountant$core$uri__GT_query(uri){
var query = uri.getQuery();
if(cljs.core.empty_QMARK_(query)){
return null;
} else {
return [cljs.core.str("?"),cljs.core.str(query)].join('');
}
});
accountant.core.uri__GT_fragment = (function accountant$core$uri__GT_fragment(uri){
var fragment = uri.getFragment();
if(cljs.core.empty_QMARK_(fragment)){
return null;
} else {
return [cljs.core.str("#"),cljs.core.str(fragment)].join('');
}
});
/**
 * Create a click handler that blocks page reloads for known routes
 */
accountant.core.prevent_reload_on_known_path = (function accountant$core$prevent_reload_on_known_path(history,path_exists_QMARK_){
var G__20909 = document;
var G__20910 = "click";
var G__20911 = ((function (G__20909,G__20910){
return (function (e){
var target = e.target;
var button = e.button;
var meta_key = e.metaKey;
var alt_key = e.altKey;
var ctrl_key = e.ctrlKey;
var shift_key = e.shiftKey;
var any_key = (function (){var or__7219__auto__ = meta_key;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
var or__7219__auto____$1 = alt_key;
if(cljs.core.truth_(or__7219__auto____$1)){
return or__7219__auto____$1;
} else {
var or__7219__auto____$2 = ctrl_key;
if(cljs.core.truth_(or__7219__auto____$2)){
return or__7219__auto____$2;
} else {
return shift_key;
}
}
}
})();
var href = accountant.core.find_href(target);
var uri = goog.Uri.parse(href);
var path = uri.getPath();
var query = accountant.core.uri__GT_query(uri);
var fragment = accountant.core.uri__GT_fragment(uri);
var relative_href = [cljs.core.str(path),cljs.core.str(query),cljs.core.str(fragment)].join('');
var title = target.title;
var host = uri.getDomain();
var current_host = window.location.hostname;
var loc = window.location;
var current_relative_href = [cljs.core.str(loc.pathname),cljs.core.str(loc.query),cljs.core.str(loc.hash)].join('');
if(cljs.core.truth_((function (){var and__7207__auto__ = cljs.core.not(any_key);
if(and__7207__auto__){
var and__7207__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(button,(0));
if(and__7207__auto____$1){
var and__7207__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(host,current_host);
if(and__7207__auto____$2){
var and__7207__auto____$3 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(current_relative_href,relative_href);
if(and__7207__auto____$3){
return (path_exists_QMARK_.cljs$core$IFn$_invoke$arity$1 ? path_exists_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : path_exists_QMARK_.call(null,path));
} else {
return and__7207__auto____$3;
}
} else {
return and__7207__auto____$2;
}
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
accountant.core.set_token_BANG_(history,relative_href,title);

return e.preventDefault();
} else {
return null;
}
});})(G__20909,G__20910))
;
return goog.events.listen(G__20909,G__20910,G__20911);
});
if(typeof accountant.core.nav_handler !== 'undefined'){
} else {
accountant.core.nav_handler = null;
}
if(typeof accountant.core.path_exists_QMARK_ !== 'undefined'){
} else {
accountant.core.path_exists_QMARK_ = null;
}
/**
 * Create and configure HTML5 history navigation.
 * 
 *   nav-handler: a fn of one argument, a path. Called when we've decided
 *   to navigate to another page. You'll want to make your app draw the
 *   new page here.
 * 
 *   path-exists?: a fn of one argument, a path. Return truthy if this path is handled by the SPA
 */
accountant.core.configure_navigation_BANG_ = (function accountant$core$configure_navigation_BANG_(p__20912){
var map__20915 = p__20912;
var map__20915__$1 = ((((!((map__20915 == null)))?((((map__20915.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20915.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20915):map__20915);
var nav_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20915__$1,cljs.core.cst$kw$nav_DASH_handler);
var path_exists_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20915__$1,cljs.core.cst$kw$path_DASH_exists_QMARK_);
accountant.core.history.setUseFragment(true);

accountant.core.history.setEnabled(true);

accountant.core.nav_handler = nav_handler;

accountant.core.path_exists_QMARK_ = path_exists_QMARK_;

accountant.core.dispatch_on_navigate(accountant.core.history,nav_handler);

return accountant.core.prevent_reload_on_known_path(accountant.core.history,path_exists_QMARK_);
});
accountant.core.map__GT_params = (function accountant$core$map__GT_params(query){
var params = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20917_SHARP_){
return cljs.core.name(p1__20917_SHARP_);
}),cljs.core.keys(query));
var values = cljs.core.vals(query);
var pairs = cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(params,values));
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (params,values,pairs){
return (function (p1__20918_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("=",p1__20918_SHARP_);
});})(params,values,pairs))
,pairs));
});
/**
 * add a browser history entry. updates window/location
 */
accountant.core.navigate_BANG_ = (function accountant$core$navigate_BANG_(var_args){
var args20919 = [];
var len__8435__auto___20922 = arguments.length;
var i__8436__auto___20923 = (0);
while(true){
if((i__8436__auto___20923 < len__8435__auto___20922)){
args20919.push((arguments[i__8436__auto___20923]));

var G__20924 = (i__8436__auto___20923 + (1));
i__8436__auto___20923 = G__20924;
continue;
} else {
}
break;
}

var G__20921 = args20919.length;
switch (G__20921) {
case 1:
return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20919.length)].join('')));

}
});

accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (route){
return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$2(route,cljs.core.PersistentArrayMap.EMPTY);
});

accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (route,query){
if(cljs.core.truth_(accountant.core.nav_handler)){
var token = accountant.core.history.getToken();
var old_route = cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(token,"?"));
var query_string = accountant.core.map__GT_params(cljs.core.reduce_kv(((function (token,old_route){
return (function (valid,k,v){
if(cljs.core.truth_(v)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(valid,k,v);
} else {
return valid;
}
});})(token,old_route))
,cljs.core.PersistentArrayMap.EMPTY,query));
var with_params = ((cljs.core.empty_QMARK_(query_string))?route:[cljs.core.str(route),cljs.core.str("?"),cljs.core.str(query_string)].join(''));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_route,route)){
return accountant.core.history.replaceToken(with_params);
} else {
return accountant.core.history.setToken(with_params);
}
} else {
return console.error("can't navigate! until configure-navigation! called");
}
});

accountant.core.navigate_BANG_.cljs$lang$maxFixedArity = 2;

accountant.core.dispatch_current_BANG_ = (function accountant$core$dispatch_current_BANG_(){

var path = window.location.pathname;
var query = window.location.search;
var hash = window.location.hash;
if(cljs.core.truth_(accountant.core.nav_handler)){
var G__20927 = [cljs.core.str(path),cljs.core.str(query),cljs.core.str(hash)].join('');
return (accountant.core.nav_handler.cljs$core$IFn$_invoke$arity$1 ? accountant.core.nav_handler.cljs$core$IFn$_invoke$arity$1(G__20927) : accountant.core.nav_handler.call(null,G__20927));
} else {
return console.error("can't dispatch-current until configure-navigation! called");
}
});
