// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args17964 = [];
var len__8435__auto___17970 = arguments.length;
var i__8436__auto___17971 = (0);
while(true){
if((i__8436__auto___17971 < len__8435__auto___17970)){
args17964.push((arguments[i__8436__auto___17971]));

var G__17972 = (i__8436__auto___17971 + (1));
i__8436__auto___17971 = G__17972;
continue;
} else {
}
break;
}

var G__17966 = args17964.length;
switch (G__17966) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17964.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async17967 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17967 = (function (f,blockable,meta17968){
this.f = f;
this.blockable = blockable;
this.meta17968 = meta17968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17969,meta17968__$1){
var self__ = this;
var _17969__$1 = this;
return (new cljs.core.async.t_cljs$core$async17967(self__.f,self__.blockable,meta17968__$1));
});

cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17969){
var self__ = this;
var _17969__$1 = this;
return self__.meta17968;
});

cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17967.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17968], null);
});

cljs.core.async.t_cljs$core$async17967.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17967.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17967";

cljs.core.async.t_cljs$core$async17967.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async17967");
});

cljs.core.async.__GT_t_cljs$core$async17967 = (function cljs$core$async$__GT_t_cljs$core$async17967(f__$1,blockable__$1,meta17968){
return (new cljs.core.async.t_cljs$core$async17967(f__$1,blockable__$1,meta17968));
});

}

return (new cljs.core.async.t_cljs$core$async17967(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args17976 = [];
var len__8435__auto___17979 = arguments.length;
var i__8436__auto___17980 = (0);
while(true){
if((i__8436__auto___17980 < len__8435__auto___17979)){
args17976.push((arguments[i__8436__auto___17980]));

var G__17981 = (i__8436__auto___17980 + (1));
i__8436__auto___17980 = G__17981;
continue;
} else {
}
break;
}

var G__17978 = args17976.length;
switch (G__17978) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17976.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args17983 = [];
var len__8435__auto___17986 = arguments.length;
var i__8436__auto___17987 = (0);
while(true){
if((i__8436__auto___17987 < len__8435__auto___17986)){
args17983.push((arguments[i__8436__auto___17987]));

var G__17988 = (i__8436__auto___17987 + (1));
i__8436__auto___17987 = G__17988;
continue;
} else {
}
break;
}

var G__17985 = args17983.length;
switch (G__17985) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17983.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args17990 = [];
var len__8435__auto___17993 = arguments.length;
var i__8436__auto___17994 = (0);
while(true){
if((i__8436__auto___17994 < len__8435__auto___17993)){
args17990.push((arguments[i__8436__auto___17994]));

var G__17995 = (i__8436__auto___17994 + (1));
i__8436__auto___17994 = G__17995;
continue;
} else {
}
break;
}

var G__17992 = args17990.length;
switch (G__17992) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17990.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17997 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17997) : fn1.call(null,val_17997));
} else {
cljs.core.async.impl.dispatch.run(((function (val_17997,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17997) : fn1.call(null,val_17997));
});})(val_17997,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args17998 = [];
var len__8435__auto___18001 = arguments.length;
var i__8436__auto___18002 = (0);
while(true){
if((i__8436__auto___18002 < len__8435__auto___18001)){
args17998.push((arguments[i__8436__auto___18002]));

var G__18003 = (i__8436__auto___18002 + (1));
i__8436__auto___18002 = G__18003;
continue;
} else {
}
break;
}

var G__18000 = args17998.length;
switch (G__18000) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17998.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__6751__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8235__auto___18005 = n;
var x_18006 = (0);
while(true){
if((x_18006 < n__8235__auto___18005)){
(a[x_18006] = (0));

var G__18007 = (x_18006 + (1));
x_18006 = G__18007;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__18008 = (i + (1));
i = G__18008;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async18012 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18012 = (function (flag,meta18013){
this.flag = flag;
this.meta18013 = meta18013;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_18014,meta18013__$1){
var self__ = this;
var _18014__$1 = this;
return (new cljs.core.async.t_cljs$core$async18012(self__.flag,meta18013__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_18014){
var self__ = this;
var _18014__$1 = this;
return self__.meta18013;
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta18013], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async18012.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18012.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18012";

cljs.core.async.t_cljs$core$async18012.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async18012");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async18012 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async18012(flag__$1,meta18013){
return (new cljs.core.async.t_cljs$core$async18012(flag__$1,meta18013));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async18012(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async18018 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18018 = (function (flag,cb,meta18019){
this.flag = flag;
this.cb = cb;
this.meta18019 = meta18019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18020,meta18019__$1){
var self__ = this;
var _18020__$1 = this;
return (new cljs.core.async.t_cljs$core$async18018(self__.flag,self__.cb,meta18019__$1));
});

cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18020){
var self__ = this;
var _18020__$1 = this;
return self__.meta18019;
});

cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async18018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async18018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta18019], null);
});

cljs.core.async.t_cljs$core$async18018.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18018";

cljs.core.async.t_cljs$core$async18018.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async18018");
});

cljs.core.async.__GT_t_cljs$core$async18018 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async18018(flag__$1,cb__$1,meta18019){
return (new cljs.core.async.t_cljs$core$async18018(flag__$1,cb__$1,meta18019));
});

}

return (new cljs.core.async.t_cljs$core$async18018(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18021_SHARP_){
var G__18025 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18021_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__18025) : fret.call(null,G__18025));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__18022_SHARP_){
var G__18026 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__18022_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__18026) : fret.call(null,G__18026));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7219__auto__ = wport;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return port;
}
})()], null));
} else {
var G__18027 = (i + (1));
i = G__18027;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7219__auto__ = ret;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__6753__auto__ = (function (){var and__7207__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7207__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7207__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___18033 = arguments.length;
var i__8436__auto___18034 = (0);
while(true){
if((i__8436__auto___18034 < len__8435__auto___18033)){
args__8442__auto__.push((arguments[i__8436__auto___18034]));

var G__18035 = (i__8436__auto___18034 + (1));
i__8436__auto___18034 = G__18035;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__18030){
var map__18031 = p__18030;
var map__18031__$1 = ((((!((map__18031 == null)))?((((map__18031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18031.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18031):map__18031);
var opts = map__18031__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq18028){
var G__18029 = cljs.core.first(seq18028);
var seq18028__$1 = cljs.core.next(seq18028);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__18029,seq18028__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args18036 = [];
var len__8435__auto___18086 = arguments.length;
var i__8436__auto___18087 = (0);
while(true){
if((i__8436__auto___18087 < len__8435__auto___18086)){
args18036.push((arguments[i__8436__auto___18087]));

var G__18088 = (i__8436__auto___18087 + (1));
i__8436__auto___18087 = G__18088;
continue;
} else {
}
break;
}

var G__18038 = args18036.length;
switch (G__18038) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18036.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17905__auto___18090 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___18090){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___18090){
return (function (state_18062){
var state_val_18063 = (state_18062[(1)]);
if((state_val_18063 === (7))){
var inst_18058 = (state_18062[(2)]);
var state_18062__$1 = state_18062;
var statearr_18064_18091 = state_18062__$1;
(statearr_18064_18091[(2)] = inst_18058);

(statearr_18064_18091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (1))){
var state_18062__$1 = state_18062;
var statearr_18065_18092 = state_18062__$1;
(statearr_18065_18092[(2)] = null);

(statearr_18065_18092[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (4))){
var inst_18041 = (state_18062[(7)]);
var inst_18041__$1 = (state_18062[(2)]);
var inst_18042 = (inst_18041__$1 == null);
var state_18062__$1 = (function (){var statearr_18066 = state_18062;
(statearr_18066[(7)] = inst_18041__$1);

return statearr_18066;
})();
if(cljs.core.truth_(inst_18042)){
var statearr_18067_18093 = state_18062__$1;
(statearr_18067_18093[(1)] = (5));

} else {
var statearr_18068_18094 = state_18062__$1;
(statearr_18068_18094[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (13))){
var state_18062__$1 = state_18062;
var statearr_18069_18095 = state_18062__$1;
(statearr_18069_18095[(2)] = null);

(statearr_18069_18095[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (6))){
var inst_18041 = (state_18062[(7)]);
var state_18062__$1 = state_18062;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18062__$1,(11),to,inst_18041);
} else {
if((state_val_18063 === (3))){
var inst_18060 = (state_18062[(2)]);
var state_18062__$1 = state_18062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18062__$1,inst_18060);
} else {
if((state_val_18063 === (12))){
var state_18062__$1 = state_18062;
var statearr_18070_18096 = state_18062__$1;
(statearr_18070_18096[(2)] = null);

(statearr_18070_18096[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (2))){
var state_18062__$1 = state_18062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18062__$1,(4),from);
} else {
if((state_val_18063 === (11))){
var inst_18051 = (state_18062[(2)]);
var state_18062__$1 = state_18062;
if(cljs.core.truth_(inst_18051)){
var statearr_18071_18097 = state_18062__$1;
(statearr_18071_18097[(1)] = (12));

} else {
var statearr_18072_18098 = state_18062__$1;
(statearr_18072_18098[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (9))){
var state_18062__$1 = state_18062;
var statearr_18073_18099 = state_18062__$1;
(statearr_18073_18099[(2)] = null);

(statearr_18073_18099[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (5))){
var state_18062__$1 = state_18062;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18074_18100 = state_18062__$1;
(statearr_18074_18100[(1)] = (8));

} else {
var statearr_18075_18101 = state_18062__$1;
(statearr_18075_18101[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (14))){
var inst_18056 = (state_18062[(2)]);
var state_18062__$1 = state_18062;
var statearr_18076_18102 = state_18062__$1;
(statearr_18076_18102[(2)] = inst_18056);

(statearr_18076_18102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (10))){
var inst_18048 = (state_18062[(2)]);
var state_18062__$1 = state_18062;
var statearr_18077_18103 = state_18062__$1;
(statearr_18077_18103[(2)] = inst_18048);

(statearr_18077_18103[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18063 === (8))){
var inst_18045 = cljs.core.async.close_BANG_(to);
var state_18062__$1 = state_18062;
var statearr_18078_18104 = state_18062__$1;
(statearr_18078_18104[(2)] = inst_18045);

(statearr_18078_18104[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___18090))
;
return ((function (switch__17779__auto__,c__17905__auto___18090){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_18082 = [null,null,null,null,null,null,null,null];
(statearr_18082[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_18082[(1)] = (1));

return statearr_18082;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_18062){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18062);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18083){if((e18083 instanceof Object)){
var ex__17783__auto__ = e18083;
var statearr_18084_18105 = state_18062;
(statearr_18084_18105[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18062);

return cljs.core.cst$kw$recur;
} else {
throw e18083;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18106 = state_18062;
state_18062 = G__18106;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_18062){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_18062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___18090))
})();
var state__17907__auto__ = (function (){var statearr_18085 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18085[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18090);

return statearr_18085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___18090))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__18294){
var vec__18295 = p__18294;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18295,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18295,(1),null);
var job = vec__18295;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17905__auto___18481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results){
return (function (state_18302){
var state_val_18303 = (state_18302[(1)]);
if((state_val_18303 === (1))){
var state_18302__$1 = state_18302;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18302__$1,(2),res,v);
} else {
if((state_val_18303 === (2))){
var inst_18299 = (state_18302[(2)]);
var inst_18300 = cljs.core.async.close_BANG_(res);
var state_18302__$1 = (function (){var statearr_18304 = state_18302;
(statearr_18304[(7)] = inst_18299);

return statearr_18304;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18302__$1,inst_18300);
} else {
return null;
}
}
});})(c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results))
;
return ((function (switch__17779__auto__,c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_18308 = [null,null,null,null,null,null,null,null];
(statearr_18308[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__);

(statearr_18308[(1)] = (1));

return statearr_18308;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1 = (function (state_18302){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18302);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18309){if((e18309 instanceof Object)){
var ex__17783__auto__ = e18309;
var statearr_18310_18482 = state_18302;
(statearr_18310_18482[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18302);

return cljs.core.cst$kw$recur;
} else {
throw e18309;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18483 = state_18302;
state_18302 = G__18483;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = function(state_18302){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1.call(this,state_18302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results))
})();
var state__17907__auto__ = (function (){var statearr_18311 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18311[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18481);

return statearr_18311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___18481,res,vec__18295,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__18312){
var vec__18313 = p__18312;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18313,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18313,(1),null);
var job = vec__18313;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8235__auto___18484 = n;
var __18485 = (0);
while(true){
if((__18485 < n__8235__auto___18484)){
var G__18316_18486 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__18316_18486) {
case "compute":
var c__17905__auto___18488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18485,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (__18485,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function (state_18329){
var state_val_18330 = (state_18329[(1)]);
if((state_val_18330 === (1))){
var state_18329__$1 = state_18329;
var statearr_18331_18489 = state_18329__$1;
(statearr_18331_18489[(2)] = null);

(statearr_18331_18489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18330 === (2))){
var state_18329__$1 = state_18329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18329__$1,(4),jobs);
} else {
if((state_val_18330 === (3))){
var inst_18327 = (state_18329[(2)]);
var state_18329__$1 = state_18329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18329__$1,inst_18327);
} else {
if((state_val_18330 === (4))){
var inst_18319 = (state_18329[(2)]);
var inst_18320 = process(inst_18319);
var state_18329__$1 = state_18329;
if(cljs.core.truth_(inst_18320)){
var statearr_18332_18490 = state_18329__$1;
(statearr_18332_18490[(1)] = (5));

} else {
var statearr_18333_18491 = state_18329__$1;
(statearr_18333_18491[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18330 === (5))){
var state_18329__$1 = state_18329;
var statearr_18334_18492 = state_18329__$1;
(statearr_18334_18492[(2)] = null);

(statearr_18334_18492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18330 === (6))){
var state_18329__$1 = state_18329;
var statearr_18335_18493 = state_18329__$1;
(statearr_18335_18493[(2)] = null);

(statearr_18335_18493[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18330 === (7))){
var inst_18325 = (state_18329[(2)]);
var state_18329__$1 = state_18329;
var statearr_18336_18494 = state_18329__$1;
(statearr_18336_18494[(2)] = inst_18325);

(statearr_18336_18494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18485,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
;
return ((function (__18485,switch__17779__auto__,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_18340 = [null,null,null,null,null,null,null];
(statearr_18340[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__);

(statearr_18340[(1)] = (1));

return statearr_18340;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1 = (function (state_18329){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18329);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18341){if((e18341 instanceof Object)){
var ex__17783__auto__ = e18341;
var statearr_18342_18495 = state_18329;
(statearr_18342_18495[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18329);

return cljs.core.cst$kw$recur;
} else {
throw e18341;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18496 = state_18329;
state_18329 = G__18496;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = function(state_18329){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1.call(this,state_18329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__;
})()
;})(__18485,switch__17779__auto__,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
})();
var state__17907__auto__ = (function (){var statearr_18343 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18343[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18488);

return statearr_18343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(__18485,c__17905__auto___18488,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
);


break;
case "async":
var c__17905__auto___18497 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__18485,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (__18485,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function (state_18356){
var state_val_18357 = (state_18356[(1)]);
if((state_val_18357 === (1))){
var state_18356__$1 = state_18356;
var statearr_18358_18498 = state_18356__$1;
(statearr_18358_18498[(2)] = null);

(statearr_18358_18498[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18357 === (2))){
var state_18356__$1 = state_18356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18356__$1,(4),jobs);
} else {
if((state_val_18357 === (3))){
var inst_18354 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18356__$1,inst_18354);
} else {
if((state_val_18357 === (4))){
var inst_18346 = (state_18356[(2)]);
var inst_18347 = async(inst_18346);
var state_18356__$1 = state_18356;
if(cljs.core.truth_(inst_18347)){
var statearr_18359_18499 = state_18356__$1;
(statearr_18359_18499[(1)] = (5));

} else {
var statearr_18360_18500 = state_18356__$1;
(statearr_18360_18500[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18357 === (5))){
var state_18356__$1 = state_18356;
var statearr_18361_18501 = state_18356__$1;
(statearr_18361_18501[(2)] = null);

(statearr_18361_18501[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18357 === (6))){
var state_18356__$1 = state_18356;
var statearr_18362_18502 = state_18356__$1;
(statearr_18362_18502[(2)] = null);

(statearr_18362_18502[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18357 === (7))){
var inst_18352 = (state_18356[(2)]);
var state_18356__$1 = state_18356;
var statearr_18363_18503 = state_18356__$1;
(statearr_18363_18503[(2)] = inst_18352);

(statearr_18363_18503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__18485,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
;
return ((function (__18485,switch__17779__auto__,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_18367 = [null,null,null,null,null,null,null];
(statearr_18367[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__);

(statearr_18367[(1)] = (1));

return statearr_18367;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1 = (function (state_18356){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18356);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18368){if((e18368 instanceof Object)){
var ex__17783__auto__ = e18368;
var statearr_18369_18504 = state_18356;
(statearr_18369_18504[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18356);

return cljs.core.cst$kw$recur;
} else {
throw e18368;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18505 = state_18356;
state_18356 = G__18505;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = function(state_18356){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1.call(this,state_18356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__;
})()
;})(__18485,switch__17779__auto__,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
})();
var state__17907__auto__ = (function (){var statearr_18370 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18370[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18497);

return statearr_18370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(__18485,c__17905__auto___18497,G__18316_18486,n__8235__auto___18484,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__18506 = (__18485 + (1));
__18485 = G__18506;
continue;
} else {
}
break;
}

var c__17905__auto___18507 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___18507,jobs,results,process,async){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___18507,jobs,results,process,async){
return (function (state_18392){
var state_val_18393 = (state_18392[(1)]);
if((state_val_18393 === (1))){
var state_18392__$1 = state_18392;
var statearr_18394_18508 = state_18392__$1;
(statearr_18394_18508[(2)] = null);

(statearr_18394_18508[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18393 === (2))){
var state_18392__$1 = state_18392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18392__$1,(4),from);
} else {
if((state_val_18393 === (3))){
var inst_18390 = (state_18392[(2)]);
var state_18392__$1 = state_18392;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18392__$1,inst_18390);
} else {
if((state_val_18393 === (4))){
var inst_18373 = (state_18392[(7)]);
var inst_18373__$1 = (state_18392[(2)]);
var inst_18374 = (inst_18373__$1 == null);
var state_18392__$1 = (function (){var statearr_18395 = state_18392;
(statearr_18395[(7)] = inst_18373__$1);

return statearr_18395;
})();
if(cljs.core.truth_(inst_18374)){
var statearr_18396_18509 = state_18392__$1;
(statearr_18396_18509[(1)] = (5));

} else {
var statearr_18397_18510 = state_18392__$1;
(statearr_18397_18510[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18393 === (5))){
var inst_18376 = cljs.core.async.close_BANG_(jobs);
var state_18392__$1 = state_18392;
var statearr_18398_18511 = state_18392__$1;
(statearr_18398_18511[(2)] = inst_18376);

(statearr_18398_18511[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18393 === (6))){
var inst_18373 = (state_18392[(7)]);
var inst_18378 = (state_18392[(8)]);
var inst_18378__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_18379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18380 = [inst_18373,inst_18378__$1];
var inst_18381 = (new cljs.core.PersistentVector(null,2,(5),inst_18379,inst_18380,null));
var state_18392__$1 = (function (){var statearr_18399 = state_18392;
(statearr_18399[(8)] = inst_18378__$1);

return statearr_18399;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18392__$1,(8),jobs,inst_18381);
} else {
if((state_val_18393 === (7))){
var inst_18388 = (state_18392[(2)]);
var state_18392__$1 = state_18392;
var statearr_18400_18512 = state_18392__$1;
(statearr_18400_18512[(2)] = inst_18388);

(statearr_18400_18512[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18393 === (8))){
var inst_18378 = (state_18392[(8)]);
var inst_18383 = (state_18392[(2)]);
var state_18392__$1 = (function (){var statearr_18401 = state_18392;
(statearr_18401[(9)] = inst_18383);

return statearr_18401;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18392__$1,(9),results,inst_18378);
} else {
if((state_val_18393 === (9))){
var inst_18385 = (state_18392[(2)]);
var state_18392__$1 = (function (){var statearr_18402 = state_18392;
(statearr_18402[(10)] = inst_18385);

return statearr_18402;
})();
var statearr_18403_18513 = state_18392__$1;
(statearr_18403_18513[(2)] = null);

(statearr_18403_18513[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___18507,jobs,results,process,async))
;
return ((function (switch__17779__auto__,c__17905__auto___18507,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_18407 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18407[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__);

(statearr_18407[(1)] = (1));

return statearr_18407;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1 = (function (state_18392){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18392);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18408){if((e18408 instanceof Object)){
var ex__17783__auto__ = e18408;
var statearr_18409_18514 = state_18392;
(statearr_18409_18514[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18392);

return cljs.core.cst$kw$recur;
} else {
throw e18408;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18515 = state_18392;
state_18392 = G__18515;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = function(state_18392){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1.call(this,state_18392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___18507,jobs,results,process,async))
})();
var state__17907__auto__ = (function (){var statearr_18410 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18410[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18507);

return statearr_18410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___18507,jobs,results,process,async))
);


var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__,jobs,results,process,async){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__,jobs,results,process,async){
return (function (state_18448){
var state_val_18449 = (state_18448[(1)]);
if((state_val_18449 === (7))){
var inst_18444 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18450_18516 = state_18448__$1;
(statearr_18450_18516[(2)] = inst_18444);

(statearr_18450_18516[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (20))){
var state_18448__$1 = state_18448;
var statearr_18451_18517 = state_18448__$1;
(statearr_18451_18517[(2)] = null);

(statearr_18451_18517[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (1))){
var state_18448__$1 = state_18448;
var statearr_18452_18518 = state_18448__$1;
(statearr_18452_18518[(2)] = null);

(statearr_18452_18518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (4))){
var inst_18413 = (state_18448[(7)]);
var inst_18413__$1 = (state_18448[(2)]);
var inst_18414 = (inst_18413__$1 == null);
var state_18448__$1 = (function (){var statearr_18453 = state_18448;
(statearr_18453[(7)] = inst_18413__$1);

return statearr_18453;
})();
if(cljs.core.truth_(inst_18414)){
var statearr_18454_18519 = state_18448__$1;
(statearr_18454_18519[(1)] = (5));

} else {
var statearr_18455_18520 = state_18448__$1;
(statearr_18455_18520[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (15))){
var inst_18426 = (state_18448[(8)]);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18448__$1,(18),to,inst_18426);
} else {
if((state_val_18449 === (21))){
var inst_18439 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18456_18521 = state_18448__$1;
(statearr_18456_18521[(2)] = inst_18439);

(statearr_18456_18521[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (13))){
var inst_18441 = (state_18448[(2)]);
var state_18448__$1 = (function (){var statearr_18457 = state_18448;
(statearr_18457[(9)] = inst_18441);

return statearr_18457;
})();
var statearr_18458_18522 = state_18448__$1;
(statearr_18458_18522[(2)] = null);

(statearr_18458_18522[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (6))){
var inst_18413 = (state_18448[(7)]);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18448__$1,(11),inst_18413);
} else {
if((state_val_18449 === (17))){
var inst_18434 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
if(cljs.core.truth_(inst_18434)){
var statearr_18459_18523 = state_18448__$1;
(statearr_18459_18523[(1)] = (19));

} else {
var statearr_18460_18524 = state_18448__$1;
(statearr_18460_18524[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (3))){
var inst_18446 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18448__$1,inst_18446);
} else {
if((state_val_18449 === (12))){
var inst_18423 = (state_18448[(10)]);
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18448__$1,(14),inst_18423);
} else {
if((state_val_18449 === (2))){
var state_18448__$1 = state_18448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18448__$1,(4),results);
} else {
if((state_val_18449 === (19))){
var state_18448__$1 = state_18448;
var statearr_18461_18525 = state_18448__$1;
(statearr_18461_18525[(2)] = null);

(statearr_18461_18525[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (11))){
var inst_18423 = (state_18448[(2)]);
var state_18448__$1 = (function (){var statearr_18462 = state_18448;
(statearr_18462[(10)] = inst_18423);

return statearr_18462;
})();
var statearr_18463_18526 = state_18448__$1;
(statearr_18463_18526[(2)] = null);

(statearr_18463_18526[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (9))){
var state_18448__$1 = state_18448;
var statearr_18464_18527 = state_18448__$1;
(statearr_18464_18527[(2)] = null);

(statearr_18464_18527[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (5))){
var state_18448__$1 = state_18448;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18465_18528 = state_18448__$1;
(statearr_18465_18528[(1)] = (8));

} else {
var statearr_18466_18529 = state_18448__$1;
(statearr_18466_18529[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (14))){
var inst_18426 = (state_18448[(8)]);
var inst_18428 = (state_18448[(11)]);
var inst_18426__$1 = (state_18448[(2)]);
var inst_18427 = (inst_18426__$1 == null);
var inst_18428__$1 = cljs.core.not(inst_18427);
var state_18448__$1 = (function (){var statearr_18467 = state_18448;
(statearr_18467[(8)] = inst_18426__$1);

(statearr_18467[(11)] = inst_18428__$1);

return statearr_18467;
})();
if(inst_18428__$1){
var statearr_18468_18530 = state_18448__$1;
(statearr_18468_18530[(1)] = (15));

} else {
var statearr_18469_18531 = state_18448__$1;
(statearr_18469_18531[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (16))){
var inst_18428 = (state_18448[(11)]);
var state_18448__$1 = state_18448;
var statearr_18470_18532 = state_18448__$1;
(statearr_18470_18532[(2)] = inst_18428);

(statearr_18470_18532[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (10))){
var inst_18420 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18471_18533 = state_18448__$1;
(statearr_18471_18533[(2)] = inst_18420);

(statearr_18471_18533[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (18))){
var inst_18431 = (state_18448[(2)]);
var state_18448__$1 = state_18448;
var statearr_18472_18534 = state_18448__$1;
(statearr_18472_18534[(2)] = inst_18431);

(statearr_18472_18534[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18449 === (8))){
var inst_18417 = cljs.core.async.close_BANG_(to);
var state_18448__$1 = state_18448;
var statearr_18473_18535 = state_18448__$1;
(statearr_18473_18535[(2)] = inst_18417);

(statearr_18473_18535[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto__,jobs,results,process,async))
;
return ((function (switch__17779__auto__,c__17905__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_18477 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18477[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__);

(statearr_18477[(1)] = (1));

return statearr_18477;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1 = (function (state_18448){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18448);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18478){if((e18478 instanceof Object)){
var ex__17783__auto__ = e18478;
var statearr_18479_18536 = state_18448;
(statearr_18479_18536[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18448);

return cljs.core.cst$kw$recur;
} else {
throw e18478;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18537 = state_18448;
state_18448 = G__18537;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__ = function(state_18448){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1.call(this,state_18448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__,jobs,results,process,async))
})();
var state__17907__auto__ = (function (){var statearr_18480 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18480[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_18480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__,jobs,results,process,async))
);

return c__17905__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args18538 = [];
var len__8435__auto___18541 = arguments.length;
var i__8436__auto___18542 = (0);
while(true){
if((i__8436__auto___18542 < len__8435__auto___18541)){
args18538.push((arguments[i__8436__auto___18542]));

var G__18543 = (i__8436__auto___18542 + (1));
i__8436__auto___18542 = G__18543;
continue;
} else {
}
break;
}

var G__18540 = args18538.length;
switch (G__18540) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18538.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args18545 = [];
var len__8435__auto___18548 = arguments.length;
var i__8436__auto___18549 = (0);
while(true){
if((i__8436__auto___18549 < len__8435__auto___18548)){
args18545.push((arguments[i__8436__auto___18549]));

var G__18550 = (i__8436__auto___18549 + (1));
i__8436__auto___18549 = G__18550;
continue;
} else {
}
break;
}

var G__18547 = args18545.length;
switch (G__18547) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18545.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args18552 = [];
var len__8435__auto___18605 = arguments.length;
var i__8436__auto___18606 = (0);
while(true){
if((i__8436__auto___18606 < len__8435__auto___18605)){
args18552.push((arguments[i__8436__auto___18606]));

var G__18607 = (i__8436__auto___18606 + (1));
i__8436__auto___18606 = G__18607;
continue;
} else {
}
break;
}

var G__18554 = args18552.length;
switch (G__18554) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18552.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17905__auto___18609 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___18609,tc,fc){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___18609,tc,fc){
return (function (state_18580){
var state_val_18581 = (state_18580[(1)]);
if((state_val_18581 === (7))){
var inst_18576 = (state_18580[(2)]);
var state_18580__$1 = state_18580;
var statearr_18582_18610 = state_18580__$1;
(statearr_18582_18610[(2)] = inst_18576);

(statearr_18582_18610[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (1))){
var state_18580__$1 = state_18580;
var statearr_18583_18611 = state_18580__$1;
(statearr_18583_18611[(2)] = null);

(statearr_18583_18611[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (4))){
var inst_18557 = (state_18580[(7)]);
var inst_18557__$1 = (state_18580[(2)]);
var inst_18558 = (inst_18557__$1 == null);
var state_18580__$1 = (function (){var statearr_18584 = state_18580;
(statearr_18584[(7)] = inst_18557__$1);

return statearr_18584;
})();
if(cljs.core.truth_(inst_18558)){
var statearr_18585_18612 = state_18580__$1;
(statearr_18585_18612[(1)] = (5));

} else {
var statearr_18586_18613 = state_18580__$1;
(statearr_18586_18613[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (13))){
var state_18580__$1 = state_18580;
var statearr_18587_18614 = state_18580__$1;
(statearr_18587_18614[(2)] = null);

(statearr_18587_18614[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (6))){
var inst_18557 = (state_18580[(7)]);
var inst_18563 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18557) : p.call(null,inst_18557));
var state_18580__$1 = state_18580;
if(cljs.core.truth_(inst_18563)){
var statearr_18588_18615 = state_18580__$1;
(statearr_18588_18615[(1)] = (9));

} else {
var statearr_18589_18616 = state_18580__$1;
(statearr_18589_18616[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (3))){
var inst_18578 = (state_18580[(2)]);
var state_18580__$1 = state_18580;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18580__$1,inst_18578);
} else {
if((state_val_18581 === (12))){
var state_18580__$1 = state_18580;
var statearr_18590_18617 = state_18580__$1;
(statearr_18590_18617[(2)] = null);

(statearr_18590_18617[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (2))){
var state_18580__$1 = state_18580;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18580__$1,(4),ch);
} else {
if((state_val_18581 === (11))){
var inst_18557 = (state_18580[(7)]);
var inst_18567 = (state_18580[(2)]);
var state_18580__$1 = state_18580;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18580__$1,(8),inst_18567,inst_18557);
} else {
if((state_val_18581 === (9))){
var state_18580__$1 = state_18580;
var statearr_18591_18618 = state_18580__$1;
(statearr_18591_18618[(2)] = tc);

(statearr_18591_18618[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (5))){
var inst_18560 = cljs.core.async.close_BANG_(tc);
var inst_18561 = cljs.core.async.close_BANG_(fc);
var state_18580__$1 = (function (){var statearr_18592 = state_18580;
(statearr_18592[(8)] = inst_18560);

return statearr_18592;
})();
var statearr_18593_18619 = state_18580__$1;
(statearr_18593_18619[(2)] = inst_18561);

(statearr_18593_18619[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (14))){
var inst_18574 = (state_18580[(2)]);
var state_18580__$1 = state_18580;
var statearr_18594_18620 = state_18580__$1;
(statearr_18594_18620[(2)] = inst_18574);

(statearr_18594_18620[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (10))){
var state_18580__$1 = state_18580;
var statearr_18595_18621 = state_18580__$1;
(statearr_18595_18621[(2)] = fc);

(statearr_18595_18621[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18581 === (8))){
var inst_18569 = (state_18580[(2)]);
var state_18580__$1 = state_18580;
if(cljs.core.truth_(inst_18569)){
var statearr_18596_18622 = state_18580__$1;
(statearr_18596_18622[(1)] = (12));

} else {
var statearr_18597_18623 = state_18580__$1;
(statearr_18597_18623[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___18609,tc,fc))
;
return ((function (switch__17779__auto__,c__17905__auto___18609,tc,fc){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_18601 = [null,null,null,null,null,null,null,null,null];
(statearr_18601[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_18601[(1)] = (1));

return statearr_18601;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_18580){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18580);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18602){if((e18602 instanceof Object)){
var ex__17783__auto__ = e18602;
var statearr_18603_18624 = state_18580;
(statearr_18603_18624[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18580);

return cljs.core.cst$kw$recur;
} else {
throw e18602;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18625 = state_18580;
state_18580 = G__18625;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_18580){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_18580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___18609,tc,fc))
})();
var state__17907__auto__ = (function (){var statearr_18604 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18604[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___18609);

return statearr_18604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___18609,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__){
return (function (state_18689){
var state_val_18690 = (state_18689[(1)]);
if((state_val_18690 === (7))){
var inst_18685 = (state_18689[(2)]);
var state_18689__$1 = state_18689;
var statearr_18691_18712 = state_18689__$1;
(statearr_18691_18712[(2)] = inst_18685);

(statearr_18691_18712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (1))){
var inst_18669 = init;
var state_18689__$1 = (function (){var statearr_18692 = state_18689;
(statearr_18692[(7)] = inst_18669);

return statearr_18692;
})();
var statearr_18693_18713 = state_18689__$1;
(statearr_18693_18713[(2)] = null);

(statearr_18693_18713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (4))){
var inst_18672 = (state_18689[(8)]);
var inst_18672__$1 = (state_18689[(2)]);
var inst_18673 = (inst_18672__$1 == null);
var state_18689__$1 = (function (){var statearr_18694 = state_18689;
(statearr_18694[(8)] = inst_18672__$1);

return statearr_18694;
})();
if(cljs.core.truth_(inst_18673)){
var statearr_18695_18714 = state_18689__$1;
(statearr_18695_18714[(1)] = (5));

} else {
var statearr_18696_18715 = state_18689__$1;
(statearr_18696_18715[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (6))){
var inst_18672 = (state_18689[(8)]);
var inst_18669 = (state_18689[(7)]);
var inst_18676 = (state_18689[(9)]);
var inst_18676__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_18669,inst_18672) : f.call(null,inst_18669,inst_18672));
var inst_18677 = cljs.core.reduced_QMARK_(inst_18676__$1);
var state_18689__$1 = (function (){var statearr_18697 = state_18689;
(statearr_18697[(9)] = inst_18676__$1);

return statearr_18697;
})();
if(inst_18677){
var statearr_18698_18716 = state_18689__$1;
(statearr_18698_18716[(1)] = (8));

} else {
var statearr_18699_18717 = state_18689__$1;
(statearr_18699_18717[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (3))){
var inst_18687 = (state_18689[(2)]);
var state_18689__$1 = state_18689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18689__$1,inst_18687);
} else {
if((state_val_18690 === (2))){
var state_18689__$1 = state_18689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18689__$1,(4),ch);
} else {
if((state_val_18690 === (9))){
var inst_18676 = (state_18689[(9)]);
var inst_18669 = inst_18676;
var state_18689__$1 = (function (){var statearr_18700 = state_18689;
(statearr_18700[(7)] = inst_18669);

return statearr_18700;
})();
var statearr_18701_18718 = state_18689__$1;
(statearr_18701_18718[(2)] = null);

(statearr_18701_18718[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (5))){
var inst_18669 = (state_18689[(7)]);
var state_18689__$1 = state_18689;
var statearr_18702_18719 = state_18689__$1;
(statearr_18702_18719[(2)] = inst_18669);

(statearr_18702_18719[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (10))){
var inst_18683 = (state_18689[(2)]);
var state_18689__$1 = state_18689;
var statearr_18703_18720 = state_18689__$1;
(statearr_18703_18720[(2)] = inst_18683);

(statearr_18703_18720[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18690 === (8))){
var inst_18676 = (state_18689[(9)]);
var inst_18679 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_18676) : cljs.core.deref.call(null,inst_18676));
var state_18689__$1 = state_18689;
var statearr_18704_18721 = state_18689__$1;
(statearr_18704_18721[(2)] = inst_18679);

(statearr_18704_18721[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto__))
;
return ((function (switch__17779__auto__,c__17905__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17780__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17780__auto____0 = (function (){
var statearr_18708 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18708[(0)] = cljs$core$async$reduce_$_state_machine__17780__auto__);

(statearr_18708[(1)] = (1));

return statearr_18708;
});
var cljs$core$async$reduce_$_state_machine__17780__auto____1 = (function (state_18689){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18689);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18709){if((e18709 instanceof Object)){
var ex__17783__auto__ = e18709;
var statearr_18710_18722 = state_18689;
(statearr_18710_18722[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18689);

return cljs.core.cst$kw$recur;
} else {
throw e18709;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18723 = state_18689;
state_18689 = G__18723;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17780__auto__ = function(state_18689){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17780__auto____1.call(this,state_18689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17780__auto____0;
cljs$core$async$reduce_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17780__auto____1;
return cljs$core$async$reduce_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__))
})();
var state__17907__auto__ = (function (){var statearr_18711 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18711[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_18711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__))
);

return c__17905__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__,f__$1){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__,f__$1){
return (function (state_18743){
var state_val_18744 = (state_18743[(1)]);
if((state_val_18744 === (1))){
var inst_18738 = cljs.core.async.reduce(f__$1,init,ch);
var state_18743__$1 = state_18743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18743__$1,(2),inst_18738);
} else {
if((state_val_18744 === (2))){
var inst_18740 = (state_18743[(2)]);
var inst_18741 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_18740) : f__$1.call(null,inst_18740));
var state_18743__$1 = state_18743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18743__$1,inst_18741);
} else {
return null;
}
}
});})(c__17905__auto__,f__$1))
;
return ((function (switch__17779__auto__,c__17905__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__17780__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17780__auto____0 = (function (){
var statearr_18748 = [null,null,null,null,null,null,null];
(statearr_18748[(0)] = cljs$core$async$transduce_$_state_machine__17780__auto__);

(statearr_18748[(1)] = (1));

return statearr_18748;
});
var cljs$core$async$transduce_$_state_machine__17780__auto____1 = (function (state_18743){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18743);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18749){if((e18749 instanceof Object)){
var ex__17783__auto__ = e18749;
var statearr_18750_18752 = state_18743;
(statearr_18750_18752[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18743);

return cljs.core.cst$kw$recur;
} else {
throw e18749;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18753 = state_18743;
state_18743 = G__18753;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17780__auto__ = function(state_18743){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17780__auto____1.call(this,state_18743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17780__auto____0;
cljs$core$async$transduce_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17780__auto____1;
return cljs$core$async$transduce_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__,f__$1))
})();
var state__17907__auto__ = (function (){var statearr_18751 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18751[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_18751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__,f__$1))
);

return c__17905__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args18754 = [];
var len__8435__auto___18806 = arguments.length;
var i__8436__auto___18807 = (0);
while(true){
if((i__8436__auto___18807 < len__8435__auto___18806)){
args18754.push((arguments[i__8436__auto___18807]));

var G__18808 = (i__8436__auto___18807 + (1));
i__8436__auto___18807 = G__18808;
continue;
} else {
}
break;
}

var G__18756 = args18754.length;
switch (G__18756) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18754.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__){
return (function (state_18781){
var state_val_18782 = (state_18781[(1)]);
if((state_val_18782 === (7))){
var inst_18763 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18783_18810 = state_18781__$1;
(statearr_18783_18810[(2)] = inst_18763);

(statearr_18783_18810[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (1))){
var inst_18757 = cljs.core.seq(coll);
var inst_18758 = inst_18757;
var state_18781__$1 = (function (){var statearr_18784 = state_18781;
(statearr_18784[(7)] = inst_18758);

return statearr_18784;
})();
var statearr_18785_18811 = state_18781__$1;
(statearr_18785_18811[(2)] = null);

(statearr_18785_18811[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (4))){
var inst_18758 = (state_18781[(7)]);
var inst_18761 = cljs.core.first(inst_18758);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18781__$1,(7),ch,inst_18761);
} else {
if((state_val_18782 === (13))){
var inst_18775 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18786_18812 = state_18781__$1;
(statearr_18786_18812[(2)] = inst_18775);

(statearr_18786_18812[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (6))){
var inst_18766 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
if(cljs.core.truth_(inst_18766)){
var statearr_18787_18813 = state_18781__$1;
(statearr_18787_18813[(1)] = (8));

} else {
var statearr_18788_18814 = state_18781__$1;
(statearr_18788_18814[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (3))){
var inst_18779 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18781__$1,inst_18779);
} else {
if((state_val_18782 === (12))){
var state_18781__$1 = state_18781;
var statearr_18789_18815 = state_18781__$1;
(statearr_18789_18815[(2)] = null);

(statearr_18789_18815[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (2))){
var inst_18758 = (state_18781[(7)]);
var state_18781__$1 = state_18781;
if(cljs.core.truth_(inst_18758)){
var statearr_18790_18816 = state_18781__$1;
(statearr_18790_18816[(1)] = (4));

} else {
var statearr_18791_18817 = state_18781__$1;
(statearr_18791_18817[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (11))){
var inst_18772 = cljs.core.async.close_BANG_(ch);
var state_18781__$1 = state_18781;
var statearr_18792_18818 = state_18781__$1;
(statearr_18792_18818[(2)] = inst_18772);

(statearr_18792_18818[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (9))){
var state_18781__$1 = state_18781;
if(cljs.core.truth_(close_QMARK_)){
var statearr_18793_18819 = state_18781__$1;
(statearr_18793_18819[(1)] = (11));

} else {
var statearr_18794_18820 = state_18781__$1;
(statearr_18794_18820[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (5))){
var inst_18758 = (state_18781[(7)]);
var state_18781__$1 = state_18781;
var statearr_18795_18821 = state_18781__$1;
(statearr_18795_18821[(2)] = inst_18758);

(statearr_18795_18821[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (10))){
var inst_18777 = (state_18781[(2)]);
var state_18781__$1 = state_18781;
var statearr_18796_18822 = state_18781__$1;
(statearr_18796_18822[(2)] = inst_18777);

(statearr_18796_18822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18782 === (8))){
var inst_18758 = (state_18781[(7)]);
var inst_18768 = cljs.core.next(inst_18758);
var inst_18758__$1 = inst_18768;
var state_18781__$1 = (function (){var statearr_18797 = state_18781;
(statearr_18797[(7)] = inst_18758__$1);

return statearr_18797;
})();
var statearr_18798_18823 = state_18781__$1;
(statearr_18798_18823[(2)] = null);

(statearr_18798_18823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto__))
;
return ((function (switch__17779__auto__,c__17905__auto__){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_18802 = [null,null,null,null,null,null,null,null];
(statearr_18802[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_18802[(1)] = (1));

return statearr_18802;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_18781){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_18781);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e18803){if((e18803 instanceof Object)){
var ex__17783__auto__ = e18803;
var statearr_18804_18824 = state_18781;
(statearr_18804_18824[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18781);

return cljs.core.cst$kw$recur;
} else {
throw e18803;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__18825 = state_18781;
state_18781 = G__18825;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_18781){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_18781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__))
})();
var state__17907__auto__ = (function (){var statearr_18805 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_18805[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_18805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__))
);

return c__17905__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7932__auto__ = (((_ == null))?null:_);
var m__7933__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7933__auto__.call(null,_));
} else {
var m__7933__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7933__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7933__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7933__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7933__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto__.call(null,m,ch));
} else {
var m__7933__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7933__auto__.call(null,m));
} else {
var m__7933__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7933__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__19054 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19054) : cljs.core.atom.call(null,G__19054));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19055 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19055 = (function (ch,cs,meta19056){
this.ch = ch;
this.cs = cs;
this.meta19056 = meta19056;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_19057,meta19056__$1){
var self__ = this;
var _19057__$1 = this;
return (new cljs.core.async.t_cljs$core$async19055(self__.ch,self__.cs,meta19056__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_19057){
var self__ = this;
var _19057__$1 = this;
return self__.meta19056;
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19058_19282 = self__.cs;
var G__19059_19283 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19058_19282,G__19059_19283) : cljs.core.reset_BANG_.call(null,G__19058_19282,G__19059_19283));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta19056], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async19055.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19055.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19055";

cljs.core.async.t_cljs$core$async19055.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async19055");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async19055 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async19055(ch__$1,cs__$1,meta19056){
return (new cljs.core.async.t_cljs$core$async19055(ch__$1,cs__$1,meta19056));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async19055(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__17905__auto___19284 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___19284,cs,m,dchan,dctr,done){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___19284,cs,m,dchan,dctr,done){
return (function (state_19194){
var state_val_19195 = (state_19194[(1)]);
if((state_val_19195 === (7))){
var inst_19190 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19196_19285 = state_19194__$1;
(statearr_19196_19285[(2)] = inst_19190);

(statearr_19196_19285[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (20))){
var inst_19093 = (state_19194[(7)]);
var inst_19105 = cljs.core.first(inst_19093);
var inst_19106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19105,(0),null);
var inst_19107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19105,(1),null);
var state_19194__$1 = (function (){var statearr_19197 = state_19194;
(statearr_19197[(8)] = inst_19106);

return statearr_19197;
})();
if(cljs.core.truth_(inst_19107)){
var statearr_19198_19286 = state_19194__$1;
(statearr_19198_19286[(1)] = (22));

} else {
var statearr_19199_19287 = state_19194__$1;
(statearr_19199_19287[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (27))){
var inst_19137 = (state_19194[(9)]);
var inst_19135 = (state_19194[(10)]);
var inst_19062 = (state_19194[(11)]);
var inst_19142 = (state_19194[(12)]);
var inst_19142__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19135,inst_19137);
var inst_19143 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_19142__$1,inst_19062,done);
var state_19194__$1 = (function (){var statearr_19200 = state_19194;
(statearr_19200[(12)] = inst_19142__$1);

return statearr_19200;
})();
if(cljs.core.truth_(inst_19143)){
var statearr_19201_19288 = state_19194__$1;
(statearr_19201_19288[(1)] = (30));

} else {
var statearr_19202_19289 = state_19194__$1;
(statearr_19202_19289[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (1))){
var state_19194__$1 = state_19194;
var statearr_19203_19290 = state_19194__$1;
(statearr_19203_19290[(2)] = null);

(statearr_19203_19290[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (24))){
var inst_19093 = (state_19194[(7)]);
var inst_19112 = (state_19194[(2)]);
var inst_19113 = cljs.core.next(inst_19093);
var inst_19071 = inst_19113;
var inst_19072 = null;
var inst_19073 = (0);
var inst_19074 = (0);
var state_19194__$1 = (function (){var statearr_19204 = state_19194;
(statearr_19204[(13)] = inst_19071);

(statearr_19204[(14)] = inst_19073);

(statearr_19204[(15)] = inst_19112);

(statearr_19204[(16)] = inst_19072);

(statearr_19204[(17)] = inst_19074);

return statearr_19204;
})();
var statearr_19205_19291 = state_19194__$1;
(statearr_19205_19291[(2)] = null);

(statearr_19205_19291[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (39))){
var state_19194__$1 = state_19194;
var statearr_19209_19292 = state_19194__$1;
(statearr_19209_19292[(2)] = null);

(statearr_19209_19292[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (4))){
var inst_19062 = (state_19194[(11)]);
var inst_19062__$1 = (state_19194[(2)]);
var inst_19063 = (inst_19062__$1 == null);
var state_19194__$1 = (function (){var statearr_19210 = state_19194;
(statearr_19210[(11)] = inst_19062__$1);

return statearr_19210;
})();
if(cljs.core.truth_(inst_19063)){
var statearr_19211_19293 = state_19194__$1;
(statearr_19211_19293[(1)] = (5));

} else {
var statearr_19212_19294 = state_19194__$1;
(statearr_19212_19294[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (15))){
var inst_19071 = (state_19194[(13)]);
var inst_19073 = (state_19194[(14)]);
var inst_19072 = (state_19194[(16)]);
var inst_19074 = (state_19194[(17)]);
var inst_19089 = (state_19194[(2)]);
var inst_19090 = (inst_19074 + (1));
var tmp19206 = inst_19071;
var tmp19207 = inst_19073;
var tmp19208 = inst_19072;
var inst_19071__$1 = tmp19206;
var inst_19072__$1 = tmp19208;
var inst_19073__$1 = tmp19207;
var inst_19074__$1 = inst_19090;
var state_19194__$1 = (function (){var statearr_19213 = state_19194;
(statearr_19213[(13)] = inst_19071__$1);

(statearr_19213[(14)] = inst_19073__$1);

(statearr_19213[(16)] = inst_19072__$1);

(statearr_19213[(17)] = inst_19074__$1);

(statearr_19213[(18)] = inst_19089);

return statearr_19213;
})();
var statearr_19214_19295 = state_19194__$1;
(statearr_19214_19295[(2)] = null);

(statearr_19214_19295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (21))){
var inst_19116 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19218_19296 = state_19194__$1;
(statearr_19218_19296[(2)] = inst_19116);

(statearr_19218_19296[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (31))){
var inst_19142 = (state_19194[(12)]);
var inst_19146 = done(null);
var inst_19147 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_19142);
var state_19194__$1 = (function (){var statearr_19219 = state_19194;
(statearr_19219[(19)] = inst_19146);

return statearr_19219;
})();
var statearr_19220_19297 = state_19194__$1;
(statearr_19220_19297[(2)] = inst_19147);

(statearr_19220_19297[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (32))){
var inst_19134 = (state_19194[(20)]);
var inst_19137 = (state_19194[(9)]);
var inst_19135 = (state_19194[(10)]);
var inst_19136 = (state_19194[(21)]);
var inst_19149 = (state_19194[(2)]);
var inst_19150 = (inst_19137 + (1));
var tmp19215 = inst_19134;
var tmp19216 = inst_19135;
var tmp19217 = inst_19136;
var inst_19134__$1 = tmp19215;
var inst_19135__$1 = tmp19216;
var inst_19136__$1 = tmp19217;
var inst_19137__$1 = inst_19150;
var state_19194__$1 = (function (){var statearr_19221 = state_19194;
(statearr_19221[(20)] = inst_19134__$1);

(statearr_19221[(9)] = inst_19137__$1);

(statearr_19221[(22)] = inst_19149);

(statearr_19221[(10)] = inst_19135__$1);

(statearr_19221[(21)] = inst_19136__$1);

return statearr_19221;
})();
var statearr_19222_19298 = state_19194__$1;
(statearr_19222_19298[(2)] = null);

(statearr_19222_19298[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (40))){
var inst_19162 = (state_19194[(23)]);
var inst_19166 = done(null);
var inst_19167 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_19162);
var state_19194__$1 = (function (){var statearr_19223 = state_19194;
(statearr_19223[(24)] = inst_19166);

return statearr_19223;
})();
var statearr_19224_19299 = state_19194__$1;
(statearr_19224_19299[(2)] = inst_19167);

(statearr_19224_19299[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (33))){
var inst_19153 = (state_19194[(25)]);
var inst_19155 = cljs.core.chunked_seq_QMARK_(inst_19153);
var state_19194__$1 = state_19194;
if(inst_19155){
var statearr_19225_19300 = state_19194__$1;
(statearr_19225_19300[(1)] = (36));

} else {
var statearr_19226_19301 = state_19194__$1;
(statearr_19226_19301[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (13))){
var inst_19083 = (state_19194[(26)]);
var inst_19086 = cljs.core.async.close_BANG_(inst_19083);
var state_19194__$1 = state_19194;
var statearr_19227_19302 = state_19194__$1;
(statearr_19227_19302[(2)] = inst_19086);

(statearr_19227_19302[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (22))){
var inst_19106 = (state_19194[(8)]);
var inst_19109 = cljs.core.async.close_BANG_(inst_19106);
var state_19194__$1 = state_19194;
var statearr_19228_19303 = state_19194__$1;
(statearr_19228_19303[(2)] = inst_19109);

(statearr_19228_19303[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (36))){
var inst_19153 = (state_19194[(25)]);
var inst_19157 = cljs.core.chunk_first(inst_19153);
var inst_19158 = cljs.core.chunk_rest(inst_19153);
var inst_19159 = cljs.core.count(inst_19157);
var inst_19134 = inst_19158;
var inst_19135 = inst_19157;
var inst_19136 = inst_19159;
var inst_19137 = (0);
var state_19194__$1 = (function (){var statearr_19229 = state_19194;
(statearr_19229[(20)] = inst_19134);

(statearr_19229[(9)] = inst_19137);

(statearr_19229[(10)] = inst_19135);

(statearr_19229[(21)] = inst_19136);

return statearr_19229;
})();
var statearr_19230_19304 = state_19194__$1;
(statearr_19230_19304[(2)] = null);

(statearr_19230_19304[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (41))){
var inst_19153 = (state_19194[(25)]);
var inst_19169 = (state_19194[(2)]);
var inst_19170 = cljs.core.next(inst_19153);
var inst_19134 = inst_19170;
var inst_19135 = null;
var inst_19136 = (0);
var inst_19137 = (0);
var state_19194__$1 = (function (){var statearr_19231 = state_19194;
(statearr_19231[(20)] = inst_19134);

(statearr_19231[(9)] = inst_19137);

(statearr_19231[(27)] = inst_19169);

(statearr_19231[(10)] = inst_19135);

(statearr_19231[(21)] = inst_19136);

return statearr_19231;
})();
var statearr_19232_19305 = state_19194__$1;
(statearr_19232_19305[(2)] = null);

(statearr_19232_19305[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (43))){
var state_19194__$1 = state_19194;
var statearr_19233_19306 = state_19194__$1;
(statearr_19233_19306[(2)] = null);

(statearr_19233_19306[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (29))){
var inst_19178 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19234_19307 = state_19194__$1;
(statearr_19234_19307[(2)] = inst_19178);

(statearr_19234_19307[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (44))){
var inst_19187 = (state_19194[(2)]);
var state_19194__$1 = (function (){var statearr_19235 = state_19194;
(statearr_19235[(28)] = inst_19187);

return statearr_19235;
})();
var statearr_19236_19308 = state_19194__$1;
(statearr_19236_19308[(2)] = null);

(statearr_19236_19308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (6))){
var inst_19126 = (state_19194[(29)]);
var inst_19125 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_19126__$1 = cljs.core.keys(inst_19125);
var inst_19127 = cljs.core.count(inst_19126__$1);
var inst_19128 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_19127) : cljs.core.reset_BANG_.call(null,dctr,inst_19127));
var inst_19133 = cljs.core.seq(inst_19126__$1);
var inst_19134 = inst_19133;
var inst_19135 = null;
var inst_19136 = (0);
var inst_19137 = (0);
var state_19194__$1 = (function (){var statearr_19237 = state_19194;
(statearr_19237[(29)] = inst_19126__$1);

(statearr_19237[(30)] = inst_19128);

(statearr_19237[(20)] = inst_19134);

(statearr_19237[(9)] = inst_19137);

(statearr_19237[(10)] = inst_19135);

(statearr_19237[(21)] = inst_19136);

return statearr_19237;
})();
var statearr_19238_19309 = state_19194__$1;
(statearr_19238_19309[(2)] = null);

(statearr_19238_19309[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (28))){
var inst_19153 = (state_19194[(25)]);
var inst_19134 = (state_19194[(20)]);
var inst_19153__$1 = cljs.core.seq(inst_19134);
var state_19194__$1 = (function (){var statearr_19239 = state_19194;
(statearr_19239[(25)] = inst_19153__$1);

return statearr_19239;
})();
if(inst_19153__$1){
var statearr_19240_19310 = state_19194__$1;
(statearr_19240_19310[(1)] = (33));

} else {
var statearr_19241_19311 = state_19194__$1;
(statearr_19241_19311[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (25))){
var inst_19137 = (state_19194[(9)]);
var inst_19136 = (state_19194[(21)]);
var inst_19139 = (inst_19137 < inst_19136);
var inst_19140 = inst_19139;
var state_19194__$1 = state_19194;
if(cljs.core.truth_(inst_19140)){
var statearr_19242_19312 = state_19194__$1;
(statearr_19242_19312[(1)] = (27));

} else {
var statearr_19243_19313 = state_19194__$1;
(statearr_19243_19313[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (34))){
var state_19194__$1 = state_19194;
var statearr_19244_19314 = state_19194__$1;
(statearr_19244_19314[(2)] = null);

(statearr_19244_19314[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (17))){
var state_19194__$1 = state_19194;
var statearr_19245_19315 = state_19194__$1;
(statearr_19245_19315[(2)] = null);

(statearr_19245_19315[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (3))){
var inst_19192 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19194__$1,inst_19192);
} else {
if((state_val_19195 === (12))){
var inst_19121 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19246_19316 = state_19194__$1;
(statearr_19246_19316[(2)] = inst_19121);

(statearr_19246_19316[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (2))){
var state_19194__$1 = state_19194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19194__$1,(4),ch);
} else {
if((state_val_19195 === (23))){
var state_19194__$1 = state_19194;
var statearr_19247_19317 = state_19194__$1;
(statearr_19247_19317[(2)] = null);

(statearr_19247_19317[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (35))){
var inst_19176 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19248_19318 = state_19194__$1;
(statearr_19248_19318[(2)] = inst_19176);

(statearr_19248_19318[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (19))){
var inst_19093 = (state_19194[(7)]);
var inst_19097 = cljs.core.chunk_first(inst_19093);
var inst_19098 = cljs.core.chunk_rest(inst_19093);
var inst_19099 = cljs.core.count(inst_19097);
var inst_19071 = inst_19098;
var inst_19072 = inst_19097;
var inst_19073 = inst_19099;
var inst_19074 = (0);
var state_19194__$1 = (function (){var statearr_19249 = state_19194;
(statearr_19249[(13)] = inst_19071);

(statearr_19249[(14)] = inst_19073);

(statearr_19249[(16)] = inst_19072);

(statearr_19249[(17)] = inst_19074);

return statearr_19249;
})();
var statearr_19250_19319 = state_19194__$1;
(statearr_19250_19319[(2)] = null);

(statearr_19250_19319[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (11))){
var inst_19071 = (state_19194[(13)]);
var inst_19093 = (state_19194[(7)]);
var inst_19093__$1 = cljs.core.seq(inst_19071);
var state_19194__$1 = (function (){var statearr_19251 = state_19194;
(statearr_19251[(7)] = inst_19093__$1);

return statearr_19251;
})();
if(inst_19093__$1){
var statearr_19252_19320 = state_19194__$1;
(statearr_19252_19320[(1)] = (16));

} else {
var statearr_19253_19321 = state_19194__$1;
(statearr_19253_19321[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (9))){
var inst_19123 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19254_19322 = state_19194__$1;
(statearr_19254_19322[(2)] = inst_19123);

(statearr_19254_19322[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (5))){
var inst_19069 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_19070 = cljs.core.seq(inst_19069);
var inst_19071 = inst_19070;
var inst_19072 = null;
var inst_19073 = (0);
var inst_19074 = (0);
var state_19194__$1 = (function (){var statearr_19255 = state_19194;
(statearr_19255[(13)] = inst_19071);

(statearr_19255[(14)] = inst_19073);

(statearr_19255[(16)] = inst_19072);

(statearr_19255[(17)] = inst_19074);

return statearr_19255;
})();
var statearr_19256_19323 = state_19194__$1;
(statearr_19256_19323[(2)] = null);

(statearr_19256_19323[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (14))){
var state_19194__$1 = state_19194;
var statearr_19257_19324 = state_19194__$1;
(statearr_19257_19324[(2)] = null);

(statearr_19257_19324[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (45))){
var inst_19184 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19258_19325 = state_19194__$1;
(statearr_19258_19325[(2)] = inst_19184);

(statearr_19258_19325[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (26))){
var inst_19126 = (state_19194[(29)]);
var inst_19180 = (state_19194[(2)]);
var inst_19181 = cljs.core.seq(inst_19126);
var state_19194__$1 = (function (){var statearr_19259 = state_19194;
(statearr_19259[(31)] = inst_19180);

return statearr_19259;
})();
if(inst_19181){
var statearr_19260_19326 = state_19194__$1;
(statearr_19260_19326[(1)] = (42));

} else {
var statearr_19261_19327 = state_19194__$1;
(statearr_19261_19327[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (16))){
var inst_19093 = (state_19194[(7)]);
var inst_19095 = cljs.core.chunked_seq_QMARK_(inst_19093);
var state_19194__$1 = state_19194;
if(inst_19095){
var statearr_19262_19328 = state_19194__$1;
(statearr_19262_19328[(1)] = (19));

} else {
var statearr_19263_19329 = state_19194__$1;
(statearr_19263_19329[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (38))){
var inst_19173 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19264_19330 = state_19194__$1;
(statearr_19264_19330[(2)] = inst_19173);

(statearr_19264_19330[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (30))){
var state_19194__$1 = state_19194;
var statearr_19265_19331 = state_19194__$1;
(statearr_19265_19331[(2)] = null);

(statearr_19265_19331[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (10))){
var inst_19072 = (state_19194[(16)]);
var inst_19074 = (state_19194[(17)]);
var inst_19082 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19072,inst_19074);
var inst_19083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19082,(0),null);
var inst_19084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19082,(1),null);
var state_19194__$1 = (function (){var statearr_19266 = state_19194;
(statearr_19266[(26)] = inst_19083);

return statearr_19266;
})();
if(cljs.core.truth_(inst_19084)){
var statearr_19267_19332 = state_19194__$1;
(statearr_19267_19332[(1)] = (13));

} else {
var statearr_19268_19333 = state_19194__$1;
(statearr_19268_19333[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (18))){
var inst_19119 = (state_19194[(2)]);
var state_19194__$1 = state_19194;
var statearr_19269_19334 = state_19194__$1;
(statearr_19269_19334[(2)] = inst_19119);

(statearr_19269_19334[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (42))){
var state_19194__$1 = state_19194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19194__$1,(45),dchan);
} else {
if((state_val_19195 === (37))){
var inst_19162 = (state_19194[(23)]);
var inst_19153 = (state_19194[(25)]);
var inst_19062 = (state_19194[(11)]);
var inst_19162__$1 = cljs.core.first(inst_19153);
var inst_19163 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_19162__$1,inst_19062,done);
var state_19194__$1 = (function (){var statearr_19270 = state_19194;
(statearr_19270[(23)] = inst_19162__$1);

return statearr_19270;
})();
if(cljs.core.truth_(inst_19163)){
var statearr_19271_19335 = state_19194__$1;
(statearr_19271_19335[(1)] = (39));

} else {
var statearr_19272_19336 = state_19194__$1;
(statearr_19272_19336[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19195 === (8))){
var inst_19073 = (state_19194[(14)]);
var inst_19074 = (state_19194[(17)]);
var inst_19076 = (inst_19074 < inst_19073);
var inst_19077 = inst_19076;
var state_19194__$1 = state_19194;
if(cljs.core.truth_(inst_19077)){
var statearr_19273_19337 = state_19194__$1;
(statearr_19273_19337[(1)] = (10));

} else {
var statearr_19274_19338 = state_19194__$1;
(statearr_19274_19338[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___19284,cs,m,dchan,dctr,done))
;
return ((function (switch__17779__auto__,c__17905__auto___19284,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17780__auto__ = null;
var cljs$core$async$mult_$_state_machine__17780__auto____0 = (function (){
var statearr_19278 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19278[(0)] = cljs$core$async$mult_$_state_machine__17780__auto__);

(statearr_19278[(1)] = (1));

return statearr_19278;
});
var cljs$core$async$mult_$_state_machine__17780__auto____1 = (function (state_19194){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_19194);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e19279){if((e19279 instanceof Object)){
var ex__17783__auto__ = e19279;
var statearr_19280_19339 = state_19194;
(statearr_19280_19339[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19194);

return cljs.core.cst$kw$recur;
} else {
throw e19279;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__19340 = state_19194;
state_19194 = G__19340;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17780__auto__ = function(state_19194){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17780__auto____1.call(this,state_19194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17780__auto____0;
cljs$core$async$mult_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17780__auto____1;
return cljs$core$async$mult_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___19284,cs,m,dchan,dctr,done))
})();
var state__17907__auto__ = (function (){var statearr_19281 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_19281[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___19284);

return statearr_19281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___19284,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args19341 = [];
var len__8435__auto___19344 = arguments.length;
var i__8436__auto___19345 = (0);
while(true){
if((i__8436__auto___19345 < len__8435__auto___19344)){
args19341.push((arguments[i__8436__auto___19345]));

var G__19346 = (i__8436__auto___19345 + (1));
i__8436__auto___19345 = G__19346;
continue;
} else {
}
break;
}

var G__19343 = args19341.length;
switch (G__19343) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19341.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto__.call(null,m,ch));
} else {
var m__7933__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto__.call(null,m,ch));
} else {
var m__7933__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7933__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7933__auto__.call(null,m));
} else {
var m__7933__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7933__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7933__auto__.call(null,m,state_map));
} else {
var m__7933__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7933__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7932__auto__ = (((m == null))?null:m);
var m__7933__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7933__auto__.call(null,m,mode));
} else {
var m__7933__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7933__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___19358 = arguments.length;
var i__8436__auto___19359 = (0);
while(true){
if((i__8436__auto___19359 < len__8435__auto___19358)){
args__8442__auto__.push((arguments[i__8436__auto___19359]));

var G__19360 = (i__8436__auto___19359 + (1));
i__8436__auto___19359 = G__19360;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((3) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8443__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__19352){
var map__19353 = p__19352;
var map__19353__$1 = ((((!((map__19353 == null)))?((((map__19353.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19353.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19353):map__19353);
var opts = map__19353__$1;
var statearr_19355_19361 = state;
(statearr_19355_19361[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts(((function (map__19353,map__19353__$1,opts){
return (function (val){
var statearr_19356_19362 = state;
(statearr_19356_19362[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__19353,map__19353__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_19357_19363 = state;
(statearr_19357_19363[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq19348){
var G__19349 = cljs.core.first(seq19348);
var seq19348__$1 = cljs.core.next(seq19348);
var G__19350 = cljs.core.first(seq19348__$1);
var seq19348__$2 = cljs.core.next(seq19348__$1);
var G__19351 = cljs.core.first(seq19348__$2);
var seq19348__$3 = cljs.core.next(seq19348__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__19349,G__19350,G__19351,seq19348__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__19535 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19535) : cljs.core.atom.call(null,G__19535));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__19536 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19536) : cljs.core.atom.call(null,G__19536));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async19537 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19537 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta19538){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta19538 = meta19538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19539,meta19538__$1){
var self__ = this;
var _19539__$1 = this;
return (new cljs.core.async.t_cljs$core$async19537(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta19538__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_19539){
var self__ = this;
var _19539__$1 = this;
return self__.meta19538;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19540_19706 = self__.cs;
var G__19541_19707 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19540_19706,G__19541_19707) : cljs.core.reset_BANG_.call(null,G__19540_19706,G__19541_19707));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta19538], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async19537.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19537.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19537";

cljs.core.async.t_cljs$core$async19537.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async19537");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async19537 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async19537(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta19538){
return (new cljs.core.async.t_cljs$core$async19537(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta19538));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async19537(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17905__auto___19708 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_19643){
var state_val_19644 = (state_19643[(1)]);
if((state_val_19644 === (7))){
var inst_19558 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
var statearr_19645_19709 = state_19643__$1;
(statearr_19645_19709[(2)] = inst_19558);

(statearr_19645_19709[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (20))){
var inst_19570 = (state_19643[(7)]);
var state_19643__$1 = state_19643;
var statearr_19646_19710 = state_19643__$1;
(statearr_19646_19710[(2)] = inst_19570);

(statearr_19646_19710[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (27))){
var state_19643__$1 = state_19643;
var statearr_19647_19711 = state_19643__$1;
(statearr_19647_19711[(2)] = null);

(statearr_19647_19711[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (1))){
var inst_19545 = (state_19643[(8)]);
var inst_19545__$1 = calc_state();
var inst_19547 = (inst_19545__$1 == null);
var inst_19548 = cljs.core.not(inst_19547);
var state_19643__$1 = (function (){var statearr_19648 = state_19643;
(statearr_19648[(8)] = inst_19545__$1);

return statearr_19648;
})();
if(inst_19548){
var statearr_19649_19712 = state_19643__$1;
(statearr_19649_19712[(1)] = (2));

} else {
var statearr_19650_19713 = state_19643__$1;
(statearr_19650_19713[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (24))){
var inst_19603 = (state_19643[(9)]);
var inst_19594 = (state_19643[(10)]);
var inst_19617 = (state_19643[(11)]);
var inst_19617__$1 = (inst_19594.cljs$core$IFn$_invoke$arity$1 ? inst_19594.cljs$core$IFn$_invoke$arity$1(inst_19603) : inst_19594.call(null,inst_19603));
var state_19643__$1 = (function (){var statearr_19651 = state_19643;
(statearr_19651[(11)] = inst_19617__$1);

return statearr_19651;
})();
if(cljs.core.truth_(inst_19617__$1)){
var statearr_19652_19714 = state_19643__$1;
(statearr_19652_19714[(1)] = (29));

} else {
var statearr_19653_19715 = state_19643__$1;
(statearr_19653_19715[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (4))){
var inst_19561 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19561)){
var statearr_19654_19716 = state_19643__$1;
(statearr_19654_19716[(1)] = (8));

} else {
var statearr_19655_19717 = state_19643__$1;
(statearr_19655_19717[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (15))){
var inst_19588 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19588)){
var statearr_19656_19718 = state_19643__$1;
(statearr_19656_19718[(1)] = (19));

} else {
var statearr_19657_19719 = state_19643__$1;
(statearr_19657_19719[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (21))){
var inst_19593 = (state_19643[(12)]);
var inst_19593__$1 = (state_19643[(2)]);
var inst_19594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19593__$1,cljs.core.cst$kw$solos);
var inst_19595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19593__$1,cljs.core.cst$kw$mutes);
var inst_19596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19593__$1,cljs.core.cst$kw$reads);
var state_19643__$1 = (function (){var statearr_19658 = state_19643;
(statearr_19658[(10)] = inst_19594);

(statearr_19658[(13)] = inst_19595);

(statearr_19658[(12)] = inst_19593__$1);

return statearr_19658;
})();
return cljs.core.async.ioc_alts_BANG_(state_19643__$1,(22),inst_19596);
} else {
if((state_val_19644 === (31))){
var inst_19625 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19625)){
var statearr_19659_19720 = state_19643__$1;
(statearr_19659_19720[(1)] = (32));

} else {
var statearr_19660_19721 = state_19643__$1;
(statearr_19660_19721[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (32))){
var inst_19602 = (state_19643[(14)]);
var state_19643__$1 = state_19643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19643__$1,(35),out,inst_19602);
} else {
if((state_val_19644 === (33))){
var inst_19593 = (state_19643[(12)]);
var inst_19570 = inst_19593;
var state_19643__$1 = (function (){var statearr_19661 = state_19643;
(statearr_19661[(7)] = inst_19570);

return statearr_19661;
})();
var statearr_19662_19722 = state_19643__$1;
(statearr_19662_19722[(2)] = null);

(statearr_19662_19722[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (13))){
var inst_19570 = (state_19643[(7)]);
var inst_19577 = inst_19570.cljs$lang$protocol_mask$partition0$;
var inst_19578 = (inst_19577 & (64));
var inst_19579 = inst_19570.cljs$core$ISeq$;
var inst_19580 = (cljs.core.PROTOCOL_SENTINEL === inst_19579);
var inst_19581 = (inst_19578) || (inst_19580);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19581)){
var statearr_19663_19723 = state_19643__$1;
(statearr_19663_19723[(1)] = (16));

} else {
var statearr_19664_19724 = state_19643__$1;
(statearr_19664_19724[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (22))){
var inst_19603 = (state_19643[(9)]);
var inst_19602 = (state_19643[(14)]);
var inst_19601 = (state_19643[(2)]);
var inst_19602__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19601,(0),null);
var inst_19603__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19601,(1),null);
var inst_19604 = (inst_19602__$1 == null);
var inst_19605 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19603__$1,change);
var inst_19606 = (inst_19604) || (inst_19605);
var state_19643__$1 = (function (){var statearr_19665 = state_19643;
(statearr_19665[(9)] = inst_19603__$1);

(statearr_19665[(14)] = inst_19602__$1);

return statearr_19665;
})();
if(cljs.core.truth_(inst_19606)){
var statearr_19666_19725 = state_19643__$1;
(statearr_19666_19725[(1)] = (23));

} else {
var statearr_19667_19726 = state_19643__$1;
(statearr_19667_19726[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (36))){
var inst_19593 = (state_19643[(12)]);
var inst_19570 = inst_19593;
var state_19643__$1 = (function (){var statearr_19668 = state_19643;
(statearr_19668[(7)] = inst_19570);

return statearr_19668;
})();
var statearr_19669_19727 = state_19643__$1;
(statearr_19669_19727[(2)] = null);

(statearr_19669_19727[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (29))){
var inst_19617 = (state_19643[(11)]);
var state_19643__$1 = state_19643;
var statearr_19670_19728 = state_19643__$1;
(statearr_19670_19728[(2)] = inst_19617);

(statearr_19670_19728[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (6))){
var state_19643__$1 = state_19643;
var statearr_19671_19729 = state_19643__$1;
(statearr_19671_19729[(2)] = false);

(statearr_19671_19729[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (28))){
var inst_19613 = (state_19643[(2)]);
var inst_19614 = calc_state();
var inst_19570 = inst_19614;
var state_19643__$1 = (function (){var statearr_19672 = state_19643;
(statearr_19672[(7)] = inst_19570);

(statearr_19672[(15)] = inst_19613);

return statearr_19672;
})();
var statearr_19673_19730 = state_19643__$1;
(statearr_19673_19730[(2)] = null);

(statearr_19673_19730[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (25))){
var inst_19639 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
var statearr_19674_19731 = state_19643__$1;
(statearr_19674_19731[(2)] = inst_19639);

(statearr_19674_19731[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (34))){
var inst_19637 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
var statearr_19675_19732 = state_19643__$1;
(statearr_19675_19732[(2)] = inst_19637);

(statearr_19675_19732[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (17))){
var state_19643__$1 = state_19643;
var statearr_19676_19733 = state_19643__$1;
(statearr_19676_19733[(2)] = false);

(statearr_19676_19733[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (3))){
var state_19643__$1 = state_19643;
var statearr_19677_19734 = state_19643__$1;
(statearr_19677_19734[(2)] = false);

(statearr_19677_19734[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (12))){
var inst_19641 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19643__$1,inst_19641);
} else {
if((state_val_19644 === (2))){
var inst_19545 = (state_19643[(8)]);
var inst_19550 = inst_19545.cljs$lang$protocol_mask$partition0$;
var inst_19551 = (inst_19550 & (64));
var inst_19552 = inst_19545.cljs$core$ISeq$;
var inst_19553 = (cljs.core.PROTOCOL_SENTINEL === inst_19552);
var inst_19554 = (inst_19551) || (inst_19553);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19554)){
var statearr_19678_19735 = state_19643__$1;
(statearr_19678_19735[(1)] = (5));

} else {
var statearr_19679_19736 = state_19643__$1;
(statearr_19679_19736[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (23))){
var inst_19602 = (state_19643[(14)]);
var inst_19608 = (inst_19602 == null);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19608)){
var statearr_19680_19737 = state_19643__$1;
(statearr_19680_19737[(1)] = (26));

} else {
var statearr_19681_19738 = state_19643__$1;
(statearr_19681_19738[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (35))){
var inst_19628 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
if(cljs.core.truth_(inst_19628)){
var statearr_19682_19739 = state_19643__$1;
(statearr_19682_19739[(1)] = (36));

} else {
var statearr_19683_19740 = state_19643__$1;
(statearr_19683_19740[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (19))){
var inst_19570 = (state_19643[(7)]);
var inst_19590 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19570);
var state_19643__$1 = state_19643;
var statearr_19684_19741 = state_19643__$1;
(statearr_19684_19741[(2)] = inst_19590);

(statearr_19684_19741[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (11))){
var inst_19570 = (state_19643[(7)]);
var inst_19574 = (inst_19570 == null);
var inst_19575 = cljs.core.not(inst_19574);
var state_19643__$1 = state_19643;
if(inst_19575){
var statearr_19685_19742 = state_19643__$1;
(statearr_19685_19742[(1)] = (13));

} else {
var statearr_19686_19743 = state_19643__$1;
(statearr_19686_19743[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (9))){
var inst_19545 = (state_19643[(8)]);
var state_19643__$1 = state_19643;
var statearr_19687_19744 = state_19643__$1;
(statearr_19687_19744[(2)] = inst_19545);

(statearr_19687_19744[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (5))){
var state_19643__$1 = state_19643;
var statearr_19688_19745 = state_19643__$1;
(statearr_19688_19745[(2)] = true);

(statearr_19688_19745[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (14))){
var state_19643__$1 = state_19643;
var statearr_19689_19746 = state_19643__$1;
(statearr_19689_19746[(2)] = false);

(statearr_19689_19746[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (26))){
var inst_19603 = (state_19643[(9)]);
var inst_19610 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_19603);
var state_19643__$1 = state_19643;
var statearr_19690_19747 = state_19643__$1;
(statearr_19690_19747[(2)] = inst_19610);

(statearr_19690_19747[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (16))){
var state_19643__$1 = state_19643;
var statearr_19691_19748 = state_19643__$1;
(statearr_19691_19748[(2)] = true);

(statearr_19691_19748[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (38))){
var inst_19633 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
var statearr_19692_19749 = state_19643__$1;
(statearr_19692_19749[(2)] = inst_19633);

(statearr_19692_19749[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (30))){
var inst_19603 = (state_19643[(9)]);
var inst_19594 = (state_19643[(10)]);
var inst_19595 = (state_19643[(13)]);
var inst_19620 = cljs.core.empty_QMARK_(inst_19594);
var inst_19621 = (inst_19595.cljs$core$IFn$_invoke$arity$1 ? inst_19595.cljs$core$IFn$_invoke$arity$1(inst_19603) : inst_19595.call(null,inst_19603));
var inst_19622 = cljs.core.not(inst_19621);
var inst_19623 = (inst_19620) && (inst_19622);
var state_19643__$1 = state_19643;
var statearr_19693_19750 = state_19643__$1;
(statearr_19693_19750[(2)] = inst_19623);

(statearr_19693_19750[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (10))){
var inst_19545 = (state_19643[(8)]);
var inst_19566 = (state_19643[(2)]);
var inst_19567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19566,cljs.core.cst$kw$solos);
var inst_19568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19566,cljs.core.cst$kw$mutes);
var inst_19569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19566,cljs.core.cst$kw$reads);
var inst_19570 = inst_19545;
var state_19643__$1 = (function (){var statearr_19694 = state_19643;
(statearr_19694[(16)] = inst_19568);

(statearr_19694[(7)] = inst_19570);

(statearr_19694[(17)] = inst_19567);

(statearr_19694[(18)] = inst_19569);

return statearr_19694;
})();
var statearr_19695_19751 = state_19643__$1;
(statearr_19695_19751[(2)] = null);

(statearr_19695_19751[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (18))){
var inst_19585 = (state_19643[(2)]);
var state_19643__$1 = state_19643;
var statearr_19696_19752 = state_19643__$1;
(statearr_19696_19752[(2)] = inst_19585);

(statearr_19696_19752[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (37))){
var state_19643__$1 = state_19643;
var statearr_19697_19753 = state_19643__$1;
(statearr_19697_19753[(2)] = null);

(statearr_19697_19753[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19644 === (8))){
var inst_19545 = (state_19643[(8)]);
var inst_19563 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_19545);
var state_19643__$1 = state_19643;
var statearr_19698_19754 = state_19643__$1;
(statearr_19698_19754[(2)] = inst_19563);

(statearr_19698_19754[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17779__auto__,c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17780__auto__ = null;
var cljs$core$async$mix_$_state_machine__17780__auto____0 = (function (){
var statearr_19702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19702[(0)] = cljs$core$async$mix_$_state_machine__17780__auto__);

(statearr_19702[(1)] = (1));

return statearr_19702;
});
var cljs$core$async$mix_$_state_machine__17780__auto____1 = (function (state_19643){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_19643);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e19703){if((e19703 instanceof Object)){
var ex__17783__auto__ = e19703;
var statearr_19704_19755 = state_19643;
(statearr_19704_19755[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19643);

return cljs.core.cst$kw$recur;
} else {
throw e19703;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__19756 = state_19643;
state_19643 = G__19756;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17780__auto__ = function(state_19643){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17780__auto____1.call(this,state_19643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17780__auto____0;
cljs$core$async$mix_$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17780__auto____1;
return cljs$core$async$mix_$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__17907__auto__ = (function (){var statearr_19705 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_19705[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___19708);

return statearr_19705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___19708,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7932__auto__ = (((p == null))?null:p);
var m__7933__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7933__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7933__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7933__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7932__auto__ = (((p == null))?null:p);
var m__7933__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7933__auto__.call(null,p,v,ch));
} else {
var m__7933__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7933__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args19757 = [];
var len__8435__auto___19760 = arguments.length;
var i__8436__auto___19761 = (0);
while(true){
if((i__8436__auto___19761 < len__8435__auto___19760)){
args19757.push((arguments[i__8436__auto___19761]));

var G__19762 = (i__8436__auto___19761 + (1));
i__8436__auto___19761 = G__19762;
continue;
} else {
}
break;
}

var G__19759 = args19757.length;
switch (G__19759) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19757.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7932__auto__ = (((p == null))?null:p);
var m__7933__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7933__auto__.call(null,p));
} else {
var m__7933__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7933__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7932__auto__ = (((p == null))?null:p);
var m__7933__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7932__auto__)]);
if(!((m__7933__auto__ == null))){
return (m__7933__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7933__auto__.call(null,p,v));
} else {
var m__7933__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7933__auto____$1 == null))){
return (m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7933__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7933__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args19765 = [];
var len__8435__auto___19893 = arguments.length;
var i__8436__auto___19894 = (0);
while(true){
if((i__8436__auto___19894 < len__8435__auto___19893)){
args19765.push((arguments[i__8436__auto___19894]));

var G__19895 = (i__8436__auto___19894 + (1));
i__8436__auto___19894 = G__19895;
continue;
} else {
}
break;
}

var G__19767 = args19765.length;
switch (G__19767) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19765.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__19768 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__19768) : cljs.core.atom.call(null,G__19768));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7219__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7219__auto__,mults){
return (function (p1__19764_SHARP_){
if(cljs.core.truth_((p1__19764_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__19764_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__19764_SHARP_.call(null,topic)))){
return p1__19764_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19764_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7219__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async19769 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async19769 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta19770){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta19770 = meta19770;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_19771,meta19770__$1){
var self__ = this;
var _19771__$1 = this;
return (new cljs.core.async.t_cljs$core$async19769(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta19770__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_19771){
var self__ = this;
var _19771__$1 = this;
return self__.meta19770;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__19772 = self__.mults;
var G__19773 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__19772,G__19773) : cljs.core.reset_BANG_.call(null,G__19772,G__19773));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta19770], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async19769.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async19769.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async19769";

cljs.core.async.t_cljs$core$async19769.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async19769");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async19769 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async19769(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19770){
return (new cljs.core.async.t_cljs$core$async19769(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta19770));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async19769(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17905__auto___19897 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___19897,mults,ensure_mult,p){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___19897,mults,ensure_mult,p){
return (function (state_19845){
var state_val_19846 = (state_19845[(1)]);
if((state_val_19846 === (7))){
var inst_19841 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19847_19898 = state_19845__$1;
(statearr_19847_19898[(2)] = inst_19841);

(statearr_19847_19898[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (20))){
var state_19845__$1 = state_19845;
var statearr_19848_19899 = state_19845__$1;
(statearr_19848_19899[(2)] = null);

(statearr_19848_19899[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (1))){
var state_19845__$1 = state_19845;
var statearr_19849_19900 = state_19845__$1;
(statearr_19849_19900[(2)] = null);

(statearr_19849_19900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (24))){
var inst_19824 = (state_19845[(7)]);
var inst_19833 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_19824);
var state_19845__$1 = state_19845;
var statearr_19850_19901 = state_19845__$1;
(statearr_19850_19901[(2)] = inst_19833);

(statearr_19850_19901[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (4))){
var inst_19776 = (state_19845[(8)]);
var inst_19776__$1 = (state_19845[(2)]);
var inst_19777 = (inst_19776__$1 == null);
var state_19845__$1 = (function (){var statearr_19851 = state_19845;
(statearr_19851[(8)] = inst_19776__$1);

return statearr_19851;
})();
if(cljs.core.truth_(inst_19777)){
var statearr_19852_19902 = state_19845__$1;
(statearr_19852_19902[(1)] = (5));

} else {
var statearr_19853_19903 = state_19845__$1;
(statearr_19853_19903[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (15))){
var inst_19818 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19854_19904 = state_19845__$1;
(statearr_19854_19904[(2)] = inst_19818);

(statearr_19854_19904[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (21))){
var inst_19838 = (state_19845[(2)]);
var state_19845__$1 = (function (){var statearr_19855 = state_19845;
(statearr_19855[(9)] = inst_19838);

return statearr_19855;
})();
var statearr_19856_19905 = state_19845__$1;
(statearr_19856_19905[(2)] = null);

(statearr_19856_19905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (13))){
var inst_19800 = (state_19845[(10)]);
var inst_19802 = cljs.core.chunked_seq_QMARK_(inst_19800);
var state_19845__$1 = state_19845;
if(inst_19802){
var statearr_19857_19906 = state_19845__$1;
(statearr_19857_19906[(1)] = (16));

} else {
var statearr_19858_19907 = state_19845__$1;
(statearr_19858_19907[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (22))){
var inst_19830 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
if(cljs.core.truth_(inst_19830)){
var statearr_19859_19908 = state_19845__$1;
(statearr_19859_19908[(1)] = (23));

} else {
var statearr_19860_19909 = state_19845__$1;
(statearr_19860_19909[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (6))){
var inst_19826 = (state_19845[(11)]);
var inst_19776 = (state_19845[(8)]);
var inst_19824 = (state_19845[(7)]);
var inst_19824__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_19776) : topic_fn.call(null,inst_19776));
var inst_19825 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19826__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_19825,inst_19824__$1);
var state_19845__$1 = (function (){var statearr_19861 = state_19845;
(statearr_19861[(11)] = inst_19826__$1);

(statearr_19861[(7)] = inst_19824__$1);

return statearr_19861;
})();
if(cljs.core.truth_(inst_19826__$1)){
var statearr_19862_19910 = state_19845__$1;
(statearr_19862_19910[(1)] = (19));

} else {
var statearr_19863_19911 = state_19845__$1;
(statearr_19863_19911[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (25))){
var inst_19835 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19864_19912 = state_19845__$1;
(statearr_19864_19912[(2)] = inst_19835);

(statearr_19864_19912[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (17))){
var inst_19800 = (state_19845[(10)]);
var inst_19809 = cljs.core.first(inst_19800);
var inst_19810 = cljs.core.async.muxch_STAR_(inst_19809);
var inst_19811 = cljs.core.async.close_BANG_(inst_19810);
var inst_19812 = cljs.core.next(inst_19800);
var inst_19786 = inst_19812;
var inst_19787 = null;
var inst_19788 = (0);
var inst_19789 = (0);
var state_19845__$1 = (function (){var statearr_19865 = state_19845;
(statearr_19865[(12)] = inst_19788);

(statearr_19865[(13)] = inst_19787);

(statearr_19865[(14)] = inst_19786);

(statearr_19865[(15)] = inst_19789);

(statearr_19865[(16)] = inst_19811);

return statearr_19865;
})();
var statearr_19866_19913 = state_19845__$1;
(statearr_19866_19913[(2)] = null);

(statearr_19866_19913[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (3))){
var inst_19843 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19845__$1,inst_19843);
} else {
if((state_val_19846 === (12))){
var inst_19820 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19867_19914 = state_19845__$1;
(statearr_19867_19914[(2)] = inst_19820);

(statearr_19867_19914[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (2))){
var state_19845__$1 = state_19845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19845__$1,(4),ch);
} else {
if((state_val_19846 === (23))){
var state_19845__$1 = state_19845;
var statearr_19868_19915 = state_19845__$1;
(statearr_19868_19915[(2)] = null);

(statearr_19868_19915[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (19))){
var inst_19826 = (state_19845[(11)]);
var inst_19776 = (state_19845[(8)]);
var inst_19828 = cljs.core.async.muxch_STAR_(inst_19826);
var state_19845__$1 = state_19845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19845__$1,(22),inst_19828,inst_19776);
} else {
if((state_val_19846 === (11))){
var inst_19800 = (state_19845[(10)]);
var inst_19786 = (state_19845[(14)]);
var inst_19800__$1 = cljs.core.seq(inst_19786);
var state_19845__$1 = (function (){var statearr_19869 = state_19845;
(statearr_19869[(10)] = inst_19800__$1);

return statearr_19869;
})();
if(inst_19800__$1){
var statearr_19870_19916 = state_19845__$1;
(statearr_19870_19916[(1)] = (13));

} else {
var statearr_19871_19917 = state_19845__$1;
(statearr_19871_19917[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (9))){
var inst_19822 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19872_19918 = state_19845__$1;
(statearr_19872_19918[(2)] = inst_19822);

(statearr_19872_19918[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (5))){
var inst_19783 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_19784 = cljs.core.vals(inst_19783);
var inst_19785 = cljs.core.seq(inst_19784);
var inst_19786 = inst_19785;
var inst_19787 = null;
var inst_19788 = (0);
var inst_19789 = (0);
var state_19845__$1 = (function (){var statearr_19873 = state_19845;
(statearr_19873[(12)] = inst_19788);

(statearr_19873[(13)] = inst_19787);

(statearr_19873[(14)] = inst_19786);

(statearr_19873[(15)] = inst_19789);

return statearr_19873;
})();
var statearr_19874_19919 = state_19845__$1;
(statearr_19874_19919[(2)] = null);

(statearr_19874_19919[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (14))){
var state_19845__$1 = state_19845;
var statearr_19878_19920 = state_19845__$1;
(statearr_19878_19920[(2)] = null);

(statearr_19878_19920[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (16))){
var inst_19800 = (state_19845[(10)]);
var inst_19804 = cljs.core.chunk_first(inst_19800);
var inst_19805 = cljs.core.chunk_rest(inst_19800);
var inst_19806 = cljs.core.count(inst_19804);
var inst_19786 = inst_19805;
var inst_19787 = inst_19804;
var inst_19788 = inst_19806;
var inst_19789 = (0);
var state_19845__$1 = (function (){var statearr_19879 = state_19845;
(statearr_19879[(12)] = inst_19788);

(statearr_19879[(13)] = inst_19787);

(statearr_19879[(14)] = inst_19786);

(statearr_19879[(15)] = inst_19789);

return statearr_19879;
})();
var statearr_19880_19921 = state_19845__$1;
(statearr_19880_19921[(2)] = null);

(statearr_19880_19921[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (10))){
var inst_19788 = (state_19845[(12)]);
var inst_19787 = (state_19845[(13)]);
var inst_19786 = (state_19845[(14)]);
var inst_19789 = (state_19845[(15)]);
var inst_19794 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_19787,inst_19789);
var inst_19795 = cljs.core.async.muxch_STAR_(inst_19794);
var inst_19796 = cljs.core.async.close_BANG_(inst_19795);
var inst_19797 = (inst_19789 + (1));
var tmp19875 = inst_19788;
var tmp19876 = inst_19787;
var tmp19877 = inst_19786;
var inst_19786__$1 = tmp19877;
var inst_19787__$1 = tmp19876;
var inst_19788__$1 = tmp19875;
var inst_19789__$1 = inst_19797;
var state_19845__$1 = (function (){var statearr_19881 = state_19845;
(statearr_19881[(12)] = inst_19788__$1);

(statearr_19881[(13)] = inst_19787__$1);

(statearr_19881[(17)] = inst_19796);

(statearr_19881[(14)] = inst_19786__$1);

(statearr_19881[(15)] = inst_19789__$1);

return statearr_19881;
})();
var statearr_19882_19922 = state_19845__$1;
(statearr_19882_19922[(2)] = null);

(statearr_19882_19922[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (18))){
var inst_19815 = (state_19845[(2)]);
var state_19845__$1 = state_19845;
var statearr_19883_19923 = state_19845__$1;
(statearr_19883_19923[(2)] = inst_19815);

(statearr_19883_19923[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19846 === (8))){
var inst_19788 = (state_19845[(12)]);
var inst_19789 = (state_19845[(15)]);
var inst_19791 = (inst_19789 < inst_19788);
var inst_19792 = inst_19791;
var state_19845__$1 = state_19845;
if(cljs.core.truth_(inst_19792)){
var statearr_19884_19924 = state_19845__$1;
(statearr_19884_19924[(1)] = (10));

} else {
var statearr_19885_19925 = state_19845__$1;
(statearr_19885_19925[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___19897,mults,ensure_mult,p))
;
return ((function (switch__17779__auto__,c__17905__auto___19897,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_19889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19889[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_19889[(1)] = (1));

return statearr_19889;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_19845){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_19845);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e19890){if((e19890 instanceof Object)){
var ex__17783__auto__ = e19890;
var statearr_19891_19926 = state_19845;
(statearr_19891_19926[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19845);

return cljs.core.cst$kw$recur;
} else {
throw e19890;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__19927 = state_19845;
state_19845 = G__19927;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_19845){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_19845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___19897,mults,ensure_mult,p))
})();
var state__17907__auto__ = (function (){var statearr_19892 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_19892[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___19897);

return statearr_19892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___19897,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args19928 = [];
var len__8435__auto___19931 = arguments.length;
var i__8436__auto___19932 = (0);
while(true){
if((i__8436__auto___19932 < len__8435__auto___19931)){
args19928.push((arguments[i__8436__auto___19932]));

var G__19933 = (i__8436__auto___19932 + (1));
i__8436__auto___19932 = G__19933;
continue;
} else {
}
break;
}

var G__19930 = args19928.length;
switch (G__19930) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19928.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args19935 = [];
var len__8435__auto___19938 = arguments.length;
var i__8436__auto___19939 = (0);
while(true){
if((i__8436__auto___19939 < len__8435__auto___19938)){
args19935.push((arguments[i__8436__auto___19939]));

var G__19940 = (i__8436__auto___19939 + (1));
i__8436__auto___19939 = G__19940;
continue;
} else {
}
break;
}

var G__19937 = args19935.length;
switch (G__19937) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19935.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args19942 = [];
var len__8435__auto___20013 = arguments.length;
var i__8436__auto___20014 = (0);
while(true){
if((i__8436__auto___20014 < len__8435__auto___20013)){
args19942.push((arguments[i__8436__auto___20014]));

var G__20015 = (i__8436__auto___20014 + (1));
i__8436__auto___20014 = G__20015;
continue;
} else {
}
break;
}

var G__19944 = args19942.length;
switch (G__19944) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19942.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17905__auto___20017 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_19983){
var state_val_19984 = (state_19983[(1)]);
if((state_val_19984 === (7))){
var state_19983__$1 = state_19983;
var statearr_19985_20018 = state_19983__$1;
(statearr_19985_20018[(2)] = null);

(statearr_19985_20018[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (1))){
var state_19983__$1 = state_19983;
var statearr_19986_20019 = state_19983__$1;
(statearr_19986_20019[(2)] = null);

(statearr_19986_20019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (4))){
var inst_19947 = (state_19983[(7)]);
var inst_19949 = (inst_19947 < cnt);
var state_19983__$1 = state_19983;
if(cljs.core.truth_(inst_19949)){
var statearr_19987_20020 = state_19983__$1;
(statearr_19987_20020[(1)] = (6));

} else {
var statearr_19988_20021 = state_19983__$1;
(statearr_19988_20021[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (15))){
var inst_19979 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
var statearr_19989_20022 = state_19983__$1;
(statearr_19989_20022[(2)] = inst_19979);

(statearr_19989_20022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (13))){
var inst_19972 = cljs.core.async.close_BANG_(out);
var state_19983__$1 = state_19983;
var statearr_19990_20023 = state_19983__$1;
(statearr_19990_20023[(2)] = inst_19972);

(statearr_19990_20023[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (6))){
var state_19983__$1 = state_19983;
var statearr_19991_20024 = state_19983__$1;
(statearr_19991_20024[(2)] = null);

(statearr_19991_20024[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (3))){
var inst_19981 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19983__$1,inst_19981);
} else {
if((state_val_19984 === (12))){
var inst_19969 = (state_19983[(8)]);
var inst_19969__$1 = (state_19983[(2)]);
var inst_19970 = cljs.core.some(cljs.core.nil_QMARK_,inst_19969__$1);
var state_19983__$1 = (function (){var statearr_19992 = state_19983;
(statearr_19992[(8)] = inst_19969__$1);

return statearr_19992;
})();
if(cljs.core.truth_(inst_19970)){
var statearr_19993_20025 = state_19983__$1;
(statearr_19993_20025[(1)] = (13));

} else {
var statearr_19994_20026 = state_19983__$1;
(statearr_19994_20026[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (2))){
var inst_19946 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_19947 = (0);
var state_19983__$1 = (function (){var statearr_19995 = state_19983;
(statearr_19995[(7)] = inst_19947);

(statearr_19995[(9)] = inst_19946);

return statearr_19995;
})();
var statearr_19996_20027 = state_19983__$1;
(statearr_19996_20027[(2)] = null);

(statearr_19996_20027[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (11))){
var inst_19947 = (state_19983[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_19983,(10),Object,null,(9));
var inst_19956 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_19947) : chs__$1.call(null,inst_19947));
var inst_19957 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_19947) : done.call(null,inst_19947));
var inst_19958 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19956,inst_19957);
var state_19983__$1 = state_19983;
var statearr_19997_20028 = state_19983__$1;
(statearr_19997_20028[(2)] = inst_19958);


cljs.core.async.impl.ioc_helpers.process_exception(state_19983__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (9))){
var inst_19947 = (state_19983[(7)]);
var inst_19960 = (state_19983[(2)]);
var inst_19961 = (inst_19947 + (1));
var inst_19947__$1 = inst_19961;
var state_19983__$1 = (function (){var statearr_19998 = state_19983;
(statearr_19998[(7)] = inst_19947__$1);

(statearr_19998[(10)] = inst_19960);

return statearr_19998;
})();
var statearr_19999_20029 = state_19983__$1;
(statearr_19999_20029[(2)] = null);

(statearr_19999_20029[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (5))){
var inst_19967 = (state_19983[(2)]);
var state_19983__$1 = (function (){var statearr_20000 = state_19983;
(statearr_20000[(11)] = inst_19967);

return statearr_20000;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19983__$1,(12),dchan);
} else {
if((state_val_19984 === (14))){
var inst_19969 = (state_19983[(8)]);
var inst_19974 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_19969);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19983__$1,(16),out,inst_19974);
} else {
if((state_val_19984 === (16))){
var inst_19976 = (state_19983[(2)]);
var state_19983__$1 = (function (){var statearr_20001 = state_19983;
(statearr_20001[(12)] = inst_19976);

return statearr_20001;
})();
var statearr_20002_20030 = state_19983__$1;
(statearr_20002_20030[(2)] = null);

(statearr_20002_20030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (10))){
var inst_19951 = (state_19983[(2)]);
var inst_19952 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_19983__$1 = (function (){var statearr_20003 = state_19983;
(statearr_20003[(13)] = inst_19951);

return statearr_20003;
})();
var statearr_20004_20031 = state_19983__$1;
(statearr_20004_20031[(2)] = inst_19952);


cljs.core.async.impl.ioc_helpers.process_exception(state_19983__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_19984 === (8))){
var inst_19965 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
var statearr_20005_20032 = state_19983__$1;
(statearr_20005_20032[(2)] = inst_19965);

(statearr_20005_20032[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17779__auto__,c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20009 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20009[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20009[(1)] = (1));

return statearr_20009;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_19983){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_19983);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20010){if((e20010 instanceof Object)){
var ex__17783__auto__ = e20010;
var statearr_20011_20033 = state_19983;
(statearr_20011_20033[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19983);

return cljs.core.cst$kw$recur;
} else {
throw e20010;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20034 = state_19983;
state_19983 = G__20034;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_19983){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_19983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__17907__auto__ = (function (){var statearr_20012 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20012[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20017);

return statearr_20012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20017,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args20036 = [];
var len__8435__auto___20094 = arguments.length;
var i__8436__auto___20095 = (0);
while(true){
if((i__8436__auto___20095 < len__8435__auto___20094)){
args20036.push((arguments[i__8436__auto___20095]));

var G__20096 = (i__8436__auto___20095 + (1));
i__8436__auto___20095 = G__20096;
continue;
} else {
}
break;
}

var G__20038 = args20036.length;
switch (G__20038) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20036.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20098,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20098,out){
return (function (state_20070){
var state_val_20071 = (state_20070[(1)]);
if((state_val_20071 === (7))){
var inst_20049 = (state_20070[(7)]);
var inst_20050 = (state_20070[(8)]);
var inst_20049__$1 = (state_20070[(2)]);
var inst_20050__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20049__$1,(0),null);
var inst_20051 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20049__$1,(1),null);
var inst_20052 = (inst_20050__$1 == null);
var state_20070__$1 = (function (){var statearr_20072 = state_20070;
(statearr_20072[(7)] = inst_20049__$1);

(statearr_20072[(9)] = inst_20051);

(statearr_20072[(8)] = inst_20050__$1);

return statearr_20072;
})();
if(cljs.core.truth_(inst_20052)){
var statearr_20073_20099 = state_20070__$1;
(statearr_20073_20099[(1)] = (8));

} else {
var statearr_20074_20100 = state_20070__$1;
(statearr_20074_20100[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (1))){
var inst_20039 = cljs.core.vec(chs);
var inst_20040 = inst_20039;
var state_20070__$1 = (function (){var statearr_20075 = state_20070;
(statearr_20075[(10)] = inst_20040);

return statearr_20075;
})();
var statearr_20076_20101 = state_20070__$1;
(statearr_20076_20101[(2)] = null);

(statearr_20076_20101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (4))){
var inst_20040 = (state_20070[(10)]);
var state_20070__$1 = state_20070;
return cljs.core.async.ioc_alts_BANG_(state_20070__$1,(7),inst_20040);
} else {
if((state_val_20071 === (6))){
var inst_20066 = (state_20070[(2)]);
var state_20070__$1 = state_20070;
var statearr_20077_20102 = state_20070__$1;
(statearr_20077_20102[(2)] = inst_20066);

(statearr_20077_20102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (3))){
var inst_20068 = (state_20070[(2)]);
var state_20070__$1 = state_20070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20070__$1,inst_20068);
} else {
if((state_val_20071 === (2))){
var inst_20040 = (state_20070[(10)]);
var inst_20042 = cljs.core.count(inst_20040);
var inst_20043 = (inst_20042 > (0));
var state_20070__$1 = state_20070;
if(cljs.core.truth_(inst_20043)){
var statearr_20079_20103 = state_20070__$1;
(statearr_20079_20103[(1)] = (4));

} else {
var statearr_20080_20104 = state_20070__$1;
(statearr_20080_20104[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (11))){
var inst_20040 = (state_20070[(10)]);
var inst_20059 = (state_20070[(2)]);
var tmp20078 = inst_20040;
var inst_20040__$1 = tmp20078;
var state_20070__$1 = (function (){var statearr_20081 = state_20070;
(statearr_20081[(10)] = inst_20040__$1);

(statearr_20081[(11)] = inst_20059);

return statearr_20081;
})();
var statearr_20082_20105 = state_20070__$1;
(statearr_20082_20105[(2)] = null);

(statearr_20082_20105[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (9))){
var inst_20050 = (state_20070[(8)]);
var state_20070__$1 = state_20070;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20070__$1,(11),out,inst_20050);
} else {
if((state_val_20071 === (5))){
var inst_20064 = cljs.core.async.close_BANG_(out);
var state_20070__$1 = state_20070;
var statearr_20083_20106 = state_20070__$1;
(statearr_20083_20106[(2)] = inst_20064);

(statearr_20083_20106[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (10))){
var inst_20062 = (state_20070[(2)]);
var state_20070__$1 = state_20070;
var statearr_20084_20107 = state_20070__$1;
(statearr_20084_20107[(2)] = inst_20062);

(statearr_20084_20107[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20071 === (8))){
var inst_20049 = (state_20070[(7)]);
var inst_20040 = (state_20070[(10)]);
var inst_20051 = (state_20070[(9)]);
var inst_20050 = (state_20070[(8)]);
var inst_20054 = (function (){var cs = inst_20040;
var vec__20045 = inst_20049;
var v = inst_20050;
var c = inst_20051;
return ((function (cs,vec__20045,v,c,inst_20049,inst_20040,inst_20051,inst_20050,state_val_20071,c__17905__auto___20098,out){
return (function (p1__20035_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__20035_SHARP_);
});
;})(cs,vec__20045,v,c,inst_20049,inst_20040,inst_20051,inst_20050,state_val_20071,c__17905__auto___20098,out))
})();
var inst_20055 = cljs.core.filterv(inst_20054,inst_20040);
var inst_20040__$1 = inst_20055;
var state_20070__$1 = (function (){var statearr_20085 = state_20070;
(statearr_20085[(10)] = inst_20040__$1);

return statearr_20085;
})();
var statearr_20086_20108 = state_20070__$1;
(statearr_20086_20108[(2)] = null);

(statearr_20086_20108[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20098,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20098,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20090 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20090[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20090[(1)] = (1));

return statearr_20090;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20070){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20070);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20091){if((e20091 instanceof Object)){
var ex__17783__auto__ = e20091;
var statearr_20092_20109 = state_20070;
(statearr_20092_20109[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20070);

return cljs.core.cst$kw$recur;
} else {
throw e20091;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20110 = state_20070;
state_20070 = G__20110;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20070){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20098,out))
})();
var state__17907__auto__ = (function (){var statearr_20093 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20093[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20098);

return statearr_20093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20098,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args20111 = [];
var len__8435__auto___20160 = arguments.length;
var i__8436__auto___20161 = (0);
while(true){
if((i__8436__auto___20161 < len__8435__auto___20160)){
args20111.push((arguments[i__8436__auto___20161]));

var G__20162 = (i__8436__auto___20161 + (1));
i__8436__auto___20161 = G__20162;
continue;
} else {
}
break;
}

var G__20113 = args20111.length;
switch (G__20113) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20111.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20164 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20164,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20164,out){
return (function (state_20137){
var state_val_20138 = (state_20137[(1)]);
if((state_val_20138 === (7))){
var inst_20119 = (state_20137[(7)]);
var inst_20119__$1 = (state_20137[(2)]);
var inst_20120 = (inst_20119__$1 == null);
var inst_20121 = cljs.core.not(inst_20120);
var state_20137__$1 = (function (){var statearr_20139 = state_20137;
(statearr_20139[(7)] = inst_20119__$1);

return statearr_20139;
})();
if(inst_20121){
var statearr_20140_20165 = state_20137__$1;
(statearr_20140_20165[(1)] = (8));

} else {
var statearr_20141_20166 = state_20137__$1;
(statearr_20141_20166[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (1))){
var inst_20114 = (0);
var state_20137__$1 = (function (){var statearr_20142 = state_20137;
(statearr_20142[(8)] = inst_20114);

return statearr_20142;
})();
var statearr_20143_20167 = state_20137__$1;
(statearr_20143_20167[(2)] = null);

(statearr_20143_20167[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (4))){
var state_20137__$1 = state_20137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20137__$1,(7),ch);
} else {
if((state_val_20138 === (6))){
var inst_20132 = (state_20137[(2)]);
var state_20137__$1 = state_20137;
var statearr_20144_20168 = state_20137__$1;
(statearr_20144_20168[(2)] = inst_20132);

(statearr_20144_20168[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (3))){
var inst_20134 = (state_20137[(2)]);
var inst_20135 = cljs.core.async.close_BANG_(out);
var state_20137__$1 = (function (){var statearr_20145 = state_20137;
(statearr_20145[(9)] = inst_20134);

return statearr_20145;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20137__$1,inst_20135);
} else {
if((state_val_20138 === (2))){
var inst_20114 = (state_20137[(8)]);
var inst_20116 = (inst_20114 < n);
var state_20137__$1 = state_20137;
if(cljs.core.truth_(inst_20116)){
var statearr_20146_20169 = state_20137__$1;
(statearr_20146_20169[(1)] = (4));

} else {
var statearr_20147_20170 = state_20137__$1;
(statearr_20147_20170[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (11))){
var inst_20114 = (state_20137[(8)]);
var inst_20124 = (state_20137[(2)]);
var inst_20125 = (inst_20114 + (1));
var inst_20114__$1 = inst_20125;
var state_20137__$1 = (function (){var statearr_20148 = state_20137;
(statearr_20148[(8)] = inst_20114__$1);

(statearr_20148[(10)] = inst_20124);

return statearr_20148;
})();
var statearr_20149_20171 = state_20137__$1;
(statearr_20149_20171[(2)] = null);

(statearr_20149_20171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (9))){
var state_20137__$1 = state_20137;
var statearr_20150_20172 = state_20137__$1;
(statearr_20150_20172[(2)] = null);

(statearr_20150_20172[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (5))){
var state_20137__$1 = state_20137;
var statearr_20151_20173 = state_20137__$1;
(statearr_20151_20173[(2)] = null);

(statearr_20151_20173[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (10))){
var inst_20129 = (state_20137[(2)]);
var state_20137__$1 = state_20137;
var statearr_20152_20174 = state_20137__$1;
(statearr_20152_20174[(2)] = inst_20129);

(statearr_20152_20174[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20138 === (8))){
var inst_20119 = (state_20137[(7)]);
var state_20137__$1 = state_20137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20137__$1,(11),out,inst_20119);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20164,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20164,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20156 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20156[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20156[(1)] = (1));

return statearr_20156;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20137){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20137);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20157){if((e20157 instanceof Object)){
var ex__17783__auto__ = e20157;
var statearr_20158_20175 = state_20137;
(statearr_20158_20175[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20137);

return cljs.core.cst$kw$recur;
} else {
throw e20157;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20176 = state_20137;
state_20137 = G__20176;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20164,out))
})();
var state__17907__auto__ = (function (){var statearr_20159 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20159[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20164);

return statearr_20159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20164,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20186 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20186 = (function (f,ch,meta20187){
this.f = f;
this.ch = ch;
this.meta20187 = meta20187;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20188,meta20187__$1){
var self__ = this;
var _20188__$1 = this;
return (new cljs.core.async.t_cljs$core$async20186(self__.f,self__.ch,meta20187__$1));
});

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20188){
var self__ = this;
var _20188__$1 = this;
return self__.meta20187;
});

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async20189 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20189 = (function (f,ch,meta20187,_,fn1,meta20190){
this.f = f;
this.ch = ch;
this.meta20187 = meta20187;
this._ = _;
this.fn1 = fn1;
this.meta20190 = meta20190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_20191,meta20190__$1){
var self__ = this;
var _20191__$1 = this;
return (new cljs.core.async.t_cljs$core$async20189(self__.f,self__.ch,self__.meta20187,self__._,self__.fn1,meta20190__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_20191){
var self__ = this;
var _20191__$1 = this;
return self__.meta20190;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__20177_SHARP_){
var G__20192 = (((p1__20177_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__20177_SHARP_) : self__.f.call(null,p1__20177_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__20192) : f1.call(null,G__20192));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta20187,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async20186], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta20190], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async20189.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20189";

cljs.core.async.t_cljs$core$async20189.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async20189");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async20189 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20189(f__$1,ch__$1,meta20187__$1,___$2,fn1__$1,meta20190){
return (new cljs.core.async.t_cljs$core$async20189(f__$1,ch__$1,meta20187__$1,___$2,fn1__$1,meta20190));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async20189(self__.f,self__.ch,self__.meta20187,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7207__auto__ = ret;
if(cljs.core.truth_(and__7207__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7207__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__20193 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__20193) : self__.f.call(null,G__20193));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20186.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async20186.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta20187], null);
});

cljs.core.async.t_cljs$core$async20186.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20186.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20186";

cljs.core.async.t_cljs$core$async20186.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async20186");
});

cljs.core.async.__GT_t_cljs$core$async20186 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async20186(f__$1,ch__$1,meta20187){
return (new cljs.core.async.t_cljs$core$async20186(f__$1,ch__$1,meta20187));
});

}

return (new cljs.core.async.t_cljs$core$async20186(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async20197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20197 = (function (f,ch,meta20198){
this.f = f;
this.ch = ch;
this.meta20198 = meta20198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20199,meta20198__$1){
var self__ = this;
var _20199__$1 = this;
return (new cljs.core.async.t_cljs$core$async20197(self__.f,self__.ch,meta20198__$1));
});

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20199){
var self__ = this;
var _20199__$1 = this;
return self__.meta20198;
});

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20197.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async20197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta20198], null);
});

cljs.core.async.t_cljs$core$async20197.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20197.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20197";

cljs.core.async.t_cljs$core$async20197.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async20197");
});

cljs.core.async.__GT_t_cljs$core$async20197 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async20197(f__$1,ch__$1,meta20198){
return (new cljs.core.async.t_cljs$core$async20197(f__$1,ch__$1,meta20198));
});

}

return (new cljs.core.async.t_cljs$core$async20197(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async20203 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20203 = (function (p,ch,meta20204){
this.p = p;
this.ch = ch;
this.meta20204 = meta20204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20205,meta20204__$1){
var self__ = this;
var _20205__$1 = this;
return (new cljs.core.async.t_cljs$core$async20203(self__.p,self__.ch,meta20204__$1));
});

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20205){
var self__ = this;
var _20205__$1 = this;
return self__.meta20204;
});

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async20203.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async20203.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta20204], null);
});

cljs.core.async.t_cljs$core$async20203.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async20203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20203";

cljs.core.async.t_cljs$core$async20203.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"cljs.core.async/t_cljs$core$async20203");
});

cljs.core.async.__GT_t_cljs$core$async20203 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async20203(p__$1,ch__$1,meta20204){
return (new cljs.core.async.t_cljs$core$async20203(p__$1,ch__$1,meta20204));
});

}

return (new cljs.core.async.t_cljs$core$async20203(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args20206 = [];
var len__8435__auto___20250 = arguments.length;
var i__8436__auto___20251 = (0);
while(true){
if((i__8436__auto___20251 < len__8435__auto___20250)){
args20206.push((arguments[i__8436__auto___20251]));

var G__20252 = (i__8436__auto___20251 + (1));
i__8436__auto___20251 = G__20252;
continue;
} else {
}
break;
}

var G__20208 = args20206.length;
switch (G__20208) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20206.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20254 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20254,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20254,out){
return (function (state_20229){
var state_val_20230 = (state_20229[(1)]);
if((state_val_20230 === (7))){
var inst_20225 = (state_20229[(2)]);
var state_20229__$1 = state_20229;
var statearr_20231_20255 = state_20229__$1;
(statearr_20231_20255[(2)] = inst_20225);

(statearr_20231_20255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (1))){
var state_20229__$1 = state_20229;
var statearr_20232_20256 = state_20229__$1;
(statearr_20232_20256[(2)] = null);

(statearr_20232_20256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (4))){
var inst_20211 = (state_20229[(7)]);
var inst_20211__$1 = (state_20229[(2)]);
var inst_20212 = (inst_20211__$1 == null);
var state_20229__$1 = (function (){var statearr_20233 = state_20229;
(statearr_20233[(7)] = inst_20211__$1);

return statearr_20233;
})();
if(cljs.core.truth_(inst_20212)){
var statearr_20234_20257 = state_20229__$1;
(statearr_20234_20257[(1)] = (5));

} else {
var statearr_20235_20258 = state_20229__$1;
(statearr_20235_20258[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (6))){
var inst_20211 = (state_20229[(7)]);
var inst_20216 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_20211) : p.call(null,inst_20211));
var state_20229__$1 = state_20229;
if(cljs.core.truth_(inst_20216)){
var statearr_20236_20259 = state_20229__$1;
(statearr_20236_20259[(1)] = (8));

} else {
var statearr_20237_20260 = state_20229__$1;
(statearr_20237_20260[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (3))){
var inst_20227 = (state_20229[(2)]);
var state_20229__$1 = state_20229;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20229__$1,inst_20227);
} else {
if((state_val_20230 === (2))){
var state_20229__$1 = state_20229;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20229__$1,(4),ch);
} else {
if((state_val_20230 === (11))){
var inst_20219 = (state_20229[(2)]);
var state_20229__$1 = state_20229;
var statearr_20238_20261 = state_20229__$1;
(statearr_20238_20261[(2)] = inst_20219);

(statearr_20238_20261[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (9))){
var state_20229__$1 = state_20229;
var statearr_20239_20262 = state_20229__$1;
(statearr_20239_20262[(2)] = null);

(statearr_20239_20262[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (5))){
var inst_20214 = cljs.core.async.close_BANG_(out);
var state_20229__$1 = state_20229;
var statearr_20240_20263 = state_20229__$1;
(statearr_20240_20263[(2)] = inst_20214);

(statearr_20240_20263[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (10))){
var inst_20222 = (state_20229[(2)]);
var state_20229__$1 = (function (){var statearr_20241 = state_20229;
(statearr_20241[(8)] = inst_20222);

return statearr_20241;
})();
var statearr_20242_20264 = state_20229__$1;
(statearr_20242_20264[(2)] = null);

(statearr_20242_20264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20230 === (8))){
var inst_20211 = (state_20229[(7)]);
var state_20229__$1 = state_20229;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20229__$1,(11),out,inst_20211);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20254,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20254,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20246 = [null,null,null,null,null,null,null,null,null];
(statearr_20246[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20246[(1)] = (1));

return statearr_20246;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20229){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20229);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20247){if((e20247 instanceof Object)){
var ex__17783__auto__ = e20247;
var statearr_20248_20265 = state_20229;
(statearr_20248_20265[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20229);

return cljs.core.cst$kw$recur;
} else {
throw e20247;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20266 = state_20229;
state_20229 = G__20266;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20254,out))
})();
var state__17907__auto__ = (function (){var statearr_20249 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20254);

return statearr_20249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20254,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args20267 = [];
var len__8435__auto___20270 = arguments.length;
var i__8436__auto___20271 = (0);
while(true){
if((i__8436__auto___20271 < len__8435__auto___20270)){
args20267.push((arguments[i__8436__auto___20271]));

var G__20272 = (i__8436__auto___20271 + (1));
i__8436__auto___20271 = G__20272;
continue;
} else {
}
break;
}

var G__20269 = args20267.length;
switch (G__20269) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20267.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17905__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto__){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto__){
return (function (state_20439){
var state_val_20440 = (state_20439[(1)]);
if((state_val_20440 === (7))){
var inst_20435 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
var statearr_20441_20482 = state_20439__$1;
(statearr_20441_20482[(2)] = inst_20435);

(statearr_20441_20482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (20))){
var inst_20405 = (state_20439[(7)]);
var inst_20416 = (state_20439[(2)]);
var inst_20417 = cljs.core.next(inst_20405);
var inst_20391 = inst_20417;
var inst_20392 = null;
var inst_20393 = (0);
var inst_20394 = (0);
var state_20439__$1 = (function (){var statearr_20442 = state_20439;
(statearr_20442[(8)] = inst_20393);

(statearr_20442[(9)] = inst_20394);

(statearr_20442[(10)] = inst_20391);

(statearr_20442[(11)] = inst_20416);

(statearr_20442[(12)] = inst_20392);

return statearr_20442;
})();
var statearr_20443_20483 = state_20439__$1;
(statearr_20443_20483[(2)] = null);

(statearr_20443_20483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (1))){
var state_20439__$1 = state_20439;
var statearr_20444_20484 = state_20439__$1;
(statearr_20444_20484[(2)] = null);

(statearr_20444_20484[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (4))){
var inst_20380 = (state_20439[(13)]);
var inst_20380__$1 = (state_20439[(2)]);
var inst_20381 = (inst_20380__$1 == null);
var state_20439__$1 = (function (){var statearr_20445 = state_20439;
(statearr_20445[(13)] = inst_20380__$1);

return statearr_20445;
})();
if(cljs.core.truth_(inst_20381)){
var statearr_20446_20485 = state_20439__$1;
(statearr_20446_20485[(1)] = (5));

} else {
var statearr_20447_20486 = state_20439__$1;
(statearr_20447_20486[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (15))){
var state_20439__$1 = state_20439;
var statearr_20451_20487 = state_20439__$1;
(statearr_20451_20487[(2)] = null);

(statearr_20451_20487[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (21))){
var state_20439__$1 = state_20439;
var statearr_20452_20488 = state_20439__$1;
(statearr_20452_20488[(2)] = null);

(statearr_20452_20488[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (13))){
var inst_20393 = (state_20439[(8)]);
var inst_20394 = (state_20439[(9)]);
var inst_20391 = (state_20439[(10)]);
var inst_20392 = (state_20439[(12)]);
var inst_20401 = (state_20439[(2)]);
var inst_20402 = (inst_20394 + (1));
var tmp20448 = inst_20393;
var tmp20449 = inst_20391;
var tmp20450 = inst_20392;
var inst_20391__$1 = tmp20449;
var inst_20392__$1 = tmp20450;
var inst_20393__$1 = tmp20448;
var inst_20394__$1 = inst_20402;
var state_20439__$1 = (function (){var statearr_20453 = state_20439;
(statearr_20453[(8)] = inst_20393__$1);

(statearr_20453[(9)] = inst_20394__$1);

(statearr_20453[(10)] = inst_20391__$1);

(statearr_20453[(12)] = inst_20392__$1);

(statearr_20453[(14)] = inst_20401);

return statearr_20453;
})();
var statearr_20454_20489 = state_20439__$1;
(statearr_20454_20489[(2)] = null);

(statearr_20454_20489[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (22))){
var state_20439__$1 = state_20439;
var statearr_20455_20490 = state_20439__$1;
(statearr_20455_20490[(2)] = null);

(statearr_20455_20490[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (6))){
var inst_20380 = (state_20439[(13)]);
var inst_20389 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20380) : f.call(null,inst_20380));
var inst_20390 = cljs.core.seq(inst_20389);
var inst_20391 = inst_20390;
var inst_20392 = null;
var inst_20393 = (0);
var inst_20394 = (0);
var state_20439__$1 = (function (){var statearr_20456 = state_20439;
(statearr_20456[(8)] = inst_20393);

(statearr_20456[(9)] = inst_20394);

(statearr_20456[(10)] = inst_20391);

(statearr_20456[(12)] = inst_20392);

return statearr_20456;
})();
var statearr_20457_20491 = state_20439__$1;
(statearr_20457_20491[(2)] = null);

(statearr_20457_20491[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (17))){
var inst_20405 = (state_20439[(7)]);
var inst_20409 = cljs.core.chunk_first(inst_20405);
var inst_20410 = cljs.core.chunk_rest(inst_20405);
var inst_20411 = cljs.core.count(inst_20409);
var inst_20391 = inst_20410;
var inst_20392 = inst_20409;
var inst_20393 = inst_20411;
var inst_20394 = (0);
var state_20439__$1 = (function (){var statearr_20458 = state_20439;
(statearr_20458[(8)] = inst_20393);

(statearr_20458[(9)] = inst_20394);

(statearr_20458[(10)] = inst_20391);

(statearr_20458[(12)] = inst_20392);

return statearr_20458;
})();
var statearr_20459_20492 = state_20439__$1;
(statearr_20459_20492[(2)] = null);

(statearr_20459_20492[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (3))){
var inst_20437 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20439__$1,inst_20437);
} else {
if((state_val_20440 === (12))){
var inst_20425 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
var statearr_20460_20493 = state_20439__$1;
(statearr_20460_20493[(2)] = inst_20425);

(statearr_20460_20493[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (2))){
var state_20439__$1 = state_20439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20439__$1,(4),in$);
} else {
if((state_val_20440 === (23))){
var inst_20433 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
var statearr_20461_20494 = state_20439__$1;
(statearr_20461_20494[(2)] = inst_20433);

(statearr_20461_20494[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (19))){
var inst_20420 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
var statearr_20462_20495 = state_20439__$1;
(statearr_20462_20495[(2)] = inst_20420);

(statearr_20462_20495[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (11))){
var inst_20391 = (state_20439[(10)]);
var inst_20405 = (state_20439[(7)]);
var inst_20405__$1 = cljs.core.seq(inst_20391);
var state_20439__$1 = (function (){var statearr_20463 = state_20439;
(statearr_20463[(7)] = inst_20405__$1);

return statearr_20463;
})();
if(inst_20405__$1){
var statearr_20464_20496 = state_20439__$1;
(statearr_20464_20496[(1)] = (14));

} else {
var statearr_20465_20497 = state_20439__$1;
(statearr_20465_20497[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (9))){
var inst_20427 = (state_20439[(2)]);
var inst_20428 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_20439__$1 = (function (){var statearr_20466 = state_20439;
(statearr_20466[(15)] = inst_20427);

return statearr_20466;
})();
if(cljs.core.truth_(inst_20428)){
var statearr_20467_20498 = state_20439__$1;
(statearr_20467_20498[(1)] = (21));

} else {
var statearr_20468_20499 = state_20439__$1;
(statearr_20468_20499[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (5))){
var inst_20383 = cljs.core.async.close_BANG_(out);
var state_20439__$1 = state_20439;
var statearr_20469_20500 = state_20439__$1;
(statearr_20469_20500[(2)] = inst_20383);

(statearr_20469_20500[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (14))){
var inst_20405 = (state_20439[(7)]);
var inst_20407 = cljs.core.chunked_seq_QMARK_(inst_20405);
var state_20439__$1 = state_20439;
if(inst_20407){
var statearr_20470_20501 = state_20439__$1;
(statearr_20470_20501[(1)] = (17));

} else {
var statearr_20471_20502 = state_20439__$1;
(statearr_20471_20502[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (16))){
var inst_20423 = (state_20439[(2)]);
var state_20439__$1 = state_20439;
var statearr_20472_20503 = state_20439__$1;
(statearr_20472_20503[(2)] = inst_20423);

(statearr_20472_20503[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20440 === (10))){
var inst_20394 = (state_20439[(9)]);
var inst_20392 = (state_20439[(12)]);
var inst_20399 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_20392,inst_20394);
var state_20439__$1 = state_20439;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20439__$1,(13),out,inst_20399);
} else {
if((state_val_20440 === (18))){
var inst_20405 = (state_20439[(7)]);
var inst_20414 = cljs.core.first(inst_20405);
var state_20439__$1 = state_20439;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20439__$1,(20),out,inst_20414);
} else {
if((state_val_20440 === (8))){
var inst_20393 = (state_20439[(8)]);
var inst_20394 = (state_20439[(9)]);
var inst_20396 = (inst_20394 < inst_20393);
var inst_20397 = inst_20396;
var state_20439__$1 = state_20439;
if(cljs.core.truth_(inst_20397)){
var statearr_20473_20504 = state_20439__$1;
(statearr_20473_20504[(1)] = (10));

} else {
var statearr_20474_20505 = state_20439__$1;
(statearr_20474_20505[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto__))
;
return ((function (switch__17779__auto__,c__17905__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____0 = (function (){
var statearr_20478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20478[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__);

(statearr_20478[(1)] = (1));

return statearr_20478;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____1 = (function (state_20439){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20439);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20479){if((e20479 instanceof Object)){
var ex__17783__auto__ = e20479;
var statearr_20480_20506 = state_20439;
(statearr_20480_20506[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20439);

return cljs.core.cst$kw$recur;
} else {
throw e20479;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20507 = state_20439;
state_20439 = G__20507;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__ = function(state_20439){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____1.call(this,state_20439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17780__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto__))
})();
var state__17907__auto__ = (function (){var statearr_20481 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto__);

return statearr_20481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto__))
);

return c__17905__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args20508 = [];
var len__8435__auto___20511 = arguments.length;
var i__8436__auto___20512 = (0);
while(true){
if((i__8436__auto___20512 < len__8435__auto___20511)){
args20508.push((arguments[i__8436__auto___20512]));

var G__20513 = (i__8436__auto___20512 + (1));
i__8436__auto___20512 = G__20513;
continue;
} else {
}
break;
}

var G__20510 = args20508.length;
switch (G__20510) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20508.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args20515 = [];
var len__8435__auto___20518 = arguments.length;
var i__8436__auto___20519 = (0);
while(true){
if((i__8436__auto___20519 < len__8435__auto___20518)){
args20515.push((arguments[i__8436__auto___20519]));

var G__20520 = (i__8436__auto___20519 + (1));
i__8436__auto___20519 = G__20520;
continue;
} else {
}
break;
}

var G__20517 = args20515.length;
switch (G__20517) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20515.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args20522 = [];
var len__8435__auto___20573 = arguments.length;
var i__8436__auto___20574 = (0);
while(true){
if((i__8436__auto___20574 < len__8435__auto___20573)){
args20522.push((arguments[i__8436__auto___20574]));

var G__20575 = (i__8436__auto___20574 + (1));
i__8436__auto___20574 = G__20575;
continue;
} else {
}
break;
}

var G__20524 = args20522.length;
switch (G__20524) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20522.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20577 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20577,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20577,out){
return (function (state_20548){
var state_val_20549 = (state_20548[(1)]);
if((state_val_20549 === (7))){
var inst_20543 = (state_20548[(2)]);
var state_20548__$1 = state_20548;
var statearr_20550_20578 = state_20548__$1;
(statearr_20550_20578[(2)] = inst_20543);

(statearr_20550_20578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (1))){
var inst_20525 = null;
var state_20548__$1 = (function (){var statearr_20551 = state_20548;
(statearr_20551[(7)] = inst_20525);

return statearr_20551;
})();
var statearr_20552_20579 = state_20548__$1;
(statearr_20552_20579[(2)] = null);

(statearr_20552_20579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (4))){
var inst_20528 = (state_20548[(8)]);
var inst_20528__$1 = (state_20548[(2)]);
var inst_20529 = (inst_20528__$1 == null);
var inst_20530 = cljs.core.not(inst_20529);
var state_20548__$1 = (function (){var statearr_20553 = state_20548;
(statearr_20553[(8)] = inst_20528__$1);

return statearr_20553;
})();
if(inst_20530){
var statearr_20554_20580 = state_20548__$1;
(statearr_20554_20580[(1)] = (5));

} else {
var statearr_20555_20581 = state_20548__$1;
(statearr_20555_20581[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (6))){
var state_20548__$1 = state_20548;
var statearr_20556_20582 = state_20548__$1;
(statearr_20556_20582[(2)] = null);

(statearr_20556_20582[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (3))){
var inst_20545 = (state_20548[(2)]);
var inst_20546 = cljs.core.async.close_BANG_(out);
var state_20548__$1 = (function (){var statearr_20557 = state_20548;
(statearr_20557[(9)] = inst_20545);

return statearr_20557;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_20548__$1,inst_20546);
} else {
if((state_val_20549 === (2))){
var state_20548__$1 = state_20548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20548__$1,(4),ch);
} else {
if((state_val_20549 === (11))){
var inst_20528 = (state_20548[(8)]);
var inst_20537 = (state_20548[(2)]);
var inst_20525 = inst_20528;
var state_20548__$1 = (function (){var statearr_20558 = state_20548;
(statearr_20558[(10)] = inst_20537);

(statearr_20558[(7)] = inst_20525);

return statearr_20558;
})();
var statearr_20559_20583 = state_20548__$1;
(statearr_20559_20583[(2)] = null);

(statearr_20559_20583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (9))){
var inst_20528 = (state_20548[(8)]);
var state_20548__$1 = state_20548;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20548__$1,(11),out,inst_20528);
} else {
if((state_val_20549 === (5))){
var inst_20528 = (state_20548[(8)]);
var inst_20525 = (state_20548[(7)]);
var inst_20532 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20528,inst_20525);
var state_20548__$1 = state_20548;
if(inst_20532){
var statearr_20561_20584 = state_20548__$1;
(statearr_20561_20584[(1)] = (8));

} else {
var statearr_20562_20585 = state_20548__$1;
(statearr_20562_20585[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (10))){
var inst_20540 = (state_20548[(2)]);
var state_20548__$1 = state_20548;
var statearr_20563_20586 = state_20548__$1;
(statearr_20563_20586[(2)] = inst_20540);

(statearr_20563_20586[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20549 === (8))){
var inst_20525 = (state_20548[(7)]);
var tmp20560 = inst_20525;
var inst_20525__$1 = tmp20560;
var state_20548__$1 = (function (){var statearr_20564 = state_20548;
(statearr_20564[(7)] = inst_20525__$1);

return statearr_20564;
})();
var statearr_20565_20587 = state_20548__$1;
(statearr_20565_20587[(2)] = null);

(statearr_20565_20587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20577,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20577,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20569 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20569[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20569[(1)] = (1));

return statearr_20569;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20548){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20548);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20570){if((e20570 instanceof Object)){
var ex__17783__auto__ = e20570;
var statearr_20571_20588 = state_20548;
(statearr_20571_20588[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20548);

return cljs.core.cst$kw$recur;
} else {
throw e20570;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20589 = state_20548;
state_20548 = G__20589;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20548){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20577,out))
})();
var state__17907__auto__ = (function (){var statearr_20572 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20572[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20577);

return statearr_20572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20577,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args20590 = [];
var len__8435__auto___20660 = arguments.length;
var i__8436__auto___20661 = (0);
while(true){
if((i__8436__auto___20661 < len__8435__auto___20660)){
args20590.push((arguments[i__8436__auto___20661]));

var G__20662 = (i__8436__auto___20661 + (1));
i__8436__auto___20661 = G__20662;
continue;
} else {
}
break;
}

var G__20592 = args20590.length;
switch (G__20592) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20590.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20664 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20664,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20664,out){
return (function (state_20630){
var state_val_20631 = (state_20630[(1)]);
if((state_val_20631 === (7))){
var inst_20626 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20632_20665 = state_20630__$1;
(statearr_20632_20665[(2)] = inst_20626);

(statearr_20632_20665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (1))){
var inst_20593 = (new Array(n));
var inst_20594 = inst_20593;
var inst_20595 = (0);
var state_20630__$1 = (function (){var statearr_20633 = state_20630;
(statearr_20633[(7)] = inst_20595);

(statearr_20633[(8)] = inst_20594);

return statearr_20633;
})();
var statearr_20634_20666 = state_20630__$1;
(statearr_20634_20666[(2)] = null);

(statearr_20634_20666[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (4))){
var inst_20598 = (state_20630[(9)]);
var inst_20598__$1 = (state_20630[(2)]);
var inst_20599 = (inst_20598__$1 == null);
var inst_20600 = cljs.core.not(inst_20599);
var state_20630__$1 = (function (){var statearr_20635 = state_20630;
(statearr_20635[(9)] = inst_20598__$1);

return statearr_20635;
})();
if(inst_20600){
var statearr_20636_20667 = state_20630__$1;
(statearr_20636_20667[(1)] = (5));

} else {
var statearr_20637_20668 = state_20630__$1;
(statearr_20637_20668[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (15))){
var inst_20620 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20638_20669 = state_20630__$1;
(statearr_20638_20669[(2)] = inst_20620);

(statearr_20638_20669[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (13))){
var state_20630__$1 = state_20630;
var statearr_20639_20670 = state_20630__$1;
(statearr_20639_20670[(2)] = null);

(statearr_20639_20670[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (6))){
var inst_20595 = (state_20630[(7)]);
var inst_20616 = (inst_20595 > (0));
var state_20630__$1 = state_20630;
if(cljs.core.truth_(inst_20616)){
var statearr_20640_20671 = state_20630__$1;
(statearr_20640_20671[(1)] = (12));

} else {
var statearr_20641_20672 = state_20630__$1;
(statearr_20641_20672[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (3))){
var inst_20628 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20630__$1,inst_20628);
} else {
if((state_val_20631 === (12))){
var inst_20594 = (state_20630[(8)]);
var inst_20618 = cljs.core.vec(inst_20594);
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20630__$1,(15),out,inst_20618);
} else {
if((state_val_20631 === (2))){
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20630__$1,(4),ch);
} else {
if((state_val_20631 === (11))){
var inst_20610 = (state_20630[(2)]);
var inst_20611 = (new Array(n));
var inst_20594 = inst_20611;
var inst_20595 = (0);
var state_20630__$1 = (function (){var statearr_20642 = state_20630;
(statearr_20642[(7)] = inst_20595);

(statearr_20642[(10)] = inst_20610);

(statearr_20642[(8)] = inst_20594);

return statearr_20642;
})();
var statearr_20643_20673 = state_20630__$1;
(statearr_20643_20673[(2)] = null);

(statearr_20643_20673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (9))){
var inst_20594 = (state_20630[(8)]);
var inst_20608 = cljs.core.vec(inst_20594);
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20630__$1,(11),out,inst_20608);
} else {
if((state_val_20631 === (5))){
var inst_20595 = (state_20630[(7)]);
var inst_20603 = (state_20630[(11)]);
var inst_20594 = (state_20630[(8)]);
var inst_20598 = (state_20630[(9)]);
var inst_20602 = (inst_20594[inst_20595] = inst_20598);
var inst_20603__$1 = (inst_20595 + (1));
var inst_20604 = (inst_20603__$1 < n);
var state_20630__$1 = (function (){var statearr_20644 = state_20630;
(statearr_20644[(11)] = inst_20603__$1);

(statearr_20644[(12)] = inst_20602);

return statearr_20644;
})();
if(cljs.core.truth_(inst_20604)){
var statearr_20645_20674 = state_20630__$1;
(statearr_20645_20674[(1)] = (8));

} else {
var statearr_20646_20675 = state_20630__$1;
(statearr_20646_20675[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (14))){
var inst_20623 = (state_20630[(2)]);
var inst_20624 = cljs.core.async.close_BANG_(out);
var state_20630__$1 = (function (){var statearr_20648 = state_20630;
(statearr_20648[(13)] = inst_20623);

return statearr_20648;
})();
var statearr_20649_20676 = state_20630__$1;
(statearr_20649_20676[(2)] = inst_20624);

(statearr_20649_20676[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (10))){
var inst_20614 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20650_20677 = state_20630__$1;
(statearr_20650_20677[(2)] = inst_20614);

(statearr_20650_20677[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20631 === (8))){
var inst_20603 = (state_20630[(11)]);
var inst_20594 = (state_20630[(8)]);
var tmp20647 = inst_20594;
var inst_20594__$1 = tmp20647;
var inst_20595 = inst_20603;
var state_20630__$1 = (function (){var statearr_20651 = state_20630;
(statearr_20651[(7)] = inst_20595);

(statearr_20651[(8)] = inst_20594__$1);

return statearr_20651;
})();
var statearr_20652_20678 = state_20630__$1;
(statearr_20652_20678[(2)] = null);

(statearr_20652_20678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20664,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20664,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20656[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20656[(1)] = (1));

return statearr_20656;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20630){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20630);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20657){if((e20657 instanceof Object)){
var ex__17783__auto__ = e20657;
var statearr_20658_20679 = state_20630;
(statearr_20658_20679[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20630);

return cljs.core.cst$kw$recur;
} else {
throw e20657;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20680 = state_20630;
state_20630 = G__20680;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20630){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20664,out))
})();
var state__17907__auto__ = (function (){var statearr_20659 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20664);

return statearr_20659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20664,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args20681 = [];
var len__8435__auto___20755 = arguments.length;
var i__8436__auto___20756 = (0);
while(true){
if((i__8436__auto___20756 < len__8435__auto___20755)){
args20681.push((arguments[i__8436__auto___20756]));

var G__20757 = (i__8436__auto___20756 + (1));
i__8436__auto___20756 = G__20757;
continue;
} else {
}
break;
}

var G__20683 = args20681.length;
switch (G__20683) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args20681.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17905__auto___20759 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17905__auto___20759,out){
return (function (){
var f__17906__auto__ = (function (){var switch__17779__auto__ = ((function (c__17905__auto___20759,out){
return (function (state_20725){
var state_val_20726 = (state_20725[(1)]);
if((state_val_20726 === (7))){
var inst_20721 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20727_20760 = state_20725__$1;
(statearr_20727_20760[(2)] = inst_20721);

(statearr_20727_20760[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (1))){
var inst_20684 = [];
var inst_20685 = inst_20684;
var inst_20686 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_20725__$1 = (function (){var statearr_20728 = state_20725;
(statearr_20728[(7)] = inst_20685);

(statearr_20728[(8)] = inst_20686);

return statearr_20728;
})();
var statearr_20729_20761 = state_20725__$1;
(statearr_20729_20761[(2)] = null);

(statearr_20729_20761[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (4))){
var inst_20689 = (state_20725[(9)]);
var inst_20689__$1 = (state_20725[(2)]);
var inst_20690 = (inst_20689__$1 == null);
var inst_20691 = cljs.core.not(inst_20690);
var state_20725__$1 = (function (){var statearr_20730 = state_20725;
(statearr_20730[(9)] = inst_20689__$1);

return statearr_20730;
})();
if(inst_20691){
var statearr_20731_20762 = state_20725__$1;
(statearr_20731_20762[(1)] = (5));

} else {
var statearr_20732_20763 = state_20725__$1;
(statearr_20732_20763[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (15))){
var inst_20715 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20733_20764 = state_20725__$1;
(statearr_20733_20764[(2)] = inst_20715);

(statearr_20733_20764[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (13))){
var state_20725__$1 = state_20725;
var statearr_20734_20765 = state_20725__$1;
(statearr_20734_20765[(2)] = null);

(statearr_20734_20765[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (6))){
var inst_20685 = (state_20725[(7)]);
var inst_20710 = inst_20685.length;
var inst_20711 = (inst_20710 > (0));
var state_20725__$1 = state_20725;
if(cljs.core.truth_(inst_20711)){
var statearr_20735_20766 = state_20725__$1;
(statearr_20735_20766[(1)] = (12));

} else {
var statearr_20736_20767 = state_20725__$1;
(statearr_20736_20767[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (3))){
var inst_20723 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20725__$1,inst_20723);
} else {
if((state_val_20726 === (12))){
var inst_20685 = (state_20725[(7)]);
var inst_20713 = cljs.core.vec(inst_20685);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20725__$1,(15),out,inst_20713);
} else {
if((state_val_20726 === (2))){
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20725__$1,(4),ch);
} else {
if((state_val_20726 === (11))){
var inst_20689 = (state_20725[(9)]);
var inst_20693 = (state_20725[(10)]);
var inst_20703 = (state_20725[(2)]);
var inst_20704 = [];
var inst_20705 = inst_20704.push(inst_20689);
var inst_20685 = inst_20704;
var inst_20686 = inst_20693;
var state_20725__$1 = (function (){var statearr_20737 = state_20725;
(statearr_20737[(7)] = inst_20685);

(statearr_20737[(8)] = inst_20686);

(statearr_20737[(11)] = inst_20705);

(statearr_20737[(12)] = inst_20703);

return statearr_20737;
})();
var statearr_20738_20768 = state_20725__$1;
(statearr_20738_20768[(2)] = null);

(statearr_20738_20768[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (9))){
var inst_20685 = (state_20725[(7)]);
var inst_20701 = cljs.core.vec(inst_20685);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20725__$1,(11),out,inst_20701);
} else {
if((state_val_20726 === (5))){
var inst_20689 = (state_20725[(9)]);
var inst_20693 = (state_20725[(10)]);
var inst_20686 = (state_20725[(8)]);
var inst_20693__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_20689) : f.call(null,inst_20689));
var inst_20694 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20693__$1,inst_20686);
var inst_20695 = cljs.core.keyword_identical_QMARK_(inst_20686,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_20696 = (inst_20694) || (inst_20695);
var state_20725__$1 = (function (){var statearr_20739 = state_20725;
(statearr_20739[(10)] = inst_20693__$1);

return statearr_20739;
})();
if(cljs.core.truth_(inst_20696)){
var statearr_20740_20769 = state_20725__$1;
(statearr_20740_20769[(1)] = (8));

} else {
var statearr_20741_20770 = state_20725__$1;
(statearr_20741_20770[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (14))){
var inst_20718 = (state_20725[(2)]);
var inst_20719 = cljs.core.async.close_BANG_(out);
var state_20725__$1 = (function (){var statearr_20743 = state_20725;
(statearr_20743[(13)] = inst_20718);

return statearr_20743;
})();
var statearr_20744_20771 = state_20725__$1;
(statearr_20744_20771[(2)] = inst_20719);

(statearr_20744_20771[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (10))){
var inst_20708 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20745_20772 = state_20725__$1;
(statearr_20745_20772[(2)] = inst_20708);

(statearr_20745_20772[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20726 === (8))){
var inst_20689 = (state_20725[(9)]);
var inst_20685 = (state_20725[(7)]);
var inst_20693 = (state_20725[(10)]);
var inst_20698 = inst_20685.push(inst_20689);
var tmp20742 = inst_20685;
var inst_20685__$1 = tmp20742;
var inst_20686 = inst_20693;
var state_20725__$1 = (function (){var statearr_20746 = state_20725;
(statearr_20746[(14)] = inst_20698);

(statearr_20746[(7)] = inst_20685__$1);

(statearr_20746[(8)] = inst_20686);

return statearr_20746;
})();
var statearr_20747_20773 = state_20725__$1;
(statearr_20747_20773[(2)] = null);

(statearr_20747_20773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17905__auto___20759,out))
;
return ((function (switch__17779__auto__,c__17905__auto___20759,out){
return (function() {
var cljs$core$async$state_machine__17780__auto__ = null;
var cljs$core$async$state_machine__17780__auto____0 = (function (){
var statearr_20751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20751[(0)] = cljs$core$async$state_machine__17780__auto__);

(statearr_20751[(1)] = (1));

return statearr_20751;
});
var cljs$core$async$state_machine__17780__auto____1 = (function (state_20725){
while(true){
var ret_value__17781__auto__ = (function (){try{while(true){
var result__17782__auto__ = switch__17779__auto__(state_20725);
if(cljs.core.keyword_identical_QMARK_(result__17782__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17782__auto__;
}
break;
}
}catch (e20752){if((e20752 instanceof Object)){
var ex__17783__auto__ = e20752;
var statearr_20753_20774 = state_20725;
(statearr_20753_20774[(5)] = ex__17783__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20725);

return cljs.core.cst$kw$recur;
} else {
throw e20752;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17781__auto__,cljs.core.cst$kw$recur)){
var G__20775 = state_20725;
state_20725 = G__20775;
continue;
} else {
return ret_value__17781__auto__;
}
break;
}
});
cljs$core$async$state_machine__17780__auto__ = function(state_20725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17780__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17780__auto____1.call(this,state_20725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17780__auto____0;
cljs$core$async$state_machine__17780__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17780__auto____1;
return cljs$core$async$state_machine__17780__auto__;
})()
;})(switch__17779__auto__,c__17905__auto___20759,out))
})();
var state__17907__auto__ = (function (){var statearr_20754 = (f__17906__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17906__auto__.cljs$core$IFn$_invoke$arity$0() : f__17906__auto__.call(null));
(statearr_20754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17905__auto___20759);

return statearr_20754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17907__auto__);
});})(c__17905__auto___20759,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

