// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.stacktrace');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
if(typeof cljs.stacktrace.parse_stacktrace !== 'undefined'){
} else {
/**
 * Parse a JavaScript stacktrace string into a canonical data form. The
 *   arguments:
 * 
 *   repl-env - the repl environment, an optional map with :host and :port keys
 *           if the stacktrace includes url, not file references
 *   st       - the original stacktrace string to parse
 *   err      - an error map. :ua-product key defines the type of stacktrace parser
 *           to use, for example :chrome
 *   opts     - additional options. :output-dir maybe given in this argument if
 *           :host and :port do not apply, for example, a file path
 * 
 *   The canonical stacktrace representation can easily be mapped to a
 *   ClojureScript one see mapped-stacktrace and mapped-stacktrace-str
 */
cljs.stacktrace.parse_stacktrace = (function (){var method_table__8245__auto__ = (function (){var G__42251 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__42251) : cljs.core.atom.call(null,G__42251));
})();
var prefer_table__8246__auto__ = (function (){var G__42252 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__42252) : cljs.core.atom.call(null,G__42252));
})();
var method_cache__8247__auto__ = (function (){var G__42253 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__42253) : cljs.core.atom.call(null,G__42253));
})();
var cached_hierarchy__8248__auto__ = (function (){var G__42254 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__42254) : cljs.core.atom.call(null,G__42254));
})();
var hierarchy__8249__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.stacktrace","parse-stacktrace"),((function (method_table__8245__auto__,prefer_table__8246__auto__,method_cache__8247__auto__,cached_hierarchy__8248__auto__,hierarchy__8249__auto__){
return (function (repl_env,st,err,opts){
return cljs.core.cst$kw$ua_DASH_product.cljs$core$IFn$_invoke$arity$1(err);
});})(method_table__8245__auto__,prefer_table__8246__auto__,method_cache__8247__auto__,cached_hierarchy__8248__auto__,hierarchy__8249__auto__))
,cljs.core.cst$kw$default,hierarchy__8249__auto__,method_table__8245__auto__,prefer_table__8246__auto__,method_cache__8247__auto__,cached_hierarchy__8248__auto__));
})();
}
cljs.stacktrace.parse_int = (function cljs$stacktrace$parse_int(s){
return parseInt(s,(10));
});
cljs.stacktrace.starts_with_QMARK_ = (function cljs$stacktrace$starts_with_QMARK_(s0,s1){
return goog.string.startsWith(s0,s1);
});
cljs.stacktrace.ends_with_QMARK_ = (function cljs$stacktrace$ends_with_QMARK_(s0,s1){
return goog.string.endsWith(s0,s1);
});
cljs.stacktrace.string__GT_regex = (function cljs$stacktrace$string__GT_regex(s){
return (new RegExp(s));
});
cljs.stacktrace.output_directory = (function cljs$stacktrace$output_directory(opts){
var or__7219__auto__ = cljs.core.cst$kw$output_DASH_dir.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return "out";
}
});
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (repl_env,st,err,opts){
return st;
}));
cljs.stacktrace.parse_file_line_column = (function cljs$stacktrace$parse_file_line_column(flc){
if(cljs.core.not(cljs.core.re_find(/:/,flc))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [flc,null,null], null);
} else {
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(flc,/:/);
var vec__42272 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (xs){
return (function (p__42278,p__42279){
var vec__42280 = p__42278;
var pre = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42280,(0),null);
var post = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42280,(1),null);
var vec__42283 = p__42279;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42283,(0),null);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42283,(1),null);
if((i <= (2))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(post,x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(pre,x),post], null);
}
});})(xs))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,xs,cljs.core.range.cljs$core$IFn$_invoke$arity$3(cljs.core.count(xs),(0),(-1))));
var pre = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42272,(0),null);
var vec__42275 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42272,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42275,(0),null);
var column = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42275,(1),null);
var file = clojure.string.join.cljs$core$IFn$_invoke$arity$2(":",pre);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__42286 = file;
if(cljs.stacktrace.starts_with_QMARK_(file,"(")){
return clojure.string.replace(G__42286,"(","");
} else {
return G__42286;
}
})(),cljs.stacktrace.parse_int((function (){var G__42287 = line;
if(cljs.stacktrace.ends_with_QMARK_(line,")")){
return clojure.string.replace(G__42287,")","");
} else {
return G__42287;
}
})()),cljs.stacktrace.parse_int((function (){var G__42288 = column;
if(cljs.stacktrace.ends_with_QMARK_(column,")")){
return clojure.string.replace(G__42288,")","");
} else {
return G__42288;
}
})())], null);
}
});
/**
 * Given a browser file url convert it into a relative path that can be used
 * to locate the original source.
 */
cljs.stacktrace.parse_file = (function cljs$stacktrace$parse_file(p__42289,file,p__42290){
var map__42295 = p__42289;
var map__42295__$1 = ((((!((map__42295 == null)))?((((map__42295.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42295.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42295):map__42295);
var repl_env = map__42295__$1;
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42295__$1,cljs.core.cst$kw$host);
var host_port = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42295__$1,cljs.core.cst$kw$host_DASH_port);
var port = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42295__$1,cljs.core.cst$kw$port);
var map__42296 = p__42290;
var map__42296__$1 = ((((!((map__42296 == null)))?((((map__42296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42296.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42296):map__42296);
var opts = map__42296__$1;
var asset_path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42296__$1,cljs.core.cst$kw$asset_DASH_path);
var urlpat = (cljs.core.truth_(host)?cljs.stacktrace.string__GT_regex([cljs.core.str("http://"),cljs.core.str(host),cljs.core.str(":"),cljs.core.str((function (){var or__7219__auto__ = host_port;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return port;
}
})()),cljs.core.str("/")].join('')):"");
var match = (cljs.core.truth_(host)?cljs.core.re_find(urlpat,file):cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$output_DASH_dir));
if(cljs.core.truth_(match)){
return clojure.string.replace(clojure.string.replace(file,urlpat,""),cljs.stacktrace.string__GT_regex([cljs.core.str("^"),cljs.core.str((function (){var or__7219__auto__ = (function (){var and__7207__auto__ = asset_path;
if(cljs.core.truth_(and__7207__auto__)){
return clojure.string.replace(asset_path,/^\//,"");
} else {
return and__7207__auto__;
}
})();
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.stacktrace.output_directory(opts);
}
})()),cljs.core.str("/")].join('')),"");
} else {
var temp__6751__auto__ = cljs.core.cst$kw$asset_DASH_root.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__6751__auto__)){
var asset_root = temp__6751__auto__;
return clojure.string.replace(file,asset_root,"");
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str("Could not relativize URL "),cljs.core.str(file)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,cljs.core.cst$kw$parse_DASH_stacktrace,cljs.core.cst$kw$reason,cljs.core.cst$kw$relativize_DASH_url], null));
}
}
});
cljs.stacktrace.chrome_st_el__GT_frame = (function cljs$stacktrace$chrome_st_el__GT_frame(repl_env,st_el,opts){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.replace(st_el,/\s+at\s+/,""),/\s+/);
var vec__42305 = ((((1) === cljs.core.count(xs)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.first(xs)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(xs),cljs.core.last(xs)], null));
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42305,(0),null);
var flc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42305,(1),null);
var vec__42308 = cljs.stacktrace.parse_file_line_column(flc);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42308,(0),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42308,(1),null);
var column = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42308,(2),null);
if(cljs.core.truth_((function (){var and__7207__auto__ = file;
if(cljs.core.truth_(and__7207__auto__)){
var and__7207__auto____$1 = function$;
if(cljs.core.truth_(and__7207__auto____$1)){
var and__7207__auto____$2 = line;
if(cljs.core.truth_(and__7207__auto____$2)){
return column;
} else {
return and__7207__auto____$2;
}
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,cljs.stacktrace.parse_file(repl_env,file,opts),cljs.core.cst$kw$function,clojure.string.replace(function$,/Object\./,""),cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,column], null);
} else {
if(clojure.string.blank_QMARK_(function$)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,null,cljs.core.cst$kw$function,clojure.string.replace(function$,/Object\./,""),cljs.core.cst$kw$line,null,cljs.core.cst$kw$column,null], null);
}
}
});
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$chrome,(function (repl_env,st,err,opts){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42313_SHARP_){
return cljs.stacktrace.chrome_st_el__GT_frame(repl_env,p1__42313_SHARP_,opts);
}),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__42312_SHARP_){
return !(cljs.stacktrace.starts_with_QMARK_(p1__42312_SHARP_,"    at eval"));
}),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (p1__42311_SHARP_){
return cljs.stacktrace.starts_with_QMARK_(p1__42311_SHARP_,"Error");
}),clojure.string.split_lines(st))))));
}));
cljs.stacktrace.safari_st_el__GT_frame = (function cljs$stacktrace$safari_st_el__GT_frame(repl_env,st_el,opts){
var vec__42320 = (cljs.core.truth_(cljs.core.re_find(/@/,st_el))?clojure.string.split.cljs$core$IFn$_invoke$arity$2(st_el,/@/):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,st_el], null));
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(0),null);
var flc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42320,(1),null);
var vec__42323 = cljs.stacktrace.parse_file_line_column(flc);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42323,(0),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42323,(1),null);
var column = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42323,(2),null);
if(cljs.core.truth_((function (){var and__7207__auto__ = file;
if(cljs.core.truth_(and__7207__auto__)){
var and__7207__auto____$1 = function$;
if(cljs.core.truth_(and__7207__auto____$1)){
var and__7207__auto____$2 = line;
if(cljs.core.truth_(and__7207__auto____$2)){
return column;
} else {
return and__7207__auto____$2;
}
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,cljs.stacktrace.parse_file(repl_env,file,opts),cljs.core.cst$kw$function,clojure.string.trim(function$),cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,column], null);
} else {
if(clojure.string.blank_QMARK_(function$)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,null,cljs.core.cst$kw$function,clojure.string.trim(function$),cljs.core.cst$kw$line,null,cljs.core.cst$kw$column,null], null);
}
}
});
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$safari,(function (repl_env,st,err,opts){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42328_SHARP_){
return cljs.stacktrace.safari_st_el__GT_frame(repl_env,p1__42328_SHARP_,opts);
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__42327_SHARP_){
return !(cljs.stacktrace.starts_with_QMARK_(p1__42327_SHARP_,"eval code"));
}),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (p1__42326_SHARP_){
return cljs.stacktrace.starts_with_QMARK_(p1__42326_SHARP_,"Error");
}),clojure.string.split_lines(st)))))));
}));
cljs.stacktrace.firefox_clean_function = (function cljs$stacktrace$firefox_clean_function(f){
var f__$1 = f;
var f__$2 = ((clojure.string.blank_QMARK_(f__$1))?null:((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(f__$1.indexOf("</"),(-1)))?(function (){var idx = f__$1.indexOf("</");
return f__$1.substring((idx + (2)));
})():f__$1
));
return clojure.string.replace(clojure.string.replace(f__$2,/</,""),(new RegExp("\\/")),"");
});
cljs.stacktrace.firefox_st_el__GT_frame = (function cljs$stacktrace$firefox_st_el__GT_frame(repl_env,st_el,opts){
var vec__42335 = (cljs.core.truth_(cljs.core.re_find(/@/,st_el))?clojure.string.split.cljs$core$IFn$_invoke$arity$2(st_el,/@/):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,st_el], null));
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42335,(0),null);
var flc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42335,(1),null);
var vec__42338 = cljs.stacktrace.parse_file_line_column(flc);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42338,(0),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42338,(1),null);
var column = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42338,(2),null);
if(cljs.core.truth_((function (){var and__7207__auto__ = file;
if(cljs.core.truth_(and__7207__auto__)){
var and__7207__auto____$1 = function$;
if(cljs.core.truth_(and__7207__auto____$1)){
var and__7207__auto____$2 = line;
if(cljs.core.truth_(and__7207__auto____$2)){
return column;
} else {
return and__7207__auto____$2;
}
} else {
return and__7207__auto____$1;
}
} else {
return and__7207__auto__;
}
})())){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,cljs.stacktrace.parse_file(repl_env,file,opts),cljs.core.cst$kw$function,cljs.stacktrace.firefox_clean_function(function$),cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,column], null);
} else {
if(clojure.string.blank_QMARK_(function$)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,null,cljs.core.cst$kw$function,cljs.stacktrace.firefox_clean_function(function$),cljs.core.cst$kw$line,null,cljs.core.cst$kw$column,null], null);
}
}
});
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$firefox,(function (repl_env,st,err,opts){
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42343_SHARP_){
return cljs.stacktrace.firefox_st_el__GT_frame(repl_env,p1__42343_SHARP_,opts);
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__42342_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__42342_SHARP_.indexOf("> eval"),(-1));
}),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (p1__42341_SHARP_){
return cljs.stacktrace.starts_with_QMARK_(p1__42341_SHARP_,"Error");
}),clojure.string.split_lines(st)))))));
}));
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$rhino,(function (repl_env,st,err,p__42344){
var map__42345 = p__42344;
var map__42345__$1 = ((((!((map__42345 == null)))?((((map__42345.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42345.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42345):map__42345);
var opts = map__42345__$1;
var output_dir = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42345__$1,cljs.core.cst$kw$output_DASH_dir);
var process_frame = ((function (map__42345,map__42345__$1,opts,output_dir){
return (function cljs$stacktrace$process_frame(frame_str){
if((clojure.string.blank_QMARK_(frame_str)) || (((-1) === frame_str.indexOf("\tat")))){
return null;
} else {
var vec__42365 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(frame_str,/:/);
var file_side = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42365,(0),null);
var line_fn_side = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42365,(1),null);
var file = clojure.string.replace(file_side,/\s+at\s+/,"");
var vec__42368 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(line_fn_side,/\s+/);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42368,(0),null);
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42368,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,clojure.string.replace(file,[cljs.core.str(output_dir),cljs.core.str("/")].join(''),""),cljs.core.cst$kw$function,(cljs.core.truth_(function$)?clojure.string.replace(clojure.string.replace(function$,"(",""),")",""):null),cljs.core.cst$kw$line,(cljs.core.truth_((function (){var and__7207__auto__ = line;
if(cljs.core.truth_(and__7207__auto__)){
return !(clojure.string.blank_QMARK_(line));
} else {
return and__7207__auto__;
}
})())?cljs.stacktrace.parse_int(line):null),cljs.core.cst$kw$column,(0)], null);
}
});})(map__42345,map__42345__$1,opts,output_dir))
;
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(process_frame,clojure.string.split.cljs$core$IFn$_invoke$arity$2(st,/\n/))));
}));
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$nashorn,(function (repl_env,st,err,p__42371){
var map__42372 = p__42371;
var map__42372__$1 = ((((!((map__42372 == null)))?((((map__42372.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42372.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42372):map__42372);
var opts = map__42372__$1;
var output_dir = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42372__$1,cljs.core.cst$kw$output_DASH_dir);
var process_frame = ((function (map__42372,map__42372__$1,opts,output_dir){
return (function cljs$stacktrace$process_frame(frame_str){
if((clojure.string.blank_QMARK_(frame_str)) || (((-1) === frame_str.indexOf("\tat")))){
return null;
} else {
var frame_str__$1 = clojure.string.replace(frame_str,/\s+at\s+/,"");
var vec__42392 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(frame_str__$1,/\s+/);
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42392,(0),null);
var file_and_line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42392,(1),null);
var vec__42395 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(file_and_line,/:/);
var file_part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42395,(0),null);
var line_part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42395,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,clojure.string.replace(file_part.substring((1)),[cljs.core.str(output_dir),cljs.core.str("/")].join(''),""),cljs.core.cst$kw$function,function$,cljs.core.cst$kw$line,(cljs.core.truth_((function (){var and__7207__auto__ = line_part;
if(cljs.core.truth_(and__7207__auto__)){
return !(clojure.string.blank_QMARK_(line_part));
} else {
return and__7207__auto__;
}
})())?cljs.stacktrace.parse_int(line_part.substring((0),(cljs.core.count(line_part) - (1)))):null),cljs.core.cst$kw$column,(0)], null);
}
});})(map__42372,map__42372__$1,opts,output_dir))
;
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(process_frame,clojure.string.split.cljs$core$IFn$_invoke$arity$2(st,/\n/))));
}));
cljs.stacktrace.parse_stacktrace.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$nodejs,(function (repl_env,st,err,p__42398){
var map__42399 = p__42398;
var map__42399__$1 = ((((!((map__42399 == null)))?((((map__42399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42399.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42399):map__42399);
var opts = map__42399__$1;
var output_dir = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42399__$1,cljs.core.cst$kw$output_DASH_dir);
var parse_source_loc_info = ((function (map__42399,map__42399__$1,opts,output_dir){
return (function cljs$stacktrace$parse_source_loc_info(x){
if(cljs.core.truth_((function (){var and__7207__auto__ = x;
if(cljs.core.truth_(and__7207__auto__)){
return !(clojure.string.blank_QMARK_(x));
} else {
return and__7207__auto__;
}
})())){
return cljs.stacktrace.parse_int(x);
} else {
return null;
}
});})(map__42399,map__42399__$1,opts,output_dir))
;
var process_frame = ((function (map__42399,map__42399__$1,opts,output_dir){
return (function cljs$stacktrace$process_frame(frame_str){
if((clojure.string.blank_QMARK_(frame_str)) || ((cljs.core.re_find(/^\s+at/,frame_str) == null))){
return null;
} else {
var frame_str__$1 = clojure.string.replace(frame_str,/\s+at\s+/,"");
if(clojure.string.starts_with_QMARK_(frame_str__$1,"repl:")){
return null;
} else {
var parts = clojure.string.split.cljs$core$IFn$_invoke$arity$2(frame_str__$1,/\s+/);
var vec__42422 = ((((2) === cljs.core.count(parts)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parts),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.second(parts),(1),(cljs.core.count(cljs.core.second(parts)) - (1)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.first(parts)], null));
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(0),null);
var file_AMPERSAND_line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42422,(1),null);
var vec__42425 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(file_AMPERSAND_line,/:/);
var file_part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42425,(0),null);
var line_part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42425,(1),null);
var col_part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42425,(2),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$file,(cljs.core.truth_(function$)?(function (){var G__42428 = file_part;
if(cljs.core.truth_(output_dir)){
return clojure.string.replace(G__42428,[cljs.core.str(output_dir),cljs.core.str("/")].join(''),"");
} else {
return G__42428;
}
})():file_part),cljs.core.cst$kw$function,function$,cljs.core.cst$kw$line,parse_source_loc_info(line_part),cljs.core.cst$kw$column,parse_source_loc_info(col_part)], null);
}
}
});})(map__42399,map__42399__$1,opts,output_dir))
;
return cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(process_frame,clojure.string.split.cljs$core$IFn$_invoke$arity$2(st,/\n/))));
}));
cljs.stacktrace.remove_ext = (function cljs$stacktrace$remove_ext(file){
return clojure.string.replace(clojure.string.replace(clojure.string.replace(clojure.string.replace(file,/\.js$/,""),/\.cljs$/,""),/\.cljc$/,""),/\.clj$/,"");
});
/**
 * Given a cljs.source-map source map data structure map a generated line
 * and column back to the original line, column, and function called.
 */
cljs.stacktrace.mapped_line_column_call = (function cljs$stacktrace$mapped_line_column_call(sms,file,line,column){
var source_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sms,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.stacktrace.remove_ext(file),"/",".")));
var get_best_column = ((function (source_map){
return (function cljs$stacktrace$mapped_line_column_call_$_get_best_column(columns,column__$1){
return cljs.core.last((function (){var or__7219__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(columns,cljs.core.last(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (source_map){
return (function (p1__42429_SHARP_){
return (p1__42429_SHARP_ <= (column__$1 - (1)));
});})(source_map))
,cljs.core.sort.cljs$core$IFn$_invoke$arity$1(cljs.core.keys(columns)))));
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.second(cljs.core.first(columns));
}
})());
});})(source_map))
;
var adjust = ((function (source_map){
return (function cljs$stacktrace$mapped_line_column_call_$_adjust(mapped){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (source_map){
return (function (p1__42430_SHARP_,p2__42431_SHARP_){
return (p1__42430_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__42430_SHARP_.cljs$core$IFn$_invoke$arity$1(p2__42431_SHARP_) : p1__42430_SHARP_.call(null,p2__42431_SHARP_));
});})(source_map))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.inc,cljs.core.inc,cljs.core.identity], null),mapped));
});})(source_map))
;
var default$ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,column,null], null);
var temp__6751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(source_map,(line - (1)));
if(cljs.core.truth_(temp__6751__auto__)){
var columns = temp__6751__auto__;
return adjust(cljs.core.map.cljs$core$IFn$_invoke$arity$2(get_best_column(columns,column),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,cljs.core.cst$kw$col,cljs.core.cst$kw$name], null)));
} else {
return default$;
}
});
/**
 * Given opts and a canonicalized JavaScript stacktrace frame, return the
 *   ClojureScript frame.
 */
cljs.stacktrace.mapped_frame = (function cljs$stacktrace$mapped_frame(p__42432,sms,opts){
var map__42438 = p__42432;
var map__42438__$1 = ((((!((map__42438 == null)))?((((map__42438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42438.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42438):map__42438);
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42438__$1,cljs.core.cst$kw$function);
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42438__$1,cljs.core.cst$kw$file);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42438__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42438__$1,cljs.core.cst$kw$column);
var no_source_file_QMARK_ = ((cljs.core.not(file))?true:cljs.stacktrace.starts_with_QMARK_(file,"<"));
var vec__42440 = ((no_source_file_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,column,null], null):cljs.stacktrace.mapped_line_column_call(sms,file,line,column));
var line_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42440,(0),null);
var column_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42440,(1),null);
var call = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42440,(2),null);
var file_SINGLEQUOTE_ = ((no_source_file_QMARK_)?null:((cljs.stacktrace.ends_with_QMARK_(file,".js"))?[cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(file,(0),(cljs.core.count(file) - (3)))),cljs.core.str(".cljs")].join(''):file));
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$function,function$,cljs.core.cst$kw$call,call,cljs.core.cst$kw$file,((no_source_file_QMARK_)?[cljs.core.str("NO_SOURCE_FILE"),cljs.core.str((cljs.core.truth_(file)?[cljs.core.str(" "),cljs.core.str(file)].join(''):null))].join(''):file_SINGLEQUOTE_),cljs.core.cst$kw$line,line_SINGLEQUOTE_,cljs.core.cst$kw$column,column_SINGLEQUOTE_], null);
});
/**
 * Given a vector representing the canonicalized JavaScript stacktrace
 * return the ClojureScript stacktrace. The canonical stacktrace must be
 * in the form:
 * 
 *  [{:file <string>
 *    :function <string>
 *    :line <integer>
 *    :column <integer>}*]
 * 
 * :file must be a URL path (without protocol) relative to :output-dir or a
 * identifier delimited by angle brackets. The returned mapped stacktrace will
 * also contain :url entries to the original sources if it can be determined
 * from the classpath.
 */
cljs.stacktrace.mapped_stacktrace = (function cljs$stacktrace$mapped_stacktrace(var_args){
var args42445 = [];
var len__8435__auto___42448 = arguments.length;
var i__8436__auto___42449 = (0);
while(true){
if((i__8436__auto___42449 < len__8435__auto___42448)){
args42445.push((arguments[i__8436__auto___42449]));

var G__42450 = (i__8436__auto___42449 + (1));
i__8436__auto___42449 = G__42450;
continue;
} else {
}
break;
}

var G__42447 = args42445.length;
switch (G__42447) {
case 2:
return cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42445.length)].join('')));

}
});

cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$2 = (function (stacktrace,sms){
return cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$3(stacktrace,sms,null);
});

cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$3 = (function (stacktrace,sms,opts){
var call__GT_function = (function cljs$stacktrace$call__GT_function(x){
if(cljs.core.truth_(cljs.core.cst$kw$call.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$function],[cljs.core.cst$kw$call.cljs$core$IFn$_invoke$arity$1(x)]);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
var call_merge = (function cljs$stacktrace$call_merge(function$,call){
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((function (munged_fn_name,unmunged_call_name){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(munged_fn_name,clojure.string.replace(cljs.core.munge(unmunged_call_name),".","$"))){
return unmunged_call_name;
} else {
return munged_fn_name;
}
}),cljs.core.array_seq([function$,call], 0));
});
var mapped_frames = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.memoize((function (p1__42443_SHARP_){
return cljs.stacktrace.mapped_frame(p1__42443_SHARP_,sms,opts);
})),stacktrace);
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$3(call_merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (mapped_frames){
return (function (p1__42444_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__42444_SHARP_,cljs.core.cst$kw$call);
});})(mapped_frames))
,mapped_frames),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(cljs.core.map.cljs$core$IFn$_invoke$arity$2(call__GT_function,mapped_frames)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY], null))));
});

cljs.stacktrace.mapped_stacktrace.cljs$lang$maxFixedArity = 3;

/**
 * Given a vector representing the canonicalized JavaScript stacktrace and a map
 *   of library names to decoded source maps, print the ClojureScript stacktrace .
 *   See mapped-stacktrace.
 */
cljs.stacktrace.mapped_stacktrace_str = (function cljs$stacktrace$mapped_stacktrace_str(var_args){
var args42452 = [];
var len__8435__auto___42465 = arguments.length;
var i__8436__auto___42466 = (0);
while(true){
if((i__8436__auto___42466 < len__8435__auto___42465)){
args42452.push((arguments[i__8436__auto___42466]));

var G__42467 = (i__8436__auto___42466 + (1));
i__8436__auto___42466 = G__42467;
continue;
} else {
}
break;
}

var G__42454 = args42452.length;
switch (G__42454) {
case 2:
return cljs.stacktrace.mapped_stacktrace_str.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.stacktrace.mapped_stacktrace_str.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args42452.length)].join('')));

}
});

cljs.stacktrace.mapped_stacktrace_str.cljs$core$IFn$_invoke$arity$2 = (function (stacktrace,sms){
return cljs.stacktrace.mapped_stacktrace_str.cljs$core$IFn$_invoke$arity$3(stacktrace,sms,null);
});

cljs.stacktrace.mapped_stacktrace_str.cljs$core$IFn$_invoke$arity$3 = (function (stacktrace,sms,opts){
var sb__8306__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_42455_42469 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_42456_42470 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_42455_42469,_STAR_print_fn_STAR_42456_42470,sb__8306__auto__){
return (function (x__8307__auto__){
return sb__8306__auto__.append(x__8307__auto__);
});})(_STAR_print_newline_STAR_42455_42469,_STAR_print_fn_STAR_42456_42470,sb__8306__auto__))
;

try{var seq__42457_42471 = cljs.core.seq(cljs.stacktrace.mapped_stacktrace.cljs$core$IFn$_invoke$arity$3(stacktrace,sms,opts));
var chunk__42458_42472 = null;
var count__42459_42473 = (0);
var i__42460_42474 = (0);
while(true){
if((i__42460_42474 < count__42459_42473)){
var map__42461_42475 = chunk__42458_42472.cljs$core$IIndexed$_nth$arity$2(null,i__42460_42474);
var map__42461_42476__$1 = ((((!((map__42461_42475 == null)))?((((map__42461_42475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42461_42475.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42461_42475):map__42461_42475);
var function_42477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42461_42476__$1,cljs.core.cst$kw$function);
var file_42478 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42461_42476__$1,cljs.core.cst$kw$file);
var line_42479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42461_42476__$1,cljs.core.cst$kw$line);
var column_42480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42461_42476__$1,cljs.core.cst$kw$column);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["\t",[cljs.core.str((cljs.core.truth_(function_42477)?[cljs.core.str(function_42477),cljs.core.str(" ")].join(''):null)),cljs.core.str("("),cljs.core.str(file_42478),cljs.core.str((cljs.core.truth_(line_42479)?[cljs.core.str(":"),cljs.core.str(line_42479)].join(''):null)),cljs.core.str((cljs.core.truth_(column_42480)?[cljs.core.str(":"),cljs.core.str(column_42480)].join(''):null)),cljs.core.str(")")].join('')], 0));

var G__42481 = seq__42457_42471;
var G__42482 = chunk__42458_42472;
var G__42483 = count__42459_42473;
var G__42484 = (i__42460_42474 + (1));
seq__42457_42471 = G__42481;
chunk__42458_42472 = G__42482;
count__42459_42473 = G__42483;
i__42460_42474 = G__42484;
continue;
} else {
var temp__6753__auto___42485 = cljs.core.seq(seq__42457_42471);
if(temp__6753__auto___42485){
var seq__42457_42486__$1 = temp__6753__auto___42485;
if(cljs.core.chunked_seq_QMARK_(seq__42457_42486__$1)){
var c__8125__auto___42487 = cljs.core.chunk_first(seq__42457_42486__$1);
var G__42488 = cljs.core.chunk_rest(seq__42457_42486__$1);
var G__42489 = c__8125__auto___42487;
var G__42490 = cljs.core.count(c__8125__auto___42487);
var G__42491 = (0);
seq__42457_42471 = G__42488;
chunk__42458_42472 = G__42489;
count__42459_42473 = G__42490;
i__42460_42474 = G__42491;
continue;
} else {
var map__42463_42492 = cljs.core.first(seq__42457_42486__$1);
var map__42463_42493__$1 = ((((!((map__42463_42492 == null)))?((((map__42463_42492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42463_42492.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42463_42492):map__42463_42492);
var function_42494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42463_42493__$1,cljs.core.cst$kw$function);
var file_42495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42463_42493__$1,cljs.core.cst$kw$file);
var line_42496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42463_42493__$1,cljs.core.cst$kw$line);
var column_42497 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42463_42493__$1,cljs.core.cst$kw$column);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["\t",[cljs.core.str((cljs.core.truth_(function_42494)?[cljs.core.str(function_42494),cljs.core.str(" ")].join(''):null)),cljs.core.str("("),cljs.core.str(file_42495),cljs.core.str((cljs.core.truth_(line_42496)?[cljs.core.str(":"),cljs.core.str(line_42496)].join(''):null)),cljs.core.str((cljs.core.truth_(column_42497)?[cljs.core.str(":"),cljs.core.str(column_42497)].join(''):null)),cljs.core.str(")")].join('')], 0));

var G__42498 = cljs.core.next(seq__42457_42486__$1);
var G__42499 = null;
var G__42500 = (0);
var G__42501 = (0);
seq__42457_42471 = G__42498;
chunk__42458_42472 = G__42499;
count__42459_42473 = G__42500;
i__42460_42474 = G__42501;
continue;
}
} else {
}
}
break;
}
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_42456_42470;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_42455_42469;
}
return [cljs.core.str(sb__8306__auto__)].join('');
});

cljs.stacktrace.mapped_stacktrace_str.cljs$lang$maxFixedArity = 3;

