// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('devtools.formatters.budgeting');
goog.require('cljs.core');
goog.require('devtools.formatters.templating');
goog.require('devtools.formatters.state');
goog.require('devtools.formatters.helpers');
goog.require('devtools.formatters.markup');
devtools.formatters.budgeting.header_expander_depth_cost = (2);
devtools.formatters.budgeting.over_budget_values = ((typeof WeakSet !== 'undefined')?(new WeakSet()):cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY));
devtools.formatters.budgeting.add_over_budget_value_BANG_ = (function devtools$formatters$budgeting$add_over_budget_value_BANG_(value){
if(cljs.core.volatile_QMARK_(devtools.formatters.budgeting.over_budget_values)){
return cljs.core.vreset_BANG_(devtools.formatters.budgeting.over_budget_values,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(devtools.formatters.budgeting.over_budget_values) : cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values)),value));
} else {
var o__24168__auto__ = devtools.formatters.budgeting.over_budget_values;
return goog.object.get(o__24168__auto__,"add").call(o__24168__auto__,value);
}
});
devtools.formatters.budgeting.delete_over_budget_value_BANG_ = (function devtools$formatters$budgeting$delete_over_budget_value_BANG_(value){
if(cljs.core.volatile_QMARK_(devtools.formatters.budgeting.over_budget_values)){
return cljs.core.vreset_BANG_(devtools.formatters.budgeting.over_budget_values,cljs.core.disj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(devtools.formatters.budgeting.over_budget_values) : cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values)),value));
} else {
var o__24168__auto__ = devtools.formatters.budgeting.over_budget_values;
return goog.object.get(o__24168__auto__,"delete").call(o__24168__auto__,value);
}
});
devtools.formatters.budgeting.has_over_budget_value_QMARK_ = (function devtools$formatters$budgeting$has_over_budget_value_QMARK_(value){
if(cljs.core.volatile_QMARK_(devtools.formatters.budgeting.over_budget_values)){
return cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(devtools.formatters.budgeting.over_budget_values) : cljs.core.deref.call(null,devtools.formatters.budgeting.over_budget_values)),value);
} else {
var o__24168__auto__ = devtools.formatters.budgeting.over_budget_values;
return goog.object.get(o__24168__auto__,"has").call(o__24168__auto__,value);
}
});
devtools.formatters.budgeting.object_reference_QMARK_ = (function devtools$formatters$budgeting$object_reference_QMARK_(json_ml){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(json_ml),"object");
});
devtools.formatters.budgeting.determine_depth = (function devtools$formatters$budgeting$determine_depth(json_ml){
if(cljs.core.array_QMARK_(json_ml)){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(devtools.formatters.budgeting.determine_depth,json_ml)) + (1));
} else {
return (0);
}
});
devtools.formatters.budgeting.has_any_object_reference_QMARK_ = (function devtools$formatters$budgeting$has_any_object_reference_QMARK_(json_ml){
if(cljs.core.array_QMARK_(json_ml)){
if(cljs.core.truth_(devtools.formatters.budgeting.object_reference_QMARK_(json_ml))){
return true;
} else {
return cljs.core.some(devtools.formatters.budgeting.has_any_object_reference_QMARK_,json_ml);
}
} else {
return null;
}
});
devtools.formatters.budgeting.transfer_remaining_depth_budget_BANG_ = (function devtools$formatters$budgeting$transfer_remaining_depth_budget_BANG_(object_reference,depth_budget){
if(!((depth_budget < (0)))){
} else {
throw (new Error("Assert failed: (not (neg? depth-budget))"));
}

var data = cljs.core.second(object_reference);
var _ = ((cljs.core.object_QMARK_(data))?null:(function(){throw (new Error("Assert failed: (object? data)"))})());
var config = goog.object.get(data,"config");
var G__27466 = data;
var target__24187__auto__ = G__27466;
if(cljs.core.truth_(target__24187__auto__)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("unable to locate object path "),cljs.core.str(null),cljs.core.str(" in "),cljs.core.str(G__27466)].join('')),cljs.core.str("\n"),cljs.core.str("target__24187__auto__")].join('')));
}

var G__27467_27470 = target__24187__auto__;
var G__27468_27471 = cljs.core.last(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["config"], null));
var G__27469_27472 = devtools.formatters.state.set_depth_budget(config,depth_budget);
goog.object.set(G__27467_27470,G__27468_27471,G__27469_27472);

return G__27466;
});
devtools.formatters.budgeting.distribute_budget_BANG_ = (function devtools$formatters$budgeting$distribute_budget_BANG_(json_ml,depth_budget){
if(!((depth_budget < (0)))){
} else {
throw (new Error("Assert failed: (not (neg? depth-budget))"));
}

if(cljs.core.array_QMARK_(json_ml)){
var new_depth_budget_27481 = (depth_budget - (1));
if(cljs.core.truth_(devtools.formatters.budgeting.object_reference_QMARK_(json_ml))){
devtools.formatters.budgeting.transfer_remaining_depth_budget_BANG_(json_ml,new_depth_budget_27481);
} else {
var seq__27477_27482 = cljs.core.seq(json_ml);
var chunk__27478_27483 = null;
var count__27479_27484 = (0);
var i__27480_27485 = (0);
while(true){
if((i__27480_27485 < count__27479_27484)){
var item_27486 = chunk__27478_27483.cljs$core$IIndexed$_nth$arity$2(null,i__27480_27485);
(devtools.formatters.budgeting.distribute_budget_BANG_.cljs$core$IFn$_invoke$arity$2 ? devtools.formatters.budgeting.distribute_budget_BANG_.cljs$core$IFn$_invoke$arity$2(item_27486,new_depth_budget_27481) : devtools.formatters.budgeting.distribute_budget_BANG_.call(null,item_27486,new_depth_budget_27481));

var G__27487 = seq__27477_27482;
var G__27488 = chunk__27478_27483;
var G__27489 = count__27479_27484;
var G__27490 = (i__27480_27485 + (1));
seq__27477_27482 = G__27487;
chunk__27478_27483 = G__27488;
count__27479_27484 = G__27489;
i__27480_27485 = G__27490;
continue;
} else {
var temp__6753__auto___27491 = cljs.core.seq(seq__27477_27482);
if(temp__6753__auto___27491){
var seq__27477_27492__$1 = temp__6753__auto___27491;
if(cljs.core.chunked_seq_QMARK_(seq__27477_27492__$1)){
var c__8125__auto___27493 = cljs.core.chunk_first(seq__27477_27492__$1);
var G__27494 = cljs.core.chunk_rest(seq__27477_27492__$1);
var G__27495 = c__8125__auto___27493;
var G__27496 = cljs.core.count(c__8125__auto___27493);
var G__27497 = (0);
seq__27477_27482 = G__27494;
chunk__27478_27483 = G__27495;
count__27479_27484 = G__27496;
i__27480_27485 = G__27497;
continue;
} else {
var item_27498 = cljs.core.first(seq__27477_27492__$1);
(devtools.formatters.budgeting.distribute_budget_BANG_.cljs$core$IFn$_invoke$arity$2 ? devtools.formatters.budgeting.distribute_budget_BANG_.cljs$core$IFn$_invoke$arity$2(item_27498,new_depth_budget_27481) : devtools.formatters.budgeting.distribute_budget_BANG_.call(null,item_27498,new_depth_budget_27481));

var G__27499 = cljs.core.next(seq__27477_27492__$1);
var G__27500 = null;
var G__27501 = (0);
var G__27502 = (0);
seq__27477_27482 = G__27499;
chunk__27478_27483 = G__27500;
count__27479_27484 = G__27501;
i__27480_27485 = G__27502;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return json_ml;
});
devtools.formatters.budgeting.was_over_budget_QMARK__BANG_ = (function devtools$formatters$budgeting$was_over_budget_QMARK__BANG_(value){
if(cljs.core.truth_(devtools.formatters.budgeting.has_over_budget_value_QMARK_(value))){
devtools.formatters.budgeting.delete_over_budget_value_BANG_(value);

return true;
} else {
return null;
}
});
devtools.formatters.budgeting.alter_json_ml_to_fit_in_remaining_budget_BANG_ = (function devtools$formatters$budgeting$alter_json_ml_to_fit_in_remaining_budget_BANG_(value,json_ml){
var temp__6751__auto__ = devtools.formatters.helpers.pref(cljs.core.cst$kw$initial_DASH_hierarchy_DASH_depth_DASH_budget);
if(cljs.core.truth_(temp__6751__auto__)){
var initial_hierarchy_depth_budget = temp__6751__auto__;
var remaining_depth_budget = (function (){var or__7219__auto__ = devtools.formatters.state.get_depth_budget();
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return (initial_hierarchy_depth_budget - (1));
}
})();
var depth = devtools.formatters.budgeting.determine_depth(json_ml);
var final_QMARK_ = cljs.core.not(devtools.formatters.budgeting.has_any_object_reference_QMARK_(json_ml));
var needed_depth = ((final_QMARK_)?depth:(depth + devtools.formatters.budgeting.header_expander_depth_cost));
if((remaining_depth_budget >= needed_depth)){
return devtools.formatters.budgeting.distribute_budget_BANG_(json_ml,remaining_depth_budget);
} else {
var expander_ml = devtools.formatters.templating.render_markup(devtools.formatters.markup._LT_header_expander_GT_(value));
devtools.formatters.budgeting.add_over_budget_value_BANG_(value);

return expander_ml;
}
} else {
return json_ml;
}
});
