// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('devtools.toolbox');
goog.require('cljs.core');
goog.require('devtools.protocols');
goog.require('devtools.formatters.templating');
goog.require('devtools.formatters.markup');
/**
 * This is a simple wrapper for logging "busy" objects.
 *   This is especially handy when you happen to be logging javascript objects with many properties.
 *   Standard javascript console renderer tends to print a lot of infomation in the header in some cases and that can make
 *   console output pretty busy. By using envelope you can force your own short header and let the details expand on demand
 *   via disclosure triangle. The header can be styled and you can optionally specify preferred wrapping tag (advanced).
 */
devtools.toolbox.envelope = (function devtools$toolbox$envelope(var_args){
var args40956 = [];
var len__8435__auto___40962 = arguments.length;
var i__8436__auto___40963 = (0);
while(true){
if((i__8436__auto___40963 < len__8435__auto___40962)){
args40956.push((arguments[i__8436__auto___40963]));

var G__40964 = (i__8436__auto___40963 + (1));
i__8436__auto___40963 = G__40964;
continue;
} else {
}
break;
}

var G__40958 = args40956.length;
switch (G__40958) {
case 1:
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40956.length)].join('')));

}
});

devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$1 = (function (obj){
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$2(obj,cljs.core.cst$kw$default_DASH_envelope_DASH_header);
});

devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$2 = (function (obj,header){
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$3(obj,header,cljs.core.cst$kw$default_DASH_envelope_DASH_style);
});

devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$3 = (function (obj,header,style){
return devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$4(obj,header,style,cljs.core.cst$kw$span);
});

devtools.toolbox.envelope.cljs$core$IFn$_invoke$arity$4 = (function (obj,header,style,tag){
if(typeof devtools.toolbox.t_devtools$toolbox40959 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {devtools.protocols.IFormat}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
devtools.toolbox.t_devtools$toolbox40959 = (function (obj,header,style,tag,meta40960){
this.obj = obj;
this.header = header;
this.style = style;
this.tag = tag;
this.meta40960 = meta40960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
devtools.toolbox.t_devtools$toolbox40959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40961,meta40960__$1){
var self__ = this;
var _40961__$1 = this;
return (new devtools.toolbox.t_devtools$toolbox40959(self__.obj,self__.header,self__.style,self__.tag,meta40960__$1));
});

devtools.toolbox.t_devtools$toolbox40959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40961){
var self__ = this;
var _40961__$1 = this;
return self__.meta40960;
});

devtools.toolbox.t_devtools$toolbox40959.prototype.devtools$protocols$IFormat$ = cljs.core.PROTOCOL_SENTINEL;

devtools.toolbox.t_devtools$toolbox40959.prototype.devtools$protocols$IFormat$_header$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return devtools.formatters.templating.render_markup(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.tag,self__.style], null),((cljs.core.fn_QMARK_(self__.header))?(self__.header.cljs$core$IFn$_invoke$arity$1 ? self__.header.cljs$core$IFn$_invoke$arity$1(self__.obj) : self__.header.call(null,self__.obj)):self__.header)], null));
});

devtools.toolbox.t_devtools$toolbox40959.prototype.devtools$protocols$IFormat$_has_body$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

devtools.toolbox.t_devtools$toolbox40959.prototype.devtools$protocols$IFormat$_body$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return devtools.formatters.templating.render_markup(devtools.formatters.markup._LT_body_GT_(devtools.formatters.markup._LT_standard_body_reference_GT_(self__.obj)));
});

devtools.toolbox.t_devtools$toolbox40959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$obj,cljs.core.cst$sym$header,cljs.core.cst$sym$style,cljs.core.cst$sym$tag,cljs.core.cst$sym$meta40960], null);
});

devtools.toolbox.t_devtools$toolbox40959.cljs$lang$type = true;

devtools.toolbox.t_devtools$toolbox40959.cljs$lang$ctorStr = "devtools.toolbox/t_devtools$toolbox40959";

devtools.toolbox.t_devtools$toolbox40959.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"devtools.toolbox/t_devtools$toolbox40959");
});

devtools.toolbox.__GT_t_devtools$toolbox40959 = (function devtools$toolbox$__GT_t_devtools$toolbox40959(obj__$1,header__$1,style__$1,tag__$1,meta40960){
return (new devtools.toolbox.t_devtools$toolbox40959(obj__$1,header__$1,style__$1,tag__$1,meta40960));
});

}

return (new devtools.toolbox.t_devtools$toolbox40959(obj,header,style,tag,cljs.core.PersistentArrayMap.EMPTY));
});

devtools.toolbox.envelope.cljs$lang$maxFixedArity = 4;

/**
 * Forces object to be rendered by cljs-devtools during console logging.
 * 
 *   Unfortunately custom formatters subsystem in DevTools is not applied to primitive values like numbers, strings, null, etc.
 *   This wrapper can be used as a workaround if you really need to force cljs-devtools rendering:
 * 
 *  (.log js/console nil) ; will render 'null'
 *  (.log js/console (force-format nil)) ; will render 'nil' and not 'null'
 * 
 *   See https://github.com/binaryage/cljs-devtools/issues/17
 *   
 */
devtools.toolbox.force_format = (function devtools$toolbox$force_format(obj){
return devtools.formatters.templating.render_markup(devtools.formatters.markup._LT_surrogate_GT_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([obj], 0)));
});
