// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('dommy.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('dommy.utils');
/**
 * Returns a selector in string format.
 * Accepts string, keyword, or collection.
 */
dommy.core.selector = (function dommy$core$selector(data){
if(cljs.core.coll_QMARK_(data)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(dommy.core.selector,data));
} else {
if((typeof data === 'string') || ((data instanceof cljs.core.Keyword))){
return cljs.core.name(data);
} else {
return null;
}
}
});
dommy.core.text = (function dommy$core$text(elem){
var or__7219__auto__ = elem.textContent;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return elem.innerText;
}
});
dommy.core.html = (function dommy$core$html(elem){
return elem.innerHTML;
});
dommy.core.value = (function dommy$core$value(elem){
return elem.value;
});
dommy.core.class$ = (function dommy$core$class(elem){
return elem.className;
});
dommy.core.attr = (function dommy$core$attr(elem,k){
if(cljs.core.truth_(k)){
return elem.getAttribute(dommy.utils.as_str(k));
} else {
return null;
}
});
/**
 * The computed style of `elem`, optionally specifying the key of
 * a particular style to return
 */
dommy.core.style = (function dommy$core$style(var_args){
var args21735 = [];
var len__8435__auto___21738 = arguments.length;
var i__8436__auto___21739 = (0);
while(true){
if((i__8436__auto___21739 < len__8435__auto___21738)){
args21735.push((arguments[i__8436__auto___21739]));

var G__21740 = (i__8436__auto___21739 + (1));
i__8436__auto___21739 = G__21740;
continue;
} else {
}
break;
}

var G__21737 = args21735.length;
switch (G__21737) {
case 1:
return dommy.core.style.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.style.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21735.length)].join('')));

}
});

dommy.core.style.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(window.getComputedStyle(elem));
});

dommy.core.style.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return (window.getComputedStyle(elem)[dommy.utils.as_str(k)]);
});

dommy.core.style.cljs$lang$maxFixedArity = 2;

dommy.core.px = (function dommy$core$px(elem,k){

var pixels = dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,k);
if(cljs.core.seq(pixels)){
return parseInt(pixels);
} else {
return null;
}
});
/**
 * Does `elem` contain `c` in its class list
 */
dommy.core.has_class_QMARK_ = (function dommy$core$has_class_QMARK_(elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__6751__auto__ = elem.classList;
if(cljs.core.truth_(temp__6751__auto__)){
var class_list = temp__6751__auto__;
return class_list.contains(c__$1);
} else {
var temp__6753__auto__ = dommy.core.class$(elem);
if(cljs.core.truth_(temp__6753__auto__)){
var class_name = temp__6753__auto__;
var temp__6753__auto____$1 = dommy.utils.class_index(class_name,c__$1);
if(cljs.core.truth_(temp__6753__auto____$1)){
var i = temp__6753__auto____$1;
return (i >= (0));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Is `elem` hidden (as associated with hide!/show!/toggle!, using display: none)
 */
dommy.core.hidden_QMARK_ = (function dommy$core$hidden_QMARK_(elem){
return (dommy.core.style.cljs$core$IFn$_invoke$arity$2(elem,cljs.core.cst$kw$display) === "none");
});
/**
 * Returns a map of the bounding client rect of `elem`
 * as a map with [:top :left :right :bottom :width :height]
 */
dommy.core.bounding_client_rect = (function dommy$core$bounding_client_rect(elem){
var r = elem.getBoundingClientRect();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$top,r.top,cljs.core.cst$kw$bottom,r.bottom,cljs.core.cst$kw$left,r.left,cljs.core.cst$kw$right,r.right,cljs.core.cst$kw$width,r.width,cljs.core.cst$kw$height,r.height], null);
});
dommy.core.parent = (function dommy$core$parent(elem){
return elem.parentNode;
});
dommy.core.children = (function dommy$core$children(elem){
return elem.children;
});
/**
 * Lazy seq of the ancestors of `elem`
 */
dommy.core.ancestors = (function dommy$core$ancestors(elem){
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.iterate(dommy.core.parent,elem));
});
dommy.core.ancestor_nodes = dommy.core.ancestors;
/**
 * Returns a predicate on nodes that match `selector` at the
 * time of this `matches-pred` call (may return outdated results
 * if you fuck with the DOM)
 */
dommy.core.matches_pred = (function dommy$core$matches_pred(var_args){
var args21742 = [];
var len__8435__auto___21745 = arguments.length;
var i__8436__auto___21746 = (0);
while(true){
if((i__8436__auto___21746 < len__8435__auto___21745)){
args21742.push((arguments[i__8436__auto___21746]));

var G__21747 = (i__8436__auto___21746 + (1));
i__8436__auto___21746 = G__21747;
continue;
} else {
}
break;
}

var G__21744 = args21742.length;
switch (G__21744) {
case 2:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21742.length)].join('')));

}
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2 = (function (base,selector){
var matches = dommy.utils.__GT_Array(base.querySelectorAll(dommy.core.selector(selector)));
return ((function (matches){
return (function (elem){
return (matches.indexOf(elem) >= (0));
});
;})(matches))
});

dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$1 = (function (selector){
return dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(document,selector);
});

dommy.core.matches_pred.cljs$lang$maxFixedArity = 2;

/**
 * Closest ancestor of `elem` (up to `base`, if provided)
 * that matches `selector`
 */
dommy.core.closest = (function dommy$core$closest(var_args){
var args21750 = [];
var len__8435__auto___21753 = arguments.length;
var i__8436__auto___21754 = (0);
while(true){
if((i__8436__auto___21754 < len__8435__auto___21753)){
args21750.push((arguments[i__8436__auto___21754]));

var G__21755 = (i__8436__auto___21754 + (1));
i__8436__auto___21754 = G__21755;
continue;
} else {
}
break;
}

var G__21752 = args21750.length;
switch (G__21752) {
case 3:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return dommy.core.closest.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21750.length)].join('')));

}
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$3 = (function (base,elem,selector){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(dommy.core.matches_pred.cljs$core$IFn$_invoke$arity$2(base,selector),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__21749_SHARP_){
return !((p1__21749_SHARP_ === base));
}),dommy.core.ancestors(elem))));
});

dommy.core.closest.cljs$core$IFn$_invoke$arity$2 = (function (elem,selector){
return dommy.core.closest.cljs$core$IFn$_invoke$arity$3(document.body,elem,selector);
});

dommy.core.closest.cljs$lang$maxFixedArity = 3;

/**
 * Is `descendant` a descendant of `ancestor`?
 * (http://goo.gl/T8pgCX)
 */
dommy.core.descendant_QMARK_ = (function dommy$core$descendant_QMARK_(descendant,ancestor){
if(cljs.core.truth_(ancestor.contains)){
return ancestor.contains(descendant);
} else {
if(cljs.core.truth_(ancestor.compareDocumentPosition)){
return ((ancestor.compareDocumentPosition(descendant) & (1 << (4))) != 0);
} else {
return null;
}
}
});
/**
 * Set the textContent of `elem` to `text`, fall back to innerText
 */
dommy.core.set_text_BANG_ = (function dommy$core$set_text_BANG_(elem,text){
if(!((void 0 === elem.textContent))){
elem.textContent = text;
} else {
elem.innerText = text;
}

return elem;
});
/**
 * Set the innerHTML of `elem` to `html`
 */
dommy.core.set_html_BANG_ = (function dommy$core$set_html_BANG_(elem,html){
elem.innerHTML = html;

return elem;
});
/**
 * Set the value of `elem` to `value`
 */
dommy.core.set_value_BANG_ = (function dommy$core$set_value_BANG_(elem,value){
elem.value = value;

return elem;
});
/**
 * Set the css class of `elem` to `elem`
 */
dommy.core.set_class_BANG_ = (function dommy$core$set_class_BANG_(elem,c){
return elem.className = c;
});
/**
 * Set the style of `elem` using key-value pairs:
 * 
 *    (set-style! elem :display "block" :color "red")
 */
dommy.core.set_style_BANG_ = (function dommy$core$set_style_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___21769 = arguments.length;
var i__8436__auto___21770 = (0);
while(true){
if((i__8436__auto___21770 < len__8435__auto___21769)){
args__8442__auto__.push((arguments[i__8436__auto___21770]));

var G__21771 = (i__8436__auto___21770 + (1));
i__8436__auto___21770 = G__21771;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var style = elem.style;
var seq__21759_21772 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__21760_21773 = null;
var count__21761_21774 = (0);
var i__21762_21775 = (0);
while(true){
if((i__21762_21775 < count__21761_21774)){
var vec__21763_21776 = chunk__21760_21773.cljs$core$IIndexed$_nth$arity$2(null,i__21762_21775);
var k_21777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21763_21776,(0),null);
var v_21778 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21763_21776,(1),null);
style.setProperty(dommy.utils.as_str(k_21777),v_21778);

var G__21779 = seq__21759_21772;
var G__21780 = chunk__21760_21773;
var G__21781 = count__21761_21774;
var G__21782 = (i__21762_21775 + (1));
seq__21759_21772 = G__21779;
chunk__21760_21773 = G__21780;
count__21761_21774 = G__21781;
i__21762_21775 = G__21782;
continue;
} else {
var temp__6753__auto___21783 = cljs.core.seq(seq__21759_21772);
if(temp__6753__auto___21783){
var seq__21759_21784__$1 = temp__6753__auto___21783;
if(cljs.core.chunked_seq_QMARK_(seq__21759_21784__$1)){
var c__8125__auto___21785 = cljs.core.chunk_first(seq__21759_21784__$1);
var G__21786 = cljs.core.chunk_rest(seq__21759_21784__$1);
var G__21787 = c__8125__auto___21785;
var G__21788 = cljs.core.count(c__8125__auto___21785);
var G__21789 = (0);
seq__21759_21772 = G__21786;
chunk__21760_21773 = G__21787;
count__21761_21774 = G__21788;
i__21762_21775 = G__21789;
continue;
} else {
var vec__21766_21790 = cljs.core.first(seq__21759_21784__$1);
var k_21791 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21766_21790,(0),null);
var v_21792 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21766_21790,(1),null);
style.setProperty(dommy.utils.as_str(k_21791),v_21792);

var G__21793 = cljs.core.next(seq__21759_21784__$1);
var G__21794 = null;
var G__21795 = (0);
var G__21796 = (0);
seq__21759_21772 = G__21793;
chunk__21760_21773 = G__21794;
count__21761_21774 = G__21795;
i__21762_21775 = G__21796;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_style_BANG_.cljs$lang$applyTo = (function (seq21757){
var G__21758 = cljs.core.first(seq21757);
var seq21757__$1 = cljs.core.next(seq21757);
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21758,seq21757__$1);
});

/**
 * Remove the style of `elem` using keywords:
 *   
 *    (remove-style! elem :display :color)
 */
dommy.core.remove_style_BANG_ = (function dommy$core$remove_style_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___21803 = arguments.length;
var i__8436__auto___21804 = (0);
while(true){
if((i__8436__auto___21804 < len__8435__auto___21803)){
args__8442__auto__.push((arguments[i__8436__auto___21804]));

var G__21805 = (i__8436__auto___21804 + (1));
i__8436__auto___21804 = G__21805;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,keywords){
var style = elem.style;
var seq__21799_21806 = cljs.core.seq(keywords);
var chunk__21800_21807 = null;
var count__21801_21808 = (0);
var i__21802_21809 = (0);
while(true){
if((i__21802_21809 < count__21801_21808)){
var kw_21810 = chunk__21800_21807.cljs$core$IIndexed$_nth$arity$2(null,i__21802_21809);
style.removeProperty(dommy.utils.as_str(kw_21810));

var G__21811 = seq__21799_21806;
var G__21812 = chunk__21800_21807;
var G__21813 = count__21801_21808;
var G__21814 = (i__21802_21809 + (1));
seq__21799_21806 = G__21811;
chunk__21800_21807 = G__21812;
count__21801_21808 = G__21813;
i__21802_21809 = G__21814;
continue;
} else {
var temp__6753__auto___21815 = cljs.core.seq(seq__21799_21806);
if(temp__6753__auto___21815){
var seq__21799_21816__$1 = temp__6753__auto___21815;
if(cljs.core.chunked_seq_QMARK_(seq__21799_21816__$1)){
var c__8125__auto___21817 = cljs.core.chunk_first(seq__21799_21816__$1);
var G__21818 = cljs.core.chunk_rest(seq__21799_21816__$1);
var G__21819 = c__8125__auto___21817;
var G__21820 = cljs.core.count(c__8125__auto___21817);
var G__21821 = (0);
seq__21799_21806 = G__21818;
chunk__21800_21807 = G__21819;
count__21801_21808 = G__21820;
i__21802_21809 = G__21821;
continue;
} else {
var kw_21822 = cljs.core.first(seq__21799_21816__$1);
style.removeProperty(dommy.utils.as_str(kw_21822));

var G__21823 = cljs.core.next(seq__21799_21816__$1);
var G__21824 = null;
var G__21825 = (0);
var G__21826 = (0);
seq__21799_21806 = G__21823;
chunk__21800_21807 = G__21824;
count__21801_21808 = G__21825;
i__21802_21809 = G__21826;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_style_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.remove_style_BANG_.cljs$lang$applyTo = (function (seq21797){
var G__21798 = cljs.core.first(seq21797);
var seq21797__$1 = cljs.core.next(seq21797);
return dommy.core.remove_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21798,seq21797__$1);
});

dommy.core.set_px_BANG_ = (function dommy$core$set_px_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___21839 = arguments.length;
var i__8436__auto___21840 = (0);
while(true){
if((i__8436__auto___21840 < len__8435__auto___21839)){
args__8442__auto__.push((arguments[i__8436__auto___21840]));

var G__21841 = (i__8436__auto___21840 + (1));
i__8436__auto___21840 = G__21841;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,kvs){

if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__21829_21842 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
var chunk__21830_21843 = null;
var count__21831_21844 = (0);
var i__21832_21845 = (0);
while(true){
if((i__21832_21845 < count__21831_21844)){
var vec__21833_21846 = chunk__21830_21843.cljs$core$IIndexed$_nth$arity$2(null,i__21832_21845);
var k_21847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21833_21846,(0),null);
var v_21848 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21833_21846,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.array_seq([k_21847,[cljs.core.str(v_21848),cljs.core.str("px")].join('')], 0));

var G__21849 = seq__21829_21842;
var G__21850 = chunk__21830_21843;
var G__21851 = count__21831_21844;
var G__21852 = (i__21832_21845 + (1));
seq__21829_21842 = G__21849;
chunk__21830_21843 = G__21850;
count__21831_21844 = G__21851;
i__21832_21845 = G__21852;
continue;
} else {
var temp__6753__auto___21853 = cljs.core.seq(seq__21829_21842);
if(temp__6753__auto___21853){
var seq__21829_21854__$1 = temp__6753__auto___21853;
if(cljs.core.chunked_seq_QMARK_(seq__21829_21854__$1)){
var c__8125__auto___21855 = cljs.core.chunk_first(seq__21829_21854__$1);
var G__21856 = cljs.core.chunk_rest(seq__21829_21854__$1);
var G__21857 = c__8125__auto___21855;
var G__21858 = cljs.core.count(c__8125__auto___21855);
var G__21859 = (0);
seq__21829_21842 = G__21856;
chunk__21830_21843 = G__21857;
count__21831_21844 = G__21858;
i__21832_21845 = G__21859;
continue;
} else {
var vec__21836_21860 = cljs.core.first(seq__21829_21854__$1);
var k_21861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21836_21860,(0),null);
var v_21862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21836_21860,(1),null);
dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.array_seq([k_21861,[cljs.core.str(v_21862),cljs.core.str("px")].join('')], 0));

var G__21863 = cljs.core.next(seq__21829_21854__$1);
var G__21864 = null;
var G__21865 = (0);
var G__21866 = (0);
seq__21829_21842 = G__21863;
chunk__21830_21843 = G__21864;
count__21831_21844 = G__21865;
i__21832_21845 = G__21866;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_px_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.set_px_BANG_.cljs$lang$applyTo = (function (seq21827){
var G__21828 = cljs.core.first(seq21827);
var seq21827__$1 = cljs.core.next(seq21827);
return dommy.core.set_px_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21828,seq21827__$1);
});

/**
 * Sets dom attributes on and returns `elem`.
 * Attributes without values will be set to their name:
 * 
 *     (set-attr! elem :disabled)
 * 
 * With values, the function takes variadic kv pairs:
 * 
 *     (set-attr! elem :id "some-id"
 *                     :name "some-name")
 */
dommy.core.set_attr_BANG_ = (function dommy$core$set_attr_BANG_(var_args){
var args21867 = [];
var len__8435__auto___21886 = arguments.length;
var i__8436__auto___21887 = (0);
while(true){
if((i__8436__auto___21887 < len__8435__auto___21886)){
args21867.push((arguments[i__8436__auto___21887]));

var G__21888 = (i__8436__auto___21887 + (1));
i__8436__auto___21887 = G__21888;
continue;
} else {
}
break;
}

var G__21873 = args21867.length;
switch (G__21873) {
case 2:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args21867.slice((3)),(0),null));
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8458__auto__);

}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,dommy.utils.as_str(k));
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,v){
var k__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(v)){
if(cljs.core.fn_QMARK_(v)){
var G__21874 = elem;
(G__21874[k__$1] = v);

return G__21874;
} else {
var G__21875 = elem;
G__21875.setAttribute(k__$1,v);

return G__21875;
}
} else {
return null;
}
});

dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,v,kvs){
if(cljs.core.even_QMARK_(cljs.core.count(kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

var seq__21876_21890 = cljs.core.seq(cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs)));
var chunk__21877_21891 = null;
var count__21878_21892 = (0);
var i__21879_21893 = (0);
while(true){
if((i__21879_21893 < count__21878_21892)){
var vec__21880_21894 = chunk__21877_21891.cljs$core$IIndexed$_nth$arity$2(null,i__21879_21893);
var k_21895__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21880_21894,(0),null);
var v_21896__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21880_21894,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_21895__$1,v_21896__$1);

var G__21897 = seq__21876_21890;
var G__21898 = chunk__21877_21891;
var G__21899 = count__21878_21892;
var G__21900 = (i__21879_21893 + (1));
seq__21876_21890 = G__21897;
chunk__21877_21891 = G__21898;
count__21878_21892 = G__21899;
i__21879_21893 = G__21900;
continue;
} else {
var temp__6753__auto___21901 = cljs.core.seq(seq__21876_21890);
if(temp__6753__auto___21901){
var seq__21876_21902__$1 = temp__6753__auto___21901;
if(cljs.core.chunked_seq_QMARK_(seq__21876_21902__$1)){
var c__8125__auto___21903 = cljs.core.chunk_first(seq__21876_21902__$1);
var G__21904 = cljs.core.chunk_rest(seq__21876_21902__$1);
var G__21905 = c__8125__auto___21903;
var G__21906 = cljs.core.count(c__8125__auto___21903);
var G__21907 = (0);
seq__21876_21890 = G__21904;
chunk__21877_21891 = G__21905;
count__21878_21892 = G__21906;
i__21879_21893 = G__21907;
continue;
} else {
var vec__21883_21908 = cljs.core.first(seq__21876_21902__$1);
var k_21909__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883_21908,(0),null);
var v_21910__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21883_21908,(1),null);
dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k_21909__$1,v_21910__$1);

var G__21911 = cljs.core.next(seq__21876_21902__$1);
var G__21912 = null;
var G__21913 = (0);
var G__21914 = (0);
seq__21876_21890 = G__21911;
chunk__21877_21891 = G__21912;
count__21878_21892 = G__21913;
i__21879_21893 = G__21914;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.set_attr_BANG_.cljs$lang$applyTo = (function (seq21868){
var G__21869 = cljs.core.first(seq21868);
var seq21868__$1 = cljs.core.next(seq21868);
var G__21870 = cljs.core.first(seq21868__$1);
var seq21868__$2 = cljs.core.next(seq21868__$1);
var G__21871 = cljs.core.first(seq21868__$2);
var seq21868__$3 = cljs.core.next(seq21868__$2);
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21869,G__21870,G__21871,seq21868__$3);
});

dommy.core.set_attr_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Removes dom attributes on and returns `elem`.
 * `class` and `classes` are special cases which clear
 * out the class name on removal.
 */
dommy.core.remove_attr_BANG_ = (function dommy$core$remove_attr_BANG_(var_args){
var args21915 = [];
var len__8435__auto___21925 = arguments.length;
var i__8436__auto___21926 = (0);
while(true){
if((i__8436__auto___21926 < len__8435__auto___21925)){
args21915.push((arguments[i__8436__auto___21926]));

var G__21927 = (i__8436__auto___21926 + (1));
i__8436__auto___21926 = G__21927;
continue;
} else {
}
break;
}

var G__21920 = args21915.length;
switch (G__21920) {
case 2:
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args21915.slice((2)),(0),null));
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8458__auto__);

}
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
var k_21929__$1 = dommy.utils.as_str(k);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["class",null,"classes",null], null), null).call(null,k_21929__$1))){
dommy.core.set_class_BANG_(elem,"");
} else {
elem.removeAttribute(k_21929__$1);
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,k,ks){
var seq__21921_21930 = cljs.core.seq(cljs.core.cons(k,ks));
var chunk__21922_21931 = null;
var count__21923_21932 = (0);
var i__21924_21933 = (0);
while(true){
if((i__21924_21933 < count__21923_21932)){
var k_21934__$1 = chunk__21922_21931.cljs$core$IIndexed$_nth$arity$2(null,i__21924_21933);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_21934__$1);

var G__21935 = seq__21921_21930;
var G__21936 = chunk__21922_21931;
var G__21937 = count__21923_21932;
var G__21938 = (i__21924_21933 + (1));
seq__21921_21930 = G__21935;
chunk__21922_21931 = G__21936;
count__21923_21932 = G__21937;
i__21924_21933 = G__21938;
continue;
} else {
var temp__6753__auto___21939 = cljs.core.seq(seq__21921_21930);
if(temp__6753__auto___21939){
var seq__21921_21940__$1 = temp__6753__auto___21939;
if(cljs.core.chunked_seq_QMARK_(seq__21921_21940__$1)){
var c__8125__auto___21941 = cljs.core.chunk_first(seq__21921_21940__$1);
var G__21942 = cljs.core.chunk_rest(seq__21921_21940__$1);
var G__21943 = c__8125__auto___21941;
var G__21944 = cljs.core.count(c__8125__auto___21941);
var G__21945 = (0);
seq__21921_21930 = G__21942;
chunk__21922_21931 = G__21943;
count__21923_21932 = G__21944;
i__21924_21933 = G__21945;
continue;
} else {
var k_21946__$1 = cljs.core.first(seq__21921_21940__$1);
dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k_21946__$1);

var G__21947 = cljs.core.next(seq__21921_21940__$1);
var G__21948 = null;
var G__21949 = (0);
var G__21950 = (0);
seq__21921_21930 = G__21947;
chunk__21922_21931 = G__21948;
count__21923_21932 = G__21949;
i__21924_21933 = G__21950;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.remove_attr_BANG_.cljs$lang$applyTo = (function (seq21916){
var G__21917 = cljs.core.first(seq21916);
var seq21916__$1 = cljs.core.next(seq21916);
var G__21918 = cljs.core.first(seq21916__$1);
var seq21916__$2 = cljs.core.next(seq21916__$1);
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21917,G__21918,seq21916__$2);
});

dommy.core.remove_attr_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Toggles a dom attribute `k` on `elem`, optionally specifying
 * the boolean value with `add?`
 */
dommy.core.toggle_attr_BANG_ = (function dommy$core$toggle_attr_BANG_(var_args){
var args21951 = [];
var len__8435__auto___21954 = arguments.length;
var i__8436__auto___21955 = (0);
while(true){
if((i__8436__auto___21955 < len__8435__auto___21954)){
args21951.push((arguments[i__8436__auto___21955]));

var G__21956 = (i__8436__auto___21955 + (1));
i__8436__auto___21955 = G__21956;
continue;
} else {
}
break;
}

var G__21953 = args21951.length;
switch (G__21953) {
case 2:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21951.length)].join('')));

}
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,k){
return dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3(elem,k,cljs.core.boolean$(dommy.core.attr(elem,k)));
});

dommy.core.toggle_attr_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,k,add_QMARK_){
if(add_QMARK_){
return dommy.core.set_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
} else {
return dommy.core.remove_attr_BANG_.cljs$core$IFn$_invoke$arity$2(elem,k);
}
});

dommy.core.toggle_attr_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Add `classes` to `elem`, trying to use Element::classList, and
 * falling back to fast string parsing/manipulation
 */
dommy.core.add_class_BANG_ = (function dommy$core$add_class_BANG_(var_args){
var args21958 = [];
var len__8435__auto___21976 = arguments.length;
var i__8436__auto___21977 = (0);
while(true){
if((i__8436__auto___21977 < len__8435__auto___21976)){
args21958.push((arguments[i__8436__auto___21977]));

var G__21978 = (i__8436__auto___21977 + (1));
i__8436__auto___21977 = G__21978;
continue;
} else {
}
break;
}

var G__21963 = args21958.length;
switch (G__21963) {
case 2:
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args21958.slice((2)),(0),null));
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8458__auto__);

}
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,classes){
var classes__$1 = clojure.string.trim(dommy.utils.as_str(classes)).split(/\s+/);
if(cljs.core.seq(classes__$1)){
var temp__6751__auto___21980 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___21980)){
var class_list_21981 = temp__6751__auto___21980;
var seq__21964_21982 = cljs.core.seq(classes__$1);
var chunk__21965_21983 = null;
var count__21966_21984 = (0);
var i__21967_21985 = (0);
while(true){
if((i__21967_21985 < count__21966_21984)){
var c_21986 = chunk__21965_21983.cljs$core$IIndexed$_nth$arity$2(null,i__21967_21985);
class_list_21981.add(c_21986);

var G__21987 = seq__21964_21982;
var G__21988 = chunk__21965_21983;
var G__21989 = count__21966_21984;
var G__21990 = (i__21967_21985 + (1));
seq__21964_21982 = G__21987;
chunk__21965_21983 = G__21988;
count__21966_21984 = G__21989;
i__21967_21985 = G__21990;
continue;
} else {
var temp__6753__auto___21991 = cljs.core.seq(seq__21964_21982);
if(temp__6753__auto___21991){
var seq__21964_21992__$1 = temp__6753__auto___21991;
if(cljs.core.chunked_seq_QMARK_(seq__21964_21992__$1)){
var c__8125__auto___21993 = cljs.core.chunk_first(seq__21964_21992__$1);
var G__21994 = cljs.core.chunk_rest(seq__21964_21992__$1);
var G__21995 = c__8125__auto___21993;
var G__21996 = cljs.core.count(c__8125__auto___21993);
var G__21997 = (0);
seq__21964_21982 = G__21994;
chunk__21965_21983 = G__21995;
count__21966_21984 = G__21996;
i__21967_21985 = G__21997;
continue;
} else {
var c_21998 = cljs.core.first(seq__21964_21992__$1);
class_list_21981.add(c_21998);

var G__21999 = cljs.core.next(seq__21964_21992__$1);
var G__22000 = null;
var G__22001 = (0);
var G__22002 = (0);
seq__21964_21982 = G__21999;
chunk__21965_21983 = G__22000;
count__21966_21984 = G__22001;
i__21967_21985 = G__22002;
continue;
}
} else {
}
}
break;
}
} else {
var seq__21968_22003 = cljs.core.seq(classes__$1);
var chunk__21969_22004 = null;
var count__21970_22005 = (0);
var i__21971_22006 = (0);
while(true){
if((i__21971_22006 < count__21970_22005)){
var c_22007 = chunk__21969_22004.cljs$core$IIndexed$_nth$arity$2(null,i__21971_22006);
var class_name_22008 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_22008,c_22007))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_22008 === ""))?c_22007:[cljs.core.str(class_name_22008),cljs.core.str(" "),cljs.core.str(c_22007)].join('')));
}

var G__22009 = seq__21968_22003;
var G__22010 = chunk__21969_22004;
var G__22011 = count__21970_22005;
var G__22012 = (i__21971_22006 + (1));
seq__21968_22003 = G__22009;
chunk__21969_22004 = G__22010;
count__21970_22005 = G__22011;
i__21971_22006 = G__22012;
continue;
} else {
var temp__6753__auto___22013 = cljs.core.seq(seq__21968_22003);
if(temp__6753__auto___22013){
var seq__21968_22014__$1 = temp__6753__auto___22013;
if(cljs.core.chunked_seq_QMARK_(seq__21968_22014__$1)){
var c__8125__auto___22015 = cljs.core.chunk_first(seq__21968_22014__$1);
var G__22016 = cljs.core.chunk_rest(seq__21968_22014__$1);
var G__22017 = c__8125__auto___22015;
var G__22018 = cljs.core.count(c__8125__auto___22015);
var G__22019 = (0);
seq__21968_22003 = G__22016;
chunk__21969_22004 = G__22017;
count__21970_22005 = G__22018;
i__21971_22006 = G__22019;
continue;
} else {
var c_22020 = cljs.core.first(seq__21968_22014__$1);
var class_name_22021 = dommy.core.class$(elem);
if(cljs.core.truth_(dommy.utils.class_index(class_name_22021,c_22020))){
} else {
dommy.core.set_class_BANG_(elem,(((class_name_22021 === ""))?c_22020:[cljs.core.str(class_name_22021),cljs.core.str(" "),cljs.core.str(c_22020)].join('')));
}

var G__22022 = cljs.core.next(seq__21968_22014__$1);
var G__22023 = null;
var G__22024 = (0);
var G__22025 = (0);
seq__21968_22003 = G__22022;
chunk__21969_22004 = G__22023;
count__21970_22005 = G__22024;
i__21971_22006 = G__22025;
continue;
}
} else {
}
}
break;
}
}
} else {
}

return elem;
});

dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,classes,more_classes){
var seq__21972_22026 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(more_classes,classes));
var chunk__21973_22027 = null;
var count__21974_22028 = (0);
var i__21975_22029 = (0);
while(true){
if((i__21975_22029 < count__21974_22028)){
var c_22030 = chunk__21973_22027.cljs$core$IIndexed$_nth$arity$2(null,i__21975_22029);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_22030);

var G__22031 = seq__21972_22026;
var G__22032 = chunk__21973_22027;
var G__22033 = count__21974_22028;
var G__22034 = (i__21975_22029 + (1));
seq__21972_22026 = G__22031;
chunk__21973_22027 = G__22032;
count__21974_22028 = G__22033;
i__21975_22029 = G__22034;
continue;
} else {
var temp__6753__auto___22035 = cljs.core.seq(seq__21972_22026);
if(temp__6753__auto___22035){
var seq__21972_22036__$1 = temp__6753__auto___22035;
if(cljs.core.chunked_seq_QMARK_(seq__21972_22036__$1)){
var c__8125__auto___22037 = cljs.core.chunk_first(seq__21972_22036__$1);
var G__22038 = cljs.core.chunk_rest(seq__21972_22036__$1);
var G__22039 = c__8125__auto___22037;
var G__22040 = cljs.core.count(c__8125__auto___22037);
var G__22041 = (0);
seq__21972_22026 = G__22038;
chunk__21973_22027 = G__22039;
count__21974_22028 = G__22040;
i__21975_22029 = G__22041;
continue;
} else {
var c_22042 = cljs.core.first(seq__21972_22036__$1);
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c_22042);

var G__22043 = cljs.core.next(seq__21972_22036__$1);
var G__22044 = null;
var G__22045 = (0);
var G__22046 = (0);
seq__21972_22026 = G__22043;
chunk__21973_22027 = G__22044;
count__21974_22028 = G__22045;
i__21975_22029 = G__22046;
continue;
}
} else {
}
}
break;
}

return elem;
});

dommy.core.add_class_BANG_.cljs$lang$applyTo = (function (seq21959){
var G__21960 = cljs.core.first(seq21959);
var seq21959__$1 = cljs.core.next(seq21959);
var G__21961 = cljs.core.first(seq21959__$1);
var seq21959__$2 = cljs.core.next(seq21959__$1);
return dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21960,G__21961,seq21959__$2);
});

dommy.core.add_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Remove `c` from `elem` class list
 */
dommy.core.remove_class_BANG_ = (function dommy$core$remove_class_BANG_(var_args){
var args22047 = [];
var len__8435__auto___22057 = arguments.length;
var i__8436__auto___22058 = (0);
while(true){
if((i__8436__auto___22058 < len__8435__auto___22057)){
args22047.push((arguments[i__8436__auto___22058]));

var G__22059 = (i__8436__auto___22058 + (1));
i__8436__auto___22058 = G__22059;
continue;
} else {
}
break;
}

var G__22052 = args22047.length;
switch (G__22052) {
case 2:
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args22047.slice((2)),(0),null));
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8458__auto__);

}
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__6751__auto___22061 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___22061)){
var class_list_22062 = temp__6751__auto___22061;
class_list_22062.remove(c__$1);
} else {
var class_name_22063 = dommy.core.class$(elem);
var new_class_name_22064 = dommy.utils.remove_class_str(class_name_22063,c__$1);
if((class_name_22063 === new_class_name_22064)){
} else {
dommy.core.set_class_BANG_(elem,new_class_name_22064);
}
}

return elem;
});

dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,class$,classes){
var seq__22053 = cljs.core.seq(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(classes,class$));
var chunk__22054 = null;
var count__22055 = (0);
var i__22056 = (0);
while(true){
if((i__22056 < count__22055)){
var c = chunk__22054.cljs$core$IIndexed$_nth$arity$2(null,i__22056);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);

var G__22065 = seq__22053;
var G__22066 = chunk__22054;
var G__22067 = count__22055;
var G__22068 = (i__22056 + (1));
seq__22053 = G__22065;
chunk__22054 = G__22066;
count__22055 = G__22067;
i__22056 = G__22068;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq(seq__22053);
if(temp__6753__auto__){
var seq__22053__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__22053__$1)){
var c__8125__auto__ = cljs.core.chunk_first(seq__22053__$1);
var G__22069 = cljs.core.chunk_rest(seq__22053__$1);
var G__22070 = c__8125__auto__;
var G__22071 = cljs.core.count(c__8125__auto__);
var G__22072 = (0);
seq__22053 = G__22069;
chunk__22054 = G__22070;
count__22055 = G__22071;
i__22056 = G__22072;
continue;
} else {
var c = cljs.core.first(seq__22053__$1);
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,c);

var G__22073 = cljs.core.next(seq__22053__$1);
var G__22074 = null;
var G__22075 = (0);
var G__22076 = (0);
seq__22053 = G__22073;
chunk__22054 = G__22074;
count__22055 = G__22075;
i__22056 = G__22076;
continue;
}
} else {
return null;
}
}
break;
}
});

dommy.core.remove_class_BANG_.cljs$lang$applyTo = (function (seq22048){
var G__22049 = cljs.core.first(seq22048);
var seq22048__$1 = cljs.core.next(seq22048);
var G__22050 = cljs.core.first(seq22048__$1);
var seq22048__$2 = cljs.core.next(seq22048__$1);
return dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22049,G__22050,seq22048__$2);
});

dommy.core.remove_class_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * (toggle-class! elem class) will add-class! if elem does not have class
 * and remove-class! otherwise.
 * (toggle-class! elem class add?) will add-class! if add? is truthy,
 * otherwise it will remove-class!
 */
dommy.core.toggle_class_BANG_ = (function dommy$core$toggle_class_BANG_(var_args){
var args22077 = [];
var len__8435__auto___22080 = arguments.length;
var i__8436__auto___22081 = (0);
while(true){
if((i__8436__auto___22081 < len__8435__auto___22080)){
args22077.push((arguments[i__8436__auto___22081]));

var G__22082 = (i__8436__auto___22081 + (1));
i__8436__auto___22081 = G__22082;
continue;
} else {
}
break;
}

var G__22079 = args22077.length;
switch (G__22079) {
case 2:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22077.length)].join('')));

}
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,c){
var c__$1 = dommy.utils.as_str(c);
var temp__6751__auto___22084 = elem.classList;
if(cljs.core.truth_(temp__6751__auto___22084)){
var class_list_22085 = temp__6751__auto___22084;
class_list_22085.toggle(c__$1);
} else {
dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3(elem,c__$1,!(dommy.core.has_class_QMARK_(elem,c__$1)));
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (elem,class$,add_QMARK_){
if(add_QMARK_){
dommy.core.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
} else {
dommy.core.remove_class_BANG_.cljs$core$IFn$_invoke$arity$2(elem,class$);
}

return elem;
});

dommy.core.toggle_class_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Display or hide the given `elem` (using display: none).
 * Takes an optional boolean `show?`
 */
dommy.core.toggle_BANG_ = (function dommy$core$toggle_BANG_(var_args){
var args22086 = [];
var len__8435__auto___22089 = arguments.length;
var i__8436__auto___22090 = (0);
while(true){
if((i__8436__auto___22090 < len__8435__auto___22089)){
args22086.push((arguments[i__8436__auto___22090]));

var G__22091 = (i__8436__auto___22090 + (1));
i__8436__auto___22090 = G__22091;
continue;
} else {
}
break;
}

var G__22088 = args22086.length;
switch (G__22088) {
case 2:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22086.length)].join('')));

}
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (elem,show_QMARK_){
return dommy.core.set_style_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem,cljs.core.array_seq([cljs.core.cst$kw$display,((show_QMARK_)?"":"none")], 0));
});

dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,dommy.core.hidden_QMARK_(elem));
});

dommy.core.toggle_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.hide_BANG_ = (function dommy$core$hide_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,false);
});
dommy.core.show_BANG_ = (function dommy$core$show_BANG_(elem){
return dommy.core.toggle_BANG_.cljs$core$IFn$_invoke$arity$2(elem,true);
});
dommy.core.scroll_into_view = (function dommy$core$scroll_into_view(elem,align_with_top_QMARK_){
var top = cljs.core.cst$kw$top.cljs$core$IFn$_invoke$arity$1(dommy.core.bounding_client_rect(elem));
if((window.innerHeight < (top + elem.offsetHeight))){
return elem.scrollIntoView(align_with_top_QMARK_);
} else {
return null;
}
});
dommy.core.create_element = (function dommy$core$create_element(var_args){
var args22093 = [];
var len__8435__auto___22096 = arguments.length;
var i__8436__auto___22097 = (0);
while(true){
if((i__8436__auto___22097 < len__8435__auto___22096)){
args22093.push((arguments[i__8436__auto___22097]));

var G__22098 = (i__8436__auto___22097 + (1));
i__8436__auto___22097 = G__22098;
continue;
} else {
}
break;
}

var G__22095 = args22093.length;
switch (G__22095) {
case 1:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22093.length)].join('')));

}
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return document.createElement(dommy.utils.as_str(tag));
});

dommy.core.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag_ns,tag){
return document.createElementNS(dommy.utils.as_str(tag_ns),dommy.utils.as_str(tag));
});

dommy.core.create_element.cljs$lang$maxFixedArity = 2;

dommy.core.create_text_node = (function dommy$core$create_text_node(text){
return document.createTextNode(text);
});
/**
 * Clears all children from `elem`
 */
dommy.core.clear_BANG_ = (function dommy$core$clear_BANG_(elem){
return dommy.core.set_html_BANG_(elem,"");
});
/**
 * Append `child` to `parent`
 */
dommy.core.append_BANG_ = (function dommy$core$append_BANG_(var_args){
var args22100 = [];
var len__8435__auto___22111 = arguments.length;
var i__8436__auto___22112 = (0);
while(true){
if((i__8436__auto___22112 < len__8435__auto___22111)){
args22100.push((arguments[i__8436__auto___22112]));

var G__22113 = (i__8436__auto___22112 + (1));
i__8436__auto___22112 = G__22113;
continue;
} else {
}
break;
}

var G__22105 = args22100.length;
switch (G__22105) {
case 2:
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args22100.slice((2)),(0),null));
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8458__auto__);

}
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__22106 = parent;
G__22106.appendChild(child);

return G__22106;
});

dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__22107_22115 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__22108_22116 = null;
var count__22109_22117 = (0);
var i__22110_22118 = (0);
while(true){
if((i__22110_22118 < count__22109_22117)){
var c_22119 = chunk__22108_22116.cljs$core$IIndexed$_nth$arity$2(null,i__22110_22118);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_22119);

var G__22120 = seq__22107_22115;
var G__22121 = chunk__22108_22116;
var G__22122 = count__22109_22117;
var G__22123 = (i__22110_22118 + (1));
seq__22107_22115 = G__22120;
chunk__22108_22116 = G__22121;
count__22109_22117 = G__22122;
i__22110_22118 = G__22123;
continue;
} else {
var temp__6753__auto___22124 = cljs.core.seq(seq__22107_22115);
if(temp__6753__auto___22124){
var seq__22107_22125__$1 = temp__6753__auto___22124;
if(cljs.core.chunked_seq_QMARK_(seq__22107_22125__$1)){
var c__8125__auto___22126 = cljs.core.chunk_first(seq__22107_22125__$1);
var G__22127 = cljs.core.chunk_rest(seq__22107_22125__$1);
var G__22128 = c__8125__auto___22126;
var G__22129 = cljs.core.count(c__8125__auto___22126);
var G__22130 = (0);
seq__22107_22115 = G__22127;
chunk__22108_22116 = G__22128;
count__22109_22117 = G__22129;
i__22110_22118 = G__22130;
continue;
} else {
var c_22131 = cljs.core.first(seq__22107_22125__$1);
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_22131);

var G__22132 = cljs.core.next(seq__22107_22125__$1);
var G__22133 = null;
var G__22134 = (0);
var G__22135 = (0);
seq__22107_22115 = G__22132;
chunk__22108_22116 = G__22133;
count__22109_22117 = G__22134;
i__22110_22118 = G__22135;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.append_BANG_.cljs$lang$applyTo = (function (seq22101){
var G__22102 = cljs.core.first(seq22101);
var seq22101__$1 = cljs.core.next(seq22101);
var G__22103 = cljs.core.first(seq22101__$1);
var seq22101__$2 = cljs.core.next(seq22101__$1);
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22102,G__22103,seq22101__$2);
});

dommy.core.append_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Prepend `child` to `parent`
 */
dommy.core.prepend_BANG_ = (function dommy$core$prepend_BANG_(var_args){
var args22136 = [];
var len__8435__auto___22147 = arguments.length;
var i__8436__auto___22148 = (0);
while(true){
if((i__8436__auto___22148 < len__8435__auto___22147)){
args22136.push((arguments[i__8436__auto___22148]));

var G__22149 = (i__8436__auto___22148 + (1));
i__8436__auto___22148 = G__22149;
continue;
} else {
}
break;
}

var G__22141 = args22136.length;
switch (G__22141) {
case 2:
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8458__auto__ = (new cljs.core.IndexedSeq(args22136.slice((2)),(0),null));
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8458__auto__);

}
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (parent,child){
var G__22142 = parent;
G__22142.insertBefore(child,parent.firstChild);

return G__22142;
});

dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (parent,child,more_children){
var seq__22143_22151 = cljs.core.seq(cljs.core.cons(child,more_children));
var chunk__22144_22152 = null;
var count__22145_22153 = (0);
var i__22146_22154 = (0);
while(true){
if((i__22146_22154 < count__22145_22153)){
var c_22155 = chunk__22144_22152.cljs$core$IIndexed$_nth$arity$2(null,i__22146_22154);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_22155);

var G__22156 = seq__22143_22151;
var G__22157 = chunk__22144_22152;
var G__22158 = count__22145_22153;
var G__22159 = (i__22146_22154 + (1));
seq__22143_22151 = G__22156;
chunk__22144_22152 = G__22157;
count__22145_22153 = G__22158;
i__22146_22154 = G__22159;
continue;
} else {
var temp__6753__auto___22160 = cljs.core.seq(seq__22143_22151);
if(temp__6753__auto___22160){
var seq__22143_22161__$1 = temp__6753__auto___22160;
if(cljs.core.chunked_seq_QMARK_(seq__22143_22161__$1)){
var c__8125__auto___22162 = cljs.core.chunk_first(seq__22143_22161__$1);
var G__22163 = cljs.core.chunk_rest(seq__22143_22161__$1);
var G__22164 = c__8125__auto___22162;
var G__22165 = cljs.core.count(c__8125__auto___22162);
var G__22166 = (0);
seq__22143_22151 = G__22163;
chunk__22144_22152 = G__22164;
count__22145_22153 = G__22165;
i__22146_22154 = G__22166;
continue;
} else {
var c_22167 = cljs.core.first(seq__22143_22161__$1);
dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$2(parent,c_22167);

var G__22168 = cljs.core.next(seq__22143_22161__$1);
var G__22169 = null;
var G__22170 = (0);
var G__22171 = (0);
seq__22143_22151 = G__22168;
chunk__22144_22152 = G__22169;
count__22145_22153 = G__22170;
i__22146_22154 = G__22171;
continue;
}
} else {
}
}
break;
}

return parent;
});

dommy.core.prepend_BANG_.cljs$lang$applyTo = (function (seq22137){
var G__22138 = cljs.core.first(seq22137);
var seq22137__$1 = cljs.core.next(seq22137);
var G__22139 = cljs.core.first(seq22137__$1);
var seq22137__$2 = cljs.core.next(seq22137__$1);
return dommy.core.prepend_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22138,G__22139,seq22137__$2);
});

dommy.core.prepend_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Insert `elem` before `other`, `other` must have a parent
 */
dommy.core.insert_before_BANG_ = (function dommy$core$insert_before_BANG_(elem,other){
var p = dommy.core.parent(other);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

p.insertBefore(elem,other);

return elem;
});
/**
 * Insert `elem` after `other`, `other` must have a parent
 */
dommy.core.insert_after_BANG_ = (function dommy$core$insert_after_BANG_(elem,other){
var temp__6751__auto___22172 = other.nextSibling;
if(cljs.core.truth_(temp__6751__auto___22172)){
var next_22173 = temp__6751__auto___22172;
dommy.core.insert_before_BANG_(elem,next_22173);
} else {
dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.parent(other),elem);
}

return elem;
});
/**
 * Replace `elem` with `new`, return `new`
 */
dommy.core.replace_BANG_ = (function dommy$core$replace_BANG_(elem,new$){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

p.replaceChild(new$,elem);

return new$;
});
/**
 * Replace children of `elem` with `child`
 */
dommy.core.replace_contents_BANG_ = (function dommy$core$replace_contents_BANG_(p,child){
return dommy.core.append_BANG_.cljs$core$IFn$_invoke$arity$2(dommy.core.clear_BANG_(p),child);
});
/**
 * Remove `elem` from `parent`, return `parent`
 */
dommy.core.remove_BANG_ = (function dommy$core$remove_BANG_(var_args){
var args22174 = [];
var len__8435__auto___22178 = arguments.length;
var i__8436__auto___22179 = (0);
while(true){
if((i__8436__auto___22179 < len__8435__auto___22178)){
args22174.push((arguments[i__8436__auto___22179]));

var G__22180 = (i__8436__auto___22179 + (1));
i__8436__auto___22179 = G__22180;
continue;
} else {
}
break;
}

var G__22176 = args22174.length;
switch (G__22176) {
case 1:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args22174.length)].join('')));

}
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (elem){
var p = dommy.core.parent(elem);
if(cljs.core.truth_(p)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Target element must have a parent"),cljs.core.str("\n"),cljs.core.str("p")].join('')));
}

return dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2(p,elem);
});

dommy.core.remove_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
var G__22177 = p;
G__22177.removeChild(elem);

return G__22177;
});

dommy.core.remove_BANG_.cljs$lang$maxFixedArity = 2;

dommy.core.special_listener_makers = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__22182){
var vec__22183 = p__22182;
var special_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22183,(0),null);
var real_mouse_event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22183,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [special_mouse_event,cljs.core.PersistentArrayMap.fromArray([real_mouse_event,((function (vec__22183,special_mouse_event,real_mouse_event){
return (function (f){
return ((function (vec__22183,special_mouse_event,real_mouse_event){
return (function (event){
var related_target = event.relatedTarget;
var listener_target = (function (){var or__7219__auto__ = event.selectedTarget;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return event.currentTarget;
}
})();
if(cljs.core.truth_((function (){var and__7207__auto__ = related_target;
if(cljs.core.truth_(and__7207__auto__)){
return dommy.core.descendant_QMARK_(related_target,listener_target);
} else {
return and__7207__auto__;
}
})())){
return null;
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
}
});
;})(vec__22183,special_mouse_event,real_mouse_event))
});})(vec__22183,special_mouse_event,real_mouse_event))
], true, false)], null);
}),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$mouseenter,cljs.core.cst$kw$mouseover,cljs.core.cst$kw$mouseleave,cljs.core.cst$kw$mouseout], null)));
/**
 * fires f if event.target is found with `selector`
 */
dommy.core.live_listener = (function dommy$core$live_listener(elem,selector,f){
return (function (event){
var selected_target = dommy.core.closest.cljs$core$IFn$_invoke$arity$3(elem,event.target,selector);
if(cljs.core.truth_((function (){var and__7207__auto__ = selected_target;
if(cljs.core.truth_(and__7207__auto__)){
return cljs.core.not(dommy.core.attr(selected_target,cljs.core.cst$kw$disabled));
} else {
return and__7207__auto__;
}
})())){
event.selectedTarget = selected_target;

return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(event) : f.call(null,event));
} else {
return null;
}
});
});
/**
 * Returns a nested map of event listeners on `elem`
 */
dommy.core.event_listeners = (function dommy$core$event_listeners(elem){
var or__7219__auto__ = elem.dommyEventListeners;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
dommy.core.update_event_listeners_BANG_ = (function dommy$core$update_event_listeners_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___22189 = arguments.length;
var i__8436__auto___22190 = (0);
while(true){
if((i__8436__auto___22190 < len__8435__auto___22189)){
args__8442__auto__.push((arguments[i__8436__auto___22190]));

var G__22191 = (i__8436__auto___22190 + (1));
i__8436__auto___22190 = G__22191;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem,f,args){
var elem__$1 = elem;
return elem__$1.dommyEventListeners = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,dommy.core.event_listeners(elem__$1),args);
});

dommy.core.update_event_listeners_BANG_.cljs$lang$maxFixedArity = (2);

dommy.core.update_event_listeners_BANG_.cljs$lang$applyTo = (function (seq22186){
var G__22187 = cljs.core.first(seq22186);
var seq22186__$1 = cljs.core.next(seq22186);
var G__22188 = cljs.core.first(seq22186__$1);
var seq22186__$2 = cljs.core.next(seq22186__$1);
return dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22187,G__22188,seq22186__$2);
});

dommy.core.elem_and_selector = (function dommy$core$elem_and_selector(elem_sel){
if(cljs.core.sequential_QMARK_(elem_sel)){
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.rest).call(null,elem_sel);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [elem_sel,null], null);
}
});
/**
 * Adds `f` as a listener for events of type `event-type` on
 * `elem-sel`, which must either be a DOM node, or a sequence
 * whose first item is a DOM node.
 * 
 * In other words, the call to `listen!` can take two forms:
 * 
 * If `elem-sel` is a DOM node, i.e., you're doing something like:
 * 
 *     (listen! elem :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on the `elem`.
 * 
 * If `elem-sel` is a sequence:
 * 
 *     (listen! [elem :.selector.for :.some.descendants] :click click-handler)
 * 
 * then `click-handler` will be set as a listener for `click` events
 * on descendants of `elem` that match the selector
 * 
 * Also accepts any number of event-type and handler pairs for setting
 * multiple listeners at once:
 * 
 *     (listen! some-elem :click click-handler :hover hover-handler)
 */
dommy.core.listen_BANG_ = (function dommy$core$listen_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___22231 = arguments.length;
var i__8436__auto___22232 = (0);
while(true){
if((i__8436__auto___22232 < len__8435__auto___22231)){
args__8442__auto__.push((arguments[i__8436__auto___22232]));

var G__22233 = (i__8436__auto___22232 + (1));
i__8436__auto___22232 = G__22233;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__22194_22234 = dommy.core.elem_and_selector(elem_sel);
var elem_22235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22194_22234,(0),null);
var selector_22236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22194_22234,(1),null);
var seq__22197_22237 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__22204_22238 = null;
var count__22205_22239 = (0);
var i__22206_22240 = (0);
while(true){
if((i__22206_22240 < count__22205_22239)){
var vec__22213_22241 = chunk__22204_22238.cljs$core$IIndexed$_nth$arity$2(null,i__22206_22240);
var orig_type_22242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22213_22241,(0),null);
var f_22243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22213_22241,(1),null);
var seq__22207_22244 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_22242,cljs.core.PersistentArrayMap.fromArray([orig_type_22242,cljs.core.identity], true, false)));
var chunk__22209_22245 = null;
var count__22210_22246 = (0);
var i__22211_22247 = (0);
while(true){
if((i__22211_22247 < count__22210_22246)){
var vec__22216_22248 = chunk__22209_22245.cljs$core$IIndexed$_nth$arity$2(null,i__22211_22247);
var actual_type_22249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22216_22248,(0),null);
var factory_22250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22216_22248,(1),null);
var canonical_f_22251 = (cljs.core.truth_(selector_22236)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_22235,selector_22236):cljs.core.identity).call(null,(factory_22250.cljs$core$IFn$_invoke$arity$1 ? factory_22250.cljs$core$IFn$_invoke$arity$1(f_22243) : factory_22250.call(null,f_22243)));
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22235,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22236,actual_type_22249,f_22243], null),canonical_f_22251], 0));

if(cljs.core.truth_(elem_22235.addEventListener)){
elem_22235.addEventListener(cljs.core.name(actual_type_22249),canonical_f_22251);
} else {
elem_22235.attachEvent(cljs.core.name(actual_type_22249),canonical_f_22251);
}

var G__22252 = seq__22207_22244;
var G__22253 = chunk__22209_22245;
var G__22254 = count__22210_22246;
var G__22255 = (i__22211_22247 + (1));
seq__22207_22244 = G__22252;
chunk__22209_22245 = G__22253;
count__22210_22246 = G__22254;
i__22211_22247 = G__22255;
continue;
} else {
var temp__6753__auto___22256 = cljs.core.seq(seq__22207_22244);
if(temp__6753__auto___22256){
var seq__22207_22257__$1 = temp__6753__auto___22256;
if(cljs.core.chunked_seq_QMARK_(seq__22207_22257__$1)){
var c__8125__auto___22258 = cljs.core.chunk_first(seq__22207_22257__$1);
var G__22259 = cljs.core.chunk_rest(seq__22207_22257__$1);
var G__22260 = c__8125__auto___22258;
var G__22261 = cljs.core.count(c__8125__auto___22258);
var G__22262 = (0);
seq__22207_22244 = G__22259;
chunk__22209_22245 = G__22260;
count__22210_22246 = G__22261;
i__22211_22247 = G__22262;
continue;
} else {
var vec__22219_22263 = cljs.core.first(seq__22207_22257__$1);
var actual_type_22264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22219_22263,(0),null);
var factory_22265 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22219_22263,(1),null);
var canonical_f_22266 = (cljs.core.truth_(selector_22236)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_22235,selector_22236):cljs.core.identity).call(null,(factory_22265.cljs$core$IFn$_invoke$arity$1 ? factory_22265.cljs$core$IFn$_invoke$arity$1(f_22243) : factory_22265.call(null,f_22243)));
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22235,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22236,actual_type_22264,f_22243], null),canonical_f_22266], 0));

if(cljs.core.truth_(elem_22235.addEventListener)){
elem_22235.addEventListener(cljs.core.name(actual_type_22264),canonical_f_22266);
} else {
elem_22235.attachEvent(cljs.core.name(actual_type_22264),canonical_f_22266);
}

var G__22267 = cljs.core.next(seq__22207_22257__$1);
var G__22268 = null;
var G__22269 = (0);
var G__22270 = (0);
seq__22207_22244 = G__22267;
chunk__22209_22245 = G__22268;
count__22210_22246 = G__22269;
i__22211_22247 = G__22270;
continue;
}
} else {
}
}
break;
}

var G__22271 = seq__22197_22237;
var G__22272 = chunk__22204_22238;
var G__22273 = count__22205_22239;
var G__22274 = (i__22206_22240 + (1));
seq__22197_22237 = G__22271;
chunk__22204_22238 = G__22272;
count__22205_22239 = G__22273;
i__22206_22240 = G__22274;
continue;
} else {
var temp__6753__auto___22275 = cljs.core.seq(seq__22197_22237);
if(temp__6753__auto___22275){
var seq__22197_22276__$1 = temp__6753__auto___22275;
if(cljs.core.chunked_seq_QMARK_(seq__22197_22276__$1)){
var c__8125__auto___22277 = cljs.core.chunk_first(seq__22197_22276__$1);
var G__22278 = cljs.core.chunk_rest(seq__22197_22276__$1);
var G__22279 = c__8125__auto___22277;
var G__22280 = cljs.core.count(c__8125__auto___22277);
var G__22281 = (0);
seq__22197_22237 = G__22278;
chunk__22204_22238 = G__22279;
count__22205_22239 = G__22280;
i__22206_22240 = G__22281;
continue;
} else {
var vec__22222_22282 = cljs.core.first(seq__22197_22276__$1);
var orig_type_22283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22222_22282,(0),null);
var f_22284 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22222_22282,(1),null);
var seq__22198_22285 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_22283,cljs.core.PersistentArrayMap.fromArray([orig_type_22283,cljs.core.identity], true, false)));
var chunk__22200_22286 = null;
var count__22201_22287 = (0);
var i__22202_22288 = (0);
while(true){
if((i__22202_22288 < count__22201_22287)){
var vec__22225_22289 = chunk__22200_22286.cljs$core$IIndexed$_nth$arity$2(null,i__22202_22288);
var actual_type_22290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22225_22289,(0),null);
var factory_22291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22225_22289,(1),null);
var canonical_f_22292 = (cljs.core.truth_(selector_22236)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_22235,selector_22236):cljs.core.identity).call(null,(factory_22291.cljs$core$IFn$_invoke$arity$1 ? factory_22291.cljs$core$IFn$_invoke$arity$1(f_22284) : factory_22291.call(null,f_22284)));
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22235,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22236,actual_type_22290,f_22284], null),canonical_f_22292], 0));

if(cljs.core.truth_(elem_22235.addEventListener)){
elem_22235.addEventListener(cljs.core.name(actual_type_22290),canonical_f_22292);
} else {
elem_22235.attachEvent(cljs.core.name(actual_type_22290),canonical_f_22292);
}

var G__22293 = seq__22198_22285;
var G__22294 = chunk__22200_22286;
var G__22295 = count__22201_22287;
var G__22296 = (i__22202_22288 + (1));
seq__22198_22285 = G__22293;
chunk__22200_22286 = G__22294;
count__22201_22287 = G__22295;
i__22202_22288 = G__22296;
continue;
} else {
var temp__6753__auto___22297__$1 = cljs.core.seq(seq__22198_22285);
if(temp__6753__auto___22297__$1){
var seq__22198_22298__$1 = temp__6753__auto___22297__$1;
if(cljs.core.chunked_seq_QMARK_(seq__22198_22298__$1)){
var c__8125__auto___22299 = cljs.core.chunk_first(seq__22198_22298__$1);
var G__22300 = cljs.core.chunk_rest(seq__22198_22298__$1);
var G__22301 = c__8125__auto___22299;
var G__22302 = cljs.core.count(c__8125__auto___22299);
var G__22303 = (0);
seq__22198_22285 = G__22300;
chunk__22200_22286 = G__22301;
count__22201_22287 = G__22302;
i__22202_22288 = G__22303;
continue;
} else {
var vec__22228_22304 = cljs.core.first(seq__22198_22298__$1);
var actual_type_22305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22228_22304,(0),null);
var factory_22306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22228_22304,(1),null);
var canonical_f_22307 = (cljs.core.truth_(selector_22236)?cljs.core.partial.cljs$core$IFn$_invoke$arity$3(dommy.core.live_listener,elem_22235,selector_22236):cljs.core.identity).call(null,(factory_22306.cljs$core$IFn$_invoke$arity$1 ? factory_22306.cljs$core$IFn$_invoke$arity$1(f_22284) : factory_22306.call(null,f_22284)));
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22235,cljs.core.assoc_in,cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22236,actual_type_22305,f_22284], null),canonical_f_22307], 0));

if(cljs.core.truth_(elem_22235.addEventListener)){
elem_22235.addEventListener(cljs.core.name(actual_type_22305),canonical_f_22307);
} else {
elem_22235.attachEvent(cljs.core.name(actual_type_22305),canonical_f_22307);
}

var G__22308 = cljs.core.next(seq__22198_22298__$1);
var G__22309 = null;
var G__22310 = (0);
var G__22311 = (0);
seq__22198_22285 = G__22308;
chunk__22200_22286 = G__22309;
count__22201_22287 = G__22310;
i__22202_22288 = G__22311;
continue;
}
} else {
}
}
break;
}

var G__22312 = cljs.core.next(seq__22197_22276__$1);
var G__22313 = null;
var G__22314 = (0);
var G__22315 = (0);
seq__22197_22237 = G__22312;
chunk__22204_22238 = G__22313;
count__22205_22239 = G__22314;
i__22206_22240 = G__22315;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_BANG_.cljs$lang$applyTo = (function (seq22192){
var G__22193 = cljs.core.first(seq22192);
var seq22192__$1 = cljs.core.next(seq22192);
return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22193,seq22192__$1);
});

/**
 * Removes event listener for the element defined in `elem-sel`,
 * which is the same format as listen!.
 * 
 *   The following forms are allowed, and will remove all handlers
 *   that match the parameters passed in:
 * 
 *    (unlisten! [elem :.selector] :click event-listener)
 * 
 *    (unlisten! [elem :.selector]
 *      :click event-listener
 *      :mouseover other-event-listener)
 */
dommy.core.unlisten_BANG_ = (function dommy$core$unlisten_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___22355 = arguments.length;
var i__8436__auto___22356 = (0);
while(true){
if((i__8436__auto___22356 < len__8435__auto___22355)){
args__8442__auto__.push((arguments[i__8436__auto___22356]));

var G__22357 = (i__8436__auto___22356 + (1));
i__8436__auto___22356 = G__22357;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__22318_22358 = dommy.core.elem_and_selector(elem_sel);
var elem_22359 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22318_22358,(0),null);
var selector_22360 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22318_22358,(1),null);
var seq__22321_22361 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__22328_22362 = null;
var count__22329_22363 = (0);
var i__22330_22364 = (0);
while(true){
if((i__22330_22364 < count__22329_22363)){
var vec__22337_22365 = chunk__22328_22362.cljs$core$IIndexed$_nth$arity$2(null,i__22330_22364);
var orig_type_22366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22337_22365,(0),null);
var f_22367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22337_22365,(1),null);
var seq__22331_22368 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_22366,cljs.core.PersistentArrayMap.fromArray([orig_type_22366,cljs.core.identity], true, false)));
var chunk__22333_22369 = null;
var count__22334_22370 = (0);
var i__22335_22371 = (0);
while(true){
if((i__22335_22371 < count__22334_22370)){
var vec__22340_22372 = chunk__22333_22369.cljs$core$IIndexed$_nth$arity$2(null,i__22335_22371);
var actual_type_22373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22340_22372,(0),null);
var __22374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22340_22372,(1),null);
var keys_22375 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22360,actual_type_22373,f_22367], null);
var canonical_f_22376 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_22359),keys_22375);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22359,dommy.utils.dissoc_in,cljs.core.array_seq([keys_22375], 0));

if(cljs.core.truth_(elem_22359.removeEventListener)){
elem_22359.removeEventListener(cljs.core.name(actual_type_22373),canonical_f_22376);
} else {
elem_22359.detachEvent(cljs.core.name(actual_type_22373),canonical_f_22376);
}

var G__22377 = seq__22331_22368;
var G__22378 = chunk__22333_22369;
var G__22379 = count__22334_22370;
var G__22380 = (i__22335_22371 + (1));
seq__22331_22368 = G__22377;
chunk__22333_22369 = G__22378;
count__22334_22370 = G__22379;
i__22335_22371 = G__22380;
continue;
} else {
var temp__6753__auto___22381 = cljs.core.seq(seq__22331_22368);
if(temp__6753__auto___22381){
var seq__22331_22382__$1 = temp__6753__auto___22381;
if(cljs.core.chunked_seq_QMARK_(seq__22331_22382__$1)){
var c__8125__auto___22383 = cljs.core.chunk_first(seq__22331_22382__$1);
var G__22384 = cljs.core.chunk_rest(seq__22331_22382__$1);
var G__22385 = c__8125__auto___22383;
var G__22386 = cljs.core.count(c__8125__auto___22383);
var G__22387 = (0);
seq__22331_22368 = G__22384;
chunk__22333_22369 = G__22385;
count__22334_22370 = G__22386;
i__22335_22371 = G__22387;
continue;
} else {
var vec__22343_22388 = cljs.core.first(seq__22331_22382__$1);
var actual_type_22389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22343_22388,(0),null);
var __22390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22343_22388,(1),null);
var keys_22391 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22360,actual_type_22389,f_22367], null);
var canonical_f_22392 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_22359),keys_22391);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22359,dommy.utils.dissoc_in,cljs.core.array_seq([keys_22391], 0));

if(cljs.core.truth_(elem_22359.removeEventListener)){
elem_22359.removeEventListener(cljs.core.name(actual_type_22389),canonical_f_22392);
} else {
elem_22359.detachEvent(cljs.core.name(actual_type_22389),canonical_f_22392);
}

var G__22393 = cljs.core.next(seq__22331_22382__$1);
var G__22394 = null;
var G__22395 = (0);
var G__22396 = (0);
seq__22331_22368 = G__22393;
chunk__22333_22369 = G__22394;
count__22334_22370 = G__22395;
i__22335_22371 = G__22396;
continue;
}
} else {
}
}
break;
}

var G__22397 = seq__22321_22361;
var G__22398 = chunk__22328_22362;
var G__22399 = count__22329_22363;
var G__22400 = (i__22330_22364 + (1));
seq__22321_22361 = G__22397;
chunk__22328_22362 = G__22398;
count__22329_22363 = G__22399;
i__22330_22364 = G__22400;
continue;
} else {
var temp__6753__auto___22401 = cljs.core.seq(seq__22321_22361);
if(temp__6753__auto___22401){
var seq__22321_22402__$1 = temp__6753__auto___22401;
if(cljs.core.chunked_seq_QMARK_(seq__22321_22402__$1)){
var c__8125__auto___22403 = cljs.core.chunk_first(seq__22321_22402__$1);
var G__22404 = cljs.core.chunk_rest(seq__22321_22402__$1);
var G__22405 = c__8125__auto___22403;
var G__22406 = cljs.core.count(c__8125__auto___22403);
var G__22407 = (0);
seq__22321_22361 = G__22404;
chunk__22328_22362 = G__22405;
count__22329_22363 = G__22406;
i__22330_22364 = G__22407;
continue;
} else {
var vec__22346_22408 = cljs.core.first(seq__22321_22402__$1);
var orig_type_22409 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22346_22408,(0),null);
var f_22410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22346_22408,(1),null);
var seq__22322_22411 = cljs.core.seq(cljs.core.get.cljs$core$IFn$_invoke$arity$3(dommy.core.special_listener_makers,orig_type_22409,cljs.core.PersistentArrayMap.fromArray([orig_type_22409,cljs.core.identity], true, false)));
var chunk__22324_22412 = null;
var count__22325_22413 = (0);
var i__22326_22414 = (0);
while(true){
if((i__22326_22414 < count__22325_22413)){
var vec__22349_22415 = chunk__22324_22412.cljs$core$IIndexed$_nth$arity$2(null,i__22326_22414);
var actual_type_22416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22349_22415,(0),null);
var __22417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22349_22415,(1),null);
var keys_22418 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22360,actual_type_22416,f_22410], null);
var canonical_f_22419 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_22359),keys_22418);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22359,dommy.utils.dissoc_in,cljs.core.array_seq([keys_22418], 0));

if(cljs.core.truth_(elem_22359.removeEventListener)){
elem_22359.removeEventListener(cljs.core.name(actual_type_22416),canonical_f_22419);
} else {
elem_22359.detachEvent(cljs.core.name(actual_type_22416),canonical_f_22419);
}

var G__22420 = seq__22322_22411;
var G__22421 = chunk__22324_22412;
var G__22422 = count__22325_22413;
var G__22423 = (i__22326_22414 + (1));
seq__22322_22411 = G__22420;
chunk__22324_22412 = G__22421;
count__22325_22413 = G__22422;
i__22326_22414 = G__22423;
continue;
} else {
var temp__6753__auto___22424__$1 = cljs.core.seq(seq__22322_22411);
if(temp__6753__auto___22424__$1){
var seq__22322_22425__$1 = temp__6753__auto___22424__$1;
if(cljs.core.chunked_seq_QMARK_(seq__22322_22425__$1)){
var c__8125__auto___22426 = cljs.core.chunk_first(seq__22322_22425__$1);
var G__22427 = cljs.core.chunk_rest(seq__22322_22425__$1);
var G__22428 = c__8125__auto___22426;
var G__22429 = cljs.core.count(c__8125__auto___22426);
var G__22430 = (0);
seq__22322_22411 = G__22427;
chunk__22324_22412 = G__22428;
count__22325_22413 = G__22429;
i__22326_22414 = G__22430;
continue;
} else {
var vec__22352_22431 = cljs.core.first(seq__22322_22425__$1);
var actual_type_22432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22352_22431,(0),null);
var __22433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22352_22431,(1),null);
var keys_22434 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [selector_22360,actual_type_22432,f_22410], null);
var canonical_f_22435 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(dommy.core.event_listeners(elem_22359),keys_22434);
dommy.core.update_event_listeners_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_22359,dommy.utils.dissoc_in,cljs.core.array_seq([keys_22434], 0));

if(cljs.core.truth_(elem_22359.removeEventListener)){
elem_22359.removeEventListener(cljs.core.name(actual_type_22432),canonical_f_22435);
} else {
elem_22359.detachEvent(cljs.core.name(actual_type_22432),canonical_f_22435);
}

var G__22436 = cljs.core.next(seq__22322_22425__$1);
var G__22437 = null;
var G__22438 = (0);
var G__22439 = (0);
seq__22322_22411 = G__22436;
chunk__22324_22412 = G__22437;
count__22325_22413 = G__22438;
i__22326_22414 = G__22439;
continue;
}
} else {
}
}
break;
}

var G__22440 = cljs.core.next(seq__22321_22402__$1);
var G__22441 = null;
var G__22442 = (0);
var G__22443 = (0);
seq__22321_22361 = G__22440;
chunk__22328_22362 = G__22441;
count__22329_22363 = G__22442;
i__22330_22364 = G__22443;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.unlisten_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.unlisten_BANG_.cljs$lang$applyTo = (function (seq22316){
var G__22317 = cljs.core.first(seq22316);
var seq22316__$1 = cljs.core.next(seq22316);
return dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22317,seq22316__$1);
});

/**
 * Behaves like `listen!`, but removes the listener after the first event occurs.
 */
dommy.core.listen_once_BANG_ = (function dommy$core$listen_once_BANG_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___22459 = arguments.length;
var i__8436__auto___22460 = (0);
while(true){
if((i__8436__auto___22460 < len__8435__auto___22459)){
args__8442__auto__.push((arguments[i__8436__auto___22460]));

var G__22461 = (i__8436__auto___22460 + (1));
i__8436__auto___22460 = G__22461;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((1) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((1)),(0),null)):null);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8443__auto__);
});

dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (elem_sel,type_fs){
if(cljs.core.even_QMARK_(cljs.core.count(type_fs))){
} else {
throw (new Error("Assert failed: (even? (count type-fs))"));
}

var vec__22446_22462 = dommy.core.elem_and_selector(elem_sel);
var elem_22463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22446_22462,(0),null);
var selector_22464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22446_22462,(1),null);
var seq__22449_22465 = cljs.core.seq(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),type_fs));
var chunk__22450_22466 = null;
var count__22451_22467 = (0);
var i__22452_22468 = (0);
while(true){
if((i__22452_22468 < count__22451_22467)){
var vec__22453_22469 = chunk__22450_22466.cljs$core$IIndexed$_nth$arity$2(null,i__22452_22468);
var type_22470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22453_22469,(0),null);
var f_22471 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22453_22469,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_22470,((function (seq__22449_22465,chunk__22450_22466,count__22451_22467,i__22452_22468,vec__22453_22469,type_22470,f_22471,vec__22446_22462,elem_22463,selector_22464){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_22470,dommy$core$this_fn], 0));

return (f_22471.cljs$core$IFn$_invoke$arity$1 ? f_22471.cljs$core$IFn$_invoke$arity$1(e) : f_22471.call(null,e));
});})(seq__22449_22465,chunk__22450_22466,count__22451_22467,i__22452_22468,vec__22453_22469,type_22470,f_22471,vec__22446_22462,elem_22463,selector_22464))
], 0));

var G__22472 = seq__22449_22465;
var G__22473 = chunk__22450_22466;
var G__22474 = count__22451_22467;
var G__22475 = (i__22452_22468 + (1));
seq__22449_22465 = G__22472;
chunk__22450_22466 = G__22473;
count__22451_22467 = G__22474;
i__22452_22468 = G__22475;
continue;
} else {
var temp__6753__auto___22476 = cljs.core.seq(seq__22449_22465);
if(temp__6753__auto___22476){
var seq__22449_22477__$1 = temp__6753__auto___22476;
if(cljs.core.chunked_seq_QMARK_(seq__22449_22477__$1)){
var c__8125__auto___22478 = cljs.core.chunk_first(seq__22449_22477__$1);
var G__22479 = cljs.core.chunk_rest(seq__22449_22477__$1);
var G__22480 = c__8125__auto___22478;
var G__22481 = cljs.core.count(c__8125__auto___22478);
var G__22482 = (0);
seq__22449_22465 = G__22479;
chunk__22450_22466 = G__22480;
count__22451_22467 = G__22481;
i__22452_22468 = G__22482;
continue;
} else {
var vec__22456_22483 = cljs.core.first(seq__22449_22477__$1);
var type_22484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22456_22483,(0),null);
var f_22485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22456_22483,(1),null);
dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_22484,((function (seq__22449_22465,chunk__22450_22466,count__22451_22467,i__22452_22468,vec__22456_22483,type_22484,f_22485,seq__22449_22477__$1,temp__6753__auto___22476,vec__22446_22462,elem_22463,selector_22464){
return (function dommy$core$this_fn(e){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(elem_sel,cljs.core.array_seq([type_22484,dommy$core$this_fn], 0));

return (f_22485.cljs$core$IFn$_invoke$arity$1 ? f_22485.cljs$core$IFn$_invoke$arity$1(e) : f_22485.call(null,e));
});})(seq__22449_22465,chunk__22450_22466,count__22451_22467,i__22452_22468,vec__22456_22483,type_22484,f_22485,seq__22449_22477__$1,temp__6753__auto___22476,vec__22446_22462,elem_22463,selector_22464))
], 0));

var G__22486 = cljs.core.next(seq__22449_22477__$1);
var G__22487 = null;
var G__22488 = (0);
var G__22489 = (0);
seq__22449_22465 = G__22486;
chunk__22450_22466 = G__22487;
count__22451_22467 = G__22488;
i__22452_22468 = G__22489;
continue;
}
} else {
}
}
break;
}

return elem_sel;
});

dommy.core.listen_once_BANG_.cljs$lang$maxFixedArity = (1);

dommy.core.listen_once_BANG_.cljs$lang$applyTo = (function (seq22444){
var G__22445 = cljs.core.first(seq22444);
var seq22444__$1 = cljs.core.next(seq22444);
return dommy.core.listen_once_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__22445,seq22444__$1);
});

