// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('im_tables.events');
goog.require('cljs.core');
goog.require('imcljs.query');
goog.require('day8.re_frame.undo');
goog.require('imcljs.fetch');
goog.require('im_tables.events.boot');
goog.require('day8.re_frame.async_flow_fx');
goog.require('im_tables.events.pagination');
goog.require('im_tables.interceptors');
goog.require('im_tables.db');
goog.require('oops.core');
goog.require('imcljs.save');
goog.require('im_tables.effects');
goog.require('clojure.string');
goog.require('re_frame.core');
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$printdb,(function (db){
console.log("DB",db);

return db;
}));
/**
 * Recursively merges maps. If keys are not maps, the last value wins.
 */
im_tables.events.deep_merge = (function im_tables$events$deep_merge(var_args){
var args__8442__auto__ = [];
var len__8435__auto___26590 = arguments.length;
var i__8436__auto___26591 = (0);
while(true){
if((i__8436__auto___26591 < len__8435__auto___26590)){
args__8442__auto__.push((arguments[i__8436__auto___26591]));

var G__26592 = (i__8436__auto___26591 + (1));
i__8436__auto___26591 = G__26592;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((0) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((0)),(0),null)):null);
return im_tables.events.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__8443__auto__);
});

im_tables.events.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (vals){
if(cljs.core.every_QMARK_(cljs.core.map_QMARK_,vals)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,im_tables.events.deep_merge,vals);
} else {
return cljs.core.last(vals);
}
});

im_tables.events.deep_merge.cljs$lang$maxFixedArity = (0);

im_tables.events.deep_merge.cljs$lang$applyTo = (function (seq26589){
return im_tables.events.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26589));
});

re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$im_DASH_tables$main_SLASH_replace_DASH_all_DASH_state,im_tables.interceptors.sandbox(),(function (_,p__26593){
var vec__26594 = p__26593;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26594,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26594,(1),null);
var state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26594,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,im_tables.events.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([im_tables.db.default_db,state], 0)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$imt$io_SLASH_save_DASH_list_DASH_success,(function (db,p__26597){
var vec__26598 = p__26597;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26598,(0),null);
var response = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26598,(1),null);
console.debug("List Saved",response);

return db;
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$imt$io_SLASH_save_DASH_list,im_tables.interceptors.sandbox(),(function (p__26601,p__26602){
var map__26603 = p__26601;
var map__26603__$1 = ((((!((map__26603 == null)))?((((map__26603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26603.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26603):map__26603);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26603__$1,cljs.core.cst$kw$db);
var vec__26604 = p__26602;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26604,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26604,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26604,(2),null);
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26604,(3),null);
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26604,(4),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_tables_SLASH_im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$imt$io_SLASH_save_DASH_list_DASH_success], null),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(imcljs.save.im_list,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$service),name,query,cljs.core.array_seq([options], 0))], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$prep_DASH_modal,im_tables.interceptors.sandbox(),(function (p__26608,p__26609){
var map__26610 = p__26608;
var map__26610__$1 = ((((!((map__26610 == null)))?((((map__26610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26610.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26610):map__26610);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26610__$1,cljs.core.cst$kw$db);
var vec__26611 = p__26609;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(1),null);
var contents = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26611,(2),null);
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$modal], null),contents)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$show_DASH_overlay,im_tables.interceptors.sandbox(),(function (db,p__26615){
var vec__26616 = p__26615;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26616,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26616,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$overlay_QMARK_], null),true);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$hide_DASH_overlay,im_tables.interceptors.sandbox(),(function (db,p__26619){
var vec__26620 = p__26619;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26620,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26620,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$overlay_QMARK_], null),false);
}));
im_tables.events.toggle_into_set = (function im_tables$events$toggle_into_set(haystack,needle){
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([needle], true),haystack))){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (n){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(n,needle);
}),haystack);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(haystack,needle);
}
});
/**
 * If a key is present in a map then remove it, otherwise add the key with a value of true.
 */
im_tables.events.flip_presence = (function im_tables$events$flip_presence(m,k){
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,true);
}
});
im_tables.events.alphabet = clojure.string.split.cljs$core$IFn$_invoke$arity$2("ABCDEFGHIJKLMNOPQRSTUVWXYZ","");
im_tables.events.haystack_has_QMARK_ = (function im_tables$events$haystack_has_QMARK_(haystack,needle){
return cljs.core.some_QMARK_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([needle], true),haystack));
});
im_tables.events.first_letter = (function im_tables$events$first_letter(letters){
return cljs.core.first(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(im_tables.events.haystack_has_QMARK_,letters),im_tables.events.alphabet));
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_set_DASH_temp_DASH_query,im_tables.interceptors.sandbox(),(function (db,p__26623){
var vec__26624 = p__26623;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26624,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26624,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$temp_DASH_query,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$query));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$filters_SLASH_update_DASH_constraint,im_tables.interceptors.sandbox(),(function (db,p__26627){
var vec__26628 = p__26627;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26628,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26628,(1),null);
var new_constraint = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26628,(2),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$temp_DASH_query,cljs.core.cst$kw$where], null),((function (vec__26628,_,loc,new_constraint){
return (function (constraints){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__26628,_,loc,new_constraint){
return (function (constraint){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(new_constraint),cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(constraint))){
return new_constraint;
} else {
return constraint;
}
});})(vec__26628,_,loc,new_constraint))
,constraints);
});})(vec__26628,_,loc,new_constraint))
);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$filters_SLASH_add_DASH_constraint,im_tables.interceptors.sandbox(),(function (p__26631,p__26632){
var map__26633 = p__26631;
var map__26633__$1 = ((((!((map__26633 == null)))?((((map__26633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26633.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26633):map__26633);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26633__$1,cljs.core.cst$kw$db);
var vec__26634 = p__26632;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26634,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26634,(1),null);
var new_constraint = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26634,(2),null);
console.log("ADDING CONSTRAINT",new_constraint);

return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_save_DASH_changes,loc], null),cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$temp_DASH_query,cljs.core.cst$kw$where], null),((function (map__26633,map__26633__$1,db,vec__26634,_,loc,new_constraint){
return (function (constraints){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(constraints,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_constraint,cljs.core.cst$kw$code,im_tables.events.first_letter(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$code,constraints))));
});})(map__26633,map__26633__$1,db,vec__26634,_,loc,new_constraint))
)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$filters_SLASH_remove_DASH_constraint,im_tables.interceptors.sandbox(),(function (p__26638,p__26639){
var map__26640 = p__26638;
var map__26640__$1 = ((((!((map__26640 == null)))?((((map__26640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26640.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26640):map__26640);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26640__$1,cljs.core.cst$kw$db);
var vec__26641 = p__26639;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26641,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26641,(1),null);
var new_constraint = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26641,(2),null);
console.log("removing constraint",loc,new_constraint);

return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$filters_SLASH_save_DASH_changes,loc], null),cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$temp_DASH_query,cljs.core.cst$kw$where], null),((function (map__26640,map__26640__$1,db,vec__26641,_,loc,new_constraint){
return (function (constraints){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__26640,map__26640__$1,db,vec__26641,_,loc,new_constraint){
return (function (constraint){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(constraint,new_constraint)){
return null;
} else {
return constraint;
}
});})(map__26640,map__26640__$1,db,vec__26641,_,loc,new_constraint))
,constraints));
});})(map__26640,map__26640__$1,db,vec__26641,_,loc,new_constraint))
)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$filters_SLASH_save_DASH_changes,im_tables.interceptors.sandbox(),(function (p__26645,p__26646){
var map__26647 = p__26645;
var map__26647__$1 = ((((!((map__26647 == null)))?((((map__26647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26647.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26647):map__26647);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26647__$1,cljs.core.cst$kw$db);
var vec__26648 = p__26646;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26648,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26648,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$query,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$temp_DASH_query)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$select_SLASH_toggle_DASH_selection,im_tables.interceptors.sandbox(),(function (db,p__26652){
var vec__26653 = p__26652;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26653,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26653,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26653,(2),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26653,(3),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$selections], null),im_tables.events.flip_presence,value);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$select_SLASH_clear_DASH_selection,im_tables.interceptors.sandbox(),(function (db,p__26656){
var vec__26657 = p__26656;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26657,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26657,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26657,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$selections], null),cljs.core.PersistentArrayMap.EMPTY);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$select_SLASH_select_DASH_all,im_tables.interceptors.sandbox(),(function (db,p__26660){
var vec__26661 = p__26660;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26661,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26661,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26661,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$selections], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__26661,_,loc,view){
return (function (p__26664){
var map__26665 = p__26664;
var map__26665__$1 = ((((!((map__26665 == null)))?((((map__26665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26665.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26665):map__26665);
var item = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26665__$1,cljs.core.cst$kw$item);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,true], null);
});})(vec__26661,_,loc,view))
,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$response,cljs.core.cst$kw$results], null)))));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$select_SLASH_set_DASH_text_DASH_filter,im_tables.interceptors.sandbox(),(function (db,p__26667){
var vec__26668 = p__26667;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26668,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26668,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26668,(2),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26668,(3),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$filters,cljs.core.cst$kw$text], null),((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,""))?null:value));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$tree_DASH_view_SLASH_toggle_DASH_selection,im_tables.interceptors.sandbox(),(function (db,p__26671){
var vec__26672 = p__26671;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26672,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26672,(1),null);
var path_vec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26672,(2),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$tree_DASH_view,cljs.core.cst$kw$selection], null),im_tables.events.toggle_into_set,path_vec);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$tree_DASH_view_SLASH_merge_DASH_new_DASH_columns,im_tables.interceptors.sandbox(),(function (p__26676,p__26677){
var map__26678 = p__26676;
var map__26678__$1 = ((((!((map__26678 == null)))?((((map__26678.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26678.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26678):map__26678);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26678__$1,cljs.core.cst$kw$db);
var vec__26679 = p__26677;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26679,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26679,(1),null);
var columns_to_add = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clojure.string.join,"."),cljs.core.rest),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$tree_DASH_view,cljs.core.cst$kw$selection], null)));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$select], null),((function (columns_to_add,map__26678,map__26678__$1,db,vec__26679,_,loc){
return (function (p1__26675_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,p1__26675_SHARP_,columns_to_add);
});})(columns_to_add,map__26678,map__26678__$1,db,vec__26679,_,loc))
),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$tree_DASH_view,cljs.core.cst$kw$selection], null),cljs.core.PersistentHashSet.EMPTY),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
}));
im_tables.events.swap = (function im_tables$events$swap(v,i1,i2){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(v,i2,(v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(i1) : v.call(null,i1)),cljs.core.array_seq([i1,(v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(i2) : v.call(null,i2))], 0));
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$style_SLASH_dragging_DASH_item,im_tables.interceptors.sandbox(),(function (db,p__26683){
var vec__26684 = p__26683;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26684,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26684,(1),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26684,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$dragging_DASH_item], null),idx);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$style_SLASH_dragging_DASH_over,im_tables.interceptors.sandbox(),(function (db,p__26687){
var vec__26688 = p__26687;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26688,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26688,(1),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26688,(2),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$dragging_DASH_over], null),idx);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$style_SLASH_dragging_DASH_finished,im_tables.interceptors.sandbox(),(function (p__26691,p__26692){
var map__26693 = p__26691;
var map__26693__$1 = ((((!((map__26693 == null)))?((((map__26693.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26693.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26693):map__26693);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26693__$1,cljs.core.cst$kw$db);
var vec__26694 = p__26692;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26694,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26694,(1),null);
var dragged_item = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$dragging_DASH_item], null));
var dragged_over = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$dragging_DASH_over], null));
var G__26698 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$select], null),im_tables.events.swap,dragged_item,dragged_over),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache], null),cljs.core.dissoc,cljs.core.cst$kw$dragging_DASH_item,cljs.core.cst$kw$dragging_DASH_over)], null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(dragged_item,dragged_over)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__26698,cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$show_DASH_overlay,loc], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$flush_DASH_dom,true], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null));
} else {
return G__26698;
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_save_DASH_column_DASH_summary,im_tables.interceptors.sandbox(),(function (db,p__26699){
var vec__26700 = p__26699;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26700,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26700,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26700,(2),null);
var summary_response = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26700,(3),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$response], null),summary_response);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_summarize_DASH_column,im_tables.interceptors.sandbox(),(function (p__26703,p__26704){
var map__26705 = p__26703;
var map__26705__$1 = ((((!((map__26705 == null)))?((((map__26705.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26705.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26705):map__26705);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26705__$1,cljs.core.cst$kw$db);
var vec__26706 = p__26704;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26706,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26706,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26706,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_tables_SLASH_im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_save_DASH_column_DASH_summary,loc,view], null),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$4(imcljs.fetch.rows,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$service),cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$query),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$summaryPath,view,cljs.core.cst$kw$format,"jsonrows"], null))], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_apply_DASH_summary_DASH_filter,im_tables.interceptors.sandbox(),(function (p__26710,p__26711){
var map__26712 = p__26710;
var map__26712__$1 = ((((!((map__26712 == null)))?((((map__26712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26712.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26712):map__26712);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26712__$1,cljs.core.cst$kw$db);
var vec__26713 = p__26711;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26713,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26713,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26713,(2),null);
var temp__6751__auto__ = cljs.core.keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary,view,cljs.core.cst$kw$selections], null)));
if(cljs.core.truth_(temp__6751__auto__)){
var current_selection = temp__6751__auto__;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$where], null),cljs.core.conj,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,view,cljs.core.cst$kw$op,"ONE OF",cljs.core.cst$kw$values,current_selection], null)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,db], null);
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_remove_DASH_view,im_tables.interceptors.sandbox(),(function (p__26717,p__26718){
var map__26719 = p__26717;
var map__26719__$1 = ((((!((map__26719 == null)))?((((map__26719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26719.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26719):map__26719);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26719__$1,cljs.core.cst$kw$db);
var vec__26720 = p__26718;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26720,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26720,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26720,(2),null);
var view__$1 = view;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$select], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.remove,((function (view__$1,map__26719,map__26719__$1,db,vec__26720,_,loc,view){
return (function (v){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,view__$1);
});})(view__$1,map__26719,map__26719__$1,db,vec__26720,_,loc,view))
)),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_sort_DASH_by,im_tables.interceptors.sandbox(),(function (p__26724,p__26725){
var map__26726 = p__26724;
var map__26726__$1 = ((((!((map__26726 == null)))?((((map__26726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26726.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26726):map__26726);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26726__$1,cljs.core.cst$kw$db);
var vec__26727 = p__26725;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26727,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26727,(1),null);
var view = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26727,(2),null);
var view__$1 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),clojure.string.split.cljs$core$IFn$_invoke$arity$2(view,".")));
var vec__26731 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$orderBy], null));
var current_sort_by = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26731,(0),null);
var update_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(view__$1,cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(current_sort_by));
var current_direction = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$orderBy,(0),cljs.core.cst$kw$direction], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,((update_QMARK_)?cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$orderBy,(0)], null),cljs.core.assoc,cljs.core.cst$kw$direction,(function (){var G__26734 = current_direction;
switch (G__26734) {
case "ASC":
return "DESC";

break;
case "DESC":
return "ASC";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(current_direction)].join('')));

}
})()):cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query,cljs.core.cst$kw$orderBy], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$path,view__$1,cljs.core.cst$kw$direction,"ASC"], null)], null))),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,loc], null)], null);
}));
im_tables.events.summary_query = (function im_tables$events$summary_query(p__26736){
var map__26739 = p__26736;
var map__26739__$1 = ((((!((map__26739 == null)))?((((map__26739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26739.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26739):map__26739);
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26739__$1,cljs.core.cst$kw$class);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26739__$1,cljs.core.cst$kw$id);
var summary_fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26739__$1,cljs.core.cst$kw$summary_DASH_fields);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$from,class$,cljs.core.cst$kw$select,summary_fields,cljs.core.cst$kw$where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,[cljs.core.str(class$),cljs.core.str(".id")].join(''),cljs.core.cst$kw$op,"=",cljs.core.cst$kw$value,id], null)], null)], null);
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_cache_DASH_item_DASH_summary,im_tables.interceptors.sandbox(),(function (db,p__26741){
var vec__26742 = p__26741;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26742,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26742,(1),null);
var response = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26742,(2),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$item_DASH_details], null),((function (vec__26742,_,loc,response){
return (function (summary_map){
var map__26745 = cljs.core.first(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(response));
var map__26745__$1 = ((((!((map__26745 == null)))?((((map__26745.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26745.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26745):map__26745);
var r = map__26745__$1;
var objectId = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26745__$1,cljs.core.cst$kw$objectId);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(summary_map,objectId,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$value,r,cljs.core.cst$kw$views,cljs.core.cst$kw$views.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$column_DASH_headers,cljs.core.cst$kw$columnHeaders.cljs$core$IFn$_invoke$arity$1(response)], null));
});})(vec__26742,_,loc,response))
);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_summarize_DASH_item,im_tables.interceptors.sandbox(),(function (p__26747,p__26748){
var map__26749 = p__26747;
var map__26749__$1 = ((((!((map__26749 == null)))?((((map__26749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26749.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26749):map__26749);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26749__$1,cljs.core.cst$kw$db);
var vec__26750 = p__26748;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26750,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26750,(1),null);
var map__26753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26750,(2),null);
var map__26753__$1 = ((((!((map__26753 == null)))?((((map__26753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26753.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26753):map__26753);
var item = map__26753__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26753__$1,cljs.core.cst$kw$class);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26753__$1,cljs.core.cst$kw$id);
var G__26756 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,db], null);
if(cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$item_DASH_details,id], null)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__26756,cljs.core.cst$kw$im_DASH_tables_SLASH_im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_cache_DASH_item_DASH_summary,loc], null),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(imcljs.fetch.records,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$service),im_tables.events.summary_query(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(item,cljs.core.cst$kw$summary_DASH_fields,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$service,cljs.core.cst$kw$model,cljs.core.cst$kw$classes,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.cst$kw$attributes], null)))))))], null));
} else {
return G__26756;
}
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_replace_DASH_query_DASH_response,im_tables.interceptors.sandbox(),(function (p__26757,p__26758){
var map__26759 = p__26757;
var map__26759__$1 = ((((!((map__26759 == null)))?((((map__26759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26759.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26759):map__26759);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26759__$1,cljs.core.cst$kw$db);
var vec__26760 = p__26758;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26760,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26760,(1),null);
var map__26763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26760,(2),null);
var map__26763__$1 = ((((!((map__26763 == null)))?((((map__26763.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26763.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26763):map__26763);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26763__$1,cljs.core.cst$kw$start);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26763__$1,cljs.core.cst$kw$size);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26760,(3),null);
var new_results_map = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (map__26759,map__26759__$1,db,vec__26760,_,loc,map__26763,map__26763__$1,start,size,results){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(idx + start),item], null);
});})(map__26759,map__26759__$1,db,vec__26760,_,loc,map__26763,map__26763__$1,start,size,results))
,cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(results)));
var updated_results = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,cljs.core.cst$kw$results,new_results_map);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$query_DASH_response,updated_results),cljs.core.cst$kw$dispatch_DASH_n,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$hide_DASH_overlay,loc], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$flush_DASH_dom,true], null))], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (new_results_map,updated_results,map__26759,map__26759__$1,db,vec__26760,_,loc,map__26763,map__26763__$1,start,size,results){
return (function (view){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_summarize_DASH_column,loc,view], null);
});})(new_results_map,updated_results,map__26759,map__26759__$1,db,vec__26760,_,loc,map__26763,map__26763__$1,start,size,results))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(results,cljs.core.cst$kw$views)))], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_merge_DASH_query_DASH_response,im_tables.interceptors.sandbox(),(function (p__26766,p__26767){
var map__26768 = p__26766;
var map__26768__$1 = ((((!((map__26768 == null)))?((((map__26768.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26768.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26768):map__26768);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26768__$1,cljs.core.cst$kw$db);
var vec__26769 = p__26767;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26769,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26769,(1),null);
var map__26772 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26769,(2),null);
var map__26772__$1 = ((((!((map__26772 == null)))?((((map__26772.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26772.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26772):map__26772);
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26772__$1,cljs.core.cst$kw$start);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26772__$1,cljs.core.cst$kw$size);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26769,(3),null);
var new_results_map = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (map__26768,map__26768__$1,db,vec__26769,_,loc,map__26772,map__26772__$1,start,size,results){
return (function (idx,item){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(idx + start),item], null);
});})(map__26768,map__26768__$1,db,vec__26769,_,loc,map__26772,map__26772__$1,start,size,results))
,cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(results)));
var updated_results = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,cljs.core.cst$kw$results,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_response,cljs.core.cst$kw$results], null)),new_results_map], 0)));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$query_DASH_response,updated_results),cljs.core.cst$kw$dispatch_DASH_n,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$hide_DASH_overlay,loc], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$flush_DASH_dom,true], null))], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (new_results_map,updated_results,map__26768,map__26768__$1,db,vec__26769,_,loc,map__26772,map__26772__$1,start,size,results){
return (function (view){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_summarize_DASH_column,loc,view], null);
});})(new_results_map,updated_results,map__26768,map__26768__$1,db,vec__26769,_,loc,map__26772,map__26772__$1,start,size,results))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(results,cljs.core.cst$kw$views)))], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$im_DASH_tables$main_SLASH_run_DASH_query,im_tables.interceptors.sandbox(),(function (p__26775,p__26776){
var map__26777 = p__26775;
var map__26777__$1 = ((((!((map__26777 == null)))?((((map__26777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26777):map__26777);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26777__$1,cljs.core.cst$kw$db);
var vec__26778 = p__26776;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26778,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26778,(1),null);
var merge_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26778,(2),null);
console.debug("Running query",cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$query));

var map__26782 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$settings,cljs.core.cst$kw$pagination], null));
var map__26782__$1 = ((((!((map__26782 == null)))?((((map__26782.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26782.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26782):map__26782);
var pagination = map__26782__$1;
var start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26782__$1,cljs.core.cst$kw$start);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26782__$1,cljs.core.cst$kw$limit);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cache,cljs.core.cst$kw$column_DASH_summary], null),cljs.core.PersistentArrayMap.EMPTY),cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$show_DASH_overlay,loc], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$flush_DASH_dom,true], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_deconstruct,loc], null)], null),cljs.core.cst$kw$im_DASH_tables_SLASH_im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,(cljs.core.truth_(merge_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_merge_DASH_query_DASH_response,loc,pagination], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_replace_DASH_query_DASH_response,loc,pagination], null)),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$4(imcljs.fetch.table_rows,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$service),cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$query),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$start,start,cljs.core.cst$kw$size,(limit * cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$settings,cljs.core.cst$kw$buffer], null)))], null))], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_save_DASH_decon_DASH_count,im_tables.interceptors.sandbox(),(function (db,p__26784){
var vec__26785 = p__26784;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26785,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26785,(1),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26785,(2),null);
var count = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26785,(3),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_parts,path,cljs.core.cst$kw$count], null),count);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_count_DASH_deconstruction,im_tables.interceptors.sandbox(),(function (p__26788,p__26789){
var map__26790 = p__26788;
var map__26790__$1 = ((((!((map__26790 == null)))?((((map__26790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26790.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26790):map__26790);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26790__$1,cljs.core.cst$kw$db);
var vec__26791 = p__26789;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26791,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26791,(1),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26791,(2),null);
var details = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26791,(3),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$im_DASH_tables_SLASH_im_DASH_operation,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_success,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_save_DASH_decon_DASH_count,loc,path], null),cljs.core.cst$kw$op,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(imcljs.fetch.row_count,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$service),cljs.core.get.cljs$core$IFn$_invoke$arity$2(details,cljs.core.cst$kw$query))], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$main_SLASH_deconstruct,im_tables.interceptors.sandbox(),(function (p__26795,p__26796){
var map__26797 = p__26795;
var map__26797__$1 = ((((!((map__26797 == null)))?((((map__26797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26797):map__26797);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26797__$1,cljs.core.cst$kw$db);
var vec__26798 = p__26796;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26798,(0),null);
var loc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26798,(1),null);
var deconstructed_query = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (map__26797,map__26797__$1,db,vec__26798,_,loc){
return (function (p__26802){
var vec__26803 = p__26802;
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26803,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26803,(1),null);
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p,"."));
});})(map__26797,map__26797__$1,db,vec__26798,_,loc))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.vals(imcljs.query.deconstruct_by_class(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$service,cljs.core.cst$kw$model], null)),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query], null))))))))));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$query_DASH_parts,deconstructed_query),cljs.core.cst$kw$dispatch_DASH_n,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (deconstructed_query,map__26797,map__26797__$1,db,vec__26798,_,loc){
return (function (p__26806){
var vec__26807 = p__26806;
var part = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26807,(0),null);
var details = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26807,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$main_SLASH_count_DASH_deconstruction,loc,part,details], null);
});})(deconstructed_query,map__26797,map__26797__$1,db,vec__26798,_,loc))
,deconstructed_query))], null);
}));
